// noinspection JSPotentiallyInvalidUsageOfThis
// ⬐ ↴ ⤵ ↕

// @TODO clasificame: Poner cuantos hay en cada cajita

/**
 *
 * Permite mostrar items (id, label, clasificación) en su columna de clasificación, cambiarlos de columna y obtener
 * en que columna quedaron con $("#id").clasificame("value")
 *
 * $("#id").claseificame({
 *             'clasificacion': [
 *             {clasificaId:'Nada', label:'X', title:'Sin Permiso', userSortable:false,},
 *             {clasificaId:'RO', label:'RO', title:'Sólo Lectura', userSortable:true,},
 *             {clasificaId:'RW', label:'RW', title:'Editar', userSortable:function(a,b){return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1},}
 *         ],
 *         liButtons:true, // botones en cada li para brincar de una a otra sin drag
 *         valueId:'user_id', // ie iac_user_id
 *         valueDisplay:'nick', // ie nick
 *         valueColumnKey:'permiso', // puede_editar has values: Nada, RO o RW
 *         'values': [],
 *              // [  {user_id:1, name:'Mary',permiso:'Nada',},],
 *              // o  {1:{name:'Mary',permiso:'RO',},],
 *              // o  {uniqueValue:{user_id:1,name:'Mary',permiso:'Nada',},],
 *              // o {11:"Mary", 12:"Joe",}
 * }); // ver options
 * $("#id").clasificame("value"); => {Nada:[id1, id2,], RO:[], ...}
 *
 * ver ejemplo_clasificame.html en esta carpeta
 *
 * public: method:function
 * privates: _method:function
 */
$.widget( "vitex.clasificame_by_color", {
    version:function() {return "2.0.2 2023-05-13 14:00";},
    Iam:this, 
    options: {
        clasificacion: [
            {clasificaId:'Nada', label:'X', title:'Sin Permiso', userSortable:false,},
            {clasificaId:'RO', label:'RO', title:'Sólo Lectura', userSortable:false,},
            {clasificaId:'RW', label:'RW', title:'Editar', userSortable:false,}
        ],
        valueId:'user_id', // ie iac_user_id
        valueDisplay:'nick', // ie nick
        valueColumnKey:'permiso', // puede_editar has values: Nada, RO o RW
        nada:'No',
        liButtons:true,
        title:null,
        label_sort:'registros',
        permiso_prohibido: $vitex_globales.puede_prohibir_colores,
        values: [],
        producto_id:"",
        // [  {user_id:1, name:'Mary',permiso:'Nada',},],
        // o  {1:{name:'Mary',permiso:'RO',},],
        // o  {uniqueValue:{user_id:1,name:'Mary',permiso:'Nada',},],
        // o {11:"Mary", 12:"Joe",}
        editable:true,
        sortable: {
            connectWith: ".clasificaItemList",
            helper: "clone",
            placeholder: "plaz",
            forcePlaceholderSize:true,
            containment: "document",
            dropOnEmpty: true,
            scroll:true,
            over: function( event, ui ) {


                if(ui.helper !== null)
                    ui.helper.css({cursor:'grabbing'});
            },
            out: function( event, ui ) {
                if(ui.helper !== null)
                    ui.helper.css({cursor:'no-drop'});

            },
            stop: function(event, ui) {

                let $element =$(event.target);
                let sortType = $element.data('clasificame')['userSortable'];
                if(sortType === true)
                    return;
                if(typeof sortType !== 'function')
                    sortType = function(a, b) {
                        return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
                    };
                $("li", $element).sort(sortType).appendTo($element);
                


            },

        }
    },
    _selector: ".clasificaItemList",

    _create: function() {
        me= this;
        this.valueId = this.options.valueId;
        this.valueDisplay = this.options.valueDisplay;
        this.valueColumnKey = this.options.valueColumnKey;


        // create html
        this.element.html(this._html());
        for(const ba in this.options.clasificacion)
            if(this.options.clasificacion.hasOwnProperty(ba)) {
                $(`UL[data-clasificame='${ba}']`).data('clasificame', this.options.clasificacion[ba])
            }
        $(".clasificaAllTo", this.element).on('click', (e) =>me._allTo(e));
        $(".clasificaFind", this.element).on('keyup',(e) =>this._find(e));
        $(".clasificaFindClear", this.element).on('click',(e) =>this._findClear(e));

        if(typeof this.options.values !== 'undefined')
            this._addValuesDo(this.options.values);

        let _selector = this._selector;
        let optionsSortable = this.options.sortable;
        let limitTo = this.element.attr('id');
        // activate html
        $(this._selector, this.element).each(function(){
            const $this  = $(this);
            $this.sortable(
                $.extend(
                    {},optionsSortable,
                {
                    connectWith: ".clasificaItemList",
                    helper: "clone",
                    placeholder: "plaz",
                    forcePlaceholderSize:true,
                    containment: "document",
                    dropOnEmpty: true,
                    scroll:true,
                    cancel:'.con_existe',
                    objects:me,
                    over: function(event, ui ) {

                        const spanText = $(ui.item).find('.clasificameLabel').text();
                        const palabraFind = 'Con ∃';
                        if(spanText.includes(palabraFind)){
                        }

                        if(ui.helper !== null)
                            ui.helper.css({cursor:'grabbing'});
                            
                    },
                    out: function( event, ui ) {

                        let permiso= $vitex_globales.puede_prohibir_colores;
                        if(ui.item.parent().data("clasificakey")==='Prohibido' && !permiso) {
                            event.preventDefault()
                            return ;
                        };
                        if(ui.helper !== null)
                            ui.helper.css({cursor:'no-drop'});
                            let item_actual=ui.item;
                            let id_key_data=$(this).attr('data-clasificakey');

                            item_actual.find('.noDrag span').removeClass('pressed');
                            item_actual.find('.noDrag').find(`[data-clasificato="${id_key_data}"]`).addClass('pressed');

                    },
                    stop: function(event, ui) {


                        let permiso= $vitex_globales.puede_prohibir_colores;
                        if(ui.item.parent().data("clasificakey")==='Prohibido' && !permiso) {
                            event.preventDefault()
                            return ;
                        };
                        let $element =$(event.target);
                        let sortType = $element.data('clasificame')['userSortable'];
                        if(sortType === true)
                            return;
                        if(typeof sortType !== 'function')
                            sortType = function(a, b) {
                                return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
                            };
                       $("li", $element).sort(sortType).appendTo($element);
                    },
                    receive: function(event, ui ) {

                        let permiso= $vitex_globales.puede_prohibir_colores;
                        if(ui.item.parent().data("clasificakey")==='Prohibido' && !permiso) {
                            console.log(ui.item.find('span.pressed'));
                            event.preventDefault()
                            
                            return ;
                        };
                        const registros=$('.numero_registros');
                         let nombre_label_registro= registros.data('label-registro');
                         let set_name_label= nombre_label_registro.replace('_',' ');
                         registros.remove();
                         const $list= $('.clasificaFlexItem ul',this.element);
                             $list.each(function () {
                                 const numero_hijos=$(this).find('li').filter(':visible').length ;
                                const div_conteo=$(`<div class="numero_registros more_info" title="Ver resumen de las listas" style="cursor:pointer;" data-label-registro="${nombre_label_registro}"><p><i class="fa-solid fa-circle-plus" style="margin-right: 5px; cursor:pointer;"></i>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
                                div_conteo.insertAfter($(this));
                             })

                         /// clasificando información
                        let div_acordeon=$('.div_acordeon');

                        div_acordeon.empty();

                        let labelMostrando= me.options.label_sort;
                        let data_mostrando= labelMostrando.replace(' ','_');
                        div_acordeon.each(function () {
                            let span_Info=$(this).parent().find('li').find('span').filter(':visible');
                            let span_Info_China=$(this).parent().find('.bg-warning-updt').filter(':visible').length;
                            let contador_conE = 0;
                            let contador_sinE = 0;
                            let contador_Huerfano = 0;
                            //inicia each
                            span_Info.each(function () {
                                const txt_span=$(this).text();

                                $('.info_modal', $(this)).remove();

                                if(txt_span.includes('(Con ∃)'))contador_conE++;
                                if ($(this).parents('span').length) {
                                    if(txt_span.includes('(Sin ∃)'))contador_sinE++;
                                    if(txt_span.includes('(H)'))contador_Huerfano++;
                                }
                            });

                            let div_china=$(`<div class="info_modal"><p style="font-size: 0.7rem;font-weight: bold;">Pedidos en China</p><p>${span_Info_China} ${data_mostrando}</p></div>`)
                            let div_conexistencia=$(`<div class="info_modal"><p style="font-size: 0.7rem;font-weight: bold;">${set_name_label} con existencia</p><p>${contador_conE} ${data_mostrando}</p></div>`)
                            let div_sinexistencia=$(`<div class="info_modal"><p style="font-size: 0.7rem;font-weight: bold;">${set_name_label} sin existencia</p><p>${contador_sinE} ${data_mostrando}</p></div>`)
                            let div_huerfanos=$(`<div class="info_modal"><p style="font-size: 0.7rem;font-weight: bold;">${set_name_label} huerfanos</p><p>${contador_Huerfano} ${data_mostrando}</p></div>`)

                            $(this).append(div_china);
                            $(this).append(div_conexistencia);
                            $(this).append(div_sinexistencia);
                            $(this).append(div_huerfanos);
                        });

                        //evento para mostrar info
                        let mostrarResumen= $('.more_info', this.element);
                        mostrarResumen.on('click',e=>{
                            let div_acordeon= $('.div_acordeon');
                            let div_list= $('.clasificaFlexItem ul');

                            let propiedades;
                            let propiedades_ul;
                                if(div_acordeon.css('opacity')==='0'){
                                    propiedades = {
                                        height: '85px',
                                        opacity: 0.8
                                    };
                                    propiedades_ul={height: '33vh'};
                                    
                                }else{
                                    propiedades = {
                                        height: '0px',
                                        opacity: 0
                                    };
                                    propiedades_ul={height: '45vh'};
                                };
                                // Define la duración de la animación en milisegundos
                                let duracion = 1000;
                                    
                                // Inicia la animación
                                div_acordeon.animate(propiedades, duracion);
                                div_list.animate(propiedades_ul, duracion);
                        });

                    }

                }
                )

            ).disableSelection();
        });
        if(!this.options.editable)
            this.readonly();
    },

    _destroy: function() {
        this.element.html("");
    },

    /**
     * Get or Set an option.
     *
     * @param {string} name
     * @param {string|undefined} value
     * @returns {vitex.clasificame|{valueColumnKey: string, valueDisplay: string, liButtons: boolean, valueId: string, nada: string, editable: boolean,label_sort: string, values: [], clasificacion: [{label: string, title: string, clasificaId: string, userSortable: boolean},{label: string, title: string, clasificaId: string, userSortable: boolean},{label: string, title: string, clasificaId: string, userSortable: boolean}], sortable: {containment: string, receive: function(*, *): void, connectWith: string, helper: string, dropOnEmpty: boolean, scroll: boolean}, title: null}|*|null}
     */
    option:function(name, value) {
        if(typeof value === "undefined") {
            if(name === 'options' || name === 'option')
                return this.options;
            if(this.options.hasOwnProperty(name))
                return this.options[name];
            return null;
        }
        let ro = {valueId:true,valueDisplay:true, valueColumnKey:true,values:true};
        if(ro.hasOwnProperty(name))
            throw 'Attempt to change Read Only Option: ' + name;
        this.options[name] = value;
        if(name === 'editable')
            if(value) {
                let $elem = $(this.element);
                $elem.find(".clasificaToolBar").each(function(){$(this).show();});
                $elem.find(".clasificaAllTo").each(function(){$(this).show();});
                $elem.find(".clasificaItemDontMove").removeClass("clasificaItemDontMove").
                    addClass("clasificaItemMove");
                this.refresh();
            }
            else
                this.readonly();
        return this;
    },

    addValues:function(values) {

        this._addValuesDo(values);
        this.refresh();
    },

    /**
     * convert to readonly
     */
    readonly:function() {
        this.options.editable = false;
        $(this._selector, this.element).each(function(){
            $(this).sortable("option", "disabled", true).sortable("destroy");
        });
        let $elem = $(this.element);
        $elem.find(".clasificaToolBar").each(function(){$(this).hide();});
        $elem.find(".clasificaAllTo").each(function(){$(this).css('visibility','hidden');});
        $elem.find(".clasificaItemMove").removeClass("clasificaItemMove").addClass("clasificaItemDontMove");
    },

    refresh:function() {
        if(!this.options.editable)
            return;
        var me = this;
        $(this._selector, this.element).each(function(){
            const $this  = $(this);
        });
    },


    allTo: function(toClasificaId) {
        if(!this.options.editable) {
            console.log("Error Clasificame: Can't do: editable = false");
            return;
        }
        if(typeof toClasificaId === 'undefined') {
            console.log("Error Clasificame: this.allTo()", "Missing parameter toClasificaId");
            return;
        }

        let $to =  $(`.clasificaItemList[data-clasificakey='${toClasificaId}']`, this.element);
        if($to.length === 0) {
            console.log("Error Clasificame: this.allTo()", "Invalid clasificaId ", toClasificaId);
            return;
        }

        let me = this;
        $(this._selector, this.element).each(function() {
            let $this = $(this);
            if($this.data('clasificakey') !== toClasificaId) {
                $this.find("LI").each(function (){
                    let $li = $(this);
                    if ($li.hasClass('con_existe')) return;
                   
                    me._toolbarUnpress($li);
                    $li.find(`SPAN[data-clasificato='${toClasificaId}']`).addClass('pressed');
                    
                    if($li.is(":visible")) {
                        $to.append($li);
                        $li.hide().toggle("up");
                    }
                });
            }
        });


        this._sortMe($to);
    },

    fromTo: function(fromClasificaId, toClasificaId) {
        if(!this.options.editable) {
            console.log("Error Clasificame: Can't do: editable = false");
            return;
        }
        if(typeof fromClasificaId === 'undefined' || typeof toClasificaId === 'undefined') {
            console.log("Error Clasificame: this.fromTo(fromClasificaId, toClasificaId)", "Need 2 parameters fromClasificaId, toClasificaId");
            return;
        }
        let $from =  $(`.clasificaItemList[data-clasificakey='${fromClasificaId}']`, this.element);
        if($from.length === 0) {
            console.log("Error Clasificame: this.fromTo(fromClasificaId, toClasificaId)", "Invalid fromClasificaId: ", fromClasificaId);
            return;
        }
        let $to =  $(`.clasificaItemList[data-clasificakey='${toClasificaId}']`, this.element);
        if($to.length === 0) {
            console.log("Error Clasificame: this.fromTo(fromClasificaId, toClasificaId)", "Invalid toClasificaId ", toClasificaId);
            return;
        }

        let me = this;
        $from.find("LI").each(function(){
            let $this = $(this);
            if($this.hasClass('con_existe')) return;
            me._toolbarUnpress($this);
            $this.find(`SPAN[data-clasificato='${toClasificaId}']`).addClass('pressed');
                $to.append($(this));
        });

    },

    value:function() {
        let ret = {};
        $(this._selector, this.element).each(function() {
            let $this = $(this);
            let clasif = $this.data("clasificakey");
            ret[clasif] = [];
            $this.find("LI").each(function (){
                let id = $(this).data("clasificaid");
                if(typeof id !== 'undefined')
                    ret[clasif].push(id);
            });
        });
        return ret;
    },

    clear:function() {
        $(this._selector, this.element).each(function() {
            let $this = $(this);
            $this.find("LI").each(function (){ $(this).remove(); });
        });
    },

    _allTo: function(event) {
        let elementId = $(event.target).data('clasificaelementid');
        $(`#${elementId}`).clasificame_by_color("allTo", $(event.target).data('clasificakey'));
        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);;
            $list.each(function () {
                const numero_hijos=$(this).find('li').filter(':visible').length ;
               const div_conteo=$(`<div class="numero_registros more_info" title="Ver resumen de las listas" style="cursor:pointer;" data-label-registro="${nombre_label_registro}"><p><i class="fa-solid fa-circle-plus" style="margin-right: 5px; cursor:pointer;"></i>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            });
            this._inforesumen();
            let mostrarResumen= $('.more_info', this.element);
            mostrarResumen.on('click',e=>{me._mostrandoResumen(e)});
        
    },
    _allToPrev: function(event, me=this) {
        let btnPrev= $('.previous', me.element);
        btnPrev.on('click',function (e) {
            let element_actual=$(e.target).parent().parent().find('.clasificaItemList').data('self');
            let prev_element=element_actual-1===-1 ? btnPrev.length-1 : element_actual-1;
            let lista_anterior=$(`.clasificaItemList[data-self='${prev_element}']`).data('clasificakey');
            //console.log(lista_anterior);
            let lista= $(e.target).parent().parent().find('.clasificaItemList').find('li').not('.con_existe').filter(':visible');
            lista.each(function () {
                let id = $(this).data("clasificaid");
                if (lista_anterior==='Prohibido' && !$vitex_globales.puede_prohibir_colores) return;
                event.moveTo(id,lista_anterior);

               event._setConteo();
            });

        })
    },
    _allToNext: function(event, me=this) {
        let btnPrev= $('.next', me.element);
        btnPrev.on('click',function (e) {
            let element_actual=$(e.target).parent().parent().find('.clasificaItemList').data('self');
            let next_element=element_actual+1>btnPrev.length-1 ? 0 : element_actual+1;

            let lista_siguiente=$(`.clasificaItemList[data-self='${next_element}']`).data('clasificakey');
            //console.log(lista_siguiente);
            let lista= $(e.target).parent().parent().find('.clasificaItemList').find('li').not('.con_existe').filter(':visible');
            lista.each(function () {
                let id = $(this).data("clasificaid");
                if (lista_siguiente==='Prohibido' && !$vitex_globales.puede_prohibir_colores) return;
                event.moveTo(id,lista_siguiente);
               event._setConteo();
               
            });

        })
    },
    _setConteo:function () {
        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
            $list.each(function () {
                const numero_hijos=$(this).find('li').filter(':visible').length ;
               const div_conteo=$(`<div class="numero_registros more_info" title="Ver resumen de las listas" style="cursor:pointer;" data-label-registro="${nombre_label_registro}"><p><i class="fa-solid fa-circle-plus" style="margin-right: 5px; cursor:pointer;"></i>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            })
        this._inforesumen();
        let mostrarResumen= $('.more_info', this.element);
        mostrarResumen.on('click',e=>{this._mostrandoResumen(e)});
    },

    _addValuesDo:function(values) {
        let me = this;
        let en = {};
        let nada = this.options.nada;
        let style = this.options.editable ? " style='cursor:grab'" : "";
        let editable = this.options.editable;
        let labelMostrando= this.options.label_sort;
        let total_registros = Array.isArray(values) ? values.length : 0;
        let total_registros_add = !Array.isArray(values);
        //poner permiso
        let permiso_colores= $vitex_globales.puede_prohibir_colores;
        $('.numero_registros',me.element).remove();
        $('.clasificame_count',me.element).remove();
        for (let v in values)
            if (values.hasOwnProperty(v)) {
                let id, label, clasificaId;
                let cssClass = '';
                let title = '';
                let bandera;
                let china;
                let programa;
                let existencia;
                if (typeof values[v] === 'object') {

                    bandera=values[v].bandera;
                    china=values[v].china;
                    programa=values[v].programa;
                    existencia=values[v].existencia;

                    let item = values[v];
                    id = typeof item[this.valueId] === 'undefined' ? v : item[this.valueId];
                    label = typeof item[this.valueDisplay] === 'undefined' ? id : item[this.valueDisplay];
                    clasificaId = typeof item[this.valueColumnKey ] === 'undefined' ? nada : item[this.valueColumnKey];
                    if((item['usuario_tipo_rony'] || '') === 'Si')
                        cssClass = 'c_usuarioTipoRony';
                    title = item['title'] || ''
                } else {
                    id = v;
                    label = values[v];
                    clasificaId = nada;
                }

                    if(bandera===1) title+='Se agrego en programación, click para marcar como aprobado';
                    if(existencia===1) if(title.length) title+=', tiene existencia'; else title+='Este producto tiene existencia';
                    if(china===1) if(title.length) title+=', tiene pedidos en China'; else title+='Este producto tiene pedidos en China';
                    if(programa===1) if(title.length) title+=', este tiene pedidos en Programa'; else title+='Este tiene producto pedidos en Programa';
                let $to = $(`.clasificaItemList[data-clasificakey='${clasificaId}']`, this.element);

                if ($to.length) {
                    en[$to.attr("id")]=$to;
                    let elementId = this.element.attr('id');
                    let $li = $(`<li title="${title}" class="${cssClass}" ${style} data-container='${clasificaId}' data-bandera=${bandera} data-clasificaconteiner="${elementId}" data-clasificaid="${id}"><span class="clasificameLabel">${label}</span></li>`);
                    $('.con_existe').tooltip();
                    $('li').tooltip();

                    


                    if (bandera===1) {
                        $li.addClass('bg-warning-updt');
                    }
                    if($li.text().includes('(Con ∃)') && $to.parent().data('clasificacontainer')==='Si' || china===1){
                         $li.addClass('con_existe');
                        };
                        
                    if($li.data("container")==='Prohibido' && !permiso_colores)$li.addClass('con_existe');
                    if($li.data("container")!=='Prohibido' || permiso_colores){
                        let toolbar = this._toolbar(clasificaId, bandera);
                        if(toolbar.length)
                            $li.append($(toolbar).on('click',function (evt) {
                                me._clickTo(evt)
                            }));
                    }
                    $to.append($li.on('click', function (evt) {
                        me._clickTo(evt)
                    }));
                    if(total_registros_add)
                        ++total_registros;
                }
            }
            const $list= $('.clasificaFlexItem ul',this.element);
            const first_element=$('.clasificaFlexItem ul',this.element).first().data('clasificakey');
            const last_element=$('.clasificaFlexItem ul',this.element).last().data('clasificakey');
            let data_mostrando
            $list.each(function () {
                let data_ant= $(this).parent().prev().data('clasificacontainer');
                let data_next= $(this).parent().next().data('clasificacontainer');
               let anterior_elemento=data_ant ?? last_element;
               let siguiente_elemento=data_next ?? first_element;

               const numero_hijos=$(this).children().length ;
               data_mostrando= labelMostrando.replace(' ','_')
               const div_conteo=$(`<div class="numero_registros more_info" title="Ver resumen de las listas" style="cursor:pointer;" data-label-registro="${data_mostrando}"><p><i class="fa-solid fa-circle-plus" style="margin-right: 5px;"></i>Mostrando:</p> <span>${numero_hijos}  ${labelMostrando}</span></div>`);
               const div_flecha=$(`<div><i title="Pasar a ${anterior_elemento}" class="fa-solid fa-circle-arrow-left fa-lg previous" style="color: #ad7600; cursor: pointer;"></i><i title="Pasar a ${siguiente_elemento}" class="fa-solid fa-circle-arrow-right fa-lg next" style="color: #ad7600; cursor: pointer;"></i></div>`)
               .css({
                "display": "flex",
                "justify-content": "space-between",
                "margin-top": "10px",
               });               
               const div_acordeon= $(`<div class="div_acordeon"><p style=" text-align: center;font-size: 0.8rem;font-weight: bold;">Información</p></div>`).css({
                "width": "90%",
                "background": "#e3e3e3",
                "padding": "0.3rem",
                "margin": "0 1rem 0.5rem 1rem",
                "border-radius": "5px",
                "border": "1px #c3c3c3 solid",
                "height": "0px",
                "overflow": "hidden",
                "opacity": "0",
               });

               

               if(editable)
                    div_flecha.insertAfter($(this));
                
                div_acordeon.insertAfter($(this));


               if($(this).data('clasificakey')=== 'Prohibido' && !$vitex_globales.puede_prohibir_colores)div_flecha.remove();
               div_conteo.insertAfter($(this));


            })
            $('.fa-solid').tooltip();
            const listTemplate= $('.clasificaTitle',this.element).first();

            let $div_total=$(`<p class="clasificame_count">Total: <span>${total_registros} ${data_mostrando}</span></p>`)

            listTemplate.append($div_total);

        me._inforesumen();
        let mostrarResumen= $('.more_info',this.element);
        mostrarResumen.on('click',e=>{me._mostrandoResumen(e,me)});

        this._allToPrev(this)
        this._allToNext(this)
        for(let e in en)
            if(en.hasOwnProperty(e))
                this._sortMe(en[e]);
    },
    _mostrandoResumen: function(e=null,me=this){

        let div_acordeon= $('.div_acordeon',me.element);
        let div_list= $('.clasificaFlexItem ul',me.element);

        let propiedades;
        let propiedades_ul;
            if(div_acordeon.css('opacity')==='0'){
                propiedades = {
                    height: '85px',
                    opacity: 0.8
                  };
                propiedades_ul={height: '33vh'};
                
            }else{
                propiedades = {
                    height: '0px',
                    opacity: 0
                  };
                propiedades_ul={height: '45vh'};
            };
            // Define la duración de la animación en milisegundos
            let duracion = 1000;
                
            // Inicia la animación
            div_acordeon.animate(propiedades, duracion);
            div_list.animate(propiedades_ul, duracion);
    },
    _inforesumen: function(me=this) {

        let div_acordeon=$('.div_acordeon', me.element);
        div_acordeon.empty();

        const $list= $('.clasificaFlexItem ul',this.element);
        let labelMostrando= me.options.label_sort;
        let data_mostrando= labelMostrando.replace(' ','_');
        div_acordeon.each(function () {
            let span_Info=$(this).parent().find('li').find('span').filter(':visible');
            let span_Info_China=$(this).parent().find('.bg-warning-updt').filter(':visible').length;
               let contador_conE = 0;
               let contador_sinE = 0;
               let contador_Huerfano = 0;
               //inicia each
               span_Info.each(function () {
                const txt_span=$(this).text();

                $('.info_modal', $(this)).remove();

                if(txt_span.includes('(Con ∃)'))contador_conE++;
                if ($(this).parents('span').length) {
                    if(txt_span.includes('(Sin ∃)'))contador_sinE++;
                    if(txt_span.includes('(H)'))contador_Huerfano++;
                }
            });
            let div_china=$(`<div class="info_modal"><p style="font-size: 0.7rem;font-weight: bold;">Pedidos en China</p><p>${span_Info_China} ${data_mostrando}</p></div>`)
            let div_conexistencia=$(`<div class="info_modal"><p style="font-size: 0.7rem;font-weight: bold;">${me.options.label_sort} con existencia</p><p>${contador_conE} ${data_mostrando}</p></div>`)
            let div_sinexistencia=$(`<div class="info_modal"><p style="font-size: 0.7rem;font-weight: bold;">${me.options.label_sort} sin existencia</p><p>${contador_sinE} ${data_mostrando}</p></div>`)
            let div_huerfanos=$(`<div class="info_modal"><p style="font-size: 0.7rem;font-weight: bold;">${me.options.label_sort} huerfanos</p><p>${contador_Huerfano} ${data_mostrando}</p></div>`)

            $(this).append(div_china);
            $(this).append(div_conexistencia);
            $(this).append(div_sinexistencia);
            $(this).append(div_huerfanos);
            $('.more_info').tooltip();
        });
    },
    _toolbar: function(clasificaId, bandera, me=this) {
        if(!this.options.liButtons)
            return '';
        if(typeof clasificaId === 'undefined')
            clasificaId = this.options.clasificacion[0].clasificaId;
        let buttons = [];
        if(bandera===1 && $vitex_globales.es_Rony){
            buttons.push(`<span class="clasificaStage"><i class="fa-duotone fa-stars fa-lg" style="--fa-primary-color: #d1b500; --fa-secondary-color: #d1b500;"></i></span>`);
        }else if(bandera===1 && !$vitex_globales.es_Rony){
            buttons.push(`<span class="clasificaStageRead"><i class="fa-duotone fa-stars fa-lg" style="--fa-primary-color: #d1b500; --fa-secondary-color: #d1b500;"></i></span>`);
        }

        for(const option in this.options.clasificacion)
          if(this.options.clasificacion.hasOwnProperty(option))  {
            const b = this.options.clasificacion[option];
            const classPressed = clasificaId === b.clasificaId ? "class='pressed'" : "";
            const label = typeof b.label === 'undefined' ? b.clasificaId.replaceAll('_', ' ') : b.label;
            const title = typeof b.title === 'undefined' ? b.label : b.title;
            buttons.push(`<span ${classPressed} data-clasificaTo="${b.clasificaId}">${label}</span>`);
        }
        return `<div class="clasificaToolBar noDrag">` + buttons.join("\r\n\t") + `</div>`;
    },
    _toolbarUnpress:function(el) {
        el.find(".clasificaToolBar").children("SPAN").each(function(){$(this).removeClass('pressed');});
    },

    _html: function() {
        
        let columns = [];
        for(const ba in this.options.clasificacion)
          if(this.options.clasificacion.hasOwnProperty(ba)) {
            const b = this.options.clasificacion[ba];
            const label = typeof b.label === 'undefined' ? b.clasificaId.replaceAll('_', ' ') : b.label;
            const titler = typeof b.title === 'undefined' ? label : b.title;
            let indicaUserSortable = b.userSortable === true ? '<span title="Se pueden reordenar con drag & drop">↕</span>' : '';

            let opc_busqueda;
            if(b.clasificaId==='Prohibido' && !this.options.permiso_prohibido) {
                 opc_busqueda='';
            }
            else
            opc_busqueda=`<div>
                            ${indicaUserSortable}
                            <input type="text" value="" placeholder="🔎" class="clasificaFind"
                                data-clasificakey="${b.clasificaId}" 
                            ><span class="clasificaFindClear" 
                                data-clasificakey="${b.clasificaId}">x</span>   
                            <span title="Pasar todos, los visibles, a ${titler}" 
                                data-clasificaelementid="${this.element.attr('id')}"
                                data-clasificakey="${b.clasificaId}"
                                class="clasificaAllTo" >↴</span>
                        </div> `;
            columns.push(`
                    <div class="clasificaFlexItem" data-clasificaContainer="${b.clasificaId}">
                            <div class="clasificaItemTitle clasificaFlexRow" data-clasificaTitle="${b.clasificaId}">
                                <h3>${titler}</h3>
                                 ${opc_busqueda}
                            </div>
                            <ul class="clasificaItemList" data-clasificame="${ba}" data-self="${ba}" data-clasificakey="${b.clasificaId}"">
                            </ul>
                    </div>`
            );


        }

        const title = this.options.title === null ?
            this.options.valueColumnKey.replaceAll('_', ' ') :
            this.options.title;
        return `<div style="padding:0.75em 0.5em"><div class="clasificaTitle">${title}</div><div class="clasificaFlexRow">` + columns.join("\r\n") + `\r\n</div></div>`;
    },

    _findClear:function(event,me=this) {
        let $element = $(event.target);
        let clasificakey = $element.data('clasificakey');
        $(`INPUT[data-clasificakey='${clasificakey}']`).val('');
        $(`UL[data-clasificakey='${clasificakey}']`).children("li").show();

        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
            $list.each(function () {
                const numero_hijos=$(this).find('li').filter(':visible').length ;
               const div_conteo=$(`<div class="numero_registros more_info" title="Ver resumen de las listas" style="cursor:pointer;" data-label-registro="${nombre_label_registro}"><p><i class="fa-solid fa-circle-plus" style="margin-right: 5px; cursor:pointer;"></i>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            })
        me._inforesumen();
        let mostrarResumen= $('.more_info', me.element);
        mostrarResumen.on('click',e=>{me._mostrandoResumen(e)});

    },

    _preg_quote: function(v) {return v.replace( /([.^$*+\-?()[\]{}\\/|])/g, '\\$1');},

    _find: function(event, me=this) {
        event.preventDefault();
        let $element = $(event.target);
       
        let clasificakey = $element.data('clasificakey');
        let $li = $(`UL[data-clasificakey='${clasificakey}']`).children("li");
        if($li.length === 0) {
            return;
        }
        let searchFor = $element.val().trim().replace(/\s+/gm, ' ')
            .normalize('NFD').replace(/[\u0300-\u036f]/g, '').toLowerCase();
        if(searchFor.length === 0) {
            $li.children("li").show();
            return;
        }
        let regex = new RegExp(this._preg_quote(searchFor), 'i');
        $li.each(function(){
          let $el = $(this);
          if($el.find('span').first().length)
            if($el.find('span').first().text().normalize('NFD')
                .replace(/[\u0300-\u036f]/g, '').toLowerCase().search(regex )>=0)
                $el.show();
            else
                $el.hide();
        });

        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
            $list.each(function () {
                const numero_hijos=$(this).find('li').filter(':visible').length ;
               const div_conteo=$(`<div class="numero_registros more_info" title="Ver resumen de las listas" style="cursor:pointer;" data-label-registro="${nombre_label_registro}"><p><i class="fa-solid fa-circle-plus" style="margin-right: 5px; cursor:pointer;"></i>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
               div_conteo.insertAfter($(this));
            })
        me._inforesumen();
        let mostrarResumen= $('.more_info', me.element);
        mostrarResumen.on('click',e=>{me._mostrandoResumen(e)});

    },

    moveTo: function(clasificaid, sendTo,me=this) {
        let target = $(`LI[data-clasificaid="${clasificaid}"]`).first();
        if (target.parent().data('clasificakey')==='Si' && target.hasClass('con_existe')) 
            return;
        if (target.parent().data('clasificakey')==='Prohibido' && target.hasClass('con_existe')) 
            return;
        if(target.length === 0 || typeof sendTo !== 'string' || sendTo.length === 0)
            return;
        let liElement = target[0];

        if(typeof liElement === 'undefined' || liElement == null)
            return;
       // console.log("liElement", liElement);
        if(liElement.tagName !== 'LI')
            return;
        liElement = $(liElement);
        liElement.find(".clasificaToolBar").children("SPAN").each(function(){$(this).removeClass('pressed');});
        liElement.find("span[data-clasificato='" + sendTo + "']").addClass('pressed');
        target.addClass('pressed');
        let $el = $(`.clasificaItemList[data-clasificakey='${sendTo}']`, $("#" + liElement.data('clasificaconteiner') ));
        $el.append(liElement);
        liElement.hide().toggle("right");
        //muestra el numero de registros
        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',me.element);
        $list.each(function () {
            const numero_hijos=$(this).find('li').filter(':visible').length;
        const div_conteo=$(`<div class="numero_registros more_info" title="Ver resumen de las listas" style="cursor:pointer;" data-label-registro="${nombre_label_registro}"><p><i class="fa-solid fa-circle-plus" style="margin-right: 5px; cursor:pointer;"></i>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
            div_conteo.insertAfter($(this));
        })
        me._inforesumen();
        let mostrarResumen= $('.more_info', me.element);
        mostrarResumen.on('click',e=>{me._mostrandoResumen(e)});

        let sortType = $el.data('clasificame')['userSortable'];
        if(sortType === true)
            return;
        if(typeof sortType !== 'function')
            sortType = function(a, b) {
                return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
            };
        $("li", $el).sort(sortType).appendTo($el);

    },

    _clickTo:function(event, me=this) {
        event.stopImmediatePropagation();
        event.stopPropagation();
        if($(event.target).hasClass('pressed')) return;
        let target = $(event.target);
        if(target.parent().parent().hasClass('con_existe'))return;
        const sendTo = target.data('clasificato');
        if(sendTo === 'Prohibido' && !$vitex_globales.puede_prohibir_colores) return;
        if(typeof sendTo !== 'string' || sendTo.length === 0)
            return;
        let liElement = $(event.target).parent();
        //Put permisos
        if (liElement.hasClass('con_existe') && liElement.parent().data('clasificakey')==='Si') return
        if(typeof liElement === 'undefined' || liElement == null)
            return;
        liElement.parent().find(".clasificaToolBar").children("SPAN").removeClass('pressed');
        target.addClass('pressed');
        let $el = $(`.clasificaItemList[data-clasificakey='${sendTo}']`, me.element);;

        let sortType = $el.data('clasificame')['userSortable'] || true;
        $el.append(liElement.parent());
        liElement.hide().toggle("right");

        //muestra el numero de registros
        const registros=$('.numero_registros');
        let nombre_label_registro= registros.data('label-registro');
        let set_name_label= nombre_label_registro.replace('_',' ');
        registros.remove();
        const $list= $('.clasificaFlexItem ul',this.element);
        $list.each(function () {
            const numero_hijos=$(this).find('li').filter(':visible').length;
           const div_conteo=$(`<div class="numero_registros more_info" title="Ver resumen de las listas" style="cursor:pointer;" data-label-registro="${nombre_label_registro}"><p><i class="fa-solid fa-circle-plus" style="margin-right: 5px; cursor:pointer;"></i>Mostrando:</p> <span>${numero_hijos}  ${set_name_label}</span></div>`);
            div_conteo.insertAfter($(this));
        })

        me._inforesumen();
        let mostrarResumen= $('.more_info', me.element);
        mostrarResumen.on('click',e=>{me._mostrandoResumen(e)});

        if(sortType === true)
            return;
        if(typeof sortType !== 'function')
            sortType = function(a, b) {
                return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
            };
        $("li", $el).sort(sortType).appendTo($el);
        
    },

    _sortMe: function(element) {
        let sortType = $(element).data('clasificame')['userSortable'];
        if(sortType === true)
            return;
        if(typeof sortType !== 'function')
            sortType = function(a, b) {
                return $(b).text().toUpperCase() < $(a).text().toUpperCase() ? 1 : -1;
            };
        $("li", element).sort(sortType).appendTo(element);
    },

});
