/*
    1.- default select class ie notselectize & default class for option, optiongroup
    2.- select to heirarchy select
    4.- if selects exist?
    5.- on multilevel heirarchy validate/invalidate combos for non existant levels
    data-nivel to data level
    data and camel case prblm?

Ejemplos
$(function(){
    $("#categoriaGasto").Clasificator({
          'readurl':'ajax/categoria_gasto_do.php',
          editable:true,
          maxLevel:3,
          uniqueNameBy:'level',
          topOffsetScroll:200,
      }).Clasificator('crud'); // altas bajas y cambios


 $("#categoria_gasto_id").Clasificator({
        'readurl':'ajax/categoria_gasto_do.php',
        editable:true,,
        maxLevel:3,
        uniqueNameBy:'level',
        'selected': 'el id o selected en select',
        topOffsetScroll:200,
    }).Clasificator('selectChained'); // 3 selects para seleccionar

 $("#altri").Clasificator({
        'readurl':'ajax/categoria_gasto_do.php',
        editable:true,
        maxLevel:3,
        uniqueNameBy:'level',
        selected: '5a02714d0779b65611e52660c4aeb3ed',
        topOffsetScroll:200,
    }).Clasificator('selectHeirarchy',true); // 1 select con options group


    $("<div>").Clasificator({
        'readurl':'ajax/categoria_gasto_do.php',
        editable:true,
        maxLevel:3,
        uniqueNameBy:'level',
        topOffsetScroll:200,
    }).Clasificator('ancestors', '5a02714d0779b65611e52660c4aeb3ed'
        , function(x) { $("#div_categoria_gasto_id").append( " <- " + x.reverse().slice(1).reverse().join(" <- ")  );}
    ); // desplegar nombres de la caetogoria



});
En colmodel ver withdrawals_de_banco_list.php y banco_diccionario_dato con su app


*/
// jshint unused:true
// jshint eqeqeq:false
// jshint forin:true
// jshint futurehostile:true
// jshint esversion: 6
// jshint latedef:nofunc
// jshint nonbsp:true

;(function($, window, document, undefined) {
    'use strict';
    var version='0.0.0', pluginName='Clasificator';

    if(typeof String.prototype.repeat == "undefined") {
        String.prototype.repeat = function( num ) { return new Array( num + 1 ).join( this ); };
    }

    // $.pluginName.defaults maybe previosly set by user
    $[pluginName] = $[pluginName] || {};
    if(!$[pluginName].hasOwnProperty('defaults')) {
    	$[pluginName].defaults = { };
    }

    var fn = {
        mouseCursor: function(cursor) {
            switch(cursor) {
            case 'grab':
                if( window.CSS.supports('cursor', 'grab') ) {
                  return 'grab';
                }
                if( window.CSS.supports('cursor', '-moz-grab') ) {
                  return '-moz-grab';
                }
                if( window.CSS.supports('cursor', '-webkit-grab') ) {
                  return '-webkit-grab';
                }
                return 'move';
                //break;
            case 'grabbing':
                if( window.CSS.supports('cursor', 'grabbing') ) {
                  return 'grabbing';
                }
                if( window.CSS.supports('cursor', '-moz-grabbing') ) {
                  return '-moz-grabbing';
                }
                if( window.CSS.supports('cursor', '-webkit-grabbing') ) {
                  return '-webkit-grabbing';
                }
                return 'move';
                //break;
            }
            return cursor;
            // cursor = 'url(/grab.cur)';
        },

       deepGet: function(obj, props, defaultValue) {
        /** https://github.com/joshuacc/drabs, licencse MIT */
            if(typeof props === 'string') {
                props = props.split('.');
            }
            var deepGetByArray = function (obj, propsArray, defaultValue) {
                if (obj === undefined || obj === null) {
                    return defaultValue;
                }
                if (propsArray.length === 0) {
                    return obj;
                }
                var foundSoFar = obj[propsArray[0]];
                var remainingProps = propsArray.slice(1);
                return deepGetByArray(foundSoFar, remainingProps, defaultValue);
            };
            return deepGetByArray(obj, props, defaultValue);
        }
    };

    // $.pluginName.fn maybe previosly set by user
    if(!$[pluginName].hasOwnProperty('fn')) {
    	$[pluginName].fn = { };
    }
    $[pluginName].fn = $.extend({}, fn, $[pluginName].fn );



    function Clasificator(element, options) {
        this._init(element, options);
    }

    Clasificator.prototype = {
        version: version,
        option: function(option, value) {
            if(!option) {
                return this.options;
            }
            var args = arguments;
            if(args.length === 2) {
                this.options[option] = value;
                return;
            }
            return this.options[option] || null;
        },

        defaults: {
            readurl: '',
            postData: {},
            uniqueNameBy: 'parent', // level, parent
            maxLevel: -1, // -1 no limit
            editable: true,
            addLevel0: false,
            addLevel0Label: "Nuevo Abuelo",
            delLevel1: true, // allow delete in level1

            btnAdd: '<button class="categoBtnAdd" title="Nuevo tipo de gasto bajo %tipo%"><img src="../img/add.png" style="border: none;"/></button>',
            btnEdit: '<button class="categoBtnEdit" title="Cambiar el nombre a %tipo%"><img src="../img/pencil.png" style="border: none;"/></button>',
            btnDel: '<button class="categoBtnDel" title="Borrar %tipo%"><img src="../img/tache_rojo_plano.gif" style="border: none;"/></button>',

            topOffsetScroll: 0,
            sortableOptions: {
                    connectWith: ".categoUlLevel",
                    placeholder: "categoPlaceHolder",
                    forcePlaceholderSize:true,
                    //revert:true,
                    cursor: $.Clasificator.fn.mouseCursor('grabbing'),
                    opacity: 0.6,
                    cancel :"input, textarea, button, select, option, a",
                    delay: 100,
                    tolerance: "pointer",
                    dropOnEmpty:true,
                    items: "> li",
                    clasificatorPage:'ajax/categoria_gasto_do.php',
                    stop: function( event, ui ) {
                        var selfSortable=$(this), $item = $(ui.item),upto = $item.data('clasificatorelem'),
                            myPluginData = $('#'+upto).data().plugin_Clasificator.options;
                        // el plugin en que cae ta en $('#'+upto).Clasificator('option')
                        if(isOutside( upto, ui)) {
                            selfSortable.sortable( "cancel" );
                            return;
                        }
                        if($item.hasClass('categoNoMove')) {
                            selfSortable.sortable( "cancel" );
                        }
                        var $ul=$item.closest('ul').children('li'),
                            o = [], ord;
                        $ul.each(function(){ o[o.length] = $(this).data('id'); });
                        ord = o.join(', ');
                        var param = {
                                h:'m',
                                id: $item.data('id'),
                                prt:$item.closest('ul').closest('li').data('id'),
                                nivel:$item.parentsUntil('#' + upto, 'ul').length,
                                order:ord
                            };
                        if(!param.prt) {
                            param.prt=0;
                        }
                        if(myPluginData.readurl) {
                            // check with server if move is valid
                            $.ajax({
                                method: 'POST',
                                url: myPluginData.readurl,
                                cache: false,
                                data: $.extend({}, param, myPluginData.postData),
                                dataType: 'json'
                            })
                            .done(function(data){
                                if(data.ok) {
                                    return;
                                }
                                selfSortable.sortable( "cancel" );
                                ajaxErrorMsg(data);
                            })
                            .fail(function(){
                                selfSortable.sortable( "cancel" );
                                dialogError("Error al guardar cambios a los tipos de gasto", "Hizo login?");
                            });
                        }
                    }
            }
        },

        selectChained:function(){
            var me=this, myval=me.$el.val();
            if(myval) {
                me.$el.data("clasificatorlastval", myval);
            } else if(me.options.selected) {
                me.$el.data("clasificatorlastval", me.options.selected);
            }
            if( typeof me.options.category === 'object') {
                chainedSelects(me.options.category, me, myval);
                return me;
            }
            if(me.options.readurl.length) { //  != ''
                $.ajax({
                    method: 'GET',
                    url: me.options.readurl,
                    cache: false,
                    data: $.extend({}, {h:'r'}, me.options.postData),
                    dataType: 'json'
                })
                .done(function(data){
                    if(data.ok) {
                        chainedSelects(data.data, me, myval);
                        return;
                    }
                    ajaxErrorMsg(data);
                })
                .fail(function(){
                    dialogError("Error al leer los tipos de gasto", "Hizo login?");
                });
            }
            return this;
        },

        selectHeirarchy : function(selectAnyLevel) {
            var me=this, myval=me.$el.val();
            if(me.options.selected)
                myval = me.options.selected;
            if(myval) {
                me.$el.data("clasificatorlastval", myval);
            } else if(me.options.selected) {
                me.$el.data("clasificatorlastval", me.options.selected);
            }
            if( typeof me.options.category === 'object') {
                heirarchySelects(me.options.category, me, myval,selectAnyLevel);
                return me;
            }
            if(me.options.readurl.length) {
                $.ajax({
                    method: 'GET',
                    url: me.options.readurl,
                    cache: false,
                    data: $.extend({}, {h:'r'}, me.options.postData),
                    dataType: 'json'
                })
                .done(function(data){
                    if(data.ok) {
                        heirarchySelects(data.data, me, myval,selectAnyLevel);
                        return;
                    }
                    ajaxErrorMsg(data);
                })
                .fail(function(){
                    dialogError("Error al leer los tipos de gasto", "Hizo login?");
                });
            }
            return this;
        },

        ancestors: function(id, callback, cache) {
            var me=this;
            if( typeof me.options.category === 'object') {
                ancestorsGet(me.options.category, id, me, callback, cache);
                return;
            }
            if(me.options.readurl.length) {
                $.ajax({
                    method: 'GET',
                    url: me.options.readurl,
                    cache: false,
                    data: $.extend({}, {h:'r'}, me.options.postData),
                    dataType: 'json'
                })
                .done(function(data){
                    if(data.ok) {
                        ancestorsGet(data.data, id, me, callback, cache);
                        return;
                    }
                    ajaxErrorMsg(data);
                })
                .fail(function(){
                    dialogError("Error al leer los tipos de gasto", "Hizo login?");
                });
            }
            return this;
        },

        crud: function() {
            var me=this;
            if( typeof this.options.category === 'object') {
                paintit(parent2nested(this.options.category), me);
                activate(me);
                return this;
            }
            if(me.options.readurl.length) { //  != ''
                $.ajax({
                    method: 'GET',
                    url: me.options.readurl,
                    cache: false,
                    data: $.extend({}, {h:'r'}, me.options.postData),
                    dataType: 'json'
                })
                .done(function(data){
                    if(data.ok) {
                        paintit(parent2nested(data.data), me);
                        activate(me);
                        return;
                    }
                    ajaxErrorMsg(data);
                })
                .fail(function(){
                    dialogError("Error al leer los tipos de gasto", "Hizo login?");
                });
            }
            return this;
        },

        isUniqueName: function(name, id, nivel, parentId) {
            var regex = new RegExp('^' + escapeRegExp(name) + '$', 'i'), testVs, ret=false;
            if(this.options.uniqueNameBy === 'level') {
                $('li[data-nivel="'+nivel+'"]', this.$element).each(function(){
                    testVs=$(this);
                    if(testVs.data('id')!=id && regex.test(testVs.find('.categoLabel:first').text().trim() ) ) {
                        ret = testVs.data('id');
                        return false;
                    }
                });
                return ret;
            }
            $('li[data-id="'+parentId+'"]', this.$element).children('ul').children('li').each(function(){
                testVs=$(this);
                if(testVs.data('id')!=id && regex.test(testVs.find('.categoLabel:first').text().trim() ) ) {
                    ret = testVs.data('id');
                    return false;
                }
            });
            return ret;
        },

        _delCat : function(elem) {
                var me=this, e=$(elem).closest('li'), parent=e.closest('ul').closest('li').data('id'), lbl = e.children('span').html();
                if(e.children('ul').children('li').length>0) {
                     dialogError(lbl+"<p>Tiene sub tipos, cambielos de lugar para borrar", 'No se puede borrar');
                    return;
                }
                // confirm delete
                var
                    confirmDlg = '<div title="Borrar la clasificaci&oacute;n?"><p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span>Confirme borrar la clasificaci&oacute;n:<p>'+lbl+'</p><p style="text-align:center">Seguro?</p></p></div>';
                $(confirmDlg).dialog({
                      resizable: true,
                      height:340,
                      width:440,
                      modal: true,
                      buttons: {
                        "Borrar": function(evt) {
                            // $(evt.target).button('disable');
                            var dlg = $(this);

                            $.ajax({
                                method: 'POST',
                                url: me.options.readurl,
                                cache: false,
                                data: $.extend({}, {h:'d', id:e.data('id'), nivel:e.data('nivel'), prt:parent, label:lbl}, me.options.postData),
                                dataType: 'json'
                            })
                            .done(function(data){
                                dlg.dialog( "close" ).dialog( "destroy" ).remove();
                                if(data.ok) {
                                    //var removed = {elem: e.detach(), prt:parent };
                                    e.detach();
                                    return;
                                }
                                ajaxErrorMsg(data);
                            })
                            .fail(function(){
                                dialogError("Error al leer los tipos de gasto", "Hizo login?");
                            });
                        },
                        Cancel: function() {
                          $( this ).dialog( "close" ).dialog( "destroy" ).remove();
                          return;
                        }
                      }
                });
        },

        _editCat : function(elem) {
                var me=this, e=$(elem).closest('li'), lbl = e.children('span').html(),
                    parentId=e.closest('ul').closest('li').data('id'); // parent=e.closest('ul').closest('li').children('span').html();
                var title='Renombrar: ' + lbl,
                    input = $('<input data-clasificatorinput="label"/>').width('40em').val(lbl),
                    errmsg = '<p data-clasifcatormsg="catmsgerr" class="ui-state-error" style="display:none"><span class="ui-icon ui-icon-info" style="float:left; margin:0 7px 50px 0;"></span><span data-clasifcatormsg="catmsgerrtxt"></span></p>';
                var dlgHTML = $('<div/>').attr('title', title).append(errmsg).append(input);
                var $dlg = $(dlgHTML).dialog({
                  modal: true,
                  width: '44em',
                  height:200,
                  buttons: [
                    {
                        text:'Save',
                        click: function(evt) { // clasificatorinput="label"
                            // $(evt.target).button('disable');
                            $(this).find('[data-clasifcatormsg="catmsgerr"]').css('display', 'none');
                            var newValue = $(this).find('[data-clasificatorinput="label"]').val().trim(), $evt=$(evt.target);
                            // check value
                                if(newValue === '') {
                                    $(this).find('[data-clasifcatormsg="catmsgerrtxt"]').html('Falto el nombre');
                                    $(this).find('[data-clasifcatormsg="catmsgerr"]').css('display', 'block');
                                    $(this).find('[data-clasificatorinput="label"]').val('');
                                    $(evt.target).button('enable');
                                    return;
                                }
                                //uniqueNameBy
                                var dblId = me.isUniqueName(newValue, e.data('id'), e.data('nivel'), parentId);
                                if(dblId !== false) {
                                    $(this).find('[data-clasifcatormsg="catmsgerrtxt"]').html('Ya existe el nombre '+newValue);
                                    $(this).find('[data-clasifcatormsg="catmsgerr"]').css('display', 'block');
                                    $(evt.target).button('enable');
                                   return;
                                }

                                $.ajax({
                                    method: 'POST',
                                    url: me.options.readurl,
                                    cache: false,
                                    data: $.extend({}, {h:'e', id:e.data('id'), nivel:e.data('nivel'), prt:parentId, label:newValue}, me.options.postData),
                                    dataType: 'json'
                                })
                                .done(function(data){
                                    if(data.ok) {
                                        e.children('span').html(newValue);
                                        $dlg.dialog( 'close' ).remove();
                                        return;
                                    }
                                    ajaxErrorMsg(data);
                                    $evt.button('enable');
                                })
                                .fail(function(){
                                    dialogError("Error al leer los tipos de gasto", "Hizo login?");
                                    $evt.button('enable');
                                });
                        }
                    },
                    {
                        text:'Cancel',
                        click: function() {$( this ).dialog( "close" ).remove();}
                    }
                  ],
                  close: function()  {
                    try {
                        if($( this ).dialog.length ) {
                            $( this ).dialog( 'close' ).dialog( 'destroy' ).remove();
                        }
                    } catch(er) {}
                  }
                });
        },

        _addCat: function(elem) {
            var me=this, e=$(elem).closest('li'), lbl = e.children('span').html(), nivel = e.data('nivel')+1;

            var title='Nuevo tipo bajo: ' + lbl,
                    input = $('<input data-clasificatorinput="label"/>').width('40em'),
                    errmsg = '<p data-clasifcatormsg="catmsgerr" class="ui-state-error" style="display:none"><span class="ui-icon ui-icon-info" style="float:left; margin:0 7px 50px 0;"></span><span data-clasifcatormsg="catmsgerrtxt"></span></p>';
                var dlg = $('<div/>').attr('title', title).append(errmsg).append(input);

                $(dlg).dialog({
                  modal: true,
                  width: '44em',
                  height:200,
                  buttons: [
                    {
                        text:'Save',
                        click: function(evt) {
                            // $(evt.target).button('disable');
                            $(this).find('[data-clasifcatormsg="catmsgerr"]').css('display', 'none');
                            var dlg = $(this), $evt=$(evt.target);
                            var newValue = $(this).find('[data-clasificatorinput="label"]').val().trim();
                            // check value
                                if(newValue === '') {
                                    $(this).find('[data-clasifcatormsg="catmsgerrtxt"]').html('Falto el nombre');
                                    $(this).find('[data-clasifcatormsg="catmsgerr"]').css('display', 'block');
                                    $(this).find('[data-clasificatorinput="label"]').val('');
                                    $evt.button('enable');
                                    return;
                                }
                                //uniqueNameBy
                                var dblId = me.isUniqueName(newValue, '\t', nivel, e.data('id'));
                                if(dblId !== false) {
                                    $(this).find('[data-clasifcatormsg="catmsgerrtxt"]').html('Ya existe el nombre '+newValue);
                                    $(this).find('[data-clasifcatormsg="catmsgerr"]').css('display', 'block');
                                    $evt.button('enable');
                                    return;
                                }
                                $.ajax({
                                    method: 'POST',
                                    url: me.options.readurl,
                                    cache: false,
                                    data: $.extend({}, {h:'a', nivel:nivel, prt:e.data('id'), label:newValue}, me.options.postData),
                                    dataType: 'json'
                                })
                                .done(function(data){
                                    if(data.ok) {
                                        me.paintNew(data.data.id, newValue, nivel, e.data('id'), e);
                                        dlg.dialog( 'close' ).dialog( 'destroy' ).remove();
                                        return;
                                    }
                                    ajaxErrorMsg(data);
                                    $evt.button('enable');
                                })
                                .fail(function(){
                                    dialogError('Error al leer los tipos de gasto', 'Hizo login?');
                                    $evt.button('enable');
                                });
                        }
                    },
                    {
                        text:'Cancel',
                        click: function() { $( this ).dialog( 'close' ).dialog( 'destroy' ).remove();}
                    }
                  ]
                });
        },

        paintNew: function(withId, label, nivel, parentId, $parent) {
            var me=this, text = jQuery('<div />').text(label).html(),
                a = {items:{id:withId, 'label':text, prt:parentId}, 'nivel':nivel};
            if( this.options.maxLevel>0 && nivel > this.options.maxLevel) {
                $parent.children('ul').append(bindButtons(categoryLi(a, me), me));
                scrollToLi($parent, $('li[data-id="'+withId+'"]', $parent), -100, me.options.topOffsetScroll);
                return;
            }
            var sortableOptions = me.options.sortableOptions;
            sortableOptions.connectWith = '.categoUlLevel' + nivel;
            $parent.children('ul').append(bindButtons(categoryLi(a, me) + categoryUL(a, me), me) );
            $('.categoUlLevel' + nivel).not('.ui-sortable').sortable(sortableOptions);
            scrollToLi($parent, $('li[data-id="'+withId+'"]', $parent), 0, me.options.topOffsetScroll);
        },

        _init: function(element, options) {
            this.el = element;
            this.$el = $(element);
            this.options = $.extend({}, this.defaults, $[pluginName].defaults, options);
            this.$element = $(element);
            this.id = this.$element.attr('id');
            this.options.id = this.id;
            this.upToLevel = this.options.maxLevel > 0 ? this.options.maxLevel : 0;
        }
    };



////////////////////////////
/// Generic library
////////////////////////////
    function escapeRegExp(str) {
        // http://stackoverflow.com/questions/3446170/escape-string-for-use-in-javascript-regex
        return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&');
    }

    function isOutside(boundigBoxId, ui) {
        var bel = $('#'+boundigBoxId), bpos=bel.offset(), ael=$(ui.item);
        if( Math.max(0, Math.min(bpos.left + bel.width(), ui.position.left + ael.width()) -  Math.max(bpos.left, ui.position.left)) === 0 )  {
            return true;
        }
        if(Math.max(0, Math.min(bpos.top + bel.height(), ui.position.top + ael.height()) - Math.max(bpos.top, ui.position.top)) === 0) {
            return true;
        }
        return false;
    }

    function isVisible($elem) {
        var pos= $elem.offset(), w=$(window);
        if(!pos) {
            return true;
        }
        return !( pos.top <= w.scrollTop() || pos.top + $elem.height() >= w.scrollTop() + w.height() );
    }

    function scrollToLi(prt, elem, offset, topOffsetScroll) {
        try {
            if(!topOffsetScroll) {
                topOffsetScroll = 0;
            }
            if(!isVisible(elem) || !isVisible(prt) ) {
                    $('html, body').animate({scrollTop: prt.offset().top + topOffsetScroll }, 100, "swing",
                        function() {
                            if( !isVisible(elem) ) {
                                $('html, body').animate({scrollTop: elem.offset().top + offset + topOffsetScroll }, 100);
                            }
                        }
                    );
                    return;
            }
            if( !isVisible(elem) ) {
                $('html, body').animate({scrollTop: elem.offset().top + offset + topOffsetScroll}, 100);
             }
         } catch(er) {}
    }

    function dialogError(msg, title) {
        if(!msg) {
            msg = "Not allowed!";
        }
        if(!title) {
            title = "Not allowed!";
        }
        var dlg = '<div title="'+title+'" ><p><span class="ui-icon ui-icon-info" style="float:left; margin:0 7px 50px 0;"></span>'+msg+'</p></div>';
        $(dlg).dialog({
              modal: true,
              height:300,
              width:400,
              dialogClass: "ui-state-error",
              buttons: {
                Ok: function() {
                   $( this ).dialog( "close" ).dialog( "destroy" ).remove();
                }
              }
        });
    }

    function ajaxErrorMsg(data) {
        if(data.msg) {
            dialogError(data.msg, "Error inesperado, intente mas tarde");
            return;
        }
        dialogError("Favor de hacer login", "Falto hacer login");
    }

////////////////////////////
/// Clasificator library
////////////////////////////
    function parentsDeduce(category) {
        return category.reduce(function(p, c){ p[""+c.id]=""+c.prt || "0"; return p; }, {});
    }

    function prepareParentChild(category, parents) {
        // deduce nivel, if nivel not given.
        var catlen=category.length, icat;
        for(icat=0;icat<catlen;icat++) {
            if(!category[icat].nivel) {
                category[icat].nivel = heirarchyGet(category[icat].id, parents).length;
            }
        }
        return category.sort(function(a, b) {
            var dif = parseInt(a.nivel || 1, 10) - parseInt(b.nivel || 1, 10);
            if(dif) {
                return dif;
            }
            dif = parseInt(a.order || 0, 10) - parseInt(b.order || 0, 10);
            if(dif) {
                return dif;
            }
            return a.label.localeCompare(b.label);
        });
    }

    function heirarchyGet(id, parents) {
        var ret = [], h=""+id;
        while( parents[""+h]) {
            ret.push(h = ""+parents[h]);
        }
        return ret;
    }

    /**
    * category array [{label:'text to display', id:'unique_node_id', prt:'parents_node_id'}, ...]
    *  optionaly add:true, del:true, edit:true, move:true
    *
    */
    function parent2nested(category) {
        var parents = parentsDeduce(category);
        prepareParentChild(category, parents);

        // convert prtid to nested array
        return category.reduce(function (p, v) {
            if(v.prt == 0 || v.prt===undefined) {
                if(p[v.id]) {
                    p[v.id].items = v;
                } else {
                    p[v.id] = { items:v, childs:{}, nivel: 1 };
                }
                return p;
            }

            if(p[v.prt]) {
                p[v.prt].childs[v.id] = {items:v, childs:{}, nivel:p[v.prt].nivel +1 };
                return p;
            }

            if(parents[""+v.prt] && p[parents[""+v.prt]]) {
                p[parents[""+v.prt]].childs[v.prt].childs[v.id] = {items:v, childs:{}, nivel:p[parents[""+v.prt]].nivel +2 };
                return p;
            }
            var h = heirarchyGet(v.id, parents).reverse().slice(1).join(".childs.");
            var tmp = $.Clasificator.fn.deepGet(p, h);
            if(tmp) {
                tmp.childs[v.id] = {items:v, childs:{}, nivel:v.nivel};
                return p;
            }
            if( v.prt != 0) {
                console.log("Warning parent not found for", v);
            }
            v.prt=0;
            if(p[v.id]) {
                p[v.id].items = v;
            } else {
                p[v.id] = { items:v, childs:{}, nivel: 1 };
            }
            return p;
        }, {});
    }

        function activate(me) {
            if(!me.options.editable) {
                return;
            }
            var i;
            var sortableOptions;
            for(i=0; i<=me.upToLevel+1;i++) {
                sortableOptions = me.options.sortableOptions;
                sortableOptions.connectWith = ".categoUlLevel" + i;
                $('.categoUlLevel' + i).sortable(sortableOptions);
            }
        }
        function paintit(categoryNested, me) {
            var topLevel='';
            if(me.options.addLevel0)
                topLevel=categoryLi({ items:{move:false, del:false, edit:false, label:me.options.addLevel0Label, nivel:0, id:'root'}, prt:'', nivel:0  }, me);
            me.$element.append( $( bindButtons( topLevel +  '<ul class="categoUl categoUlLevel0" data-clasificatorelem="0">' +  categoryList(categoryNested, me) + '</ul>', me  ) ) );
        }

        function categoryList( ax, me ) {
            var str='', a, i;
            for (i in ax) {
                if (ax.hasOwnProperty(i)) {
                    a = ax[i];
                    if(a.nivel > me.upToLevel) {
                        me.upToLevel = a.nivel;
                    }
                    str += categoryLi(a, me);
                    if(a.nivel > me.options.maxLevel && me.options.maxLevel>0) {
                        console.log('Warning this item has nivel greater than defined maxLevel ('+me.options.maxLevel+')', a);
                    }
                    if(me.options.maxLevel < 1 || a.nivel < me.options.maxLevel) {
                        str += categoryUL(a, me);
                    }
                    if (a.childs  && !jQuery.isEmptyObject(a.childs) ) {
                        str += categoryList( a.childs, me );
                    }
                    if(me.options.maxLevel < 1 || a.nivel < me.options.maxLevel) {
                        str += '</ul>';
                    }
                }
            }
            return str;
        }

        function categoryUL(a, me) {
            return '<ul class="categoUl categoUlLevel'+a.nivel+'" data-clasificatorelem="'+me.id+'">';
        }

        function categoryLi(a, me) {
            var noMove = a.items.move===false ? ' categoNoMove' : ' categoGrab';
            return '<li data-clasificatorelem="'+me.id+'" data-nivel="'+a.nivel+'" data-id="'+a.items.id+'" class="ui-state-default categoLi categoLiLevel'+a.nivel+noMove+'"><span class="categoLabel">' + a.items.label  + '</span>' + toolbarStr(a, me);
        }

        function toolbarStr(a, me) {
            var str = '<p class="categoToolBar">';
            if(me.options.editable) {
                if( ( me.options.maxLevel < 1 ||  a.nivel < me.options.maxLevel) && a.items.add !== false) {
                    str += me.options.btnAdd.replace("%tipo%", a.items.label.replace(/\"/g,'&quote;'));
                }
                if(a.items.edit !== false) {
                    str += me.options.btnEdit.replace("%tipo%", a.items.label.replace(/\"/g,'&quote;'));
                }

                if(a.items.del !== false && ( a.nivel>1 || (me.options.delLevel1 && a.nivel==1) ) ) {
                    str += me.options.btnDel.replace("%tipo%", a.items.label.replace(/\"/g,'&quote;'));
                }
            }
            return str + '</p>';
        }

        function bindButtons(str, me) {
            var xh = $(str);
            xh.find('.categoBtnAdd').on('click', function(){me.$element.Clasificator('_addCat', this);});
            xh.find('.categoBtnEdit').on('click', function(){me.$element.Clasificator('_editCat', this);});
            xh.find('.categoBtnDel').on('click', function(){me.$element.Clasificator('_delCat', this);});
            return xh;
        }

        function heirarchySelects(category, me, myval, selectAnyLevel) {
            var categoryNested = parent2nested(category), id, v, cssClass, indent='&nbsp;', ret='<option></option>';
            if(typeof selectAnyLevel == 'undefined')
                selectAnyLevel = false;


            for (id in categoryNested) {
                if (categoryNested.hasOwnProperty(id)) {
                    v = categoryNested[id];
                    cssClass = 'optgroup' + v.nivel + (v['class'] ? ' '+v['class'] : '');
                    if(!selectAnyLevel && !jQuery.isEmptyObject(v.childs)) {
                        ret += '<optgroup data-clasificatorid="' + id + '" class="' + cssClass + '" label="' + ( v.nivel>1 ? indent.repeat(v.nivel-1) : '') + $('<span>'+v.items.label+'</span>').text() + '">' + heirarchySelectsLevel(v.childs, selectAnyLevel) + '</optgroup>';
                    } else {
                        ret += '<option class="' + cssClass + '" value="' + id + '">' + (v.nivel>1 ? indent.repeat(v.nivel-1) : '') + $('<span>'+v.items.label+'</span>').text() + '</option>' + heirarchySelectsLevel(v.childs, selectAnyLevel);
                    }
                }
            }
            me.$el.html(ret).find(' option[value="' + myval + '"]').prop('selected', 'selected');
        }

        function heirarchySelectsLevel(subcat, selectAnyLevel) {
            var id,v,cssClass, indent='&nbsp;', ret='';
            for (id in subcat) {
                if (subcat.hasOwnProperty(id)) {
                    v = subcat[id];

                    cssClass = 'optgroup' + v.nivel + (v['class'] ? ' '+v['class'] : '');
                    if(!selectAnyLevel && !jQuery.isEmptyObject(v.childs)) {
                        ret += '<optgroup data-clasificatorid="' + id + '" class="' + cssClass + '" label="' + ( v.nivel>1 ? indent.repeat(v.nivel-1) : '') + $('<span>'+v.items.label+'</span>').text() + '">' + heirarchySelectsLevel(v.childs, selectAnyLevel) + '</optgroup>';
                    } else {
                        ret += '<option class="' + cssClass + '" value="' + id + '">' + ( v.nivel>1 ? indent.repeat(v.nivel-1) : '') + $('<span>'+v.items.label+'</span>').text() + '</option>' + heirarchySelectsLevel(v.childs, selectAnyLevel);
                    }
                }
            }
            return ret;
        }

        function ancestorsGet(category, id, me, callbackFunction, cache) {
            var parents, categoryByIds;
            if(cache && me.parents) {
                parents = me.parents;
                categoryByIds = me.categoryByIds;
            } else {
                parents = parentsDeduce(category);
                prepareParentChild(category, parents);
                categoryByIds = category.reduce(function(p,v){ p = p || {}; p[v.id] = v; return p;  }, {} );
                if(cache) {
                    me.parents = parents;
                    me.categoryByIds = categoryByIds;
                }
            }
            callbackFunction(heirarchyGet(id, parents).map(function(v){ if(v!=0) return categoryByIds[v]; else return categoryByIds[id]; }));
        }

////////////////////////////
/// Clasificator chained selects
////////////////////////////
        function chainedSelects(category, me, myval) {
            var parents = parentsDeduce(category), myParents = heirarchyGet(myval, parents).reverse(), myParentsLen = myParents.length, i, selected, ops;
            me.chainedOptions = byLevelToChainedOption(category, me, myval, parents);
            for(i=1;i<me.upToLevel;i++) {
                selected = myParentsLen > i && myParents[i] ? ' data-clasificatorlastval="' + myParents[i] + '" ' : "";
                if(i===1) {
                    ops = me.chainedOptions[i];
                } else {
                    ops = '';
                }
                $('#'+me.id).before($('<select data-Clasificatorselect="'+me.id+i+'" class="chainedSelectAuto optgroup'+i+'"' + selected + '>'+ops+'</select>'));
            }

            for(i=1;i<me.upToLevel-1;i++) {
                chainedSetTrigger(''+me.id+i, '[data-Clasificatorselect="'+me.id+(i+1)+'"]', i+1, me);
            }
            chainedSetTrigger(''+me.id+i, '#'+me.id, me.upToLevel, me);

            $('#'+me.id).on('change', function(){
                var este=$(this), myval = este.val();
                if(myval) {
                    este.data("clasificatorlastval", myval);
                }
            });

            $('[data-Clasificatorselect="'+me.id+'1"] option[value="' + myParents[1] + '"]').prop('selected', 'selected');
            $('[data-Clasificatorselect="'+me.id+'1"]').trigger('change');
        }

        function chainedSetTrigger(master, slave, level, me) {
            $('[data-Clasificatorselect="'+master+'"]').on('change', function(){
                var este=$(this), myval = este.val(),
                    $child=$(slave),
                    childLast = $child.data('clasificatorlastval');
                if(myval) {
                    este.data('clasificatorlastval', myval);
                }
                $child.html(me.chainedOptions[level][myval] || '');
                if($child.find('option').length==2) {
                    $child.find('option:eq(1)').attr('selected', 'selected');
                }
                if(childLast) {
                    $child.find(' option[value="' + childLast + '"]').prop('selected', 'selected');
                }
                $child.trigger('change');
            });
        }

        function byLevelToChainedOption(category, me, myval, parents) {
            prepareParentChild(category, parents );
            return category.reduce(function(p, v) {
                var n = v.nivel;
                v['class'] = 'optgroup' + n + (v['class'] ? ' '+v['class'] : '');
                if(n > me.upToLevel) {
                    me.upToLevel = n;
                }
                if(n==1) {
                    if(!p[n]) {
                        p[n] = '<option></option>';
                    }
                    p[n] += '<option value="'+v.id+'"' + (v['class'] ? ' class="optgroup'+n+' '+v['class'].replace(/\"/g, "'")+'"' : '' )  + '>' + $('<span>'+v.label+'</span>').text() + '</option>';
                } else {
                    if(!p[n]) {
                        p[n] = {};
                    }
                    if(!p[n][v.prt]) {
                        p[n][v.prt] = '<option></option>';
                    }
                    p[n][v.prt] += '<option value="'+v.id+'"' + (v['class'] ? ' class="optgroup'+n+' '+v['class'].replace(/\"/g, "'")+'"' : '' )  + '>' + $('<span>'+v.label+'</span>').text() + '</option>';
                }
                return p;
            }, []);
        }


////////////////////////////
/// Activate jQuery: instantiate:
///         $().pluginName({options}).
///         execute $().pluginName('method', params, ..)
///         read option $().pluginName('option', 'option name')
///         modify option  $().pluginName('option', 'option name', new value)
////////////////////////////
    $.fn[pluginName] = function(option) {
		var args = $.makeArray(arguments).slice(1),
			result;

		this.each(function() {
			var $this = $(this),
				data = $.data(this, 'plugin_' + pluginName),
				options = typeof option === 'object' && option;
			if (!data) {
				$this.data('plugin_' + pluginName, data = new Clasificator(this, options));
			}
			// if first argument is a string, call silimarly named function $('.d').plugin('destroy');  $('.d').plugin('option', 'key');
			if (typeof option === 'string') {
                var fn = data[option];
                if (!fn) {
                    throw pluginName + ' - No such method: ' + option;
                }
                result = fn.apply(data, args);
			}
		});
		return result === undefined ? this : result;
	};

})(jQuery, window, document);