
let comprobandoTotales = {};

comprobandoTotales.metodos = {
    comprobando: function (totales=[], grid='', conf={}) {

        if(Object.keys(conf).length) return this.comprobandoExistencia(totales, grid, conf);

        if(!totales || !grid) return;
        //buscando en que página estamos
        const pagina = window.location;
        const paginaActual = pagina.pathname;

       
        
        switch (true) {

            case paginaActual.includes('/pedido/pedido.php'):
                this.comprobandoChina(totales, grid);
                break;
        
            default:
                console.log('No estamos en la pagina de pedidos');
                break;
        }
    }, 
    comprobandoExistencia: function (totales, grid, conf) {
        const dialogoExistencias = conf.esDialogo || false;
        const not_found = conf.not_found || false;
        const fns= this;

        if(not_found) return fns.setEmptyTotales();

       switch (dialogoExistencias) {
        case dialogoExistencias==='existencia':
            
            fns.comprobandoTotalesExistencia(totales, grid, conf);
            break;
       
        default:
            console.log('No se ha seleccionado ninguna opción');
            break;
       }
    },
    comprobandoTotalesExistencia: function (totales, grid, conf) {
        const {data} = conf;

        const fns = this;
        if(!data) return;

        $.ajax({
            url: '../backoffice/ajax/comprobarTotales.php',
            type: 'POST',
            data: {
                ...data,
                accion: 'comprobarExistencia',
            },
            success: function (response) {
            
                const totalesBD = response.totales;
                const totalesKeys = Object.keys(totales.units);
                let errores = [];
                let aciertos = [];

                totalesKeys.forEach( key => {
                    if(totales.units[key]!==totalesBD[key]){
                        
                        if(totalesBD[key]===undefined) return;
                        
                      const totalesUnits= Object.keys(totales.units[key]);
                      
                    
                        totalesUnits.forEach( unit => {

                           let totalU = totales.units[key][unit] ?? null
                           let totalBD = totalesBD[key][unit] ?? null;

                            if(!totalU || !totalBD) return;

                           
                            const totalCalculado = parseFloat(totalU).toFixed(2);
                            totalBD= parseFloat(totalesBD[key][unit]).toFixed(2);

                            const info= {
                                campo: key,
                                totalCalculado,
                                unit: unit,
                                totalBD,
                                errorMsj: null
                            };

                            if(totalCalculado!==totalBD){
                                info.errorMsj = `El total de ${key} no coincide. Total: ${numFormatter(totalCalculado,2)} Total calculado: ${numFormatter(totalBD,2)}`;
                                errores=[...errores, info];
                            }else
                                aciertos=[...aciertos, info];

                        });

                    
                    }});

                if(errores.length>0)
                    //modificando el html de los totales
                fns.setExistenciaTotales(errores, true);

                if(aciertos.length>0)
                    fns.setExistenciaTotales(aciertos);

                
            },
            error: function (error) {
                console.log(error);
            }
        });
    },
    setEmptyTotales: function (totales, grid, conf) {
        

    },
    comprobandoChina: function (totales, grid) {

        //buscando si total es un array
        if(Array.isArray(totales)) return;
        
        //obteniendo filtro de la tabla
        const filtros = grid.jqGrid('getGridParam', 'postData') || null;
        let filtrosAplicados = null;

        //verificando si hay filtros
        try {
            if(filtros.filters)
            filtrosAplicados = filtros ? JSON.parse(filtros?.filters) : null;
        } catch (error) {
            filtrosAplicados = null;
        }

        //si no hay filtros no hacemos nada
       
        if(!filtrosAplicados) return;


        //verificando si hay filtros aplicados
        let rules = filtrosAplicados?.rules || null;
        if(Object.keys(rules).length===1 && rules[0].field==='activo') 
            filtrosAplicados.groupOp = 'AND';
        
        //haciendo la petición ajax
        $.ajax({
            url: '../backoffice/ajax/comprobarTotales.php',
            type: 'POST',
            data: {
                accion: 'comprobarChina',
                totales: totales,
                filtros:{ filtros: filtrosAplicados, setWhere: filtros.iacwhere}
            },
            success: function (response) {
                //verificando si hay error
                if(!response.status){
                    ia.alertError('Error', response.message || 'Error al comprobar totales');
                    return;
                }
                //si no hay error comprobamos los totales

                comprobandoTotales.metodos.validarTotalesChina(totales, response.totales );
                
            },
            error: function (error) {
                console.log(error);
            }
        });

    },

    validarTotalesChina: function (totales, totalesCalculados) {
        const totalesKeys = Object.keys(totales);
        let errores = [];
        let aciertos = [];
        let totalesBD= [];

        //haciendo un recorrido de los totales

        totalesKeys.forEach( key => {
            //verificando si el total de la bd es igual al total calculado
            if(totales[key]!==totalesCalculados[key]){
                
                //si el total calculado no existe no hacemos nada
                if(totalesCalculados[key]===undefined) return;
                //convirtiendo a numero los totales
                let total = !totales[key] ? 0.00 : totales[key];
                //pasando a numero los totales
                const totalCalculado = parseFloat(totalesCalculados[key]).toFixed(2);

                total = parseFloat(total).toFixed(2);

                //creando un objeto con la información
                const info= {
                    campo: key,
                    total: total,
                    totalCalculado: totalCalculado, 
                    errorMsj: null
                };

                //si el total no coincide lo agregamos a errores sino a aciertos
                if(total!==totalCalculado){
                    info.errorMsj = `El total de ${key} no coincide. Total: ${total} Total calculado: ${totalCalculado}`;
                    errores=[...errores, info];
                }
                else
                    aciertos=[...aciertos, info];
                
            }
        });
       

        //si hay errores los mostramos en el grid
        if(errores.length>0)
            //modificando el html de los totales
            this.setIconInfo(errores, true);
        //si hay aciertos los mostramos en el grid
        if(aciertos.length>0)
            this.setIconInfo(aciertos);
       
            this.setTotalesFooter(totalesCalculados);

        
    },
    setIconInfo: function (datos, error=false) {
        //recorriendo los datos
        datos.forEach( dato => {
            let campo = dato.campo;
            const errorMsj = dato.errorMsj;
            let id='';
            if(campo.includes('usd'))
                id='#tfootClientes';

            //si tiene usd quitamos el usd
            if(id)
                campo = campo.replace('_usd', '');
                campo = campo
                    .replace('suma_', '')
                    .replace('_ca', '')
            
            
            //buscando la celda del grid
            let gridCelda= id ? $(`tr${id} td[aria-describedby='iajqgridpedido_${campo}']`) : $(`tr.footrow  td[aria-describedby='iajqgridpedido_${campo}']`).first();
            //operador ternario para saber si es un error o no
            let icono = error ? 'fa-exclamation-circle' : 'fa-check-circle';
            let color = error ? 'red' : 'green';
            let txt_cell = gridCelda.text();

            //icono de error o acierto
            
            let iconoHtml = 
                $('<i></i>',
                    {
                        class: `fa ${icono} mr-2px`,
                    }
                );

                //si hay un mensaje de error se lo agregamos al icono
            if(errorMsj) 
                iconoHtml
                    .attr('title', errorMsj)
                    .tooltip();
            let txt = $('<span></span>', {text: txt_cell});

            //juntando el icono con el texto
            let html = 
                $('<div></div>')
                .css({
                    color: color,
                    fontSize: '0.8rem',
                })
                .append(iconoHtml, txt);

            //modificando el html de la celda
            gridCelda
                .empty()
                .append(html);

        });
    },
    setExistenciaTotales: function (totales,error=false, tableTd=null) {
        //recorriendo los totales
        totales.forEach( total => {
            //haciendo destructuring de los totales
            const {campo, totalCalculado, totalBD, errorMsj} = total;
            let campoTabla;
            //buscando la celda del grid
            if(tableTd) campoTabla = $(tableTd).find(`td[aria-describedby='iajqgridpedido_${campo}']`);
            else campoTabla = $(`td[data-type='${campo}']`);
            
            //si existe la unidad el campoTabla será igual al span con el título de la unidad
            if(total.unit)
                campoTabla= campoTabla.find(`span[title='${total.unit}']`);
            
            //operador ternario para saber si es un error o no
            let icono = error ? 'fa-exclamation-circle' : 'fa-check-circle';
            let color = error ? 'red' : 'green';
            let txt_cell = campoTabla.first().text();
            
            //si hay un mensaje de error se lo agregamos al icono
            let title= errorMsj ? errorMsj : null;

            //icono de error o acierto
            let iconoHtml =
                $('<i></i>',
                    {
                        class: `fa ${icono} mr-2px `,
                        title: title
                    }
                ).css('padding', '0 5px');

            //juntando el icono con el texto
            campoTabla
                .empty()
                .append(iconoHtml, txt_cell)
                .css('color', color);
           

        });
        
    },


    setTotalesFooter: function (totales) {
        for (let clave in totales) {

            if(!clave.includes('total')) continue;
            let claveView = clave.replace('total_', '');


            let gridCelda = $(`tr#tfootTotals td[aria-describedby='iajqgridpedido_${claveView}']`);

            //pasando a numero los totales
            const total = parseFloat(totales[clave]).toFixed(2);
            let totalGrid = gridCelda.text();
            //quitando las comas
            totalGrid = totalGrid.replace(/,/g, '');
            //pasando a numero
            totalGrid = parseFloat(totalGrid).toFixed(2);

            const isError = total!==totalGrid;


            let icono = isError ? 'fa-exclamation-circle' : 'fa-check-circle';
            let color = isError ? 'red' : 'green';
            let txt_cell = gridCelda.text();
            let errorMsj = isError ? `El total de ${claveView} no coincide. Total: ${total} Total calculado: ${totalGrid}` : null;

            let iconoHtml = 
                $('<i></i>',
                    {
                        class: `fa ${icono} mr-2px`,
                    }
                );

            if(errorMsj)
                iconoHtml
                    .attr('title', errorMsj)
                    .tooltip();

            let txt = $('<span></span>', {text: txt_cell});

            let html = 
                $('<div></div>')
                .css({
                    color: color,
                    fontSize: '0.8rem',
                })
                .append(iconoHtml, txt);

            

            gridCelda.empty().append(html);

           
            
          }
    },
    isNotaBodegaContainerSi: function() {
        try {
            const url = new URL(window.location.href);
            return url.pathname.includes('backoffice/nota_bodega.php') && url.searchParams.get('container') === 'si';
        } catch (e) {return true;}
    },
    comprobandoNBTotales: function (totales, grid, conf={}) {
        if(!totales || !grid) return;

        let { iacwhere } = conf;
            try {
                iacwhere = decodeURIComponent(iacwhere);
            } catch (error) {}
        

        let filtros =  grid.jqGrid('getGridParam', 'postData') || null;

        let filtrosAplicados = null;
        //verificando si hay filtros
        if(typeof filtros.filters === "string")
            filtrosAplicados = filtros.filters ? JSON.parse(filtros.filters) : null;
        else if(typeof filtros.filters === "object" && filtros.filters !== null && Object.keys(filtros.filters).length)
            filtrosAplicados = filtros.filters;
       $.ajax({
              url: '../backoffice/ajax/comprobarTotales.php',
              type: 'POST',
              data: {
                accion: 'comprobarNBTotales',
                filtros: filtrosAplicados, 
                setWhere: iacwhere,
                inicio: comprobandoTotales.metodos.isNotaBodegaContainerSi() ? "0" : comprobandoTotales.variables.inicio,
              },
              success: function (response) {
                if(!response.status){
                     ia.alertError('Error', response.message || 'Error al comprobar totales');
                     return;
                }

                const totalesCalculados = response.totales;

                
                comprobandoTotales.metodos.validarTotalesNb(totales, totalesCalculados);

                comprobandoTotales.variables.inicio = 0;
                
              },
              error: function (error) {
                console.log(error);
              }
         });
        
        
    },

    validarTotalesNb : function (totales, totalesCalculados) {
        const validando = comprobandoTotales.helpers.getErrorAccert(totales, totalesCalculados);

        const {errores, aciertos, warnings , totalesBD} = validando;

        let $grid_footer_entradas = $(gridhandler[0].grid.sDiv).find('tr.footrow');
        let $grid_footer_salidas = doGridFooterRowUSD();

        if(errores.length>0){
            errores.forEach( error => {
                const {campo, errorMsj} = error;
                let $cell;
                if(campo.includes('usd'))
                    $cell = $grid_footer_salidas.find(`td[data-tipo='${campo}']`);
                else
                    $cell = $grid_footer_entradas.find(`td[data-tipo='${campo}']`);
                
                comprobandoTotales.helpers.setIcon($cell, true);

                if(errorMsj)
                    $cell
                        .attr('title', errorMsj)
                        .tooltip();

            });
        }

        if(aciertos.length>0){
            aciertos.forEach( acierto => {
                const {campo} = acierto;
                let $cell;
                if(campo.includes('usd'))
                    $cell = $grid_footer_salidas.find(`td[data-tipo='${campo}']`);
                else
                    $cell = $grid_footer_entradas.find(`td[data-tipo='${campo}']`);
                
                comprobandoTotales.helpers.setIcon($cell);
            });
        }

        if(warnings.length>0){
            warnings.forEach( warning => {
                const {campo, errorMsj} = warning;
                let $cell;
                if(campo.includes('usd'))
                    $cell = $grid_footer_salidas.find(`td[data-tipo='${campo}']`);
                else
                    $cell = $grid_footer_entradas.find(`td[data-tipo='${campo}']`);
                
                comprobandoTotales.helpers.setIcon($cell, false, true);

                if(errorMsj)
                    $cell
                        .attr('title', errorMsj)
                        .tooltip();
            });
        }


       
        comprobandoTotales.helpers.setTotalesFooter({totalesBD, $grid_footer_entradas, $grid_footer_salidas});
        
            
      
        

    }
   
}

comprobandoTotales.helpers = {
    getErrorAccert: function (totales, totalesCalculados, fix=2) {
        
        const totalesKeys = Object.keys(totalesCalculados);


        let errores = [];
        let aciertos = [];
        let warnings = [];
        let totalesBD= [];

        //haciendo un recorrido de los totales

        totalesKeys.forEach( key => {
            
            //verificando si el total de la bd es igual al total calculado
            if(totales[key]===undefined) 
                    return totalesBD = [ ...totalesBD ,{
                        campo: key,
                        total: totalesCalculados[key],
                }]


                let isDolar = key.includes('_usd');
            //buscando si el key actual tiene tiene _usd
            let complement= isDolar ? key.replace('_usd', '_ca_usd') : `${key}_ca`;

            let total = totales[key];
            //pasando a numero los totales
            const totalCalculado = parseFloat( totalesCalculados[key]).toFixed(fix);
            
            total = parseFloat( total ).toFixed(fix);

            let $cell = $(`td[data-tipo='${key}']`).text().replace(/,/g, '');
            //pasando a numero
            $cell = parseFloat($cell).toFixed(fix);
            

            //creando un objeto con la información
            const info= {
                campo: key,
                total: total,
                totalCalculado: totalCalculado, 
                warning: false,
                errorMsj: null
            };


            //si el total no coincide lo agregamos a errores sino a aciertos
            if(total!==totalCalculado){
                info.errorMsj = `El total de ${key} no coincide. Total: ${numFormatter(total,2)} Total calculado: ${numFormatter(totalCalculado,2)}`;
                errores=[...errores, info];
            }
            else{
                if($cell===totalCalculado)
                    aciertos=[...aciertos, info];
                else
                {
                    info.warning = true;
                    info.errorMsj = `El total de la BD no coincide con el pintado en la tabla. Total: ${numFormatter($cell,2)} Total calculado: ${numFormatter(totalCalculado,2)}`;
                    warnings=[...warnings, info];
                }
            }
        });

        return {errores, aciertos,warnings, totalesBD};
    },

    setIcon($cell, error=false, warning=false) {
        let icono = error ? 'fa-exclamation-circle' : (warning ? 'fa-exclamation-triangle' : 'fa-check-circle');
        let color = error ? 'red' : (warning ? '#f37000' : 'green');
        let txt_cell = $cell.text();

        let iconoHtml = 
            $('<i></i>',
                {
                    class: `fa ${icono} mr-2px`,
                }
            );

        let txt = $('<span></span>', {text: txt_cell});

        let html = 
            $('<div></div>')
            .css({
                color: color,
                fontSize: '0.8rem',
            })
            .append(iconoHtml, txt);

        $cell
            .empty()
            .append(html);
    },

    setTotalesFooter: function (totalInfo, fix=2) {
        const {totalesBD, $grid_footer_entradas, $grid_footer_salidas} = totalInfo;
        totalesBD.forEach( total => {
            const {campo, total: totalCalculado} = total;
           
            let $cell;
            if(campo.includes('usd'))
                $cell = $grid_footer_salidas.find(`td[data-tipo='${campo}']`);
            else
                $cell = $grid_footer_entradas.find(`td[data-tipo='${campo}']`);

            //tomando el texto de la celda
            let txt_cell = $cell.text();
            //quitando las comas
            txt_cell = txt_cell.replace(/,/g, '');

            //pasando a numero
            txt_cell = parseFloat(txt_cell).toFixed(fix);

            //pasando el número a 2 decimales
            let totalC =  parseFloat(totalCalculado).toFixed(fix);

            const isError = totalC!==txt_cell;

            if(isError){
                const msg= `El total de ${campo} no coincide. Total: ${txt_cell} Total calculado: ${totalC}`;
                $cell
                    .attr('title', msg)
                    .tooltip();
            }
                

            this.setIcon($cell, isError);
        });

    }
};



comprobandoTotales.variables = {
    gridhandler: null,
    inicio: 1,

};