/**
 *
 * @type {{array_symmetric_diff: (function(*, *): *), isEqual: ((function(*, *, boolean=): boolean)|*), array_diff: (function(*, *): *), object_key_symmetric_diff: (function(*, *): Array), array_intersection: (function(*, *): *), object_intersection: (function(*, *, boolean=): {}), version: (function(): string), object_key_intersection: (function(*, *): *[]), array_union_all: (function(*, *): *), array_union_distinct: (function(*, *): *)}}
 */
const conjuntos = {

    version:function() {return "1.2 2023-10-07"; },

    /**
     * intersection ∩, elements in both arrays
     *
     * @param arr1 array
     * @param arr2 array
     * @returns  array elements in both arrays
     */
    array_intersection: function(arr1, arr2) {
        let noObjects_1 = true;
        for(let a of arr1)
            if(typeof a === 'object' && a !== null) {
                hasObjects1 = false;
                break;
            }
        let noObjects_2 = false;
        for(let a of arr2)
            if(typeof a === 'object' && a !== null) {
                noObjects_2 = true;
                break;
            }
        if(noObjects_1 || noObjects_2)
            return arr1.filter(x => arr2.includes(x));

        let interesction = [];
            for(let a1 of arr1)
                for(let a2 of arr2)
                    if(this.isEqual(a1, a2)) {
                        interesction.push(a1);
                        break;
                    }
        return interesction;
    },

    /**
     * symmetric difference Δ (disjunctive union ⊖): elements not in intersection
     *
     * @param arr1 array
     * @param arr2 array
     * @returns array
     */
    array_symmetric_diff: function(arr1, arr2) {
        return arr1.filter(x => !arr2.includes(x))
            .concat(arr2.filter(x => !arr1.includes(x)));
    },

    /**
     *  sets A - B, elements in the first set (elements) not in the second set ( param: notIn)
     *
     * @param elements
     * @param notIn
     * @returns array
     */
    array_diff: function(elements, notIn) {return elements.filter(x => !notIn.includes(x)); },

    /**
     *  union all ∪, elements of both arrays combined
     *
     * @param arr1 array
     * @param arr2 array
     * @returns array
     */
    array_union_all: function(arr1, arr2) {
        return arr1.concat(arr2)
    },

    /**
     *  union distinct ⊔, elements which appear only once in both arrays
     *
     * @param arr1 array
     * @param arr2 array
     * @returns array
     */
    array_union_distinct: function(arr1, arr2) {
        return arr1.concat(arr2).filter((item, index, array) => array.indexOf(item) === index);
    },


    /**
     * key intersection ∩, key is in both objects
     *
     * @param obj1 object
     * @param obj2 object
     * @returns array with the keys in both obj1 and obj2
     */
    object_key_intersection: function(obj1, obj2) {
        let keys_intersect = []
        for(let e in obj1)
            if(obj1.hasOwnProperty(e) && obj2.hasOwnProperty(e))
                keys_intersect.push(e);
        return keys_intersect;
    },

    /**
     * symmetric difference Δ (disjunctive union ⊖): keys not in intersection
     *
     * @param obj1 object
     * @param obj2 object
     * @returns array
     */
    object_key_symmetric_diff: function(obj1, obj2) {
        return this.array_symmetric_diff(Object.keys(obj1), Object.keys(obj2));
    },

    /**
     * intersection ∩, same key and value in both objects
     *
     * @param obj1 object
     * @param obj2 object
     * @param strictComparison boolean default true
     * @returns object with elements in both
     */
    object_intersection: function(obj1, obj2, strictComparison = true) {
        let intersect = {}
        for(let e in obj1)
            if(obj1.hasOwnProperty(e) && obj2.hasOwnProperty(e) && this.isEqual(obj1[e], obj2[e], strictComparison))
                intersect[e] = obj1[e];
        return intersect;
    },

    /**
     * deepEqual, recursive equal
     *
     * @param any1 mixed
     * @param any2 mixed
     * @param strictComparison boolean default true
     * @returns {boolean}
     */
    isEqual: function (any1, any2, strictComparison = true) {
        if(typeof any1 !== 'object' || typeof any2 !== 'object')
             // noinspection EqualityComparisonWithCoercionJS
            return strictComparison ? any1 === any2 : any1 == any2;
        if(any1 === null || any2 === null)
            // noinspection EqualityComparisonWithCoercionJS
            return strictComparison ? any1 === any2 : any1 == any2;
        let props1 = Object.getOwnPropertyNames(any1);
        let props2 = Object.getOwnPropertyNames(any2);
        if (props1.length !== props2.length)
            return false;
        for(let i = 0, len = props1.length; i < len; i++) {
            let val1 = any1[props1[i]];
            let val2 = any2[props1[i]];

            if(isObject(val1) && isObject(val2))
                return this.isEqual(val1, val2, strictComparison);
            if(strictComparison)
                if(val1 !== val2)
                    return false;
                else
                    continue;
            // noinspection EqualityComparisonWithCoercionJS
            if(val1 != val2)
                return false;
        }
        return true;

        function isObject(object) {return object != null && typeof object === 'object';}
    }

}
Object.freeze(conjuntos);
