function eChartsTimeSeries() {
    let timeSeries = {
        // fechas = ['2022-01-01','2022-01-09',..]
        fechas: [],
        // markArea = ['fechaIni', 'fechaFin']
        markArea: [],
        data: [
            {'legend':'Existencias',data:[]},
            {'legend':'Ventas',data:[]},
        ]
    }

    let legend = typeof timeSeries.legend === 'undefined' ? [] : timeSeries.legend;
    let yAxis = typeof timeSeries.yAxis === 'undefined' ? [] : timeSeries.yAxis;
    let series = typeof timeSeries.series === 'undefined' ? [] : timeSeries.series;

    for(let s of timeSeries.series) {
        if(typeof timeSeries.legend === 'undefined')
            legend.push(s.legend);
        if(typeof timeSeries.legend === 'undefined')
            yAxis.push({name: s, type: 'value'});
        if(typeof timeSeries.series === 'undefined')
        series.push({
            name: 'Existencias',
                type: 'line',
            areaStyle: {},
            lineStyle: {width: 1},
            emphasis: {focus: 'series'},
            markArea: {
                silent: true,
                    itemStyle: {opacity: 0.3},
                data: [timeSeries.markArea]
            },
            data: [gExistencia],
        })

    }

    option = {
        title: {text: 'Title', left: 'center'},
        grid: {
            bottom: 80
        },
        toolbox: {
            feature: {
                dataZoom: {
                    yAxisIndex: 'none'
                },
                restore: {},
                saveAsImage: {}
            }
        },
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'cross',
                animation: false,
                label: {
                    backgroundColor: '#505765'
                }
            }
        },
        legend: {
            data: legend,
            left: 10
        },
        dataZoom: [
            {
                show: true,
                realtime: true,
                start: 65,
                end: 85
            },
            {
                type: 'inside',
                realtime: true,
                start: 65,
                end: 85
            }
        ],
        xAxis: [
            {
                type: 'category',
                boundaryGap: false,
                axisLine: {onZero: false},
                data: [timeSeries.fechas].map(function (str) {
                    return str.replace(' ', '\n');
                })
            }
        ],
        yAxis: yAxis,
        series: [
            {
                name: 'Existencias',
                type: 'line',
                areaStyle: {},
                lineStyle: {width: 1},
                emphasis: {focus: 'series'},
                markArea: {
                    silent: true,
                    itemStyle: {opacity: 0.3},
                    data: [timeSeries.markArea]
                },
                data: [gExistencia],
            },
            {
                name: 'Rainfall',
                type: 'line',
                yAxisIndex: 1,
                areaStyle: {},
                lineStyle: {
                    width: 1
                },
                emphasis: {
                    focus: 'series'
                },
                markArea: {
                    silent: true,
                    itemStyle: {
                        opacity: 0.3
                    },
                    data: [timeSeries.markArea],
                },
                data: []
            }
        ]
    };
    return options;
}