

const htmlUtil = {
    version: '2025-04-12',
    checkboxFieldsetTo: function (element) {
        $(element).parent().siblings("INPUT[type='checkbox']").each(function(){this.checked = element.checked;})
    },
    checkboxFieldsetSwap: function (element) {
        $(element).parent().siblings("INPUT[type='checkbox']").each(function(){this.checked = !this.checked;})
    },

    /**
     *
     * @param nameToSet string
     * @param checkedSelected bool true mark all inputs named nameToSet to true or false
     */
    setAll:function(nameToSet, checkedSelected) {
        $(`[name='${nameToSet}']`).each(function(){
            switch(this.tagName) {
                case 'INPUT': this.checked = checkedSelected; break;
                case 'SELECT':
                    for (let option of this.options)
                        option.selected = checkedSelected;
                    if(typeof this.selectize === 'object') // https://github.com/selectize/selectize.js
                        refreshItems();
                    else if(this.classList.contains("multiselect"))
                        $(this).multiselect('refresh');
            }
        })
    },

    allUnSet:function(name, nameAll) {
        let allChecked = true;
        $(`[name='${name}']`).each(function(){
            switch(this.tagName) {
                case 'INPUT':
                    if(!this.checked)
                        allChecked = false;
                    break;
            }
        });
        for(let all of document.getElementsByName(nameAll) )
            all.checked = allChecked;
    },

    setCheckedValue:function(name, value) {
        $(`input[name='${name}'][value='${value}']`).prop('checked',true);
    },

    getValue: function(name) {
        let el = document.getElementsByName(name);
        let values = [];
        for(let e of el ) {
            switch(e.tagName) {
                case 'INPUT':
                    if((e.type !== 'RADIO' && e.type !== 'CHECKBOX') || e.checked)
                        values.push(e.value)
                    break;
            }
        }
        return values;
    },
};
Object.freeze(htmlUtil);
let filterUtil = {
    version:"1.1 2022-03-03",
    limpiaSelectize: function(element, parentElement) {
        let el;
        if(typeof element === 'object')
            el = $(element)[0];
        else {
            if(typeof parentElement === 'undefined')
                el = $(`SELECT[name='${element}']`)[0];
            else
                el = $(`SELECT[name='${element}']`, $(parentElement))[0];
        }
        el.selectize.clear();
        el.selectize.refreshItems();
    },
    fitroClearColores: function() {
        let selectColor = document.getElementById("color_id");
        selectColor.selectize.clear();
        selectColor.selectize.refreshItems();
    },

    fitroClearProductos: function() {
        let selectProducto = document.getElementById('producto_general_id');
        selectProducto.selectize.clear();
        selectProducto.selectize.refreshItems();
    },

    setDate: function(n, max, d) {
        let $dateMin = $("#fecha_min_viewdate");
        let $dateMax = $("#fecha_max_viewdate");
        if (typeof n === "undefined" || n === '') {
            $dateMin.datepicker("setDate", null)
            $dateMax.datepicker('setDate', null);
            return;
        }
        if(typeof n === "undefined" || n === '') {
            $dateMin.datepicker("setDate", null)
            $dateMax.datepicker('setDate', null);
            return;
        }
        if(typeof max !== "undefined" && max !== '' && max !== null) {
            let dMin = n.split('-');
            $dateMin.datepicker("setDate", new Date(parseInt(dMin[0]), parseInt(dMin[1]) -1, parseInt(dMin[2])));
            let d = max.split('-');
            $dateMax.datepicker("setDate", new Date(parseInt(d[0]), parseInt(d[1]) -1, parseInt(d[2])));
            return;
        }
        let date = new Date();
        if(typeof d === 'undefined')
            d = 1;
        switch (n) {
            case 'este_mes':
                $dateMin.datepicker("setDate", new Date(date.getFullYear(), date.getMonth(), 1));
                $dateMax.datepicker("setDate", new Date(date.getFullYear(), date.getMonth() + 1, 0));
                break;
            case 'mes_anterior':
                $dateMin.datepicker("setDate", new Date(date.getFullYear(), date.getMonth() - d, 1));
                $dateMax.datepicker("setDate", new Date(date.getFullYear(), date.getMonth()+ 1, 0));
                break;
            case 'este_ano':
                $dateMin.datepicker("setDate", new Date(date.getFullYear(), 0, 1));
                $dateMax.datepicker("setDate", new Date(date.getFullYear(), 11, 31));
                break;
            default:
                $dateMin.datepicker("setDate", n);
                $dateMax.datepicker("setDate", date);
        }
    },
};
Object.freeze(filterUtil);
