//Inicializa el objeto grupoBodegas
grupoBodegas = {};

//Variables del objeto grupoBodegas
grupoBodegas.vars = {
    grupo:'',
    bodegas:[],
    bodegas_si:[],
    bodegas_no:[],
    clasificador: null,
    tipo: 'bodegas',
};

grupoBodegas.helpers = {
    removerDialogo: function (dialogo) {
        $('.ui-button-icon.ui-icon.ui-icon-closethick').trigger('click');
        if(dialogo.length>0){
            dialogo.remove();
            return true;
        }

        return false;
    },
    setAlerta (msj, tipo) {
        const div= $(`<div>${msj}</div>`);

        let bg_color= tipo==='error' ? 'rgb(255 223 223)' : (tipo==="warning" ? '#fff9cf' : 'rgb(224 255 223)');
        let color= tipo==='error' ? '#c70000' : (tipo==="warning" ? '#ddb000' : 'rgb(34 167 0)');
        div.css({
            'background-color': bg_color,
            'padding': '0.3rem',
            'margin':' 0.8rem 0.3rem',
            'border-left': `5px ${color} solid`,
            'color': color,
            'font-size': '0.7rem',
            'font-weight': 'bold',
            'opacity': '0',
            'width': '100%'
        });
        return div;
    },
    putAlerta (msj, tipo, me=this) {
        $('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').css('position','relative');
        let div_alerta= me.setAlerta(msj, tipo);
        div_alerta.css({
            "width": "30%",
            "position": "absolute",
            "top": "0",
           }).animate({opacity: 1});
        setTimeout(function() {
            $('#titulo_grupo').css('border', '1px solid #f4f4f4');
            div_alerta.remove();
        }, 5000)
        $('.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix').append(div_alerta)
    },
    getGrupos: function(select){
        let tipo= grupoBodegas.vars.tipo;
        $.ajax({
            url: getUrlForAjax('agrupadorColores.php'),
            method: 'POST',
            cache: false,
            data: {accion:`getGruposColores`, tipo},
            dataType: 'json',
        })
        .done(function(data, textStatus, jqXHR) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }
            select.empty();
            select.append(`<option value=""  selected>Seleccione las Bodegas</option>`);
            select.append(data.opciones);

            
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    },
    findElementsGroup:async function(e){
        let id_grupo= e.target.value;
        let nombre_grupo= e.target.options[e.target.selectedIndex].text.trim();
        let tipo= grupoBodegas.vars.tipo;
        //moviendo todos los elementos a No
        let clasificador= grupoBodegas.vars.clasificador;
        clasificador.clasificame("allTo", "No");
        if(id_grupo==='') return grupoBodegas.helpers.restoreTitle();
        await $.ajax({
            url: getUrlForAjax('agrupadorColores.php'),
            method: 'POST',
            cache: false,
            data: {accion:`${tipo}Agrupados`, id_grupo, tipo},
            dataType: 'json',
        })
        .done(function(data, textStatus, jqXHR) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }

            
            $(".boton-borrar").removeClass("ui-button-disabled ui-state-disabled");
            $(".boton-borrar").prop("disabled", false);
            data.colores.forEach(bodega => {
                clasificador.clasificame("moveTo", bodega.bodega_id, 'Si');
            });
            $('.inputGrupo').val(nombre_grupo);
            
            let cuenta= $(".clasificame_count")
            $('.clasificaTitle').text(`Grupo: ${nombre_grupo}`);
            $('.clasificaTitle').append(cuenta);

            let priv= data.privado;
            if(priv==='1')
                $('#selectPrivate').prop('checked', true);
            else
                $('#selectPrivate').prop('checked', false);



        }).fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });


    },
    findBodegaGroup: async function(e){
        let id_grupo= e.target.value;
        let nombre_grupo= e.target.options[e.target.selectedIndex].text.trim();
        let tipo= grupoBodegas.vars.tipo;
        //moviendo todos los elementos a No
        // let clasificador= grupoBodegas.vars.clasificador;
        // clasificador.clasificame("allTo", "No");
        if(id_grupo==='') return grupoBodegas.helpers.restoreTitle();

        await $.ajax({
            url: '/vitex/backoffice/ajax/nota_form_acciones.php',
            method: 'POST',
            cache: false,
            data: {
                accion:'bodegasAgrupados',
                id_grupo, tipo
            },
            dataType: 'json',
        })
            .done(function(data, textStatus, jqXHR) {
                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax failed url:", this.url);
                    return;
                }

                grupoBodegas.helpers.openUrlWithArrayParams('/vitex/bodega/edita_movimientos_v2.php?nota_bodega_id=' + data.last_nota.nota_bodega_id, data.bodegas_id_list)



            }).fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                console.log('ajax failed: ' + this.url, arguments);
            });


    },
    restoreTitle: function(){
        let cuenta= $(".clasificame_count")
        let resumen= $('.clasificaResumen');
        $('.clasificaTitle').text('Crea Grupos de Bodegas');
        $('.clasificaTitle').append(cuenta, resumen);
        $("#btnBorrar").addClass("ui-button-disabled ui-state-disabled");
        $("#btnBorrar").prop("disabled", true);
        $('.inputGrupo').val('');
        $('#selectPrivate').prop('checked', false);

    },
    openUrlWithArrayParams: function (baseUrl, bodegaIds) {
        const params = `bodegas_list=${encodeURIComponent(bodegaIds.join(','))}`;
        const fullUrl = `${baseUrl}&${params}`;
        window.open(fullUrl, '_blank');
    },
    
};

//Funciones del objeto grupoBodegas
grupoBodegas.fns = {
    init: function(){

        //buscando si estoy en la página de bodegas
        let iconGroup = $('.group-style');
        const pagina = window.location.pathname;
        if(pagina.includes('bodega.php') && !iconGroup.length)
            grupoBodegas.fns.addIconoGrupos();
            
        else
            if(iconGroup.length && !pagina.includes('bodega.php'))
                iconGroup.on('click', this.mostrarGrupos);

        if($('#selectByGroup').length) {
            $('#selectByGroup').html('');
            grupoBodegas.fns.createSelectGroups($('#selectByGroup'))
        }
       
    },
    addIconoGrupos: function(){

        //console.log('agregando icono de grupos');
        //buscando el icono de bancos en el menu
       const bancos = $('#iaBancos');
       //buscando el td más cercano
         const td = bancos.closest('td');
         
 
         //creando un nuevo td
         const tdNuevo = $('<td></td>');
         //agregando el nuevo td después del td encontrado
         tdNuevo.insertAfter(td);
 
         //creando un nuevo icono
         const icono = 
             $('<i></i>',{
                 class: 'fa-solid fa-layer-group pointer group-style',
                 title: 'Grupos Bodegas',
             });
 
         icono.on('click', this.mostrarGrupos);
 
         //creando parrafo informativo
         const parrafo = $('<p></p>',{
             text: 'Grupos de Bodegas',
             class: 'text-center fs-12 font-bold',
         });
 
         let div = $('<div></div>',{
             class: 'd-flex flex-col justify-content-center align-items-center gap-0 mxw-85',
         });
 
         div.append(icono, parrafo);
 
         //agregando el icono al td
         tdNuevo.append(div);
    },

    getBodegas: async function () {
        let request = {
            url: getUrlForAjax('nota_form_acciones.php'),
            data: {
                accion: 'getBodegasPorUsuario',
            }
        };
        return await jqAjaxAsync(request);
    },

    mostrarGrupos: async function(){

        let stopProcess= grupoBodegas.helpers.removerDialogo($('#dialogoClasificadorBodegas'));
        // console.log('stopProcess', stopProcess);
        if(stopProcess) return;

        // traer bodegas por usuario
        var bodegas = $vitex_globales.es_usuario_tipoRony ? $vitex_globales.g_cat_bodega : (await grupoBodegas.fns.getBodegas()).bodegas;

        grupoBodegas.vars.bodegas =
            bodegas.map(bodega => { return {bodega_id: bodega.bodega_id, bodega: bodega.bodega};} );

        let dialogoClasificador = $('<div></div>',{
            id: 'dialogoClasificadorBodegas',
            class: 'dialogoClasificadorBodegas',
        });

        let divGruposInfo = $('<div></div>',{
            class: 'd-flex justify-content-evenly align-items-center',
        });

        grupoBodegas.fns.createDivsInfoGroups(divGruposInfo);

        let setPrivatediv = $('<div></div>',{
            class: 'd-flex justify-content-center align-items-center',
        });

        grupoBodegas.fns.createDivsPrivate(setPrivatediv);

        let divContainerClasificador = $('<div></div>',{
            id: 'divContainerClasificador',
        });

        let divClasificame = $('<div></div>',{
            id: 'divClasificameBodegas',
        });
        dialogoClasificador.append(divGruposInfo,setPrivatediv, divContainerClasificador);
        divContainerClasificador.append(divClasificame);

        grupoBodegas.fns.createClasificador(divClasificame);



        grupoBodegas.fns.createDialog(dialogoClasificador);


    },

    createSelectGroups: function(divGruposInfo) {

        let divDisplayGroups = $('<div></div>', {
            class: 'd-flex justify-content-center align-items-center',
        });

        let selectAgrupar = $('<select style="border-radius: 3px; font-weight: 500; width: 200px; height: 27px;"></select>', {
            class: 'selectAgrupar select-custum',
            id: 'selectGrupos',
        });

        selectAgrupar.on('change', grupoBodegas.helpers.findBodegaGroup);
        let opcSeleccione = $('<option></option>', {
            text: 'Seleccione las Bodegas',
            value: '',
            selected: true,
            disabled: true,
        });

        selectAgrupar.append(opcSeleccione);
        divDisplayGroups.append(selectAgrupar);

        divGruposInfo.append(divDisplayGroups);
        grupoBodegas.helpers.getGrupos(selectAgrupar);
    },

    createDivsInfoGroups: function(divGruposInfo){

        let divDisplayGroups = $('<div></div>',{
            class: 'd-flex justify-content-center align-items-center',
        });

        let labelAgrupar = $('<label></label>',{
            text: 'Agrupar Bodegas',
            class: 'fs-12 font-bold',
            for: 'selectGrupos',
        });

        let selectAgrupar = $('<select></select>',{
            class: 'selectAgrupar select-custum',
            id: 'selectGrupos',
        });

        selectAgrupar.on('change', grupoBodegas.helpers.findElementsGroup);


        let opcSeleccione = $('<option></option>',{
            text: 'Seleccione las Bodegas',
            value: '',
            selected: true,
            disabled: true,
        });

        selectAgrupar.append(opcSeleccione);

        divDisplayGroups.append(labelAgrupar, selectAgrupar);

        let divGroupSelected = $('<div></div>',{
            class: 'd-flex justify-content-center align-items-center',
        });

        let labelGrupo = $('<label></label>',{
            text: 'Elije un nombre para el grupo',
            class: 'fs-12 font-bold',
        });

        let inputGrupo = $('<input></input>',{
            class: 'inputGrupo input-custum w-80',
            type: 'text',
        });

        divGroupSelected.append(labelGrupo, inputGrupo);

        divGruposInfo.append(divDisplayGroups, divGroupSelected);

        grupoBodegas.helpers.getGrupos(selectAgrupar);

    },

    createDivsPrivate: function(setPrivatediv){
        const divPrivate = $('<div></div>',{
            class: 'd-flex justify-content-center align-items-center mt-3',
        });

        const labelPrivate = $('<label></label>',{
            text: 'Hacer grupo privado (Solo visible para mi)',
            class: 'fs-12 font-bold fs-gray-600',
            for: 'selectPrivate',
        });

        const inputPrivate = $('<input></input>',{
            class: 'inputPrivate',
            type: 'checkbox',
            id: 'selectPrivate',
        });

        divPrivate.append(labelPrivate, inputPrivate);

        setPrivatediv.append(divPrivate);
    },
    createClasificador: function(divClasificame){

        grupoBodegas.vars.clasificador =
            divClasificame.clasificame({
                'clasificacion': [
                    {clasificaId:'Si', label:'Si', title:'Agrega a Grupo'},
                    {clasificaId:'No', label:'No', title: 'Descartar'},
                ],
                valueId: 'bodega_id',
                valueDisplay: 'bodega',
                valueColumnKey: 'active',
                values: grupoBodegas.vars.bodegas,
                title:'Crea Grupos de Bodegas',
                label_sort: 'Bodegas',
                editable: true,
                modalGroup: true
            })
    },
    createDialog: function(dialogoClasificador){
        dialogoClasificador.dialog({
            title:  "Crea Grupo de Bodegas",
            closeOnEscape: true,
            width: 'auto',
            buttons: [
                {
                    text: 'Ver Notas',
                    icon: 'ui-icon-document',
                    class: '',
                    id: "verNotas",
                    click: function() {
                        grupoBodegas.fns.verNotas();
                    }
                },
                {
                    text: 'Guardar',
                    icon: 'ui-icon-disk',
                    class: 'none',
                    id: "botonGuardar",
                    click: function() {
                        console.log("boton dentro de dialogo");
                    }
                },
               {
                    text: 'Nuevo',
                    icon: 'ui-icon-plus',
                    click: function() {
                       grupoBodegas.fns.nuevoGrupo();

                    }
                },
                {
                    text: 'Borrar',
                    icon: 'ui-icon-trash',
                    class: 'boton-borrar',
                    disabled: true,
                    id: 'btnBorrar',
                    click: function() {

                        grupoBodegas.fns.borrarGrupo();
                    }

                },
                {
                    text: 'Cancelar',
                    icon: 'ui-icon-cancel',
                    click: function() {
                        $(this).dialog('close');
                    }
                },
            ],

            close: function() {
                $('#dialogoClasificadorBodegas').remove();
            },
        });

        let boton_guardar_grupos= $(`<button type="button" id="btnUsersGuardar" class="ui-button ui-corner-all ui-widget"><span class="ui-button-icon ui-icon ui-icon-disk"></span><span class="ui-button-icon-space"> </span>Guardar</button>`).insertAfter("#botonGuardar");
        boton_guardar_grupos.on('click', grupoBodegas.fns.guardarGrupos);
    },
    verNotas: async function () {
        let clasificador = grupoBodegas.vars.clasificador;
        selection = clasificador.clasificame('value');

        if (empty(selection.Si)) {
            grupoBodegas.helpers.putAlerta('Bodegas no seleccionadas ', 'error');
            return;
        }
        var nota = await grupoBodegas.fns.getNotasPorBodega(selection.Si);
        grupoBodegas.helpers.openUrlWithArrayParams('/vitex/bodega/edita_movimientos_v2.php?nota_bodega_id=' + nota.last_nota.nota_bodega_id, selection.Si)
    },
    getNotasPorBodega: async function(bodegas_id){
        let request = {
            url: getUrlForAjax('nota_form_acciones.php'),
            data: {
                accion: 'getNotasPorBodega',
                bodegasIds: bodegas_id
            }
        };
        return await jqAjaxAsync(request);
    },

    guardarGrupos: function(){
        let clasificador= grupoBodegas.vars.clasificador;
        selection= clasificador.clasificame('value');

        let nombre_del_grupo= $('.inputGrupo').val();
        if(nombre_del_grupo===''){
            grupoBodegas.helpers.putAlerta('Debe ingresar un nombre para el grupo', 'error');
            return;
        }
        let privado= $('#selectPrivate').prop('checked') ? 1 : 0;
        let tipo= grupoBodegas.vars.tipo;
        $.ajax({
            url: getUrlForAjax('agrupadorColores.php'),
            method: 'POST',
            cache: false,
            data: {accion:`agrupandoColores`, seleccion: selection, nombre_del_grupo, tipo, privado},
            dataType: 'json',
            success: function(data){
                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax failed url:", this.url);
                    return;
                }
                selection.Si.forEach(si => {
                    clasificador.clasificame("moveTo", si, 'No');
                });

                grupoBodegas.helpers.getGrupos($('#selectGrupos'));
                grupoBodegas.helpers.putAlerta('Grupos guardados correctamente', 'success');

                $('.inputGrupo').val('');
                let cuenta= $(".clasificame_count")
                $('.clasificaTitle').text('Crea un grupo de usuarios');
                $('.clasificaTitle').append(cuenta);
                $('#selectPrivate').prop('checked', false);
            },
            error: function(error){
                grupoBodegas.helpers.putAlerta('Error al guardar los grupos', 'error');
            }
        });
        
    },
    nuevoGrupo: function(){
        //obteniendo valores seleccionados
        let clasificador= grupoBodegas.vars.clasificador;
        selection= clasificador.clasificame('value');
        let nombre_del_grupo= $('.inputGrupo');
        let selectGrupos= $('#selectGrupos');

        //pasar todos los seleccionados a No
        clasificador.clasificame("allTo", "No");;
        //limpiar el input
        nombre_del_grupo.val('');
        //limpiar el select
        selectGrupos.val('');

        grupoBodegas.helpers.restoreTitle();

    },
    borrarGrupo: function(){
        let id_grupo= $('#selectGrupos').val();

        if(id_grupo==='') return grupoBodegas.helpers.putAlerta('Debe seleccionar un grupo para borrar', 'error');
        let tipo= grupoBodegas.vars.tipo;
        $.ajax({
            url: getUrlForAjax('agrupadorColores.php'),
            method: 'POST',
            cache: false,
            data: {accion:`deleteGroup`, id_grupo},
            dataType: 'json',
            success: function(data){
                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax failed url:", this.url);
                    return;
                }
                let clasificador= grupoBodegas.vars.clasificador;
                clasificador.clasificame("allTo", "No");
                grupoBodegas.helpers.getGrupos($('#selectGrupos'));
                grupoBodegas.helpers.putAlerta('Grupo borrado correctamente', 'success');
                grupoBodegas.helpers.restoreTitle();
            },
            error: function(error){
                grupoBodegas.helpers.putAlerta('Error al borrar el grupo', 'error');
            }
        });
    },
   

    
};

//Inicializa el objeto grupoBodegas
$(document).ready(function(){
    grupoBodegas.fns.init();
});