// on remove y on add debe ser en object.subObject()
    $(function(){
        $.views.settings.trigger(false); // Trigger on blur/change.
       $.views.converters({
            number: function(n, decimals) {
                if(n === '' || n === null)
                    n = 0;
                if(isNaN(n))
                    return n;
                if(typeof decimals === 'undefined')
                    decimals = 2;
                return $("<span/>").text(n).autoNumeric({mDec:decimals,vMax:99999999999.99,vMin:-99999999999.99}).text();
            },
            auto: function(n, decimals) {
                if(n === '' || n === null)
                    return '';
                return $.views.converters.number(n, decimals);
            },
            currency: function(n, decimals) {
                if(n === '' || n === null)
                    n = 0;
                if(isNaN(n))
                    return n;
                if(typeof decimals === 'undefined')
                    decimals = 2;
                return $("<span/>").text(n).autoNumeric({mDec:decimals, aSign:'$',vMax:99999999999.99,vMin:-99999999999.99}).text();
            },
            percent100: function(n, decimals) {
                if(n === '' || n === null)
                    n = 0;
                if(isNaN(n))
                    return n;
                if(typeof decimals === 'undefined')
                    decimals = 2;
                return $("<span/>").text(n).autoNumeric({mDec:decimals,pSign:'s',aSign:'%',vMax:99999999999.99,vMin:-99999999999.99}).text();
            },
            percent: function(n, decimals) {
                if(n === '' || n === null)
                    n = 0;
                if(isNaN(n))
                    return n;
                if(typeof decimals === 'undefined')
                    decimals = 2;
                return $("<span/>").text(n*100).autoNumeric({mDec:decimals,pSign:'s',aSign:'%',vMax:99999999999.99,vMin:-99999999999.99}).text();
            },
            "dateHoy":function(val) {
             if(typeof val !== "string" || val === null) return '';
              var d = new Date(), hoy=d.toISOString().substr(0,10);
              if(val.startsWith(hoy))
                return " Hoy " + val.substr(11,5);
              return val.substr(0,16);
            },
            "upper": function(val) {return val.toUpperCase();},
            "lower": function(val) {return val.toLowerCase();},
            "ucwords":function(str) {
                        if(typeof str !== 'string')
                            return str;
                        var ucnocaps = /^(a|e|i|o||u|y|al|alas|de|del|el|en|la|le|los|un|una|unas|uno|unos|mas|ms|ie|i\.e[\.\:]|etc\.?|pg\.?|pag\.?|pg\.?)$/i;
                        return str.replace(/[A-Za-z0-9\u00C0-\u00FF]+[^\s-]*/g, function(match, index, title){
                            if (index > 0 && index + match.length !== title.length &&
                              match.search(ucnocaps) > -1 && title.charAt(index - 2) !== ':' &&
                              (title.charAt(index + match.length) !== '-' || title.charAt(index - 1) === '-') &&
                              title.charAt(index - 1).search(/[^\s-]/) < 0
                            ) {
                                return match.toLowerCase();
                            }

                            if (match.substr(1).search(/[A-Z]|\../) > -1) {
                                return match;
                            }
                            return match.charAt(0).toUpperCase() + match.substr(1);
                        });
                    },
            "labelit":function(str) {
                if(typeof str !== "string" || str === null) return '';
                var uncamelized = str.replace(/([a-z](?=[A-Z0-9]))/g, '$1 ').toLowerCase().replace(/^[a-z]/, function(v) { return v.toUpperCase(); });
                return $.views.converters.ucwords(uncamelized.replace(/\_/g, ' ').trim());
            },

        });
    });

///////////
// Crea un jsViewModel apartir del jsonData
/////////
    /*
        Crea un jsViewModel apartir del jsonData.
        json_viewsViewModel(modelName, jsonData, ids)

        supone
            primera propiedad llamada xxx_id o id es el unique id
            jsonData trae el modelo completo, todas las posibles propiedades en todos los niveles
            si una propiedad (ejemplo movs) es un array de propiedades hace su viewModel llamado Movs
            si una propiedad (ejemplo totales) es un objecto {t1:14,count=9} hace su viewModel llamado Totales
            si una propiedad (ejemplo fechas) es un array simple [1,2,3], se queda su getter/setter
        id es importante para que repinte rapido el merge

        ejemplo uso

            var model ={
                'ok': true,
                'error_msg': '',
                'dataArray':  [
                    {array1:1, array2:2}
                ],
                dataObject: {obj1:11,obj2:12},
                'dataTotal':123,
                'page':1,
                'perpage':10,
                'arrsimple':['a','b','c'],
                'soynulo':null,
            }
            var viewModel = json_viewsViewModel('cc',model);
            // en su caso modificar viewModel
            $.views.viewModels(viewModel);
            var cuentas = $.views.viewModels['cc'].map(model);
            cuentas.unmap(); // regresa el modelo normal
id
            o en array
            var a = [model,model,model]
            var viewModelArray = json_viewsViewModel('cc',a);
            sale igual que viewModel sin array

    */
    function json_viewsViewModel(modelName, jsonData, ids) {
        if(Array.isArray(jsonData)) {
            if(jsonData.length === 0)
                throw 'json_viewsViewModel: jsonData is empty array';
            var oneData = jsonData.slice( jsonData.length-1)[0];
            if(oneData !== null && typeof oneData === 'object')
                return viewModel(modelName, oneData, ids);
            throw 'json_viewsViewModel: jsonData is non object array';
        }
        if(typeof jsonData === 'object')
            return viewModel(modelName, jsonData, ids);
        throw 'json_viewsViewModel: jsonData is non object';

        function viewModel(name, model, ids, en) {
            if(typeof en === 'undefined')
                en = {};
            if(Array.isArray(model)) {
                if(model.length === 0) {
                    console.log(name, "hmm, es un array vacio! no hago sub modelo ___________");
                    return;
                }
                var oneData = model.slice( model.length-1)[0];
                if(oneData !== null && typeof oneData === 'object')
                    viewModel(name.charAt(0).toUpperCase() + name.substr(1), oneData, ids, en);
                return;
            }
            if(typeof model !== 'object' || model === null) {
                console.log(name, "hmmm, no fue objeto esperaba un {}  _______________________");
                return;
            }

            var gets=Object.keys(model),
            getters=[] // ["name", // name is a primitive type (string) or {getter: "address", type: "Address"}, // address is of type Address (View Model)]
            ;

            for(var i=0, iLen=gets.length;i<iLen;i++) {
                var p = gets[i], m=model[p];
                if(m !== null && typeof m === 'object' ) {
                    getters[getters.length] = {getter:p, type:p.charAt(0).toUpperCase() + p.substr(1) };
                    viewModel(p.charAt(0).toUpperCase() + p.substr(1), m, ids, en);
                } else {
                    getters[getters.length] = p;
                }
            }

            en[name] = {'getters':getters, extended:{} };
             // id is either a string (the name of a View Model property to be treated as id)
            var idName = deduceIdProperty(name, gets, ids);
            if(typeof idName !== 'undefined') {
                en[name]['id'] = idName;
            }
            return en;
        }
    }

///////////
// Template generators flexbox, pegasus
/////////

    function viewsAutoTemplateDiv_show(name,templateId, jsonData, ids, editable, addDel, topName) {
        var doms = viewsAutoTemplateDiv(name,templateId, jsonData, ids, editable, addDel, topName);
        return `<script id='${templateId}' type='text/x-jsrender'>\r\n\t` +
            doms +
            "\r\n</script>";
    }

    function viewsAutoTemplateDiv_register(name, templateId, jsonData, ids, editable, addDel, topName) {
        var doms = viewsAutoTemplateDiv(name, templateId, jsonData, ids, editable, addDel, topName);
       return $.templates(templateId, doms );
    }

    function viewsAutoTemplateDiv(name, templateId, jsonData, ids, editable, addDel, topName) {
        var endDiv = "\r\n\t</div>", classTopItem = ' iajsViewFlexGroup iajsViewCard';

        if(Array.isArray(jsonData)) {
            if(jsonData.length === 0)
                throw 'viewsAutoTemplateDiv: jsonData is empty array';
            var oneData = jsonData.slice( jsonData.length-1)[0];

            if(oneData !== null && typeof oneData === 'object')
                return  templateModel(templateId, oneData, ids)  + endDiv;
            throw 'viewsAutoTemplateDiv: jsonData is non object array';
        }
        if(typeof jsonData === 'object')
            return templateModel(templateId, jsonData, ids)  + endDiv;
        throw 'viewsAutoTemplateDiv: jsonData is non object';

        function templateModel(name, model, ids, indent, idName) {
            if(typeof indent === 'undefined')
                indent = "\t\t";
             var methodName = name.charAt(0).toLowerCase() + name.substr(1),
                 className = methodName.replace(/\(\)/g,'');
            if(Array.isArray(model)) {
                if(model.length === 0) {
                    console.log(name, "hmm, es un array vacio! no hago sub modelo ___________");
                    return '';
                }
                var oneData = model.slice( model.length-1)[0];
                if(oneData !== null && typeof oneData === 'object') {
                    if(classTopItem.length == 0)
                        classTopItem = " iajsViewCard";
                    return "\r\n" + indent + `{^{for ${methodName}}}` + templateModel(name.charAt(0).toUpperCase() + name.substr(1), oneData, ids, indent + "\t", idName) +
                        "\r\n" + indent + "</div>" + "\r\n" + indent + '{{/for}}';
                    //return templateModel(name.charAt(0).toUpperCase() + name.substr(1), oneData, ids, indent, idName);
                }
                return '';

            }
            if(typeof model !== 'object' || model === null) {
                console.log(name, "hmmm, no fue objeto esperaba un {}  _______________________");
                return '';
            }

            var gets=Object.keys(model), idNameTemp=deduceIdProperty(name, gets, ids);
            if(typeof idName === 'undefined' || typeof idNameTemp !== 'undefined') {
                idName = deduceIdProperty(name, gets, ids); // encuentra el id;

            }
            var controls = [];
            if(typeof idName === 'undefined')
                controls = [`<div class='iajsViewFlexRow'>`];
            else
                controls = [`<div data-link="data-id{:${idName}()}" data-idfield="${idName}" class='iajsViewFlexRow${classTopItem}'>`];
            classTopItem='';

            for(var i=0, iLen=gets.length;i<iLen;i++) {
                var prop = gets[i], label = $.views.converters.labelit(prop),  m=model[prop], p = prop +'()';
                if(typeof m === 'object' ) {
                    var embedded = "\r\n\t" + indent + templateModel(p.charAt(0).toUpperCase() + p.substr(1), model[gets[i]], ids, indent + "\t\t", idName);
                    controls[controls.length] = `\r\n${indent}<div class='iajsViewFlexItem embeds div_${prop}'><label class='label_${prop}'>${label}</label><div>${embedded}\r\n\t${indent}</div>\r\n${indent}</div>`;
                } else {
                    var inputElement;
                    if(editable)
                        inputElement=`<input type='text' class='input_c' name='_${prop}[]' data-link='${p}'/>`;
                    else
                        inputElement=`<span class='span_${prop}'>{^{:${p}}}</span>`;
                    controls[controls.length] = `\r\n${indent}<div class='iajsViewFlexItem div_${prop}'><label class='label_${prop}'>${label}<br />${inputElement}</label></div>`;
                }
            }
            if(addDel && typeof idName !== 'undefined') { // && Array.isArray(jsonData)
               controls[controls.length] = `\r\n\t\t<div class='iajsViewFlexItem iajsViewRemove remove_${topName}' data-link="data-id{:${idName}()}" data-idfield="${idName}" data-prop="${className}"'>X</div>`;
            }
            return controls.join(' ');
        }
    }

///////////
// Template generators table
/////////

    function viewsAutoTemplateTR_show(name, templateId, jsonData, ids, editable, addDel, topName) {
        var doms = viewsAutoTemplateTR(name,templateId, jsonData, ids, editable, addDel, topName);
        return `<script id='${templateId}' type='text/x-jsrender'>\r\n\t` +
            doms +
            "\r\n</script>";
    }

    function viewsAutoTemplateTR_register(name, templateId, jsonData, ids, editable, addDel, topName) {
        var doms = viewsAutoTemplateTR(name, templateId, jsonData, ids, editable, addDel, topName);
        return $.templates(templateId,  doms );
    }

    function viewsAutoTemplateTR(name, templateId, jsonData, ids, editable, addDel, topName) {
        if(Array.isArray(jsonData)) { //<td
            if(jsonData.length === 0)
                throw 'viewsAutoTemplateDiv: jsonData is empty array';
            var oneData = jsonData.slice( jsonData.length-1)[0];
            if(oneData !== null && typeof oneData === 'object')
                return  templateModel(templateId, oneData, ids);
            throw 'viewsAutoTemplateDiv: jsonData is non object array';
        }
        if(typeof jsonData === 'object')
            return templateModel(templateId, jsonData, ids);
        throw 'viewsAutoTemplateDiv: jsonData is non object';

        function templateModel(name, model, ids, indent, idName) {
            if(typeof indent === 'undefined')
                indent = "";
             var methodName = name.charAt(0).toLowerCase() + name.substr(1),
                 className = methodName.replace(/\(\)/g,'');
            if(Array.isArray(model)) {
                if(model.length === 0) {
                    console.log(name, "hmm, es un array vacio! no hago sub modelo ___________");
                    return '';
                }
                var oneData = model.slice( model.length-1)[0];
                if(oneData !== null && typeof oneData === 'object') {
                    return "\r\n" + indent + `{^{for ${methodName}}}` + templateModel(name.charAt(0).toUpperCase() + name.substr(1), oneData, ids, indent + "\t", idName) + "\r\n" + indent + '{{/for}}';
                }
                return '';
            }
            if(typeof model !== 'object' || model === null) {
                console.log(name, "hmmm, no fue objeto esperaba un {}  _______________________");
                return '';
            }

            var gets=Object.keys(model),controls=[], idNameTemp=deduceIdProperty(name, gets, ids);
            if(typeof idName === 'undefined' || typeof idNameTemp !== 'undefined')
                idName = deduceIdProperty(name, gets, ids); // encuentra el id <tr;
            if(typeof idName === 'undefined')
                controls[0]=`\r\n${indent}<tr data-prop="${className}">`;
            else
                controls[0]=`\r\n${indent}<tr data-link="data-id{:${idName}()}" data-idfield="${idName}" data-prop="${className}">`;
            for(var i=0, iLen=gets.length;i<iLen;i++) {
                var prop = gets[i], label = $.views.converters.labelit(prop),  m=model[prop], p = prop +'()';

                if(typeof m === 'object' ) {
                    var embedded = templateModel(p.charAt(0).toUpperCase() + p.substr(1), m, ids, indent + "\t", idName);
                    addButton = addDel && Array.isArray(m) ? `<caption>${prop} <button type="button" class="add_${topName}">Nuevo ${prop}</button></caption>` : '';
                    controls[controls.length] = `\r\n\t${indent}<td class='td_${prop}'>\r\n\t${indent}<table class='tb_${prop}'>${addButton}<tbody>${embedded}\r\n\t${indent}</tbody></table>\r\n${indent}</td>`;
                } else {
                    if(editable) {
                        var inputElement=`<input placeholder='${prop}' type='text' class='input_${prop}' name='${prop}[]' data-link='${p}'/>`;
                    } else {
                        var inputElement=`<span class='span_${prop}' data-link='${p}'></span>`;
                    }
                    controls[controls.length] = `\r\n\t${indent}<td class='td_${prop}'>${inputElement}</td>`;
                }
            }

            if(addDel && typeof idName !== 'undefined') {
                controls[controls.length] = `\r\n\t${indent}<td class='tdRemove'><span class='iajsViewRemove remove_${topName}' data-link="data-id{:${idName}()}" data-idfield="${idName}" data-prop="${className}">X</span></td>`;
            }
            controls[controls.length] = `\r\n${indent}</tr>`;
            return controls.join(' ');
        }
    }

    function tableHeaderPojo(pojo, start) {
        //if(typeof props === 'undefined')
        var props = [];
        var at=pojo[start]['getters'];
        for(var i=0, iLen = at.length; i < iLen; i++) {
            if(typeof at[i] === 'object') {
                props[props.length] = "\r\n\t\t\t<th>"+at[i].getter+"\r\n\t\t\t\t<table class='tableit tableitSubHeader'><thead><tr>" + tableHeaderPojo(pojo, at[i].type) + "\r\n\t\t\t\t</tr></thead></table>";
            } else {
                props[props.length] = "\r\n\t\t\t<th>"+at[i]+"</th>";
            }
        }
        return props.join(' ');
    }

///////////
// Auxiliares
/////////
    function deduceIdProperty(name, gets, ids) {
         // id is either a string (the name of a View Model property to be treated as id) or a function
        if(typeof ids === 'undefined' || typeof ids[name] === 'undefined') {
            if(typeof gets === 'undefined')
                return undefined;
            for(var i=0, iLen=gets.length;i<iLen;i++)
                if(gets[i].endsWith('_id') || gets[i].toLowerCase() === 'id') {
                    return gets[i];
                }
        } else if(typeof ids !== 'undefined' && typeof ids[name] !== 'undefined')
            return ids[name];
        return undefined;
    }

    function formatJson(str) {
        var s='', indent=0, c, prefix='',suffix='',doSep=false,extraTab='';
        for(i=0,iLen=str.length; i<iLen; i++) {
            c=str[i];
            doSep = false;
            prefix='';
            suffix='';
            extraTab='';
            if(c==='{' || c==='[') {indent++; suffix=prefix="\r\n";doSep=true; }
            else if(c==='}' || c===']') {if(indent>0) {indent--; extraTab="\t";} prefix=suffix="\r\n";doSep=true;}
            s += prefix+(doSep ? extraTab + "\t".repeat(indent) : '')+c+suffix+(doSep ? "\t".repeat(indent) : '');
        }
        return s;
    }