// noinspection ES6ConvertVarToLetConst

var it_jqGridNavigateEdit = (function(grid) {
    if(!(this instanceof it_jqGridNavigateEdit))
        return new it_jqGridNavigateEdit(grid);
    if(typeof grid === "string")
        grid = grid[0] === "#" ? $(grid) : $("#" + grid);
    else
        grid = $(grid);

    var version = "2024-05-22";
    var lastRowId = "";
    var optionsRowEditSaveRestore = {
        // true a [Enter] key is used to save the row (method saveRow is called) and [Esc] to cancel editing (method restoreRow is called)
        keys : true,
        //  if keys option is true and defines the jquery binding method. Default is keydown. In some situations keyup can be used in case 'keydown' already is applied.
        keyevent : "keydown",
        // fires after successfully accessing the row for editing, prior to allowing user access to the input fields
        //  oneditfunc: function() {},
        //  or jqGridInlineSuccessSaveRow is called immediately after the request is successful
        successfunc:  function() { return true;},
        // editurl If set to 'clientArray', the data is not posted to the server but rather is saved only to the grid
        url: 'clientArray',
        // posted along with the other values to the server
        extraparam: {accion: 'recomiendaGuarda', tipo: brv.getTipo()},
        // or jqGridInlineAfterSaveRow(ev, rowid, response) called after the data is saved to the server or url is set to 'clientArray'.
        //  aftersavefunc:  function() {},
        // or jqGridInlineErrorSaveRow(ev, rowid, response, satus) called after the data is saved to the server
        // errorfunc:  function() {},
        // or jqGridInlineAfterRestoreRow(ev, rowid) called in restoreRow (in case the row is not saved with success)
        afterrestorefunc:  function() {lastSelection = ''; },
        // boolean. Default true which call the restoreRow method with afterrestorefunc if defined. If set to false the row stay in edit mode when an error occurs.
        restoreAfterError: true,
        mtype: "POST",
        // mixed boolean or number. If true the cursor is positioned at the first editable field. If set to false no cursor position. If  the option is a number it is positioned to the editable field which correspond to this number starting from 0
        focusField : true,
        //  When the url is not clientArray it is possible to show a message during a saving the data
        saveui : "disable",
        //savetext : $.jgrid.getRegional($t,'defaults.savetext'),
        // it executes before editing the row. If the function return false the row will be not edited
        // beforeEditRow :  function() { return true;},
        // before saving the row. If the function return false the row will be not be saved
        beforeSaveRow : function() {lastSelection = "";  return true;},
        // before restoring the row to its original state in restoreRow method. If the function return false the row will be not be restored
        beforeCancelRow: function() { return true;},
        // validationCell(elem, error, iRow, iCol)  replace the error message dialog, that appear when a validation error occur
        validationCell: function() { return true;},
        // onEnter( rowid, options, event). executed when a Enter key is pressed while editing the input element. saving the row is not performed
        // onEnter : null,
        // onEscape( rowid, options, When the event is executed the row is not restored.
        // onEscape : null
    };



    /**
     * Normalmente llamada desde jqGrid.onSelectRow o jqGrid.onCellSelect ver el ejemplo.
     *
     * @param {string} id
     */
    function rowEdit(id) {
        rowSave();
        if(id !== lastRowId) {
            lastRowId = id;
            grid.jqGrid("editRow",id, optionsRowEditSaveRestore);
        }
    }

    /**
     * Guarda el row: lastRowId
     */
    function rowSave() {
        if(lastRowId.length) {
            grid.jqGrid("saveRow", lastRowId, optionsRowEditSaveRestore);
            lastRowId = "";
        }
    }

    /**
     * Cancela la edición del row lastRowId
     */
    function rowCancel() {
        if(lastRowId.length)
            grid.jqGrid("setGridParam", { inlineNav: false }).jqGrid("restoreRow", lastRowId, optionsRowEditSaveRestore);
        lastRowId = "";
    }

    /**
     * Navigate the grid with keys while ROW editing
     * Normalmente llamada desde editoptions.dataEvents: [{type: "keydown", fn: it_jqGridNavigateEditInstancia.navigateEditingRow}]
     *
     * @param {KeyboardEvent} event
     */
    function navigateEditingRow(event) {
        switch(event.which) {
            case 27:
                event.stopImmediatePropagation();
                event.stopPropagation();
                event.preventDefault();
                rowCancel();
                break;
            //case 9: // tab
            case 13: // enter
            case 33: // page up
            case 34: // page down
            case 38: // arrow up
            case 40: // arrow down
                event.stopImmediatePropagation();
                event.stopPropagation();
                event.preventDefault();
                var previousRowId = lastRowId;
                rowSave();
                var navigate;
                switch(event.which) {
                    case 33: navigate = -10; break;
                    case 38: navigate = -1; break;
                    case 34: navigate = 10; break;
                    case 40: navigate = 1; break;
                    default: navigate = event.shiftKey ? -1 : 1;
                }
                var nextTr = _trGet(previousRowId, navigate);
                if(nextTr.attr("id")) {
                    scrollToTR(previousRowId, nextTr)
                    rowEdit(nextTr.attr("id"));
                }
        }
    }

    /**
     * Navigate the grid with keys while viewing in read only mode ie NOT editing
     * Normalmente llamada desde
     *
     * @param  event
     */
    function navigateReadOnly(event) {

        switch(event.which) {
            case 13: // enter
                var navigate13 =  1;
                if(event.whichPrevious === 38) {
                    navigate13 = -1;
                }
                else if(event.shiftKeyPrevious)
                    navigate13 = -1;
                var currentRowId13 = lastSelection || grid.jqGrid("getGridParam", "selrow");
                var nextTr13 = _trGet(currentRowId13, navigate13);
                if(nextTr13.attr("id")) {
                    scrollToTR(currentRowId13, nextTr13);
                    if(event.doEdit)
                        editTheRow(nextTr13.attr("id"), typeof event.whichPrevious !== "undefined" &&  event.whichPrevious !== 13);
                }
                break;
            case 9: // tab
            case 33: // page up
            case 34: // page down
            case 38: // arrow up
            case 40: // arrow down
                event.stopImmediatePropagation();
                event.stopPropagation();
                event.preventDefault();
                var navigate;
                switch(event.which) {
                    case 33: navigate = -10; break;
                    case 38: navigate = -1; break;
                    case 34: navigate = 10; break;
                    case 40: navigate = 1; break;
                    default: navigate = event.shiftKey ? -1 : 1;
                }
                var currentRowId = grid.jqGrid("getGridParam", "selrow");
                var nextTr = _trGet(currentRowId, navigate);
                if(nextTr.attr("id")) {
                    scrollToTR(currentRowId, nextTr);
                   if(event.doEdit)
                        editTheRow(nextTr.attr("id"), false);
                } else {
                    console.log("                  no encontre next id", navigate);
                }
                return;
            case 35: // fin/end
                event.stopImmediatePropagation();
                event.stopPropagation();
                event.preventDefault();
                var rows = grid.jqGrid("getDataIDs");
                if(rows.length === 0)
                    return;
                if(event.ctrlKey) {
                    var last = rows[rows.length - 1];
                    grid.jqGrid("setSelection", last , true);
                    grid.jqGrid("focusBodyCell", rows.length, 0);
                    return;
                }
                var numCols = 0;
                var n = -1;
                var TD = $("#" + rows[0]).children("TD");
                for(var e in TD ) if(TD.hasOwnProperty(e)) {
                    if(TD[e].tagName === "TD") {
                        n++;
                        if($(TD[e]).is(":visible"))
                            numCols = n;
                    }
                }
                var selectedRowId = grid.jqGrid("getGridParam", "selrow");
                if(typeof selectedRowId !== "undefined" && selectedRowId !== null) {
                    grid
                        .jqGrid("setSelection", selectedRowId, true)
                        .jqGrid("focusBodyCell", grid.jqGrid("getInd", selectedRowId), numCols);
                }
                return;

            case 36: // inicio/home
                event.stopImmediatePropagation();
                event.stopPropagation();
                event.preventDefault();
                if(event.ctrlKey) {
                    grid.jqGrid("setSelection", grid.jqGrid("getDataIDs")[0], true).jqGrid("focusBodyCell", 1, 0);
                    return;
                }
                var selectedRowHomeId = grid.jqGrid("getGridParam", "selrow");
                if(typeof selectedRowHomeId === "undefined" || selectedRowHomeId === null)
                    return;
                grid.jqGrid("focusBodyCell", grid.jqGrid("getInd", selectedRowHomeId), 0).jqGrid("setSelection", selectedRowHomeId, true);
        }
    }

    /**
     * Navigate the grid with keys while CELL editing
     * Normalmente llamada desde editoptions.dataEvents: [{type: "keydown", fn: it_jqGridNavigateEditInstancia.navigateEditingRow}]
     *
     * @param  event
     */
    function navigateEditingCell(event) {
        if(event.which >= 48)
            return;
        switch(event.which) {
            case 13:
                // enter shift enter son OK
                // tab, down arrow baja ok pero no cierra el edit
                // shift tab baja
                event.doEdit = true;

                var navigate;
                switch(event.whichPrevious) {
                    case 33: navigate = -10; break;
                    case 38: navigate = -1; break;
                    case 34: navigate = 10; break;
                    case 13:
                        return false;
                    case 9:
                    case 40:
                        return false;
                    default:
                        if(typeof event.shiftKeyPrevious === 'undefined')
                            navigate = event.shiftKey ? -1 : 1;
                        else
                            navigate = event.shiftKeyPrevious ? -1 : 1;
                }
                if(event.whichPrevious === 38)
                    break;

                var currentRowId = grid.jqGrid("getGridParam", "selrow");
                var nextTr = _trGet(currentRowId, navigate);
                if(nextTr.attr("id")) {
                    scrollToTR(currentRowId, nextTr);
                    if(event.doEdit)
                        editTheRow(nextTr.attr("id"), typeof event.whichPrevious !== "undefined" &&  event.whichPrevious !== 13);
                } else {
                    console.log("                  no encontre next id! navigate=", navigate);
                    console.log("                  no encontre next id! event=", event);
                    console.log("                  no encontre next id! currentRowId=", currentRowId);
                    console.log("                  no encontre next id! nextTr=", nextTr);
                }

                break;
            case 27:
               break;

            case 9: // tab
            case 40: // arrow down
            case 33: // page up
            case 34: // page down
            case 38: // arrow up
                event.stopImmediatePropagation();
                event.stopPropagation();
                event.preventDefault();
                var dispatchEvent = $.Event('keydown');
                dispatchEvent.which = 13;
                dispatchEvent.whichPrevious = event.which;
                dispatchEvent.shiftKeyPrevious = event.shiftKey;
                dispatchEvent.era = { ...event};
                $(event.target).trigger(dispatchEvent);
                break;
        }
    }

    /**
     * Dado un rowId regresa el $TR que le corresponde
     *
     * @param currentRowId
     * @returns {{length: number}|*|jQuery|HTMLElement}
     * @private
     */
    function _currentRowId2selectedTR(currentRowId) {
        if(typeof currentRowId === "undefined" || null === currentRowId || "" === currentRowId) {
            currentRowId = grid.jqGrid("getGridParam", "selrow");
            if(typeof currentRowId === "undefined" || null === currentRowId)
                return {length:0};
        }
        if(typeof currentRowId === "string")
            return currentRowId[0] === "#" ? $("TR" + currentRowId, grid) : $("TR#" + currentRowId, grid);
        return $(currentRowId);
    }

    /**
     * Regresa el $TR al que moverse
     *
     * @param {string} currentRowId
     * @param {int} moveRows
     * @returns {jQuery}
     * @private
     */
    function _trGet(currentRowId, moveRows) {
        var $selectedTR = _currentRowId2selectedTR(currentRowId);
        if($selectedTR === "undefined" || null === $selectedTR || $selectedTR.length === 0)
            return {length:0};

        if(typeof moveRows === "undefined" || isNaN(moveRows) || null === moveRows || "" === moveRows || 0 === moveRows)
            moveRows = 1;
        if(1 === moveRows)
            return $selectedTR.next(":visible");
        if(-1 === moveRows)
            return $selectedTR.prev(":visible").not(".jqgfirstrow");
        if(moveRows > 1) {
            var $nextVisibleElements = $selectedTR.nextAll(":visible");
            return $nextVisibleElements.length > moveRows ? $nextVisibleElements.eq(moveRows) : $nextVisibleElements.last();
        }
        if(moveRows < 1) {
            moveRows = Math.abs(moveRows);
            var $prevVisibleElements = $selectedTR.prevAll(":visible").not(".jqgfirstrow");
            return $prevVisibleElements.length > moveRows ? $prevVisibleElements.eq(moveRows) : $prevVisibleElements.last();
        }
        return $selectedTR;
    }

    /**
     * Selecciona el row toIdOrTr y lo mueve a que top sea el top que era de fromIdOrTr
     *
     * @param {string|jQObject|HTMLElement} fromIdOrTr defaults to selected row
     * @param {string|jQObject|HTMLElement} toIdOrTr defaults to selected row
     * @returns {boolean} false problem, true moved or tried to
     * @private
     */
    function scrollToTR(fromIdOrTr, toIdOrTr) {
        var $selectedTR = _currentRowId2selectedTR(fromIdOrTr);
        if($selectedTR === "undefined" || null === $selectedTR || $selectedTR.length === 0)
            return false;
        var toTr = _currentRowId2selectedTR(toIdOrTr);
        if(toTr === "undefined" || null === toTr || toTr.length === 0)
            return false;
        var nextRowId = toTr.attr("id");
        if(nextRowId === "undefined" || null === nextRowId || nextRowId.length === 0)
            return false;
        grid.jqGrid("setSelection", nextRowId, true);
        var diff = $selectedTR[0].offsetTop - toTr[0].offsetTop;
        if(diff > 10 || diff < -10) {
            var container = grid.closest(".ui-jqgrid-bdiv")[0];
            container.scrollTop = container.scrollTop - diff; // no usar -=
            return true;
        }
        return true;
    }

    return {
        navigateReadOnly: navigateReadOnly,
        navigateEditingRow: navigateEditingRow,
        navigateEditingCell: navigateEditingCell,
        rowEdit: rowEdit,
        rowSave: rowSave,
        rowCancel: rowCancel,
        optionsRowEditSaveRestore: optionsRowEditSaveRestore,

        scrollToTR: scrollToTR,
        lastRowId: lastRowId,
        version: version
    };

});

