/**
 * Agrega navegación 'tipo excel' al jqGrid y botones de font-size
 *
 * Usage: ver jqGridNavigate para paramtros del constructor
 *
 * en el onGridComplete
     gridComplete:function() {
         if(!$(this).data("jqGridNavigate_")) {
            jqGridNav = new jqGridNavigate($(this), '', {});
            $(this).data("jqGridNavigate_",true)
        }
     },

* o
    .on("jqGridAfterGridComplete", function() {
         if(!$(this).data("jqGridNavigate_")) {
             jqGridNav = new jqGridNavigate($(this), '', {});
            $(this).data("jqGridNavigate_",true)
         }
     })

 * en app_*.listme_preRender()
     // Agrega Excel like Key navigaton
     $grid->add_event_code('gridComplete',
         'if(!$(this).data("jqGridNavigate_")) {
             jqGridNav = new jqGridNavigate($(this), "", {});
             $(this).data("jqGridNavigate_",true)
         }'
     );
Tip ampliar botones del navigator .ui-pg-div {width:fit-content; padding:0 2.25em;margin:0 1.3em}
*
*/
class jqGridNavigate {
    #$grid;
    #gridId;
    editUrl;
    editParams;
    gridLocked = false; //
    #editLastRowId = '';
    #lastEventKeyTimeStamp = 0;
    #inSave = false;

    constructor($grid, editUrl, editParams) {
        this.#$grid = $($grid);
        this.#gridId = this.#$grid.attr('id');
        this.editUrl = editUrl;
        this.editParams = editParams;
        this.#$grid.on('keydown',  ev => this.keyNavigate(ev) );
        let me = this;
        let gridPager = this.#$grid.jqGrid("getGridParam", "pager");
        if(gridPager)
            this.#$grid.jqGrid('navSeparatorAdd',gridPager)
                .jqGrid('navButtonAdd',gridPager,{
                    caption:'🗚',
                    title:'Incrementar Font Size',
                    buttonicon:'ui-icon-arrowthick-1-n',
                    onClickButton: function(){
                        let $tBody = $(this).find("TBODY");
                        $tBody.css({
                            'font-size': parseFloat($tBody.css('font-size')) * 1.025
                        });
                    }
                })
                .jqGrid('navButtonAdd',gridPager,{
                    caption:'🗛',
                    title:'Reducir Font Size',
                    buttonicon:'ui-icon-arrowthick-1-s',
                    onClickButton: function(){
                        let $tBody = $(this).find("TBODY");
                        $tBody.css({
                            'font-size': parseFloat($tBody.css('font-size')) * 0.975
                        });
                    }
                })
                .jqGrid('navSeparatorAdd',gridPager)
                .jqGrid('navButtonAdd',gridPager,{
                    caption:'Ve Filas',
                    title:'Solo ver los renglones o rows',
                    buttonicon:'ui-icon-list',
                    onClickButton: function(){ me.veRows($(this)); }
                })
                .jqGrid('navButtonAdd',gridPager,{
                    caption:'Ir A',
                    title:'Goto Línea, Producto, color (Control+g)',
                    buttonicon:'ui-icon-zoom',
                    onClickButton: function(){ me.pideIrA($(this)); }
                })
            ;
    }

    pideIrA() {
        if (this.#pideIrA_On)
            return;
        this.#pideIrA_On = true;
        this.editCancel();
        let promise = ia.form(
            `<div><ul><li>
                    <select name='iraop'>
                        <option value='eq' title='Igual'>Igual</option>
                        <option value='cn' title='Contine'>Contiene</option>
                        <option value='bw' title='Inicia con'>Inicia Con</option>
                        <option value='ew' title='Termina con'>Termina Con</option>
                    </select>
                    <input name='ira' autofocus value=''>
                    <br><i style="font-weight: 100;font-size:0.9em;color:silver">En pruebas....</i>
                </ul></div>`,
            "Ir a Número de Línea o Buscar texto");
        this.#$grid = $(`#${this.#gridId}`);
        let me = this;
        promise.done(function (formValues) {
            me.#pideIrA_On = false;
            let irA = formValues.ira.trim();
            me.#pideIrA_findOp = formValues.iraop.trim();
            if (irA.length === 0)
                return;

            let nextRowId;
            if (isNaN(irA)) {
                me.#pideIrA_searchFor = me.#strim(irA.toLowerCase());
                nextRowId = me.#findRowId(me.#pideIrA_searchFor, true)
            } else {
                nextRowId = me.#lineNumber2id(Math.abs(parseInt(irA)));
            }
            let selectedTR = $("TR#" + me.#$grid.jqGrid('getGridParam', 'selrow'), me.#$grid);
            if (selectedTR[0].id === nextRowId) {
                me.#$grid.jqGrid("setSelection", nextRowId, true);
                return;
            }
            me.nextRow(nextRowId, selectedTR, true);
        });
        promise.fail(function () { me.#pideIrA_On = false;});
    }

    veRows() {
        let id = this.#gridId + "VeRowsDialogo";
        if($(id).length > 0) {
            $(id).remove();
            return;
        }
        closeAllDialog();
        let me = this;
        let $grid = $("#" + this.#$grid.attr('id'));
        let $dlg = $(
            `<div id="VeRowsDialogo" style="display:none">
                        <table style="line-height: 2em">
                            <caption style="white-space: nowrap">Mostrar Únicamente los Renglones:</caption>
                            <tr><td><label for="rowsVisiblesDel">Del:</label></td><td><input type="number" pattern="\d*" min="1" step="1" name='ini' id="rowsVisiblesDel" style="width:4em" value=''></td>
                                <td style="padding-left:1.5em"><label for="rowsVisiblesAl">Al:</label></td><td><input type="number" pattern="\d*" min="1" step="1" name='fin' id="rowsVisiblesAl" style="width:4em" value=''></td></tr>
                        </table>
                        <br><i style="font-weight: 100;font-size:0.9em;color:silver">En pruebas....</i>
                    </div>`);
        let promise = ia.form($dlg.html(), "Filas Visibles");
        promise.done(function(visiblesDelAl) {
            let ini = parseInt(visiblesDelAl.ini);
            let fin = parseInt(visiblesDelAl.fin);
            let ids = $grid.jqGrid('getDataIDs');
            if( isNaN(ini) || ini < 1)
                ini = 1;
            if(isNaN(fin) || fin < 1 || fin > ds.length)
                fin = ids.length +1;
            if(ini > fin) {
                let tmp = fin;
                fin = ini;
                ini = tmp;
            }
            ini--;
            fin--;
            for(let i in ids)
                if(ids.hasOwnProperty(i))
                    if(i < ini || i > fin)
                        $(`#${ids[i]}`, $grid).hide();
                    else
                        $(`#${ids[i]}`, $grid).show();
            $("#rowsVisiblesDel").val(ini);
            $("#rowsVisiblesAl").val(fin);
        });
    }

    showRibbon() {
        let $captionBar = $(".ui-jqgrid-titlebar", $("#gview_" + this.#$grid ) );
        if($captionBar.is(":visible"))
            return;
        let me = this.#$grid;
        $captionBar.show(function(){
            if(me.#$grid.data('iacfullwindow')) {
                me.#$grid.data('iacfullwindow', false);
                gridMaximize(me.#gridId);
            }
        });
    }

    hideRibbon() {
        let $captionBar = $(".ui-jqgrid-titlebar", $("#gview_" + this.#$grid ) );
        if(!$captionBar.is(":visible"))
            return;
        let me = this.#$grid;
        $captionBar.hide(function(){
            if(me.#$grid.data('iacfullwindow')) {
                me.#$grid.data('iacfullwindow', false);
                gridMaximize(me.#gridId);
            }
        });
    }

    swapRibbon() {
        let me = this;
        let $captionBar = $(".ui-jqgrid-titlebar", $("#gview_" + me.#$grid[0].id ) );
        if($captionBar.is(":visible"))
            $captionBar.hide(function(){
                if(me.#$grid.data('iacfullwindow')) {
                    me.#$grid.data('iacfullwindow', false);
                    gridMaximize(me.#$grid[0].id);
                }
            });
        else
            $captionBar.show(function(){
                if(me.#$grid.data('iacfullwindow')) {
                    me.#$grid.data('iacfullwindow', false);
                    gridMaximize(me.#$grid[0].id);
                }
            });
    }

    editCancel() {
        this.#inSave = false;
        this.#lastEventKeyTimeStamp = 0;
        if(this.#editLastRowId !== '') try {
            this.#$grid.jqGrid('restoreRow', this.#editLastRowId);
        } catch(e) {}
        this.#editLastRowId = '';
    }
    
    /**
     *
     * @param rowId
     * @param params
     */
    editStart(rowId, params) {
        if(typeof params === 'undefined')
            params = this.editParams;
        this.#editLastRowId = rowId;
        this.#lastEventKeyTimeStamp = 0;
        this.#$grid = $(`#${this.#gridId}`);
        let me = this;
        this.#$grid.editRow(
            rowId,
            false, // keys
            null,
            null, // successfunc,
            typeof this.editUrl === 'string' ? this.editUrl : this.editUrl(), // url,
            typeof params === 'object' ? params : params(),
            function () {
                me.editNextRow(rowId, true, true, null);
            },
            function (info) {
                try {
                    if (typeof info === 'object' && typeof info.responseText.message === 'string') {
                        ia.alertError(info.responseText.message, 'Error Inesperado');
                        return;
                    }
                } catch (e) {}
                ia.alertError("Error", 'Error Inesperado');
                js_errores_a_dime(e);
            },
        );
    }

    /**
     *
     * @param {string} rowId
     * @param {boolean} dontEditNext
     * @param {boolean} directionDown
     * @param {string|null} nextId
     */
    editNextRow(rowId, dontEditNext, directionDown, nextId) {
        $("TR.footrow").children("TD.recomiendoQuantity")
            .html(numFormatter( this.#$grid.jqGrid('getCol', "recomiendo_quantity", false, 'sum'), 2));
        this.#inSave = false;
        if(dontEditNext) {
            this.#editLastRowId = '';
            return;
        }
        if(nextId === null || typeof nextId === 'undefined') {
            if (directionDown)
                nextId = this.#$grid.jqGrid('getDataIDs')[this.#$grid.jqGrid("getInd", rowId)] || null;
            else
                nextId = this.#$grid.jqGrid('getDataIDs')[this.#$grid.jqGrid("getInd", rowId) - 2] || null;
        }
        if(nextId) {
            this.#editLastRowId = nextId;
            this.nextRow(nextId, $("TR#" + rowId, this.#$grid), directionDown);
            this.editStart(
                nextId,
                {accion: 'recomiendaGuardaInvalid', tipo: brv.getTipo(),}
            );
        } else {
            this.#editLastRowId = '';
            console.log("   EditNextRow SIN NEXT ID", `n=${nextId}`);
        }
    }

    /**
     * Selecciona el nextRowId scrolleando como excel: scroleando los renglones es decir sin bajar/subir el seleccionado.
     *
     * @param {string} nextRowId
     * @param {boolean} directionDown
     * @param {*} selectedTR
     */
    nextRow(nextRowId, selectedTR, directionDown) {
        try {
            if (nextRowId) {
                try {
                    if (selectedTR[0].id === nextRowId)
                        nextRowId = this.#checkNextIsSameId(nextRowId, directionDown);
                } catch (e0) {}
                let nextRow = document.getElementById(nextRowId);
                if (nextRow === null) {
                    console.log("ERROR nextRow nextRowId NOT FOUND: ", nextRowId);
                    return;
                }

                this.#$grid.jqGrid("setSelection", nextRowId, true);
                let diff = selectedTR[0].offsetTop - nextRow.offsetTop;
                if (diff < 400 && diff > -400) {
                    let container = this.#$grid.closest(".ui-jqgrid-bdiv")[0];
                    container.scrollTop = container.scrollTop - diff; // no usar -=
                    return;
                }
                let me = this;
                vx_asyncFunction(
                    function () {
                        console.log("0/7 ____ container.scrollTop", me.#$grid.closest(".ui-jqgrid-bdiv")[0].scrollTop);
                        let container = me.#$grid.closest(".ui-jqgrid-bdiv")[0];
                        container.scrollTop = container.scrollTop - diff;  // no usar -=

                        if (me.#isVisible(nextRow, me.#$grid.closest(".ui-jqgrid-bdiv")[0]))
                            return;
                        console.log("Problemas!", new Date());
                        console.log("1/7 ____ No Pude Ir", nextRow);
                        console.log("  2/7        nextRow", nextRow);
                        console.log("  3/7        nextRow scrollTop", nextRow.scrollTop);
                        console.log("  4/7       selected scrollTop", selectedTR[0].offsetTop);
                        console.log("  5/7        diff", diff);
                        console.log("  6/7        container.scrollTop", me.#$grid.closest(".ui-jqgrid-bdiv")[0].scrollTop);
                        console.log("  7/7        container.scrollHeight", me.#$grid.closest(".ui-jqgrid-bdiv")[0].scrollHeight);

                    },
                    20,
                    this
                );

            } else {
                console.log("nextRow: empty nextRowId", nextRowId)
            }
        } catch (e) {
            console.log("ERROR nextRow", e);
            js_errores_a_dime(e);
        }
    }

    keyNavigate(eventKey) {
        try {
            const k = eventKey.which;
            if (k !== 17 && k !== 16 && k !== 13 && !(k >= 33 && k <= 40))
                return;
            if (k !== 17 && k !== 16 && eventKey.timeStamp - this.#lastEventKeyTimeStamp < 150) {
                eventKey.stopImmediatePropagation();
                eventKey.stopPropagation();
                eventKey.preventDefault();
                return;
            }
            this.#lastEventKeyTimeStamp = eventKey.timeStamp;
            let selectedRowId = this.#$grid.jqGrid('getGridParam', 'selrow');
            if (selectedRowId === null || selectedRowId.length === 0)
                if (eventKey.target.tagName === 'TR')
                    selectedRowId = eventKey.target.id;
                else
                    selectedRowId = $(eventKey.target).parents("TR").first().attr('id');

            switch (k) {
                case 27:
                    eventKey.stopImmediatePropagation();
                    eventKey.stopPropagation();
                    eventKey.preventDefault();
                    this.editCancel();
                    gGridLocked = false;
                    break;
                case 13: // enter
                case 33: // page up
                case 34: // page down
                case 38: // arrow up
                case 40: // arrow down
                    eventKey.stopImmediatePropagation();
                    eventKey.stopPropagation();
                    eventKey.preventDefault();
                    if (this.#editLastRowId.length)
                        this.editCancel(); // no deberia llegar lo debe atrapar el onkeydown del input
                    this.#editLastRowId = '';
                    let selectedTR = $("TR#" + selectedRowId, this.#$grid);
                    this.nextRow(
                        this.keyToNextRowId(eventKey, selectedRowId, selectedTR),
                        selectedTR,
                        k === 13 || k === 34 || k === 40
                    );
                    return;

                case 35: // fin/end
                    if (this.#editLastRowId.length)
                        return; // no deberia llegar lo debe atrapar el onkeydown del input
                    eventKey.stopImmediatePropagation();
                    eventKey.stopPropagation();
                    eventKey.preventDefault();
                    let rows = this.#$grid.jqGrid('getDataIDs');
                    if (rows.length === 0)
                        return;
                    if (eventKey.ctrlKey) {
                        this.#$grid.jqGrid("setSelection", rows[rows.length - 1], true);
                        this.#$grid.jqGrid('focusBodyCell', rows.length, 0);
                        return;
                    }
                    let numCols = 0;
                    let n = -1;
                    let TD = $("#" + rows[0]).children("TD");
                    for (let e in TD) if (TD.hasOwnProperty(e)) {
                        if (TD[e].tagName === 'TD') {
                            n++;
                            if ($(TD[e]).is(":visible"))
                                numCols = n;
                        }
                    }
                    if (typeof selectedRowId !== 'undefined' && selectedRowId !== null) {
                        this.#$grid.jqGrid("setSelection", selectedRowId, true).jqGrid('focusBodyCell', this.#$grid.jqGrid("getInd", selectedRowId), numCols);
                    } else {
                        console.log("key fin", "lost rowId in $(eventKey.target)", $(eventKey.target))
                    }
                    return;

                case 36: // inicio/home
                    if (this.#editLastRowId.length)
                        return; // no deberia llegar lo debe atrapar el onkeydown del input
                    eventKey.stopImmediatePropagation();
                    eventKey.stopPropagation();
                    eventKey.preventDefault();
                    if (eventKey.ctrlKey) {
                        this.#$grid.jqGrid("setSelection", this.#$grid.jqGrid('getDataIDs')[0], true).jqGrid('focusBodyCell', 1, 0);
                        return;
                    }
                    if (typeof selectedRowId === 'undefined' || selectedRowId === null)
                        return;
                    this.#$grid.jqGrid('focusBodyCell', this.#$grid.jqGrid("getInd", selectedRowId), 0).jqGrid("setSelection", selectedRowId, true);
            }
        } catch (e) {
            console.log("ERROR keyNavigate", e);
            js_errores_a_dime(e);
        }
    }

    /**
     * Dado un key event regresa el siguiente rowId para el key Event, regresa el mismo rowId si no se mueve
     *
     * @param {object} eventKey
     * @param {string} selectedRowId
     * @param {object|null} $selectedTR
     * @returns {*|string|string}
     */
    keyToNextRowId(eventKey, selectedRowId, $selectedTR) {
        let ret = '';
        try {
            if (typeof selectedRowId !== 'string' || selectedRowId.length === 0) {
                selectedRowId = this.#$grid.jqGrid('getGridParam', 'selrow');
                if (selectedRowId === null || selectedRowId.length === 0)
                    if (eventKey.target.tagName === 'TR')
                        selectedRowId = eventKey.target.id;
                    else
                        selectedRowId = $(eventKey.target).parents("TR").first().attr('id');
            }

            switch (eventKey.which) {
                case 13: // enter as arrow down
                case 38: // arrow up
                case 40: // arrow down
                    if ($selectedTR === null || typeof $selectedTR === 'undefined') {
                        if (selectedRowId.length === 0)
                            selectedRowId = this.#editLastRowId;
                        $selectedTR = $("TR#" + selectedRowId, this.#$grid);
                    }
                    ret = eventKey.which === 40 || (eventKey.which === 13 && !eventKey.shiftKey) ?
                        $selectedTR.next().attr("id") : $selectedTR.prev().attr("id");
                    break;
                case 33: // page up
                    ret = this.#getPrevVisible(this.#$grid.jqGrid("getInd", selectedRowId));
                    break;
                case 34: // page down
                    ret = this.#getNextVisible(this.#$grid.jqGrid("getInd", selectedRowId));
                    break;
                case 35: // fin/end
                    let rows = this.#$grid.jqGrid('getDataIDs');
                    return rows.length === 0 ? '' : rows[rows.length - 1];
                case 36: // inicio/home
                    return this.#$grid.jqGrid('getDataIDs')[0];
                default:
                    return selectedRowId;
            }

            if (ret !== selectedRowId)
                return ret;
            return this.#checkNextIsSameId(ret, eventKey.which === 13 || eventKey.which === 34 || eventKey.which === 40);
        } catch (e) {
            console.log("ERROR keyToNextRowId selectedRow", selectedRowId);
            console.log("ERROR keyToNextRowId", e);
            js_errores_a_dime(e);
            return '';
        }
    }

    /**
     * Regresa info de la celda siguiente a name que se puede editar
     *   {rowId:next_rowId, colModelIndex:next_colModelIndex, name:next_name, cm:colModel[next_name]}
     *
     * @param rowId
     * @param name
     * @returns {{colModelIndex: null, name, cm: *, rowId: (*|string)}|{colModelIndex: number, name, cm: *, rowId}}
     */
    findNextEdit(rowId, name) {
        let modoFindEdit = false;
        let firstEdit = null;
        this.#$grid = $(`#${this.#gridId}`);
        let colModel = this.#$grid.jqGrid("getGridParam", "colModel");
        for(let colModelIndex = 0, len = colModel.length; colModelIndex < len; ++colModelIndex) {
            if(colModel[colModelIndex].editable) {
                if (modoFindEdit)
                    return {rowId, colModelIndex, name:colModel[colModelIndex].name, cm:colModel[colModelIndex]};
                if(firstEdit === null)
                    firstEdit = colModelIndex;
            }
            if (colModel[colModelIndex].name === name)
                modoFindEdit = true;
        }
        let nextRowId = this.#getNextVisible($('#' + rowId)[0].rowIndex);
        return {rowId:nextRowId, colModelIndex:firstEdit, name:colModel[firstEdit].name, cm:colModel[firstEdit]};
    }

    /**
     * Regresa info de la celda anterior a name que se puede editar
     *   {rowId:prev_rowId, colModelIndex:prev_colModelIndex, name:prev_name, cm:colModel[prev_name]}
     *
     * @param rowId
     * @param name
     * @returns {{colModelIndex: null, name, cm: *, rowId: (*|string)}}
     */
    findPrevEdit(rowId, name) {
        let firstEdit = null;
        let lastEdit = null;
        this.#$grid = $(`#${this.#gridId}`);
        let colModel = this.#$grid.jqGrid("getGridParam", "colModel");
        for(let colModelIndex = 0, len = colModel.length; colModelIndex < len; ++colModelIndex) {
            if(colModel[colModelIndex].editable) {
                if(firstEdit === null)
                    firstEdit = colModelIndex;
            }
            if (colModel[colModelIndex].name === name) {
            }
            if(colModel[colModelIndex].editable)
                lastEdit = colModelIndex;
        }
        let nextRowId = this.#getPrevVisible($('#' + rowId)[0].rowIndex);
        return {rowId:nextRowId, colModelIndex:firstEdit, name:colModel[firstEdit].name, cm:colModel[firstEdit]};
    }

    /**
     *
     * @param {string} rowId
     * @param {boolean} directionDown
     * @returns {string}
     */
    #checkNextIsSameId(rowId, directionDown) {
        if (directionDown)
            return this.#$grid.jqGrid('getDataIDs')[this.#$grid.jqGrid("getInd", rowId)] || rowId;
        return this.#$grid.jqGrid('getDataIDs')[this.#$grid.jqGrid("getInd", rowId) - 2] || rowId;
    }

    /**
     * Regresa true elemento se encuentra en el scroll área visible de container.
     *
     * @param elemento
     * @param container
     * @returns {boolean}
     * @private
     */
    #isVisible(elemento, container) {
        const elementoRect = elemento.getBoundingClientRect();
        const containerRect = container.getBoundingClientRect();
        if (elementoRect.top < containerRect.top || elementoRect.bottom > containerRect.bottom)
            return false;
        //@TODO margen de error ie 8px entre 5 y 10
        return elementoRect.top < containerRect.top ?
            containerRect.top - elementoRect.top < elementoRect.height :
            elementoRect.bottom - containerRect.bottom < elementoRect.height;
    }

    /**
     * Regresa el primer Id no visible Antes de currentIndex.
     *
     * @param currentIndex
     * @returns {*|string}
     * @private  let
     */
    #getPrevVisible(currentIndex) {
        try {
            let ids = this.#$grid.jqGrid('getDataIDs');
            if (currentIndex >= ids.length)
                currentIndex = ids.length - 1;
            for (let i = currentIndex; i >= 0; --i)
                if (!this.#isVisible($("#" + ids[i], this.#$grid)[0], this.#$grid.closest(".ui-jqgrid-bdiv")[0])) {
                    if (i !== currentIndex)
                        return ids[i > 1 ? i + 1 : 0];
                    return ids[i > 0 ? i - 1 : 0];
                }
            return ids[0];
        } catch (e) {
            console.log("ERROR grid.onkeydown.getPrevVisible", e);
            js_errores_a_dime(e);
            return '';
        }
    }

    /**
     * Regresa el primer Id no visible Después de currentIndex.
     *
     * @param currentIndex
     * @returns {*|string}
     * @private
     */
    #getNextVisible(currentIndex) {
        try {
            let ids = this.#$grid.jqGrid('getDataIDs');
            let len = ids.length;
            for (let i = currentIndex; i < len; ++i)
                if (!this.#isVisible($("#" + ids[i], this.#$grid)[0], this.#$grid.closest(".ui-jqgrid-bdiv")[0])) {
                    if (i !== currentIndex)
                        return ids[i > 2 ? i - 2 : 0];
                    return ids[i + 1 >= len ? len - 1 : i + 1];
                }
            return ids[len - 1];
        } catch (e) {
            console.log("ERROR grid.onkeydown.getNextVisible", e);
            js_errores_a_dime(e);
            return '';
        }
    }

    #pideIrA_findOp = 'cn'; // 'eq, 'cn', 'bw', 'ew'
    #pideIrA_findIn = ['producto', 'color'];
    #pideIrA_searchFor = ['producto', 'color'];
    #pideIrA_On = false;

    #findRowId(irA, directionDown) {
        let regExp, find = irA;

        switch (this.#pideIrA_findOp) {
            case 'cn':
                regExp = new RegExp(`${find}`, 'gmiu');
                break;
            case 'bw':
                regExp = new RegExp(`^${find}`, 'gmiu');
                break;
            case 'ew':
                regExp = new RegExp(`${find}$`, 'gmiu');
                break;
            default:
                regExp = new RegExp(`^${find}$`, 'gmiu');
        }
        let selectedTR = $("TR#" + this.#$grid.jqGrid('getGridParam', 'selrow'), this.#$grid);
        let desdeRow = selectedTR[0].rowIndex || 0;
        let data = this.#$grid.jqGrid('getRowData');
        let len = data.length;
        if (find.length === 0 || len === 0)
            return '';
        if (directionDown) {
            for (let i = desdeRow + 1; i < len; ++i) {
                let row = data[i];
                for (let c of this.#pideIrA_findIn)
                    if (regExp.test(row[c]))
                        return this.#lineNumber2id(i + 1);
            }
            for (let i = 0; i <= desdeRow; ++i) {
                let row = data[i];
                for (let c of this.#pideIrA_findIn)
                    if (regExp.test(row[c]))
                        return this.#lineNumber2id(i + 1);
            }
            return this.#lineNumber2id(desdeRow);
        }
        for (let i = desdeRow - 1; i >= 0; --i) {
            let row = data[i];
            for (let c of this.#pideIrA_findIn)
                if (regExp.test(row[c]))
                    return this.#lineNumber2id(i + 1);
        }
        for (let i = len - 1; i >= 0; --i) {
            let row = data[i];
            for (let c of this.#pideIrA_findIn)
                if (regExp.test(row[c]))
                    return this.#lineNumber2id(i + 1);
        }
        return this.#lineNumber2id(desdeRow);
    }

    #lineNumber2id(rowNum) {
        let rowId, ids = this.#$grid.jqGrid('getDataIDs');
        if (rowNum <= 1)
            rowId = ids[0];
        else if (rowNum >= ids.length)
            rowId = ids[ids.length - 1];
        else
            rowId = ids[rowNum - 1];
        // noinspection JSJQueryEfficiency
        if (!$(`#${rowId}`).is(":visible"))
            $(`#${rowId}`).show();
        return rowId;
    }
    
    #strim(s) {
        if (typeof s !== 'string')
            return '';
        const regex = /\s{2,}/gu;
        return s.trim().replace(regex, " ");
    }

}

