
// noinspection JSUnusedGlobalSymbols

/**
 *


 iajqgridcheque_cols = new jqgridcolssorter( $("#iajqgridcheque"), "iajqgridcheque_", "iajqgridcheque_cols", [] );
 iajqgridcheque_cols.putGetParam();
 $("BODY").append(iajqgridcheque_cols.controles());

     let iajqgridcheque_cols;
      gridname_cols = new jqgridcolssorter( $("#iajqgridcheque"), "iajqgridcheque_", "iajqgridcheque_cols",
         [],
         // <?php echo json_encode(jqgridcolssorter_GetDefs('gridname_cols_') ); ?>
      );
     iajqgridcheque_cols.putGetParam();
    $("BODY").append(iajqgridcheque_cols.controles());

 */

if (typeof window.jqgridcolssorter === 'undefined') {
    window.jqgridcolssorter = class {

    debug = false;
    doHideCols = true;
    dialog_title = 'Columnas';
    $dialog_top = "<div>";

    #gridId = '';
    #$grid = {};
    #colDefKey = '';
    #varName = '';
    #selectId = '';
    #inputId = '';
    #nameLabelOverride = {}; // {name:'New label'}
    /**
     * Conjuntos ordenados de columnas para ofrecer al usuario, conjuntos del sistema
     * Oculto y/o Visible traen nombres de columnas
     * Truco puede nombrar solo las visibles. value debe ser string.
     *
     * @type {[]} [{label:string, value:string, para_todos:string, def:{Oculta:[],Visible:[],Width:{} }, ... ]
     */
    #extraColsDef = [];

    /**
     * El conjunto ordenado de columnas por default.
     *
     * @type {null|object} {Oculta:[],Visible:[],Width:{}}
     */
    #defaultColsDef = null;

    #hideKeyColumn = true;


    /**
     *
     *
     * @param {object} $grid el grid como jquery object
     * @param {string|null|undefined} colDefKey El nombre único con que se guardaran las definiciones de columnas en la db, default $grid.attr('id') + '_'
     * @param {string|null|undefined} varName El nombre de la variable , default $grid.id + '_cols'
     * @param {array|undefined} extraColsDef [{label:string, value:string, def:{Oculta:[],Visible:[],Width:{}} }, ... ]
     * @param {array|undefined} userColsDefs [{label:string, value:string, def:{Oculta:[],Visible:[],Width:{}} }, ... ]
     * @param {array|undefined} nameLabelOverride {name:New Label, colName:Label}
     * @param {object|null|undefined} defaultColsDef {Oculta:[],Visible:[],Width:{}} en empty lo deduce
     */
    constructor($grid, colDefKey, varName, extraColsDef, userColsDefs, nameLabelOverride, defaultColsDef) {
        this.#$grid = $grid;
        this.#gridId = $grid.attr('id');
        this.#colDefKey = typeof colDefKey === 'undefined' || colDefKey === null || colDefKey === '' ?
            $grid.attr('id') + '_' : colDefKey;
        this.#varName = typeof varName === 'undefined' || varName === null || varName === '' ?
            $grid.attr('id') + '_cols' : varName;
        this.#selectId = `${this.#varName}_Select`;
        this.#inputId = `${this.#varName}_Input`;

        if(Array.isArray(extraColsDef))
            this.#extraColsDef = extraColsDef;
        if(typeof userColsDefs !== 'undefined')
            for(let c of userColsDefs)
                    this.#extraColsDef.push(c);
        if(typeof nameLabelOverride !== 'undefined')
            this.#nameLabelOverride = nameLabelOverride;

        if(typeof defaultColsDef === 'undefined' || defaultColsDef === null) {
            let me = this;
            this.#$grid.one('jqGridLoadComplete', function () {
                me.saveDefault(me);
            });
        } else
            this.#defaultColsDef = defaultColsDef;
    }

    /**
     *
     * @param {string} name
     * @param {string}label
     * @returns {string}
     */
    #setLabel(name, label) {
        var niceName =this.#ucwords( name.replaceAll('_id', ' ').replaceAll('_', ' ').trim() );
        if(this.#nameLabelOverride.hasOwnProperty(name))
            return this.#nameLabelOverride[name];
        if(typeof label === 'undefined' || label === '')
            return niceName;
        label = label.replaceAll("<p>", " ");
        label = label.replaceAll("<br>&nbsp;", " ");
        label = label.replaceAll("<br>", " ");
        let at = label.search('<');
        if(at < 0)
            return label;
        if(at > 0)
            return label.substring(0, at);
        try {
            return $(`<div>${label}</div>`).text().trim();
        } catch(e) {
            console.log("ERROR: setLabel", e)
            return niceName + ".";
        }

    }

    /**
     *  ucwords or titlecase: Uppercase the first letter of each word, others are lowercased
     *
     * @requires ES9 or use XRegExp library
     * @param {string} str
     * @returns {string}
     */
    #ucwords(str) {
        return str.toLowerCase().replace(
            /(^([a-zA-Z\p{L}]))|([ -][a-zA-Z\p{L}])/gmu,
            function(s) {return s.toUpperCase();}
        );
    }


    /**
     * Regresa el $(html) del botón y select para re-acomodar columnas para append a la hoja
     *
     * @returns {JQuery<HTMLElement>}
     */
    controles() {
        // let opt = [{value:'loaded_default', label:'_Original', class:'jqgridcolssorter_option_coded'}];
        let opt = [];
        for(let o of this.#extraColsDef) {
            opt.push({
                value: o.value, label: o.label, class: isNaN(o.value) ? 'jqgridcolssorter_option_coded' : '',
                myDefault: o.myDefault ||  'No', para_todos: o.para_todos ||  'No', ocultar_ribbon: o.ocultar_ribbon || 'No'
            });
        }
        let options = '';
        for(let o of opt) {
            let cls = o.myDefault === 'Si' ? "class='mydefault' " : "";
            options += `<option ${cls} data-mydefault="${o.myDefault}" data-paratodos="${o.para_todos}"
                data-ocultarribbon="${o.ocultar_ribbon}" 
                value="${o.value}" class="${o.class}">${o.label}</option>`;
        }
        let controles =
            `<div class="jqgridcolssorter_container">
                    <button type="button" onclick="${this.#varName}.dialog()"
                        class="jqgridcolssorter_button"
                        title="Ordena las columnas"><i class="fa-regular fa-arrow-down-small-big fa-lg fa-rotate-270"></i></button>
                    <select id="${this.#selectId}" class="ui-front notSelectize jqgridcolssorter_select" required
                        onchange="${this.#varName}.put(this.value);${this.#varName}.selectApplySelectedClass(); ">
                        <option></option>
                        ${options}
                    </select> <i onclick="${this.#varName}.del()" title="Elimina la plantilla" class="fa-solid fa-trash-can jqgridcolssorter_del"></i>
                    <div class="jqgridcolssorter_label">Plantilla de Columnas.</div>
                </div>`;
        let me = this;
        let $controles = $(controles);
        return $controles;
    }

    selectApplySelectedClass() {
        $("#" + this.#selectId).each(function(){
            var e=$(this);
            if(!e.prop("multiple")) {
                e.off("change",selectTextAddSelectedClass).on("change",selectTextAddSelectedClass);
                var select = $(this), optionClass = select.children(":selected").prop("class");
                select.removeClass(select.data("iaprevoptionclass")).addClass(optionClass).data("iaprevoptionclass", optionClass);
            }
        });
        function selectTextAddSelectedClass() {
            var select = $(this), optionClass = select.children(":selected").prop("class");
            select.removeClass(select.data("iaprevoptionclass")).addClass(optionClass).data("iaprevoptionclass", optionClass);
        }
    }
    // uso avanzado
    /**
     * Pone la definición del orden Default
     *
     * @param {object} value {Oculta:[],Visible:[],Width:{}}
     */
    set defaultColDef(value) {
        this.#defaultColsDef = value;
    }



    #getKeyColumnName() {
        let colModel = this.#$grid.jqGrid("getGridParam", "colModel");
        for(let c of colModel) {
            if(c.key) {
                this.#hideKeyColumn = c.hasOwnProperty('hidden') ? c.hidden : true;
                return c.name;
            }
        }
        return '\t';
    }

    #prepareCols(colsDef)
    {
        let cols = colsDef
        let keyColName = this.#getKeyColumnName();
        let v = [keyColName];
        for(let c of cols.Visible)
            if(c !== keyColName)
                v.push(c);
        cols.Visible = v;
        if(cols.Oculta.includes(keyColName)) {
            let v = [];
            for(let c of cols.Oculta)
                if(c !== keyColName)
                    v.push(c);
            cols.Oculta = v;
        }
        return cols
    }

    // uso manual
    /**
     *
     * @param {string} saveName Nombre con que guarda el colDef en el server
     */
    dialog(saveName) {
        if($("#jqgridcolssorter_dialog").length > 0) {
            $("#jqgridcolssorter_dialog").remove();
            return;
        }
        let paraTodosChecked = '';
        let miDefaultChecked = '';
        let select = $(`#${this.#selectId}`);
        if(typeof saveName === 'undefined')
            saveName = select.val();
        if(saveName === 'loaded_default')
            saveName = '';
        else {
            let opt = select.find(`OPTION[value='${saveName}']`).first();
            if(opt.data('mydefault') === 'Si')
                miDefaultChecked = 'CHECKED="CHECKED"';
            if(opt.data('paratodos') === 'Si')
                paraTodosChecked = 'CHECKED="CHECKED"';
            let name = opt.text();
            if(typeof name !== 'undefined')
                saveName = name;
        }
        if(saveName[0] === '_')
            saveName = saveName.substring(1);
        let defaultButton = ($vitex_globales.tipo_rony || (typeof gDefaultsTodosLosUsuarios === "undefined" || gDefaultsTodosLosUsuarios ) ) ?
            `<input type="checkbox" id='${this.#varName}_default' ${miDefaultChecked} value='1'><label title="Hazlo Mi Default" for='${this.#varName}_default'> Mi Default</label>` :
            "";
        let paraTodos = $vitex_globales.tipo_rony ?
            `<input type="checkbox" id='${this.#varName}_para_todos' ${paraTodosChecked} value='Si'><label for='${this.#varName}_para_todos'> Para Todos</label>` : '';
        $("BODY").append(
            `<div id='jqgridcolssorter_dialog' class='jqgridcolssorter_dialog'>
                    <div id='${this.#varName}_dialog_top'></div>
                    <div id='${this.#varName}_clasificame'></div>
                    <div>
                        <label title="Se guarda con el nombre seleccionado. Sin nombre no se guarda." for='${this.#inputId}'>Guardar como:
                            </label><input placeholder='Nombralo' class='jqgridcolssorter_inputLabel'
                        autofill="off"   autocomplete="off" id='${this.#inputId}' type='text' maxlength="63" value='${saveName}' style="width:30em">
                        ${defaultButton}
                        <input type="checkbox" id='${this.#varName}_width' value='1'><label title="Guarda el ancho de las columnas, pero es más lento" for='${this.#varName}_width'> Con Ancho Cols</label>                                
                        <input type="checkbox" id='${this.#varName}_ribbon' value='1'><label title="Ocultar el Ribbon, toolbar de arriba" for='${this.#varName}_ribbon'> Ocultar el Ribbon</label>                                
                        ${paraTodos}
                    </div>
                </div>`
        );

        let columnas = [];
        let colModel = this.#$grid.jqGrid('getGridParam', 'colModel');
        for(let col of colModel)
            if(col.name !== 'rn' && col.name !== 'cb' && col.name !== 'subgrid')
                columnas.push({
                    name: col.name,
                    label: this.#setLabel(col.name, col.label),
                    permiso: col.hidden ? 'Oculta' : 'Visible',
                });
        let clasificame = $(`#${this.#varName}_clasificame`).clasificame({
            'clasificacion': [
                {clasificaId:'Visible', label:'Visible', title:'Visibles', userSortable:true},
                {clasificaId:'Oculta', label:'Oculta', title:'Ocultas'},
            ],
            valueId: 'name',
            valueDisplay: 'label',
            valueColumnKey: 'permiso',
            values: columnas,
            title: 'Ordena y oculta columnas',
            label_sort: 'Columnas',
        });

        $(`#${this.#varName}_dialog_top`).append(this.$dialog_top);

        let me = this;
        $("#jqgridcolssorter_dialog").dialog({
            title: me.dialog_title,
            me: me,
            closeOnEscape: true,
            width: 'auto',
            buttons: [
                {
                    text: 'Aplica',
                    icon: 'ui-icon-check',
                    click:function() {

                        let me = $(this).dialog('option', 'me');
                        me.setCursorWaiting(true);
                        let cols = me.#prepareCols(clasificame.clasificame("value"));
                        console.log("click Ok cols", cols);
                        let colDef = me.aplica(cols, $(`#${me.varName}_width`).is(":checked"));
                        console.log("colDef", colDef)
                        let label = $(`#${me.inputId}`).val().trim();
                        let para_todos = $(`#${me.varName}_para_todos`).is(":checked") ? 'Si' : 'No';
                        let ocultar_ribbon = $(`#${me.varName}_ribbon`).is(":checked") ? 'Si' : 'No';
                        let myDefault =
                            $(`#${me.varName}_default`).is(":checked") ? 'Si' : 'No';
                        console.log("me.colDefKey", me.colDefKey)
                        if(label.length) {
                            $.ajax({
                                url: '../backoffice/ajax/jqgridcolssorter_acciones.php',
                                method: 'POST',
                                data: {
                                    accion: 'setColDefs',
                                    col_def_key: me.colDefKey,
                                    label: label,
                                    para_todos: para_todos,
                                    ocultar_ribbon: ocultar_ribbon,
                                    myDefault: myDefault,
                                    def: colDef,
                                },
                                cache: false,
                                dataType: 'json',
                            })
                            .done(function (data) {
                                if(!data.status) {
                                    if(data.message.length)
                                        ia.alertError(data.message, 'Error Inesperado');
                                    else
                                        console.log("data.status false sin msg");
                                    return;
                                }

                                let $select = $(`#${me.#selectId}`);
                                if( $select.children(`OPTION[value='${data.value}']`).length === 0) {
                                    $select.append(
                                        `<option selected="selected" value="${data.value}" class="jqgridcolssorter_para_todos_${para_todos}">${label}</option>`
                                    );
                                }
                                me.#extraColsDef[data.value] = colDef;
                            })
                            .fail(function () {
                                ia.alertError("No se guardó la plantilla de columnas");
                                console.log("ERROR: jqgridcolssorter save plantilla", arguments);
                            });
                        }
                        // @TODO jqgridcolssorter throwEvent para que lo cachen los scripts con .on() al cerrar el dialogo
                        me.setCursorWaiting(false);
                        $( this ).dialog( 'close' );
                    }
                },
                {
                    text: 'Cancelar',
                    icon: 'ui-icon-cancel',
                    click: function() {
                        $(this).dialog('close');
                    }
                },
            ],
            close: function() {
                $("#jqgridcolssorter_dialog").remove();
            }
        });
    }

    putGetParam(dflt) {
        let url = new URL(window.location);
        let jqgridcolssorter_id = url.searchParams.get("jqgridcolssorter_id");
        if(jqgridcolssorter_id === null && dflt !== undefined)
            jqgridcolssorter_id = dflt;
        if(jqgridcolssorter_id === null) {
            for(let c of this.#extraColsDef) {
                if (typeof c.myDefault !== 'undefined' && c.myDefault === 'Si') {
                    jqgridcolssorter_id = c.value;
                    break;
                }
            }
        }
        if(jqgridcolssorter_id === null)
            return;
        this.put( jqgridcolssorter_id );
        let id = `#${this.selectId}`;
        setTimeout(function() {$(id).val(jqgridcolssorter_id);},1000);
    }

    /**
     * Llama poner las columnas con el columnSetId de this.#extraColsDef, cambiando el cursor a wait
     *
     * @param {string} columnSetId
     */
    put(columnSetId) {
        this.setCursorWaiting(true);

        let me = this;
        vx_asyncFunction(function () {
            me.#putDo(columnSetId);
            let href = document.location.href;
            let params = new URL(document.location).searchParams;
            if(params.get("jqgridcolssorter_id") !== null)
                href = href.replace(
                    `jqgridcolssorter_id=${params.get("jqgridcolssorter_id")}`,
                    `jqgridcolssorter_id=${columnSetId}`
                    );
            else {
                let sep = href.search('\\?') >= 0 ? '&' : '?';
                href += `${sep}jqgridcolssorter_id=${columnSetId}`;
            }
            history.replaceState({content: document.title}, document.title, href);

            me.setCursorWaiting(false);
        },0,this);
    }

    /**
     * Pone las columnas con el columnSetId de this.#extraColsDef
     *
     * @param {string} columnSetId
     */
    #putDo(columnSetId) {
        console.log("#put", columnSetId);
        if(columnSetId === '')
            return;
        if(columnSetId === 'loaded_default') {
            if(this.#defaultColsDef === null)
                return;
            let cols = this.#prepareCols(this.#defaultColsDef);
            this.aplica(cols, true);
            return;
        }
        for(let oIndex in this.#extraColsDef) {
            if(!this.#extraColsDef.hasOwnProperty(oIndex))
                continue;
            let o = this.#extraColsDef[oIndex];
            if(typeof o!== 'object' || o === null) {
                console.log("putDo error en this.#extraColsDef = ", this.#extraColsDef);
                console.log("                for(let o of this.#extraColsDef) o=", o);
                continue;
            }
            if(o.value === columnSetId) {
                let cols = this.#prepareCols(o.def);
                console.log("o de columnSetId=" + columnSetId, cols)
                this.aplica(cols, true);
                if(typeof o.ocultar_ribbon !== 'undefined')
                    if(o.ocultar_ribbon === 'Si')
                        this.hideRibbon(this.#$grid);
                    else if(o.ocultar_ribbon === 'No')
                        this.showRibbon(this.#$grid);
                return;
            }
        }
    }
    showRibbon($grid) {
        let $captionBar = $(".ui-jqgrid-titlebar", $("#gview_" + $grid[0].id ) );
        if($captionBar.is(":visible"))
            return;

        $captionBar.show(function(){
            if($grid.data('iacfullwindow')) {
                $grid.data('iacfullwindow', false);
                gridMaximize($grid[0].id);
            }
        });
    }

    hideRibbon($grid) {
        let $captionBar = $(".ui-jqgrid-titlebar", $("#gview_" + $grid[0].id ) );
        if(!$captionBar.is(":visible"))
            return;
        $captionBar.hide(function(){
            if($grid.data('iacfullwindow')) {
                $grid.data('iacfullwindow', false);
                gridMaximize($grid[0].id);
            }
        });
    }
    /**
     * Cambia el cursor
     *
     * @param {boolean} waiting true pone cursor en wait, false a normal
     */
    setCursorWaiting(waiting) {
        if(waiting) {
            $("body").addClass('wait');
            return;
        }
        $("body").removeClass('wait');
    }

    /**
     * Pone el colDef en el grid
     *
     * @param {{Oculta: *[], Visible: *[], Width: {}}} colDef deseado
     * @param {boolean} resizeCols en true cambia el width de las columnas al solicitado, es lento
     * @returns {Promise<{Oculta: *[], Visible: *[], Width: *[]}|{Oculta: *[], Visible: *[], Width: {}}>}
     */
    aplica(colDef, resizeCols) {

        if (typeof colDef !== 'object' || colDef === null || typeof colDef.Visible === 'undefined') {
            return {Oculta:[], Visible:[], Width:[]};
        }
        if(typeof colDef.Width === 'undefined')
            colDef.Width = [];
        if(typeof colDef.Oculta === 'undefined')
            colDef.Oculta = [];
        this.#$grid = $(`#${this.#gridId}`);
        let colModel = this.#$grid.jqGrid("getGridParam", "colModel");
        let cmName2Index = {};
        let pk = -1;
        for(let index_1 in colModel)
            if(colModel.hasOwnProperty(index_1)) {
                pk = colModel[index_1].hasOwnProperty('key') && colModel[index_1].key ? index_1 : pk;
                let name = colModel[index_1].name;
                cmName2Index[name] = parseInt(index_1);
                if(name !== '' && name !== 'rn' && name !== 'cb' && name !== 'subgrid' && !colDef.Oculta.includes(name) && !colDef.Visible.includes(name) )
                    colDef.Oculta.push(name);
            }
        if(typeof resizeCols === 'undefined')
            resizeCols = false;
        pk = parseInt(pk);
        // perm: The indexes of the permutation array are the current order, the values are the new order.
        let perm = Array.from({ length: colModel.length }, (value, index) => index);
        let perm_ = Array.from({ length: colModel.length }, (value, index) => index);
        let index = 0;

        for(let name of colDef.Visible) if(name !== 'rn') {
            if (cmName2Index.hasOwnProperty(name))
                perm[++index] = parseInt( cmName2Index[name] );
            if(resizeCols && colDef.hasOwnProperty('Width') && colDef.Width.hasOwnProperty(name))
                this.#$grid.jqGrid("resizeColumn", name, colDef.Width[name], true, true).jqGrid("refreshGroupHeaders");
        }
        for(let iColModel = 0, lenColModel = colModel.length; iColModel < lenColModel; ++iColModel)
            if (!perm.includes(iColModel))
                perm[++index] = iColModel;

        //Fix para el key
        for(let ordered_index = 0; ordered_index < perm.length; ordered_index++){
            if(perm[ordered_index] === pk){
                // Step 1: Remove element at index where value is pk
                let element0 = perm.splice(ordered_index, 1)[0];

                // Step 2: Insert the removed element at index pk
                perm.splice(pk, 0, element0);
                break;
            }
        }

        if(this.debug) {
            let checkPerm = {};
            for(let p of perm) {
                let k = "a" + p;
                if (checkPerm.hasOwnProperty(k))
                    console.log("*** Permutation duplicado (a#) donde # es indice en colmodel has: " + k);
                else
                    checkPerm[k] = k;
            }
        }

        let keyColName = this.#getKeyColumnName();
        if (this.#hideKeyColumn)
        {
            // agregamos el keyColumn a los oculta
            colDef.Oculta.push(keyColName);
            // y eliminamos el keyColumn de los visibles si existe
            const index = colDef.Visible.indexOf(keyColName);
            if (index !== -1)
                colDef.Visible.splice(index, 1);
        }

        // @TODO jqgridcolssorter Revisar y en su caso arreglar si perm no tiene unique values
        this.#$grid.jqGrid("remapColumns", perm, true, false);
        if(this.doHideCols)
            this.hideCols(colDef.Oculta);
        this.showCols(colDef.Visible);
        this.#$grid.jqGrid("refreshGroupHeaders");
        this.#$grid.trigger("jqGridColSorterDone");

        return this.currentColDef(resizeCols);
    }

    showCols(cols) {
        let show = [];
        for(let c of cols) {
            if(this.$grid.jqGrid('getColProp', c).hidden)
                show.push(c);
        }
        if(show.length)
            this.#$grid.showCol(show);
    }

    hideCols(cols) {
        let hide = [];
        for(let c of cols) {
            if(!this.$grid.jqGrid('getColProp', c).hidden)
                hide.push(c);
        }
        if(hide.length)
            this.#$grid.hideCol(hide);
    }
    /**
     * Guarda el colDef actual en this.#defaultColsDef para regresar al default
     *
     * @param {jqgridcolssorter} me
     */
    saveDefault(me) {
        if(typeof me === 'undefined')
            me = this;
        if(me.#defaultColsDef === null)
            me.#defaultColsDef = me.currentColDef(false);
    }

    /**
     * Pregunta y borra el coldef seleccionado
     */
    del() {
        let $select =  $(`#${this.#selectId}`);

        /**
         *
         * @type {string}
         */
        let value= $select.val();
        if(typeof value === 'undefined' || value === '' || Number.isNaN(value))
            return;
        if(value === 'loaded_default') {
            ia.alertInfo("La plantilla original, default, de la pantalla no se puede eliminar");
            return;
        }
        if(isNaN(value)) {
            ia.alertInfo("No se puede eliminar una plantilla azul, propuesta por el sistema");
            return;
        }
        let me = this;
        let label = $select.children(`OPTION[value='${value}']`).first().text();
        ia.confirmDelete(
            `¿Elimino la Plantilla de Columnas: ${label}?`,
            "Confirme Borrar",
            true
        ).done(function(){
            $.ajax({
                url: '../backoffice/ajax/jqgridcolssorter_acciones.php',
                method:'POST',
                data:{accion: 'deleteColDefs', col_def_key: me.#colDefKey, id: value, label:label},
                cache:false,
                dataType:'json',
            })
            .done(function(data) {
                if(!data.status) {
                    if(data.message.length)
                        ia.alertError(data.message, 'Error Inesperado');
                    return;
                }
                $select.children(`OPTION[value='${value}']`).remove();
            })
            .fail(function() {
                ia.alertError("No se borró la plantilla de columnas");
                console.log("ERROR: jqgridcolssorter deñ plantilla", arguments);
            });
        });
    }

    // getters
    get $grid() { return this.#$grid; }

    get colDefKey() { return this.#colDefKey; }

    get varName() { return this.#varName; }

    get inputId() { return this.#inputId; }

    get selectId() { return this.#selectId; }

    /**
     * El colDef inicial
     *
     * @returns {object} {Oculta:[],Visible:[],Width:{}}
     */
    get defaultColDef() { return this.#defaultColsDef; }

    /**
     *
     * @returns {[{label:string, value:string, para_todos:string, def:object}]}
     */
    get extraColsDef() { return this.#extraColsDef; }

    /**
     *
     * @param {boolean} conWidth
     * @returns {{Oculta: *[], Visible: *[], Width: {}}}
     */
    currentColDef(conWidth) {
        let colDef = {Oculta:[], Visible:[], Width:{}};
        let colModel = this.#$grid.jqGrid('getGridParam', 'colModel');
        for(let col of colModel)
            if(col.name !== 'rn' && col.name !== 'cb' && col.name !== 'subgrid')
                if(col.hidden)
                    colDef.Oculta.push(col.name);
                else {
                    colDef.Visible.push(col.name);
                    if(conWidth)
                        colDef.Width[col.name] = this.#$grid.jqGrid('getColProp',col.name).width;
                }
        return colDef;
    }

}
}
