<?php
if (file_exists("../../../inc/config.php")) {
    require_once("../../../inc/config.php");
} else {
    echo "El archivo config.php no se encuentra en la ruta especificada.";
}
require_once("../../../app/iacase_base.php");
?>
<!DOCTYPE html>
<html lang="es-MX es">
<head>
    <meta charset="UTF-8">
    <title>jqGridFilterBuilder Test</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/themes/base/jquery-ui.min.css" integrity="sha512-ELV+xyi8IhEApPS/pSj66+Jiw+sOT1Mqkzlh8ExXihe4zfqbWkxPRi8wptXIO9g73FSlhmquFlUOuMSoXz5IRw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://code.jquery.com/jquery-3.6.0.js"></script>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
    <link rel="stylesheet" href="../../../js2/clasificame/clasificame.css" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="../../../tools/qUnit/qunit.min.css">
</head>
<body>
<?php include '../../../backoffice/view/component/toolbar/menu/menu.php'; ?>


<div id="qunit"></div>
<div id="qunit-fixture"></div>
<i>Chrome code coverage: developer tools -&gt; hamburger menu -&gt; More Tools -&gt; Coverage</i>
<h1 id="qunit-header">QUnit Test Suite</h1>
<h2 id="qunit-banner"></h2>
<div id="qunit-testrunner-toolbar"></div>
<h2 id="qunit-userAgent"></h2>
<ol id="qunit-tests"></ol>
<div id="prueba"></div>
<script>let $vitex_globales = {puede_prohibir_colores: true};</script>
<script src="../../../js2/clasificame/clasificame.js?va=2"></script>
<script src="../../../tools/qUnit/qunit.min.js"></script>

<script>
    $(document).ready(function () {
        QUnit.test("Prueba de la función _AllTo", function (assert) {
            // Crear un elemento DOM para el widget
            let $clasificamePrueba = $("<div id='contenedor_clasificame'><div id='asignaPrueba_clasificame'></div></div></div>");
            $('#prueba').append($clasificamePrueba);
            // Configurar las opciones requeridas
            $clasificamePrueba.clasificame({
                clasificacion: [
                    { clasificaId: 'Nada', label: 'X', title: 'Sin Permiso', userSortable: false },
                    { clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura', userSortable: false },
                    { clasificaId: 'RW', label: 'RW', title: 'Editar', userSortable: false }
                ],
                valueId: 'user_id',
                valueDisplay: 'nick',
                valueColumnKey: 'permiso',
                values: [
                    { user_id: 12, nick: 'Mary', permiso: 'Nada' },
                    { user_id: 13, nick: 'Nary', permiso: 'Nada' },
                    { user_id: 32, nick: 'Joe', permiso: 'Nada' },
                    { user_id: 33, nick: 'Josh', permiso: 'Nada' },
                    { user_id: 333, nick: 'Abel', permiso: 'Nada' },
                    { user_id: 3, nick: 'Zoe', permiso: 'Nada' }
                ],
                label_sort: 'usuarios',
                editable: true
            });

            $clasificamePrueba.clasificame("option", "editable", false);
            let list_first = $(".clasificaItemList", $clasificamePrueba);
            list_first.eq(0).find("li").length;
            assert.strictEqual(list_first.eq(0).find("li").length, 6, "El elemento Nada debe tener 6 elementos li");
            $clasificamePrueba.clasificame("allTo", 'RW');
            assert.strictEqual(list_first.eq(0).find("li").length, 6, "El evento no hace nada si el editable es false");

            $clasificamePrueba.clasificame("option", "editable", true);
            assert.strictEqual($clasificamePrueba.clasificame("option", "editable"), true, "La opción 'editable' se cambió a true");


            $clasificamePrueba.clasificame("allTo", 'RWSW');
            assert.strictEqual(list_first.eq(0).find("li").length, 6, "Si no existe un id válido no hace nada");

            $clasificamePrueba.clasificame("allTo", 'RW');
            assert.strictEqual(list_first.eq(0).find("li").length, 0, "Se cambió de lugar");
            $clasificamePrueba.clasificame("allTo", 'Nada');
        });

        QUnit.test('Inicializando widget', function (assert) {
            // Crea una instancia del widget
            let $widgetElement = $("<div></div>");
            $widgetElement.clasificame(); // Inicializa el widget

            // Realiza las aserciones correspondientes
            assert.ok($widgetElement.clasificame, "El widget clasificame está definido");
            assert.strictEqual($widgetElement.clasificame("version"), "2.0.3 2024-08-16", "La versión del widget debe ser '2.0.3 2024-08-16'");
        });


        QUnit.test("Prueba de cambio de opciones", function (assert) {
            let $widgetElement = $("<div></div>");
            $widgetElement.clasificame(); // Inicializa el widget

            // Verifica las opciones iniciales
            assert.strictEqual($widgetElement.clasificame("option", "editable"), true, "La opción 'editable' debe ser true inicialmente");

            // Cambia la opción 'editable' a false
            $widgetElement.clasificame("option", "editable", false);

            // Verifica que la opción 'editable' se haya actualizado correctamente
            assert.strictEqual($widgetElement.clasificame("option", "editable"), false, "La opción 'editable' debe ser false después de cambiarla");
        });

        QUnit.test("Prueba de la opción valueId", function (assert) {
            let $widgetElement = $("<div></div>");
            $widgetElement.clasificame({
                valueId: "user_id"
            }); // Inicializa el widget con la opción valueId

            // Obtén el valor actual de la opción valueId
            let currentValueId = $widgetElement.clasificame("option", "valueId");

            // Verifica que el valor de la opción valueId sea el esperado
            assert.strictEqual(currentValueId, "user_id", "El valor de la opción valueId debe ser 'user_id'");
        });

        QUnit.test("Prueba de la opción clasificacion", function (assert) {
            let $widgetElement = $("<div></div>");
            $widgetElement.clasificame({
                clasificacion: [
                    { clasificaId: 'Nada', label: 'X', title: 'Sin Permiso', userSortable: false },
                    { clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura', userSortable: false },
                    { clasificaId: 'RW', label: 'RW', title: 'Editar', userSortable: false }
                ]
            }); // Inicializa el widget con la opción clasificacion

            // Obtén el valor actual de la opción clasificacion
            let currentClasificacion = $widgetElement.clasificame("option", "clasificacion");

            // Verifica que el valor de la opción clasificacion sea el esperado
            assert.deepEqual(
                currentClasificacion,
                [
                    { clasificaId: 'Nada', label: 'X', title: 'Sin Permiso', userSortable: false },
                    { clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura', userSortable: false },
                    { clasificaId: 'RW', label: 'RW', title: 'Editar', userSortable: false }
                ],
                "El valor de la opción clasificacion debe ser el arreglo esperado"
            );
        });

        QUnit.test("Prueba de las opciones valueId, valueDisplay y valueColumnKey", function (assert) {
            let $widgetElement = $("<div></div>");
            $widgetElement.clasificame({
                valueId: 'user_id',
                valueDisplay: 'nick',
                valueColumnKey: 'permiso'
            }); // Inicializa el widget con las opciones valueId, valueDisplay y valueColumnKey

            // Verifica el valor de la opción valueId
            assert.strictEqual(
                $widgetElement.clasificame("option", "valueId"),
                "user_id",
                "El valor de la opción valueId debe ser 'user_id'"
            );

            // Verifica el valor de la opción valueDisplay
            assert.strictEqual(
                $widgetElement.clasificame("option", "valueDisplay"),
                "nick",
                "El valor de la opción valueDisplay debe ser 'nick'"
            );

            // Verifica el valor de la opción valueColumnKey
            assert.strictEqual(
                $widgetElement.clasificame("option", "valueColumnKey"),
                "permiso",
                "El valor de la opción valueColumnKey debe ser 'permiso'"
            );
        });

        QUnit.test("Prueba de la opción values", function (assert) {
            let $widgetElement = $("<div></div>");
            $widgetElement.clasificame({
                clasificacion: [
                    { clasificaId: 'Nada', label: 'X', title: 'Sin Permiso', userSortable: false },
                    { clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura', userSortable: false },
                    { clasificaId: 'RW', label: 'RW', title: 'Editar', userSortable: false }
                ],
                values: [
                    { user_id: 12, nick: 'Mary', permiso: 'Nada' },
                    { user_id: 13, nick: 'Nary', permiso: 'Nada' },
                    { user_id: 32, nick: 'Joe', permiso: 'Nada' },
                    { user_id: 33, nick: 'Josh', permiso: 'Nada' },
                    { user_id: 333, nick: 'Abel', permiso: 'Nada' },
                    { user_id: 3, nick: 'Zoe', permiso: 'Nada' }
                ]
            });

            let widgetInstance = $widgetElement.clasificame("instance");

            // Accede a la opción 'values' del widget y verifica su contenido
            assert.deepEqual(
                widgetInstance.options.values,
                [
                    { user_id: 12, nick: 'Mary', permiso: 'Nada' },
                    { user_id: 13, nick: 'Nary', permiso: 'Nada' },
                    { user_id: 32, nick: 'Joe', permiso: 'Nada' },
                    { user_id: 33, nick: 'Josh', permiso: 'Nada' },
                    { user_id: 333, nick: 'Abel', permiso: 'Nada' },
                    { user_id: 3, nick: 'Zoe', permiso: 'Nada' }
                ],
                "El contenido de la opción 'values' debe ser el esperado"
            );
        });

        QUnit.test("Prueba de eventos", function (assert) {
            let $widgetElement = $("<div></div>");
            $widgetElement.clasificame(); // Inicializa el widget

            // Simula un evento de clic en un elemento del widget
            $widgetElement.find(".clasificaToolBar").trigger("click");

            // Verifica que se haya disparado el evento correspondiente y se haya manejado adecuadamente
            assert.ok(true, "El evento de clic debe haberse disparado y manejado correctamente");
        });

        QUnit.test("Prueba de manipulación del DOM", function (assert) {
            let $widgetElement = $("<div></div>");
            $widgetElement.clasificame(); // Inicializa el widget

            // Verifica que el widget agregue elementos al DOM correctamente
            assert.strictEqual($widgetElement.find(".clasificaAllTo").length, 3, "Se debe agregar el elemento '.clasificaAllTo'");
            assert.strictEqual($widgetElement.find(".clasificaFind").length, 3, "Se debe agregar el elemento '.clasificaFind'");
        });


        QUnit.test("Prueba de la función readonly", function (assert) {
            let done = assert.async();
            let $widgetElement = $("<div></div>"); // No necesitas IDs específicos a menos que los uses en tu widget
            $("body").append($widgetElement); // Asegúrate de que el widget esté en el DOM para que funcione correctamente


            // Configurar las opciones
            let options = {
                clasificacion: [
                    { clasificaId: 'Nada', label: 'X', title: 'Sin Permiso', userSortable: false },
                    { clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura', userSortable: false },
                    { clasificaId: 'RW', label: 'RW', title: 'Editar', userSortable: false }
                ],
                valueId: 'user_id',
                valueDisplay: 'nick',
                valueColumnKey: 'permiso',
                values: [
                    { user_id: 12, nick: 'Mary', permiso: 'Nada' },
                    { user_id: 13, nick: 'Nary', permiso: 'Nada' },
                    { user_id: 32, nick: 'Joe', permiso: 'Nada' },
                    { user_id: 33, nick: 'Josh', permiso: 'Nada' },
                    { user_id: 333, nick: 'Abel', permiso: 'Nada' },
                    { user_id: 3, nick: 'Zoe', permiso: 'Nada' }
                ],
                label_sort: 'usuarios',
                editable: true // Se espera que esté en modo de solo lectura
            };

            $widgetElement.clasificame(options);

            function checkElementsRemoved() {
                let allToCount = $widgetElement.find(".clasificaAllTo").length;
                if (allToCount === 0) {
                    assert.strictEqual(allToCount, 0, "✅ Los elementos .clasificaAllTo se eliminaron correctamente");
                    done(); // Finalizar la prueba
                } else {
                    setTimeout(checkElementsRemoved, 50); // Intentar de nuevo después de 50ms
                }
            }

            let timeout = setTimeout(function () {
                assert.ok(true, "❌ Tiempo de espera agotado");
                done();
            }, 8000); // 2 segundos de tiempo máximo

            checkElementsRemoved();
        });





        QUnit.test("Prueba de la función AllTo", function (assert) {
            let $clasificamePrueba = contruyendoClasificame(true);
            let list_first = $(".clasificaItemList", $clasificamePrueba);
            assert.strictEqual(list_first.eq(0).find("li").length, 6, "El elemento Nada debe tener 6 elementos li");
            $clasificamePrueba.clasificame("allTo", 'RW');
            assert.ok(true, "Se lanzó el evento allTo para RW");
            assert.strictEqual(list_first.eq(0).find("li").length, 0, "Se cambió de lugar");
            assert.strictEqual(list_first.eq(2).find("li").length, 6, "Ahora está en RW");
            $clasificamePrueba.clasificame("allTo", 'Nada');
        });

        QUnit.test("Prueba de evento keyup en input en find", function (assert) {
            let $clasificamePrueba = contruyendoClasificame(true);
            let input_busqueda = $(".clasificaFind", $clasificamePrueba).first();
            input_busqueda.val("Zoe");
            input_busqueda.trigger("keyup");
            assert.ok(true, "Se introdujo Zoe en el input de búsqueda");
            let list_first = $(".clasificaItemList", $clasificamePrueba);
            assert.strictEqual(list_first.eq(0).find("li:visible").length, 1, "Se encontró un elemento Zoe en la búsqueda");
            let clearFind = $(".clasificaFindClear", $clasificamePrueba).first();
            clearFind.trigger("click");
            assert.strictEqual(list_first.eq(0).find("li:visible").length, 6, "Se borró con éxito la búsqueda");
        });

        QUnit.test("Prueba de addValues", function (assert) {
            let $clasificamePrueba = contruyendoClasificame(true);
            let list_first = $(".clasificaItemList", $clasificamePrueba);
            assert.strictEqual(list_first.eq(0).find("li").length, 6, "El elemento Nada debe tener 6 elementos li");
            let values = [
                { user_id: 120, nick: 'Cain (H)', permiso: 'Nada' },
                { user_id: 133, nick: 'Harry (H)', permiso: 'Nada' },
                { user_id: 323, nick: 'Ana', permiso: 'Nada' },
                { user_id: 332, nick: 'Abel', permiso: 'Nada' },
                { user_id: 335, nick: 'Clara', permiso: 'Nada' },
                { user_id: 390, nick: 'Lilia', permiso: 'Nada' }
            ];
            $clasificamePrueba.clasificame("addValues", values);
            assert.ok(true, "Se lanzó el evento addValues añadiendo otros 6 elementos");
            assert.strictEqual(list_first.eq(0).find("li").length, 12, "El elemento Nada debe tener 12 elementos li");
        });

        QUnit.test("Prueba de fromTo", function (assert) {
            let $clasificamePrueba = contruyendoClasificame(true);
            let list_element = $(".clasificaItemList", $clasificamePrueba);
            assert.strictEqual(list_element.eq(0).find("li").length, 6, "El elemento Nada debe tener 6 elementos li");
            $clasificamePrueba.clasificame("fromTo", 'Nada', 'RW');
            assert.ok(true, "Se lanzó el evento fromTo de Nada a RW");
            assert.strictEqual(list_element.eq(0).find("li").length, 0, "El elemento Nada debe tener 0 elementos li");
            assert.strictEqual(list_element.eq(2).find("li").length, 6, "El elemento RW debe tener 6 elementos li");
        });

        QUnit.test("Prueba de _clickTo", function (assert) {
            let $clasificamePrueba = contruyendoClasificame(true);
            let list_element = $(".clasificaItemList", $clasificamePrueba);
            assert.strictEqual(list_element.eq(0).find("li").length, 6, "El elemento Nada debe tener 6 elementos li");
            assert.strictEqual(list_element.eq(2).find("li").length, 0, "El elemento RW debe tener 0 elementos li");
            list_element.eq(0).find("li").first().find('span').last().trigger("click");
            assert.ok(true, "Se hizo el evento click en el botón de RW");
            list_element = $(".clasificaItemList", $clasificamePrueba);
            assert.strictEqual(list_element.eq(0).find("li").length, 5, "El elemento Nada debe tener 5 elementos li");
            assert.strictEqual(list_element.eq(2).find("li").length, 1, "El elemento RW debe tener 1 elemento li");
        });

        QUnit.test("Prueba de flechas de desplazamiento previous", function (assert) {
            let $clasificamePrueba = contruyendoClasificame(true);
            let list_element = $(".clasificaItemList", $clasificamePrueba);
            assert.strictEqual(list_element.eq(0).find("li").length, 6, "El elemento Nada debe tener 6 elementos li");
            assert.strictEqual(list_element.eq(2).find("li").length, 0, "El elemento RW debe tener 0 elementos li");
            let flecha_derecha = $(".previous", $clasificamePrueba).first();
            flecha_derecha.trigger("click");
            assert.ok(true, "El evento clic mandó todos los elementos de Nada a RW");
            assert.strictEqual(list_element.eq(0).find("li").length, 0, "El elemento Nada debe tener 0 elementos li");
            assert.strictEqual(list_element.eq(2).find("li").length, 6, "El elemento RW debe tener 6 elementos li");
        });

        QUnit.test("Prueba de flechas de desplazamiento next", function (assert) {
            let $clasificamePrueba = contruyendoClasificame(true);
            let list_element = $(".clasificaItemList", $clasificamePrueba);
            assert.strictEqual(list_element.eq(0).find("li").length, 6, "El elemento Nada debe tener 6 elementos li");
            assert.strictEqual(list_element.eq(1).find("li").length, 0, "El elemento RO debe tener 0 elementos li");
            let flecha_derecha = $(".next", $clasificamePrueba).first();
            flecha_derecha.trigger("click");
            assert.ok(true, "El evento clic mandó todos los elementos de Nada a RO");
            assert.strictEqual(list_element.eq(0).find("li").length, 0, "El elemento Nada debe tener 0 elementos li");
            assert.strictEqual(list_element.eq(1).find("li").length, 6, "El elemento RO debe tener 6 elementos li");
        });

        function contruyendoClasificame(editable = false) {
            $('#prueba').empty();
            let $clasificamePrueba = $("<div id='contenedor_clasificame'><div id='asignaPrueba_clasificame'></div></div></div>");
            $clasificamePrueba.clasificame({
                clasificacion: [
                    { clasificaId: 'Nada', label: 'X', title: 'Sin Permiso', userSortable: false },
                    { clasificaId: 'RO', label: 'RO', title: 'Sólo Lectura', userSortable: false },
                    { clasificaId: 'RW', label: 'RW', title: 'Editar', userSortable: false }
                ],
                valueId: 'user_id',
                valueDisplay: 'nick',
                valueColumnKey: 'permiso',
                values: [
                    { user_id: 69, nick: 'ale', permiso: 'Nada' },
                    { user_id: 83, nick: 'alberto (H)', permiso: 'Nada' },
                    { user_id: 97, nick: 'Joe', permiso: 'Nada' },
                    { user_id: 82, nick: 'Josh', permiso: 'Nada'},
                    { user_id: 101, nick: 'Abel', permiso: 'Nada' },
                    { user_id: 132, nick: 'Zoe', permiso: 'Nada' }
                ],
                label_sort: 'usuarios',
                editable: editable
            });
            $('.previous', $clasificamePrueba).html('⇚');
            $('.next', $clasificamePrueba).html('➾');
            $('#prueba').append($clasificamePrueba);
            return $clasificamePrueba;
        }
    });
</script>

</body>
</html>

