// noinspection JSUnusedGlobalSymbols
class Repartidor {
    #version = "1.02.01 2023-10-06"; version() { return this.#version; }

    variables = {};
    KEY_VAR = "_var";
    KEY_CSS = "_css";
    KEY_APPEND_TAG = "_append"; // ojo es igual que {BODY:{append:"<style>..</style>"}}


    /**
     *
     * @param variables object {"variableName":variable, varNamed,}
     */
    constructor(variables = {}) {
        this.variables = variables;
    }

    /**
     *  {mediaQuery:{html:xxx,addClass:"gatos", show:34, fadeTo:["slow", 0.25]}, innerHtml:"<b>DOM value</b>"} o
     *  { _css:{className:"css string"} } o
     *  { _var:{variableName:"value", variableName.property:"value", variableName.function:"Parameters"} } o
     *  { _append:"<style>...</style>" | ["<style>...</style>", "<script></script>"]} o
     *  [{mediaQuery:{html:xxx,addClass:}}, { _css:{className:"css string"} },  { _append:"<style>...</style>" | ["<style>...</style>"]}]
     *  o un array de estos de arriba
     *
     * @param repartir
     */
    reparte(repartir) {
        if(Array.isArray(repartir))
            for(let arrayItem of repartir)
                this.#reparteDo(arrayItem);
        else
            this.#reparteDo(repartir);
    }

    /**
     *  {mediaQuery:{html:xxx,addClass:}} o
     *  { _var:{variableName:"value", variableName.property:"value", variableName.function:"Parameters"} } o
     *  { _css:{className:"css string"} } o
     *  { _append:"<style>...</style>" | ["<style>...</style>","<script></script>"]}
     *
     * @param repartir
     */
    #reparteDo(repartir) {
        for(let key in repartir)
            if(repartir.hasOwnProperty(key)) {
                let values = repartir[key];
                switch(key) {
                    case this.KEY_APPEND_TAG:
                        let $body = $("BODY");
                        if(Array.isArray(values))
                            for(let a in values)
                                $body.append(a)
                        else
                            $body.append(values);
                        break;
                    case this.KEY_CSS:
                        for(let className in values)
                            if(values.hasOwnProperty(className))
                                this.#setCssClass(className, values[className]);
                        break;
                    case this.KEY_VAR:
                        for(let varToUse in values) {
                            if (values.hasOwnProperty(varToUse))
                                try {
                                    let parts = varToUse.split(".");
                                    if (typeof this.variables[parts[0]] === "undefined")
                                        continue;
                                    let variable = this.variables[parts[0]];
                                    for (let i = 1, len = parts.length; i < len; ++i) {
                                        if (typeof variable === "function")
                                            break;
                                        variable = variable[parts[i]];
                                    }
                                    if (typeof variable === "function")
                                        if (Array.isArray(values[varToUse]))
                                            variable.apply(variable, values[varToUse]);
                                        else
                                            variable(values[varToUse]);
                                    else
                                        variable = values[varToUse];
                                    break;
                                } catch (error) {
                                    console.log(`* ERROR: using variable varToUse`, error);
                                }
                        }
                        break;
                    default:
                        let $el = $(key);
                        for(let func in values)
                            if(values.hasOwnProperty(func))
                                $el.each(function () {
                                    let $this = $(this);
                                    if(typeof $this[func] === "function")
                                        try {
                                            if (Array.isArray(values[func]))
                                                $this[func].apply($this, values[func]);
                                            else
                                                $this[func](values[func]);
                                        } catch (error) {
                                            console.log(`* ERROR: $(${key}).${func}(...)`, error);
                                        }
                                    else if (typeof this[func] === "function")
                                        try {
                                            if (Array.isArray(values[func]))
                                                this[func].apply(this, values[func]);
                                            else
                                                this[func](values[func]);
                                        } catch (error) {
                                            console.log(`* ERROR: document(key).func(...)`, error);
                                        }
                                    else if (typeof this[func] !== "undefined")
                                        this[func] = values[func];
                                });
                } // switch_end
            } // hasOwnProperty end
    }

    #setCssClass(className, style) {
        if(typeof style === "string" && style.indexOf("{") >= 0 && style.lastIndexOf("}") >=0 )
            style = style.substring(style.indexOf("{") + 1,  style.lastIndexOf("}")).trim();
        let rule = this.#getLastRule(className);
        if(rule === false) {
            let iStyleSheet = document.styleSheets.length - 1;
            document.styleSheets[iStyleSheet].insertRule(className + " {" +
                (typeof style === "string" ? style : this.#styleObject2String(style)) +  "}",
                document.styleSheets[iStyleSheet].length);
            return;
        }
        let useStyle = (typeof style === "string") ? this.#styleString2object(style) : style;
        for(let s in useStyle)
            if(useStyle.hasOwnProperty(s))
                rule.style[s] = useStyle[s];
    }

    #styleObject2String(obj) {
        let str = "";
        for(let s in obj)
            if(obj.hasOwnProperty(s))
                str += s.trim() + ":" + obj[s].toString().trim() + ";";
        return str;
    }

    #styleString2object(str) {
        let style = {},
            pairs = str.split(";");
        for(let i=0, len=pairs.length; i < len; ++i) {
            if(pairs[i].length > 0) {
                let s = pairs[i].split(":");
                if(s.length === 2)
                    style[s[0].trim()] = s[1].trim();
            }
        }
        return style;
    }

    /**
     * Get document.styleSheets[LastDefinition].rules for className, use .lbl or #id
     *
     * @param className  {string}
     * @returns {CSSRule|boolean} false on not found
     */
    #getLastRule(className) {
        for(let iStyleSheet=document.styleSheets.length -1; iStyleSheet >= 0; --iStyleSheet) {
            let classes = document.styleSheets[iStyleSheet].rules || document.styleSheets[iStyleSheet].cssRules;
            for (let x = classes.length -1; x >= 0; --x) {
                if (classes[x].selectorText === className)
                    return classes[x];
            }
        }
        return false;
    }

}
