<?php
if (file_exists("../../../inc/config.php")) {
    require_once("../../../inc/config.php");
} else {
    echo "El archivo config.php no se encuentra en la ruta especificada.";
}
require_once("../../../app/iacase_base.php");
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Prueba Unitaria - Share Button</title>
    <link rel="stylesheet" href="../../../tools/qUnit/qunit.min.css">
    <link rel="stylesheet" href="https://code.jquery.com/qunit/qunit-2.19.1.css">
    <script src="https://code.jquery.com/qunit/qunit-2.19.1.js"></script>

</head>
<body>
<?php include '../../../backoffice/view/component/toolbar/menu/menu.php'; ?>
<div id="qunit"></div>
<div id="qunit-fixture"></div>

<div style="display: flex; align-items: center; gap: 5px;">
    <button title="COMPARTIR" type="button" id="shareButton" class="share-btn pointer noprin">
        <i class="fa-solid fa-share"></i>
    </button>
    <img src="../img/icons/Paste.png" alt="Copiar Destino" class="pointer noprint" onclick="imageDestino()" title="Copiar Destino JPG" style="width: 20px; height: 20px; cursor: pointer;">
</div>

<script>
    // Función que se ejecuta al hacer clic en el botón
    document.getElementById("shareButton").addEventListener("click", function (event) {
        event.preventDefault();

        const urlActual = decodeURIComponent(window.location.href);
        const notaBodegaId = new URLSearchParams(window.location.search).get('nota_bodega_id');
        const iah = new URLSearchParams(window.location.search).get('iah');

        let urlCorta = urlActual.split('?')[0] + '?nota_bodega_id=' + notaBodegaId;

        if (iah && iah !== 'null') {
            urlCorta += '&&iah=' + iah;
        }

        imageDestino();
        setTimeout(() => {
            const mensaje = `¡Reviza la nota #123 de la bodega Bodega Ejemplo 📄\n\n ENLACE: \n\n${urlCorta}`;
            const whatsappWebURL = `https://web.whatsapp.com/send?text=${encodeURIComponent(mensaje)}`;
            window.open(whatsappWebURL, '_blank');
        }, 1000);
    });

    // Función simulada para imageDestino
    function imageDestino() {
        console.log("Función imageDestino ejecutada");
    }
</script>

<script>
    // Pruebas unitarias con QUnit
    QUnit.test("Prueba del evento click en shareButton", function (assert) {
        const done = assert.async();

        // 1. Prepara los valores de prueba
        const testNotaBodegaId = "123";
        const testIah = "456";
        const testBaseUrl = "https://ejemplo.com/ruta";
        const testFullUrl = testBaseUrl + "?nota_bodega_id=" + testNotaBodegaId + "&iah=" + testIah;
        const testShortUrl = testBaseUrl + "?nota_bodega_id=" + testNotaBodegaId + "&&iah=" + testIah;

        // 2. Guardar las funciones/objetos originales
        const originalDecodeURIComponent = window.decodeURIComponent;
        const originalURLSearchParams = window.URLSearchParams;
        const originalImageDestino = window.imageDestino;
        const originalWindowOpen = window.open;
        const originalSplit = String.prototype.split;

        try {
            // 3. Crear mocks para las funciones necesarias

            // Mock para decodeURIComponent
            window.decodeURIComponent = function() {
                return testFullUrl;
            };

            // Mock para URLSearchParams
            window.URLSearchParams = function() {
                return {
                    get: function(param) {
                        if (param === 'nota_bodega_id') return testNotaBodegaId;
                        if (param === 'iah') return testIah;
                        return null;
                    }
                };
            };

            // Mock para String.prototype.split
            String.prototype.split = function(delimiter) {
                if (this.toString() === testFullUrl && delimiter === '?') {
                    return [testBaseUrl, "nota_bodega_id=" + testNotaBodegaId + "&iah=" + testIah];
                }
                return originalSplit.call(this, delimiter);
            };

            // Mock para imageDestino
            let imageDestinoCalled = false;
            window.imageDestino = function() {
                imageDestinoCalled = true;
            };

            // Mock para window.open
            let windowOpenCalled = false;
            let openedUrl = '';
            window.open = function(url) {
                windowOpenCalled = true;
                openedUrl = url;
                return true;
            };

            // 4. Simular el clic en el botón compartir
            const shareButton = document.getElementById("shareButton");
            const clickEvent = new Event("click", { bubbles: true, cancelable: true });
            shareButton.dispatchEvent(clickEvent);

            // 5. Verificar después del timeout
            setTimeout(function() {
                // Verificar que imageDestino fue llamado
                assert.ok(imageDestinoCalled, "La función imageDestino se ejecutó");

                // Verificar que window.open fue llamado
                assert.ok(windowOpenCalled, "Se abrió una nueva ventana con window.open");

                // Verificar que la URL abierta contiene los parámetros correctos
                assert.ok(openedUrl.includes(encodeURIComponent(testShortUrl)), "La URL compartida contiene la dirección correcta");

                // Finalizar la prueba asíncrona
                done();
            }, 1100); // Un poco más que el setTimeout original de 1000ms

        } finally {
            // 6. Restaurar todas las funciones originales después de la prueba
            setTimeout(function() {
                window.decodeURIComponent = originalDecodeURIComponent;
                window.URLSearchParams = originalURLSearchParams;
                window.imageDestino = originalImageDestino;
                window.open = originalWindowOpen;
                String.prototype.split = originalSplit;
            }, 1200);
        }
    });
</script>