let infoListaPrecios= {}

$(document).ready(function() {
   let icono_precios_tiendas= $('#li_precios_tiendas');

   if(icono_precios_tiendas.length){
      eventsLiPrecios()
      //funciones para li precios


      function eventsLiPrecios() {
        icono_precios_tiendas.on('click',function(e) {
          const $usuarioTipoRony= $vitex_globales.es_usuario_tipoRony;
          if(!$usuarioTipoRony)
            buscandoPermisoPreciosTiendas()
          else 
            questionUserRony();
        });
       }
    
       function buscandoPermisoPreciosTiendas(id=null, name=null) {

        infoListaPrecios= {
            ids: [],
            totalLists: 0,
            totalProductos: 0
          }

        //consultando permiso para precios tiendas
        $.ajax({
            url: '../backoffice/ajax/crudList.php',
            type: 'POST',
            data: {accion:'obteniendoPermisos', id},
            success: function(response) {
              if(!response.status){
                ia.alertError(response.message, "Hubo un error", true);
                return;
              }
              let {data}= response;
              let tiendas_ids= data.map(element=>element.tienda_id);
              let objSend={
                ids: tiendas_ids,
                res: data,
                id,
                name
              }
                      if(response.data.length>0)
                        obteniendoListaPrecios(objSend);
                     
                      else ia.alertError("No tiene permisos asignados para ver alguna lista", "Hubo un error", true);
                  
                
            },
            error: function(xhr, status) {
                ia.alertError("Hubo un error al obtener los permisos", "Hubo un error", true);
            }
        })
      
      }

      async function questionUserRony() {
        let dialogo= $('<div></div>');
        let body= $('<div></div>', {class:' m-4'});
      
        let alert= $('<div></div>', {class:'alert-warning', text:'Al ser usuario tipo rony puedes ver las listas de precios de cualquier usuario, selecciona un usuario para ver sus listas de precios, si no seleccionas ningun usuario se veran las listas de precios de todas las tiendas con todos los productos activos a la fecha.'});
        alert.css({
          'padding': '10px',
          'border-radius': '5px',
          'margin': '10px',
          'font-size': '0.9em',
          'text-align': 'center',
          'font-weight': 'bold',
          'color': 'rgb(147 117 51)',
          'background-color': 'rgb(248 238 215)'

        });
        body.append(alert);
        let p= 
          $('<label></label>', 
            {
              text:'Ver listas como otro usuario', 
              class:'text-center font-bold', 
              for:'selectUser'
            });
          
        let select= $('<select></select>', {id:'selectUser', class:'form-control my-2'}).css('width', '50%');
        let option= $('<option></option>', {value:'', text:'Selecciona un usuario'});
        select.append(option);
      
        let div= $('<div></div>', {class:'flex justify-content-center align-items-center'});
        await obteniendoUsuariosModalList(select);
      
        div.append(p , select);
        body.append(div);
      
        dialogo.append(body);
      
        let objBtns= [
          {
            text: 'Aceptar',
            click: function () {
                let id= select.val();
                let name= select.find('option:selected').text().trim();
                if(!id) {id=null; name=null;}
                buscandoPermisoPreciosTiendas(id, name);
                $(this).remove();
            },
      
        },
            
            {
              text: 'Cancelar',
              click: function () {
                  $(this).remove();
              },
      
          },
         
        ]; 
      
        creandoListDialog(
            dialogo, 
            null,
             {
                  autoOpen: true,
                  resizable: true,
                  width: "50%",
                  heigth: 200,
                  title: 'Ver listas como otro usuario',
              }, 
              objBtns);
      
      
        
      }
     
   }




});


async function obteniendoUsuariosModalList(select) {

  await $.ajax({
    url: '../backoffice/ajax/crudList.php',
    type: 'POST',
    data: {accion:'getAllUsers'},
    success: function(response) {
      if(!response.status){
        ia.alertError(response.message, "Hubo un error", true);
        return;
      }
      let {data}= response;
      data.forEach(element => {
        let {nick, iac_usr_id, userPermiso}= element;
        let option= $('<option></option>', {value:iac_usr_id, text:userPermiso});
        select.append(option);
      });
    },
    error: function(xhr, status) {
        ia.alertError("Hubo un error al obtener los usuarios", "Hubo un error", true);
    }
  })

}

function creandoListDialog(dialogo, callback=null, objConf={}, objBtns={}) {
    //si no se mandan botones se crean los botones por defecto
    if(Object.keys(objBtns).length===0){
      objBtns= {
          Aceptar: function () {
              callback($(this));
          },
          Cancelar: function () {
              $(this).remove();
          }

      };
  }

  dialogo.dialog({
      modal: false,
      ...objConf,
      buttons: objBtns,
      close: function () {
          $(this).remove();
      }
  });
}

 function obteniendoListaPrecios({ids, res, id, name}) {
    if($('#generandoModalList').length) {
      $('#generandoModalList').remove();
      return;
    }



    let dialogo= $('<div id="generandoModalList"></div>');
    let body= $('<div id="ListPrecioTienda"></div>');
    let toolbar=`<div class="toolbar_exporter tableLiPrecios none" style="position: absolute; top: 80px;"> </div>`;
    let busqueda= $('<div></div>', {class:'my-2 flex align-items-center none', id:'listFound'} );
    let input= $('<select></select>', { id:'inputBusqueda', multiple:true, class:'form-control', placeholder:'Buscar producto' });
    let iconClear= $('<i></i>', {class:'fa-solid fa-xmark-large clear-mack', id:'iconClear'});
    iconClear.on('click', ()=>input[0].selectize.clear());
    busqueda.append(input , iconClear);
    body.append(busqueda);
    
    let container= $('<div></div>',{id:'containerList', class:'mx-80 m-auto h-60vh' })
    .css({heigth:'60vh', overflow:'auto' });
    let tableLiPrecios= $(`<table id="table_li_precios" class="table table-striped table-bordered table-hover" style="width:unset"></table>`);
    let spinner= $('<div></div>', {class: 'sk-cube-grid'});
    let body_spinner= 
      $(`<div class="sk-cube sk-cube1"></div>
             <div class="sk-cube sk-cube2"></div>
             <div class="sk-cube sk-cube3"></div>
             <div class="sk-cube sk-cube4"></div>
            <div class="sk-cube sk-cube5"></div>
            <div class="sk-cube sk-cube6"></div>
            <div class="sk-cube sk-cube7"></div>
            <div class="sk-cube sk-cube8"></div>
            <div class="sk-cube sk-cube9"></div>
        `);
      spinner.append(body_spinner);
    
      let container_spinner= $('<div></div>', {class: 'absolute flex justify-content-center align-items-center container_spinner h-60vh', id:'container_spinner'});
      container_spinner.append(spinner);
      container.append(tableLiPrecios)
      body.append(container).append(toolbar);
      container.append(container_spinner);



    dialogo.append(body);

    let objBtns= [
      {
          text: 'Cerrar',
          click: function () {
              $(this).remove();
          },

      },

  ];

    creandoListDialog(dialogo, null, {
        autoOpen: true,
        resizable: true,
        width: "80%",
        heigth: 1200,
        title: 'Listas de costos',
    },
    
    objBtns);


    

        $.ajax({
          url: '../backoffice/ajax/crudList.php',
          type: 'POST',
          data: {accion:'obteniendoListaPrecios', ids, usuario: id},
          success: function(response) {
          
            if(!response.status){
              ia.alertError(response.message, "Hubo un error", true);
              return;
            }
            
            contruyendoModalListaPrecios({response, res, name, input});
           
            input.selectize({
              plugins: ["remove_button"],
              delimiter: ",",
              onInitialize : function() {
                  let wrapper= this.$wrapper[0];
                  let container= $(wrapper).parent();

                  $wrapper= $(wrapper);

                  $wrapper
                      .css(
                          {
                              'width': '100%',
                              'height': '50px',
                          }
                      );
                  $wrapper
                      .find('.selectize-input')
                      .css({
                          'height': '40px',
                          'max-height': '50px',
                      });

              },

          });

          input.on('change', filtrandoListaPrecios);
          },
          error: function(xhr, status) {
              ia.alertError("Hubo un error al obtener las listas", "Hubo un error", true);
          }
        })
      }
      function contruyendoModalListaPrecios(sendList) {

        let { response, res, name, input}= sendList;
        $('#container_spinner').remove();
        $('#listFound').removeClass('none');
        let {data, info_lista, tiendasEnLista, productos}= response;
        let productosShow=productos.length
        let totalProductos= $vitex_globales.g_cat_producto_general.length;
        let table= $('#table_li_precios');
        let listasLength= info_lista.length;
          generandoCaptionsLi({table, res, name, productosShow, totalProductos, listasLength});
          generanddHeadLitsa({table, info_lista, tiendasEnLista});
          generandoBodyListas({table, data, productos, input});
          

     }

     function generandoBodyListas(info) {
      let {productos, table, data, input} = info
      
      let tbody= $('<tbody></tbody>');


      productos.forEach(prd => {
        let {producto_general_id, unidad, producto}= prd;
        let precios_producto= data[producto_general_id];
        
        let opc= $('<option></option>', {value:producto_general_id, text:producto});
        input.append(opc);

        let tr= $('<tr></tr>');
        tr.attr('data-id', producto_general_id);


        let td_producto= $('<td></td>', {class:'text-center px-2 py-1' , text:producto});
        let td_unidad= $('<td></td>', {class:'text-center px-2 py-1' , text:unidad});

        tr.append(td_producto);

        precios_producto.forEach(element => {
          let { precio_pesos}= element;

          if(!precio_pesos)precio_pesos= '0.00'
          let vacio= precio_pesos=='0.00' ? 'set-empty': '';
          let td_precio= $('<td></td>', {class:`text-right px-2 py-1 ${vacio}` , text:`${precio_pesos}`});

          tr.append(td_precio);
          
        });

        tr.append(td_unidad);

        tbody.append(tr);
      });

      table.append(tbody);
     }
     function generandoCaptionsLi({table, res, name, productosShow, totalProductos, listasLength}) {

        let caption= $('<caption></caption>', {class:'text-center h-60 align-content-center px-3 justify-content-center '});
        let claves= res.map(element=>element.clave);
       
        caption.text(`Listas de Costos de: ${claves.join(', ')}`);

        let p_productos=$('<p></p>', {class:'text-center text-gray-400 m-0'}).css('font-size', '0.8em');
        let textProd=`Mostrando: <span id='mostrandoLi'>${productosShow}</span> {Rony} productos`
        $usuarioTipoRony= $vitex_globales.es_usuario_tipoRony;

        let rep=$usuarioTipoRony? ` / ${totalProductos}`: '';
        textProd=textProd.replace('{Rony}', rep);

        p_productos.append(textProd);

        caption.append(p_productos);


        if($usuarioTipoRony && name){
          let p= 
            $('<p></p>', 
            {
              class:'text-center text-gray-400 m-0 bold',
              text: `Viendo listas como: ${name}`
            }).css('font-size', '0.8em');
          caption.append(p);
        }

        let exporter= $('.toolbar_exporter.tableLiPrecios')

        let widthCols= setWcolsListas(claves.length, listasLength);

        

        let toolbar= $(`<div title="Imprimir" style="font-size: 1em;" class="ui-icon ui-icon-print-b noprint pointer" onclick="exporter.print('#table_li_precios', 'Lista de precios ${claves}', true)"></div>
        <div title="PDF" style="font-size: 1em;" class="ui-icon ui-icon-file-pdf noprint pointer" onclick="ListasPast.funciones.pdf_table('#table_li_precios', 'Lista de precios ${claves}', 'Lista de precios ${claves}')"></div>
        <div title="Copiar texto al clipboard" style="font-size: 1em;" class="ui-icon ui-icon-copy pointer copyClipBloard noprint" data-clipboard-target="#table_li_precios"></div>
        <div title="Guardar como imagen" style="font-size: 1em;" class="ui-icon ui-icon-file-image noprint pointer" onclick="ListasPast.funciones.imageSave('#table_li_precios', '${claves}');"></div>
        <div title="Excel" style="font-size: 1em;padding-left: 5px;color: #2f73d7;" class="fa-solid fa-file-excel noprint pointer" onclick="toExcelLista('#table_li_precios', 'Lista de precios ${claves}', {colsW:['180', ${widthCols},'220'], rowsW:['80']})"></div>`);

        exporter.append(toolbar);

        exporter.removeClass('none');

        let copyClipBloard= 
        $('<div></div>', 
            {
                id: 'copyImageClick', 
                title: 'Copiar imagen al clipboard', 
                class: 'fa-regular fa-file-jpg pointer copyClipBloard noprint'
            }).css({
                'font-size': '1em',
                'padding-left': '5px',
                'color': '#2f73d7',
                'cursor': 'pointer'
            })

        if(typeof(ClipboardItem) !== 'undefined'){
            copyClipBloard.on('click',() =>copyImageListas());
            exporter.append(copyClipBloard);

        }
        const ocultarCero= 
        $('<div></div>', 
            {
              class:'pointer noprint fa-solid fa-eye-slash', 
              id:'ocultarCero'}
          ).css({color: '#2f73d7', 'font-size': '1em', 'padding-left': '5px'});
        ocultarCero.on('click', ocultarCerosListas);
        exporter.append(ocultarCero);

        table.append(caption);
     }

     function setWcolsListas(claves, listasLength) {
      let withInitial= 120;

      switch (claves) {
         case 1:
            withInitial= 100;
            break;
        case 2:
            withInitial= 140;
            break;
        case 3:
            withInitial= 180;
            break;
        case 4:
            withInitial= 190;
            break;
        default:
            withInitial= 200;
            break;
      }

      let wCols='';

      for (let i = 0; i < listasLength; i++) {
          wCols+= `[${withInitial}],`;
      }

      return wCols;
     }
     function canvas2ClipboardList(canvas) {
        try {
            queueMicrotask(() => {
            canvas.toBlob(async (blob) => {
                await navigator.clipboard.write([
                    new ClipboardItem({[blob.type]: blob})
                ]);

                $("#copyImageClick").notify("¡Imagen Copiada!", {
                    position: 'left',
                    globalPosition: 'bottom left',
                    style: 'copiado',
                    className: 'supercopiado',
                    autoHideDelay: 2000
                });
            });
            });
        } catch(e) {
            ia.alertError("Haga click en Guardar como imagen y copiela", "Sin permiso de copiar una imagen directamente");
        }
    }

    function copyImageListas() {
            
      html2canvas(document.querySelector('#table_li_precios')).then(function (canvas) {
          // $("BODY").append('canvas');
          canvas2ClipboardList(canvas);
      });
  
      footAlertList('Imagen copiada al clipboard', 'success');
    }

    function footAlertList(message, type, time=5000) {
      $div_dialogo= $('div.ui-dialog-buttonpane').css('position', 'relative');

      let div_alert= $('<div></div>', {class: `alert alert-${type}`, text: message});

      $div_dialogo.append(div_alert);

      setTimeout(() => {
          div_alert.remove();
      }, time);

    }
    function ocultarCerosListas(e) {
      let fieldsEmpty= $('#table_li_precios tbody tr');
      let totalListas= infoListaPrecios.totalLists;

      fieldsEmpty.each((index, element) => {
          let tr= $(element);
          let tdEmpty= tr.find('.set-empty');
        console.log(tdEmpty.length);
        console.log(totalListas);
          if(tdEmpty.length == totalListas){
              $(element).addClass('none noprint');
          }
      });

      //buscando cuantos tr estan visibles
      let trVisible= $('#table_li_precios tbody tr:not(.none)');
      let cantInicial= $('#mostrandoLi').text();
      infoListaPrecios.totalProductos= cantInicial;

      $('#mostrandoLi').text(trVisible.length);

      let icon= $(e.target);
      icon
        .removeClass('fa-eye-slash')
        .addClass('fa-eye')
        .off('click')
        .on('click', mostrarCerosListas);


    }

    function mostrarCerosListas(e) {
      let fieldsEmpty= $('#table_li_precios tbody tr');
      fieldsEmpty.each((index, element) => {
          $(element).removeClass('none noprint');
      });

      $('#mostrandoLi').text(infoListaPrecios.totalProductos);

      let icon= $(e.target);
      icon
        .removeClass('fa-eye')
        .addClass('fa-eye-slash')
        .off('click')
        .on('click', ocultarCerosListas);
    }
  
     function generanddHeadLitsa(listas) {
      let {table, info_lista, tiendasEnLista}= listas;
      
      let thead= $('<thead></thead>');
      let tr= $('<tr></tr>');
      let th= $('<th></th>', {class:'text-center px-2 py-1'});
      th.text('Producto');

      let th_unidad= $('<th></th>', {class:'text-center px-2 py-1'});
      th_unidad.text('Unidad');
      tr.append(th);

      info_lista.forEach(element => {
        let {fecha_inicio, fecha_fin, fecha_lista}= element;
        let tiendas= tiendasEnLista[fecha_lista];

        let totalListas= infoListaPrecios.totalLists;
        totalListas++

        infoListaPrecios.totalLists= totalListas;

        //listas de precios
        let listasArr=infoListaPrecios.ids;
        listasArr= [...listasArr, fecha_lista];

        infoListaPrecios.ids= listasArr;
        //conviertiendo array en string
        let tiendas_str= tiendas.join(', ');

        //formateando fecha de inicio con luxon
        fecha_inicio= luxon.DateTime.fromISO(fecha_inicio, { zone: 'America/Mexico_City' }).setZone('America/Mexico_City');
        fecha_inicio= fecha_inicio.toFormat('dd/MM/yyyy', { zone: 'America/Mexico_City' });

        
        
        
        th= $('<th></th>', {class:'text-center px-2 py-1'});
        let p= $('<p></p>', {class:'m-0'});
        let span = $('<span></span>', {class:'fs-075'});
        span.text(tiendas_str+' \n ');
        let span2 = $('<span></span>', {class:'text-gray-400 fs-065'});
        span2.text(` Vigencia: ${fecha_inicio}`);
        let br= $('<br>');

        p.append(span, br, span2);

        th.append(p);

        tr.append(th);
        
      });

      tr.append(th_unidad);

      thead.append(tr);

      table.append(thead);
      
     }

     function filtrandoListaPrecios(event) {
      let productos= $(event.target).val();

        if(!productos.length){
            let tables= $('#ListPrecioTienda tbody tr');
            tables.show();
            return;
        }

        let tables= $('#ListPrecioTienda tbody tr');
            tables.hide();
        productos.forEach(producto => {
            //buscando los tr que contengan el producto
            let tr= $(`tr[data-id="${producto}"]`);
            tr.show();
        });
     }

    function toExcelLista (id, fileName, conf={}){
      let table = document.querySelector(id);
      let sbFileName = fileName.replace('Lista de precios', '');
      let tabName= sbFileName.length > 30? sbFileName.substring(0, 30): sbFileName;
      tabName= tabName.trim().replaceAll(/[^a-zA-Z0-9]/g, '_');
      tabName= tabName.replaceAll('__', '_');
      tabName= tabName.replaceAll('/', '_');

       if(typeof tabName === 'undefined')    tabName = id;
      let type = 'xlsx';
      let wb = XLSX.utils.table_to_book(table, { sheet: tabName,display:true, raw:true, cellStyles:true,  cellText:true, cellHTML:true});

      const ws = wb.Sheets[tabName];
      var columnWidths = conf.colsW // Adjust values as needed
      var rowHeights = conf.rowsW // Adjust values as needed

      wb.Sheets[tabName]['!cols'] = columnWidths.map(wpx => ({ wpx }));
      wb.Sheets[tabName]['!rows'] = rowHeights.map(hpx => ({ hpx }));

  let recordRow= rowHeights.length;
    

    const range = XLSX.utils.decode_range(ws['!ref']);

    for(R = 0; R < recordRow; ++R)
      for (let C = 0; C <= range.e.c; ++C) {
        console.log(R);
        let address = XLSX.utils.encode_cell({c:C, r:R}); // <-- first row
        let cell = ws[address];

          if(!ws[address]) continue;

          //buscandpo \n en el texto
          let text= cell.v;

          if(text.includes('\n')){
            //reemplazando \n por <br>
            text= text.replaceAll('\n', ' \r\n ');

            //poniendo el texto en el objeto
            cell.v= text;
          }

          cell.s = {
            
            font: {bold: true, sz: 10},
            fill: {fgColor: {rgb: "9EDFFF"}},
            alignment: {
              wrapText: true,
              horizontal: 'center', 
              vertical: 'center'},
            border: {
                top: { style: "thin", color: { rgb: "000000" } }, // Borde superior
                bottom: { style: "thin", color: { rgb: "000000" } }, // Borde inferior
                left: { style: "thin", color: { rgb: "000000" } }, // Borde izquierdo
                right: { style: "thin", color: { rgb: "000000" } } // Borde derecho
              },
            // <-- wrap text
          };
        }
      
      for( let R = recordRow ; R <= range.e.r; ++R){
        for (let C = 0; C <= range.e.c; ++C) {
          
          let address = XLSX.utils.encode_cell({c:C, r:R}); // <-- first row

          let cell = ws[address];
          if(!ws[address]) continue;
          
          //buscando si el valor es un numero
          let text= cell.v;

          //parseando el texto a numero
          let number= parseFloat(text);

          let objStyle= {
            font: {sz: 10},
            border: {
                top: { style: "thin", color: { rgb: "000000" } }, // Borde superior
                bottom: { style: "thin", color: { rgb: "000000" } }, // Borde inferior
                left: { style: "thin", color: { rgb: "000000" } }, // Borde izquierdo
                right: { style: "thin", color: { rgb: "000000" } } // Borde derecho
              }
          }

          //si el texto es un numero
          if(!isNaN(number)){
            objStyle.numFmt= '#,##0.00';
            objStyle.alignment= {
              horizontal: 'right',
              vertical: 'center'
            };
          }else{
            objStyle.alignment= {
              horizontal: 'center',
              vertical: 'center'
            };
          }

          cell.s= objStyle;

        }
    }


        


     let archivo= XLSX.write(wb, { bookType: type, bookSST: true, type: 'base64' });

     //limpiando el nombre del archivo de caracteres especiales
      fileName= fileName.trim().replaceAll(/[^a-zA-Z0-9]/g, '_');
      //console.log(fileName);
      let a = document.createElement('a');
      $(a).attr('href', 'data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64,' + archivo);
      $(a).attr('download', fileName+'.xlsx');

      //console.log(a);

      //console.log('prueba');
      a.click();

  }


     