let arrayEstados = [];
let filtros_seleccionados=[];
let potencia=0;
let allFilters = [];
$(document).ready(function() {
    $('#gs_estado').one('click', abriendoModal);
   gridhandler.on('jqGridAfterLoadComplete', function(e, data) {
    obteniendoEstados();
    const tieneEventoClick = $("#miBoton").data("events")?.click?.length > 0;
    // if (!tieneEventoClick) 
    //     $('#gs_estado').one('click', abriendoModal);

   });
});

function abriendoModal() {

    $('.ui-dialog-titlebar-close:visible').trigger('click');
    $("#modal_state_filter").remove();
    
    $("BODY").append(
        `<div id='modal_state_filter' class='jqgridcolssorter_dialog'>
    
     <fieldset>
        <legend>Opciones del estado</legend>
        <div class="d-flex filter_status">
            <div>
                <input name="radio_input" type="radio" id="selecionado_radio" value="1" checked>
                <label for="selecionado_radio">Seleccionado</label>
            </div>
            <div>
                <input name="radio_input" type="radio" id="selecionado_No" value="0">
                <label for="selecionado_No">Sin selecionar</label>
            </div>
         </div>
    </fieldset>
         <div id="table_estados"></div>

    <fieldset>
        <legend>Opciones de busqueda</legend>
        <div class="d-flex filter_status">
            <div>
                <input name="radio_busqueda" type="radio" id="busqueda_and" value="1" checked>
                <label for="busqueda_and">AND</label>    
            </div>

            <div>
                <input name="radio_busqueda" type="radio" id="busqueda_or" value="0">
                <label for="busqueda_or">OR</label>
            </div>
        </div>
    </fieldset>
        </div>`);

    $('.filter_status').css({
        'display': 'flex',
        'justify-content': 'space-evenly',
    })

    $('#table_estados').css({
        'display': 'grid',
        'grid-template-columns': 'repeat(6, 1fr)',
        'width': '100%',
        "width": "60%",
        "margin": "15px auto",

    });

    $("#modal_state_filter").dialog({
        title: "Filtrar por estado",
        width: 800,
        height: 400,
        buttons: [
            {
                text: 'Filtrar',
                icon: 'ui-icon-search',
                id: "guardar_estado",
                click: function() {
                    setBusqueda();
                }
            },
            {
                text: 'Regresar',
                icon: ' ui-icon-arrowrefresh-1-e',
                click: function() {
                    const postData = gridhandler.jqGrid('getGridParam', 'postData');
                    postData._search = true;
                    postData.filters = '';
                    gridhandler.jqGrid('setGridParam', { search: true });
                    gridhandler.trigger('reloadGrid');
                    filtros_seleccionados=[];
                    potencia=0;
                    $(".seleccionado").css({
                        'background': "#fff",
                        'color': "#ababab",
                    }).removeClass('seleccionado');
                    
                }
            },
            {
                text: 'Cancelar',
                icon: 'ui-icon-cancel',
                click: function() {
                    $(this).dialog('close');
                    filtros_seleccionados=[];
                    potencia=0;
                }
            },
            
        ],
        
        close: function() {
            $("#asigna_usuariosDialog").remove();
            $('#gs_estado').on('click', abriendoModal);
            filtros_seleccionados=[];
            potencia=0;
        },

    })
    llenandoGridStatus();
    $('#selecionado_No').on('click', settandoANdOR)
    $('#selecionado_radio').on('click', settandoEnabled)
}

function settandoANdOR() {
    $('#busqueda_and').prop('checked', true).prop('disabled', true);
    $('#busqueda_or').prop('disabled', true);
}
function settandoEnabled(e) {
    $('#busqueda_and').prop('disabled', false);
    $('#busqueda_or').prop('disabled', false);
}

function llenandoGridStatus() {
    arrayEstados.forEach(estado => {
        const { clave, color, background, title, icon, potencia } = estado;
        allFilters.push(potencia);

        let icon_estado= icon ? $(`<i class="icono_parrafo elementStatus fa-duotone ${icon}" data-potencia="${potencia}" data-clave="${clave}" data-color="${color}" data-bg="${background}"></i>`) : $(`<p style="margin: 0" class="icono_parrafo elementStatus" data-potencia="${potencia}" data-clave="${clave}" data-color="${color}" data-bg="${background}">${clave}</p>`);
            icon_estado.css({
            'display': 'flex',
            'justify-content': 'center',
            'align-items': 'center',
            'width': '100%',
            'background': "#fff",
            'color': "#ababab",
            'margin': '0 auto',
            'padding': '20px 0',
            "border": "1px solid #ababab",
            "cursor": "pointer",

            "transition": "all 0.5s ease-in-out",
        }).appendTo('#table_estados').prop('title', title).append(icon_estado);
    });
    simulandoHover();
    $('.icono_parrafo').tooltip();
    $('.icono_parrafo').on('click', addBusqueda);
}
function simulandoHover() {
    var elemento = $('.elementStatus');
    elemento.on('mouseenter',function(e) {setColor(e, true)})
    elemento.on('mouseleave',function() {
        if($(this).hasClass('seleccionado')) return;
        $(this).css({
            'background': "#fff",
            'color': "#ababab",
        });
    });
}
function setColor(e, hover=false) {
    if($(e.target).hasClass('seleccionado') && !hover) {
        $(e.target).css({
            'background': "#fff",
            'color': "#ababab",
        });
        return;
    };
    let background=$(e.target).data('bg');
    let color=$(e.target).data('color');

     $(e.target).css({
         'background': background,
         'color': color,
     });
}
function addBusqueda(e) {
    let target=$(e.target);
    const div_element= $(e.target).data('potencia');
    setColor(e);
    if (target.hasClass('seleccionado')) {
        target.removeClass('seleccionado');
        potencia =potencia - parseInt($(e.target).data('potencia'));
        filtros_seleccionados= filtros_seleccionados.filter(filtro => filtro !== div_element);

    }else if (!filtros_seleccionados.includes(div_element)){ 
        $(e.target).addClass('seleccionado');
        potencia =potencia + parseInt($(e.target).data('potencia'));
        filtros_seleccionados.push(div_element);

    }
    if (filtros_seleccionados.length===1) {
        $('label[for="busqueda_and"]').text('Solo este');
        $('label[for="busqueda_or"]').text('Que contenga');
    }else{
        $('label[for="busqueda_and"]').text('AND');
        $('label[for="busqueda_or"]').text('OR');
    }

}

function setBusqueda() {
    let input_tipo_busqueda= $('input[name="radio_input"]:checked');
    let radio_busqueda= $('input[name="radio_busqueda"]:checked');
    if(!input_tipo_busqueda.length || !radio_busqueda.length) return;

    let tipo_busqueda= input_tipo_busqueda.val();

    data_busqueda= tipo_busqueda === '0' ? 'nc'  : potencia;

    let rules=[];
    let acumulador=0;

    if(radio_busqueda.val() === '0' && tipo_busqueda === '1'){
        rules=[];
        filtros_seleccionados.forEach( (filtro,index) => {
            rules.push({
                field: "estado",
                op: `${tipo_busqueda}`,
                data: `${filtro}`,
            });

            allFilters.forEach( (filter, index) => {
            if(parseInt(filter)===filtro) return;
                
                rules.push({
                    field: "estado",
                    op: `${tipo_busqueda}`,
                    data: `${parseInt(filter)+filtro}`,
                });
                acumulador = acumulador + parseInt(filter);

                rules.push({
                    field: "estado",
                    op: `${tipo_busqueda}`,
                    data: `${acumulador+filtro}`
                });


                allFilters.forEach( (filter2, index) => {
                    if(filter2===filter || parseInt(filter2)===filtro) return;
                    rules.push({
                        field: "estado",
                        op: `${tipo_busqueda}`,
                        data: `${parseInt(filter2)+parseInt(filter)+filtro}`,
                    });
                    
                });
            });
            
        });
    }
    if(input_tipo_busqueda.val() === '0' && radio_busqueda.val() === '1'){
        rules=[];
        tipo_busqueda='ne';
        filtros_seleccionados.forEach( (filtro,index) => {
            rules.push({
                field: "estado",
                op: `ne`,
                data: `${filtro}`,
            });

            allFilters.forEach( (filter_all, index) => {
                if(parseInt(filter_all)===filtro) return;
                let filtro_rule=filtro+parseInt(filter_all);
                rules.push({
                    field: "estado",
                    op: `ne`,
                    data: `${filtro_rule}`,
                });

                allFilters.forEach( (filter2, index) => {
                    if(filter2===filter_all || parseInt(filter2)===filtro) return;
                    let double_filter=parseInt(filter2)+parseInt(filter_all)+filtro;
                    rules.push({
                        field: "estado",
                        op: `ne`,
                        data: `${double_filter}`,
                    })
                });

            });

        });
    }
    let operador= radio_busqueda.val() === '1' ? 'AND' : 'OR';

    if (input_tipo_busqueda.val() === '1' && radio_busqueda.val() === '1') {
        rules= [
            {
                field: "estado",
                op: `eq`,
                data: `${potencia}`,
            }
        ]
    }
        

    let filters = {};

    if(input_tipo_busqueda.val() === '0' && radio_busqueda.val() === '1'){
        filters = {
            groupOp: `AND`,
            rules: rules,
        };}
    else{
        filters = {
            groupOp: `${operador}`,
            rules: rules,
        };
    }

    const postData = gridhandler.jqGrid('getGridParam', 'postData');
    postData._search = true;
    postData.filters = JSON.stringify(filters);
    gridhandler.jqGrid('setGridParam', { search: true });
    gridhandler.trigger('reloadGrid');

    filters={};
    
}

function obteniendoEstados() {
    let url = "/vitex/backoffice/ajax/get_estados.php";
    $.ajax({
        url: url,
        type: "POST",
        dataType: "json",
        cache: false,
        data: {accion:`get_estado`},
        success: function(data) {
            arrayEstados = data.estados;
        },
        error: function(error) {
            console.log(error);
        }
    });
}