/*
@TODO Tree2Table:  proteger nombre y value
@TODO Tree2Table:  array2tree llenar granTotal
@TODO Tree2Table:  markExpand onclick...
@TODO Tree2Table:  control global expand/collapse, group/regroup, export

@TODO Tree2Sunburst:  control global expand/collapse, group/regroup, export

@TODO class FormatCol que regrese un span con data-value="valor" class="colName mas requeridos" y formateado, duda si quiero un td para class=der?
@TODO class totalizador con por unit, moneda,... o lo ponene si desean en groupBy o dimensiones

*/

//toOthers(pivotViewerData, ["Producto"], "Rolls", {by: "topN", n:4}, ["Containers"])
/**
 * Regresa un array agrupado por groupBy y usando el valor toma las principales slices y las demás las pone en others
 *
 * @param data {array} [{dimensiones, valores}]
 * @param groupBy {string} [dimension1, dimension2]
 * @param valor {string} valor
 * @param slices {object} {by:'topN|topPercent|valueGE', n:number}
 * @param totals {array} nombres de campos a sumar
 * @param keepChildren {boolean}
 */
function toOthers(data, groupBy, valor, slices = {}, totals = [], keepChildren = false) {
    if(!totals.includes(valor))
        totals.push(valor);

    let granTotal;
    let n = 0;
    let totalAcc = 0.00;
    let accPercent = 0.00;
    let others_num=0;
    let toOthers = false;
    let ret = [];
    let others;

    let grouped = group(data, groupBy, valor, totals, keepChildren);

    let totalValue = granTotal[valor];
    for(let g of grouped) {
        switch (slices.by.toLowerCase()) {
            case 'topn': toOthers = n >= slices.n; break;
            case 'toppercent':
                toOthers = accPercent >= slices.n;
                let vv = g[valor];
                g.percent = totalValue === 0.00 ? 0.00 : vv/totalValue;
                totalAcc += vv;
                g.accPercent = accPercent += g.percent;
                break;
            case 'valuege': toOthers = g[valor] >= slices.n; break;
        }
        if(toOthers) {
            others._others.push(g)
            others._othersLabel.push(g[groupBy])
            others_num++;
            for(let s of totals) {
                let v = parseFloat(g[s] ?? 0);
                if(isNaN(v) || v === Infinity || v === -Infinity)
                    v = 0;
                others[s] += v;
            }
            others.name = "Others";
            others.value = others[valor];
        } else
            ret.push(g);
        n++;
    }
    if(others_num) {
        others.name = `${others_num} ${groupBy}s`
        ret.push(others);
    }
    granTotal.others_num = others_num;
    return ret;

    function group(data, groupBy, valor, totals, keepChildren) {
        let zeros = {};
        for(let s of totals)
            zeros[s] = 0.00;
        granTotal = {...zeros}
        others = {...zeros, _others:[], _othersLabel:[], name:'Others'}
        others[groupBy] = 'Others';

        let grouped = {}
        for(let d of data) {
            let llave =d[groupBy] ?? "N/A";
            if(!grouped.hasOwnProperty(llave)) {
                let ks = {};
                ks[groupBy] = llave;
                if (keepChildren)
                    grouped[llave] = {name:ks[groupBy],  ...ks, ...zeros, children: []};
                else
                    grouped[llave] = {...ks, ...zeros};
            }
            let g = grouped[llave];
            if(keepChildren)
                g.children.push(d);
            for(let s of totals) {
                let v = parseFloat(d[s] ?? 0);
                if(isNaN(v) || v === Infinity || v === -Infinity)
                    v = 0;
                g[s] += v;
                granTotal[s] += v;
            }
            g.value = g[valor];
        }
        let summarized = [];
        for(let g in grouped)
            if(grouped.hasOwnProperty(g)) {
                summarized.push(grouped[g])
            }
        summarized.sort(function(a, b){return b[valor] - a[valor]});
        return summarized;
    }
}

class FormatCol {
    #fmtInt = null;
    #fmt2 = null;
    #fmtN = {}
    #formats= {};

    constructor(formats = {
        Rolls: {dec:0}, Rollos: {dec:0},
        Quantity:{dec:2}, Qty:{dec:2},
        Containers:{dec:2}, Container:{dec:2},
        CIF: {dec:0}, "CIF TODAY": {dec:0},
    }) {
        this.#formats = formats;
        this.#fmtInt = new Intl.NumberFormat('en-US',{minimumFractionDigits:0,maximumFractionDigits:0});
        this.#fmt2 = new Intl.NumberFormat('en-US',{minimumFractionDigits:2,maximumFractionDigits:2});
    }

    /**
     *
     * @param key
     * @param value formateado, con su <span class='...'> y numero con decimales y comas o el string
     */
    format(key, value) {
        if(value === "" || value === null)
            return ""
        if(isNaN(value))
            return value;
        let v = parseFloat(value);
        if(isNaN(v))
            return value;
        try {
            let decs = this.#formats.hasOwnProperty(key) ?
                parseInt(this.#formats[key].dec ?? 2) : 2;
            switch (decs) {
                case 0:
                    return this.#fmtInt.format(v);
                case 2:
                    return this.#fmt2.format(v);
                default:
                    if(this.#fmtN.hasOwnProperty(decs))

                    this.#fmtN[decs] = new Intl.NumberFormat('en-US', {
                        minimumFractionDigits: decs,
                        maximumFractionDigits: decs
                    });
                    return this.#fmtN[decs].format(v);
            }
        } catch(er) {return value;}
    }
}

class Tree2table {
    #formatCol = null;
    #granTotal = {};
    infoExclude = {};
    totalsBy = {};
    constructor(formatCol) {
        this.#formatCol =  typeof formatCol === 'undefined' || formatCol === null ?
            this.#formatCol = new FormatCol() :
            this.#formatCol = formatCol;
    }

    array2Table(data, dimensions, totals = [], info = []) {
       return this.tree2Table(this.array2Tree(data, dimensions, totals, info), dimensions, totals, info);
    }

    array2Tree(data, dimensions, totals = [], info = []) {
        if(typeof dimensions === 'string')
            dimensions = [dimensions];
        if(typeof totals === 'string')
            totals = [totals];
        let zeros = {};
        for(let t of totals)
            zeros[t] = 0.00;
        this.#granTotal = {...zeros};
        let ret = {};
        for(let d of data) {
            let level = 0;
            let levelPointer = undefined;
            for(let g of dimensions) {
                level++;
                let gValue = d[g] ?? "N/A";
                if(typeof levelPointer === 'undefined') {
                    if(!ret.hasOwnProperty(gValue))  {
                        ret[gValue] = {...zeros, children:{}, _level:level};
                        levelPointer = ret[gValue]
                        levelPointer[g] = gValue;
                    } else
                        levelPointer = ret[gValue]
                } else if(!levelPointer.hasOwnProperty(gValue)) {
                    levelPointer[gValue] = {  ...zeros, children:{}, _level:level };
                    levelPointer = levelPointer[gValue];
                    levelPointer[g] = gValue;
                } else
                    levelPointer = levelPointer[gValue];
                for(let t of info)
                    levelPointer[t] = d[t] || "";

                for(let t of totals) {
                    let v = parseFloat(d[t]);
                    if(!isNaN(v) && v !== Infinity && v !== -Infinity) {
                        //@TODO el total tiene subTotal por campo
                        levelPointer[t] += v;
                        if(level === 1) {
                            //@TODO el total tiene subTotal por campo
                            this.#granTotal[t] += v;
                        }
                    }
                }
                levelPointer = levelPointer.children;
            }
        }
        return ret;
    }

    #tHeadTotals = [];
    #tHead = [];
    #tBody = [];
    tree2Table(data, drillCols, totals, info) {
        this.#tBody = [];
        for (let d in data)
            if (data.hasOwnProperty(d))
                this.#record2tr(data[d], drillCols, totals, info, 1);

        this.#tHeadTotals = ['<th>'];
        this.#tHead = [''];
        for(let t of info) {
            this.#tHead.push(this.#toLabel(t));
            this.#tHeadTotals.push("<th>");
        }
        for(let t of totals) {
            this.#tHead.push(this.#toLabel(t));
            let v = this.#granTotal[t] ?? 0
            this.#tHeadTotals.push(`<th class="der ${t}" data-value="${v}">` + this.#formatCol.format(t, v));
        }

        return `<thead>
                    <tr><th>${this.#tHead.join("<th>")}</tr>
                    <tr>${this.#tHeadTotals.join("")}</tr>
                </thead>
                <tbody>${this.#tBody.join("")}</tbody>
                </table>`;
    }

    static fechaSet(setDate, id) {
        let $el = $(`#${id}`);
        if(setDate instanceof Date) {
            $el.datepicker("setDate", setDate);
            return;
        }
        if(setDate.length === 10) {
            $el.datepicker("setDate", new Date(setDate));
            return;
        }
        $el.datepicker("setDate", setDate);
    }

    static tableDrillClick(el) {
        let expand = el.innerText === "▶";
        let $el = $(el);
        let level = parseInt($el.data("level"));
        let nextLevel = level + 1;
        let $tr = $el.parents("TR");
        let $siblings = $tr.nextAll("TR");
        for(let s of $siblings) {
            let $s = $(s);
            let sLevel = parseInt($s.data("level"));
            if(sLevel <= level)
                break;
            if(expand && sLevel === nextLevel)
                $s.show();
            else
                $s.hide();
        }
        el.innerHTML = expand ? "&bigtriangledown;" : "&#9654;";
    }

    get tHead() {return this.#tHead;}

    get tBody() {return this.#tBody;}

    get granTotal() {return this.#granTotal;}

    #record2tr(r, drillCols, totals, info, indent) {
        let hasChildren = Object.keys(r.children || {}).length > 0;

        let tr = [`<tr data-children="${hasChildren}" data-level="${indent}" class="${indent > 1 ? "drillCollapsed" : ""}" >`];
        let markExpand = hasChildren ? `<span class="drillClick noprint" onclick="Tree2table.tableDrillClick(this)" data-level="${indent}">▶</span>` : "";
        let dCol = '';
        for (let col of drillCols)
            if (r.hasOwnProperty(col)) {
                tr.push(`<td data-value="${r[col]}" data-leaf="${!hasChildren}" data-level="${indent}" 
                        
                        class="drillCol ${col}">${markExpand} ${r[col]}</td>`);
                dCol = col;
                break;
            }

        for (let col of info) {
            let v = r[col] || "";
            for(let excludeCol in this.infoExclude)
                if(this.infoExclude.hasOwnProperty(excludeCol))
                    if(dCol === excludeCol &&  this.infoExclude[excludeCol].includes(col))
                        v = '';
            //@TODO el total tiene subTotal por campo
            tr.push(isNaN(v) || v === "" ?
                `<td class="${col}" data-value="${v}">` + v:
                `<td class="der ${col}" data-value="${v}">` + this.#formatCol.format(col, v)
            );
        }
        for (let col of totals) {
            let v = r[col] || "";
            if (v === null)
                v = "";
            tr.push(isNaN(v) || v === "" ?
                `<td class="${col}" data-value="${v}">` + v:
                `<td class="der ${col}" data-value="${v}">` + this.#formatCol.format(col, v)
            );
        }
        this.#tBody.push(tr.join(""));
        if(hasChildren)
            for(let c in r.children)
                if(r.children.hasOwnProperty(c) && typeof r.children[c] === 'object')
                    this.#record2tr(r.children[c], drillCols, totals, info, indent+1);
    }

    #toLabel(s) {
        return s.replaceAll("_", " ").trim().toLowerCase().trim()
            .replace(/\b[a-z]/g, function(letter) {return letter.toUpperCase();})
    }

}

console.log("pareateador v1.0.2");





