
/**
 * Rutinas para ayudar con pivotTable y subTotal
 *
 * @type {{show: pivotUtil.show, describe: (function(*): string)}}
 */
let pivotUtil = {
    lastConfig: {},
    lastDescribe: "",
    tema: "",
    templates: {},

    describeArticulo: 'En',

    granTotal: function() {
        try {
            let en = $(".pvtAttrDropdown").last().val();
            $("#elGranTotalEn").html(en);
            let $h = $("#elGranTotalH");
            let $td = $("TD[data-value]"); // .pvtVal
            if (en.search("CIF CHINA") >= 0) {
                $h.css({color: '#139312'});
                $td.css({color: '#00F'});
            } else if (en.search("CIF") >= 0) {
                $h.css({color: 'darkmagenta'});
                $td.css({color: 'darkmagenta'});
            } else if (en.search("Neg") >= 0) {
                $h.css({color: '#F00'});
                $td.css({color: '#F00'});
            } else {
                $h.css({color: 'black'});
                $td.css({color: 'black'});
            }
            $(".pvtTotal").css({color: 'black'});
            let $pvtGrandTotal = $(".pvtGrandTotal");
            $("#elGranTotal").html($pvtGrandTotal.last().html().replaceAll('_', ' '));
            $pvtGrandTotal.css({color: 'black', "border-top":"7px black double"})
        } catch(e) {}
    },

    pivotToExcel(fileName) {
        try {
            let table = $(".pvtTable").first()[0];
            let type = 'xlsx';
            let dl = false;
            let wb = XLSX.utils.table_to_book(table, {sheet: "sheet1", display: true});
            return dl ?
                XLSX.write(wb, {bookType: type, bookSST: true, type: 'base64'}) :
                XLSX.writeFile(wb, (fileName + '.' + type));
        } catch(er) {
            ia.alertError("Para exportar a Excel ponga el viewer en Table o algún Heatmap", "Exportar a Excel neceisto números");
        }
    },

    cellDialog: function(totalsFor, event, cellValue, dimensions, aggregator) {
        if(typeof event === "undefined")
            return;
        let totals = pivotUtil.cellTotals(pivotViewerData, dimensions, totalsFor);
        let title = [];
        for(let dim in totals)
            if(totals.hasOwnProperty(dim))
                if(dim === '_data_points')
                    title.push(`<th>Number of Data Points<td style="text-align:right">${pivotUtil.numFormatter(totals[dim],0)}`);
                else
                    title.push(`<th>${dim}<td style="text-align:right">${pivotUtil.numFormatter(totals[dim],2)}`);

        let d = [];
        for(let dim in dimensions)
            if(dimensions.hasOwnProperty(dim))
                d.push(`${dim}: ${dimensions[dim]}`);
        let filtrado = pivotUtil.describe_filtrado(pivotUtil.lastConfig);
        let tFoot = filtrado.length ? `<tfoot><tr><td colspan="2">${filtrado}</tfoot>` : "";
        let exportToolbar = `<p class='noprint' style="padding:0; margin:0">            
            <button type="button" onclick="pivotUtil.cellDialogToExcel(this.parentElement)"><i title="Exportar a Excel" class="fa-duotone fa-file-excel fa-xs" style="color:darkgreen;"></i
            ></button>
            </p>`;
        let table = `<table id="pivotCellDetail" class="tablita"><caption>${exportToolbar}</caption><tbody><tr><th colspan="2">${d.join(", ")}</th></tr><tr>${title.join("<tr>")}</tbody>${tFoot}</table>`;
        $(`<div>${table}</div>`).dialog({
            title: d.join(", "),
            closeOnEscape: true,
            width:"auto",
            height:"auto",
            buttons: {
                Ok: function() {$(this).dialog("close");},
            },
            close: function() {$(this).remove();},
        });
        event.target.title = table;
        return totals;
    },

    cellDialogToExcel: function(element) {
        let table = element.parentElement.parentElement;
        let type = 'xlsx';
        let dl = false;
        let wb = XLSX.utils.table_to_book(table, { sheet: "sheet1",display:true });
        return dl ?
            XLSX.write(wb, { bookType: type, bookSST: true, type: 'base64' }):
            XLSX.writeFile(wb, ("cell_values" + '.' + type));
    },

    reportSetParaTodos: function(element) {
        if(pivotUtil.tema.length === 0)
            pivotUtil.tema = pivotUtil.urlFile();
        $.ajax({
            url: '../backoffice/ajax/user_json_data_acciones.php',
            method: 'POST',
            cache: false,
            processData: true,
            dataType: 'json',
            data: {accion:'setParaTodos', tema: pivotUtil.tema, id:$(element).data('id')},
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax status wrong: " + this.url, data);
                return;
            }
            if(data.es_para_todos === 'Si')
                $(element).addClass("hpButtonFlagPressed");
            else
                $(element).removeClass("hpButtonFlagPressed");
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    },

    reportSetAsDefault:function(element) {
        if(pivotUtil.tema.length === 0)
            pivotUtil.tema = pivotUtil.urlFile();
        $.ajax({
            url: '../backoffice/ajax/user_json_data_acciones.php',
            method: 'POST',
            cache: false,
            processData: true,
            dataType: 'json',
            data: {accion:'setAsDefault', tema: pivotUtil.tema, id:$(element).data('id')},
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax status wrong: " + this.url, data);
                return;
            }
            $(".hpButtonDefault").removeClass("hpButtonFlagPressed");
            if(data.es_default === 'Si')
                $(element).addClass("hpButtonFlagPressed");
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    },

    reportDelete:function(element) {
        if(pivotUtil.tema.length === 0)
            pivotUtil.tema = pivotUtil.urlFile();
        ia.confirmDelete(" Elimino el Reporte: " + element.parentElement.innerText, "Confirme Borrar")
            .done(function(){
                $.ajax({
                    url: '../backoffice/ajax/user_json_data_acciones.php',
                    method: 'POST',
                    cache: false,
                    processData: true,
                    dataType: 'json',
                    data: {accion:'borra', tema: pivotUtil.tema, id:$(element).data('id')},
                })
                .done(function(data) {
                    if(!data.status) {
                        ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                        console.log("ajax status wrong: " + this.url, data);
                        return;
                    }
                    element.parentElement.parentElement.remove();
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                    console.log('ajax failed: ' + this.url, arguments);
                });
            })
    },

    reportSave: function(nombre = '') {
        if(pivotUtil.tema.length === 0)
            pivotUtil.tema = pivotUtil.urlFile();
        $(`<div style='text-align: center;padding:1em'>
            <label><i class="fa-duotone fa-cloud-arrow-up"></i> Nombre del Reporte: <p>
                <input type='text' value='${nombre}' style="width:20em" maxlength="64"></p></label></div>`).dialog({
            modal:true,
            title: "Guardar este Reporte",
            width: "24em",
            buttons: [
                {
                    text: "Guardar",
                    icon: "ui-icon-disk",
                    default: true,
                    click: function() {
                        let me = $(this), $input = me.children().find("INPUT"),  name = $input.val().trim();
                        if(name.length === 0) {
                            $input.css({"border":"1px red solid"});
                            return;
                        }

                        if($("#puntoEquilibrio").length)
                            pivotUtil.lastConfig.puntoEquilibrio = dimensions.autoNumeric.puntoEquilibrio.get();
                        if($("#summary").length) {
                            pivotUtil.lastConfig.summary = $("#summary").val().trim();
                            pivotUtil.lastConfig.remarks = pivotUtil.getRemarks();
                        }
                        let params =  {accion:'guarda', tema: pivotUtil.tema, name, data:pivotUtil.lastConfig, descripcion:pivotUtil.lastDescribe}
                        $.ajax({
                            url: '../backoffice/ajax/user_json_data_acciones.php',
                            method: 'POST',
                            cache: false,
                            processData: true,
                            dataType: 'json',
                            data: params,
                        })
                        .done(function(data) {
                            if(!data.status) {
                                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                                console.log("ajax status wrong: " + this.url, data);
                                return;
                            }
                            let def = data.def;
                            let b = $(`#buttonReporte_${def.user_json_data_id}`);
                            if(b.length) {
                                b.remove();
                                $("#reportesTemplates").prepend(pivotUtil.reportButton(def));
                            } else
                                $("#reportesTemplates").prepend(pivotUtil.reportButton(def));
                            me.dialog( "close" );
                        })
                        .fail(function(jqXHR, textStatus, errorThrown) {
                            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                            console.log('ajax failed: ' + this.url, arguments);
                        });

                    },
                },
                {
                    id:"tacancel",
                    text: "Cancelar",
                    icon: "ui-icon-cancel",
                    click: function() {
                        $( this ).dialog( "close" );
                    },
                },
            ],
            closeOnEscape: true,
            close: function(){$(this).remove();},
        });
    },

    clearLastTemplate: function() {$("#templateName").data("templateid", "s1").html("System Default");},

    reportCacheTemplate(config) {
        //$(".pvtAxisContainer").off( "sortupdate", pivotUtil.clearLastTemplate ).on( "sortupdate", pivotUtil.clearLastTemplate );
        //$(".pvtFilter").off("change", pivotUtil.clearLastTemplate ).on( "change", pivotUtil.clearLastTemplate );
        let ret = {};
        let clone = {...config};
        for(let c of ['aggregatorName', 'cols', 'colOrder', 'inclusions',  'rendererName', 'rendererOptions', 'rowOrder', 'rows',  'vals'])
            if(clone.hasOwnProperty(c))
                ret[c] = clone[c];
        pivotUtil.lastConfig = ret;
        pivotUtil.resaltaFiltros();
    },

    reportButton: function(def) {
        if(pivotUtil.tema.length === 0)
            pivotUtil.tema = pivotUtil.urlFile();
        if( typeof def.data == 'string' )
            def.data = JSON.parse(def.data);
        this.templates[def.user_json_data_id] = def;

        let descripcion = def.descripcion.replaceAll("'", "&apos;");
        let name = def.name.replaceAll("<", "&lt;");
        let esDefaultClass = def.es_default === 'Si' ? 'hpDefault hpButtonFlagPressed' : '';
        let esParaTodosClass = def.es_para_todos === 'Si' ? 'hpButtonFlagPressed' : '';
        let eliminar = clickDefault = clickTodos = '';
        if($vitex_globales.tipo_rony || $vitex_globales.iac_usr_id == def.iac_usr_id)
            eliminar = `<button data-id="${def.user_json_data_id}" onclick="pivotUtil.reportDelete(this)"  class="hpButton hpButtonFlag"><i style="color:red;" title="Eliminar">X</i></button>`;
        if($vitex_globales.tipo_rony) {
            clickDefault = 'onclick="pivotUtil.reportSetAsDefault(this)"';
            clickTodos = 'onclick="pivotUtil.reportSetParaTodos(this)"';
        }

        if($vitex_globales.tipo_rony)
            return `<div style="white-space:nowrap" id="buttonReporte_${def.user_json_data_id}" class="${esDefaultClass}">
                        <button title='${descripcion}' onclick='pivotUtil.show(pivotViewerData, ${def.user_json_data_id}, this)' class="hpButton" data-id="${def.user_json_data_id}" data-name="${name}"> ${name}
                        </button><button title="Set as Default" data-id="${def.user_json_data_id}" ${clickDefault} class="hpButton hpButtonFlag hpButtonDefault ${esDefaultClass}"><i class="fa-duotone fa-star-of-life"></i>
                        </button><button title="Para Todos" data-id="${def.user_json_data_id}" ${clickTodos} class="hpButton hpButtonFlag ${esParaTodosClass}"><i class="fa-solid fa-users"></i>
                        </button><button title="Guardar" data-id="${def.user_json_data_id}" onclick="pivotUtil.reportSave('${name}')" class="hpButton hpButtonFlag"><i class="fa-solid fa-floppy-disk"></i>
                        </button>${eliminar}
                    </div>`;


        return `<div style="white-space:nowrap" id="buttonReporte_${def.user_json_data_id}">
                    <button onclick='pivotUtil.show(pivotViewerData, ${def.user_json_data_id}, this)' class="hpButton" title='${descripcion}' data-id="${def.user_json_data_id}" data-name="${name}"> ${name}!! </button>${eliminar}
                </div>`;
    },

    reportList: function() {
        $("#templateName").html("System Default");
        if(pivotUtil.tema.length === 0)
            pivotUtil.tema = pivotUtil.urlFile();
        $.ajax({
            url: '../backoffice/ajax/user_json_data_acciones.php',
            method: 'POST',
            cache: false,
            processData: true,
            dataType: 'json',
            data: {accion:'lista', tema: pivotUtil.tema},
        })
        .done(function(data) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax status wrong: " + this.url, data);
                return;
            }
            for(let d of data.lista) {
                $("#reportesTemplates").append(pivotUtil.reportButton(d));
                if(d.es_default === 'Si') {
                    $("#templateName").data("templateid", d.user_json_data_id).html("Template: <b style='color:#00F'>" + d.name + "</b>");
                    pivotUtil.show(pivotViewerData, typeof d.data === 'string' ? JSON.parse(d.data) : d.data);
                }
            }
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
    },

    resaltaFiltros: function() {
        let resaltar = {};
        $('.pvtFilter[type=checkbox]:not(:checked)').each(function(){
            let label = $(this).first().parents(".pvtFilterBox").first().children("H4").children("SPAN").first().text();
            resaltar[label] = label;
        });
        $(".pvtAttr").each(function(){
            let $this = $(this);
            let label = $this.first().html().split("<span")[0].trim();
            if(resaltar.hasOwnProperty(label))
                $this.addClass("filtrando");
            else
                $this.removeClass("filtrando");
        });
    },

    /**
     * usage onRefresh: function(config) { $("#pivotDescribe").html(pivotUtil.describe(config)); }
     */
    describe: function(config, articulo) {
        if(typeof articulo === 'undefined')
            articulo = pivotUtil.describeArticulo;
        let v = config.vals[0];
        if(typeof v === 'undefined' || v === '')
            v = "Ceros";
        return pivotUtil.lastDescribe = `${config.rendererName}:<br>${config.aggregatorName}: ${v} <span style='color:black'>${articulo}</span> 
            ${config.rows.join(", ")} <span style='color:black'>por</span> ${config.cols.join(", ")}${pivotUtil.describe_filtrado(config)}`;
    },

    describe_filtrado: function(config) {
        let filtrado = [];
        let filtros = config.inclusions;
        for (let k in filtros)
            if (filtros.hasOwnProperty(k))
                filtrado.push(k + ": <b>" + filtros[k].join(", ") + "</b>");
        return filtrado.length === 0 ? '' :
            "<div style='padding-top:0'>Se Muestra <ol style='margin:0 0.5em;padding:0.2em 0;list-style: decimal-leading-zero;font-size:0.9em'><li style='max-height: 3.4em;overflow-y:hidden;text-overflow: ellipsis;'>" +
            filtrado.join("<li style='padding-top:0.5em;margin-top:0.2em; max-height:3em;overflow:hidden;text-overflow: ellipsis;'>") + "</ol></div>";
    },

    setRemarks:function(remarks) {
        const editor = tinymce.get('remarks');
        editor.setContent(remarks);
    },

    getRemarks:function() {
        const editor = tinymce.get('remarks');
        return editor.getContent();
    },

    show: function(pivotViewerData, templateId, el) {

        let changeConfig = typeof templateId === 'object' ? templateId : (pivotUtil.templates[templateId] || {data:{}}).data;

        if(!changeConfig.hasOwnProperty('inclusions'))
            changeConfig.inclusions = {};
        if(!changeConfig.hasOwnProperty('exclusions'))
            changeConfig.exclusions = {};
        if(!changeConfig.hasOwnProperty('cols'))
            changeConfig.cols = [];
        if(!changeConfig.hasOwnProperty('rows'))
            changeConfig.rows = [];

        try {
            if(changeConfig.hasOwnProperty("puntoEquilibrio"))
                dimensions.autoNumeric.puntoEquilibrio.set(changeConfig.puntoEquilibrio);
            if($("#summary").length) {
                if(changeConfig.hasOwnProperty("summary")) {
                    $("#summary").val(changeConfig.summary);
                    $("#detailsSummary").text(changeConfig.summary);
                } else {
                    $("#summary").val("Remarks, empty");
                    $("#detailsSummary").text("Remarks, empty");
                    const editor = tinymce.get('remarks');
                    editor.setContent("");
                }
                if(changeConfig.hasOwnProperty("remarks"))
                    pivotUtil.setRemarks(changeConfig.remarks);
            }
        } catch(er) {
            console.log("error", er)
        }

        if(typeof el === "object" ) {
            $("#templateName").data("templateid", templateId).html("Template: <b style='color:#00F'>" + $(el).data("name") + "</b>");
        }

        let id = 'pivotViewer';
        let p = $("#" +id);
        let config = p.data('pivotUIOptions');
        if(typeof config !== 'object' || config === null)
            config = {};
        if($("#pivotViewerContainer").length) {
            $("#pivotViewer").remove();
            $("#pivotViewerContainer").append($("<div></div>", {id:"pivotViewer"}));
            p = $("#" +id);
        }

        for(let k in changeConfig)
            if(changeConfig.hasOwnProperty(k))
                config[k] = changeConfig[k];

        if(typeof putPivot === 'function')
            putPivot(config);
        else
            p.pivotUI(pivotViewerData, config, true);
    },

    cellTotals: function(data, dimensions, vals) {
        let totals = {_data_points:0}
        for(let value of vals)
            totals[value] = 0.00;
        dataLoop: for(let d of data) {
            for(let dimension in dimensions) {
                if(dimensions.hasOwnProperty(dimension))
                    if((d[dimension] || "\t") !== dimensions[dimension])
                        continue dataLoop;
            }
            if(pivotUtil.filteredExcluded(d))
                continue;
            totals._data_points++;
            for(let value of vals) {
                let number = parseFloat(d[value] || 0.00);
                if(!isNaN(number))
                    totals[value] += number;
            }
        }
        return totals;
    },

    /**
     * Checks if a given object should be filtered and excluded based on
     * the last configuration
     *
     * @param {Object} obj - The object to be checked
     * @returns {boolean} True if the object should be excluded, false otherwise
     */
    filteredExcluded:function(d) {
        let exclude = false;
        let filtros = pivotUtil.lastConfig.inclusions;
        for(let k in filtros)
            if (filtros.hasOwnProperty(k)) {
                exclude = true;
                for(let value of filtros[k])
                    // noinspection EqualityComparisonWithCoercionJS
                    if((d[k] || null) == value)
                        return false;
            }
        return exclude;
    },

    /**
     * Formats a number with a specific number of decimal places and returns it as a string.
     * If the provided number is not a valid number, it will be returned as is.
     * If the number is empty or null, an empty string will be returned.
     * If the Number function is available, it will be used to format the number using the locale-specific conventions.
     * If the Intl.NumberFormat function is available, it will be used to format the number with the specified decimal places.
     * If none of the above methods are available, the number will be returned as is.
     *
     * @param {number|string} n - The number to format.
     * @param {number} [dec=2] - The number of decimal places to include. Defaults to 2.
     * @returns {string} The formatted number as a string.
     */
    numFormatter: function(n, dec = 2) {
        if(isNaN(n))
            return n;
        if(n === '' || n === null)
            return '';
        if(typeof Number === 'function')
            return parseFloat(n).toLocaleString('en-us', {minimumFractionDigits: dec, maximumFractionDigits:dec});

        if(typeof typeof Intl === 'object' && Intl.NumberFormat === 'function')
            return dec > 0 ?
                new Intl.NumberFormat('en-US',
                    {minimumFractionDigits:dec,maximumFractionDigits:dec}).format(n) :
                new Intl.NumberFormat('en-US',
                    {minimumFractionDigits:0,maximumFractionDigits:0}).format(Math.round(n));
        return n;
    },

    /**
     * Returns the name of the file from the URL.
     * If the URL contains a query string or a fragment identifier, they are removed before extracting the file name.
     *
     * @returns {string} The name of the file from the URL
     */
    urlFile: function() {
        let url = window.location.toString();
        if(url.search('\\?') >= 0)
            url = url.slice(0, url.indexOf('?'));
        if(url.search('\\#') >= 0)
            url = url.slice(0, url.indexOf('#'));
        return url.toString().split('/').reverse()[0];
    },

    padZero: function(value) {return value < 10  ? `0${value}` : `${value}`;},

    filtraMesDia: function(del, al) {
        if(del > al) {
            let tmp = al;
            al = del;
            del = tmp;
        }
        pivotUtil.lastConfig.inclusions["Dia-Mes"] = [];
        let ini = new Date(`2024-${del} 00:00:00`);
        let fin = new Date(`2024-${al} 00:00:00`);
        i=0;
        while(ini < fin) {
            pivotUtil.lastConfig.inclusions["Dia-Mes"].push(`${pivotUtil.padZero(ini.getMonth()+1)}/${pivotUtil.padZero(ini.getDate())}`);
            ini.setDate(ini.getDate() + 1);
            if(++i > 368)
                break;
        }
        pivotUtil.show(pivotViewerData, pivotUtil.lastConfig)

    },

    mesDiaDialog: function() {
        let mesOptions = [];
        for(let m = 1; m <=12; ++m)
            mesOptions.push(`<option>${pivotUtil.padZero(m)}</option>`);
        let diaOptions = [];
        for(let m = 1; m <=31; ++m)
            diaOptions.push(`<option>${pivotUtil.padZero(m)}</option>`);
        let html = `<div id="filtro"><input type="hidden" name="nada" value="no">
            <fieldset style="width:fit-content"><legend>Del</legend>
                <label style="color:#00F">Mes <select name="mesIni">${mesOptions.join("")}</select> </label> <label style="color:#00F">Día <select name="diaIni">${diaOptions.join("")}</select></label>
            </fieldset> 
            <fieldset style="width:fit-content"><legend>Al</legend>
                <label style="color:#00F">Mes <select name="mesFin">${mesOptions.join("")}</select> </label> <label  style="color:#00F">Día <select name="diaFin">${diaOptions.join("")}</select></label>
            </fieldset>              
            <div>  
                <i style="font-weight: 100;font-size: 0.9em;color:silver">* Tip ponga en las columnas: "Dia Mes", "Year" </i>
            </div> 
        </div>`;
        let promise = ia.form(html, "Selecciones el rango de días a mostrar");
        promise.done(function(v) {
            console.log("done", v)
           let ini = `${v.mesIni}/${v.diaIni}`;
           let fin = `${v.mesFin}/${v.diaFin}`;
           console.log(ini, fin)
           pivotUtil.filtraMesDia(ini, fin);
        });
    },
}

if(typeof vx_asyncFunction === 'undefined') {
    var vx_asyncFunction = function(callback, timeout, self) {
        var args = Array.prototype.slice.call(arguments, 3);
        return setTimeout(function() {
            callback.apply(self || window, args);
        }, timeout);
    };
}
if(typeof incializaHotKeysInputs === 'undefined') {function incializaHotKeysInputs() {}}

console.log("pivotUtil", '1.2.A');
