const plantillas = {
    version: '1.1.0',
    banco_cuenta_mov_id: '',
    plantillas: typeof jsonPlantillas != 'undefined' ? jsonPlantillas:[],
    getPlantillasHtml: (callbackOK) => {
        let request = {
            url: getUrlForAjax('banco_acciones.php'),
            data: {
                accion: 'actualizarPlantillas'
            }
        };

        jqAjax(request, function (response) {
            callbackOK(response);
        });
    },
    init_dialogo: () => {
        $("#dialogo_plantillas").dialog({
            width: 'auto',
            resizable: true,
            autoOpen: false,
            open: function(){
                $(this).tooltip({
                    content: function (callback) {
                        callback($(this).prop('title'));
                    }
                });
                // initThisColorPicker('.rp_color_resaltar', false);
            },
            close: function() {
                // console.log('close dialog', this);
            },
            title: "Remarks de Withdrawal Con Plantilla",
            buttons: {
                // Aceptar: function() {
                //     $(this).dialog( "close" );
                // },
                Cancelar: function() {
                    $(this).dialog( "close" );
                    $(this).tooltip('destroy');
                }
            }
        });

        // $('#form_plantilla_container').dialog({
        //     autoOpen: false,
        //     resizable: false,
        //     modal: true,
        //     title: "Llenar Remarks usando plantilla: " + jsonPlantillas[plantilla].nombre,
        // });
    },
    show_dialog_plantillas: (banco_cuenta_mov_id) => {
        plantillas.banco_cuenta_mov_id = banco_cuenta_mov_id;
        plantillas.getPlantillasHtml((response) => {
            // jsonPlantillas = plantillas.plantillas = response.plantillas_json;
            plantillas.plantillas = response.plantillas_json;
            $('#content_plantillas').html(response.plantillas);
            $("#dialogo_plantillas").dialog('open');
        });
    },
    show_dialog_from_template: (plantilla_id, para_editar = false, banco_cuenta_mov_id='', data_plantilla = {}) => {
        tinymce.remove();
        $("#dialogo_plantillas").dialog('close');
        // plantillas.banco_cuenta_mov_id = banco_cuenta_mov_id;
        let html_platilla = plantillas.get_html_form_template(plantilla_id, data_plantilla);
        if (empty(html_platilla))
            return ia.alertError("No hay campos en la platilla", "Aviso");

        html_platilla += "<input id='banco_cuenta_mov_id' value='"+plantillas.banco_cuenta_mov_id+"' type='hidden'>";
        let platilla = plantillas.plantillas[plantilla_id];

        if (para_editar) {
            if (empty(banco_cuenta_mov_id))
                return ia.alertError("Necesito el id del withdrawal para la edicion!", "Aviso");

            plantillas.banco_cuenta_mov_id = banco_cuenta_mov_id;
            let request = {
                url: getUrlForAjax('banco_acciones.php'),
                data: {
                    accion: 'leebcm',
                    id: plantillas.banco_cuenta_mov_id
                }
            }
            // let rowData = typeof gridhandler != 'undefined' ? gridhandler.getRowData(plantillas.banco_cuenta_mov_id):{};
            jqAjax(request, function (response) {
                if (response.Status === 'OK') {
                    var banco_cuenta_mov = response.bcm;
                    if (es_usuario_tipoRony || (banco_cuenta_mov.withdrawal_autorizado||'').strcasecmp('Si')!=0) {
                        html_platilla = `<div style="min-width: 700px;"><div style="float:left"><button class="btn bg-orange" type="button" id="btn_sin_plantilla" style="padding: 0 0.5em; width: auto; min-height: auto;">QUITAR PLANTILLA</button></div>`+plantillas.prepare_options_plantillas(plantilla_id, para_editar)+`</div>`+html_platilla;
                    }
                    continue_show_dialog();
                }
                else {
                    ia.alertError(response.Error||'Algo sucedio al leer el movimiento', 'Error', true);
                }
            });
        }
        else {
            continue_show_dialog();
        }

        function continue_show_dialog()
        {
            var dialogo = ia.form(html_platilla, 'Llenar Remarks usando plantilla: '+platilla.nombre, 'Pasar a Remarks', 'Cancelar', false, true, false);

            var $form_platilla = $('#frm_tmplt_'+plantilla_id);
    
            // if (!para_editar) {
            //     $('input, select, textarea', $form_platilla).val('');
            // }
    
            var dialogo_platilla = $form_platilla.parent();
            $('#btn_sin_plantilla').click(function () {
                let confirm = ia.confirm("<br><div style='width: 500px' class='txt_1_3em'>¿Confirmas quitar la Plantilla <b>"+platilla.nombre+"</b>?</div><br><br><br><p>Nota: Debera guardar los remarks despues de quitar la plantilla.</p>", 'Quitar Plantilla', true);
    
                confirm.done(function () {
                    $(dialogo_platilla).dialog("close");
                    modificarWithdrawal(banco_cuenta_mov_id, false, true); 
                });
                confirm.fail(function () {
                    $('#plantillas_disponibles').val(plantilla_id);
                });
            });
    
            $('#plantillas_disponibles').change(function () {
                if (this.value.strcasecmp('sin_plantilla') != 0) { // seleccionaron una plantilla nueva
                    $(dialogo_platilla).dialog("close");
                    plantillas.show_dialog_from_template(this.value, true, banco_cuenta_mov_id, data_plantilla);
                    return;
                }
                // la dejaron sin plantilla
                let confirm = ia.confirm("<br><div style='width: 500px' class='txt_1_3em'>¿Confirmas quitar la Plantilla <b>"+platilla.nombre+"</b>?</div><br><br><br><p>Nota: Debera guardar los remarks despues de quitar la plantilla.</p>", 'Quitar Plantilla', true);
    
                confirm.done(function () {
                    $(dialogo_platilla).dialog("close");
                    modificarWithdrawal(banco_cuenta_mov_id, false, true); 
                });
                confirm.fail(function () {
                    $('#plantillas_disponibles').val(plantilla_id);
                });
            });
    
    
            let first_input = $form_platilla.find('input, select, textarea').filter(':visible:first');
            if (first_input.length > 0) {
                if (first_input[0].tagName != 'SELECT')
                    first_input[0].setSelectionRange(first_input.val().length, first_input.val().length);
                first_input.focus();
            }
            
    
            incializaHotKeysInputs('frm_tmplt_'+plantilla_id, 'tmplt_loop_input_');
            incializaHotKeysSelects('frm_tmplt_'+plantilla_id);
            incializaHotKeysTextAreas('frm_tmplt_'+plantilla_id);
            init_autoNumeric('frm_tmplt_'+plantilla_id);
            init_datepicker('frm_tmplt_'+plantilla_id);
            elementos2UpperCase('frm_tmplt_'+plantilla_id);
            $form_platilla.find('.vx_numeric').onlyNumbers({es_decimal: true, decimales:2});
            vx_asyncFunction(function () {
                let first_input = $form_platilla.find('input, select, textarea').filter(':visible:first');
                if (first_input.length > 0) {
                    if (first_input[0].tagName != 'SELECT')
                        first_input[0].setSelectionRange(first_input.val().length, first_input.val().length);
                    first_input.focus();
                }
                $form_platilla.validationEngine({
                    scroll: false,
                    insideDialog: true,
                    promptPosition: 'topLeft',
                    validationEventTrigger: 'change',
                    focusInvalid: true,
                    addFailureCssClassToField: "input-required",
                    validateNonVisibleFields: false,
                    /* onValidationComplete: function (form, status) {
                        console.log(form);
                        console.log("The form status is: " +status+", it will never submit");
                        // alert("The form status is: " +status+", it will never submit");
                    }, */
                    // addPromptClass: "",
    
                });
            }, 300);
    
            $('input, select, textarea', $form_platilla).on('input', function () {
                vx_asyncFunction(function () {
                    $('#preview-remarks_'+plantilla_id).html(plantillas.get_remarks_from_template(plantilla_id));
                }, 10);
            });
            $('input, select, textarea', $form_platilla).blur(function () {
                vx_asyncFunction(function () {
                    $('#preview-remarks_'+plantilla_id).html(plantillas.get_remarks_from_template(plantilla_id));
                }, 10);
            });
            let config = {
                setup: function (editor) {
                    editor.on('change', function(e) {
                        editor.save();
                        $('#'+this.id).val(this.getContent());
                        vx_asyncFunction(function () {
                            $('#preview-remarks_'+plantilla_id).html(plantillas.get_remarks_from_template(plantilla_id));
                        }, 10);
                    });
                },
                content_style: "body { padding: 0 0.3em; margin: 0; }",
                toolbar: 'bold italic underline | fontselect fontsizeselect'
            };
            init_tinymce(config, '#frm_tmplt_'+plantilla_id+' textarea');
            $('.tox.tox-tinymce', $form_platilla).css({ width: '100%'});
    
            $form_platilla.parent().find('.tooltip').tooltip({content: function (callback) {callback($(this).prop('title'));}});
    
            dialogo.progress(async function (values, this_) {
                let form_ok = $('#frm_tmplt_'+plantilla_id).validationEngine('validate');
                if (form_ok) // Si pasa las validaciones del form (validate engine)
                {
                    // validamos la platilla de totales desde el javascript
                    let remarks_finales = plantillas.transfer_template_to_remarks(plantilla_id);
                    if (remarks_finales) {
                        // validamos las restricciones en el servidor
                        let rowData = gridhandler.getRowData(plantillas.banco_cuenta_mov_id);
                        let monto_withdrawal = vx_utils.parseFloat(rowData.withdrawal);
                        let input_total = $("input[data-total='Si']", $form_platilla);
                        if (input_total.length > 0)
                            monto_withdrawal = input_total.val()
    
                        let validate_rest = await plantillas.validate_restrictions(plantilla_id, monto_withdrawal);
                        if (!validate_rest)
                            return;
    
                        plantillas.send_remarks_from_template(plantilla_id, remarks_finales);
                    }
                }
            });
        }
    },

    get_html_form_template: (plantilla_id, data_plantilla) => {
        if(!plantilla_id)
            return '';

        var $tmplt = plantillas.plantillas[plantilla_id],
            $tabla = "<form id='frm_tmplt_" + plantilla_id +"' class='form-build' style='min-width: 700px;'><table class='form-build-table' style='width:100%;' id='tbl_tmplt_" + plantilla_id +"'>",
            req="", ve="", total=false, dataTotal="", maxlen="", $ph="", $sp="", $sel="", $val="",
            $op="", $on="", $dp=false, $dn=false, $dc=false, $prev={}, $next={}, $oculto="",
            // $mondef = $tmplt.monto_default === 'Si' && !encambiaTmplt,
            $monmax = vx_utils.parseFloat($tmplt.monto_maximo),
            $res = $tmplt.tiene_restricciones === 'Si',
            $pT = plantilla_id,
            $cT= $pT != plantilla_id,
            $prevRemarks = '',
            /* $prevRemarks=$cT && $('#'+lb_comentario).val().length ? "<hr /><div><span class='txt_bold_red txt14px'>Datos Previos:</span><br /><span class='txt_bold_blue txt14px'>" + $("<div/>").html($('#'+lb_comentario).val()).text() + "</span></div>" : "", */
            // $monmax = 100000000000;
            $dan=$monmax > 0.00 ? 'data-autonumeric="{mNum:10,mDec:2,vMin:0.00,vMax:'+$monmax+'}" data-validation-engine="validate[min[0.00]]"' : '';

        let rowData = typeof gridhandler != 'undefined' ? gridhandler.getRowData(plantillas.banco_cuenta_mov_id):{};
        /* let rowData = gridhandler.getRowData(this.banco_cuenta_mov_id);
        $prevRemarks = rowData.remarks;
        if (!empty($prevRemarks))
            $prevRemarks = "<hr /><span class='txt_bold_red txt14px'>Datos Previos:</span><br />"+$prevRemarks; */

        // if($mondef)
        //     $("#quantity").val($monmax);

        //Tratamos de llenar los valores de la plantilla si hay datos en los remarks.
        if (empty($tmplt.campos))
            return '';
        var campos = JSON.parse($tmplt.campos);
        $.each(campos, function(k, campo){
            req=""; ve=""; total=false; dataTotal=""; maxlen=""; $ph=""; $sp=""; $sel=""; $val=""; $op=""; $on=""; $prev={}; $next={}; $dp=false; $dn=false; $dc=false;

            $prev=campos[k-1] || {};
            $next=campos[k+1] || {};

            let $next_next = campos[k+2] || {};

            // $val = campo.hasOwnProperty("val") ? campo.val : "";
            $val = campo.hasOwnProperty("value") ? campo.value : "";
            $val = data_plantilla[campo.name] || $val; // para set de valor si estoy en edicion

            if($prev.hasOwnProperty("ocultar") && $prev.ocultar == true)
                $dp=true;

            if($next.hasOwnProperty("ocultar") && $next.ocultar == true)
            {
                $dn =true;
                if ($next_next.hasOwnProperty("ocultar") && $next_next.ocultar == true)
                    $on='&nbsp;<a href="javascript:void(0);" onclick="plantillas.show_hide_line(this,true);"><image src="../img/add.png" alt="Mostrar otra línea" class="noborders" title="Agregar linea" /></a>';
            }

            if(campo.hasOwnProperty("ocultar") && campo.ocultar == true)
            {
                $dc=true;
                $op='&nbsp;<a href="javascript:void(0);" onclick="plantillas.show_hide_line(this,false);"><image src="../img/delete.png" alt="Ocultar esta línea" class="noborders" title="Eliminar linea" /></a>';
            }
            $oculto = '';
            /* if($dc && $dn)
                $oculto=" style='display:none;' "; */

            if($dc)
                $oculto=" style='display:none;' ";

            if(campo.hasOwnProperty("required") && campo.required == true)
            {
                req = "<span class='txt_color_red'> *</span>";
                ve = 'data-validation-engine="validate[required]"';
                if (campo.type === 'number')
                    ve = 'data-validation-engine="validate[required,min[0.01]]"';
            }
            if(campo.hasOwnProperty("maxlength"))
            {
                maxlen = "maxlength='" + campo.maxlength + "'";
            }
            if(campo.hasOwnProperty("placeholder") && campo.placeholder.length)
            {
                $ph = " placeholder='" + campo.placeholder + "'";
            }
            switch(campo.type)
            {
                case "header":
                    let restr = $res ? " <span class='titulo-gasto-rec'>(Máx. $ "+CommaFormatted($monmax)+")</span>": "";
                    let class_= $res ? 'titulo-gasto-rec':'titulo-gasto';
                    if ($monmax<=0)
                        restr = '';
                    $tabla += "<tr " + $oculto + "><td colspan='2' style='width: 100%;'><h3 class='text-center "+class_+"'>" + campo.label + restr+"</h3><hr/></td></tr>";
                    break;

                case "text":
                    if($val.length)
                        $oculto = '';
                    $tabla += "<tr " + $oculto + "><td class='lbl bold txt_right_aligned' style=' padding-right: 10px;'>" + campo.label + req +":</td><td style=''><input autocomplete='off' class='input input-md tmplt_loop_input_' style='width: 80%;' type='text' id='"+ campo.name +"' value='"+ $val +"' " + ve + " " + maxlen + " " + $ph + ">" + $on + $op + "</td></tr>";
                    break;

                case "number":
                    if(campo.hasOwnProperty("esTotal"))
                    {
                        $val = vx_utils.parseFloat($val);
                        dataTotal = "data-total='Si'";
                        total = true;

                        if (campo.hasOwnProperty("automaticTotal") && campo.automaticTotal === true)
                        {
                            dataTotal+= " data-automatic='Si' disabled readonly ";
                        }
                        if (rowData.withdrawal) {
                            $val = rowData.withdrawal || $val;
                            const tempDiv = document.createElement('div');
                            tempDiv.innerHTML = $val;
                            $val = normalizaQuantity(tempDiv.innerText || tempDiv.textContent);
                            dataTotal+= " disabled readonly ";
                        }
                        
                    }
                    else
                        $val = vx_utils.parseFloat($val);
                    if(campo.hasOwnProperty("esMoneda"))
                        $sp = "<span>&nbsp;$&nbsp;</span>";

                    if($val > 0) {
                        $oculto='';
                        $val = CommaFormatted($val)
                    }
                        

                    if (!campo.hasOwnProperty("esTotal") && campo.hasOwnProperty("addToTotal")) {
                        dataTotal+=" data-toTotal='Si' ";
                        dataTotal+= ` onchange="plantillas.functions.calculaTotal(this, '${plantilla_id}')" `;
                    }

                    $tabla += "<tr " + $oculto + "><td class='lbl bold txt_right_aligned' style='padding-right: 10px;'>" + campo.label + req + $sp + ":</td><td style=''><input autocomplete='off' type='text' id='"+ campo.name +"' value='" + $val + "' style='width: 80%;' class='vx_numeric input input-md tmplt_loop_input_' " + ve + " " + dataTotal + " " + $ph + " " + $dan + ">" + $on + $op + "</td></tr>";
                    break;

                case "date":
                    if($val.length)
                        $oculto = '';
                    $tabla += "<tr " + $oculto + "><td class='lbl bold txt_right_aligned' style='padding-right: 10px;'>" + campo.label + req +":</td><td style=''><input autocomplete='off' type='text' id='"+ campo.name +"' value='"+ $val +"' class='datepicker input input-md tmplt_loop_input_' size='12' " + ve + " " + maxlen + " " + $ph + ">" + $on + $op + "</td></tr>";
                    break;

                case "textarea":
                    if($val.length)
                        $oculto = '';
                    $tabla += "<tr " + $oculto + "><td colspan='2' ></td></tr><tr><td colspan='2' class='lbl bold' style='width: 100%;'>" + (!empty(campo.label)?(campo.label+req+": "):'' )+"<br /><textarea autocomplete='off' class='input tmplt_loop_input_' cols='58' rows='4' id='"+ campo.name +"' " + ve + " " + maxlen + " " + $ph + ">"+ $val +"</textarea>" + $on + $op + "</td></tr>";
                    break;

                case "select":
                    if($val.length)
                        $oculto = '';

                    $tabla += "<tr " + $oculto + "><td class='lbl bold txt_right_aligned' style='padding-right: 10px;'>" + campo.label + req +":</td><td style=''><select value='"+$val+"' autocomplete='off' class='input input-md tmplt_loop_input_' style='width: 80%;' id='"+ campo.name +"' " + ve + $ph + "><option value=''>Elige " + campo.label + "</option>";

                    let es_de_bancos = (campo.hasOwnProperty('selectFromBancos') && campo.selectFromBancos === true) || (campo.hasOwnProperty('selectBancos') && campo.selectBancos === true)
                    if (es_de_bancos)
                        $tabla+= getSelect($vitex_globales.g_cat_banco_cuenta, 'nombre', 'nombre', $val, '', '', true, [], '', false);
                    else {
                        $.each(campo.values, function(k,v){
                            $sel = v.value == $val ? 'selected="selected"' : "";
                            $tabla += "<option value='" + v.value + "' "+ $sel +">" + v.label + "</option>";
                        });
                    }
                    $tabla += "</select>" + $on + $op + "</td></tr>"

                    break;

                case "campoAutomatico":
                    if($val.length)
                        $oculto = '';
                    $tabla += "<tr " + $oculto + "><td class='lbl bold txt_right_aligned' style='padding-right: 10px;'>" + campo.label + req +":</td><td style=''><input autocomplete='off' class='input input-md tmplt_loop_input_' style='width: 80%;' type='text' id='"+ campo.name ;

                    if(!$val.length)
                        $.each(campo.values, function(i,v){
                            $val = v.selected ? v.result : $val;
                        });

                    $tabla += "' value='" + $val + "' " + ve + " " + maxlen + " " + $ph + ">" + $on + $op + "</td></tr>";

                    break;

            }
            req=""; ve=""; total="0.00"; dataTotal=""; maxlen=""; $ph=""; $sp="";
        });
        $tabla += "</table>" + $prevRemarks + "<hr /><div class='form-build-preview-remarks' id='preview-remarks_"+plantilla_id+"'></div></form><div id='restriction_valitate_tmplt_"+plantilla_id+"' style='margin-top: 2em'></div>";
        encambiaTmplt = false;
        let restricciones = '';
        if ($res){
            restricciones = `<div class="txt_shadow_turquoise tooltip" style="position: absolute; z-index: 1;" title='${$tmplt.restricciones}'><i class='fa-icon fa-duotone fa-solid fa-circle-info txt_shadow_turquoise txt_1_6em'></i>INFO</div>`;
        }
        return restricciones+$tabla;
    },

    get_remarks_from_template: (plantilla_id, para_preview = true) => {
        if(!plantilla_id)
            return '';

        var $tmplt = plantillas.plantillas[plantilla_id],
            $nls = "<br>",
            $nln = " ",
            $label="",
            $val="",
            $sp="",
            $cval=0.00,
            $monmax=vx_utils.parseFloat($tmplt.monto_maximo);
        $res = $tmplt.tiene_restricciones === 'Si';

        if (empty($tmplt.campos))
            return '';

        let estado_default = $tmplt.link_vale || '';
        if (typeof gridhandler != 'undefined') {
            let rowData = gridhandler.getRowData(plantillas.banco_cuenta_mov_id);
            let estado_db = rowData.link_vale || '';
            if (empty(estado_default))
                estado_default = estado_db;

            if (estado_db.strcasecmp('NAVIERA') == 0)
                estado_default = estado_db;
        }
        let class_estado = !empty(estado_default) ? ('link_vale_'+estado_default):'';

        var text2Remarks = "<span class='txt_bold_red txt14px'>Datos Nuevos:</span> <span style='float:right'>Estado <b class='"+class_estado+"'>"+estado_default+"</b></span><br />";

        if (!para_preview)
            text2Remarks = "";

        var campos = JSON.parse($tmplt.campos);

        $.each(campos, function(k, campo){
            $sp = campo.hasOwnProperty("esMoneda") ? "$ " : "";
            $val = '';
            if(campo.type === "header")
            {
                /* if (!para_preview) {
                    text2Remarks += campo.label+"<br>";
                    return true;
                } */
                if($tmplt.tiene_restricciones === 'Si')
                    text2Remarks += "<p class='titulo-gasto'><span class='titulo-gasto-rec' id='" + plantilla_id + "_header'>"+campo.label + ($res?" (MÁX. $ "+CommaFormatted($monmax)+")":"") + "</span></p>";
                else
                    text2Remarks += "<p class='titulo-gasto'><span class='titulo-gasto' id='" + plantilla_id + "_header'>"+campo.label+"</span></p>";
                return true;
            }
            $label = '';

            if(campo.hasOwnProperty("labelAlter") || campo.usarLabel)
            {
                if(campo.hasOwnProperty("labelAlter") && campo.labelAlter.length)
                    $label = (campo.labelAlter||'').trim()+": ";
                else if(campo.usarLabel)
                    $label = (campo.label||'').trim() + ": ";
            }
            if(campo.type === "number")
            {
                $cval = vx_utils.parseFloat($("#"+campo.name).val());
                if ($cval > 0) {
                    $val = $sp + CommaFormatted($cval);
                }
                else
                    $val = "";
                // $val = $cval > 0 ? $sp + $("#"+campo.name).val() : "";
            }
            else
                $val = $("#"+campo.name).val().trim() || "";

            $label = $label.toUpperCase();
            $val = $val.toUpperCase();

            let completement = "";
            if (campo.hasOwnProperty('extracarac') && campo.extracarac.length>0)
                completement = " "+campo.extracarac;

            if (campo.label === 'LABEL_DESCRIPCION' && completement.length > 0)
                text2Remarks+= $label + completement + (campo.nuevaLinea ? $nls : $nln);

            // if($val.length === 0 && completement.length > 0)
            //     $val = " ";

            if($val.length && campo.type !== "header")
                text2Remarks += $label + "<span id='" + plantilla_id + "_" + campo.name + "'>" + $val + "</span>" + completement + (campo.nuevaLinea ? $nls : $nln);

            plantillas.plantillas[plantilla_id].campos[k].val = $val;
        });

        return text2Remarks;
    },

    transfer_template_to_remarks: (plantilla) => {
        if(!plantilla)
            return false;
        var $tmplt = plantillas.plantillas[plantilla], $suma=0.00,
            $total=0.00, $cval=0.00, $doTotal=false, $doSuma=false,
            $mondef = $tmplt.monto_default === 'Si',
            $monmax=vx_utils.parseFloat($tmplt.monto_maximo);
        $res = $tmplt.tiene_restricciones === 'Si';


        let rowData = gridhandler.getRowData(plantillas.banco_cuenta_mov_id);
        let monto_withdrawal = vx_utils.parseFloat(rowData.withdrawal);

        var campos = JSON.parse($tmplt.campos);

        var total_automatico = false;
        var suma_auto = 0;
        $.each(campos, function(k, campo){
            if(campo.type === "header")
                return true;

            if(campo.type === "number")
            {
                $cval = vx_utils.parseFloat($("#"+campo.name).val());

                if(campo.hasOwnProperty("esTotal") && campo["esTotal"])
                {
                    $total = $cval;
                    $doTotal = true;

                    if (campo.hasOwnProperty("automaticTotal") && campo.automaticTotal)
                        total_automatico = true;
                }
                else
                {
                    $suma += $cval;
                    $doSuma = true;
                    if (campo.hasOwnProperty("addToTotal") && campo.addToTotal)
                        suma_auto = suma_auto + $cval;
                }
            }
        });

        guardarAutoComplete("withdrawals_de_banco", campos);

        if (total_automatico)
            $suma = suma_auto;

        if (suma_auto == 0) $doTotal = false;

        if($doTotal && $doSuma && $total != $suma)
        {
            ia.alertWarn("El total no coincide con la suma de las cantidades.", "Plantilla "+$tmplt.nombre, true);
            return false;
        }

        // if ($res) {
            if ($doTotal) {
                if (monto_withdrawal != $total) {
                    ia.alertWarn("El total no coincide con el monto del gasto.", "Plantilla "+$tmplt.nombre, true);
                    return false;
                }
            }
        // }

        /* if($monmax && $total > $monmax)
        {
            ia.alertWarn("El total excede el monto máximo.", "Plantilla "+$tmplt.nombre, true);
            return false;
        } */

        return plantillas.get_remarks_from_template(plantilla, false);
        /* tinymce.get(lb_comentario).setContent(text2Remarks);
        tinymce.editors[lb_comentario].getBody().style.backgroundColor = '#D0D0D0';
        tinymce.editors[lb_comentario].getBody().setAttribute('contenteditable', false);
        tinymce.triggerSave();
        return true; */
    },

    send_remarks_from_template: (plantilla_id, remarks_finales = '', confirmacion = false) => {
        if (remarks_finales.length == 0)
            return ia.alertError("Los remarks estan vacios", "Remarks invalidos");

        var dialogo_platilla = $('#frm_tmplt_'+plantilla_id).parent();
        let input_total = $("input[data-total='Si']", $('#frm_tmplt_'+plantilla_id));
        let data = {
            accion: 'ModificarRemarksPlantilla',
            remarks: remarks_finales,
            banco_cuenta_mov_id: plantillas.banco_cuenta_mov_id,
            plantilla_id: plantilla_id,
            monto: input_total.val()
        };

        if (confirmacion) {
            let motivo = $('#motivo_para_usar', dialogo_platilla).val();
            if (empty(motivo))
                return ia.alertError("El motivo para usar la plantilla no debe estar vacio", "Alerta");

            data.confirmacion = true;
            data.motivo = motivo;
        }

        jqBlockUI(null, false, false, true);
        let request = {
            url: getUrlForAjax('banco_acciones.php?_app=withdrawals_de_banco'),
            data: data
        };
        jqAjax(request, function (response) {
            if (response.Status !== 'OK') {
                ia.alertWarn(response.Error, response.Status);
                return;
            }
            $.notify('Se actualizarón los remarks con plantilla', 'success');
            jqUnBlockUI();
            /* $('tr#'+this.banco_cuenta_mov_id+ ' td[aria-describedby="iajqgridgastosdebanco_mov_remarks"]').html(remarks_finales); */
            $(dialogo_platilla).dialog("close");
            // gridhandler.jqGrid('setRowData', plantillas.banco_cuenta_mov_id, response.bcmenDB);
            gridhandler.updateRow(plantillas.banco_cuenta_mov_id, response.bcmenDB);
            let selector = 'tr#'+plantillas.banco_cuenta_mov_id+' td[aria-describedby="iajqgridgastosdebanco_mov_plantilla_withdrawals_de_banco_id"] .grid_tooltip_';
            vx_asyncFunction(function () {
                inicializa_ui_tooltip(selector, 'ui_tooltip_grid_notas_verificacion_completa', { my: 'left+20 top-50', at: 'left top+20'}, 3000);
                inicializa_ui_tooltip('.tooltip_plantillas_info', '');
            }, 500);
        });
    },

    show_hide_line: (elem, mostrar) => {
        if(mostrar)
        {
            // $(elem).parent().parent().next().toggle().find('input').each(function(i){$(this).val('');});
            $(elem).parents('tr').nextAll(':lt(2)').toggle().find('input').val('');
            $(elem).parents('tr').next().find('a').remove();
        }
        else
        {
            $(elem).parents('tr').toggle().find('input').val('');
            $(elem).parents('tr').prev().toggle().find('input').val('');
        }
    },

    validate_restrictions: async (plantilla_id, monto = 0.00) => {

        let request = {
            url: getUrlForAjax('banco_acciones.php?_app=withdrawals_de_banco'),
            data: {
                accion: 'validaRestriccionesPlantilla',
                plantilla_id: plantilla_id,
                monto: monto,
                banco_cuenta_mov_id: plantillas.banco_cuenta_mov_id
            }
        };

        var form_platilla = $('#frm_tmplt_'+plantilla_id);
        var dialogo_platilla = $('#frm_tmplt_'+plantilla_id).parent();
        var div_valiation = $('#restriction_valitate_tmplt_'+plantilla_id);
        var div_dialogo_platilla = form_platilla.parents('div.ui-dialog');
        var buttons = $('.ui-dialog-buttonset .ui-button', div_dialogo_platilla);

        div_valiation.html("");
        div_valiation.hide();

        var dialog_title_original = dialogo_platilla.dialog('option', 'title');

        var ok = true;

        await $.ajax({
            url: request.url,
            method:'POST',
            data: request.data,
            dataType:'json',
        })
        .done(function(response, textStatus, jqXHR) {
            if (response.Status !== 'OK') {
                ok = false;
                form_platilla.hide();
                $('#plantillas_disponibles').parent().hide();
                div_valiation.html("LA PLANTILLA TIENE LAS SIGUIENTES RESTRICCIONES: <br><br><ul>"+response.validacion.message+"</ul><br><br><br><b style='text-transform: uppercase; margin-left: 2em'>¿Confirmas usar esta platilla?</b>");
                div_valiation.show();
                dialogo_platilla.dialog('option', 'title', 'Plantilla con Restricciones');
                $(buttons[0]).button('option', 'label', 'Si, confirmo');
                $(buttons[0]).off('click').click(function () {
                    dialogo_platilla.dialog('option', 'title', 'Motivo para usar platilla');
                    div_valiation.html("<b class='lbl'>INGRESA MOTIVO POR QUE QUIERE USAR LA PLATILLA:</b><br><textarea name='' id='motivo_para_usar' cols='30' rows='10' style='width: 100%'></textarea>");
                    $('#motivo_para_usar', div_valiation).focus();
                    $(buttons[0]).button('option', 'label', 'Confirmar y Pasar a Remarks');
                    $(buttons[0]).off('click').click(function () {
                        if (empty($('#motivo_para_usar', div_valiation).val()))
                        {
                            $('#motivo_para_usar', div_valiation).addClass('input-required');
                            return;
                        }
                        let remarks_finales = plantillas.transfer_template_to_remarks(plantilla_id);
                        if (remarks_finales)
                            plantillas.send_remarks_from_template(plantilla_id, remarks_finales, true);
                    });
                });
                $(buttons[1]).off('click').click(function () {
                    dialogo_platilla.dialog('option', 'title', dialog_title_original);
                    dialogo_platilla.dialog('close');
                });
            }
        })
        .fail(function(xhr, ajaxOptions, thrownError) {
            console.log("jqAjaxError thrownError=", thrownError);
            console.log("jqAjaxError xhr=", xhr);
            if (xhr.status == 401) {
                var dialogoError_401 = ia.alertError('Su sesión a caducado', "Error");
                dialogoError_401.done(function () {window.location.href = getUrlBase('backoffice');});
                dialogoError_401.fail(function () {window.location.href = getUrlBase('backoffice');});
                return;
            }

            let message = ((xhr.responseJSON) ? xhr.responseJSON.message : undefined) || xhr.responseText || thrownError;
            let title_error = "Error: " + (((xhr.responseJSON) ? xhr.responseJSON.code : undefined) || (xhr.status+" -> ("+thrownError+")") || '');
            if (xhr.responseJSON && xhr.responseJSON.title)
                title_error = xhr.responseJSON.title;

            if (xhr.status == 403) {
                var dialogoError_403 = ia.alertError(message, title_error, true);
                dialogoError_403.done(function () {window.location.href = getUrlBase('backoffice');});
                dialogoError_403.fail(function () {window.location.href = getUrlBase('backoffice');});
                return;
            }
            ia.alertError(message, title_error, true);
        });
        return ok;
    },

    autorizarProhibida: (banco_cuenta_mov_id) => {
        jqBlockUI(null, false, false, true);
        let request = {
            url: getUrlForAjax('banco_acciones.php?_app=withdrawals_de_banco'),
            data: {
                accion: 'autorizarPlatillaProhibida',
                banco_cuenta_mov_id: banco_cuenta_mov_id
            }
        };
        jqAjax(request, function (response) {
            if (response.Status !== 'OK') {
                ia.alertWarn(response.Error, response.Status);
                return;
            }
            $.notify(response.Error, 'success');
            jqUnBlockUI();
            // gridhandler.updateRow(banco_cuenta_mov_id, response.bcmenDB);
            ColoreaLineaJQGrid(banco_cuenta_mov_id, response.bcmenDB);
            // gridhandler.jqGrid('setRowData', banco_cuenta_mov_id, response.bcmenDB);
            /* let data = response.bcmenDB;
            gridhandler.updateRow(banco_cuenta_mov_id, data);
            gridhandler.setRowData(banco_cuenta_mov_id, {numero_original: data.numero_original, fecha: data.fecha}); */
            let selector = 'tr#'+banco_cuenta_mov_id+' td[aria-describedby="iajqgridgastosdebanco_mov_plantilla_withdrawals_de_banco_id"] .grid_tooltip_';
            inicializa_ui_tooltip(selector, 'ui_tooltip_grid_notas_verificacion_completa', { my: 'left+20 top-50', at: 'left top+20'}, 3000);
        });
    },

    rechazarProhibida: (banco_cuenta_mov_id) => {
        jqBlockUI(null, false, false, true);
        let request = {
            url: getUrlForAjax('banco_acciones.php?_app=withdrawals_de_banco'),
            data: {
                accion: 'rechazarPlatillaProhibida',
                banco_cuenta_mov_id: banco_cuenta_mov_id
            }
        };
        jqAjax(request, function (response) {
            if (response.Status !== 'OK') {
                ia.alertWarn(response.Error, response.Status);
                return;
            }
            $.notify(response.Error, 'success');
            jqUnBlockUI();
            // gridhandler.updateRow(banco_cuenta_mov_id, response.bcmenDB);
            ColoreaLineaJQGrid(banco_cuenta_mov_id, response.bcmenDB);
            // gridhandler.jqGrid('setRowData', banco_cuenta_mov_id, response.bcmenDB);
            /* gridhandler.updateRow(banco_cuenta_mov_id, data);
            gridhandler.setRowData(banco_cuenta_mov_id, {numero_original: data.numero_original, fecha: data.fecha}); */
            let selector = 'tr#'+banco_cuenta_mov_id+' td[aria-describedby="iajqgridgastosdebanco_mov_plantilla_withdrawals_de_banco_id"] .grid_tooltip_';
            inicializa_ui_tooltip(selector, 'ui_tooltip_grid_notas_verificacion_completa', { my: 'left+20 top-50', at: 'left top+20'}, 3000);
        });
    },

    formatter: (cellvalue, options, rowObject) => {
        if (empty(cellvalue))
            return cellvalue;

        let plantilla = plantillas.plantillas[cellvalue].nombre||'';
        let plantilla_prohibida = rowObject.plantilla_prohibida || rowObject[getColNum(gridhandler, 'plantilla_prohibida')]||'';
        let icon_prohibida = "";
        let actions_plantilla_prohibida = "";
        if (plantilla_prohibida.strcasecmp('Si') === 0) {
            let label_autorizada = '';

            if (es_usuario_tipoRony) {
                let actions = {
                    autorizar: `<div id="tmpl_a_${options.rowId}" class="defActions">
                        <a href="javascript:plantillas.autorizarProhibida('${options.rowId}');" title="Autorizar plantilla">
                            <i class="fa-icon fa-duotone fa-circle-check txt_shadow_green txt_1_5em grid_tooltip_"></i>
                        </a>
                    </div>`,
                    rechazar: `<div id="tmpl_r_${options.rowId}" class="defActions">
                        <a href="javascript:plantillas.rechazarProhibida('${options.rowId}');" title="Rechazar plantilla">
                            <i class="fa-icon fa-duotone fa-circle-xmark txt_shadow_red txt_1_5em grid_tooltip_"></i>
                        </a>
                    </div>`
                };
                let plantilla_autorizada = (rowObject.plantilla_prohibida_autorizada || rowObject[getColNum(gridhandler, 'plantilla_prohibida_autorizada')] || '');

                if (!empty(plantilla_autorizada)) {
                    if (plantilla_autorizada.strcasecmp('Si') === 0) {
                        delete actions.autorizar;
                        label_autorizada = ` <b class='text-success'>AUTORIZADA</b> `;
                    }
                    else {
                        delete actions.rechazar
                        label_autorizada = ` <b class='text-danger'>RECHAZADA</b> `;
                    }
                }
                actions_plantilla_prohibida = `<div class="flexRow" style="margin-top: 1em; justify-content: space-evenly; background: white; padding: 0.2em 0;">${Object.keys(actions).map(function (key, index) {
                    return actions[key]
                }).join('')}</div>`;
            }
            let plantilla_prohibida_porque = rowObject.plantilla_prohibida_porque || rowObject[getColNum(gridhandler, 'plantilla_prohibida_porque')]||'No paso la restricciones';
            let plantilla_prohibida_uso = rowObject.plantilla_prohibida_uso || rowObject[getColNum(gridhandler, 'plantilla_prohibida_uso')]||'';
            if (!empty(plantilla_prohibida_uso))
                plantilla_prohibida_uso = "<br><hr>MOTIVO: "+plantilla_prohibida_uso;
            icon_prohibida = `<i class="fa-solid fa-triangle-exclamation txt_1_9em grid_tooltip_" title="Plantilla prohibida ${label_autorizada+': '+plantilla_prohibida_porque+plantilla_prohibida_uso}"></i><br><br>`;
        }

        return `<span data-value="${plantilla}" value="${plantilla}" data-plantillaid="${cellvalue}">${icon_prohibida+plantilla+actions_plantilla_prohibida.fulltrim()}</span>`;
    },

    unformatter: (cellvalue, options, rowObject) => { return $(cellvalue).data("value"); },

    prepare_options_plantillas: (plantilla_id='') => {
        let options = "<option value='sin_plantilla'>Sin plantilla</option>";
        let selected = '';
        let disabled = '';
        $.each(plantillas.plantillas, function (plantilla_id_key, plantilla) {
            if (plantilla.activa.strcasecmp('si') != 0)
                return;
            
            selected = plantilla_id === plantilla_id_key ? 'selected':'';
            disabled = plantilla.pausado === 'Si' ? 'disabled': '';
            options+=`<option value='${plantilla_id_key}' ${selected+" "+disabled} style='color:#${plantilla.color}; background:#${plantilla.bkgcolor};'>${plantilla.nombre}</option>`;
        });
        return "<div class='text-right'>Plantillas disponibles: <select id='plantillas_disponibles' class='select-plantillas'>"+options+"</select></div>";
    },


    functions: {
        calculaTotal: function(_input, platilla_id) {
            let form_template = $('#frm_tmplt_'+platilla_id);
            let inputs_para_total = $("input[data-tototal='Si']", form_template);
            var total = 0;
            if (inputs_para_total.length > 0)
            {
                inputs_para_total.each(function () {
                    total = total + vx_utils.parseFloat(this.value);
                });
            }

            let input_total = $("input[data-total='Si']", form_template);
            if ((input_total.data('automatic')||'no') === 'Si')
                input_total.val(CommaFormatted(total.toFixed(2)));
        }
    },

};
console.log('Versión Plantillas: '+plantillas.version);