/**
 * Plugin para select de color
 */
(function ( $ ) {
    var _settings, _this, _nodename,
        _itemSelected = {value: '', label: ''},
        _idParent, _liSelected = null, $list,
        _heightDef = 38, _keysAttrData;
    $.fn.customSelectColor = function( config = {} ) {
        _this = this;
        _nodename = this.prop('nodeName');
        _idParent = _this.attr('id');
        if (_nodename === 'SELECT') {
            this.hide();
        }
        this.addClass('custom-select');

        initMe(config);

        // this.customSelectColor.setValue();
        this.isCustomSelectColor = true;

        return this;
    };
    /**
     * Functions Setter
     */
    /** setItems - Setea items para el select */
    $.fn.customSelectColor.setItems = function (data) {
        _settings.data = data;
    }
    /** setItems - Setea el valor para el select */
    $.fn.customSelectColor.setValue = function (val='') {
        if (val == 'first') {
            $('#custom_select_' + _idParent).find('ul li:nth-child(2)').click();
        } else if (val == 'last') {
            $('#custom_select_' + _idParent).find('ul li:last').click();
        } else {
            $('#custom_select_' + _idParent).find(`ul [data-value='${val}']`).click();
        }
        // agregaFuncionalidadClickSelect();
    }
    /** setItems - Setea el numero de elementos visibles para el select */
    $.fn.customSelectColor.setSize = function (size = 5) {
        $(_this).next().find('ul').css({'max-height': (size * _heightDef) + 'px', /*'height': (size * _heightDef) + 'px'*/});
    }
    /** End Functions Setter*/

    /**
     * Functions Getter
     */
    $.fn.customSelectColor.getItems = function () {
        return _settings.data;
    }
    $.fn.customSelectColor.getValue = function () {
        return _itemSelected.value;
    }
    $.fn.customSelectColor.getSelected = function () {
        return _itemSelected;
    }
    $.fn.customSelectColor.getIsCustomSelectColor = function () {
        if (_this && _this.isCustomSelectColor)
            return _this.isCustomSelectColor;

        return false;
    }
    /** End Functions Getter*/
    /**
     * Extra Functions
     */
    /** addItem - Agrega un elemento a la lista y al select */
    $.fn.customSelectColor.addItem = function (item) {
        if (item) {
            _settings.data.push(item);
            var data_extras = "";
            if (_keysAttrData.length > 0 ){
                _keysAttrData.forEach( key => {
                    data_extras += `data-${key}= "${item[key]}" `;
                })
            }
            _this.append(`<option value="${item[_settings.lb_value]}" ${data_extras}>${item[_settings.lb_label]}</option>`);

            data_extras = '';
            if (_settings.extra_data_attr.length > 0 ){
                _settings.extra_data_attr.forEach( key => {
                    data_extras += `data-${key}= "${item[key]}" `;
                })
            }
            $list.find('ul').append(`<li data-value="${item[_settings.lb_value]}" ${data_extras}>${item[_settings.lb_label]}<span style="width:1.3em; height:1.3em; background: ${item[_settings.lb_color]}; float: right; border: 1px solid black; border-radius: 50%;"></span></li>`);

            if (_settings.data.length > 1) {
                $list.find('ul li').css('height', '28px');
            }
        }
    }
    /** clear - Limpia el select */
    $.fn.customSelectColor.clear = function () {
        _this.customSelectColor.reload();

        _this.find('option').not(':first').remove();
        _settings.data = [];
        _settings.addNull = true;
        initMe(_settings);

        if (_settings.data.length <= 1) {
            $list.find('ul li').css({'height': '13px'});
        }
    }
    /** destroy - Destruye el widget */
    $.fn.customSelectColor.destroy = function () {
        if (_nodename === 'SELECT') {
            _this.next().remove();
        }
        _this.show();
        delete this.isCustomSelectColor;
        window.removeEventListener('keydown', downUpHandler, false);
        $('#custom_select').remove();
    }
    /** destroy - Recarga el widget con los _settings*/
    $.fn.customSelectColor.reload = function() {
        _itemSelected = {value: '', label: ''};
        _this.val('');
        $('#'+_idParent+' option').attr("selected", false);
        $('#custom_select_' + _idParent).find('ul li').removeClass('custom-select-selected');
    }

    function initMe(config)
    {
        _keysAttrData = Object.keys(_this.find('option').last().data());

        prepareConfig(config);
        prepareData();
        setStyles();
        setHtml();

        $list = $('#custom_select_' + _idParent);

        agregaFuncionalidadInOut();
        agregaFuncionalidadClickSelect();

        $(document).click(function(e) {
            if (_settings.collapsable === true) {
                $list.find('ul:visible').hide();
            } else {
                window.removeEventListener('keydown', downUpHandler, false);
            }
            // agregaFuncionalidadClickSelect();
        });
        if (_settings.collapsable === false) {
            window.addEventListener('keydown', downUpHandler, false);
        }
    }

    function prepareConfig(config) {
        _settings = $.extend({
            data: [],
            addNull: true,
            label: "Seleccione",
            lb_value: 'value',
            lb_label: 'label',
            lb_color: 'color',
            collapsable: false,
            size: 0,
            onSelect: null,
            extra_data_attr: [],
            color_selected: 'hsl(0, 0%, 85%)',
            color_hover: 'hsl(0, 0%, 85%)'
        }, config );
        if (_settings.size === 0 && _nodename === 'SELECT') {
            if (_nodename === 'SELECT') {
                if (_this.attr('size')) {
                    _settings.size = parseInt(_this.attr('size'));
                } else {
                    _settings.size = 5;
                }
            } else {
                _settings.size = 5;
            }
        }
        if (_settings.addNull) {
            _settings.size = _settings.size +1;
        }
    }

    function prepareData() {
        if (_settings.data.length === 0 &&  _nodename === 'SELECT') {
            var options = _this[0].options;
            var item = {};
            $.each(options, function () {
                if (this.value === '' || this.value == null) return;

                item = {};
                item[_settings.lb_value] = this.value;
                item[_settings.lb_label] = this.textContent;
                item = {...item, ...this.dataset};
                _settings.data.push(item);
            })
        }
    }

    function setStyles() {
        var id = "custom_select";

        if ($('#'+id).length > 0) {
            return;
        }
        var css = '',
            head = document.head || document.getElementsByTagName('head')[0],
            style = document.createElement('style');

        head.appendChild(style);

        css = `
                .custom-select {
                    position: relative;
                    display: inline-block;
                }

                .custom-select label {
                    display: inline-block;
                    min-width: 170px;
                    color: #000;
                    padding: 5px;
                    cursor: pointer;
                    border: 1px solid #000;
                    height: 13px
                }

                .custom-select ul {
                    margin: 0;
                    min-width: 170px;
                    position: ${_settings.collapsable === true ? 'absolute': 'relative'};
                    display: ${_settings.collapsable === true ? 'none': 'block'};
                    border: 1px solid #333;
                    max-height: ${_settings.size * _heightDef}px;
                    overflow: auto;
                    z-index: 10;
                    padding: 0;
                    background: white;
                }

                .custom-select ul li {
                    padding: 5px;
                    border-bottom: ${_settings.collapsable === true ? '1px solid #333': 'none'};
                    cursor: pointer;
                    height: ${_settings.data.length <= 1 ? '13': '28'}px;
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                }

                .custom-select ul li:hover {
                    background-color: ${_settings.color_hover};
                    color: #000;
                }

                .custom-select ul li:last-child {
                    border-bottom: none;
                }
                .custom-select-selected {
                    background-color: ${_settings.color_selected};
                }
                .custom-select-selected:hover {
                    background-color: ${_settings.color_selected} !important;
                    color: #000 !important;
                }
            `;

        style.type = 'text/css';
        style.id = id;
        if (style.styleSheet){
            // This is required for IE8 and below.
            style.styleSheet.cssText = css;
        } else {
            style.appendChild(document.createTextNode(css));
        }
    }

    function setHtml() {
        $(`#custom_select_${_idParent}`).remove();
        if (_nodename === 'SELECT') {
            _this.after(getHtml());
        } else {
            _this.html(getHtml());
        }
    }

    function getHtml(data) {
        // var li_s = (_settings.addNull) ? `<li data-value="">${_settings.label}</li>`: "";
        var li_s = `<li data-value="" ${!_settings.addNull ? 'style="display:none"': ''}>${_settings.label}</li>`;
        var data_extras = '';
        _settings.data.forEach(item => {
            data_extras = '';
            if (_settings.extra_data_attr.length > 0 ){
                _settings.extra_data_attr.forEach( key => {
                    if (item[key] == null || item[key] === '')
                        return;
                    data_extras += `data-${key}= "${item[key]}" `;
                })
            }

            if (_keysAttrData.length > 0 ){
                _keysAttrData.forEach( key => {
                    if (item[key] == null || item[key] === '')
                        return;
                    data_extras += `data-${key}= "${item[key]}" `;
                })
            }

            li_s += `<li data-value="${item[_settings.lb_value]}" ${data_extras}>${item[_settings.lb_label]}<span style="width:1.3em; height:1.3em; background: ${item[_settings.lb_color]}; float: right; border: 1px solid black; /*border-radius: 50%;*/"></span></li>`;
        });
        var label = _settings.collapsable === true ? `<label>${_settings.label}</label>`: '';
        return `<div class="custom-select" id="custom_select_${_idParent}">${label}<ul>${li_s}</ul></div>`
    }

    function agregaFuncionalidadInOut() {
        $list.focusin(function () {
            if (_liSelected == null) {
                _this.customSelectColor.setValue();
            }
            window.addEventListener('keydown', downUpHandler, false);
        });
        $list.focusout(function () {
            window.removeEventListener('keydown', downUpHandler, false);
        });
    }

    function agregaFuncionalidadClickSelect() {
        $list.on('click',function(e) {
            e.stopPropagation();
            window.addEventListener('keydown', downUpHandler, false);
            if (_settings.collapsable === true) {
                $list.not(this).find('ul:visible').hide();
                $list.find('ul').slideToggle('fast');
            }
            var parent = $(e.target).parent();
            var $tgt = $(e.target);
            if (parent.is('li')) {
                $tgt = parent;
            }
            if ($tgt.is('li')) {
                _liSelected = $tgt;
                _itemSelected = {value: $tgt.data('value'), label: $tgt.text()};
                if (_settings.collapsable === true) {
                    if (_itemSelected.value === '') {
                        $list.find('ul:visible').hide();
                    }
                    $(this).find('label').html(_itemSelected.label);
                }
                $(this).find('ul li').removeClass('custom-select-selected');
                $tgt.addClass('custom-select-selected');

                if (_nodename === 'SELECT') {
                    _this.val(_itemSelected.value)
                    $('#'+_idParent+' option').attr("selected", false)
                    $('#'+_idParent+' option[value="'+_itemSelected.value+'"]').attr("selected", "selected")
                }
                if (typeof _settings.onSelect === 'function') {
                    _settings.onSelect(_itemSelected, _itemSelected.value);
                }
            }
        });
    }

    function downUpHandler(e) {
        /*DOWN ARROW (40)
        UP ARROW (38)*/
        if (e.which === 40 || e.which === 38) {
            e.view.event.preventDefault();
            if(_liSelected){
                _liSelected.removeClass('custom-select-selected');
                var next_prev_Li;
                if (e.which === 40) {
                    next_prev_Li = _liSelected.next();
                } else {
                    next_prev_Li = _liSelected.prev();
                }
                if(next_prev_Li.length > 0) {
                    _liSelected = next_prev_Li
                } else {
                    if (e.which === 40) {
                        _liSelected = $list.find("ul li").first();
                    } else {
                        _liSelected = $list.find("ul li").last();
                    }
                }
                var $listHeight = $list.find("ul").height(),
                    offsetTop = 0;
                if (_liSelected[0].offsetTop === 0) {
                    offsetTop = _liSelected[0].offsetTop;
                } else if (_liSelected[0].offsetTop >= $listHeight) {
                    offsetTop = _liSelected[0].offsetTop - _heightDef;
                }
                $list.find("ul").scrollTop(offsetTop);
            }
            _liSelected.click();
        }
    }
}( jQuery ));