(function ( $ ) {
    var _settings, dataOk, dataNo, keyIndex, keyValue;
    var callBackOk, callBakNo;
    var _this;
    var locaOrg_data_permission_ok = null, locaOrg_data_permission_no = null;
    $.fn.doWidgetPermission = function( congif ) {
        _this = this;
        setStyles();
        var settings = $.extend({
            // These are the defaults.
            label_permission_ok: 'Con Permisos',
            label_permission_no: 'Sin Permisos',
            data_permission_ok: [],
            data_permission_no: [],
            keyIndex: 'id',
            keyValue: 'nombre',
            mode: 'button',
            callBackAddPermission: () => {
                console.log('Se dio Permisos');
            },
            callBackRemovePermission: () => {
                console.log('Se quito Permisos');
            },
        }, congif );
        _settings = settings;
       
        keyIndex = settings.keyIndex;
        keyValue = settings.keyValue;

        
        dataOk = settings.data_permission_ok;
        dataNo = settings.data_permission_no;

        locaOrg_data_permission_ok = JSON.stringify(dataOk);
        locaOrg_data_permission_no = JSON.stringify(dataNo);

        // console.log(locaOrg_data_permission_ok);
        // console.log(locaOrg_data_permission_no);


        this.html(getHtml());

        this.getIdPermission = getIdPermission;
        this.getIdNoPermission = getIdNoPermission;
        this.reload = reload;

        setClickPermission();

        return this;
    };

    function getIdPermission(type = 'array') {
        var ids = [];
        $(this).find('[data-col="permission"]').each((index, ele) => {
            typeof $(ele).data('index') != 'undefined'  ? ids.push($(ele).data('index')):'';
        })
        return type == 'array' ? ids: ids.join(',');
    }
    function getIdNoPermission(type = 'array') {
        var ids = [];
        $(_this).find('[data-col="no_permission"]').each((index, ele) => {
            typeof $(ele).data('index') != 'undefined'  ? ids.push($(ele).data('index')):'';
        })
        return type == 'array' ? ids: ids.join(',');
    }

    function getHtml() {
        var dataFor = null, isForOk = false, isForNo = false;

        if (dataOk.length > dataNo.length) {
            dataFor = dataOk;
            isForOk = true;
            isForNo = false;
        } else {
            dataFor = dataNo;
            isForOk = false;
            isForNo = true;
        }

        var tdOk = '', tdNo = '';
        var itemContrario = null;
        var tr_s = '';
        let indexId = '';
        dataFor.forEach((item, index) => {
            if (isForOk) {
                itemContrario = dataNo[index] ? dataNo[index]: null;
                indexId = itemContrario != null ? itemContrario[keyIndex] : null;
                tdOk = `<td widht="auto" class="border event-drag" data-key="${index}" data-col="permission" data-index="${item[keyIndex]}">
                            ${item[keyValue]}
                            <a href="javascript:void(0);" class="permission-action">
                                <img src="../img/delete.png" alt="Quitar Permiso a Usuario." title="Quitar Permiso a Usuario." width="14" height="14">
                            </a>
                        </td>
                        <td widht="auto" class="${itemContrario != null ? 'border' : ''}" data-key="${itemContrario != null? index: ''}" data-col="no_permission" ${indexId!=null?'data-index="'+indexId+'"': ''}>
                            ${itemContrario != null ?itemContrario[keyValue] : ''}
                            <a href="javascript:void(0);" class="nopermission-action" ${itemContrario == null ? 'style="display:none"': ''}>
                                <img src="../img/add.png" alt="Quitar Permiso a Usuario." title="Dar Permiso a Usuario." width="14" height="14">
                            </a>
                        </td>`;
            } else {
                itemContrario = dataOk[index] ? dataOk[index]: null;
                indexId = itemContrario != null ? itemContrario[keyIndex] : null;
                tdOk = `<td widht="auto" class="${itemContrario != null ? 'border' : ''}" data-key="${itemContrario != null? index: ''}" data-col="permission" ${indexId!=null?'data-index="'+indexId+'"': ''}>
                            ${itemContrario != null ?itemContrario[keyValue] : ''}
                            <a href="javascript:void(0);" class="permission-action" ${itemContrario == null ? 'style="display:none"': ''}>
                                <img src="../img/delete.png" alt="Quitar Permiso a Usuario." title="Quitar Permiso a Usuario." width="14" height="14">
                            </a>
                        </td>
                        <td widht="auto" class="border" data-key="${index}" data-col="no_permission" data-index="${item[keyIndex]}">
                            ${item[keyValue]}
                            <a href="javascript:void(0);" class="nopermission-action">
                                <img src="../img/add.png" alt="Quitar Permiso a Usuario." title="Dar Permiso a Usuario." width="14" height="14">
                            </a>
                        </td>`;
            }
            tr_s += `<tr>${tdOk + tdNo}</tr>`;
        })
        
        return `<table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th class="thPermission" widht="auto">${_settings.label_permission_ok}</th>
                            <th class="thPermission" widht="auto">${_settings.label_permission_no}</th>
                        </tr>
                    </thead>
                    <tbody>
                        ${tr_s}
                    </tbody>
                </table>`
    }

    function setClickPermission() {
        $('.permission-action').click(function () {
            let data = $(this).parents('td').data();
            
            let htmlAppend = removeItem(this, data);
            // console.log(htmlAppend);
            $(_this).html(htmlAppend);

            setClickPermission();


            _settings.callBackRemovePermission(data.index);
        });
        $('.nopermission-action').click(function () {
            let data = $(this).parents('td').data();

            let htmlAppend = removeItem(this, data, 'ok');
            // console.log(htmlAppend);|
            $(_this).html(htmlAppend);

            setClickPermission();

            _settings.callBackAddPermission(data.index);
        });
    }

    function removeItem(thisEl, data, to = 'no') {
        var push = {};
        if (to == 'no') {
            push = dataOk[data.key];
            dataNo.push(push);
            dataOk.splice(data.key, 1);
        } else {
            push = dataNo[data.key];
            dataOk.push(push);
            dataNo.splice(data.key, 1);
        }

        return getHtml();
    }

    function setStyles() {
        var css = '',
        head = document.head || document.getElementsByTagName('head')[0],
        style = document.createElement('style');
        
        head.appendChild(style);

        css = `
            .table {
                width: 100%;
            }
            .thead-light {
                background:#ddd;
            }
            table thead tr {
                border-bottom: 1px solid gray;
            }
            table thead th {
                padding: 0.5em 0.2em 0.5em 0.2em;
                border-left: 1px solid gray;
                border-right: 1px solid gray;
            }
            table.table tbody th, td {
                padding: 0.5em 0.5em 0.5em 0.5em;
            }
            .border-bottom {
                border-bottom: 1px solid gray;
            }
            .border-right {
                border-right: 1px solid gray;
            }
            .border-left {
                border-left: 1px solid gray;
            }
            .border {
                border: 1px solid gray;
            }
        `;

        style.type = 'text/css';
        if (style.styleSheet){
            // This is required for IE8 and below.
            style.styleSheet.cssText = css;
        } else {
            style.appendChild(document.createTextNode(css));
        }
    }

    function reload(response = true)
    {
        // console.log(response);
        // console.log(JSON.parse(locaOrg_data_permission_ok));
        // console.log(JSON.parse(locaOrg_data_permission_no));
        if (!response) {
            dataOk = JSON.parse(locaOrg_data_permission_ok);
            dataNo = JSON.parse(locaOrg_data_permission_no);
        }
        // console.log('reload', _this);
        // console.log(getHtml());
        
        _this.html(getHtml());

        this.getIdPermission = getIdPermission;
        this.getIdNoPermission = getIdNoPermission;
        this.reload = reload;

        setClickPermission();
    }

}( jQuery ));