/**
 *
 * Permite que un input de tipo file se converte en un widget para mejorar su presentación
 *
 * De preferencia para el id del selector
 * $('#selector_id').vx_file_attachments({
 *                 url: http://localhost/vitex/backoffice/ajax/producto_general_acciones.php,
 *                 axtraParam: {param_1: 'val_1'},
 *                 pk_id: 'pk_del_registro',
 *                 files: [],
 *                 filesAccept: 'jpg,png,gif',
 *                 onFailFiles: function (status, files) { // que quiero hacer cuando los archivos no son validos}
 *             });
 *
 * NOTA: Ver todos los options y su descripción
 *
 * Para acceder a las funciones el widget:
 *      $('#selector_id')[0].vx_file_attachment
 *      // Para Mandar el archivo al server (Upload file)
 *      $('#selector_id')[0].vx_file_attachment.add_files();
 *
 *      // Para set de nuevos arhivos
 *      $('#selector_id')[0].vx_file_attachment.set_files([]);  -> Ver en options => files, para el armado del array
 *
 *      // Para eliminar un archivo
 *      $('#selector_id')[0].vx_file_attachment.delete_file('nombre_archivo', 'id_arhivo');
 *
 *     // Para eliminar todos los archivos
 *     $('#selector_id')[0].vx_file_attachment.delete_all();
 *
 *
 *
 * public: method:function
 * privates: _method:function
 */

(function ( $ ) {
    var _this, options, _style;
    $.fn.vx_file_attachments = function (options_ = {}) {
        _this = this;
        if (typeof options_ !== 'object') {
            _defineAction(_this, options_);
        }
        else {
            options = $.extend({
                url: '', // Url donde se hara la petición HTTP
                accionAdd: 'adjuntarArchivos', // Acción o Funcion que resolvera la petición de agregar archivos
                accionDelete: 'borraAdjunto', // Acción o Funcion que resolvera la petición de eliminar el archivo
                accionDeleteAll: 'borraAdjuntos', // Acción o Funcion que resolvera la petición de eliminar todos los archivos
                pk_id: '', // primary key (id) del documento/registro padre al que se le quieren adjuntar archivos
                axtraParam: {}, // parametros extra que se quieren enviar en la petición object type {key: value}
                canDelete: true, // Puede eliminar archivos [true||false]
                canAdd: true, // Puede adjuntar archivos [true||false]
                pathApp: '../backoffice/',
                files: [], // archivos default Arrar type [{id: 'identificador unico', nombre: 'file name', 'path4File': 'dir where the file is hosted'}];
                filesAccept: '', // Para indicar extensiones validas. String separado por comas 'jpg,png,gif,jpeg,pdf,...' o un array con las extensiones ['jpg','png','gif','jpeg','pdf',...]. Para indicar que todas las extensiones son validas -> '*'. Si esta vacio trata de calcular con el attr accept del input
                addButtonDeteleAll: true, // Para saber si coloca el icono para borrar todos los archivos [true|false]
                previewImage: true, // Para ver un preview de la Imagen, si es false muestra icono de imagen
                orderBy: '', // key para saber si se debe ordenar y por que campo el array de archivos
                pathDir: '', // Ruta del directorio donde esta alojado el archivo. Hace override al key 'path4File' dentro del array de files
                onFailFiles: null, //  Función callback para procesar mensajes al validar los archivos. Params(status, files, ext_ok) --> status => true|false, files => object type {ok: [array de archivos validos], fail: [array de archivos invalidos]} de los archivos seleccionados, ext_ok => array de las extensiones (archivos) validas
                addListFiles: true, // para mostrar la lista de archivos
                beforeUpload: function (_input, files) {},
                afterUpload: function (files, _input) {},
                afterRenderFiles: function (files) {},
                afterInit: function (input) {},
                afterDelete: function (files, _input) {},
                afterDeleteAll: function (files, _input) {},
            }, options_);

            if ((options.url||'') === '') {
                console.error("vx_file_attachments: param url is empty or not found in options")
                return;
            }
            if ((options.accionAdd||'') === '') {
                console.error("vx_file_attachments: param accionAdd is empty or not found in options")
                return;
            }
            if ((options.accionDelete||'') === '') {
                console.error("vx_file_attachments: param accionDelete is empty or not found in options")
                return;
            }

            _setStyles();

            _this.each(function () {
                let mini_me = this;
                schedulerPostTaskV2(
                    { task: () => {
                            _setHtml(mini_me);
                            new SetThisProps(mini_me, options);
                            _setAcceptFiles(mini_me);
                            if (options.canAdd)
                                _setEvents(mini_me);
                        }, priority: 'background' },
                    { task: () => {
                            mini_me.vx_file_attachment.set_files(options.files);
                            options.afterInit(mini_me);
                        }, priority: 'background' },
                );

            });

            function SetThisProps(_this_, options_) {
                _this_.vx_file_attachment = {
                    is_show:false,
                    url: options_.url||'',
                    accionAdd: options_.accionAdd||'',
                    accionDelete: options_.accionDelete||'',
                    accionDeleteAll: options_.accionDeleteAll||'',
                    filesAccept: [], // se calculan en _setAcceptFiles()
                    addListFiles: options_.addListFiles||false,
                    files: [],
                    meExtraParams: {},
                    widget: $(_this_).next(),
                    add_files: function (e = null) {
                        if(!options.canAdd) {
                            _this_.value = '';
                            return ia.alertError("No puedes adjuntar archivos", "Sin Permiso");
                        }

                        const me = e==null?_this_.vx_file_attachment:this.vx_file_attachment;
                        if (!window.FormData && e == null)
                            return;

                        let formdata = new FormData(),
                            files = _this_.files.length ? _this_.files : [],
                            cuantos_archivos_validos = 0;

                        if (files.length === 0)
                        {
                            _this_.value = '';
                            ia.alert("No hay archivos para cargar");
                            return;
                        }

                        let files_validation = {
                            ok: [],
                            fail: [],
                        };

                        $.each(files, function(i, file){
                            let extension = file.name.split('.').pop().toLowerCase();
                            if (me.filesAccept === '*') {
                                cuantos_archivos_validos++;
                                formdata.append(i, file);
                            }
                            else {
                                if (me.filesAccept.includes(extension))
                                {
                                    cuantos_archivos_validos++;
                                    formdata.append(i, file);
                                    files_validation.ok.push(file.name);
                                }
                                else {
                                    files_validation.fail.push(file.name);
                                }
                            }
                        });
                        if (me.filesAccept !== '*')
                        {
                            if(cuantos_archivos_validos === 0) {
                                _this_.value = '';
                                if (typeof options.onFailFiles === 'function') {
                                    options.onFailFiles(false, files_validation, me.filesAccept);
                                    return;
                                } else {
                                    ia.alert("Algunos archivos no son permitidos.<br>Archivos validos: <b>"+me.filesAccept.join(", ")+"</b>", null, true);
                                }
                                return;
                            }
                        }

                        options_.beforeUpload(_this_, files);

                        formdata.append('accion', me.accionAdd);
                        var extra_params = options_.axtraParam;
                        for (let clave in extra_params)
                            formdata.append(clave, extra_params[clave]);


                        for (let clave in me.meExtraParams)
                            formdata.append(clave,  me.meExtraParams[clave]);

                        $.ajax({
                            url: me.url,
                            cache: false,
                            type: "post",
                            async: true,
                            processData: false,
                            contentType: false,
                            dataType: 'json',
                            data: formdata,

                            beforeSend: function(jqXHR, settings)
                            {
                                $.blockUI();
                            }
                        })
                            .done(function(response, textStatus, jqXHR){
                                try {
                                    me.set_files(response.files);
                                    options_.afterUpload(response.files, _this_);
                                }catch(err){
                                    console.log("vx_file_attachments: add_files() +++++++++++++++");
                                    console.log(err);
                                    alert(err.message);
                                }
                            })
                            .fail(function (xhr, ajaxOptions, thrownError){
                                try {

                                    let message = ((xhr.responseJSON) ? xhr.responseJSON.message : undefined) || xhr.responseText || thrownError;
                                    let title_error = "Error: " + (((xhr.responseJSON) ? xhr.responseJSON.code : undefined) || (xhr.status+" -> ("+thrownError+")") || '');
                                    if (ia.alertError)
                                        ia.alertError(message, title_error, true);
                                    else
                                        alert(message);
                                }catch(err){
                                    console.log("vx_file_attachments: second catch add_files() +++++++++++++++");
                                    console.log(err);
                                    alert(err.message);
                                }
                            })
                            .always(function(res){
                                _this_.value = '';
                                $.unblockUI();
                            });
                    },

                    set_files: function (files) {
                        this.files = files;
                        if (!this.addListFiles)
                            return;

                        let div_file_list = $("#div_file_list_"+_this_.name);
                        div_file_list.html('');
                        div_file_list.removeClass('with-files');
                        $('#div_content_file_attachments_'+_this_.name).find('.list-files-title').remove();
                        $('#div_content_file_attachments_'+_this_.name).find('.btn-delete-all-files').remove();
                        // if (files.length>0) {
                            let lis_files = [];
                            if (options.orderBy.length > 0 && files.length>0) {
                                let key_order = options.orderBy;
                                const [firstItem, ...rest] = files;
                                if (firstItem[key_order])
                                    files.sort(function (a, b) { return b[key_order] - a[key_order] });
                            }
                            $.each(files, function (i, file) {
                                let file_name = file.nombre,
                                    path = file.path4File || '';

                                if ((options.pathDir||'').length > 0)
                                    path = options.pathDir;

                                let href_download = options_.pathApp + 'descargaarchivo.php?NA=' +file_name+'&P2F='+path
                                let icon_ver;
                                if (_fileIsImage(file_name) && options.previewImage)
                                    icon_ver = `<div class="hoverImageWrapper"><img loading="lazy" src="${path+file_name}" style="width: 64px; height: 38px" class="grid_tooltip_ hoverImage"></div>`;
                                else
                                    icon_ver = _getIconToFile(file.nombre);

                                let icon_delete = `<a title="Eliminar Archivo" class="file-item-remove" style="top: 10px; position: relative">
                                                <i class="fa-icon fa-duotone fa-trash-can txt_shadow_red grid_tooltip_ txt_1_3em" ></i>
                                            </a>`;

                                if (!options.canDelete)
                                    icon_delete = "<b>"+(i+1)+'.- </b>';

                                lis_files.push(`<li id="file-item-${file.id||''}" style="margin-bottom:0.8em" class="file-item" data-file-name="${file_name}" data-file-id="${file.id||''}">
                                            ${icon_delete}
                                            <a href="${href_download}" title="Descargar Archivo" class="link-download-file"><b class="grid_tooltip_">${file_name} <i class="fa-icon fa fa-download"></i></b></a>
                                            <a target="_blank" href="${path+file_name}" title="Ver archivo" style="margin-left:1em; float: right">
                                                ${icon_ver}
                                            </a>
                                        </li>`);
                            });

                            let button_delete_all = '';
                            if (lis_files.length > 0) {
                                div_file_list.addClass('with-files');
                                div_file_list.html('<ul class="list_files">'+lis_files.join(""));
                                inicializa_ui_tooltip('.grid_tooltip_', 'ui_tooltip_grid_notas_verificacion_completa', { my: 'left+20 top-30', at: 'left top+20' }, 3000);

                                button_delete_all = `<button type="button" title="Eliminar todos los archivos" class="btn-delete-all-files">
                                                    <i class="fa-icon fa-duotone fa-trash-can txt_shadow_red grid_tooltip_ txt_1_3em"></i>
                                                </button>`;
                            }


                            if (!options.canDelete || !options.addButtonDeteleAll)
                                button_delete_all = '';
                            let title = `<h3 class="list-files-title">${lis_files.length} Archivo${lis_files.length>2?'s':''}</h3>${button_delete_all}`;
                            div_file_list.before(title);

                            if (options.canDelete) {
                                $('#div_content_file_attachments_'+_this_.name).find('.btn-delete-all-files').click(function () {
                                    _this_.vx_file_attachment.delete_all();
                                });

                                $('.file-item-remove', div_file_list).click(function () {
                                    let data = $(this).parents('li.file-item')[0].dataset;
                                    _this_.vx_file_attachment.delete_file(data.fileName, data.fileId);
                                });
                            }
                        // }
                        options_.afterRenderFiles(files, _this_);
                    },

                    delete_file: function(file_name, file_id){
                        if(!options.canDelete)
                            return ia.alertError("No puedes borrar archivos", "Sin Permiso");

                        if(!file_name || !file_id)
                            return ia.alertError("Hace falta el nombre o el id del archivo");


                        let dDescripcion = '<br/>¿Confirmas borrar el Archivo Adjunto?<br /><br />Nombre: <strong>'+file_name+'</strong>';
                        let confirm = ia.confirmDelete(dDescripcion, null, true);

                        confirm.then(function () {
                            // alert("Vamoa a eiminar "+file_name);
                            doDeleteFile();
                        });


                        var me = _this_.vx_file_attachment;
                        function doDeleteFile(){
                            let data = {
                                accion: me.accionDelete,
                                file_name: file_name,
                                file_id: file_id,
                                id: options.pk_id
                            };

                            var extra_params = options.axtraParam;
                            for (let clave in extra_params)
                                data[clave] = extra_params[clave];

                            for (let clave in me.meExtraParams)
                                data[clave] = me.meExtraParams[clave];


                            $.ajax({
                                url: me.url,
                                cache: false,
                                type: "post",
                                async: true,
                                dataType: 'json',
                                data: data,
                            }).done(function(response, textStatus, jqXHR){
                                try {
                                    me.set_files(response.files);
                                    options_.afterDelete(response.files, _this_);
                                    if ($.notify)
                                        $.notify(response.message, 'success');
                                }catch(err){
                                    alert(err.message);
                                    console.log("vx_file_attachments: delete_file() **************");
                                    console.log(err);
                                }
                            }).fail(function (xhr, ajaxOptions, thrownError){
                                try {

                                    let message = ((xhr.responseJSON) ? xhr.responseJSON.message : undefined) || xhr.responseText || thrownError;
                                    let title_error = "Error: " + (((xhr.responseJSON) ? xhr.responseJSON.code : undefined) || (xhr.status+" -> ("+thrownError+")") || '');
                                    if (ia.alertError)
                                        ia.alertError(message, title_error, true);
                                    else
                                        alert(message);
                                }catch(err){
                                    alert(err.message);
                                    console.log("vx_file_attachments: second catch delete_file() +++++++++++++++");
                                    console.log(err);
                                }
                            });
                        }
                    },

                    delete_all: function () {
                        if(!options.canDelete)
                            return ia.alertError("No puedes borrar archivos", "Sin Permiso");

                        if (!options.addButtonDeteleAll)
                            return ia.alertError("No puedes borrar todos los archivos", "Sin Permiso");

                        const me = _this_.vx_file_attachment;

                        let dDescripcion = _this_.vx_file_attachment.messageDeletaAll||'<br/>¿Confirmas borrar todos los Archivo Adjuntos?<br /><br />';
                        let confirm = ia.confirmDelete(dDescripcion, null, true);

                        confirm.then(function () {
                            doDeleteAllFiles();
                        });


                        function doDeleteAllFiles(){
                            let data = {
                                accion: me.accionDeleteAll,
                                id: options.pk_id
                            };

                            var extra_params = options.axtraParam;
                            for (let clave in extra_params)
                                data[clave] = extra_params[clave];

                            for (let clave in me.meExtraParams)
                                data[clave] =  me.meExtraParams[clave];

                            $.ajax({
                                url: me.url,
                                cache: false,
                                type: "post",
                                async: true,
                                dataType: 'json',
                                data: data,
                            }).done(function(response, textStatus, jqXHR){
                                try {
                                    me.set_files(response.files);
                                    options_.afterDeleteAll(response.files, _this_);
                                    if ($.notify)
                                        $.notify(response.message, 'success');
                                }catch(err){
                                    alert(err.message);
                                    console.log("vx_file_attachments: delete_all() **************");
                                    console.log(err);
                                }
                            }).fail(function (xhr, ajaxOptions, thrownError){
                                try {

                                    let message = ((xhr.responseJSON) ? xhr.responseJSON.message : undefined) || xhr.responseText || thrownError;
                                    let title_error = "Error: " + (((xhr.responseJSON) ? xhr.responseJSON.code : undefined) || (xhr.status+" -> ("+thrownError+")") || '');
                                    if (ia.alertError)
                                        ia.alertError(message, title_error, true);
                                    else
                                        alert(message);
                                }catch(err){
                                    alert(err.message);
                                    console.log("vx_file_attachments: second catch delete_all() +++++++++++++++");
                                    console.log(err);
                                }
                            });
                        }
                    },

                    show: function (show_config = {}) {
                        let div_content = $('#div_content_file_attachments_'+_this_.name);
                        div_content.show();
                    },
                    hide: function () {
                        let div_content = $('#div_content_file_attachments_'+_this_.name);
                        div_content.hide();
                    },
                    close: function () {this.hide()},
                    open: function () {this.show()},
                    set: function (attr, value) {},
                    get: function () {},

                    destroy: function () {
                        $(_this_).show();
                        $(_this_).removeClass('vx_file_attachments');
                        let div_content = $('#div_content_file_attachments_'+_this_.name);
                        div_content.html('');
                        div_content.remove();
                        delete _this_.vx_file_attachment;
                        if (_style !== null) {
                            _style.parentNode.removeChild(_style);
                        }
                        _style = null;
                    },

                    set_title: function (title_set) {
                        let div_content = $('#div_content_file_attachments_'+_this_.name);
                        $('.list-files-title', div_content).text(title_set);
                    },

                    /* setActivateOn: function (_trigger_on){
                    },
                    getActivateOn: function () {
                    },


                    getTitle: function () {return '';},
                    */
                };
            }
        }
        return this;

        function _setStyles() {
            var css = '',
                head = document.head || document.getElementsByTagName('head')[0],
                style = document.createElement('style');

            head.appendChild(style);

            css = `
                .div_content_file_attachments {
                    border: 1px solid #77a9e1;
                    box-shadow: 1px 1px 2px #77a9e1, 0 0 0.1em #194160, 0 0 0.1em #d0d0d2;
                    width: max-content;
                }
                .content-file-explorer {
                    border-right: 2px solid #77a9e1;
                    margin: 0;
                    padding: 0.5em;
                    height: 10em;
                    width: 7em;
                    text-align: center;
                }
                .content-file-explorer .drag-drop-file {
                    border: 2px dashed grey;
                    height: 100%;
                    color: grey;
                    display: flex;
                    align-items: center;
                    cursor: pointer;
                }
                .content-file-explorer .drag-drop-file:hover .file-icon-explorer {
                    animation: bounce 1.5s ease 3;
                }
                .file-icon-explorer {
                    font-size: 2.2em;
                }
                @keyframes bounce {
                    0%, 20%, 50%, 80%, 100% {transform: translateY(0);}
                    40% {transform: translateY(-0.2em);}
                    60% {transform: translateY(-0.1em);}
                }
                .content-file-explorer .drag-drop-file.dragging-file {
                    background: #8a899173;
                }
                .list-files-title {
                    margin: 0;
                    padding: 0.2em 0.5em;
                }
                .btn-delete-all-files {
                    border: none;
                    background: no-repeat;
                    font-size: 1.1em;
                    padding: 0;
                    position: absolute;
                    top: 0.2em;
                    right: 0.5em;
                }
                .div-file-list {
                    max-height: 9em;
                    overflow-y: auto;
                    overflow-x: hidden;
                    scrollbar-width: thin;
                    scrollbar-color: #f8faff #A6C9E2;
                    width: 40em;
                }
                .div-file-list.with-files {
                    /* box-shadow: 1px 1px 2px #77a9e1, 0 0 0.1em #194160, 0 0 0.1em #d0d0d2 */;
                    border-top: 2px solid #77a9e1;
                    min-width: 40em;
                }
                .div-file-list ul {
                    padding-left: 0.5em;
                    list-style: none;
                    counter-reset: item;
                }
                .div-file-list ul li {
                    position: relative;
                    height: 40px;
                    counter-increment: item;
                }
                .div-file-list ul li a.link-download-file {
                    margin-left:0.5em;
                    top: 7px;
                    position: relative;
                    width: 31em;
                    display: inline-flex;
                }
                /*.div-file-list ul li:before {
                    top: 10px;
                    position: relative;
                    content: counter(item) ". ";
                    font-weight: bold;
                }*/
                .div-file-list ul li:hover {
                    background: #72c5e65e;
                }
                .list_files .hoverImageWrapper {
                    display: inline-block;
                    transition: background 0.5s ease-in-out;
                    border-radius: 10px;
                    overflow: hidden;
                    // position: absolute;
                    // right: 0;
                }
                .list_files .hoverImageWrapper:hover {
                    background: #00000096;
                }
                .list_files .hoverImageWrapper {
                    display: inline-block;
                }
                .list_files .hoverImageWrapper:hover .hoverImage {
                    transform: scale(1.2);
                    opacity: 0.3;
                }
                .list_files .hoverImage {
                    position: relative;
                    align-self: stretch;
                    height: auto;
                    flex-shrink: 0;
                    object-fit: cover;
                    max-width: 100%;
                    transition: transform 0.5s ease-in-out;
                }
            `;

            style.type = 'text/css';
            if (style.styleSheet){
                // This is required for IE8 and below.
                style.styleSheet.cssText = css;
            } else {
                style.appendChild(document.createTextNode(css));
            }
            _style = style;
        }

        function _setHtml(this_)
        {
            _this.hide();
            var $this = $(this_);
            $this.after(_prepareHtml($this));
            $this.addClass('vx_file_attachments');
        }

        function _prepareHtml($this) {
            let input_name = $this[0].name;
            let html_add_icon = `<div class="custom-file flexItem content-file-explorer" style="">
                    <div class="drag-drop-file">
                        <div>
                            <label for="${input_name}__" id="label_for_icon" class="tooltip_toolbar_wohtml" title="Adjuntar archivos"><i class="file-icon-explorer fa-duotone fa-solid fa-folder-open" style=""></i></label>
                            <p style="margin: 0"><b style="color:black">Elija un archivo</b> o arrástrelo aquí</p>
                        </div>
                    </div>
                </div>`;

            if(!options.canAdd)
                html_add_icon = '';

            let html_list = `<div class="flexItem" style="margin:0; padding: 0; position: relative;">
                    <div id="div_file_list_${input_name}" class="div-file-list"></div>
                </div>`;
            if(!options.addListFiles)
                html_list ='';

            return `<div class="flexRow div_content_file_attachments" id="div_content_file_attachments_${input_name}" style="margin: 0 0 0 0.5em;">
                ${html_add_icon}
                ${html_list}
            </div>`
        }

        function _setAcceptFiles(_input)
        {
            var files_ok = [];
            if (options.filesAccept.length == 0) // no mandaron nada
            {
                if (_input.accept.length > 0){
                    let string = _input.accept;
                    string = string.replaceAll(".","");
                    files_ok = string.split(",").map(function (item) { return item.trim();});
                }
            }
            else {
                if (options.filesAccept !== '*' && !Array.isArray(options.filesAccept))
                {
                    files_ok = (options.filesAccept).split(",").map(function (item) { return item.trim(); });
                }
                else if(Array.isArray(options.filesAccept)){
                    files_ok = options.filesAccept.map(function(item) { return item.trim().replaceAll(".", ""); });
                }
            }
            if (files_ok.length == 0) {
                files_ok = '*';
                _input.accept = '.*';
            }
            else {
                _input.accept = '.'+files_ok.join(',.');
            }
            _input.vx_file_attachment.filesAccept = files_ok;
        }
        function _setEvents(input_) {
            // Add Files
            $(input_).off('change').on('change', input_.vx_file_attachment.add_files);
            let input_name = $(input_).attr('name');

            // Drag and Drop
            let div_drag_drop = $('#div_content_file_attachments_'+input_name).find('.drag-drop-file');
            div_drag_drop.click(function () {input_.click();});
            div_drag_drop[0].addEventListener('dragover', function(e) {
                e.preventDefault();
                this.classList.add('dragging-file');
            }, false);
            div_drag_drop[0].addEventListener("dragleave", function( e ) {
                e.preventDefault();
                this.classList.remove('dragging-file');
            }, false);
            div_drag_drop[0].addEventListener('drop', function (e) {
                e.preventDefault();

                input_.files = e.dataTransfer.files;
                this.classList.remove('dragging-file');
                $(input_).change();
            });
        }

        function _getIconToFile(file_name)
        {
            if (_fileIsImage(file_name))
                return '<i class="fa-icon fa-duotone fa-image txt_shadow_grey grid_tooltip_" style="font-size: 2em"></i>';

            let extension = file_name.split('.').pop().toLowerCase();
            let ext_files = {
                word: ['doc', 'docx', 'docm', 'dotx', 'dotm'],
                excel: ['csv', 'xls', 'xlsx', 'xlsm', 'xltx', 'xltm', 'xlsb', 'xlam'],
                ppoint: ['ppt', 'pptx', 'pptm', 'potx', 'potm', 'ppam', 'ppsx', 'ppsm', 'sldx', 'sldm', 'thmx'],
                pdf: ['pdf'],
                txt: ['txt']
            };
            if (ext_files.word.includes(extension)) {
                return '<i class="fa-icon fa-duotone fa-file-word txt_shadow_grey grid_tooltip_" style="font-size: 2em"></i>';
            }
            if (ext_files.excel.includes(extension)) {
                return '<i class="fa-icon fa-duotone fa-file-excel txt_shadow_grey grid_tooltip_" style="font-size: 2em"></i>';
            }
            if (ext_files.ppoint.includes(extension)) {
                return '<i class="fa-icon fa-duotone fa-file-powerpoint txt_shadow_grey grid_tooltip_" style="font-size: 2em"></i>';
            }
            if (ext_files.pdf.includes(extension)) {
                return '<i class="fa-icon fa-duotone fa-file-pdf txt_shadow_grey grid_tooltip_" style="font-size: 2em"></i>';
            }
            if (ext_files.txt.includes(extension)) {
                return '<i class="fa-icon fa-duotone fa-file-lines txt_shadow_grey grid_tooltip_" style="font-size: 2em"></i>';
            }

            return '<i class="fa-icon fa-duotone fa-eye txt_shadow_grey grid_tooltip_" style="font-size: 2em"></i>';
        }

        function _fileIsImage(fileName) {
            const dotIndex = fileName.lastIndexOf('.');
            if (dotIndex === -1) {
                return false;
            }
            const ext = fileName.substring(dotIndex + 1).toLowerCase();
            return (ext === 'jpg' || ext === 'jpeg' || ext === 'gif' || ext === 'png');
        }

        function _defineAction(_this, _action)
        {
            if (options_ === 'destroy') {
                _this.each(function () {
                    if (this.hasClass('vx_file_attachments'))
                        this.vx_file_attachment.destroy();
                });
            }
            if (options_ === 'closeAll' || options_ === 'hideAll' || options_ === 'close' || options_ === 'hide') {
                _this.each(function () {
                    if (this.hasClass('vx_file_attachments')) {
                        this.vx_file_attachment.close();
                    }
                });
            }
            if (options_ === 'openAll' || options_ === 'showAll' || options_ === 'open' || options_ === 'show') {
                _this.each(function () {
                    if (this.hasClass('vx_file_attachments')) {
                        this.vx_file_attachment.show();
                    }
                });
            }
        }
    }
}( jQuery ));