let modal_dialog;

$( document ).ready()
{
    const lectura= $('#lectura');
    //Boton de guardar
    const btnguardar= $('#btnGuardarReglas');
    btnguardar.on('click', doGuardaReglas);
    //Boton onlyread
    const read_only= $('#btnReadOnly');
    read_only.on('click', doReadOnly);
    let comentario= $('#rules_cometario').val();
    //boton Editar
    const editar= $('#btnEditar');
    editar.on('click', doEditar);
    let editor;
    //busqueda
    let ruta_busqueda= $('#ruta_busqueda').length=== 0 ? null : $('#ruta_busqueda').val();
    const enlace_list_rules= $('.enlace_list_rules');
    enlace_list_rules.on('click',obteniendoHistorial);
    //variables de contenido
    const rules_textarea= $('#rules_textarea');
    let rules_edit_titulo;
    let acordeon_historial= $('#acordeon_historial_rules');
    let acordeon_preview_rules= $('#acordeon_preview_rules');
    acordeon_preview_rules.on('click',()=>{ trayendoArchivos(true) });
    determiandoPermiso();

    //modal
    modal_dialog=$('#modal_rules');
        InicializandoModalRules();
        reglasMostrandoModal();
        function InicializandoModalRules(){
            modal_dialog.dialog();

            acordeon_historial.accordion({
                active: false,
                collapsible: true
            });
            acordeon_preview_rules.accordion({
                active: false,
                collapsible: true
            });
            $('#modal_rules').dialog("close");
        }
    function reglasMostrandoModal(){
        setteandoTitulo();
    }

    function mostrandoInfo(event){
        if( comentario)
        {    comentario = editor.getContent();
            trayendoArchivos();
        }else{
            /* @TODO enviar al server Error */ 
            js_errores_a_dime('Error no encontre las reglas de esta hoja');
        }
    }
    function determiandoPermiso(){
        const btnguardar= $('#btnGuardarReglas');
        let time= 500;

        if (!btnguardar.is('*')) {
            trayendoArchivos(true);
            acordeon_preview_rules.accordion();
            acordeon_preview_rules.accordion({active:0});
            return;
        }
        setInterval(() => {
            if(typeof tinymce === "undefined" || time!==500) return;
            time= 720000000000;
            init_tinymce("#rules_cometario");
            editor = tinymce.get('rules_cometario');
            editor.on('keyup', mostrandoInfo);

        }, time);
    }

    //Metodo que crea el archivo
    async function doGuardaReglas(e){
        e.preventDefault();
        guardandoArchivos();

        rules_textarea.show();
        formateandoHistorial();

        $('.alerta_rules').addClass('alerta_show_rules');

        setTimeout(()=>{$('.alerta_rules').removeClass('alerta_show_rules')}, 3000);

    }
    async function doReadOnly(e=null) {
        if (e) e.preventDefault();

        rules_textarea.hide();

        trayendoArchivos(true);

        btnguardar.prop('disabled',true).hide();

        mostrandoHistory();

    }
    //funcion que trae el archivo
    function trayendoArchivos(archivo=null){

        let ruta_busqueda= $('#ruta_busqueda').length=== 0 ? null : $('#ruta_busqueda').val();
        let array_ruta= obteniendoRuta(ruta_busqueda);
        const input_titulo= $('#rules_titulo');
        let titulo_reglas= `##${input_titulo.val()}##`;

        $.ajax({
            url: "../backoffice/ajax/show_reglas.php",
            method: 'POST',
            cache: false,
            data: {
                accion: 'mostrarOnlyRead',
                ruta: array_ruta,
                archivo: archivo,
                comentario: comentario,//El valor del icono al clicarlo,
                titulo_reglas: titulo_reglas,

            },
            processData: true,
            dataType: 'json',
            beforeSend: function(){
                // en_revisa_tc_conversion = true;
            }
        }).done(function(response, textStatus, jqXHR){
            if(!response.status) {
                ia.alertError(response.message || "Error Insesperado", "Error");
                return;
            }
            actualizandoInputs(response)

        }).fail(function () {
            console.log("trayendoArchivos.done response",arguments);
        });
    }
    function doEditar(e){
        e.preventDefault();

        rules_textarea.show();
        //bloqueando text area
        tinymce.editors["rules_cometario"].getBody().style.backgroundColor = '#FFF';
        tinymce.editors["rules_cometario"].getBody().setAttribute('contenteditable', true);

        trayendoArchivos(true);

        btnguardar.prop('disabled',false);
        btnguardar.show();

        formateandoHistorial();

    }
    //Metodo que obtiene una ruta
    function obteniendoRuta(ruta= null) {
        let rutaJS = !ruta ? window.location.pathname : ruta;
        rutaJS= rutaJS.replace('/vitex/','');
        rutaJS= rutaJS.replace('.php','');

        const arreglo_nota_bodega= ['bodega/edita_movimiento','bodega/alta_movimiento','backoffice/nota_bodega'];

        if (arreglo_nota_bodega.includes(rutaJS)) rutaJS= 'backoffice/nota_bodega';

        const array_ruta=rutaJS.split('/');

        return array_ruta;

    }
    async function guardandoArchivos() {
        //Actualizamos el textarea de tinymce
        tinymce.triggerSave();

        let ruta_busqueda= $('#ruta_busqueda').length=== 0 ? null : $('#ruta_busqueda').val();
        let array_ruta= obteniendoRuta(ruta_busqueda);
        const input_titulo= $('#rules_titulo');
        let titulo_reglas= `##${input_titulo.val()}##`;
        let comentario= $('#rules_cometario').val();

        $.ajax({
            url: "../backoffice/ajax/reglas_acciones.php",
            data: {
                accion: 'guardarRegla',
                value: comentario,
                ruta: array_ruta,
                titulo_reglas: titulo_reglas,
                comentario: comentario//El valor del icono al clicarlo,
            },
            method: 'POST',
            processData: true,
            dataType: 'json',
            beforeSend: function(){
                // en_revisa_tc_conversion = true;
            }
        }).done(function(response, textStatus, jqXHR){
            if(!response.status) {
                ia.alertError(response.message || "Error Insesperado", "Error");
                return;
            }
            trayendoArchivos();
        }).fail(function () {
            console.log("trayendoArchivos.done response",arguments);
        });
    }
    function mostrandoForm() {
        const form_titulo= $('#form_titulo');
        form_titulo.show();
    }
    function actualizandoInputs(response){
        const {contenido, bandera, titulo}=response
        if (contenido){
            $('#rules_div_onlyread').html(contenido);
            if (bandera){
                //borrando contenido del div pasado
                $('#rules_div_onlyread').empty();

                //respuesta del server
                let rules_texto = contenido;

                // Crear un nuevo objeto DOMParser
                var parser = new DOMParser();

                // Parsear la respuesta como HTML
                var respuesta_html = parser.parseFromString(rules_texto, 'text/html').body.textContent;

                $('#rules_onlyread').remove();

                let divTemporal = document.createElement("div");
                divTemporal.id= "rules_onlyread";
                const div_response= document.createElement("div");
                div_response.innerHTML = respuesta_html;

                divTemporal.appendChild(div_response)
                $('#rules_div_onlyread').append(divTemporal);

                //Seteando titulo
                const vista_titulo= $('#vista_titulo');
                vista_titulo.removeClass('none');
                const form_titulo= $('#form_titulo');
                form_titulo.addClass('none');

                let format_rules= titulo==='' ? 'Reglas del site': titulo;
                //Poniendo la respuesta del titulo
                $('#rules_titulo').val(format_rules);
                setteandoTitulo();
            }
            }
        }
        function obteniendoHistorial(e){
        const archivo_historial =e.target.textContent.trim();
        $('.enlace_list_rules').removeClass('color_green');
        $(this).addClass('color_green');
        let array_ruta= obteniendoRuta(ruta_busqueda);
        $.ajax({
        url: "../backoffice/ajax/historial_reglas.php",
        data: {
        accion: 'mostrarHistorial',
        value: archivo_historial,
        ruta: array_ruta,
    },
        method: 'POST',
        processData: true,
        dataType: 'json',
        beforeSend: function(){
        // en_revisa_tc_conversion = true;
    }
    }).done(function(response, textStatus, jqXHR){
        if(!response.status) {
        ia.alertError(response.message || "Error Insesperado", "Error");
        return;
    }
        actualizandoInputs(response)
        mostrandoHistory();
        $('#rules_textarea').hide();
    }).fail(function () {
        console.log("mostrarHistorial.done response",arguments);
    });
    }
        function formateandoHistorial(){

        $('.history').removeClass('d-flex-history').addClass('w-50').removeClass('w-100');
        $('#acordeon_preview_rules').removeClass('w-50');
        $('.contenedor_rule').removeClass('h500');
        $('#acordeon_historial').removeClass('w-50');
    }
        function mostrandoHistory(){
        $('.history').addClass('d-flex-history').removeClass('w-50').addClass('w-100');
        $('#acordeon_preview_rules').addClass('w-50');
        $('.contenedor_rule').addClass('h500');
        $('#acordeon_historial').addClass('w-50');

        acordeon_historial.accordion();
        acordeon_preview_rules.accordion();

        acordeon_historial.accordion({active:0});
        acordeon_preview_rules.accordion({active:0});
    }
        function setteandoTitulo() {
        const form_titulo = $('#form_titulo');
        form_titulo.hide();

        const input_titulo = $('#rules_titulo').val();

        const iconElement = $('<i class="fa-regular fa-pen-to-square pointer"></i>')
        .attr('id', 'rules_edit_titulo')
        .css({
        marginLeft: '10px',
        cursor: 'pointer'
    })
        .on('click', function () {
        const form_titulo = $('#form_titulo');
        if (form_titulo.is(':visible')) {
        form_titulo.hide();
        $(this).attr('title', 'Mostrar título');
    } else {
        form_titulo.show();
        $(this).attr('title', 'Ocultar título');
    }
    });

        const iconClose = $('<i class="fa-regular fa-circle-xmark pointer" style="margin-left: 10px; color: red;"></i>')
        .attr('id', 'rules_close_dialog')
        .css({
        position: 'absolute',
        right: '10px',
        top: '50%',
        transform: 'translateY(-50%)',
        color: 'red',
        cursor: 'pointer'
    })
        .on('click', function () {
        modal_dialog.dialog("close");
    });

        const dialogHeader = modal_dialog.dialog('widget').find('.ui-dialog-titlebar')
        ;

        dialogHeader.empty();
        dialogHeader.css('position', 'relative');
        dialogHeader.append(
        $('<span></span>').text(input_titulo)
        );
        dialogHeader.append(iconElement);
        dialogHeader.append(iconClose); // Añade el ícono de cerrar

    }
}