function resetEstados() {
    $("#confirmar_reset_state").remove();
    $("BODY").append(
        `<div id='confirmar_reset_state' class='jqgridcolssorter_dialog'>
        <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0px 12px 20px 0;"></span>¿Seguro que quiere borrar <span style="color:red; font-weight: bold; text-transform: uppercase;">todos</span> los estados de <span style="color:red; font-weight: bold; text-transform: uppercase;">todos los registros</span>?</p></div>
        </div>`
    );

    $("#confirmar_reset_state").dialog({
                title: "LIMPIA ESTADOS",
                resizable: false,
                height: "auto",
                width: 400,
                modal: true,
                buttons: [
                    {
                        text: "Confirmar",
                        icon: "ui-icon-check", // Clase de icono de jQuery UI
                        click: function() {
                            // Acción a realizar si el usuario confirma
                            reseteandoState();
                        }
                    },
                    {
                        text: "Cancelar",
                        icon: "ui-icon-closethick", // Clase de icono de jQuery UI
                        click: function() {
                            $(this).dialog("close");
                        }
                    }
                ]
            });
}
function reseteandoState() {
    $.ajax({
        url: '../backoffice/ajax/ResetState.php',
        method: 'POST',
        cache: false,
        data: {accion:'resetBodega'},
        dataType: 'json',
    })
    .done(function(data, textStatus, jqXHR) {
        if(!data.status) {
            ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
            console.log("ajax failed url:", this.url);
            return;
        }
        gridhandler.trigger("reloadGrid");
        $("#confirmar_reset_state").dialog("close");

    })
    .fail(function(jqXHR, textStatus, errorThrown) {
        ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
        console.log('ajax failed: ' + this.url, arguments);
    });
    
}

function resetEstadosSelec(tipo) {
    let row_visible= $('tr.ui-row-ltr:visible', gridhandler); 

    let rowid = [];

    row_visible.each(function(index, el) {
        let id_row=$(el).prop('id');
        rowid.push(id_row);
    });

    let rowid_string = rowid.join(',');

    $('.ui-dialog-titlebar-close:visible').trigger('click');
            $("#confirmar_reset_select").remove();
            $("BODY").append(
                `<div id='confirmar_reset_select' class='jqgridcolssorter_dialog'>
                <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0px 12px 20px 0;"></span>¿Seguro que quiere borrar <span style="color:red; font-weight: bold; text-transform: uppercase;">todos</span> los estados <span style="color:red; font-weight: bold; text-transform: uppercase;">visibles</span> ?</p></div>
                </div>`
            );

            $("#confirmar_reset_select").dialog({
                        title: "LIMPIA ESTADOS VISIBLES",
                        resizable: false,
                        height: "auto",
                        width: 400,
                        buttons: [
                            {
                                text: "Confirmar",
                                icon: "ui-icon-check", // Clase de icono de jQuery UI
                                click: function() {
                                    // Acción a realizar si el usuario confirma
                                    resetEstadosSelecAjax(rowid_string, tipo);
                                }
                            },
                            {
                                text: "Cancelar",
                                icon: "ui-icon-closethick", // Clase de icono de jQuery UI
                                click: function() {
                                    $(this).dialog("close");
                                }
                            }
                        ]
                    });
}
function resetEstadosSelecAjax(ids, tipo) {
    $.ajax({
        url: '../backoffice/ajax/ResetState.php',
        method: 'POST',
        cache: false,
        data: {accion:`reset${tipo}Select`, ids},
        dataType: 'json',
        })
        .done(function(data, textStatus, jqXHR) {
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax failed url:", this.url);
                return;
            }

            gridhandler.trigger("reloadGrid");
            $("#confirmar_reset_select").dialog("close");

        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
        });
}