$(function () {
    $('#btn_reset_selected, #btn_reset_all').button();
});

function resetBodega(bodega_id)
{
    let title = bodega_id === '*' ? '¿Reset de TODAS LAS BODEGAS? ¡Danger!' : 'Reset de Bodega. ¡Cuidado!';
    if (!Array.isArray(bodega_id) && bodega_id !== '*') {
        for(let b of bodegas) {
            if (b.bodega_id === bodega_id) {
                title = 'Reset de la Bodega ' + b.bodega;
                break;
            }
        }
        bodega_id = [bodega_id];
    }

    $d.dialogoConfirmWithPassword({
        titulo: title,
        callBack: function (pwd, response) {
            doResetBodega(bodega_id);
        }
    });
}

function doResetBodega(bodega_id)
{
    if (empty(bodega_id)) {
        vx_alert(divIDError, 'Falta id para reset', 'Alerta!');
        return;
    }
    if (!Array.isArray(bodega_id) && bodega_id !== '*') {
        bodega_id = [bodega_id];
    }
    jqBlockUI();
    let request = {url: getUrlForAjax('bodega_acciones.php'), data: {accion: 'resetBodega', bodega_id: bodega_id }};
    jqAjax(request, resetOk)
    function resetOk(res)
    {
        if (bodega_id.length === 1 && bodega_id !== '*')
            selected_row_id = bodega_id;

        if (res.code === 200 && res.status === true) {
            ia.alertInfo(res.html_resumen, "Resumen de Reset", true);
            gridhandler.trigger('reloadGrid');
        }
        else {
            ia.alertError(res.message, 'Reset de Bodega', true);
        }
    }
}

function resetBodegasSeleccionadas()
{
    var bodegas_id = getGridVisibleSelectedIds(gridhandler);
    if (empty(bodegas_id)) {
        vx_alert(divIDError, 'Seleccione bodegas para hacer reset', 'Alerta!');
        return;
    }
    resetBodega(bodegas_id);
}

function resetBodegasTodas()
{
    resetBodega('*');
}