var gridhandlerInconsistencias = null, gridhandler = null;
var data_jqgrid = [];
var inconsistencias;
jQuery(function($){
    inconsistencias = {
    urlRequest: getUrlForAjax('inconsistencia_nota_bodega_acciones.php'),
    puede_hacer_reset: puede_hacer_reset_inconsistencias,

    initControls: function () {
        this.initCheckResetInconsistencia();
    },

    initJqGrid: function () {
        var _this = this;
        var pager = "#pager_jqgrid_inconsistencias";

        gridhandlerInconsistencias = gridhandler = $('#jqgrid_inconsistencias');
        let jqGridConfig = {
            regional: 'es',
            search: true, // Activa el buscador
            sortable: true, // Permite ordenar las columnas
            url: _this.urlRequest,
            datatype:'local',
            postData: {
                iactbl:'inconsistencia_nota_bodega',
                iacpk: 'inconsistencia_nota_bodega_id',
                isJqgrid: true,
                search: {}
            },
            loadonce: true,
            data: data_jqgrid,
            searchOperators: {
                eq: "igual",
                ne: "diferente",
                lt: "menor que",
                le: "menor o igual que",
                gt: "mayor que",
                ge: "mayor o igual que",
                bw: "comienza con",
                ew: "termina con",
                cn: "contiene"
            }, 
            colModel: [
                {name: "iacsel",index:"iacsel", label:"&Sigma;",template:iacJqGridSelect().iacselColTemplate,ctrl:true,ctrlId:'#iactoolbarselect',ctrlButtonset:true},
                {
                    'label': 'InconsistenciaNotaBodegaID',
                    'name': 'inconsistencia_nota_bodega_id',
                    'index': 'inconsistencia_nota_bodega_id',
                    'hidden': true,
                    'sortable': true,
                    'search': true,
                    //'key': true,
                },
                {
                    'label': 'BodegaID',
                    'name': 'bodega_id',
                    'index': 'bodega_id',
                    'hidden': true,
                },
                {
                    'label': 'NotaBodegaID',
                    'name': 'nota_bodega_id',
                    'index': 'nota_bodega_id',
                    'key': true,
                    'hidden': true,
                },

                {
                    'label': 'Nota',
                    'name': 'label',
                    'index': 'label',
                    'width': 200,
                    'template': colFmt.text,
                    'align':'left',
                },
                {
                    'label': 'Bodega',
                    'name': 'bodega',
                    'index': 'bodega',
                },
                {
                    'label': 'Número Nota',
                    'name': 'numero',
                    'index': 'numero',
                    'formatter': iaNumeroNotaGridVarFormatter,
                    'unformat': iaNumeroNotaGridVarUnFormatter,
                    'width': '80',
                    'classes':'bold',
                    'align':'center',
                },
                {
                    'label': 'Tipo Inconsistencia',
                    'name': 'tipo_inconsistencia',
                    'index': 'tipo_inconsistencia',
                },
                {
                    'label': 'Inconsistencia',
                    'name': 'inconsistencia',
                    'index': 'inconsistencia',
                    'width': 600,
                    'template': colFmt.text
                },
                {
                    'label': 'Nivel',
                    'name': 'nivel',
                    'index': 'nivel',
                    hidden:true,
                },
                {
                    'label': 'Alta DB',
                    'name': 'alta_db',
                    'index': 'alta_db',
                    'template': colFmt.timestamp,
                    hidden:true,
                },
                {
                    'label': 'Alta Por',
                    'name': 'alta_por',
                    'index': 'alta_por',
                    hidden:true,
                },
                {
                    'label': 'remarks',
                    'name': 'remarks',
                    'index': 'remarks',
                    'width': 230,
                },
            ],
            filterToolbar: true,
            gridview: true,
            viewable : true,
            height: 750,
            width: gridhandlerInconsistencias.parent().width()-25,
            hidegrid: false,
            pager: pager,
            search: true,
            autoencode : true,
            ignoreCase : true,
            shrinkToFit : false,
            scrollrows : true,
            rownumbers : true,
            rowNum: 100,
            rowList:[50,100,200,500,1000,2000,5000,10000000],        // disable page size dropdown
            viewrecords: true,    // disable current view record text like 'View 1-10 of 100'
            hoverrows : false,
            footerrow: false,
            userDataOnFooter: true,
            resizable: true,
            rowattr: function(rd, rowData) {},
            loadComplete: function (data){
                data_jqgrid = data.rows;
                $gridParams = gridhandlerInconsistencias.getGridParam();
                let caption = $('#caption_jqgrid_inconsistencias');
                caption.html(_this.getCaptionGrid($gridParams.postData.search));
                let total_inconssitencias = gridhandlerInconsistencias.getGridParam("records");
                let search = $gridParams.postData.search;
                $('.btn_reset').remove();
                if (Object.keys(search).length === 0) {
                    /*if (total_inconssitencias>0) {
                        $('#total_inconsistencias').html("<label class='lbl'>"+total_inconssitencias + " INCONSISTENCIAS</label>");
                        if (_this.puede_hacer_reset) {
                            $('#tools_jqgrid_inconsistencias').append(_this.btnsReset($gridParams.postData.search));
                        }
                    }
                    else {*/
                    $('#total_inconsistencias').html("Seleccione el tipo de Inconsistencia");
                    caption.html(_this.getCaptionGrid());
                    // }
                } else {
                    $('#total_inconsistencias').html("<label class='lbl'>" + numFormatter(total_inconssitencias, 0) + " INCONSISTENCIAS</label>");
                    if (total_inconssitencias>0) {
                        if (_this.puede_hacer_reset) {
                            $('#tools_jqgrid_inconsistencias').append(_this.btnsReset($gridParams.postData.search));
                        }
                    }
                }

                if (_this.puede_hacer_reset && $("[data-tipo_inconsistencia]").length > 0) {
                    let btn_reset_All = `<button type="button" class="btn_reset btn-danger" onClick="inconsistencias.resetAll()" style="margin-left:2em; position:absolute; right:0; height:40px">Deseas hacer Reset de Todo?</button>`;
                    $('#tools_jqgrid_inconsistencias').append(btn_reset_All);
                }
                if ($("[data-tipo_inconsistencia]").length === 0) {
                    caption.parent().html("<h2 style=\"margin: 0;text-align: center\" id=\"caption_jqgrid_inconsistencias\">- = NO HAY INCONSISTENCIAS = -</h2>");
                }

                _this.initCheckResetInconsistencia();
            },
            grouping: false,
            groupingView: {
                groupField: ['numero'],
                groupColumnShow: [true, true],
                groupText: [/*"<b>Bodega {0} - Notas{1}</b>", */'<b>Nota: {0} -> Inconsistencias {1}</b>'],
                groupCollapse: false,
            },
            caption: `<b style="font-size: 1.3em;display: block;text-align: center; margin-top: -15px;" id="total_inconsistencias">Seleccione el tipo de Inconsistencia</b>
            <h2 style="margin: 0;text-align: center" id="caption_jqgrid_inconsistencias">- = INCONSISTENCIAS = -</h2>
            <div id="tools_jqgrid_inconsistencias" style="display: flex">
            <img src="../img/grouping.png" title="Ver o no agrupado por nota" alt="Agrupar" id="toggle_grouping" style="cursor: pointer" width="30" onclick="inconsistencias.toggleGrouping()">
            
            <img class="noprint" style="cursor:pointer; margin-left: 2em;height:32px; width:32px;border:0 silver solid;visibility: hidden" src="../img/collapseAll.png" alt="Collapse all" title="Collapse all" onclick="iaJqGridGrouping.collapseAll( gridhandler )" id="inconsistencias_collapse_all">
            <img class="noprint" style="cursor:pointer; margin-left: 2em;height:32px; width:32px ;border:0 silver solid;visibility: hidden;" src="../img/expandAll.png" alt="Expand all" title="Expand all" onclick="iaJqGridGrouping.expandAll( gridhandler )" id="inconsistencias_expand_all">
        
            </div>`
        };
        gridhandlerInconsistencias.jqGrid(jqGridConfig)
    },

    getCaptionGrid: function (search = []) {
        let caption = "- = INCONSISTENCIAS";
        if (search.tipo_inconsistencia && !empty(search.tipo_inconsistencia)) {
            let tipoDisplay = inconsistencias.ucwords( search.tipo_inconsistencia.replaceAll('_', ' ') );
            if(tipoDisplay === "Contra Nota")
                tipoDisplay = "Traslado Match";
            caption += ` DE TIPO ´${tipoDisplay}´`;
        }

        if (search.bodega_id && !empty(search.bodega_id))
            caption+= ` DE LA BODEGA ${$('#bodega_id_inconsistencias option:selected').text()}`;

        if (search.numero && !empty(search.numero))
            caption+= ` EN LA NOTA ${search.numero}`;

        return caption+" = -";
    },
    btnsReset: function (search = []) {

        let cual = "";
        if(search !== null && typeof(search) === "object") {
            if($("#bodega_id_inconsistencias").val().length > 0 )
                cual += " Bodega: <b>" + $("#bodega_id_inconsistencias option:selected").text() + "</b>.";
            if(search.hasOwnProperty("numero") && (search.numero || "").length > 0)
                cual += " Nota: <b>" + search.numero + "</b>.";
            if(search.hasOwnProperty("tipo_inconsistencia") && (search.tipo_inconsistencia || "").length > 0) {
                if((search.tipo_inconsistencia || "") === 'contra_nota')
                    cual += " Tipo: Traslado Match.";
                else
                    cual += " Tipo: " + (search.tipo_inconsistencia || "").replaceAll('_', ' ') + ".";
            }

            cual = cual.slice(0, -1) + "?";
        }

        let btn_reset = [];

        // if (search.tipo_inconsistencia && !empty(search.tipo_inconsistencia))
        btn_reset.push(`<button id="buttonResetTipo" type="button" class="btn_reset btn-warning" onClick="inconsistencias.reset()" style="margin-left:2em">Deseas ¿Hacer <b>Reset</b> ${cual}</button>`);

        btn_reset.push(`<button type="button" class="btn_reset hidden reset_selected" onClick="inconsistencias.resetSelected()" style="margin-left:2em">Deseas hacer Reset de Seleccionados?</button>`);

        /*if (search.bodega_id && !empty(search.bodega_id))
            btn_reset.push(`<button type="button" class="btn_reset" onClick="inconsistencias.reset('${search.tipo_inconsistencia}')" style="margin-left:2em">Deseas hacer Reset por Bodega?</button>`);*/

        /*if (search.numero && !empty(search.numero))
            caption+= ` EN LA NOTA ${search.numero}`;*/

        // btn_reset.push(`<button type="button" class="btn_reset" onClick="inconsistencias.resetAll()" style="margin-left:2em">Deseas hacer Reset de Todas las inconsistencias?</button>`);

        return btn_reset.join("");
    },

    initCheckResetInconsistencia: function () {
        gridhandlerInconsistencias.find('input:checkbox.selecting').click(function () {
            let inputs_checked = gridhandlerInconsistencias.find('input:checkbox.selecting:checked');
            if (inputs_checked.length > 0) {
                $('.btn_reset.hidden').show()
                return;
            }
            $('.btn_reset.hidden').hide();
        });
    },



    getInconsistenciasTipo: function (type) {
        if (!type) {
            ia.alertWarn("Seleccione un tipo de inconsistencia", 'Reset Inconsistencias');
            return;
        }

        $('.container_tipos ul li').removeClass("active");
        $('BUTTON.active').removeClass('active');
        $('[data-tipo_inconsistencia="'+type+'"]').addClass('active');

        this.searchInconsistencias();

        /*let postData = gridhandlerInconsistencias.getGridParam('postData');
        postData.accion = 'getInconsistencias';
        postData.search.tipo_inconsistencia = type;
        // postData.tipo = type;
        gridhandlerInconsistencias.jqGrid('setGridParam', { 'datatype' : 'json', postData: postData });
        gridhandlerInconsistencias.trigger('reloadGrid');

        return;*/

        /*let request = {
            url: this.urlRequest,
            data:{
                accion: 'getInconsistenciasTipo',
                tipo: type,
                is_page: is_page
            }
        };
        jqAjax(request, function (res) {
            let $table = $('#tabla_inconsistencias');
            let $div_parent = $table.parent();
            console.log($div_parent);

            $table.remove();
            $div_parent.append(res.inconsistencias);
            inconsistencias.initCheckResetInconsistencia();
        });*/
    },

    searchInconsistencias: function (clear = false) {
        let postData = gridhandlerInconsistencias.getGridParam('postData');
        if (clear)
        {
            let selectize_bodega_id = $('#bodega_id_inconsistencias');
            selectize_bodega_id.val('');
            if (selectize_bodega_id.hasClass('selectized'))
                selectize_bodega_id[0].selectize.setValue('');
            $('#numero_nota_inconsistencias').val('');
            gridhandlerInconsistencias.clearGridData();
            postData.search = {};
            gridhandlerInconsistencias.jqGrid('setGridParam', { 'datatype' : 'local', postData: postData });
            gridhandlerInconsistencias.trigger('reloadGrid');
            $('.container_tipos ul li').removeClass("active");
            return;
        }

        var bodega_id = $('#bodega_id_inconsistencias').val(),
            numero_nota = $('#numero_nota_inconsistencias').val();

        postData.accion = 'getInconsistencias';
        postData.search.bodega_id = bodega_id;
        postData.search.numero = numero_nota;
        postData.search.tipo_inconsistencia = $('.container_tipos ul li.active').data('tipo_inconsistencia');
        postData.search.tipo_inconsistencia = $('BUTTON.active').data('tipo_inconsistencia');

        gridhandlerInconsistencias.jqGrid('setGridParam', { 'datatype' : 'json', postData: postData });
        gridhandlerInconsistencias.trigger('reloadGrid');
    },

    toggleGrouping: function () {
        let grouping = gridhandlerInconsistencias.getGridParam('grouping');

        let img_grouping = $('#toggle_grouping');

        if (grouping) {
            img_grouping.attr('title', 'Agrupar');
            img_grouping.attr('alt', 'Agrupar');
            img_grouping.attr('src', "../img/grouping.png");
            $("#inconsistencias_collapse_all")._hide();
            $("#inconsistencias_expand_all")._hide();
        } else {
            img_grouping.attr('title', 'Desagrupar');
            img_grouping.attr('alt', 'Desagrupar');
            img_grouping.attr('src', "../img/ungrouping.png");
            $("#inconsistencias_collapse_all")._show();
            $("#inconsistencias_expand_all")._show();
        }

        gridhandlerInconsistencias.setGridParam({grouping : !grouping});
        gridhandlerInconsistencias.trigger('reloadGrid');
    },

    resetType: function (type = '') {
        if (!type) {
            ia.alertWarn("Seleccione un tipo de inconsistencia", 'Reset Inconsistencias');
            return;
        }
        var label = type === 'contra_nota' ? 'Traslado Match' : type.replace("_", "");
        var _me = this;
        $d.dialogoConfirmWithPassword({
            titulo: 'Reset de Inconsistencias',
            message: '&nbsp;Se hará <b>reset de TODAS</b> las inconsistencias de <b>tipo: '+label+'</b>',
            callBack: function (pwd, response) {
                _me.doResetType(type);
            }
        });
    },

    doResetType: function (type)
    {
        var _this = this;
        if (!type) {
            ia.alertWarn("Seleccione un tipo de inconsistencia", 'Reset Inconsistencias');
            return;
        }

        if (type === '*' || type === 'all' || type === 'todos') {
            this.resetAll();
            return;
        }
        let request = {
            url: this.urlRequest,
            data: {
                accion: 'resetInconsistenciaTipo',
                tipo: type
            }
        };
        jqAjax(request, function (res) {
            $("[data-tipo_inconsistencia='"+type+"']").remove();
            _this.searchInconsistencias();
            ia.alertInfo(res.message, 'Reset de Inconsistencias', true);
        });
    },

    reset: function () {
        var _this = this;
        if (!this.puede_hacer_reset) {
            ia.alertWarn("No tienes permiso para realizar esta acción", 'Reset Inconsistencias');
            return;
        }
        let $gridParams = gridhandlerInconsistencias.getGridParam();
        let search = $gridParams.postData.search;
        let total_inconsistencias = gridhandlerInconsistencias.getGridParam("records");
        if (total_inconsistencias === 0) {
            ia.alertInfo("No hay registros para poder hacer reset", 'Reset Inconsistencias');
            return;
        }
        let message = "&nbsp;Se hará <b>reset de TODAS</b> las inconsistencias";

        if (search.tipo_inconsistencia && !empty(search.tipo_inconsistencia)) {
            if(search.tipo_inconsistencia === 'contra_nota')
                message += ` DE TIPO <b>TRASLADO MATCH</b>`;
            else
                message += ` DE TIPO <b>${(search.tipo_inconsistencia).replaceAll("_", " ")}</b>`;
        }

        if (search.bodega_id && !empty(search.bodega_id))
            message+= ` DE LA BODEGA <b>${$('#bodega_id_inconsistencias option:selected').text()}</b>`;

        if (search.numero && !empty(search.numero))
            message+= ` EN LA NOTA <b>${search.numero}</b>`;

        $d.dialogoConfirmWithPassword({
            titulo: 'Reset de Inconsistencias',
            message: message,
            callBack: function (pwd, response) {
                _this.doReset(search);
            }
        });
    },

    resetAll: function () {
        var _this = this;
        $d.dialogoConfirmWithPassword({
            titulo: 'Reset de Inconsistencias',
            message: "Se hará reset de <b>TODAS LAS INCONSISTENCIAS</b>",
            callBack: function (pwd, response) {
                _this.doReset('*');
            }
        });
    },
    doReset: function (search) {
        var _this = this;
        if (!this.puede_hacer_reset) {
            ia.alertWarn("No tienes permiso para realizar esta acción", 'Reset Inconsistencias');
            return;
        }
        if (!search) {
            ia.alertInfo("No hay registros para poder hacer reset", 'Reset Inconsistencias');
            return;
        }
        jqBlockUI(null, false, false);
        let request = {
            url: this.urlRequest,
            data: {
                accion: 'resetInconsistencias',
                search: search
            }
        };
        jqAjax(request, function (res) {
            jqUnBlockUI();
            let alert = ia.alertInfo(res.message, 'Reset de Inconsistencias', true);
            if (true ||  search === '*') {
                alert.done(function () {
                    location.reload();
                });
                alert.fail(function () {
                    location.reload();
                });
            } else {
                _this.searchInconsistencias();
            }
        });
    },

    resetSelected: function () {
        var _this = this;
        var inconsistencias_id_selected = getGridVisibleSelectedIds(gridhandlerInconsistencias);

        if (inconsistencias_id_selected.length <= 0) {
            ia.alertWarn("Seleccione inconsistencias para hacer reset", 'Reset Inconsistencias');
            return;
        }

        let inconsistencias_id_selected_real = [];
        inconsistencias_id_selected.forEach(function (id_row, key) {
            let dataRow = gridhandlerInconsistencias.getRowData(id_row);
            inconsistencias_id_selected_real.push(dataRow.inconsistencia_nota_bodega_id);
        });

        jqBlockUI(null, false, false);
        let request = {
            url: this.urlRequest,
            data: {
                accion: 'resetInconsistencia',
                inconsistencia_id: inconsistencias_id_selected_real
            }
        };
        jqAjax(request, function (res) {
            jqUnBlockUI();
            _this.searchInconsistencias();
        });
    },

    ucwords: function(phrase) {
        return phrase.toLowerCase().replace(
            /(^([\p{L}\p{M}]))|([\s-][\p{L}\p{M}])/gmiu,
            function(s){
                switch(s) {
                    case ' a':
                    case ' e':
                    case ' o':
                    case ' u':
                    case ' y':
                    case ' de':
                    case ' del':
                    case ' en':
                    case ' el':
                    case ' la':
                    case ' los':
                    case ' las':
                        return s;
                    default:
                        return s.toUpperCase();
                }
            }
        );
    },

};
    Object.freeze(inconsistencias);
});
function iaNumeroNotaGridVarFormatter (cellvalue, options, rowObject) {
    let posicion_numero = typeof posicion_column_numero === 'undefined' ? 8: posicion_column_numero;
    var nota_bodega_id = rowObject['nota_bodega_id'] || rowObject[posicion_numero];
    if (empty(nota_bodega_id))
        return "<span data-value='"+cellvalue+"'>"+cellvalue+"</span>";

    var url = getUrlBase('bodega/edita_movimientos_v2.php?nota_bodega_id=' + nota_bodega_id + "&iah=e&iagridvar=gridhandlerInconsistencias");
    return "<a href='"+url+"' title='VER LA NOTA' target='_blank' rel='opener refferer'><span data-value='"+cellvalue+"'>"+cellvalue+"</span></a>";
}
function iaNumeroNotaGridVarUnFormatter (cellvalue, options, rowObject) {return $(cellvalue).data("value");}

runAfterFetchingCatalogs(() => {
    inconsistencias.initJqGrid();

    inconsistencias.initControls();
    dialogConsultarExistencia.initOtrosBuscadores($vitex_globales['g_cat_bodegas_y_grupos'], $vitex_globales['g_cat_producto_general'], $vitex_globales['g_cat_color_alfabetico']);

    /*gridhandlerInconsistencias.setGridParam({grouping : false});
    gridhandlerInconsistencias.trigger('reloadGrid');*/

}, 'inconsistencias.js');


