var filter_reset = false;
$(document).ready(function () {
    doSumasGrid = productoBodegadoSumasGrid;
    $('#btn_reset_selected, #btn_reset_filters, #btn_ajuste_inventario').button();
});

function productoBodegadoSumasGrid(iasumCols, solo_filas_visibles = true)
{
    solo_filas_visibles = typeof solo_filas_visibles === "undefined" ? true : solo_filas_visibles;
    $(".ui-jqgrid-ftable td").html("&#160;");
    //Suma los seleccionados
    if(typeof iasumCols === 'undefined' || typeof iasumCols['rn'] === 'undefined')
    {
        doSumasGridSolamente(solo_filas_visibles);
        return false;
    }

    iasumCols = typeof iasumCols !== 'undefined' ? iasumCols : {};
    var col = "", newSums = {};

    $.each(iasumCols, function(k,v){
        col = k.replace("suma_", "");
        newSums[col] = v;
    });

    gridhandler.jqGrid('footerData', 'set', newSums);
}

function resetBodegaProductoColor(producto_bodega_id)
{
    let message = '';

    if (!Array.isArray(producto_bodega_id)) {
        producto_bodega_id = [producto_bodega_id];
        const row = gridhandler.jqGrid('getRowData',producto_bodega_id);
        const bodega_id = row.bodega_id;
        let bodega_name = '';
        for(let b of bodegas)
            if(b.bodega_id === bodega_id )
                bodega_name = b.bodega;
        message = `¿Esta seguro de hacer <b>reset</b> (pasar existencia a ceros) a: <p style="margin:2em auto auto auto;width:95%;padding-top:1em:text-align:center"> <b>${row['producto']} en la bodega: ${bodega_name}</b>?</p>`;
    }
    $d.dialogoConfirmWithPassword({
        message:message,
        titulo: 'Reset de Producto Color',
        callBack: function (pwd, response) {
            doResetBodegaProductoColor(producto_bodega_id);
        }
    });
}
function doResetBodegaProductoColor(producto_bodega_id)
{
    if (empty(producto_bodega_id)) {
        vx_alert(divIDError, 'Falta id para reset', 'Alerta!');
        return;
    }

    if (!Array.isArray(producto_bodega_id)) {
        producto_bodega_id = [producto_bodega_id];
    }

    let request = {url: getUrlForAjax('producto_color_acciones.php'), data: {accion: 'resetProductoColor',producto_bodega_id:producto_bodega_id }};
    jqAjax(request, resetOk)
    function resetOk(res)
    {
        if (producto_bodega_id.length === 1 && producto_bodega_id !== '*')
            selected_row_id = producto_bodega_id;

        if (res.code === 200 && res.status === true) {
            gridhandler.trigger('reloadGrid');
        }
        else {
            ia.alertError(res.message, 'Reset de Producto Color', true);
        }
    }
}

function resetProductoBodegaSelected()
{
    var producto_bodega_id = getGridVisibleSelectedIds(gridhandler);
    if (empty(producto_bodega_id)) {
        vx_alert(divIDError, 'Seleccione Porductos Bodega para hacer reset', 'Alerta!');
        return;
    }
    resetBodegaProductoColor(producto_bodega_id);
}

function resetProductoBodegaFilter()
{
    var producto_bodega_id = getGridVisibleIds(gridhandler);
    if (empty(producto_bodega_id)) {
        vx_alert(divIDError, 'Filtre Porductos Bodega para hacer reset', 'Alerta!');
        return;
    }
    resetBodegaProductoColor(producto_bodega_id);
}

function showHideResetProductoBodega()
{
    let td_producto_origen = gridhandler.find("td[aria-describedby=iajqgridproducto_bodega_producto_general_id]");
    let productos_array = [];
    td_producto_origen.each(function () {
        productos_array.push(this.innerText);
    });
    let productos_unicos = productos_array.filter((v, i, a) => a.indexOf(v) === i);
    console.log('Here', productos_array);
    console.log('unique', productos_unicos);
    if (productos_unicos.length === 1) {
        console.log('mostrar boton reset producto');
    } else {
        console.log('ocultar boton reset producto');
    }
}

function filtraProductosReset()
{
    let iacwhere = '';
    if (!filter_reset) {
        iacwhere = `((existencia_rollos <= ${max_reset_rollos} AND existencia_rollos >= -${max_reset_rollos} AND existencia_rollos<>0) AND (existencia_quantity <= ${max_reset_quantity} AND existencia_quantity >= -${max_reset_quantity} AND existencia_quantity <> 0.00))`;
    }

    filter_reset = !filter_reset;

    $gridParams.postData.iacwhere = iacwhere;
    gridhandler.trigger('reloadGrid');
}

function showHideOptions()
{
    var data = gridhandler.getRowData();

    var array_producto_bodega = [];

    data.forEach(function (row, i) {
        array_producto_bodega.push(row.producto_general_id+"_"+row.bodega_id);
    });

    let producto_bodega_unique = array_producto_bodega.filter((v, i, a) => a.indexOf(v) === i);

    if (producto_bodega_unique.length === 1) {
        $('#btn_ajuste_inventario').show();
    } else {
        $('#btn_ajuste_inventario').hide();
    }

    // var productos_unicos = data.map(function (item) {
    //     console.log(item);
    // });
}

function ajusteInventarioProductoBodega(producto_bodega_id = '', es_producto_bodega = true)
{

    if (empty(producto_bodega_id))
        producto_bodega_id = gridhandler.getDataIDs()[0];

    let row = gridhandler.getRowData(producto_bodega_id);
    var bodegasByID = jsObjetivisa_(bodegas, 'bodega_id');
    var bodega = bodegasByID[row.bodega_id][0];
    let bodega_name = bodega.bodega, product_name = row.producto.split(" ") [0];

    var message = "", data = {};

    if (es_producto_bodega) {
        let requestColores = {
            url: getUrlForAjax("producto_color_acciones.php"),
            data: {accion:'obtenColoresProductoBodega', bodega_id: row.bodega_id, producto_general_id: row.producto_general_id}
        };

        jqAjax(requestColores, function (res) {
            let colores = [];
            $.each(res.colores_producto_bodega, function (i, producto_color) {
                colores.push(producto_color.color);
            });
            colores= colores.join(", ");
            message = `Está seguro de hacer <b>ajuste de inventario de ${product_name} en la bodega ${bodega_name}</b>.<br>Esto afectará los suguientes colores: `+colores;
            data = {
                accion: 'ajusteInventarioProductoBodega',
                bodega_id: row.bodega_id,
                producto_general_id: row.producto_general_id,
            };
            dialogoConfirma();
        });
    } else {
        message = `Está seguro de hacer <b>ajuste de inventario de ${row.producto} en la bodega ${bodega_name}</b>`;
        data = {
            accion: 'ajusteInventarioProductoColor',
            producto_bodega_id: producto_bodega_id,
        };
        dialogoConfirma();
    }

    function dialogoConfirma()
    {
        $d.dialogoConfirmWithPassword({
            titulo: 'Ajuste de Inventario',
            extra_inputs: [
                {
                    label: 'Ingresa numero de nota que quieres utilizar para el ajuste',
                    type: 'number',
                    identifier: 'numero_nota_ajuste_inventario',
                    required: true
                }
            ],
            message: message,
            callBack: function (pwd, response, data_inputs) {
                jqBlockUI();
                let request = {
                    url: getUrlForAjax('producto_bodega_acciones.php'),
                    data: data
                };
                request.data.numero_nota_ajuste = data_inputs.numero_nota_ajuste_inventario;
                jqAjax(request, function (response) {
                    console.log(response);
                    jqUnBlockUI();
                    ia.alertInfo(response.message, "Ajuste de Inventario");
                    gridhandler.trigger('reloadGrid');
                });
            }
        });
    }
}

function ajusteInventarioProductoColor(producto_bodega_id)
{
    ajusteInventarioProductoBodega(producto_bodega_id, false);
}