$(document).ready(function () {
    $('#btn_reset_selected, #btn_reset_all').button();
});

function resetProducto(producto_general_id)
{
    if (!Array.isArray(producto_general_id) && producto_general_id !== '*') {
        producto_general_id = [producto_general_id];
    }

    $d.dialogoConfirmWithPassword({
        titulo: 'Reset de Bodega',
        callBack: function (pwd, response) {
            doResetProducto(producto_general_id);
        }
    });
}

function doResetProducto(producto_general_id)
{
    if (empty(producto_general_id)) {
        vx_alert(divIDError, 'Falta id para reset', 'Alerta!');
        return;
    }

    if (!Array.isArray(producto_general_id) && producto_general_id !== '*') {
        producto_general_id = [producto_general_id];
    }

    jqBlockUI();
    let request = {url: getUrlForAjax('producto_general_acciones.php'), data: {accion: 'resetProducto', producto_general_id: producto_general_id }};
    jqAjax(request, resetOk)
    function resetOk(res)
    {
        if (producto_general_id.length === 1 && producto_general_id !== '*')
            selected_row_id = producto_general_id;

        if (res.code === 200 && res.status === true) {
            ia.alertInfo(res.html_resumen, "Resumen de Reset", true);
            gridhandler.trigger('reloadGrid');
        }
        else {
            ia.alertError(res.message, 'Reset de Bodega', true);
        }
    }
}

function resetProductosSeleccionados()
{
    var productos_id = getGridVisibleSelectedIds(gridhandler);
    if (empty(productos_id)) {
        vx_alert(divIDError, 'Seleccione productos para hacer reset', 'Alerta!');
        return;
    }
    resetProducto(productos_id);
}