/*!
 * Tiny Small icon pack
 *
 * Copyright (c) Tiny Technologies, Inc. All rights reserved.
 *
 * Version: 2.5.0-8
 */
tinymce.IconManager.add('small', {
  icons: {
    'accessibility-check': '<svg width="18" height="18"><path fill-rule="nonzero" d="M9 1a2 2 0 012 2 2 2 0 01-2 2 2 2 0 01-2-2c0-1.1.9-2 2-2zm6 7h-3v8c0 .6-.4 1-1 1a1 1 0 01-1-1v-3c0-.6-.4-1-1-1a1 1 0 00-1 1v3c0 .6-.4 1-1 1a1 1 0 01-1-1V8H3a1 1 0 110-2h12c.6 0 1 .4 1 1s-.4 1-1 1z"/></svg>',
    'action-next': '<svg width="18" height="18"><path fill-rule="nonzero" d="M9 10.6L4.7 6.3a1 1 0 00-1.4 1.4L9 13.4l5.7-5.7a1 1 0 10-1.4-1.4L9 10.6z"/></svg>',
    'action-prev': '<svg width="18" height="18"><path fill-rule="nonzero" d="M9 8.4l4.3 4.3a1 1 0 001.4-1.4L9 5.6l-5.7 5.7a1 1 0 001.4 1.4L9 8.4z"/></svg>',
    'align-center': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4 6a1 1 0 110-2h10a1 1 0 010 2H4zm2 4a1 1 0 110-2h6a1 1 0 010 2H6zm-2 4a1 1 0 010-2h10a1 1 0 010 2H4z"/></svg>',
    'align-justify': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4 6a1 1 0 110-2h10a1 1 0 010 2H4zm0 4a1 1 0 110-2h10a1 1 0 010 2H4zm0 4a1 1 0 010-2h10a1 1 0 010 2H4z"/></svg>',
    'align-left': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4 6a1 1 0 110-2h10a1 1 0 010 2H4zm0 4a1 1 0 110-2h6a1 1 0 010 2H4zm0 4a1 1 0 010-2h10a1 1 0 010 2H4z"/></svg>',
    'align-none': '<svg width="18" height="18"><path fill-rule="nonzero" d="M9 4l-.8 2H4a1 1 0 110-2h5zm4.5 0h.5a1 1 0 010 2h-1.4l.9-2zM7.3 8l-1 2H4a1 1 0 110-2h3.3zm4.4 0H14a1 1 0 010 2h-3.3l1-2zm-6.3 4l-.9 2H4a1 1 0 010-2h1.4zm4.4 0H14a1 1 0 010 2H9l.8-2zm2-9.2c.4.2.6.6.4 1l-5 11c-.2.4-.6.6-1 .4a.8.8 0 01-.4-1l5-11c.2-.4.6-.6 1-.4z"/></svg>',
    'align-right': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4 6a1 1 0 110-2h10a1 1 0 010 2H4zm4 4a1 1 0 110-2h6a1 1 0 010 2H8zm-4 4a1 1 0 010-2h10a1 1 0 010 2H4z"/></svg>',
    'arrow-left': '<svg width="18" height="18"><path d="M5 9.9l7.6 3.8a1 1 0 001.4-.9V5.2a1 1 0 00-1.4-1l-7.7 4a1 1 0 000 1.7z" fill-rule="evenodd"/></svg>',
    'arrow-right': '<svg width="18" height="18"><path d="M13.4 10l-7.9 3.9a1 1 0 01-1.5-1V5a1 1 0 011.5-.9l8 4a1 1 0 010 1.8z" fill-rule="evenodd"/></svg>',
    'bold': '<svg width="18" height="18"><path d="M5.7 15c-.3 0-.4 0-.5-.2l-.2-.4V3.6c0-.2 0-.4.2-.5l.5-.1H10c1.3 0 2.3.3 3 .8.6.6 1 1.3 1 2.2 0 .6-.2 1.1-.6 1.6-.4.5-.8.8-1.3 1v.1c.3 0 .7.2 1 .5.4.2.7.6 1 1 .2.4.3.8.3 1.3 0 1.2-.3 2-1 2.6-.8.6-1.9.9-3.3.9H5.7zm4.2-7c.6 0 1-.2 1.4-.5.4-.3.6-.7.6-1.1 0-1-.7-1.5-2-1.5H7v3h3zm.5 5c.6 0 1.1 0 1.5-.4.3-.2.5-.7.5-1.2s-.2-.9-.6-1.2c-.4-.2-1-.4-1.7-.4H7v3.3h3.4z" fill-rule="evenodd"/></svg>',
    'bookmark': '<svg width="18" height="18"><path fill-rule="nonzero" d="M5 3v13l4-4 4 4V3c0-.6-.4-1-1-1H6a1 1 0 00-1 1z"/></svg>',
    'border-style': '<svg width="18" height="18"><g fill-rule="evenodd" stroke="#000"><path stroke-width="3" d="M2 5.5h14"/><path stroke-width="2" d="M2 10h6M10 10h6"/><path d="M2 13.5h2M5 13.5h2M8 13.5h2M11 13.5h2M14 13.5h2"/></g></svg>',
    'border-width': '<svg width="18" height="18"><path fill-rule="nonzero" d="M2 7V4h14v3H2zm0 4V9h14v2H2zm0 3v-1h14v1H2z"/></svg>',
    'brightness': '<svg width="18" height="18"><path d="M9 14c.3 0 .5.1.7.3.2.2.3.4.3.7v1c0 .3-.1.5-.3.7a1 1 0 01-.7.3 1 1 0 01-.7-.3A1 1 0 018 16v-1c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3zM9 4a1 1 0 01-.7-.3A1 1 0 018 3V2c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3.3 0 .5.1.7.3.2.2.3.4.3.7v1c0 .3-.1.5-.3.7A1 1 0 019 4zm7 4c.3 0 .5.1.7.3.2.2.3.4.3.7 0 .3-.1.5-.3.7a1 1 0 01-.7.3h-1a1 1 0 01-.7-.3A1 1 0 0114 9c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3h1zM4 9c0 .3-.1.5-.3.7a1 1 0 01-.7.3H2a1 1 0 01-.7-.3A1 1 0 011 9c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3h1c.3 0 .5.1.7.3.2.2.3.4.3.7zm10 3.5l.7.8c.2.1.3.4.3.6 0 .3-.1.6-.3.8a1 1 0 01-.8.3 1 1 0 01-.7-.3l-.7-.7a1 1 0 01-.3-.8c0-.2.1-.5.3-.7a1 1 0 011.4 0zm-10-7l-.7-.8a1 1 0 01-.3-.6c0-.3.1-.6.3-.8.2-.2.5-.3.8-.3.2 0 .5.1.7.3l.7.7c.2.2.3.5.3.8 0 .2-.1.5-.3.7a1 1 0 01-.7.3 1 1 0 01-.8-.3zm10 0a1 1 0 01-.8.3 1 1 0 01-.7-.3 1 1 0 01-.3-.7c0-.3.1-.6.3-.8l.8-.7c.1-.2.4-.3.6-.3.3 0 .6.1.8.3.2.2.3.5.3.8 0 .2-.1.5-.3.7l-.7.7zm-10 7c.2-.2.5-.3.8-.3.2 0 .5.1.7.3a1 1 0 010 1.4l-.8.8a1 1 0 01-.6.3 1 1 0 01-.8-.3 1 1 0 01-.3-.8c0-.2.1-.5.3-.7l.7-.7zM9 5a4 4 0 013.7 2.4 4 4 0 010 3.2A4 4 0 019 13a4 4 0 01-3.7-2.4 4 4 0 010-3.2A4 4 0 019 5zm0 6.5c.7 0 1.3-.2 1.8-.7.5-.5.7-1.1.7-1.8s-.2-1.3-.7-1.8c-.5-.5-1.1-.7-1.8-.7s-1.3.2-1.8.7c-.5.5-.7 1.1-.7 1.8s.2 1.3.7 1.8c.5.5 1.1.7 1.8.7z" fill-rule="evenodd"/></svg>',
    'browse': '<svg width="18" height="18"><path fill-rule="nonzero" d="M15 1a2 2 0 012 2v11a2 2 0 01-2 2h-4v-2h4V5H3v9h4v2H3a2 2 0 01-2-2V3c0-1.1.9-2 2-2h12zM8 9.4l-2.3 2.3a1 1 0 11-1.4-1.4l4-4a1 1 0 011.4 0l4 4a1 1 0 01-1.4 1.4L10 9.4V16a1 1 0 01-2 0V9.4z"/></svg>',
    'cancel': '<svg width="18" height="18"><path fill-rule="nonzero" d="M10 9l2.2 2a.8.8 0 01-1.1 1.2L9 10l-2 2a.8.8 0 01-1.2-1L8 9 6 7a.8.8 0 011-1.2L9 8l2-2a.8.8 0 011.2 1L10 9zm-1 8A8 8 0 119 1a8 8 0 010 16zm0-1.5a6.5 6.5 0 100-13 6.5 6.5 0 000 13z"/></svg>',
    'cell-background-color': '<svg width="18" height="18"><path d="M3.4 9l9-9 1.4 1.4-2.4 2.4 5.2 5.1c.5.6.5 1.6 0 2.2L11 16.6a1.5 1.5 0 01-2.2 0L3.4 11c-.5-.6-.5-1.5 0-2v-.2zm11.4 1L10 5.2 5.2 10h9.6zM2.7 12.9l.3-.4.2.3.3.3.3.4v.1l.3.3c.5.7.9 1.5.9 2.1a2 2 0 01-2 2 2 2 0 01-2-2c0-.6.4-1.3.8-2l.2-.2.2-.3.2-.3.3-.3z"/></svg>',
    'cell-border-color': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M9 12l5.6-5.5.9.9L14 8.9l3.2 3.2c.4.4.4 1 0 1.3L13.8 17a1 1 0 01-1.3 0L9 13.4a1 1 0 010-1.2V12zm7.1.8l-3-3-3 3h6zm-7.5 1.7l.2-.2.1.2.2.2.1.2.1.1.1.2c.3.4.6 1 .6 1.3 0 .7-.6 1.3-1.2 1.3-.7 0-1.3-.6-1.3-1.3 0-.4.2-.8.5-1.2L8 15l.2-.2v-.2l.3-.2z"/><path opacity=".3" d="M16 2v3h-2V4H4v10h1v2H2V2z"/><path d="M2 10V2h8v6.5H8.5V10H2zm2-2h4V4H4v4z"/></g></svg>',
    'change-case': '<svg width="18" height="18"><path d="M14.8 14.4V14c-.3.6-.9 1-1.7 1-1.6 0-2.4-1.3-2.4-3.9 0-2.5.8-3.8 2.4-3.8.8 0 1.3.3 1.7 1v-.6c0-.4.3-.6.6-.6s.6.3.6.6v6.8c0 .3-.3.6-.6.6a.6.6 0 01-.6-.6zm-1.4-6c-1 0-1.3.7-1.3 2.6 0 2 .3 2.7 1.2 2.7 1 0 1.3-.8 1.3-2.6 0-2-.3-2.7-1.2-2.7zm-5.7 3.5H4l-.6 2a1 1 0 01-1 .8.6.6 0 01-.6-.8L5 3.9a.9.9 0 011.6 0l3.3 10a.6.6 0 01-.6.8 1 1 0 01-1-.7l-.7-2zm-.2-1.2L5.9 5.3l-1.6 5.4h3.2z" fill-rule="evenodd"/></svg>',
    'character-count': '<svg width="18" height="18"><path d="M1 8.8h16v1H1v-1zM5.8 2v5.3H4.7V3h-1V2h2zM8 5.4v.8h2v1.1H7V4.9l2-1V3H7V2h3v2.4l-2 1zM14.3 2v5.3h-3.1v-1h2.1V5.2h-2.1V4.1h2.1V3h-2.1V2h3.1zM2.8 13.7c0-.5.2-.8.5-1 .2-.3.6-.4 1.2-.4.3 0 .6 0 .8.2.2 0 .4.1.5.3.2 0 .3.2.4.4V16l.2.3H5.2V16 16l-.6.3H4c-.4 0-.7 0-1-.3a1 1 0 01-.3-.8c0-.4 0-.7.3-.9l1.2-.4.6-.1h.3v-.3l-.1-.2a.8.8 0 00-.5-.1 1 1 0 00-.4.1l-.3.4h-1zm2.3.8h-.2-.2l-.4.2a1 1 0 00-.4.1l-.2.3.1.3.5.1.4-.1.4-.4v-.5zM7 11h1.2v1.8c.1-.2.3-.3.5-.3h.5c.5 0 .9 0 1.2.4.3.4.5.9.5 1.4 0 .6-.2 1.2-.5 1.6-.3.4-.7.6-1.3.6-.2 0-.4 0-.6-.2l-.4-.4v.4H7.1V11zm1.1 3.3c0 .4 0 .6.2.8a.7.7 0 001.2 0l.2-.8c0-.3 0-.6-.2-.8a.7.7 0 00-.6-.3c-.2 0-.4.2-.6.4l-.2.7zm6.1-.5c0-.1 0-.3-.2-.4a.8.8 0 00-.5-.1c-.3 0-.5 0-.6.3l-.2.8c0 .4 0 .7.2.9.1.2.3.2.6.2l.5-.1.2-.5h1.1c0 .5-.3.9-.6 1.2a2 2 0 01-1.3.4c-.5 0-1-.2-1.3-.6a2 2 0 01-.5-1.4c0-.7.1-1.2.5-1.5.3-.4.8-.6 1.4-.6.5 0 1 .1 1.2.4.4.3.5.6.5 1.1h-1z" fill-rule="evenodd"/></svg>',
    'checklist-rtl': '<svg width="18" height="18"><path fill-rule="nonzero" d="M3 7a1 1 0 110-2h6a1 1 0 110 2H3zm0 6a1 1 0 010-2h6a1 1 0 010 2H3zm12-9c.3-.4.7-.5 1-.3.3.2.3.6.1 1l-2 3.4c-.3.3-.8.4-1 0l-1.4-1.3a.7.7 0 010-1c.2-.2.6-.2.9 0l.8.9L15 3.9zm0 5.3c.3-.3.7-.4 1-.2.3.2.3.6.1 1l-2 3.3c-.3.4-.8.5-1 .1l-1.4-1.4a.7.7 0 010-.9c.2-.3.6-.3.9 0l.8.8L15 9.3z"/></svg>',
    'checklist': '<svg width="18" height="18"><path fill-rule="nonzero" d="M8 7a1 1 0 110-2h6a1 1 0 010 2H8zm0 6a1 1 0 010-2h6a1 1 0 010 2H8zM5.2 4c.2-.4.6-.5.9-.3.3.2.4.6.2 1L4 8c-.2.3-.7.4-1 0L1.8 6.9a.7.7 0 010-1c.3-.2.7-.2 1 0l.7.9 1.7-2.8zm0 5.3c.2-.3.6-.4.9-.2.3.2.4.6.2 1L4 13.3c-.2.4-.7.5-1 .1l-1.3-1.4a.7.7 0 010-.9c.3-.3.7-.3 1 0l.7.8 1.7-2.7z"/></svg>',
    'checkmark': '<svg width="18" height="18"><path fill-rule="nonzero" d="M7.8 13.4l-3-3.1a1 1 0 00-1.5 1.4l4.9 4.9 7.6-12a1 1 0 00-1.6-1.1l-6.4 10z"/></svg>',
    'chevron-down': '<svg width="10" height="10"><path fill-rule="nonzero" d="M5.2 5.8l2.4-2.5a.8.8 0 011 1L5.3 8 1.6 4.4a.8.8 0 011-1l2.6 2.4z"/></svg>',
    'chevron-left': '<svg width="10" height="10"><path fill-rule="nonzero" d="M4.4 5l2.5-2.5a.8.8 0 00-1.1-1L2.3 5l3.5 3.5a.8.8 0 001-1L4.5 5z"/></svg>',
    'chevron-right': '<svg width="10" height="10"><path fill-rule="nonzero" d="M6 5L3.4 2.5a.8.8 0 011-1L8.1 5 4.5 8.5a.8.8 0 01-1-1L5.9 5z"/></svg>',
    'chevron-up': '<svg width="10" height="10"><path fill-rule="nonzero" d="M5.2 4.2l2.4 2.5a.8.8 0 001-1L5.3 2 1.6 5.6a.8.8 0 001 1l2.6-2.4z"/></svg>',
    'close': '<svg width="18" height="18"><path fill-rule="nonzero" d="M10.4 9l4.3 4.3a1 1 0 01-1.4 1.4L9 10.4l-4.3 4.3a1 1 0 11-1.4-1.4L7.6 9 3.3 4.7a1 1 0 011.4-1.4L9 7.6l4.3-4.3a1 1 0 011.4 1.4L10.4 9z"/></svg>',
    'code-sample': '<svg width="18" height="18"><path d="M4.3 7.5a2.8 2.8 0 01-1 2 2.8 2.8 0 011 2v1.7c0 .3 0 .6.3.8.2.3.5.4.9.4.2 0 .4.2.4.4v.8c0 .2-.2.4-.4.4-.8 0-1.5-.3-2-.8-.6-.6-.9-1.3-.9-2v-1.7c0-.3 0-.6-.3-.8-.3-.3-.6-.4-.9-.4A.4.4 0 011 10v-.8c0-.2.2-.4.4-.4.3 0 .6-.1.9-.4.2-.2.3-.5.3-.8V5.8c0-.7.3-1.4.9-2 .5-.5 1.2-.8 2-.8.2 0 .4.2.4.4v.8c0 .2-.2.4-.4.4-.4 0-.7.1-.9.4-.2.2-.3.5-.3.8v1.7zm9.7 0V5.8c0-.3-.1-.6-.4-.8-.2-.3-.5-.4-.8-.4a.4.4 0 01-.4-.4v-.8c0-.2.2-.4.4-.4.8 0 1.4.3 2 .8.5.6.8 1.3.8 2v1.7c0 .3.1.6.4.8.2.3.5.4.8.4.3 0 .4.2.4.4v.8c0 .2-.1.4-.4.4-.3 0-.6.1-.8.4-.3.2-.4.5-.4.8v1.7c0 .7-.3 1.4-.8 2-.6.5-1.2.8-2 .8a.4.4 0 01-.4-.4v-.8c0-.2.2-.4.4-.4.3 0 .6-.1.8-.4.3-.2.4-.5.4-.8v-1.7a2.8 2.8 0 01.9-2 2.8 2.8 0 01-.9-2zM10.7 7c0 .4-.1.8-.4 1.1-.3.3-.7.5-1.2.5-.4 0-.8-.2-1.1-.5-.3-.3-.5-.7-.5-1.1 0-.5.2-.9.5-1.2.3-.3.7-.4 1.1-.4.5 0 .9.1 1.2.4.3.3.4.7.4 1.2zM9.2 9.5c.5 0 .9.1 1.2.5.3.3.4.7.4 1.1 0 1-.1 1.6-.4 2a3 3 0 01-1.2 1c-.4.3-.8.4-1.1.4a.5.5 0 01-.5-.5v-.5a3 3 0 001-.2l.7-.6c-.7 0-1.1-.2-1.3-.5-.3-.3-.4-.7-.4-1 0-.5.2-1 .5-1.2.3-.4.7-.5 1.1-.5z" fill-rule="evenodd"/></svg>',
    'color-levels': '<svg width="18" height="18"><path d="M13.6 8.5a8.2 8.2 0 01.4 2.4l-.1 1.1a4.8 4.8 0 01-1.3 2.3 5.1 5.1 0 01-2.2 1.5 4.6 4.6 0 01-2.8 0 4.8 4.8 0 01-2.2-1.5A5.4 5.4 0 014 12a6 6 0 010-2.3l.3-1.2a12.1 12.1 0 011.9-3.6A17.2 17.2 0 019 2a22.5 22.5 0 012.7 3 16 16 0 012 3.5zM12 12.4c.3-.6.4-1.2.3-1.8a6.7 6.7 0 00-.8-2.7c.2.5.2 1 .2 1.6a4 4 0 01-.5 1.8 4.5 4.5 0 01-2.6 2.2 3.9 3.9 0 01-1.6 0c.3.3.6.4 1 .6l1 .2c.6 0 1.2-.2 1.7-.6.6-.3 1-.8 1.3-1.3z" fill-rule="evenodd"/></svg>',
    'color-swatch': '<svg width="18" height="18"><rect width="14" height="14" x="2" y="2" rx="1" fill-rule="evenodd"/></svg>',
    'comment-add': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M8 14l3-2h3c.6 0 1-.4 1-1V4c0-.6-.4-1-1-1H4a1 1 0 00-1 1v7c0 .6.4 1 1 1h4v2zm-2 4v-4H4a3 3 0 01-3-3V4a3 3 0 013-3h10a3 3 0 013 3v7a3 3 0 01-3 3h-2.4L6 18z"/><path d="M10 7h2a1 1 0 010 2h-2v2a1 1 0 01-2 0V9H6a1 1 0 110-2h2V5a1 1 0 112 0v2z"/></g></svg>',
    'comment': '<svg width="18" height="18"><path fill-rule="nonzero" d="M8 14l3-2h3c.6 0 1-.4 1-1V4c0-.6-.4-1-1-1H4a1 1 0 00-1 1v7c0 .6.4 1 1 1h4v2zm-2 4v-4H4a3 3 0 01-3-3V4a3 3 0 013-3h10a3 3 0 013 3v7a3 3 0 01-3 3h-2.4L6 18z"/></svg>',
    'contrast': '<svg width="18" height="18"><path d="M9 1a7.8 7.8 0 015.7 2.3A8 8 0 119 1zM3 9a6 6 0 006 6V3a6 6 0 00-6 6z" fill-rule="evenodd"/></svg>',
    'copy': '<svg width="18" height="18"><path fill-rule="nonzero" d="M12 1H4a2 2 0 00-2 2v10c0 1.1.9 2 2 2V3h10a2 2 0 00-2-2zm2 3a2 2 0 012 2v9a2 2 0 01-2 2H7a2 2 0 01-2-2V6c0-1.2.9-2 2-2h7zm0 11V6H7v9h7z"/></svg>',
    'crop': '<svg width="18" height="18"><path d="M14 5v7h2c.6 0 1 .4 1 1s-.4 1-1 1h-2v2c0 .6-.4 1-1 1a1 1 0 01-1-1v-2H4V6H2a1 1 0 110-2h2V2c0-.6.4-1 1-1s1 .4 1 1v2h7l3-3 1 1-3 3zM6 6v5l5-5H6zm1 6h5V7l-5 5z" fill-rule="evenodd"/></svg>',
    'cut-column': '<svg width="18" height="18"><path fill-rule="evenodd" d="M3.7 2c.9 0 1.6.4 2.2 1A3.7 3.7 0 017 5.6V6l1 1 4-4 1-.5a3.3 3.3 0 012 0c.4 0 .7.3 1 .5h1v14h-5V7l-2 2 1 1v4l-3-3-1 1v.5c0 .4 0 .8-.3 1.2-.2.5-.4.9-.8 1.2-.6.7-1.3 1-2.2 1-.8.2-1.5 0-2-.6l-.5-.8-.2-1c0-.4 0-.8.3-1.2a3.9 3.9 0 012.2-2.1c.5-.2 1-.3 1.5-.2l1-1-1-1c-.5 0-1 0-1.5-.2S2.5 7.4 2 7c-.4-.3-.6-.7-.8-1.2L1 4.5c0-.4 0-.7.2-1 0-.3.3-.6.5-.8.5-.5 1.2-.8 2-.7zm11.8 2.5h-.9l-1.1 1.1v9.9h2v-11zm-11 6.8h-.3l-.4.2a2.8 2.8 0 00-.7.4v.1a2.8 2.8 0 00-.6.8l-.1.4v.7l.2.5.5.2h.7a2.6 2.6 0 00.8-.3 2.4 2.4 0 00.7-.7 2.5 2.5 0 00.3-.8 1.5 1.5 0 000-.8 1 1 0 00-.2-.4 1 1 0 00-.5-.2h-.4zM8 7.6c-.4 0-.7.1-1 .4-.3.3-.4.6-.4 1s.1.7.4 1c.3.3.6.4 1 .4s.7-.1 1-.4c.3-.3.4-.6.4-1s-.1-.7-.4-1c-.3-.3-.6-.4-1-.4zM3.5 3.3H3a1 1 0 00-.5.3 1 1 0 00-.2.5v.7a2.5 2.5 0 00.3.8L3 6H3l.4.4.4.2.4.1h.7l.5-.2.2-.4a1.6 1.6 0 000-.8 2.6 2.6 0 00-.3-.8 2.5 2.5 0 00-1.1-.9l-.4-.1h-.3z"/></svg>',
    'cut-row': '<svg width="18" height="18"><path fill-rule="evenodd" d="M17 1v5H7l2 2 1-1h4l-3 3 1 1h.5c.4 0 .8 0 1.2.3.5.2.9.4 1.2.8.7.6 1 1.3 1 2.2.2.8 0 1.5-.6 2l-.8.5-1 .2c-.4 0-.8 0-1.2-.3a3.9 3.9 0 01-2.1-2.2c-.2-.5-.3-1-.2-1.5l-1-1-1 1c0 .5 0 1-.2 1.5s-.4 1-.9 1.4c-.3.4-.7.6-1.2.8l-1.2.3c-.4 0-.7 0-1-.2-.3 0-.6-.3-.8-.5-.5-.5-.8-1.2-.7-2 0-.9.4-1.6 1-2.2A3.7 3.7 0 015.6 11H6l1-1-4-4-.5-1a3.3 3.3 0 010-2c0-.4.3-.7.5-1V1h14zM5.5 12.3h-.3a2.6 2.6 0 00-.8.4 2.5 2.5 0 00-.9 1.1l-.1.4v.7l.2.5.5.2h.7a2.5 2.5 0 00.8-.3L6 15V15l.4-.4.2-.4.1-.4v-.3-.4a1 1 0 00-.2-.5 1 1 0 00-.4-.2h-.5zm7 0H12a1 1 0 00-.4.3 1 1 0 00-.2.5 1.5 1.5 0 000 .7v.4a2.8 2.8 0 00.5.7h.1a2.8 2.8 0 00.8.6l.4.1h.7l.5-.2.2-.5v-.4-.3a2.6 2.6 0 00-.3-.8 2.4 2.4 0 00-.7-.7 2.5 2.5 0 00-.8-.3h-.3zM9 8.6c-.4 0-.7.1-1 .4-.3.3-.4.6-.4 1s.1.7.4 1c.3.3.6.4 1 .4s.7-.1 1-.4c.3-.3.4-.6.4-1s-.1-.7-.4-1c-.3-.3-.6-.4-1-.4zm6.5-6.1h-11v.9l1.1 1.1h9.9v-2z"/></svg>',
    'cut': '<svg width="18" height="18"><path d="M15 12c.6.7 1 1.4 1 2.3 0 .8-.2 1.5-.7 2l-.8.5-1 .2c-.4 0-.8 0-1.2-.3a3.9 3.9 0 01-2.1-2.2c-.2-.5-.3-1-.2-1.5l-1-1-1 1c0 .5 0 1-.2 1.5s-.4 1-.9 1.4c-.3.4-.7.6-1.2.8l-1.2.3c-.4 0-.7 0-1-.2-.3 0-.6-.3-.8-.5-.5-.5-.8-1.2-.7-2 0-.9.4-1.6 1-2.2A3.7 3.7 0 015.6 11H6l1-1-4-4-.5-1a3.3 3.3 0 010-2c0-.4.3-.7.5-1l6 6 6-6 .5 1a3.3 3.3 0 010 2c0 .4-.3.7-.5 1l-4 4 1 1h.5c.4 0 .8 0 1.2.3.5.2.9.4 1.2.8zm-8.5 2.2l.1-.4v-.3-.4a1 1 0 00-.2-.5 1 1 0 00-.4-.2 1.6 1.6 0 00-.8 0 2.6 2.6 0 00-.8.3 2.5 2.5 0 00-.9 1.1l-.1.4v.7l.2.5.5.2h.7a2.5 2.5 0 00.8-.3 2.8 2.8 0 001-1zM9 11.4c.4 0 .7-.1 1-.4.3-.3.4-.6.4-1s-.1-.7-.4-1c-.3-.3-.6-.4-1-.4s-.7.1-1 .4c-.3.3-.4.6-.4 1s.1.7.4 1c.3.3.6.4 1 .4zm5.4 4l.2-.5v-.4-.3a2.6 2.6 0 00-.3-.8 2.4 2.4 0 00-.7-.7 2.5 2.5 0 00-.8-.3 1.5 1.5 0 00-.8 0 1 1 0 00-.4.2 1 1 0 00-.2.5 1.5 1.5 0 000 .7v.4l.3.4.3.4a2.8 2.8 0 00.8.5l.4.1h.7l.5-.2z" fill-rule="evenodd"/></svg>',
    'document-properties': '<svg width="18" height="18"><path fill-rule="nonzero" d="M10.4 1H5a2 2 0 00-2 2v12c0 1.1.9 2 2 2h8a2 2 0 002-2V5.6L10.4 1zM13 15H5V3h4v4h4v8z"/></svg>',
    'drag': '<svg width="18" height="18"><path d="M10 2h2v2h-2V2zm0 4h2v2h-2V6zM6 6h2v2H6V6zm4 4h2v2h-2v-2zm-4 0h2v2H6v-2zm0 4h2v2H6v-2zm4 0h2v2h-2v-2zM6 2h2v2H6V2z" fill-rule="evenodd"/></svg>',
    'duplicate-column': '<svg width="18" height="18"><path d="M14 4v13H7V4h7zm-2 2H9v9h3V6zm-1-5v2H6v11H4V1h7z"/></svg>',
    'duplicate-row': '<svg width="18" height="18"><path fill-rule="evenodd" d="M17 7v7H4V7h13zm-2 2H6v3h9V9zm-1-5v2H3v5H1V4h13z"/></svg>',
    'duplicate': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M12 1a2 2 0 012 2H4v12a2 2 0 01-2-2V3c0-1.1.9-2 2-2h8zm4 6h-2V6H7v9h9a2 2 0 01-2 2H7a2 2 0 01-2-2V6c0-1.2.9-2 2-2h7a2 2 0 012 2v1z"/><path d="M14 10h1a1 1 0 010 2h-1v1a1 1 0 01-2 0v-1h-1a1 1 0 010-2h1V9a1 1 0 012 0v1z"/></g></svg>',
    'edit-block': '<svg width="18" height="18"><path fill-rule="nonzero" d="M16 6.8l-7.4 7.4c-.3.3-.6.4-.9.5l-5.4 1.2 1.2-5.4c0-.3.2-.6.5-.9l7.4-7.4c.6-.6 1.8-.6 2.4 0L16 4.4c.6.6.6 1.7 0 2.4zm-1.1-1c.1-.1.1-.3 0-.4l-2.1-2.1a.2.2 0 00-.4 0l-.9.9L14 6.7l.9-1zm-4.4-.6l-4 4 2.4 2.5 4-4-2.4-2.5zm-5 5.1l-.5.4v.1L4.3 14l3-.7h.2l.4-.4-2.5-2.5z"/></svg>',
    'edit-image': '<svg width="18" height="18"><path fill-rule="nonzero" d="M14 12h2V5a2 2 0 00-2-2H5v2h9v7zM4 13h13a1 1 0 010 2h-1v1a1 1 0 01-2 0v-1H4a2 2 0 01-2-2V5H1a1 1 0 110-2h1V2a1 1 0 112 0v11zm2.7-4.3l1 2L10 6l3 6H5l1.7-3.3z"/></svg>',
    'embed-page': '<svg width="18" height="18"><path fill-rule="nonzero" d="M15 4V3H3v12h3.2A9 9 0 0115 4zm0 1c-.6 0-1.4 2-1.8 5H15V5zm-2 6a24.6 24.6 0 000 4h2v-4h-2zm-1 2v-2h-1.8a12.4 12.4 0 000 4H12l-.1-2zm-3 0l.1-2H7.3a8 8 0 000 4H9L9 13zM3 1h12a2 2 0 012 2v12a2 2 0 01-2 2H3a2 2 0 01-2-2V3c0-1.1.9-2 2-2zm6.3 9c.4-1.6 1.1-3 2-4.1A8 8 0 007.6 10h1.7zm4-4.5c-1.3.7-2.4 2.4-3 4.5h1.9a14 14 0 011.2-4.5z"/></svg>',
    'embed': '<svg width="18" height="18"><path fill-rule="nonzero" d="M3 1h12a2 2 0 012 2v12a2 2 0 01-2 2H3a2 2 0 01-2-2V3c0-1.1.9-2 2-2zm0 2v12h12V3H3zm9 6l-5 4V5l5 4z"/></svg>',
    'emoji': '<svg width="18" height="18"><path fill-rule="nonzero" d="M6 8c.5 0 1-.5 1-1s-.5-1-1-1a1 1 0 00-1 1c0 .5.5 1 1 1zm6 0c.6 0 1-.5 1-1s-.4-1-1-1a1 1 0 00-1 1c0 .5.4 1 1 1zm-3 5.5c2.1 0 4-1.5 4.4-3.5H4.6c.5 2 2.3 3.5 4.4 3.5zM9 1a8 8 0 100 16A8 8 0 009 1zm0 14.5a6.5 6.5 0 110-13 6.5 6.5 0 010 13z"/></svg>',
    'export': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M12 17H5c-1 0-2-.8-2-1.9V3c0-1 .8-2 1.9-2h5.5l4 4H9V3H5v12h7a1 1 0 010 2z"/><path d="M13.8 6.4l2.4 3.6-2.4 3.6a1 1 0 01-1.7-1v-.2l1-1.4H8a1 1 0 01-.1-2H13l-1-1.4a1 1 0 01.3-1.4 1 1 0 011.4.2z"/></g></svg>',
    'fill': '<svg width="18" height="18"><path fill-rule="nonzero" d="M14.6 9l-9-9-1.4 1.4 2.4 2.4-5.2 5.1c-.5.6-.5 1.6 0 2.2L7 16.6a1.5 1.5 0 002.2 0l5.5-5.5c.6-.6.6-1.6 0-2.2zM3.2 10L8 5.2l4.8 4.8H3.2zM15 12.5s-2 2.2-2 3.5c0 1.1.9 2 2 2a2 2 0 002-2c0-1.3-2-3.5-2-3.5z"/></svg>',
    'flip-horizontally': '<svg width="18" height="18"><path fill-rule="nonzero" d="M11 16h2v-2h-2v2zm4-8h2V6h-2v2zM1 4v10c0 1.1.9 2 2 2h3v-2H3V4h3V2H3a2 2 0 00-2 2zm14-2v2h2a2 2 0 00-2-2zM8 18h2V0H8v18zm7-6h2v-2h-2v2zm-4-8h2V2h-2v2zm4 12a2 2 0 002-2h-2v2z"/></svg>',
    'flip-vertically': '<svg width="18" height="18"><path fill-rule="nonzero" d="M2 11v2h2v-2H2zm8 4v2h2v-2h-2zm4-14H4a2 2 0 00-2 2v3h2V3h10v3h2V3a2 2 0 00-2-2zm2 14h-2v2a2 2 0 002-2zM0 8v2h18V8H0zm6 7v2h2v-2H6zm8-4v2h2v-2h-2zM2 15c0 1.1.9 2 2 2v-2H2z"/></svg>',
    'format-painter': '<svg width="18" height="18"><path fill-rule="nonzero" d="M13 4V3c0-.5-.4-1-1-1H3a1 1 0 00-1 1v4c0 .5.5 1 1 1h9c.6 0 1-.5 1-1V6h1v4H7v6c0 .6.5 1 1 1h2c.6 0 1-.4 1-1v-4h5V4h-3z"/></svg>',
    'format': '<svg width="18" height="18"><path fill-rule="evenodd" d="M13 3a1 1 0 010 2h-3v9a1 1 0 01-2 0V5H5a1 1 0 110-2h8z"/></svg>',
    'fullscreen': '<svg width="18" height="18"><path fill-rule="nonzero" d="M12.3 7l-1.2-1.3 2.9-3h-2.3a.9.9 0 110-1.7H16c.5 0 .9.4.9.9v4.4a.9.9 0 11-1.8 0V4l-2.9 3zm0 4l3 3v-2.3a.9.9 0 111.7 0V16c0 .5-.4.9-.9.9h-4.4a.9.9 0 110-1.8H14l-3-2.9 1.3-1.2zM7 12.4l-2.9 3h2.3a.9.9 0 110 1.7H2a.9.9 0 01-.9-.9v-4.4a.9.9 0 111.8 0V14l2.9-3 1.2 1.3zM5.7 7L2.7 4v2.3a.9.9 0 11-1.7 0V2c0-.5.4-.9.9-.9h4.4a.9.9 0 110 1.8H4l3 2.9-1.3 1.2z"/></svg>',
    'gallery': '<svg width="18" height="18"><g fill-rule="nonzero"><rect width="14" height="1" x="2" y="3" rx=".5"/><rect width="10" height="1" x="4" y="1" rx=".5"/><path d="M3 13l4-4 2.5 2.4 3-3L15 11V7H3v6zm0 2h3l2.4-2.5L7 11.1 3 15zm12-2l-2.5-2.4L8.1 15H15v-2zM3 5h12a2 2 0 012 2v8a2 2 0 01-2 2H3a2 2 0 01-2-2V7c0-1.1.9-2 2-2z"/></g></svg>',
    'gamma': '<svg width="18" height="18"><path fill-rule="nonzero" d="M1.9 1H16c.5 0 .9.4.9.9V16c0 .5-.4.9-.9.9H2a.9.9 0 01-.9-.9V2c0-.5.4-.9.9-.9zM3 3v12h12V3H3zm5.5 10.8V11L6.2 5.7a5.1 5.1 0 00-.4-.8l-.1-.2H5 5v-1l.3-.1.3-.1h.7a1 1 0 01.6.5l.1.3a8.5 8.5 0 01.3.6l1.9 4.6 2-5.2a1 1 0 011-.6.5.5 0 01.5.6L10 11v2.8a.7.7 0 01-1.4 0z"/></svg>',
    'help': '<svg width="18" height="18"><g fill-rule="evenodd"><path d="M9 2.5a6.5 6.5 0 00-6 9 6.3 6.3 0 001.4 2l1 1a6.3 6.3 0 003.6 1 6.5 6.5 0 006-9 6.3 6.3 0 00-1.4-2l-1-1a6.3 6.3 0 00-3.6-1zM9 1a7.8 7.8 0 015.7 2.3A8 8 0 119 1z"/><path fill-rule="nonzero" d="M6.6 6.7a.7.7 0 01-.7-.8c0-1.1 1.5-1.8 3.2-1.8 1.8 0 3.2.8 3.2 2.4 0 1.4-.4 2.1-1.5 2.8-.2 0-.3.1-.3.2a2 2 0 00-.8.8.8.8 0 11-1.4-.6c.3-.7.8-1 1.3-1.5L10 8c.7-.4.8-.6.8-1.5 0-.5-.6-.9-1.7-.9-.5 0-1 .1-1.4.3-.2 0-.3.1-.3.2v-.2c0 .4-.4.8-.8.8z"/><circle cx="9" cy="13" r="1"/></g></svg>',
    'highlight-bg-color': '<svg width="18" height="18"><g fill-rule="evenodd"><path id="tox-icon-highlight-bg-color__color" d="M1 14h16v3H1z"/><path fill-rule="nonzero" d="M5.7 12.7H3l2.3-2.3-.7-.8L8.2 6l3 3.1-3 3.2c-.2.2-.6.2-.8 0l-.6-.7-1.1 1.1zM9 5.4l3-2.9a2 2 0 012.6 0l.4.5c.7.7.7 2 0 2.7l-2.9 2.9L9 5.4z"/></g></svg>',
    'home': '<svg width="18" height="18"><path fill-rule="nonzero" d="M7 17v-6h4v6h3V9h3L9 1 1 9h3v8z"/></svg>',
    'horizontal-rule': '<svg width="18" height="18"><path d="M1 8h16v2H1z" fill-rule="evenodd"/></svg>',
    'image-options': '<svg width="18" height="18"><path fill-rule="nonzero" d="M3 7a2 2 0 00-2 2c0 1.1.9 2 2 2a2 2 0 002-2 2 2 0 00-2-2zm12 0a2 2 0 00-2 2c0 1.1.9 2 2 2a2 2 0 002-2 2 2 0 00-2-2zM9 7a2 2 0 00-2 2c0 1.1.9 2 2 2a2 2 0 002-2 2 2 0 00-2-2z"/></svg>',
    'image': '<svg width="18" height="18"><path fill-rule="nonzero" d="M6 15l2.4-2.5L7 11.1 3 15h3zm2 0h7v-2l-2.5-2.4L8.1 15zm7-4V3H3v10l4-4 2.5 2.4 3-3L15 11zM3 1h12a2 2 0 012 2v12a2 2 0 01-2 2H3a2 2 0 01-2-2V3c0-1.1.9-2 2-2zm6 5a2 2 0 11-4 0 2 2 0 014 0z"/></svg>',
    'indent': '<svg width="18" height="18"><path fill-rule="nonzero" d="M11 3a1 1 0 012 0v12a1 1 0 01-2 0V3zM7.6 9L4.3 5.7a1 1 0 011.4-1.4L10.4 9l-4.7 4.7a1 1 0 11-1.4-1.4L7.6 9z"/></svg>',
    'info': '<svg width="18" height="18"><path d="M9 1a7.8 7.8 0 015.7 2.3A8 8 0 119 1zM8 4v2h2V4H8zm3 10v-1h-1V8H7v1h1v4H7v1h4z" fill-rule="evenodd"/></svg>',
    'insert-character': '<svg width="18" height="18"><path d="M12 15h4l1-2v4h-6v-3.3l1.4-1a6 6 0 001.8-2.9 6.3 6.3 0 00-.1-4.1 5.8 5.8 0 00-3-3.2C10.5 2.2 9.8 2 9 2a5.1 5.1 0 00-3.9 1.8 6.3 6.3 0 00-1.3 6 6.2 6.2 0 001.8 3l1.4.9V17H1v-4l1 2h4v-.5l-2-1L2.4 12A6.5 6.5 0 011 8c0-1 .2-1.9.6-2.7A7 7 0 013.3 3C4.1 2.4 5 2 6 1.5c1-.3 2-.5 3.1-.5a8.8 8.8 0 015.7 2 7 7 0 011.7 2.3 6 6 0 01.2 4.8c-.2.7-.6 1.3-1 1.9a7.6 7.6 0 01-3.6 2.5v.5z" fill-rule="evenodd"/></svg>',
    'insert-time': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M9 15A6 6 0 109 3a6 6 0 000 12zm0 2A8 8 0 119 1a8 8 0 010 16z"/><path d="M12 9h-2V5c0-.6-.4-1-1-1a1 1 0 00-1 1v6h4c.6 0 1-.4 1-1s-.4-1-1-1z"/></g></svg>',
    'invert': '<svg width="18" height="18"><path d="M15 16.3L13.5 15a5.8 5.8 0 01-3.1 1.9 6.1 6.1 0 01-5.5-1.6A5.8 5.8 0 013 11v-.3l.1-1.2A13.9 13.9 0 014.7 6l-3-3 .7-.8 2.9 2.9 8.9 8.9 1.5 1.6-.7.6zm0-5.5v.3l-.1 1.1-.4 1-1.2-1.2a4.3 4.3 0 00.2-1v-.2c0-.4 0-.8-.2-1.3l-.5-1.4a14.8 14.8 0 00-3-4.2L9 3a26.1 26.1 0 00-2.2 2.5l-1-1a20.9 20.9 0 012.9-3.3L9 1l1 .8a22.2 22.2 0 014 5.4c.6 1.2 1 2.4 1 3.6z" fill-rule="evenodd"/></svg>',
    'italic': '<svg width="18" height="18"><path d="M12.4 3l-.1.7H12c-.6 0-1 .1-1.2.3-.2.2-.4.5-.5 1l-1.7 8.2v.4c0 .5.3.7 1.1.7h.2l-.1.7H5l.1-.7h.3c.9 0 1.4-.4 1.6-1.2l1.8-8.3v-.4c0-.5-.4-.7-1.2-.7h-.2l.1-.7h5z" fill-rule="evenodd"/></svg>',
    'language': '<svg width="18" height="18"><path d="M9 0a9 9 0 110 18A9 9 0 019 0zm4.2 13.3c-.5 1-1.2 2-2.1 2.9a7.5 7.5 0 003.4-2.1l-.2-.2a6 6 0 00-1-.6zm-8.5 0c-.5.2-.9.5-1.2.8.9 1 2 1.7 3.2 2a10 10 0 01-2-2.8zm3.6-.8c-.8 0-1.6.1-2.2.3.5 1 1.2 1.9 2.1 2.7zm1.5 0v3c.9-.9 1.5-1.8 2-2.7-.6-.2-1.3-.3-2-.3zm-6-2.7H1.5c.2 1 .5 2.1 1 3h.3l1.3-1a10 10 0 01-.3-2zm12.7 0H14c0 .7-.1 1.4-.3 2l1.7 1.1c.5-1 .9-2 1-3.1zm-8.3 0h-3l.4 1.6c.8-.3 1.7-.4 2.7-.4V9.7zm4.4 0H9.8V11c.9 0 1.8.1 2.6.3l.2-1.5zm-9.8-5C2 5.8 1.7 7 1.5 8.3h2.3c0-1 .2-1.8.5-2.6l-1.5-1zm2.9 1.4v.1c-.2.6-.4 1.3-.4 2h3V6.5c-1 0-1.8-.1-2.6-.3zm6.5 0l-2.4.3v1.8h2.8c0-.8-.2-1.5-.4-2.1zm3-1.4l-.2.1-1.4.8c.3.8.5 1.7.5 2.6h2.4a7.5 7.5 0 00-1.3-3.5zm-8.8 0l1.9.2V2.5a9 9 0 00-2 2.2zm3.4-2.2V5c.6 0 1.2 0 1.8-.2-.5-.8-1-1.5-1.8-2.2zm1.3-.8l.1.1A10 10 0 0113 4.3c.5-.2.9-.4 1.2-.7A7.5 7.5 0 0011.3 2l-.2-.1zm-4.3 0h-.1c-1.1.4-2.1 1-3 1.8l1.2.7a10 10 0 011.9-2.5z"/></svg>',
    'line-height': '<svg width="18" height="18"><path d="M16 4a1 1 0 01.1 2H10a1 1 0 01-.1-2H16zm0 4a1 1 0 01.1 2H10a1 1 0 01-.1-2H16zm0 4a1 1 0 01.1 2H10a1 1 0 01-.1-2H16zM5 2l1 .9 2 2a.8.8 0 01-1 1.2L6 5v7.8l1-1c.2-.2.7-.2 1 0 .3.3.3.8.1 1v.1L5 16l-3-3A.8.8 0 013 12l1 1V5.1L3 6c-.2.2-.7.2-1 0a.8.8 0 01-.1-1V5L4 3v-.1l1-1z"/></svg>',
    'line': '<svg width="18" height="18"><path d="M12 6l-8 8H1v-3l8-8 3 3zm1-1l-3-3 1-1h1c-.2 0 0 0 0 0l2 2s0 .2 0 0v1l-1 1zM1 15h16v2H1v-2z" fill-rule="evenodd"/></svg>',
    'link': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M8 8h1a2 2 0 110 4H5a2 2 0 01-.7-3.9l.5-.2-.6-1.8-.5.1A4 4 0 005 14h4a4 4 0 100-8H8v2z"/><path d="M10 9H9a2 2 0 110-4h4a2 2 0 01.7 3.9l-.5.2.6 1.8.5-.1A4 4 0 0013 3H9a4 4 0 100 8h1V9z"/></g></svg>',
    'lock': '<svg width="18" height="18"><path d="M13.3 7c.2 0 .3 0 .5.2l.2.5v7.5c0 .3 0 .4-.2.6l-.6.2H4.8c-.3 0-.4 0-.6-.2a.7.7 0 01-.2-.6V7.8c0-.3 0-.4.2-.6l.5-.2H5V4c0-.8.3-1.5.9-2.1C6.5 1.3 7.2 1 8 1h2c.8 0 1.5.3 2.1.9.6.6.9 1.3.9 2.1v3h.3zM7 4v3h4V4a1 1 0 00-.3-.7A1 1 0 0010 3H8a1 1 0 00-.7.3A1 1 0 007 4z" fill-rule="evenodd"/></svg>',
    'ltr': '<svg width="18" height="18"><path d="M9 3h6a1 1 0 010 2h-1v9a1 1 0 01-2 0V5h-1v9a1 1 0 01-2 0v-4c-.5 0-1 0-1.4-.3A3.4 3.4 0 015.8 8a3.3 3.3 0 010-2.8 3.4 3.4 0 011.8-1.8L9 3zM2.4 14.2L4.2 13l-1.8-1.2a1 1 0 011.2-1.6l3 2a1 1 0 010 1.6l-3 2a1 1 0 11-1.2-1.6z" fill-rule="evenodd"/></svg>',
    'more-drawer': '<svg width="18" height="18"><path fill-rule="nonzero" d="M3 7a2 2 0 00-2 2c0 1.1.9 2 2 2a2 2 0 002-2 2 2 0 00-2-2zm12 0a2 2 0 00-2 2c0 1.1.9 2 2 2a2 2 0 002-2 2 2 0 00-2-2zM9 7a2 2 0 00-2 2c0 1.1.9 2 2 2a2 2 0 002-2 2 2 0 00-2-2z"/></svg>',
    'new-document': '<svg width="18" height="18"><path fill-rule="nonzero" d="M10.4 1H5a2 2 0 00-2 2v12c0 1.1.9 2 2 2h8a2 2 0 002-2V5.6L10.4 1zM13 15H5V3h4v4h4v8z"/></svg>',
    'new-tab': '<svg width="18" height="18"><path d="M12 10l2-2v8H2V4h8L8 6H4v8h8v-4zm4-8v5.5l-2-2L8.4 11H7V9.6L12.5 4l-2-2H16z" fill-rule="evenodd"/></svg>',
    'non-breaking': '<svg width="18" height="18"><path d="M8 8H5a1 1 0 110-2h3V3c0-.6.4-1 1-1s1 .4 1 1v3h3c.6 0 1 .4 1 1s-.4 1-1 1h-3v3c0 .6-.4 1-1 1a1 1 0 01-1-1V8zm8 3v5H2v-5c0-.6.4-1 1-1s1 .4 1 1v3h10v-3c0-.6.4-1 1-1s1 .4 1 1z" fill-rule="evenodd"/></svg>',
    'notice': '<svg width="18" height="18"><path d="M17 5.5v7L12.5 17h-7L1 12.5v-7L5.5 1h7L17 5.5zM10 14v-2H8v2h2zm0-4V4H8v6h2z" fill-rule="evenodd"/></svg>',
    'ordered-list-rtl': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M4 7h6a1 1 0 000-2H4a1 1 0 100 2zM4 13h6a1 1 0 000-2H4a1 1 0 000 2z"/><path d="M15 4v3.5a.5.5 0 11-1 0V5h-.5a.5.5 0 110-1H15zm-1 8.8l.2.2h1.3a.5.5 0 110 1h-1.6a1 1 0 01-.9-1V13c0-.4.3-.8.6-1l1.2-.4.2-.3a.2.2 0 00-.2-.2h-1.3a.5.5 0 01-.5-.5c0-.3.2-.5.5-.5h1.6c.5 0 .9.4.9 1v.1c0 .4-.3.8-.6 1l-1.2.4-.2.3z"/></g></svg>',
    'ordered-list': '<svg width="18" height="18"><path fill-rule="nonzero" d="M8 7a1 1 0 110-2h6a1 1 0 010 2H8zm0 6a1 1 0 010-2h6a1 1 0 010 2H8zM4 4v3.5a.5.5 0 01-1 0V5h-.5a.5.5 0 010-1H4zm-1 8.8l.2.2h1.3a.5.5 0 110 1H2.9a1 1 0 01-.9-1V13c0-.4.3-.8.6-1l1.2-.4.2-.3a.2.2 0 00-.2-.2H2.5a.5.5 0 01-.5-.5c0-.3.2-.5.5-.5h1.6c.5 0 .9.4.9 1v.1c0 .4-.3.8-.6 1l-1.2.4-.2.3z"/></svg>',
    'orientation': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M2 7h14v10H2V7zm2 2v6h10V9H4z"/><path d="M2 4h2v2H2V4zm0-3h2v2H2V1zm3 0h2v2H5V1zm3 0h2v2H8V1zm3 0h2v2h-2V1zm0 3h2v2h-2V4z"/></g></svg>',
    'outdent': '<svg width="18" height="18"><path fill-rule="nonzero" d="M11 3a1 1 0 012 0v12a1 1 0 01-2 0V3zM5.8 9l3.3 3.3a1 1 0 01-1.4 1.4L3 9l4.7-4.7a1 1 0 011.4 1.4L5.8 9z"/></svg>',
    'page-break': '<svg width="18" height="18"><g fill-rule="evenodd"><path d="M2 8c.6 0 1 .4 1 1s-.4 1-1 1a1 1 0 110-2zm3 0h1c.6 0 1 .4 1 1s-.4 1-1 1H5a1 1 0 110-2zm4 0c.6 0 1 .4 1 1s-.4 1-1 1a1 1 0 110-2zm3 0h1c.6 0 1 .4 1 1s-.4 1-1 1h-1a1 1 0 010-2zm4 0c.6 0 1 .4 1 1s-.4 1-1 1a1 1 0 010-2zM4 3v2h10V3c0-.6.4-1 1-1s1 .4 1 1v4H2V3c0-.6.4-1 1-1s1 .4 1 1zM3 16a1 1 0 01-1-1v-4h14v4c0 .6-.4 1-1 1a1 1 0 01-1-1v-2H4v2c0 .6-.4 1-1 1z"/></g></svg>',
    'paragraph': '<svg width="18" height="18"><path fill-rule="evenodd" d="M13 3a1 1 0 010 2h-1v9a1 1 0 01-2 0V5H9v9a1 1 0 01-2 0v-4c-.5 0-1 0-1.4-.3A3.4 3.4 0 013.8 8a3.3 3.3 0 010-2.8 3.4 3.4 0 011.8-1.8L7 3h6zM7 4.5a2 2 0 100 4v-4z"/></svg>',
    'paste-column-after': '<svg width="18" height="18"><path d="M9 1a3 3 0 012.8 2H14a2 2 0 012 2v2h-2V5h-1v1c0 .6-.4 1-1 1H6a1 1 0 01-1-1V5H4v10h6v2H4a2 2 0 01-2-2V5c0-1.1.9-2 2-2h2.2A3 3 0 019 1zm7 7v9h-5V8h5zm-1.5 1.5h-2v6h2v-6zM9 3a1 1 0 00-1 1c0 .5.4 1 1 1s1-.5 1-1-.4-1-1-1z"/></svg>',
    'paste-column-before': '<svg width="18" height="18"><path d="M9 1a3 3 0 012.8 2H14a2 2 0 012 2v10a2 2 0 01-2 2H8v-2h6V5h-1v1c0 .6-.4 1-1 1H6a1 1 0 01-1-1V5H4v2H2V5c0-1.1.9-2 2-2h2.2A3 3 0 019 1zM7 8v9H2V8h5zM5.5 9.5h-2v6h2v-6zM9 3a1 1 0 00-1 1c0 .5.4 1 1 1s1-.5 1-1-.4-1-1-1z"/></svg>',
    'paste-row-after': '<svg width="18" height="18"><path d="M9 1a3 3 0 012.8 2H14a2 2 0 012 2v6h-2V5h-1v1c0 .6-.4 1-1 1H6a1 1 0 01-1-1V5H4v12a2 2 0 01-2-2V5c0-1.1.9-2 2-2h2.2A3 3 0 019 1zm8 11v5H5v-5h12zm-1.5 1.5h-9v2h9v-2zM9 3a1 1 0 00-1 1c0 .5.4 1 1 1s1-.5 1-1-.4-1-1-1z"/></svg>',
    'paste-row-before': '<svg width="18" height="18"><path d="M9 1a3 3 0 012.8 2H14a2 2 0 012 2v2h-2V5h-1v1c0 .6-.4 1-1 1H6a1 1 0 01-1-1V5H4v10h10v-1h2v1a2 2 0 01-2 2H4a2 2 0 01-2-2V5c0-1.1.9-2 2-2h2.2A3 3 0 019 1zm8 7v5H5V8h12zm-1.5 1.5h-9v2h9v-2zM9 3a1 1 0 00-1 1c0 .5.4 1 1 1s1-.5 1-1-.4-1-1-1z"/></svg>',
    'paste-text': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M14 15V5h-1v1c0 .6-.4 1-1 1H6a1 1 0 01-1-1V5H4v10h10zM4 17a2 2 0 01-2-2V5c0-1.1.9-2 2-2h2.2A3 3 0 019 1a3 3 0 012.8 2H14a2 2 0 012 2v10a2 2 0 01-2 2H4zM9 3a1 1 0 00-1 1c0 .5.4 1 1 1s1-.5 1-1-.4-1-1-1z"/><path d="M6 8h6v2h-.5L11 9h-1v4h.8v1H7.2v-1H8V9H7l-.5 1H6z"/></g></svg>',
    'paste': '<svg width="18" height="18"><path fill-rule="nonzero" d="M14 15V5h-1v1c0 .6-.4 1-1 1H6a1 1 0 01-1-1V5H4v10h10zM4 17a2 2 0 01-2-2V5c0-1.1.9-2 2-2h2.2A3 3 0 019 1a3 3 0 012.8 2H14a2 2 0 012 2v10a2 2 0 01-2 2H4zM9 3a1 1 0 00-1 1c0 .5.4 1 1 1s1-.5 1-1-.4-1-1-1z"/></svg>',
    'permanent-pen': '<svg width="18" height="18"><path d="M8.5 14.5L6 17H2v-3l3-3c-.5-.7-.4-1.6.2-2.2l7.3-7.3a.8.8 0 011 1L6.2 9.8v.4l3.6 3.6h.4l5.3-5.3a.8.8 0 011 1l-5.3 5.3c-.6.7-1.8.7-2.4 0l-.3-.3z" fill-rule="evenodd"/></svg>',
    'plus': '<svg width="18" height="18"><path fill-rule="nonzero" d="M10 8h5a1 1 0 010 2h-5v5a1 1 0 01-2 0v-5H3a1 1 0 110-2h5V3a1 1 0 112 0v5z"/></svg>',
    'preferences': '<svg width="18" height="18"><path d="M15.1 10.2l-1.3.1a4.5 4.5 0 01-.5 1.2l.9 1c.3.4.3 1 0 1.4l-.3.2a1 1 0 01-1.4.1l-1-.9a4.8 4.8 0 01-1.2.5l-.1 1.3c0 .5-.5.9-1 .9h-.4a1 1 0 01-1-.9l-.1-1.3a4.5 4.5 0 01-1.2-.5l-1 .9a1 1 0 01-1.4 0l-.2-.3a1 1 0 01-.1-1.4l.9-1a4.8 4.8 0 01-.5-1.2l-1.3-.1a1 1 0 01-.9-1v-.4c0-.5.4-1 .9-1l1.3-.1a4.5 4.5 0 01.5-1.2l-.9-1a1 1 0 010-1.4l.3-.2a1 1 0 011.4-.1l1 .9a4.8 4.8 0 011.2-.5l.1-1.3c0-.5.5-.9 1-.9h.4c.5 0 1 .4 1 .9l.1 1.3a4.5 4.5 0 011.2.5l1-.9a1 1 0 011.4 0l.2.3c.4.4.4 1 .1 1.4l-.9 1a4.8 4.8 0 01.5 1.2l1.3.1c.5 0 .9.5.9 1v.4c0 .5-.4 1-.9 1zM9 11a2 2 0 100-4 2 2 0 000 4z" fill-rule="evenodd"/></svg>',
    'preview': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M1.3 9.5c.5.8 1 1.6 1.7 2.3 1.7 2 3.8 3.2 6 3.2s4.3-1.2 6-3.2A16 16 0 0017 9a16 16 0 00-2-2.8C13.3 4.2 11.2 3 9 3S4.7 4.2 3 6.2A16 16 0 001 9m3.5-1.5C6 5.8 7.5 5 9 5s3 .8 4.5 2.5L14.7 9l-1.2 1.5C12 12.2 10.5 13 9 13s-3-.8-4.5-2.5L3.3 9"/><path d="M9.9 6.1a1.5 1.5 0 102 2 3 3 0 11-2-2z"/></g></svg>',
    'print': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M14 5a3 3 0 013 3v5h-2v3H3v-3H1V8a3 3 0 013-3h10zm0 9v-4H4v4h10zm-.5-5c.8 0 1.5-.7 1.5-1.5S14.3 6 13.5 6 12 6.7 12 7.5 12.7 9 13.5 9zM14 2H4v2h10z"/></g></svg>',
    'quote': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4.5 14h.9c.4 0 .7-.2.9-.6L8 10V5c0-.6-.4-1-1-1H3a1 1 0 00-1 1v4c0 .6.4 1 1 1h2l-1.3 2.7a1 1 0 00.8 1.3zm8 0h.9c.4 0 .7-.2.9-.6L16 10V5c0-.6-.4-1-1-1h-4a1 1 0 00-1 1v4c0 .6.4 1 1 1h2l-1.3 2.7a1 1 0 00.8 1.3z"/></svg>',
    'redo': '<svg width="18" height="18"><path fill-rule="nonzero" d="M12.6 8H6.9C5.1 8 4 9.1 4 11c0 1.3.4 2.4 1.3 3.3a1 1 0 11-1.4 1.4A6.5 6.5 0 012 11c0-3 2-5 5-5h5.6l-2.3-2.3a1 1 0 011.4-1.4L16.4 7l-4.7 4.7a1 1 0 01-1.4-1.4L12.6 8z"/></svg>',
    'reload': '<svg width="18" height="18"><path fill-rule="nonzero" d="M12 5a5 5 0 00-8 4 1 1 0 11-2 0 7 7 0 0111-5.7V2a1 1 0 012 0v5h-5a1 1 0 110-2h2zm-6 8a5 5 0 008-4 1 1 0 012 0 7 7 0 01-11 5.7V16a1 1 0 01-2 0v-5h5a1 1 0 010 2H6z"/></svg>',
    'remove-formatting': '<svg width="18" height="18"><path fill-rule="nonzero" d="M13 13l1.7-1.8a.8.8 0 011 1L14.2 14l1.7 1.7a.8.8 0 01-1 1L13 15.2l-1.7 1.7a.8.8 0 01-1-1l1.6-1.8-1.7-1.7a.8.8 0 011-1l1.8 1.6zM9 3h4a1 1 0 010 2H9.8L8 11.3a1 1 0 01-2-.6L7.7 5H5a1 1 0 110-2h4zM4 15a1 1 0 010-2h5a1 1 0 010 2H4z"/></svg>',
    'remove': '<svg width="18" height="18"><path fill-rule="nonzero" d="M13 5h3a1 1 0 010 2h-1v7a3 3 0 01-3 3H6a3 3 0 01-3-3V7H2a1 1 0 110-2h3V4a3 3 0 013-3h2a3 3 0 013 3v1zm-2 0V4c0-.6-.4-1-1-1H8a1 1 0 00-1 1v1h4zm2 2H5v7c0 .6.4 1 1 1h6c.6 0 1-.4 1-1V7zM6 9a1 1 0 112 0v4a1 1 0 01-2 0V9zm4 0a1 1 0 012 0v4a1 1 0 01-2 0V9z"/></svg>',
    'resize': '<svg width="18" height="18"><path d="M2 3c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3h6c.3 0 .5.1.7.3.2.2.3.4.3.7 0 .3-.1.5-.3.7A1 1 0 019 4H5.4l8.6 8.6V9c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3.3 0 .5.1.7.3.2.2.3.4.3.7v6c0 .3-.1.5-.3.7a1 1 0 01-.7.3H9a1 1 0 01-.7-.3A1 1 0 018 15c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3h3.6L4 5.4V9c0 .3-.1.5-.3.7a1 1 0 01-.7.3 1 1 0 01-.7-.3A1 1 0 012 9V3z" fill-rule="evenodd"/></svg>',
    'restore-draft': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M3 3.7A8 8 0 0117 9a8 8 0 01-13.7 5.7l1.5-1.5A6 6 0 0015 9 6 6 0 003.8 6H6a1 1 0 110 2H1V2a1 1 0 112 0v1.7z"/><path d="M12 10c0 .6-.4 1-1 1H8V6c0-.6.4-1 1-1s1 .4 1 1v3h1c.6 0 1 .4 1 1z"/></g></svg>',
    'rotate-left': '<svg width="18" height="18"><path fill-rule="nonzero" d="M3 5.4a7 7 0 111 8.5l1.5-1.4A5 5 0 0014 9a5 5 0 00-9.6-2H6a1 1 0 110 2H1V3a1 1 0 112 0v2.4z"/></svg>',
    'rotate-right': '<svg width="18" height="18"><path fill-rule="nonzero" d="M15 5.4V3a1 1 0 012 0v6h-5a1 1 0 010-2h1.6a5 5 0 10-1 5.5l1.3 1.4A7 7 0 012 9a7 7 0 0113-3.6z"/></svg>',
    'rtl': '<svg width="18" height="18"><g fill-rule="evenodd"><path d="M5 3h6c.6 0 1 .4 1 1s-.4 1-1 1h-1v9c0 .6-.4 1-1 1a1 1 0 01-1-1V5H7v9c0 .6-.4 1-1 1a1 1 0 01-1-1v-4c-.5 0-1 0-1.4-.3A3.4 3.4 0 011.8 8a3.3 3.3 0 010-2.8 3.4 3.4 0 011.8-1.8L5 3zM15.6 14.2a1 1 0 11-1.2 1.6l-3-2a1 1 0 010-1.6l3-2a1 1 0 011.2 1.6L13.8 13l1.8 1.2z"/></g></svg>',
    'save': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4 11h10a2 2 0 012 2v2a2 2 0 01-2 2H4a2 2 0 01-2-2v-2c0-1.1.9-2 2-2zm0 2v2h10v-2H4zm6 0h2v2h-2v-2zM8 7.6V2a1 1 0 112 0v5.6l2.3-2.3a1 1 0 011.4 1.4l-4 4a1 1 0 01-1.4 0l-4-4a1 1 0 011.4-1.4L8 7.6z"/></svg>',
    'search': '<svg width="18" height="18"><path fill-rule="nonzero" d="M11.5 12.9a6 6 0 111.4-1.4l3.3 3.3a1 1 0 01-1.4 1.4L11.5 13zM8 12a4 4 0 100-8 4 4 0 000 8z"/></svg>',
    'select-all': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4 4h10v10H4V4zm2 2v6h6V6H6zM1 4v2h2V4H1zm0 4v2h2V8H1zm0 4v2h2v-2H1zm3 3v2h2v-2H4zm4 2h2v-2H8v2zm4 0h2v-2h-2v2zm5-3v-2h-2v2h2zm0-4V8h-2v2h2zm0-4V4h-2v2h2zm-3-5h-2v2h2V1zm-4 0H8v2h2V1zM6 1H4v2h2V1z"/></svg>',
    'settings': '<svg width="18" height="18"><path d="M8 3h7c.6 0 1 .4 1 1s-.4 1-1 1H8v.3c0 .2 0 .3-.2.5l-.5.2H4.8c-.3 0-.4 0-.6-.2a.7.7 0 01-.2-.5V5H3a1 1 0 110-2h1v-.3c0-.2 0-.3.2-.5l.5-.2h2.5c.3 0 .4 0 .6.2l.2.5V3zM5 5h2V3H5v2zm9 2.8V8h1c.6 0 1 .4 1 1s-.4 1-1 1h-1v.3c0 .2 0 .3-.2.5l-.6.2h-2.4c-.3 0-.4 0-.6-.2a.7.7 0 01-.2-.6V10H3a1 1 0 110-2h7v-.3c0-.2 0-.3.2-.5l.6-.2h2.4c.3 0 .4 0 .6.2l.2.5zM11 10h2V8h-2v2zm-3 2.8v.2h7c.6 0 1 .4 1 1s-.4 1-1 1H8v.3c0 .2 0 .3-.2.5l-.5.2H4.8c-.3 0-.4 0-.6-.2a.7.7 0 01-.2-.6V15H3a1 1 0 010-2h1v-.3c0-.2 0-.3.2-.5l.5-.2h2.5c.3 0 .4 0 .6.2l.2.6zM5 15h2v-2H5v2z" fill-rule="evenodd"/></svg>',
    'sharpen': '<svg width="18" height="18"><path d="M13 3l4 4-8 9-8-9 4-4h8zM9 13.2L14.5 7l-.1-.1H9v-.3h5.1l-.2-.2H9V6h4.6l-.2-.2H9v-.3h4.1l-.2-.2H9V5h3.6l-.2-.2H5.7L3.5 7l.1.1H9v.3H3.9l.2.2H9V8H4.3l.2.2H9v.3H4.7l.3.2h4V9H5.2l.2.2H9v.3H5.6l.3.2H9v.3H6l.3.2H9v.3H6.5l.2.2H9v.3H7l.2.2H9v.3H7.4l.2.2H9v.3H7.9l.2.2H9v.3h-.7l.2.2H9v.3h-.3l.3.2z" fill-rule="evenodd"/></svg>',
    'sourcecode': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M6.8 12.7c.3.3.3.8 0 1-.4.4-.9.4-1.2 0L1.2 9.7a.8.8 0 010-1.2l4.4-4.2c.3-.3.8-.3 1.2 0 .3.3.3.8 0 1.1L3 9l3.8 3.7zM11.2 12.7c-.3.3-.3.8 0 1 .4.4.9.4 1.2 0l4.4-4.1c.3-.3.3-.8 0-1.2l-4.4-4.2a.8.8 0 00-1.2 0c-.3.3-.3.8 0 1.1L15 9l-3.8 3.7z"/></g></svg>',
    'spell-check': '<svg width="18" height="18"><path d="M3 6v3H2V3c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3h2c.3 0 .5.1.7.3.2.2.3.4.3.7v6H5V6H3zm0-3v2h2V3H3zm13 0h-3v5h3v1h-3a1 1 0 01-.7-.3A1 1 0 0112 8V3c0-.3.1-.5.3-.7.2-.2.4-.3.7-.3h3v1zm-5 1.5l-.1.7c-.1.2-.3.3-.6.3.3 0 .5.1.6.3l.1.7V8c0 .3-.1.5-.3.7a1 1 0 01-.7.3H7V2h3c.3 0 .5.1.7.3.2.2.3.4.3.7v1.5zM10 8V6H8v2h2zm0-3V3H8v2h2zm2 5l1 1-5.5 6L5 13.5l1.3-1 1.2 1.2L12 10z" fill-rule="evenodd"/></svg>',
    'strike-through': '<svg width="18" height="18"><path d="M9.2 8H16a1 1 0 010 2h-2.5c.3.5.3 1 .3 1.5 0 1.2-.6 3.5-4.3 3.5A5.3 5.3 0 015 12.8l1.3-1c.3.5 1.3 1.8 3.2 1.8 1.4 0 2-.4 2.5-1 .4-.8.3-1.9-.7-2.4l-.5-.2H2a1 1 0 110-2h4c-.3-.4-.5-1-.5-1.7C5.5 4 7.8 3 9.6 3c2.5 0 3.6 1.4 4 2l-1.2 1c-.5-.6-.8-1-1.2-1.2-.5-.3-1-.4-1.7-.4-2.3 0-2.4 1.5-2.4 1.8 0 1.1 1 1.5 2.1 1.8z" fill-rule="evenodd"/></svg>',
    'subscript': '<svg width="18" height="18"><path fill-rule="nonzero" d="M8 9.6l2.9 2.9a1 1 0 01-1.4 1.4l-3-2.9-2.8 2.9a1 1 0 01-1.4-1.4l2.9-3-3-2.8a1 1 0 111.5-1.4l2.9 2.9 2.9-3a1 1 0 011.4 1.5L8 9.6zm8.4 7h-4.8v-1l.8-.8c.8-.6 1.4-1.2 1.7-1.6.4-.5.6-.9.6-1.3 0-.2 0-.5-.3-.7l-.8-.2a2 2 0 00-.9.1l-.6.4-.5-1.1c.3-.3.6-.4 1-.6l1.3-.2c.8 0 1.4.2 1.8.6.4.5.6 1 .6 1.6 0 .6-.2 1.1-.5 1.6a8 8 0 01-1.3 1.3l-.6.5h2.5v1.4z"/></svg>',
    'superscript': '<svg width="18" height="18"><path fill-rule="nonzero" d="M8 9.6l2.9 2.9a1 1 0 01-1.4 1.4l-3-2.9-2.8 2.9a1 1 0 01-1.4-1.4l2.9-3-3-2.8a1 1 0 111.5-1.4l2.9 2.9 2.9-3a1 1 0 011.4 1.5L8 9.6zm8.4 0h-4.8v-1l.8-.8c.8-.6 1.4-1.2 1.7-1.6.4-.5.6-.9.6-1.3 0-.2 0-.5-.3-.7l-.8-.2a2 2 0 00-.9.1l-.6.4-.5-1.1c.3-.3.6-.4 1-.6l1.3-.2c.8 0 1.4.2 1.8.6.4.5.6 1 .6 1.6 0 .6-.2 1.1-.5 1.6a8 8 0 01-1.3 1.3l-.6.5h2.5v1.4z"/></svg>',
    'table-caption': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M16 16H2V6h14v10zm-8-4H4v2h4v-2zm6 0h-4v2h4v-2zM8 8H4v2h4V8zm6 0h-4v2h4V8zM12 2v2H2V2z"/></g></svg>',
    'table-cell-classes': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M9 9v7H2V2h14v7H9zM7 9H4v5h3V9zm0-5H4v3h3V4zm7 0H9v3h5V4z" opacity=".3"/><path d="M13.5 15l-2 1.3.5-2.3-1.8-1.6 2.4-.2.9-2.2 1 2.2 2.3.2L15 14l.6 2.3z"/><path fill-rule="nonzero" d="M9 2H2v7h7V2zM7 4v3H4V4h3z"/></g></svg>',
    'table-cell-properties': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M16 2v8h-6v6H2V2h14zm-8 8H4v4h4v-4zm0-6H4v4h4V4z"/><circle cx="12.5" cy="13.5" r="1"/><circle cx="15.5" cy="13.5" r="1"/></g></svg>',
    'table-classes': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M9 9v7H2V2h14v7H9zM7 9H4v5h3V9zm0-5H4v3h3V4zm7 0H9v3h5V4z"/><path d="M13.5 15l-2 1.3.5-2.3-1.8-1.6 2.4-.2.9-2.2 1 2.2 2.3.2L15 14l.6 2.3z"/></g></svg>',
    'table-delete-column': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M10 4v5a1 1 0 11-2 0V4H4v11a1 1 0 01-2 0V2h14v13a1 1 0 01-2 0V4h-4z"/><path d="M9 12l2-2a.8.8 0 011 1l-2 2 2 2a.8.8 0 01-1 1l-2-2-2 2a.8.8 0 01-1-1l2-2-2-2a.8.8 0 011-1l2 2z"/></g></svg>',
    'table-delete-row': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M4 8h5a1 1 0 110 2H4v4h11a1 1 0 010 2H2V2h13a1 1 0 010 2H4v4z"/><path d="M13 8l2-2a.8.8 0 011 1l-2 2 2 2a.8.8 0 01-1 1l-2-2-2 2a.8.8 0 01-1-1l2-2-2-2a.8.8 0 011-1l2 2z"/></g></svg>',
    'table-delete-table': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M2 2h14v14H2V2zm2 2v10h10V4H4z"/><path d="M9 8l2-2a.8.8 0 011 1l-2 2 2 2a.8.8 0 01-1 1l-2-2-2 2a.8.8 0 01-1-1l2-2-2-2a.8.8 0 011-1l2 2z"/></g></svg>',
    'table-insert-column-after': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M7 4H4v4h3V4zm2 0v10h6a1 1 0 010 2H2V2h13a1 1 0 010 2H9zM7 14v-4H4v4h3z"/><path d="M12 8V7a1 1 0 012 0v1h1a1 1 0 010 2h-1v1a1 1 0 01-2 0v-1h-1a1 1 0 010-2h1z"/></g></svg>',
    'table-insert-column-before': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M11 14h3v-4h-3v4zm-2 0V4H3a1 1 0 110-2h13v14H3a1 1 0 010-2h6zm2-10v4h3V4h-3z"/><path d="M4 8V7a1 1 0 112 0v1h1a1 1 0 110 2H6v1a1 1 0 01-2 0v-1H3a1 1 0 110-2h1z"/></g></svg>',
    'table-insert-row-above': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M10 14h4v-3h-4v3zm-2 0v-3H4v3h4zm6-5V3a1 1 0 012 0v13H2V3a1 1 0 112 0v6h10z"/><path d="M8 4V3a1 1 0 112 0v1h1a1 1 0 010 2h-1v1a1 1 0 11-2 0V6H7a1 1 0 110-2h1z"/></g></svg>',
    'table-insert-row-after': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M8 4H4v3h4V4zm2 0v3h4V4h-4zM4 9v6a1 1 0 01-2 0V2h14v13a1 1 0 01-2 0V9H4z"/><path d="M8 12v-1a1 1 0 012 0v1h1a1 1 0 010 2h-1v1a1 1 0 01-2 0v-1H7a1 1 0 010-2h1z"/></g></svg>',
    'table-left-header': '<svg width="18" height="18"><path fill-rule="nonzero" d="M8 8h2V4H8v4zm0 6h2v-4H8v4zm6-6V4h-2v4h2zm0 2h-2v4h2v-4zM2 2h14v14H2V2z"/></svg>',
    'table-merge-cells': '<svg width="18" height="18"><path fill-rule="nonzero" d="M8 8v6h6V8H8zm-4 2h2V8H4v2zm0 2v2h2v-2H4zm4-6h2V4H8v2zm6 0V4h-2v2h2zM4 6h2V4H4v2zM2 2h14v14H2V2z"/></svg>',
    'table-properties': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M10 10v6H2V2h14v8h-6zm-2 0H4v4h4v-4zm0-6H4v4h4V4zm6 0h-4v4h4V4z"/><circle cx="12.5" cy="13.5" r="1"/><circle cx="15.5" cy="13.5" r="1"/></g></svg>',
    'table-row-numbering-rtl': '<svg width="18" height="18"><path d="M2 16h14V2H2v14zm10-4h2v2h-2v-2zm-8 0h6v2H4v-2zm8-4h2v2h-2V8zM4 8h6v2H4V8zm8-4h2v2h-2V4zM4 4h6v2H4V4z"/></svg>',
    'table-row-numbering': '<svg width="18" height="18"><path d="M16 16H2V2h14v14zM6 12H4v2h2v-2zm8 0H8v2h6v-2zM6 8H4v2h2V8zm8 0H8v2h6V8zM6 4H4v2h2V4zm8 0H8v2h6V4z"/></svg>',
    'table-row-properties': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M2 16V2h14v8h-6v6H2zm6-2v-2H4v2h4zM8 4H4v2h4V4zm6 0h-4v2h4V4z"/><circle cx="12.5" cy="13.5" r="1"/><circle cx="15.5" cy="13.5" r="1"/></g></svg>',
    'table-split-cells': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M4 10h2V8H4v2zm0 2v2h2v-2H4zm10-6V4h-2v2h2zm2 2H8v8H2V2h14v6zM8 6h2V4H8v2zM4 6h2V4H4v2z"/><path d="M12 11l2-2a.8.8 0 011 1l-2 2 2 2a.8.8 0 01-1 1l-2-2-2 2a.8.8 0 01-1-1l2-2-2-2a.8.8 0 011-1l2 2z"/></g></svg>',
    'table-top-header': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4 8v2h4V8H4zm10 0h-4v2h4V8zM4 12v2h4v-2H4zm10 0h-4v2h4v-2zM2 2h14v14H2V2z"/></svg>',
    'table': '<svg width="18" height="18"><path fill-rule="nonzero" d="M4 8h4V4H4v4zm0 2v4h4v-4H4zm10-2V4h-4v4h4zm0 2h-4v4h4v-4zM2 2h14v14H2V2z"/></svg>',
    'template': '<svg width="18" height="18"><path d="M14 15v-1H4v1h10zm-8-3v-2a5 5 0 116 0v2h2a2 2 0 012 2v3H2v-3c0-1.1.9-2 2-2h2zm4 0V9l.8-.6a3 3 0 10-3.6 0L8 9v3h2z" fill-rule="nonzero"/></svg>',
    'temporary-placeholder': '<svg width="18" height="18"><g fill-rule="evenodd"><path d="M7.1 7v-.8h1.6v-1S8.8 5 9 5c.2 0 .3.1.3.3v.9H11V7c1.8.7 3.1 2.3 3.1 4.3 0 2.5-2.2 4.6-5 4.6s-5-2-5-4.6c0-2 1.3-3.6 3.1-4.3zm-2 3.6a.3.3 0 00.1.4c.2 0 .4 0 .4-.2v-.1c.4-1 1.2-1.7 2.2-2l.2-.4C8 8 7.8 8 7.6 8A3.8 3.8 0 005 10.6z"/><circle cx="11" cy="4" r="1"/><circle cx="9" cy="2" r="1"/><circle cx="7" cy="4" r="1"/></g></svg>',
    'text-color': '<svg width="18" height="18"><g fill-rule="evenodd"><path id="tox-icon-text-color__color" d="M1 14h16v3H1z"/><path d="M6 12h-.6a.5.5 0 01-.5-.6l2.4-8c0-.3.3-.4.5-.4h2.4c.2 0 .4.1.5.4l2.4 8a.5.5 0 01-.5.6H12a.5.5 0 01-.4-.4l-.6-2c-.1-.2-.3-.3-.5-.3h-3c-.2 0-.4.1-.5.4l-.6 2c0 .2-.2.3-.4.3zm2.4-6.8l-.5 1.7a.5.5 0 00.5.6h1.2a.5.5 0 00.5-.6l-.5-1.7c0-.3-.2-.4-.5-.4H9c-.3 0-.4.1-.5.4z"/></g></svg>',
    'toc': '<svg width="18" height="18"><path d="M3 2c.6 0 1 .4 1 1s-.4 1-1 1a1 1 0 110-2zm3 0h9c.6 0 1 .4 1 1s-.4 1-1 1H6a1 1 0 110-2zm-3 8c.6 0 1 .4 1 1s-.4 1-1 1a1 1 0 010-2zm3 0h9c.6 0 1 .4 1 1s-.4 1-1 1H6a1 1 0 010-2zm0-4c.6 0 1 .4 1 1s-.4 1-1 1a1 1 0 110-2zm3 0h6c.6 0 1 .4 1 1s-.4 1-1 1H9a1 1 0 110-2zm-3 8c.6 0 1 .4 1 1s-.4 1-1 1a1 1 0 010-2zm3 0h6c.6 0 1 .4 1 1s-.4 1-1 1H9a1 1 0 010-2z" fill-rule="evenodd"/></svg>',
    'translate': '<svg width="18" height="18"><path d="M9.7 11.3l-.3.7-.4.7-2.2-2.2-3.1 3c-.3.4-.8.4-1 0a.7.7 0 010-1l3.1-3A12.4 12.4 0 013.7 6H5a10.1 10.1 0 001.7 2.4c.5-.5 1-1.1 1.4-1.8l.9-2H1.7a.7.7 0 110-1.5h4.4v-.7c0-.4.3-.8.7-.8.4 0 .7.4.7.8v.7H12c.4 0 .8.3.8.7 0 .4-.4.8-.8.8h-1.4a12.3 12.3 0 01-1 2.4 13.5 13.5 0 01-1.7 2.3l1.9 1.8zm4.3-3l2.7 7.3a.5.5 0 01-.4.7 1 1 0 01-1-.7l-.6-1.5h-3.4l-.6 1.5a1 1 0 01-1 .7.5.5 0 01-.4-.7L12 8.2a1 1 0 012 0zm-2.2 4.4h2.4L13 9.5l-1.2 3.2z" fill-rule="evenodd"/></svg>',
    'underline': '<svg width="18" height="18"><path d="M13 3c.6 0 1 .4 1 1v4.5a4 4 0 01-.4 1.8l-1 1.4a5.3 5.3 0 01-5.5 1 5 5 0 01-1.6-1c-.5-.4-.8-.9-1.1-1.4A4 4 0 014 8.4V4c0-.6.4-1 1-1s1 .4 1 1v4.5c0 .3 0 .6.2 1l.6.7A3.3 3.3 0 009 11a3.4 3.4 0 002.2-.8c.3-.2.4-.5.6-.8l.2-.9V4c0-.6.4-1 1-1zM5 14h8c.6 0 1 .4 1 1s-.4 1-1 1H5a1 1 0 010-2z" fill-rule="evenodd"/></svg>',
    'undo': '<svg width="18" height="18"><path fill-rule="nonzero" d="M5.4 6h5.7C14 6 16 8 16 11c0 1.9-.6 3.4-1.9 4.7a1 1 0 11-1.4-1.4c.9-.9 1.3-2 1.3-3.3 0-1.9-1.1-3-3-3H5.5l2.3 2.3a1 1 0 01-1.4 1.4L1.6 7l4.7-4.7a1 1 0 011.4 1.4L5.4 6z"/></svg>',
    'unlink': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M13 10.2V10a2 2 0 00-2-.5A2 2 0 009 8H8V6h1a4 4 0 014 4.2zm-2.2 3.4A4 4 0 019 14H5a4 4 0 01-1.3-7.8l.5-.1.6 1.8-.5.2A2 2 0 005 12h4.5l.6 1 .7.6z"/><path d="M10 9H9a2 2 0 110-4h4a2 2 0 01.7 3.9l-.5.2.6 1.8.5-.1A4 4 0 0013 3H9a4 4 0 100 8h1V9z"/><path d="M14 13l2-2a.8.8 0 011 1l-2 2 2 2a.8.8 0 01-1 1l-2-2-2 2a.8.8 0 01-1-1l2-2-2-2a.8.8 0 011-1l2 2z"/></g></svg>',
    'unlock': '<svg width="18" height="18"><path d="M14 1c.8 0 1.5.3 2.1.9.6.6.9 1.3.9 2.1v3h-2V4a1 1 0 00-.3-.7A1 1 0 0014 3h-2a1 1 0 00-.7.3 1 1 0 00-.3.7v3h.3c.2 0 .3 0 .5.2l.2.5v7.5c0 .3 0 .4-.2.6l-.6.2H2.8c-.3 0-.4 0-.6-.2a.7.7 0 01-.2-.6V7.8c0-.3 0-.4.2-.6l.5-.2H9V4c0-.8.3-1.5.9-2.1.6-.6 1.3-.9 2.1-.9h2z" fill-rule="evenodd"/></svg>',
    'unordered-list': '<svg width="18" height="18"><path fill-rule="nonzero" d="M8 7a1 1 0 110-2h6a1 1 0 010 2H8zm0 6a1 1 0 010-2h6a1 1 0 010 2H8zM2.5 6c0-.4.1-.8.4-1 .3-.4.7-.5 1.1-.5.4 0 .8.1 1 .4.4.3.5.7.5 1.1 0 .4-.1.8-.4 1-.3.4-.7.5-1.1.5-.4 0-.8-.1-1-.4-.4-.3-.5-.7-.5-1.1zm0 6c0-.4.1-.8.4-1 .3-.4.7-.5 1.1-.5.4 0 .8.1 1 .4.4.3.5.7.5 1.1 0 .4-.1.8-.4 1-.3.4-.7.5-1.1.5-.4 0-.8-.1-1-.4-.4-.3-.5-.7-.5-1.1z"/></svg>',
    'vertical-align': '<svg width="18" height="18"><g fill-rule="evenodd"><path fill-rule="nonzero" d="M9 4.6L6.7 2.3a1 1 0 00-1.4 1.4L9 7.4l3.7-3.7a1 1 0 10-1.4-1.4L9 4.6zm0 8.7l-2.3 2.3a1 1 0 01-1.4-1.4L9 10.5l3.7 3.7a1 1 0 11-1.4 1.4L9 13.3z"/><path d="M2 8h14v2H2z"/></g></svg>',
    'visualblocks': '<svg width="18" height="18"><path fill-rule="nonzero" d="M6 15v2H4v-2h2zm4 0v2H8v-2h2zm4 0v2h-2v-2h2zM3 12v2H1v-2h2zm14 0v2h-2v-2h2zm-5-8a1 1 0 010 2v7a1 1 0 01-2 0V6H9v7a1 1 0 01-2 0V9a2.5 2.5 0 01-.2-5H12zM3 8v2H1V8h2zm14 0v2h-2V8h2zM3 4v2H1V4h2zm14 0v2h-2V4h2zm-3-3v2h-2V1h2zm-4 0v2H8V1h2zM6 1v2H4V1h2z"/></svg>',
    'visualchars': '<svg width="18" height="18"><path d="M7 2h7a1 1 0 010 2h-1v11a1 1 0 01-2 0V4H9v11a1 1 0 01-2 0V9c-.5 0-1 0-1.4-.3A3.4 3.4 0 013.8 7a3.3 3.3 0 010-2.8 3.4 3.4 0 011.8-1.8L7 2z" fill-rule="evenodd"/></svg>',
    'zoom-in': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M12.2 13.6a7 7 0 111.4-1.4l2.6 2.6a1 1 0 01-1.4 1.4l-2.6-2.6zM8 13A5 5 0 108 3a5 5 0 000 10z"/><path d="M9 7h2a1 1 0 010 2H9v2a1 1 0 01-2 0V9H5a1 1 0 110-2h2V5a1 1 0 112 0v2z"/></g></svg>',
    'zoom-out': '<svg width="18" height="18"><g fill-rule="nonzero"><path d="M12.2 13.6a7 7 0 111.4-1.4l2.6 2.6a1 1 0 01-1.4 1.4l-2.6-2.6zM8 13A5 5 0 108 3a5 5 0 000 10z"/><path d="M5 9h6a1 1 0 000-2H5a1 1 0 100 2z"/></g></svg>',
  }
});