const dialogMeVersion = "2025-04-11 14:00";
/**
 * De un array de objetos le cambia a cada objeto su llave por la de reyKeyer
 *
 * @example
 * let reyKeyer = {aaa:'a', bbb:'b'};
 * let llega = [ {aaa:1, bbb:2, ccc:4}, {aaa:14, bbb:24, ccc:44} ];
 *  reKeyArray(reyKeyer, llega) => [{a: 1, b: 2, ccc: 4},{a: 14, b: 24, ccc: 44}]
 *
 * @param reyKeyer {} ie {aaa:'a', bbb:'b', 'ddd':'d'};
 * @param data [{}] ie [ {aaa:1, bbb:2, ccc:4}, {aaa:14, bbb:24, ccc:44} ];
 * @returns [{}] ie [{a: 1, b: 2, ccc: 4},{a: 14, b: 24, ccc: 44}]
 *, 'ddd':'d'
 *
 */
function reKeyArray(reyKeyer, data) {
    let result = []
    for(let row of data) {
        let r = {}
        for(k in row)
            if(row.hasOwnProperty(k))
                r[ reyKeyer[k] || k ] = row[k];
        result.push(r);
    }
    return result;
}

function dialogCloseAll() {
    $(".ui-dialog-content").each(function(){
        let $dialog = $(this);
        if($dialog.dialog('isOpen'))
            $dialog.dialog('close');
    })
}
/**
 * Un div, ya en la hoja que tiene id=id se muestra como dialogo. Si esta abierto solo se cierra sin abrirse
 *
 * @example ver bodega_reporte_ventas.php
 * @param id string
 * @param options object opciones para el dialog
 */
function dialogme(id, options, doneCallback = null, doneLabel = 'Haz') {
    let $dlg = $("#" + id);
    if($dlg.is(":visible")) {
        $dlg.dialog('close');
        return;
    }
    dialogCloseAll();
    $dlg.dialog(
        $.extend(
            {closeOnEscape:true,width:'fit-content',height: window.innerHeight - 150,
                buttons: [
                    {
                        text: doneLabel,
                        id:"dialogme_done",
                        icon: "ui-icon-check",
                        click: function () {
                            if(typeof doneCallback === "function")
                                doneCallback();
                            $("#" + id).dialog( "close" );
                        }
                    },
                    {
                        text: "Cancel",
                        id:"dialogme_cancel",
                        icon: "ui-icon-close",
                        click: function () {
                            $("#" + id).dialog("close");
                        }
                    },
                ],
            },
            options)
    );
}

/**
 * Solo con el boton de cancel.
 *
 * @param id
 * @param options
 * @param doneCallback
 */
function dialogmeCancel(id, options, doneCallback = null) {
    console.log('id', id);
    
    let $dlg = $("#" + id);
    if($dlg.is(":visible")) {
        $dlg.dialog('close');
        return;
    }
    dialogCloseAll();

    let prodId=$(`#${id} select[name="producto_general_id[]"]`);
    if(prodId.length){
        setColorsInProduct(prodId, id);
    }
    $dlg.dialog(
        $.extend(
            {
                closeOnEscape:true,
                width:'fit-content',
                height: window.innerHeight - 150,
                buttons: [
                    {
                        text: "Cancel",
                        id:"dialogme_cancel",
                        icon: "ui-icon-close",
                        click: function () {
                            $("#" + id).dialog("close");
                        }
                    },
                ],
            },
            options)
    );
}

/**
 * Solo con el boton de done
 *
 * @param id
 * @param options
 * @param doneCallback
 */
function dialogmeDone(id, options, doneCallback = null, doneLabel = 'Haz') {
    let $dlg = $("#" + id);
    if($dlg.is(":visible")) {
        $dlg.dialog('close');
        return;
    }
    dialogCloseAll();
    $dlg.dialog(
        $.extend(
            {closeOnEscape:true,width:'fit-content',height: window.innerHeight - 150,
                buttons: [
                    {
                        text: doneLabel,
                        id:"dialogme_done",
                        icon: "ui-icon-check",
                        click: function () {
                            if(typeof doneCallback === "function")
                                doneCallback();
                            $("#" + id).dialog( "close" );
                        }
                    },
                ],
            },
            options)
    );
}

function setColorsInProduct(prodId, id){
    prodId.on('change', function(e){
        findProductColors(e, id);        
    });

}

async function findProductColors(e, id){
    //busca select de colores
    let selectColor=$(`#${id} select[name="color_id[]"]`);    
   //obteniendo colores del select
   const colors= selectColor.val();

    //obteniendo id de producto
    const productos=$(e.target).val();
    //si no hay producto seleccionado se retorna
    if(!productos.length) return setAllColors(selectColor);
    selectColor.empty();
    $.ajax({
        url: getUrlForAjax('get_colores_by_producto.php'),
        method: 'POST',
        data: { accion: 'productoColoresMultiple', productos: productos, colores: colors, posibles:selectColor.data("coloresposibles"), "_nd":(new Date()).getTime()  },
        dataType: 'json',
        success: function(data) {

            if(data.status) {
                let colores = data.colores;
                let $dialog_color_id = selectColor;
                $dialog_color_id[0].selectize.clear();
                $dialog_color_id[0].selectize.clearOptions();
                colores.forEach(function(color) {
                    $dialog_color_id[0].selectize.addOption({value: color.color_id, text: color.color});
                });
                $dialog_color_id[0].selectize.refreshItems();

                if(colores.length){
                    //poniendo en selected los colores que ya estaban seleccionados
                    $dialog_color_id[0].selectize.setValue(colors);
                }
            }
        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log("Error en la petición de colores", errorThrown);
        }
    });   
    
}

function setAllColors(selectColor){
    let colors= $vitex_globales.g_cat_color;

    selectColor.empty();

    colors.forEach(function(color) {
        selectColor[0].selectize.addOption({value: color.color_id, text: color.color});
    });
}

/**
 * Sin boton de cancel ni done
 *
 * @param id
 * @param options
 * @param doneCallback
 */
function dialogmeSinBotones(id, options, doneCallback = null) {
    let $dlg = $("#" + id);
    if($dlg.is(":visible")) {
        $dlg.dialog('close');
        return;
    }
    dialogCloseAll();
    $dlg.dialog(
        $.extend(
            {closeOnEscape:true,width:'fit-content',},
            options)
    );
}

/**
 * Pide al server con url, accion, parametros una respuesta de ajaxHelper con todos/algunos de
 *  filtro, reporte, titulo (del dialogo), options (del dialogo).
 *
 * @example buscar pedidoRecomiendaLog ver: producto_color_acciones.php y bodega_reporte_ventas.php
 *
 * @param id string
 * @param url string
 * @param accion string
 * @param parametros objeto
 * @param dialogOptions objeto
 */
function dialogmeReporter(id, url, accion, parametrosDefault = {}, dialogOptions = {}) {
    // si existe el dialogo cierralo
    let $dialog = $("#" + id);
    if($dialog.length) {
        $dialog.dialog('close');
        $dialog.remove();
        return;
    }
    dialogCloseAll();
    let parametros = parametrosDefault;
    getReport();

    function getReport() {
        parametros.accion = accion;
        $.ajax({
            url: url,
            method: 'GET',
            data: parametros,
            cache: false,
            dataType:'json',
        })
        .done(function(data) {
            parametros = {accion:accion}
            if(!data.status) {
                if(typeof data.message === 'string')
                    ia.alertError(data.message, "Error inesperado");
                else
                    ia.alertError("Error inesperado", "Error inesperado");
                console.log("data error", data)
                return;
            }
            display(data);
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(errorThrown, "Error inesperado");
            console.log("ajax error", arguments);
        });
    }


    function display(data) {
        let $dlg = $(`<DIV id="${id}">`);
        fillDialog($dlg, data);
        if(typeof data.title === 'string')
            dialogOptions.title = data.title;
        let options2 = typeof data.options === 'object' ? data.options : {};

        let opt =             $.extend({},
            {closeOnEscape:true,
                width:'fit-content',

                height:window.innerHeight - 100,
                buttons: [
                    {
                        text: "Reporte",
                        id:"dialogmeReporter_Refresh",
                        icon: "ui-icon-file-text",
                        click: function () {
                            let object = {};
                            let forma = $(this).children("FORM");
                            if(forma.length) {
                                let formData = new FormData(forma[0]);
                                formData.forEach((value, key) => {
                                    if (!object.hasOwnProperty(key)) {
                                        object[key] = value;
                                        return;
                                    }
                                    if (!Array.isArray(object[key]))
                                        object[key] = [object[key]];
                                    else
                                        object[key].push(value);
                                });
                            }
                            reload($dlg, object);
                        },
                    },
                    {
                        text: "Cerrar",
                        icon: "ui-icon-circle-b-close",
                        id: "dialogmeReporter_Close",
                        click: function () {
                            $(this).dialog("close");
                        },
                    }
                ],
                close: function() {$(this).remove();},
                open: function() {
                    $(".ui-dialog-buttonpane", $(this).parent()).hide();
                },

            },
            dialogOptions, options2);
        $dlg.dialog(opt);
    }


    function fillDialog($dlg, data) {
        if(typeof data.filtro === 'string')
            $dlg.append(data.filtro);
        if(typeof data.reporte === 'string')
            $dlg.append(data.reporte);
    }

    function reload($dlg, valoresForma) {
        $.ajax({
            url: url,
            method: 'GET',
            data: $.extend({}, parametros, valoresForma),
            cache: false,
            dataType:'json',
        })
        .done(function(data) {
            if(!data.status) {
                if(typeof data.message === 'string')
                    ia.alertError(data.message, "Error inesperado");
                else
                    ia.alertError("Error inesperado", "Error inesperado");
                console.log("data error", data)
                return;
            }
            $dlg.html('');
            if(typeof data.title === 'string')
                $dlg.attr("title", data.title).dialog("option", "title", data.title);
            fillDialog($dlg, data);
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(errorThrown, "Error inesperado");
            console.log("ajax error", arguments);
        });
    }
}
