
const iacParam = {

    /**
     * Presenta en modal dialog a containerId con title para editarlos y guardarlos
     * backoffice_view_iacParamFile es un file con extensión .html en backoffice/view/iacParam/ con title y id
     * ver ejemplo backoffice/view/iacParam/resetBodegaProductos.html
     *
     * @param {string} backoffice_view_iacParamFile fileName.html del html de la forma a editar en backoffice/view/iacParam
     *
     * @example
     * iacParam.edit('resetBodegaProductos.html');
     *
     */
    edit: function( backoffice_view_iacParamFile) {
        $.ajax({
            url:'../backoffice/ajax/iacParam_acciones.php',
            method:'POST',
            cache:false,
            dataType:'json',
            data:{accion:'get', html:backoffice_view_iacParamFile }
        }).done(function( gotData) {
            if(gotData.message.length) {
                alerta_error('Error al leer los parámetros', gotData.message);
                return;
            }
            $("BODY").append(gotData.html);
            let containerId = $(gotData.html).attr('id');
            let title = $(`#${containerId}`).attr('title');
            if(typeof title === 'undefined' || title === '')
                title = 'Editar los Parámetros del Sistema';
            iacParam._fillData(containerId, gotData.gIAParametros);
            iacParam._openDialog(containerId, title, true);
        }).fail(function( jqXHR, textStatus ) {
            alerta_error('Problema al leer los parámetros', textStatus);
        });
    },

    /**
     * Pone el valor (o checked, selected) a los inputs dentro de containerId cuyo id sea un key en params
     * <input id='input_id' value='params[input_id'] >.
     *
     * @param {string} containerId
     * @param {object} params
     */
    _fillData: function(containerId, params) {
        let $container = $(`#${containerId}`);
        $("INPUT[type='checkbox']", $container).each(function(){
            this.checked = false;
        });
        $("INPUT[type='radio']", $container).each(function(){
            this.checked = false;
        });
        for(let key in params)
            if(params.hasOwnProperty(key)) {
                let elem = $(`#${key}`, $container);
                if(elem.length === 0)
                    continue;
                switch(elem.attr('type')) {
                    case 'checkbox':
                        elem.prop('checked', iacParam._value2Checked(params[key]))
                        break;
                    case 'radio':
                        $('INPUT[name="' + key + '"][value="' + params[key] + '"]').
                        prop('checked','checked');
                        break;
                    default:
                        if(elem.hasClass('selectized')) {
                            elem.selectize()[0].selectize.setValue(data[key]);
                            break;
                        }
                        if(elem.hasClass('multiselect')) {
                            elem.val(params[key]);
                            break;
                        }
                        if(elem.hasClass('hasDatePicker') || elem.hasClass('datepicker')) {
                            elem.datepicker('setDate', params[key]);
                            break;
                        }
                        if(typeof elem.data('autoNumeric') === 'object') {
                            elem.autoNumeric('set', params[key]);
                        }
                        elem.val(params[key]);
                }
            }
    },

    _openDialog: function(containerId, title) {
        $(`#${containerId}`).dialog({
            title: '<i class="fa-regular fa-gear-complex fa-spin"></i>&nbsp;&nbsp;' + title,
            autoOpen: true,
            modal: true,
            closeOnEscape: false,
            width: "auto",
            open: function(){
                if(typeof iacParam_openDialog === "function")
                    iacParam_openDialog();
            },
            close: function () {
                if(typeof iacParam_save === "function")
                    iacParam_save();
                else
                    iacParam.save(containerId, title);
                $(this).remove();
            },
            buttons: {
                'Cerrar': function () {
                    $(`#${containerId}`).dialog("close");
                }
            }
        })
    },

    save: function(containerId) {
        let data = {accion:'save' };
        let $container = $(`#${containerId}`);
        console.log("containerId", containerId)
        // lee valores
        $("INPUT", $container).each(function(){
            let elem = this, $elem = $(this);
            switch($elem.attr('type')) {
                case 'checkbox':
                    if(elem.checked)
                        data[elem.name] = elem.value;
                    break;
                case 'radio':
                    let val = $(`input[name='${elem.name}']:checked`).val();
                    if(typeof val !== 'undefined')
                        data[elem.name] = val;
                    break;
                default:
                    if($elem.hasClass('selectized')) {
                        data[elem.name] = $elem.selectize()[0].selectize.getValue();
                        break;
                    }
                    if($elem.hasClass('hasDatePicker') || $elem.hasClass('datepicker')) {
                        data[elem.name] = $elem.datepicker('getDate');
                        break;
                    }
                    if(typeof $elem.data('autoNumeric') === 'object') {
                        data[elem.name] = $elem.autoNumeric('get', params[key]);
                    }
                    data[elem.name] = $elem.val();
            }
        });
        console.log("dataToSend", data);
        // guarda valores
        $.ajax({
            url:'../backoffice/ajax/iacParam_acciones.php',
            method:'POST',
            cache:false,
            dataType:'json',
            data:data
        }).done(function( gotData ) {
            if(gotData.message) {
                alerta_error('Problema al guardar', gotData.message);
            }
        }).fail(function( jqXHR, textStatus ) {
            alerta_error('Problema al guardar', textStatus);
        })
    },

    _value2Checked: function(value) {
        return !(typeof value === 'undefined' || value === '' || value === null || value === '0' || value === 0)
    },

    dialogParams: function(el) {
        let $el = $(el);
        let divIdParams = 'dab_parametros';
        if($(`#${divIdParams}`).length) {
            $(`#${divIdParams}`).remove();
            return;
        }
        $(`<div id='${divIdParams}'>`).dialog({
            title: $el.data('titulo'),
            modal: true,
            resizable: true,
            position: {
                my: "center bottom-20",
                at: "center top", },
            width: 600,
            closeOnEscape: true,

            open: function( ) {
                iacParam.getParams($el.data('tema'), $el.data('subtema'), divIdParams)
            },
            close: function() {$(this).remove();},
            buttons: {
                'Guardar': function() {
                    let validate = validateInputValues(divIdParams);
                    if(validate){
                        parametros_save(divIdParams);
                        $(this).dialog("close");
                    }
                },
                "Cancelar": function() {
                    $(this).dialog("close");  // Cierra el diálogo
                }
            }
        });
    },
    mostrarConfig:function (elemento)  {
        event.preventDefault();
        tituloDialog = elemento.getAttribute("data-titulo");
        divIdParams = elemento.getAttribute("data-divparam");
        subtema = elemento.getAttribute("data-subtema");
        set_class = elemento.getAttribute("data-setclass");
        $("#"+divIdParams).dialog({
            title: tituloDialog,
            modal: true,
            resizable: true,
            position: {
                my: "center bottom-20",
                at: "center top", },
            width: 950,
            height: 400,
            closeOnEscape: true,
            open: function( ) {
                iacParam.getParamsv2('nota_bodega',subtema,divIdParams, set_class)
            },
            buttons: {
                'Guardar': function() {
                    let validate = validateInputValues(divIdParams)
                    if(validate){
                        parametros_save_v2(divIdParams);
                        $(this).dialog("close");
                    }
                },
                "Cancelar": function() {
                    $(this).dialog("close");  // Cierra el diálogo
                }
            }
        });
    },
    getParamsv2: function(tema, subtema, divIdParams, set_class = ''){
        $.ajax({
            url:'../backoffice/ajax/iacParam_acciones.php',
            method:'POST',
            data:{
                accion:'getParams',
                tema: tema,
                subtema: subtema
            }
        }).done(function( response ) {
            if( response.code !== 200  || typeof response.parametros !== 'object') {
                ia.alertError(response.message || "Error Inesperado", "Error al Leer los Parámetros");
                try { $("#" + divIdParams).dialog('close'); } catch(er) {}
                return;
            }
            createmultipleForm(response.parametros, divIdParams, set_class);
        }).fail(function( jqXHR, textStatus ) {
            console.log("fail", arguments)
            ia.alertError(textStatus, "Error al Leer los Parámetros");
            try{$("#" + divIdParams).dialog('close');} catch(er) {}
        });
    },
    getParams: function(tema, subtema, divIdParams){
        $.ajax({
            url:'../backoffice/ajax/iacParam_acciones.php',
            method:'POST',
            data:{
                accion:'getParams',
                tema: tema,
                subtema: subtema
            }
        }).done(function( response ) {
            if( response.code !== 200  || typeof response.parametros !== 'object') {
                ia.alertError(response.message || "Error Inesperado", "Error al Leer los Parámetros");
                try { $("#" + divIdParams).dialog('close'); } catch(er) {}
                return;
            }
            createForm(response.parametros, divIdParams);
        }).fail(function( jqXHR, textStatus ) {
            console.log("fail", arguments)
            ia.alertError(textStatus, "Error al Leer los Parámetros");
            try{$("#" + divIdParams).dialog('close');} catch(er) {}
        });
    }
}

Object.freeze(iacParam);
