
let version = "2024-10-26 11:02:00a___________________________________";
// console.log(`worker_time.js version=${version}`);
let inputGetLastModified;
let inputTotalCountBodega;
let intervals = {};
/*
    ejemplo
    worker.postMessage({ type: 'GET_LAST_MODIFIED', payload: {tables: ['nota_bodega'], interval: 1000*10 , inicio: 'date-string y-m-d H:i:s'} })
        Manda postMessage cada que cambie el MAX(ultimo_cambio) de las tablas de payload.tables desde la fecha inicio, con las tablas que cambiaron.
    worker.postMessage({ type: 'GET_LAST_MODIFIED', stop:true}); // ya no trae datos del server ni manda mensaje aqui.
    worker.postMessage({ type: 'GET_LAST_MODIFIED', resume:true}); // vuelve a traer datos del server desde donde se quedo.
    @TODO worker.postMessage({ type: 'GET_LAST_MODIFIED', restart:true}); // detiene, trae, pone fecha de ahora y reinicia traer datos del servidor.

 */
onmessage = function(e) {
    const message = e.data;
    if(message.stop) {
        console.log(`worker_time.js type=${message.type} detiene envíar al servidor`, message);
        if(intervals.hasOwnProperty(message.type) && intervals.hasOwnProperty(message.type)) {
            clearInterval(intervals[inputGetLastModified.type]);
            delete(intervals[inputGetLastModified.type]);
        }
        return;
    }

    switch(message.type) {
        case 'GET_LAST_MODIFIED':
            if(!message.resume) {
                inputGetLastModified = {
                    type: message.type,
                    inicio: message.payload.inicio,
                    interval: message.payload.interval,
                    tables: message.payload.tables,
                }
                inputGetLastModified.ahora = inputGetLastModified.inicio;
                inputGetLastModified.tablas_usar = {};
                for(let t in inputGetLastModified.tables || [])
                    inputGetLastModified.tablas_usar[inputGetLastModified.tables[t]] = inputGetLastModified.inicio;
            }
            if(intervals.hasOwnProperty(message.type)) {
              clearInterval(intervals[message.type]);
              delete(intervals[message.type]);
            }
            intervals[message.type] =  setInterval(procesaGetLastModified, inputGetLastModified.interval );
            break;
        case 'TOTAL_COUNT_BODEGA':
            inputTotalCountBodega = {
                type: message.type,
                bodega_id: message.payload.bodega_id,
                es_verificacion: message.payload.es_verificacion,
                bodega_verificador_id: message.payload.bodega_verificador_id,
            };
            procesaTotalCount();
            break;
        default:
            console.error('worker_time.procesaGetLastModified inputGetLastModified.type desconocido', inputGetLastModified);
    }
};

function procesaGetLastModified() {
    fetch('../backoffice/ajax/worker_time_acciones.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(inputGetLastModified),
        cache: 'no-cache'
    })
    .then(response => response.json())
    .then(data => {
        if(!data.status) {
            console.error("worker_time_acciones.php regreso error", data);
            return;
        }
        let hasNewData = false;
        let newData = {};
        for(let t in data.times) {
            if(inputGetLastModified.tablas_usar.hasOwnProperty(t)) {
                if(data.times[t] > inputGetLastModified.tablas_usar[t] ) {
                    hasNewData = true;
                    inputGetLastModified.tablas_usar[t] = newData[t] = data.times[t];
                } else
                    inputGetLastModified.tablas_usar[t] = data.times[t];
            }
        }
        if (hasNewData)
            postMessage({ type: 'GET_LAST_MODIFIED', succes: true, data: newData, input: inputGetLastModified });
    })
    .catch(error => {
        console.error("worker_time_acciones.procesaGetLastModified fetch error", error);
    });
}


function procesaTotalCount() {
    fetch('../backoffice/ajax/worker_time_acciones.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(inputTotalCountBodega),
        cache: 'no-cache'
    })
        .then(response => response.json())
        .then(data => {

            if (!data.status) {
                console.error("worker_time_acciones.php regreso error", data);
                return;
            }

            postMessage({ type: 'TOTAL_COUNT_BODEGA', succes: true, totals: data, input: inputTotalCountBodega });

        })
        .catch(error => {
            console.error("worker_time_acciones.procesaGetLastModified fetch error", error);
        });
}
