<!DOCTYPE html>
<html lang="es-mx">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Cache Ejemplo</title>
    <style>
        table {border-collapse: collapse}
        td {border:1px silver solid;vertical-align:top;text-align: left;padding:0.5em}
    </style>
<head>
<body>
<table>
    <thead><tr><th>Run<th>Code
    <tbody>
    <tr><td>
<?php
error_reporting(E_ALL);
ini_set('display_errors',"1");
ini_set('ignore_repeated_errors', "1");
ini_set("date.timezone", "America/Mexico_City");
require( __DIR__ . '/../Cacher.php');

// en config php
    Cacher::init(
       null, // path a donde se guardan los archivos cacheados __DIR__ . '/cachedContent/',
        include 'cacheArrayDefinition.php', // array de definiciones
        60 * 5 // 5 min 60 * 5,  12 horas = 60 * 60 * 12
    );

// pedir el archivo
    $pacaEnPhp = Cacher::get('paca.php'); // si no existe o expiro lo genera y regresa el valor
    $pacaEnJson = Cacher::get('paca.json'); // si no existe o expiro lo genera y regresa el valor

    echo "<hr>Por ejemplo para 'paca' => Cacher::def('paca', Cacher::ENCODE_PHP | Cacher::ENCODE_JSON),
            <ul>
            <li>\$pacaEnPhp = Cacher::get('paca.php'); // si no existe o expiro lo genera y regresa el valor</li>
            <p>\$pacaEnPhp=" . var_export($pacaEnPhp, true);

    echo "<li>\$pacaEnJson = Cacher::get('paca.json'); // si no existe o expiro lo genera y regresa el valor</li>
            <p>\$pacaEnJson=" . var_export($pacaEnJson, true)
        . "</ul>";

// cuando cambia forzar el cambio
    $ok = Cacher::generate('paca'); // lama su callback
    // o manualmente
    // $ok =  Cacher::set('paca', ['nuevo_array', 'no llama el callback']);

$pacaEnPhp = Cacher::get('paca.php'); // si no existe o expiro lo genera y regresa el valor
$pacaEnJson = Cacher::get('paca.json'); // si no existe o expiro lo genera y regresa el valor
echo "<hr>Despues de forsar el cambio:
            <ul>
            <li>\$pacaEnPhp = Cacher::get('paca.php'); // si no existe o expiro lo genera y regresa el valor</li>
            <p>\$pacaEnPhp=". var_export($pacaEnPhp, true);
        echo "<li>\$pacaEnJson = Cacher::get('paca.json'); // si no existe o expiro lo genera y regresa el valor</li>
            <p>\$pacaEnJson=" . var_export($pacaEnJson, true)
            . "</ul>";

// slatarse al generador via callbacks, un archivo no definido en el array del init (solo casos excepcionales)
    $ok = Cacher::set('gatos.html', '<h1>Gatos</h1>');
    $ok = Cacher::get('gatos.html', 'No encontre gatos.html');


// instrucciones para generadores
    function dame() { return Date('Y-m-d G:i:s');}

    function paca() { return ['array'=>2.7172, 'pi'=>3.14159211, 'do', 'pacaaaa', 'now'=>new DateTime()]; }
?><td>
<pre>
require('../Cacher.php');

// en config php
    Cacher::init(
       null, // path a donde se guardan los archivos cacheados __DIR__ . '/cachedContent/',
       include 'cacheArrayDefinition.php',
       60 * 5 // 5 min, para el ejemplo = 60 * 5,  12 horas = 60 * 60 * 12
    );

// pedir el archivo
    $pacaEnPhp = Cacher::get('paca.php'); // si no existe o expiro lo genera y regresa el valor
    $pacaEnJson = Cacher::get('paca.json'); // si no existe o expiro lo genera y regresa el valor

    echo "&lt;hr>Por ejemplo para 'paca' => Cacher::def('paca', Cacher::ENCODE_PHP | Cacher::ENCODE_JSON),
            &lt;ul>
            &lt;li>\$pacaEnPhp = Cacher::get('paca.php'); // si no existe o expiro lo genera y regresa el valor&lt;/li>
            &lt;p>\$pacaEnPhp=" . var_export($pacaEnPhp, true);

    echo "&lt;li>\$pacaEnJson = Cacher::get('paca.json'); // si no existe o expiro lo genera y regresa el valor&lt;/li>
            &lt;p>\$pacaEnJson=" . var_export($pacaEnJson, true)
        . "&lt;/ul>";

// cuando cambia forzar el cambio
    $ok = Cacher::generate('paca'); // lama su callback
    // o manualmente
    // $ok =  Cacher::set('paca', ['nuevo_array', 'no llama el callback']);

    $pacaEnPhp = Cacher::get('paca.php'); // si no existe o expiro lo genera y regresa el valor
    $pacaEnJson = Cacher::get('paca.json'); // si no existe o expiro lo genera y regresa el valor
    echo "&lt;hr>Despues de forzar el cambio:
        &lt;ul>
        &lt;li>\$pacaEnPhp = \Cacher::get('paca.php'); // si no existe o expiro lo genera y regresa el valor&lt;/li>
        &lt;p>\$pacaEnPhp=" . var_export($pacaEnPhp, true);

     echo "&lt;li>\$pacaEnJson = \Cacher::get('paca.json'); // si no existe o expiro lo genera y regresa el valor&lt;/li>
            &lt;p>\$pacaEnJson=" . var_export($pacaEnJson, true) .
            "&lt;/ul>";

// slatarse al generador via callbacks, un archivo no definido en el array del init (solo casos excepcionales)
    $ok = Cacher::set('gatos.html', '&lt;h1>Gatos&lt;/h1>');
    $ok = Cacher::get('gatos.html', 'No encontre gatos.html');


// funciones/metodos para generadores
    function dame() { return Date('Y-m-d G:i:s'); }

    function paca() { return ['array'=>2.7172, 'pi'=>3.14159211, 'do', 'pacaaaa', 'now'=>new DateTime()]; }
</pre>
</tbody>
</table>
</body>
</html>

