<?php

class ClientesSaldo extends BaseModel {
    public static function prepare_query_select($return_parts = false): array|string
    {
        $tabla = param('iactbl');
        $per_page = param('rows', 50);

        $para_votos = param('para_votos', 'No');
        $iac_usrid = param('iac_usr_id');
        $campos_puede_votar = '';
        if ($para_votos === 'Si' && !empty($iac_usrid)) {
            $campos_puede_votar.=", 'Si' puede_votar";
        }

        $campo_propietario = ", (SELECT GROUP_CONCAT(concat(pd.iac_usr_id, '_', u.nombre) SEPARATOR '#') FROM propietario_departamento pd JOIN iac_usr u USING (iac_usr_id) WHERE pd.departamento_id = $tabla.departamento_id) as propietario";

        $partes = [
            'select' => "SELECT $tabla.*, t.nombre as torre$campos_puede_votar$campo_propietario",
            'from' => "FROM $tabla LEFT JOIN torre t on t.torre_id = $tabla.torre_id",
            'where' => self::prepare_where(),
            'order_by' => "",
            'limit' => "LIMIT 0, $per_page"
        ];

        // Preparando el limit
        $page = param('page', 1);
        $page_anterior = $page-1;
        $desde = 0;
        if ($page_anterior>0) {
            $desde = $page == 1?0:($per_page*$page_anterior);
        }

        $partes['limit'] = "LIMIT $desde, $per_page";

        // Preparando el order
        $sidx = param('sidx');
        $sort = param('sord');
        if (!empty($sidx)) {
            $partes['order_by'] = "ORDER BY $sidx $sort";
        }

        if ($return_parts)
            return $partes;

        return implode(" ", $partes);
    }
    public static function prepare_where(): string
    {
        $iacwhere = param('iacwhere');
        $wheres = [];

        // Add user-specific filtering logic
        $iac_usr_id = $_SESSION['usuario_id'] ?? '';
        $superUser = esSuperUser();

        // If not a superuser, add the iac_usr_id filter
        if (!$superUser && !empty($iac_usr_id)) {
            $wheres[] = "departamento_id IN (
            SELECT pd.departamento_id 
            FROM propietario_departamento pd 
            WHERE pd.iac_usr_id = '$iac_usr_id'
        )";
        }

        $para_votos = param('para_votos', 'No');
        $iac_usrid = param('iac_usr_id');

        if ($para_votos === 'Si' && !empty($iac_usrid)) {
            $elect_me_tranfirieron = "SELECT ptv.iac_usr_id_transfiere FROM propietario_transferencia_voto ptv WHERE ptv.iac_usr_id_recibe = '$iac_usrid' AND ptv.activo = 'Si' AND ptv.aceptado = 'Si'";

            $select_depas_tranfer_votos = "SELECT pd.departamento_id FROM propietario_departamento pd WHERE pd.iac_usr_id IN ($elect_me_tranfirieron) AND pd.activo = 'Si'";

            $wheres[] = "departamento_id IN ($select_depas_tranfer_votos)";
        }


        if (!empty($iacwhere))
            $wheres[] = $iacwhere;

        $iacwhere = implode(" AND ", $wheres);
        $where_filters = self::apply_filters();

        $wheres_concat = [];
        if (!empty($iacwhere))
            $wheres_concat[] = "($iacwhere)";

        if (!empty($where_filters))
            $wheres_concat[] = $where_filters;

        $where = "";
        if (!empty($wheres_concat))
            $where = "WHERE ".implode(" AND ", $wheres_concat);

        return $where;
    }
    public static function apply_filters(&$wheres=[]): string
    {
        $filters = param('filters');
        $iacase = null;
        $tablePrefix='';
        $where='';
        $tabla = param('iactbl');
        if (!empty($filters)) {
            $tmp = '';
            $f = @json_decode($filters);
            $json = json_last_error();
            if($json) {
                if($json === JSON_ERROR_DEPTH)
                    $jsonerr = "\r\nJSON ERROR: The maximum stack depth has been exceeded";
                elseif($json === JSON_ERROR_STATE_MISMATCH)
                    $jsonerr = "\r\nJSON ERROR: Invalid or malformed JSON";
                elseif($json === JSON_ERROR_CTRL_CHAR)
                    $jsonerr = "\r\nJSON ERROR: Control character error, possibly incorrectly encoded";
                elseif($json === JSON_ERROR_SYNTAX)
                    $jsonerr = "\r\nJSON ERROR: Syntax error";
                elseif($json === JSON_ERROR_UTF8)
                    $jsonerr = "\r\nJSON ERROR: Malformed UTF-8 characters, possibly incorrectly encoded";
                else
                    $jsonerr = "\r\nJSON ERROR: unkown $json";
                ia_errores_a_dime($jsonerr);
            }

            if(isset($f->groupOp))
                $op = $f->groupOp;
            else
                $op = 'AND';
            if($op != 'AND' && $op != 'OR')
                $op = 'AND';

            if( $f->rules ) {
                foreach( $f->rules as $rule ) {
                    $tiene=$rule->data;
                    if (!is_array($rule->data))
                        $tiene=trim($rule->data);

                    if( $tiene !== '' || ( $rule->op === 'nu' || $rule->op === 'nn' || $rule->op === 'nu_bodega' || $rule->op === 'nn_bodega' ) ) {
                        if ($tiene === '@_#empty#_@') // paa indicar que esta vacio
                            $tiene = '';

                        if($rule->field === 'torre')
                            $rule->field = 't.nombre';

                        if($rule->field === 'propietario')
                            $rule->field = "(SELECT GROUP_CONCAT(concat(pd.iac_usr_id, '_', u.nombre) SEPARATOR '#') FROM propietario_departamento pd JOIN iac_usr u USING (iac_usr_id) WHERE pd.departamento_id = $tabla.departamento_id)";


                        where_op($tmp,$op);
                        $prefix = strpos($rule->field,'.') === false ? $tablePrefix : '';
                        if($rule->op  ===  'eq')
                            $tiene = str_replace(",","",$tiene);
                        $oldName = $rule->field;
                        $rule->field = solveVirtualField($rule->field);
                        if($oldName === $rule->field && $iacase !== null && !empty($iacase->campos[$rule->field]['virtual_sql'])  ) {
                            $tmpFieldName = preg_replace('/\)\s*as\s+[\'a-z0-9]+\s*$/miUuS', ")",
                                $iacase->campos[$rule->field]['virtual_sql']);
                            $tmpFieldName =  str_replace("as " . $rule->field,"", $tmpFieldName);

                            $tmp.=where_clause($tmpFieldName,$rule->op,$tiene);
                            continue;
                        }

                        $tiene = str_replace("," ,"", $tiene);
                        $apps_de_nota_bodega = ['nota_bodega', 'nota_bodega_verificacion'];
                        if ($iacase !== null && in_array($iacase->table, $apps_de_nota_bodega) && ($rule->field === 'numero')) {
                            $numero_search = $tiene;
                            $parts = explode("-", $numero_search);
                            $contiene_ajuste = str_contains($numero_search, strtolower('ajuste'));
                            if (count($parts)>1 || $contiene_ajuste || !is_numeric($parts[0]))
                                $rule->op = 'cn';

                            if (count($parts) == 1 && is_numeric($parts[0])) {
                                $rule->field = 'numero_real';
                                // $valor = strit("$numero_search%");
                                // $tmp.= fieldit($prefix.$rule->field). " LIKE $valor";
                                // continue;
                            }
                        }
                        if(strpos($rule->field,"remarks") !== false) {
                            $tmp_tiene = preg_replace_callback('/(\d+(.|,))+(\d)+/m', function ($matches) {
                                $monto = echonf(limpiaCantidad($matches[0]), true);
                                return substr($monto, -3) == ".00" ? substr_replace($monto ,"", -3) : $monto;
                            }, $tiene);

                            if ($tmp_tiene != $tiene) {
                                $tiene_where=where_clause($prefix.$rule->field,$rule->op,$tiene);
                                where_op($tiene_where, 'OR');
                                $tiene_where .= where_clause($prefix . $rule->field, $rule->op, $tmp_tiene);


                                $tmp .= "($tiene_where)";
                            }
                            else
                                $tmp.=where_clause($prefix.$rule->field,$rule->op,$tiene);
                        }
                        else
                            $tmp.=where_clause($prefix.$rule->field,$rule->op,$tiene);


                        //echo "<li>$gParams[iactbl]";
                        if(($rule->field === 'cliente' || $rule->field === 'cliente_id') && isset($iacase) && !empty($iacase) && ($iacase->table === 'cheque' || $iacase->table === 'pagare' || $iacase->table === 'vale' || $iacase->table === 'compra')) {
                            $tmpNombre = where_clause('nombre',$rule->op,$tiene);
                            $tmp = "($tmp OR cliente_id IN(SELECT cliente_id FROM cliente WHERE $tmpNombre ))";
                        }
                    }
                }
                if($tmp!='') {
                    where_op($where,'AND');
                    $where.="($tmp)";
                    return $where;
                }
            }
        }
        return '';
    }

    public static function update($departamento_id, $values): bool|int
    {
        $existe = ia_singleread("SELECT 1 FROM departamento WHERE departamento_id = ".strit($departamento_id))==1;
        if (!$existe)
            return 404;

        if (self::validadatos($values) !== true)
            return 400;

        $values['ultimo_cambio'] = date('Y-m-d H:i:s');
        $values['ultimo_cambio_por'] = $_SESSION['usuario_id'];

        $sql_builder = new \Iac\inc\sql\IacSqlBuilder();
        $update = $sql_builder->update('departamento', $values, ['departamento_id'=>$departamento_id]);

        if (ia_query($update))
            return 409;

        self::genera_historian($departamento_id, 'update');
        return true;
    }

    static function validadatos($values): bool|array
    {
        $errors = [];
        if (empty($values['torre_id']))
            $errors[] = "La torre es un dato obligatorio";
        else {
            $existe_torre = ia_singleread("SELECT 1 FROM torre WHERE torre_id = ".strit($values['torre_id']))==1;
            if (!$existe_torre)
                $errors[] = "La torre no existe";
        }

        if (empty($values['piso']))
            $errors[] = "El piso es requerido";

        if (!empty($values['telefono'])) {
            if (!is_numeric($values['telefono']))
                $errors[] = "No es teléfono valido";
        }
        if (!empty($values['correo'])) {
            if (!filter_var($values['correo'], FILTER_VALIDATE_EMAIL))
                $errors[] = "No es un correo valido";
        }

        if (empty($values['numero_escritura']))
            $errors[] = "El número de escritura es requerido";

        if (empty($errors))
            return true;

        self::$msg_error = "Se encontraron los siguientes errores:<ul><li>".implode("<li>", $errors);
        return $errors;
    }

    static function genera_historian($id, $accion, $motivo = ''): void
    {
        $historian = new Historian('departamento', ['departamento_id']);
        $id_it = strit($id);
        $method = __METHOD__;
        $record = ia_singleton("SELECT /*$method*/ * FROM departamento WHERE departamento_id = $id_it");
        $historian->set($accion, ['departamento_id' => $id], $record, $motivo);
    }
    static function genera_historian_doctos($id, $accion, $motivo = ''): void
    {
        $historian = new Historian('departamento', ['departamento_id']);
        $id_it = strit($id);
        $method = __METHOD__;
        $record = ia_singleton("SELECT /*$method*/ * FROM departamento WHERE departamento_id = $id_it");
        $record['files'] = ia_sqlArrayIndx("SELECT /*$method*/ * FROM documento WHERE parent_id = $id_it");
        $historian->set($accion, ['departamento_id' => $id], $record, $motivo);
    }
}