$vitex_globales['hot_keys_onini_load'] = false;
const clientes_saldo = {
    url_acciones: '',
    prefix_grid_action: '',
    viewer_file: {
        docs: '<iframe src="" type="" class="card-img-top file-viewer" style="height: 250px;"></iframe>',
        img: '<img src="" alt="img documento" class="card-img-top file-viewer h-100">'
    },
    get_estado_cuenta: function (id, method)
    {
        let request = {
            url: getUrlForAjax("cliente_acciones"),
            data: {
                accion: 'estado_cuenta_cliente',
                cliente_id: id,
            }
        };

        jqAjax(request, function (res) {
            _app_.alert({
                id: 'doctos_detalle',
                titulo: 'Estado de Cuenta',
                mensaje: res.estado_cuenta_cliente_html,
                options_btn: {
                    textButtonCancel: 'Cancelar',
                },
                on_open: function (dialog) {
                    $("#saldo_cliente_tabla").show().css('position', 'relative').addClass('w-100');
                    $('#saldo_cliente_tabla_maximize').remove();
                    $('#saldo_cliente_tabla_toolbar').show();
                    $('#saldo_cliente_nombre').show();

                    $("div[id^='doctos_detalle']", dialog).css({
                        'max-height': 'unset',
                        'width': 'unset',
                    }).addClass('row px-2');

                    $("div[id^='doctos_detalle']", dialog).find('div').addClass('col-12 mb-3');

                    let _config = {
                        print: false,
                        new_window: false,
                        'query_selector':'#saldo_cliente_tabla',
                        'query_selector4pdf_table':'',
                        'query_selector_wrapper':'#saldo_cliente_tabla',
                        'image_copy_alert_element': $('.modal-content', dialog)[0],
                        image_copy_alert_element_pos: 'top',
                        // 'pre_func': pre_func,
                        // 'post_func': post_func,
                        'hideOnCopy': false,
                        'cliente_nombre_ocultar': false,
                        'fileName': "Estado de Cuenta "+res.cliente.nombre,
                        'wrapper_width': $("#saldo_cliente_tabla").css('width'),
                    };
                    cliente_saldo_exporter = new canvas_exporter(_config);
                    $("#saldo_cliente_tabla_toolbar").html(cliente_saldo_exporter.toolBar("#saldo_cliente_tabla",{},"cliente_saldo_exporter")).show();
                },
            });
        });
    },

    get_details: function(id)
    {
        let request = {
            url: getUrlForAjax("cliente_acciones"),
            data: {
                accion: 'cliente_saldos',
                cliente_id: id,
            }
        };

        jqAjax(request, function (res) {
            console.log(res);
            let saldo = res.cliente;
            let html = `
            <h4 class="${saldo.saldo_cliente_moneda_id=='1'?'txt_color_PESOS':'txt_color_USD'}">SALDO: ${saldo.saldo_cliente_formateado}</h4>
            <table class="table">
                <thead class="thead-light">
                    <tr>
                        <th></th>
                        <th>PESOS</th>
                        <th>USD</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <th>CHEQUE</th>
                        <td class="txt_color_PESOS text-right">${CommaFormatted(saldo.saldo_cheques_pesos)}</td>
                        <td class="txt_color_USD text-right">${CommaFormatted(saldo.saldo_cheques_usd)}</td>
                    </tr>
                    <tr>
                        <th>PAGARÉ</th>
                        <td class="txt_color_PESOS text-right">${CommaFormatted(saldo.saldo_pagares_pesos)}</td>
                        <td class="txt_color_USD text-right">${CommaFormatted(saldo.saldo_pagares_usd)}</td>
                    </tr>
                    <tr>
                        <th>VALE</th>
                        <td class="txt_color_PESOS text-right">${CommaFormatted(saldo.saldo_vales_pesos)}</td>
                        <td class="txt_color_USD text-right">${CommaFormatted(saldo.saldo_vales_usd)}</td>
                    </tr>
                    <tr>
                        <th>NOTAS</th>
                        <td class="txt_color_PESOS text-right">${CommaFormatted(saldo.saldos_notas_pesos)}</td>
                        <td class="txt_color_USD text-right">${CommaFormatted(saldo.saldos_notas_usd)}</td>
                    </tr>
                    <tr>
                        <th>GASTOS</th>
                        <td class="txt_color_PESOS text-right">${CommaFormatted(saldo.saldos_gastos_pesos)}</td>
                        <td class="txt_color_USD text-right">${CommaFormatted(saldo.saldos_gastos_usd)}</td>
                    </tr>
                </tbody>
                <tfoot class="thead-light d-none">
                    <tr>
                        <th>TOTAL</th>
                        <td class="txt_color_PESOS text-right">${CommaFormatted(saldo.saldo_pesos)}</td>
                        <td class="txt_color_USD text-right">${CommaFormatted(saldo.saldo_usd)}</td>
                    </tr>
                </tfoot>
            </table>`;

            _app_.alert({
                id: 'saldo_detalle',
                titulo: 'Detalle del Saldos',
                mensaje: html,
                options_btn: {
                    textButtonCancel: 'Cerrar'
                },
            });
        });
    },

    jqgrid: {
        colModel: [],
        table: '',
        pk_field: '',
        iacwhere_: '',
        init: function (table, pk_fiel, config_grid = {}) {
            const self = this;
            this.table = table;
            this.pk_field = pk_fiel;
            this.prepare_colModel();

            gridhandler = $('#table_registros');
            gridhandler.data('firstLoad',true);

            let iacwhere = "( saldo_total_ventas_pesos > 0.00 OR saldo_total_ventas_usd > 0.00 OR saldo_compras_pesos > 0.00 OR saldo_compras_usd > 0.00  )";

            let configJqgrid = {
                url: getUrlForAjax('jqgrid_read'),
                // loadonce: false,
                regional: 'en',
                datatype: 'local',
                data: [],
                postData: {
                    accion: 'jqgrid_read',
                    iact: 'iacase',
                    iactbl: this.table,
                    iacc: 'app_clientes_saldos',
                    iacpk: this.pk_field,
                    iacwhere: iacwhere,
                    iaccols: 'cliente_id,nombre,tienda_id,saldo_cliente_moneda_id,saldo_cliente,ultima_compra,doc_mas_antiguo,saldo_cheques_pesos,saldo_pagares_usd,saldo_vales_pesos,saldo_vales_usd,saldo_pagares_pesos,ultimo_pago,saldo_cheques_usd,saldo_compras_pesos,cuantos_cheques,cuantos_pagares,cuantos_compras,cuantos_vales,tipo_cambio,saldo_cliente_usd,saldo_compras_usd,saldo_cliente_moneda_id_calc,saldo_total_ventas_pesos,saldo_total_ventas_usd,cheque_mas_antiguo,pagare_mas_antiguo,vale_mas_antiguo',
                    iaccolse: '',
                    /*  iaccols: cols.join(","),
                     iaccolse: 'iacsel,actions' */
                },
                colModel: this.colModel,
                sortname:"IF((doc_mas_antiguo is null), '2030-12-31', doc_mas_antiguo)",
                sortorder: "ASC",
                rowattr: function(rd, rowData) {
                    // if(rd.existencia_rollos < 0 || rd.existencia_quantity < 0 || rd.quantity_bodega < 0)
                    //     return {"style":"color:red"};
                },
                beforeProcessing: function(data, status, xhr){
                    //Ph. 14-04-2025
                    //gzipping rows
                    data.rows = decompressPayload(data.rows);
                },
                loadComplete: function (data){
                    $gridParams = $(this).getGridParam();
                    if (gridhandler.data('firstLoad')) {
                        gridhandler.data('firstLoad',false);
                        initAutoCompleteToolBarjqGrid();

                        vx_asyncFunction(function () {
                            gridhandler.jqGrid('setGridParam', {'datatype':'json'});
                            gridhandler.trigger('reloadGrid'); // para recargar toto el grid sin filtros
                            // gridhandler[0].triggerToolbar(); // para cuando se agrega un filtro desde el inicio
                        }, 10);
                        return false;
                    }

                    $('#loadingMask').fadeOut(350);
                    /* self.set_actions_rows(data.rows);
                    $('[data-toggle="tooltip"]').tooltip({
                        placement:'bottom',
                        container: gridhandler
                    }); *!/ */
                },
                sortable:true,
                name_reporst: 'Pasada Terceros',
                rowNum: 50,
                height: $(window).height()-200,
                // rownumbers : false,
            };

            let navConfig = {
                full_window: false,
                export_excel: false,
                export_pdf: false,
                print: false,
            };
            initJqGrig('#table_registros', configJqgrid, navConfig);

            if (_app_.isMobile()) {
                $('[id^=gs_]').change(function () {
                    setTimeout(function () {
                        gridhandler[0].triggerToolbar();
                    }, 100);
                });

                let tr_pager = $('#table_registros_pager table.ui-pg-table tr');
                tr_pager.addClass('row no-gutters')
                tr_pager.find('#table_registros_pager_left').addClass('col-2');
                tr_pager.find('#table_registros_pager_center').addClass('col-10').find('table').addClass('float-right');
                tr_pager.find('#table_registros_pager_right').addClass('col-12').attr('align', 'center');
            }
        },

        prepare_colModel: function ()
        {
            this.colModel = [
                {
                    name: this.pk_field,
                    index: this.pk_field,
                    key: true,
                    search: false,
                    hidden: true
                },
                {
                    name: 'nombre',
                    index: 'nombre',
                    label: 'Nombre',
                    search: true,
                    hidden: false,
                    comboBoxAutoComplete: {
                        busqueda_relajada: true,
                        dataUrl: "../../backoffice/json/clientes_saldos_nombre.html"
                    },
                    formatter: clientes_saldo.nombre_cliente_formatter,
                    BusquedaRapida: {
                        field: "cliente_id",
                        input: "cliente_id",
                        type: "ba_multi",
                        extraf: {filePath: "../../backoffice/json/clientes_saldos.html"}
                    }
                },
                {
                    name: 'tienda_id',
                    index: 'tienda_id',
                    label: 'Tienda',
                    align: 'center',
                    edittype: "select",
                    formatter: "select",
                    comboBoxAutoComplete: {
                        dataUrl: "../../backoffice/json/tienda.html"
                    },
                    BusquedaRapida: {
                        field: "tienda_id",
                        input: "tienda_id",
                        type: "ba_multi",
                        extraf: {filePath: "../../backoffice/json/tienda.html"}
                    },
                    editoptions: {
                        multiple: false,
                        size: 1,
                        value: {1: 'OFI', 2: 'CH', 3: 'GT', 4: 'JM', 5: 'LV', 6: 'SV', 7: 'UG', 8: 'AL', 9: 'SIM', 10: 'GDL', 13: 'PALACIOS (TIENDA)'}
                    },
                    search: true,
                    width: 70,
                },
                {
                    name: 'saldo_cliente_moneda_id',
                    index: 'saldo_cliente_moneda_id',
                    label: 'Moneda',
                    align: 'center',
                    edittype: "select",
                    formatter: "select",
                    search: true,
                    comboBoxAutoComplete: {dataUrl: '../../backoffice/json/moneda.html'},
                    BusquedaRapida: {
                        field: "saldo_cliente_moneda_id",
                        input: "saldo_cliente_moneda_id",
                        type: "ba_multi",
                        extraf: {filePath: "../../backoffice/json/moneda.html"}
                    },
                    editoptions: {
                        multiple: false,
                        size: 1,
                        value: {0: 'Seleccione', 1: 'PESOS', 2: 'USD'}
                    },
                    cellattr: "saldo_cliente_moneda_id",
                    width: 80,
                },
                {
                    name:'saldo_cliente',
                    index:'saldo_cliente',
                    label:'Saldo Combinado',
                    template:colFmt.decimal,
                    // width:150,classes:'bold txt15px',
                    cellattr: 'saldo_cliente_moneda_id',
                    width: 90,
                },
                {
                    name: 'ultima_compra',
                    index: 'ultima_compra',
                    label: 'Ultima Alta',
                    search: true,
                    template:colFmt.fecha
                },
                {
                    name: 'doc_mas_antiguo',
                    index: 'doc_mas_antiguo',
                    label: 'Debe desde',
                    search: true,
                    template:colFmt.fecha
                },
               /*  {
                    name: 'activo',
                    index: 'activo',
                    label: 'Activo',
                    align:'center',
                    template:colFmt.SiNo,
                    search: false,
                },
                {
                    name: 'alta_db',
                    index: 'alta_db',
                    label: 'Alta',
                    align:'center',
                    template:colFmt.timestamp,
                    search: false,
                },
                {
                    name: 'alta_por',
                    index: 'alta_por',
                    label: 'Alta por',
                    template:colFmt.text,
                    search: false,
                },
                {
                    name: 'ultimo_cambio',
                    index: 'ultimo_cambio',
                    label: 'Ultimo Cambio',
                    align:'center',
                    template:colFmt.timestamp,
                    search: false,
                },
                {
                    name: 'ultimo_cambio_por',
                    index: 'ultimo_cambio_por',
                    label: 'Ultimo Cambio por',
                    template:colFmt.text,
                    search: false,
                }, */
            ];
        },


        set_actions_rows: function (items = [])
        {
            console.log(iah);
            let url_full = window.location.href;
            const self = this;
            items.forEach(function (item) {
                let row_id = item[self.pk_field];
                var newDiv = $('<div>');
                let anchor_action = null;
                // Ver
                /* anchor_action = $('<a>', {
                    href: `../departamento/?id=${row_id}&iah=r`,
                    target: '_blank',
                    'class': 'btn btn-sm btn-info',
                    title: '<div class=\'alert alert-primary py-1 grid_tooltip_\'>Consultar registro</div>',
                    rel: 'opener referrer',
                    'data-toggle': 'tooltip',
                    'data-html': 'true'
                }).addClass('actions_col');
                anchor_action.append(`<i class="fa-icon fa-solid fa-eye text-white txt_1_3em"></i>`);
                anchor_action.appendTo(newDiv); */

                if (iah !== 'r') {
                    // Editar
                    anchor_action = $('<a>', {
                        href: clientes_saldo.prefix_grid_action+`?id=${row_id}&iah=e`,
                        target: '_blank',
                        'class': 'text-secondary ml-2',
                        title: '<div class=\'alert alert-secondary py-1 grid_tooltip_\'>Editar registro</div>',
                        rel: 'opener referrer',
                        'data-toggle': 'tooltip',
                        'data-html': 'true'
                    }).addClass('actions_col');
                    anchor_action.append(`<i class="fa-icon fa-solid fa-pen-to-square text-secondary txt_1_3em"></i>`);
                    anchor_action.appendTo(newDiv);

                    // Borrar
                    anchor_action = $('<a>', {
                        href: `javascript:departamento.handle_delete('${row_id}', true)`,
                        'class': 'text-danger ml-2',
                        title: '<div class=\'alert alert-danger py-1 grid_tooltip_\'>Eliminar registro</div>',
                        rel: 'opener referrer',
                        'data-toggle': 'tooltip',
                        'data-html': 'true'
                    }).addClass('actions_col');
                    anchor_action.append(`<i class="fa-icon fa-solid fa-trash-can text-danger txt_1_3em"></i>`);
                    anchor_action.appendTo(newDiv);
                }

                $('tr#' + row_id).find('td[aria-describedby="table_registros_actions"]').html(newDiv);
            });
        },

        delete_calculadora: function (row_id)
        {
            // let row_data =gridhandler.getRowData(row_id);
            let confirm = $(`<div class="modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-body p-0">
                            <div class="card">
                                <h4 class="card-header py-1">
                                    Confirma Eliminar Registro
                                    <button type="button" class="close border-secondary border rounded" data-dismiss="modal" aria-label="Close">
                                        <i class="fa-icon fa-solid fa-close"></i>
                                    </button>
                                </h4>
                                <div class="card-body p-2">
                                    <br>
                                    ¿Deseas eliminar el registro?
                                    <br>
                                    <br>
                                </div>
                                <div class="card-footer text-muted text-right py-1">
                                    <button type="button" class="btn btn-sm btn-primary p-1" id="btn_confirm_delete">Sí, Eliminar</button>
                                    <button type="button" class="btn btn-sm btn-secondary p-1" data-dismiss="modal" id="btn_cancel_delete">Cancelar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>`).modal();
            $('#btn_confirm_delete', confirm).click(function () {
                confirm.modal('hide');
                do_delete();
            });
            confirm.on('hidden.bs.modal', function (e) {confirm.remove();});

            function do_delete() {
                let request = {
                    url: getUrlForAjax('costos_contenedor_acciones'),
                    data: {
                        accion: 'delete_calculadora',
                        id: row_id
                    }
                };
                jqAjax(request, function (res) {
                    if (res.status) {
                        $d.notify('OK', (res.message||'Registro eliminado'), 'success');
                        gridhandler.trigger('reloadGrid');
                    }
                });
            }
        },

        delete_rows_selected: function ()
        {
            const ids = getGridVisibleSelectedIds(gridhandler);
            // const ids = getGridVisibleIds(gridhandler);
            if (empty(ids)) {
                return app.alert({
                    titulo: 'Alerta!',
                    mensaje: '<b>NO HAY REGISTROS SELECCIONADOS.</b><br>Seleccione registros para eliminar',
                    type: 'warning',
                });
            }
            const html = `<br>¿Deseas eliminar los registros seleccionados?<br><br>`;
            const confirm = app.alert({
                titulo: 'Eliminar registros',
                mensaje: html,
                type: 'ask',
                options_btn: {
                    textButtonConfirm: 'Sí, eliminar',
                    textButtonCancel: 'Cancelar',
                }
            });
            confirm.then(function () {
                let request = {
                    url: getUrlForAjax('costos_contenedor_acciones'),
                    data: {
                        accion: 'delete_calculadoras',
                        ids: ids
                    }
                };
                jqAjax(request, function (res) {
                    if (res.status) {
                        $d.notify('OK', (res.message||'Registros eliminados'), 'success');
                        gridhandler.trigger('reloadGrid');
                    }
                });
            });
        }
    },

    ia_hrefPropietario: function (cellvalue, options, rowObject){
        let propietarios = cellvalue.split("#");
        let anchors = [];
        propietarios.forEach(function (propietario) {
            let parts = propietario.split("_");
            anchors.push(`<a href="../propietario?id=${parts[0]}&iah=e" target="_blank">${parts[1]}</a>`);
        });
        return `<li>${anchors.join("<li>")}`;
    },

    nombre_cliente_formatter: function (cellvalue, options, rowObject)
    {
        return `<div data-value="${cellvalue}" style="position:relative;"><a href="javascript:clientes_saldo.get_estado_cuenta('${options.rowId}', 'dialog')" style="text-decoration: none">${cellvalue}</a><button type="button" class="btn btn-info float-right" onclick="clientes_saldo.get_details('${options.rowId}')"><i class="fa fa-info"></i></button></div>`
    },
};