<?php session_start();
if(empty($_SESSION) || empty($_SESSION['usuario_id']) || empty($_SESSION['usuario'])) {
    $_SESSION["usuario_id"] = 1999;
    $_SESSION["usuario"] = 'mobile';
}
?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Productos</title>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <script type="module" src="../js/existencia_por_bodega.js"></script>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            color: #333;
            width: 100%;
            margin: 0;
            padding: 0;
            overflow-x: hidden; /* Evita el desplazamiento horizontal */
        }

        .container {
            margin-top: 12%;
            width: 100%;
            box-sizing: border-box; /* Incluye padding y borde en el ancho */
            padding: 0 10px; /* Añade un poco de padding para evitar que el contenido toque los bordes */
        }

        .controls {
            display: flex;
            flex-direction: column;
            gap: 10px;
            padding: 10px;
            background-color: #f9f9f9;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            width: 100%;
            box-sizing: border-box; /* Incluye padding y borde en el ancho */
        }

        input {
            width: 100%; /* Ocupa el 100% del contenedor */
            padding: 10px;
            border: 2px solid #007bff;
            border-radius: 5px;
            font-size: 16px;
            margin-bottom: 10px;
            outline: none;
            transition: 0.3s ease;
            box-sizing: border-box; /* Incluye padding y borde en el ancho */
        }

        input:focus {
            border-color: #0056b3;
            background-color: #e9f5ff;
        }

        .ui-menu {
            list-style: none;
            padding: 0;
            margin: 0;
            background: #fff;
            border: 1px solid #ccc;
            max-height: 200px;
            overflow-y: scroll;
            width: 100%;
            z-index: 1000;
        }

        .ui-menu-item {
            padding: 8px;
            cursor: pointer;
            transition: background 0.2s ease;
        }

        .ui-menu-item:hover,
        .ui-state-active {
            background: #007bff;
            color: white;
        }

        .table-container {
            width: 100%;
            margin-top: 10px;
            overflow-x: hidden; /* Evita el desplazamiento horizontal */
        }

        #exiDriller {
            width: 100%;
            background-color: #fff;
            padding: 1rem;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            box-sizing: border-box; /* Incluye padding y borde en el ancho */
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
            background-color: white;
            table-layout: fixed; /* Asegura que la tabla no exceda el ancho del contenedor */
        }

        th, td {
            border: 1px solid #ccc;
            padding: 10px;
            text-align: center;
            word-wrap: break-word; /* Permite que el texto se divida en varias líneas si es necesario */
        }

        th {
            background-color: #007bff;
            color: white;
        }

        tfoot tr {
            background-color: #ddd;
            font-weight: bold;
        }

        tr.group-row {
            background-color: #ccc;
            font-weight: bold;
            text-align: center;
        }


        tr.color-header {
            background-color: #d7d7d7;
        }

        .ui-helper-hidden-accessible {
            display: none;
        }

        /* Estilos para la barra de navegación */
        .navbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #007bff;
            padding: 10px 15px;
            color: white;
            position: fixed;
            width: 100%;
            top: 0;
            left: 0;
            z-index: 1000;
            box-sizing: border-box;
            margin: 0;
        }


        .navbar .menu-toggle {
            font-size: 24px;
            cursor: pointer;
        }

        .navbar .menu-toggle:hover {
            color: #f8f9fa;
        }

        .navbar .home-btn {
            font-size: 24px;
            cursor: pointer;
        }

        .navbar .home-btn:hover {
            color: #f8f9fa;
        }

        /* Menú lateral */
        .sidebar {
            position: fixed;
            top: 0;
            left: -250px;
            width: 250px;
            height: 100%;
            background-color: #333;
            color: white;
            overflow-y: auto;
            transition: left 0.3s ease-in-out;
            padding-top: 50px;
        }

        .sidebar.active {
            left: 0;
        }

        .sidebar ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .sidebar ul li {
            padding: 10px;
            border-bottom: 1px solid #444;
        }

        .sidebar ul li a {
            color: white;
            text-decoration: none;
            display: block;
        }

        .sidebar ul li a:hover {
            background-color: #007bff;
            padding-left: 10px;
        }


        /*---------------------------------------*/


        .radio-container {
            display: flex;
            flex-direction: row; /* Cambia a fila para que los inputs estén uno al lado del otro */
            gap: 10px; /* Espacio entre los inputs */
            padding: 10px;
            background-color: #f9f9f9;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .radio-label {
            flex: 1; /* Cada label ocupa el 50% del contenedor */
            display: flex;
            align-items: center;
            justify-content: center; /* Centra el contenido horizontalmente */
            padding: 12px;
            background-color: #fff;
            border: 2px solid #ddd;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 16px;
            color: #333;
            text-align: center; /* Centra el texto */
        }

        .radio-label:hover {
            border-color: #007bff;
            background-color: #f0f8ff;
        }

        .radio-input {
            display: none; /* Ocultar el radio button nativo */
        }

        /* !* Estilo para el círculo del radio button personalizado *!
         .radio-label::before {
             content: "";
             display: inline-block;
             width: 20px;
             height: 20px;
             margin-right: 10px;
             border: 2px solid #ddd;
             border-radius: 50%;
             background-color: #fff;
             transition: all 0.3s ease;
         }*/

        /* Estilo del círculo cuando el radio button está seleccionado */
        .radio-input:checked + .radio-label::before {
            border-color: #007bff;
            background-color: #007bff;
        }

        /* Estilo cuando el radio button está seleccionado */
        .radio-input:checked + .radio-label {
            background-color: #007bff;
            border-color: #007bff;
            color: #fff;
        }


        #btnBuscar {
            background-color: #007bff; /* Color de fondo azul */
            color: white; /* Texto blanco */
            border: none; /* Sin borde */
            padding: 12px 24px; /* Espaciado interno */
            font-size: 16px; /* Tamaño de fuente */
            border-radius: 8px; /* Bordes redondeados */
            cursor: pointer; /* Cambia el cursor al pasar el mouse */
            transition: all 0.3s ease; /* Transición suave */
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); /* Sombra suave */
            display: inline-block; /* Asegura que el botón no ocupe todo el ancho */
            text-align: center; /* Centra el texto */
        }

        /* Efecto hover */
        #btnBuscar:hover {
            background-color: #0056b3; /* Color de fondo más oscuro al pasar el mouse */
            box-shadow: 0 6px 8px rgba(0, 0, 0, 0.15); /* Sombra más pronunciada */
            transform: translateY(-2px); /* Efecto de levantar el botón */
        }

        /* Efecto active (cuando se hace clic) */
        #btnBuscar:active {
            background-color: #004080; /* Color de fondo aún más oscuro */
            box-shadow: 0 3px 5px rgba(0, 0, 0, 0.2); /* Sombra más pequeña */
            transform: translateY(0); /* Vuelve a su posición original */
        }

        .selected-tag {
            background-color: #007bff;
            color: white;
            border-radius: 5px;
            padding: 2px;
            margin: 2px;
            font-size: 13px;
        }

        div#table-container-china {
            margin-top: 10px;
        }

        .toggle-button {
            width: 40px;
            padding: 10px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .toggle-button:hover {
            background-color: #0056b3;
        }


        /* Estilos base para el botón */
        .btn-alerta-stock {
            background-color: #ff4757; /* Rojo vibrante */
            border: none; /* Sin borde */
            border-radius: 8px; /* Bordes redondeados */
            padding: 12px 24px; /* Espaciado interno */
            font-size: 16px; /* Tamaño de fuente */
            color: white; /* Color del texto */
            cursor: pointer; /* Cursor en forma de mano */
            transition: background-color 0.3s ease, transform 0.2s ease; /* Transiciones suaves */
            width: 100%; /* Ocupa todo el ancho disponible */
            max-width: 300px; /* Ancho máximo para no estirarse demasiado en pantallas grandes */
            margin: 10px auto; /* Centrar el botón */
            display: block; /* Convertir en bloque para ocupar el ancho completo */
            text-align: center; /* Centrar el texto */
            box-shadow: 0 4px 6px rgba(255, 71, 87, 0.3); /* Sombra suave */
        }

        /* Efecto hover */
        .btn-alerta-stock:hover {
            background-color: #ff6b81; /* Rojo más claro al pasar el mouse */
            transform: scale(1.05); /* Escalar ligeramente el botón */
        }

        /* Efecto activo (al hacer clic) */
        .btn-alerta-stock:active {
            transform: scale(0.95); /* Reducir ligeramente el botón al hacer clic */
        }


        /* Estilo responsivo para dispositivos móviles */
        @media (max-width: 768px) {
            .radio-label {
                font-size: 14px;
                padding: 5px;
            }

            .btn-alerta-stock {
                padding: 5px 2px;
                font-size: 12px;
            }

            #btnBuscar {
                padding: 10px 20px; /* Espaciado más pequeño */
                font-size: 14px; /* Tamaño de fuente más pequeño */
            }

            body {
                padding: 0.5rem;
            }

            input.ui-autocomplete-input {
                font-size: 14px;
                padding: 8px;
            }

            table {
                font-size: 12px;
            }

            th, td {
                padding: 6px;
            }

        }
        .hidden-input {
            display: none;
        }
        div#miMultiselect {
            margin-top: 10px;
        }
    </style>
</head>
<body>
<div class="nav-mv"></div>
<div class="container">
    <!--inputs principales-->
    <div class="controls">
        <input id="producto_general_label" placeholder="Seleccina un producto...">
        <div class="multi-autocomplete-container">
            <input id="color_label" placeholder="Seleccina Colores...">
        </div>

        <div class="filtros-bodega">
            <button class="toggle-button" title="Mostrar Filtros por bodega">
                <i class="fas fa-eye"></i> <!-- Ícono de ojo (mostrar) -->
            </button>
            <div id="miMultiselect" class="multiselect "></div>
            <div id="multiSelectGrupos" class="multiselect hidden-input"></div>
        </div>
    </div>

    <!--botones pra reordenar la tabla-->
    <div id="radio-buttons-container" style="display: none;"></div>
    <button id="btnBuscar">Buscar</button>
    <!-- Contenedor para mostrar la tabla-->
    <div id="table-container" class="table-container"></div>

    <!-- Contenedor para mostrar la tabla-->
    <div id="table-container-china" ></div>
</div>

<script>
    $(document).ready(function() {
        const radioOptions = [
            { value: "color_bodega", label: "Color", checked: true },
            { value: "bodega_color", label: "Bodega", checked: false },
            { value: "grupo", label: "Grupo", checked: false }
        ];

        generateRadioButtons("radio-buttons-container", radioOptions);
    });


    function generateRadioButtons(containerId, options) {
        const $container = $("#" + containerId);

        $container.empty();
        $container.addClass("radio-container");

        const radioHtml = options.map((option, index) => `
                <input type="radio" class="radio-input" name="table_view" value="${option.value}" id="radio${index + 1}" ${option.checked ? "checked" : ""}>
                <label class="radio-label" for="radio${index + 1}">${option.label}</label>
            `).join("");

        $container.append(radioHtml);
    }


    function reportarMinimoRollos(zeroRollosItemsJSON, $el){

        var productId = $('#producto_general_label').attr('data-id');
        var data = {
            accion: 'reporteDeStock',
            info: zeroRollosItemsJSON,
            producto_general_id: productId,
            method: 'POST',
            cache: false
        };

        $.ajax({
            url: '../../backoffice/ajax/existencia_acciones_mv.php',
            dataType: "json",
            data: data,
            beforeSend: function (jqXHR, settings) {
                return true;
            }
        }).done(function (response) {
            // console.log("Respuesta del servidor:", response);

            if(response.status && response.message === '') {

                //quitar btn para que no reporten de nuevo
                return;
            }

        });
    }


</script>


</body>
</html>
