<?php

//@ToDo: cambiar por login
session_start();

if(empty($_SESSION) || empty($_SESSION['usuario_id']) || empty($_SESSION['usuario'])) {
    $_SESSION["usuario_id"] = 1999;
    $_SESSION["usuario"] = 'mobile';
}
?><!DOCTYPE html>
<html lang="es-MX">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Existencia</title>

    <!-- @ToDo: poner esto 2 lnks y 2 scripts en service-worker.js seccion cache -->
    <link href="/vitex/fontawesome-pro-6.4.0-web/css/all.min.css" rel="stylesheet">
    <link href=" https://cdn.jsdelivr.net/npm/tom-select@2.4.3/dist/css/tom-select.default.min.css " rel="stylesheet">

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.4.3/dist/js/tom-select.complete.min.js"></script>

    <style id="estilos_hoja_existencia">
        SELECT {background-color: white}

        BUTTON.ex {cursor:pointer;background-color:#e6f2ff;color:#00F;border:2px outset #99c2ff;padding:0.7em}

        .ex-FlexRow {display:flex;flex-direction:row;flex-wrap:wrap;gap:1em;justify-content:start;align-items:flex-start;color:#00F}

        /* Container for the buttons */
        .ex-button-group {
            display: flex;
            flex-wrap: wrap;
            justify-content: start;
            margin: 20px auto;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            background-color: #f5f5f5;
        }

        .ex-button-group input[type="radio"],
        .ex-button-group input[type="checkbox"] {
            position: absolute;
            opacity: 0;
            pointer-events: none;
        }

        /* Label styling for the button-like appearance */
        .ex-button-group label {
            display: inline-block;
            min-width: 24px;
            text-align: center;
            padding: 12px 8px;
            background-color: #e6f2ff;
            color: #0066cc;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid #99c2ff;
            position: relative;
            font-size: 14px;
            white-space: nowrap;
            user-select: none;
            height: 20px;
            line-height: 20px;
        }

        /* Button shadows for raised effect */
        .ex-button-group label:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            box-shadow: inset 0 2px 3px rgba(255, 255, 255, 0.8),
            inset 0 -2px 3px rgba(0, 0, 0, 0.1);
            z-index: 1;
            pointer-events: none;
        }

        /* Hover state */
        .ex-button-group label:hover {
            background-color: #cce4ff;
        }

        /* Checked (sunken) state for both radio and checkbox */
        .ex-button-group input[type="radio"]:checked + label,
        .ex-button-group input[type="checkbox"]:checked + label {
            background-color: #0066cc;
            color: white;
            font-weight: bold;
            box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.2);
        }

        .ex-button-group input[type="radio"]:checked + label:before,
        .ex-button-group input[type="checkbox"]:checked + label:before {
            box-shadow: inset 0 2px 5px rgba(0, 0, 0, 0.3);
        }

        /* Button styling to match the radio/checkbox appearance */
        .ex-button-group .ex-search-button {
            min-width: 60px;
            text-align: center;
            padding: 12px 8px;
            background-color: #e6f2ff;
            color: #0066cc;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid #99c2ff;
            position: relative;
            font-size: 14px;
            white-space: nowrap;
            user-select: none;
            font-family: inherit;
            outline: none;
            height: 44px;
        }

        /* Button shadows for raised effect */
        .ex-button-group .ex-search-button:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            box-shadow: inset 0 2px 3px rgba(255, 255, 255, 0.8),
            inset 0 -2px 3px rgba(0, 0, 0, 0.1);
            z-index: 1;
            pointer-events: none;
        }

        /* Hover state for button */
        .ex-button-group .ex-search-button:hover {
            background-color: #cce4ff;
        }

        /* Active (pressed) state for button */
        .ex-button-group .ex-search-button:active {
            background-color: #0066cc;
            color: white;
            font-weight: bold;
            box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.2);
        }

        /* Focus state for button */
        .ex-button-group .ex-search-button:focus {
            outline: 2px solid #3399ff;
            outline-offset: -2px;
        }

        TABLE.exTable {border-collapse: collapse;width:98%;box-shadow: 3px 3px 0 0 rgba(135, 182, 217, 1), 0 2px 2px rgba(135, 182, 217, 1)}
        TABLE.exTable TH, TD {border:1px solid lightblue;padding:0.1em 0.2em;color:#00F}

        TABLE.exTable TR TD:first-child{text-align:center}
        TABLE.exTable TR TD:nth-child(2){text-align:right}
        TABLE.exTable TR TD:last-child{text-align:right}

        TABLE.exTable TR.exRowTitle {color:black;border:none;background-color:#e6f2ff}
        TABLE.exTable TR.exRowTitle TD {color:black;border:none;background-color:#e6f2ff}
        TABLE.exTable TR.exTotal {font-weight: 600;border-bottom:6px double #3F3F3F;vertical-align: bottom}

        /* Mobile-friendly input styles */
        input[type="text"],
        input:not([type]),
        textarea {
            height: 48px;
            font-size: 16px;
            padding: 12px 16px;
            border-radius: 6px;
            border: 1px solid #99c2ff;
            width: calc(100% - 34px); /* Account for padding */
            box-sizing: border-box;
            margin-bottom: 10px;
            -webkit-appearance: none; /* Removes iOS default styling */
            appearance: none;
        }

        input[type="text"]:focus,
        input:not([type]):focus,
        textarea:focus {
            outline: none;
            border-color: #0066cc;
            box-shadow: 0 0 0 2px rgba(0, 102, 204, 0.2);
        }

        /* Fix for placeholder text */
        ::placeholder {
            color: #999;
            opacity: 1;
        }
    </style>

</head>
<body style="margin:0;padding:0;">
<div style="max-width:50ch;margin:0 auto;padding:0;text-align:center;vertical-align: top;border:2px inset whitesmoke;">
    <!-- @ToDo: Cambiar el header estandard -->
    <header class="ex-FlexRow" style="justify-content: space-between; align-items: center; background-color:darkblue;margin:0 0 1em 0;padding:0.2em 2em;color:white">
        <i class="fa-solid fa-house"></i>
        <span>Existencias</span>
        <i class="fa-solid fa-bars"></i>
    </header>
    <div id="exFiltrosOpen" style="text-align:left;margin-top:0;padding:0;display:none"><button type="button" class="ex" onclick="ex.exFiltrosToggle()"><i class="fa-regular fa-triangle fa-xl"></i></button></div>
    <div id="exFiltros" style="padding:0.2em 0.5em;">
        <div style="display:flex;flex-direction:column;justify-content:start;align-items:start">
            <div style="width:99%;text-align:left;display:flex;flex-direction: row;justify-content:start;align-items:start">
                <select class="notSelectize" id="ex_producto_general_id" style="width:95%" multiple></select>
                <button type="button" data-txsave="ex_producto_general_id" class="ex ex-save-button" title="Guardar selección"><i class="fa-regular fa-thumbtack" style="color:#00F"></i></button>
            </div>
            <div style="width:99%;text-align:left;display:flex;flex-direction: row;justify-content:start;align-items:start">
                <select class="notSelectize" id="ex_color_id" style="width:90%" multiple></select>
                <button type="button" data-txsave="ex_color_id" class="ex ex-save-button" title="Guardar selección"><i class="fa-regular fa-thumbtack" style="color:#00F"></i></button>
            </div>
            <div id="ex_bodegas" style="width:99%;text-align:left;display:flex;flex-direction: row;justify-content:space-between;align-items:start">
                <select class="notSelectize" id="ex_bodega_id" style="width:90%" multiple></select>
                <button type="button" data-txsave="ex_bodega_id" class="ex ex-save-button" title="Guardar selección"><i class="fa-regular fa-thumbtack" style="color:#00F"></i></button>
            </div>
        </div>
    </div>
    <div class="ex-button-group">
        <input type="radio" name="ex_por" id="ex_por_color" value="color"><label for="ex_por_color" style="vertical-align:top;line-height:0.90em"><i class="fa-solid fa-palette fa-2xs" style="font-weight:100"></i><br>Color</label>
        <input type="radio" name="ex_por" id="ex_por_bodega" value="bodega"><label for="ex_por_bodega" style="vertical-align:top;line-height:0.90em"><i class="fa-solid fa-warehouse fa-2xs"  style="font-weight:100"></i><br>Bodega</label>
        <input type="checkbox" id="ex_grupo" value="grupo"><label for="ex_grupo" style="vertical-align:top;line-height:0.90em"><i class="fa-solid fa-layer-group fa-2xs"  style="font-weight:100"></i><br>Grupo</label>
        <input type="checkbox" id="ex_sort" value="alfabetico" title="Orden alfabético o normal"><label for="ex_sort"><i id="ex_sortIcon" class="fa-solid fa-arrow-down-triangle-square""></i></label>
        <input type="checkbox" name="ex_filtro" id="ex_filtro" value="filtros"><label for="ex_filtro"><i class="fas fa-filter"></i></label>
        <button type="button" id="ex_clear_all" class="ex-search-button ex-compact-button" title="Limpiar todo"><i class="fas fa-broom"></i></button>
        <button type="button" id="ex_busca" class="ex-search-button"><i class="fas fa-search"></i></button>
        <!-- @ToDo: buscar, y buscar en cambios con datos, serian cambios de click para color/bodega/grupo  -->
    </div>
    <div id="exResults">
        <div class="ex-FlexRow" style="justify-content:space-between;padding-bottom:0.5em" >
            <div><button type="button" class="ex" onclick="ex.exFiltrosToggle()"><i class="fa-regular fa-triangle fa-xl"></i></button></div>
            <div><button type="button" class="ex"><i class="fa-regular fa-rotate-right fa-xl" style="color:#00F"></i></button></div>
            <div><button type="button" class="ex"><i class="fa-regular fa-square-share-nodes fa-2xl"></i></button></div>
        </div>
        <table class="exTable" style="width:100%">
            <caption><!-- @ToDo: resumen filtros --></caption>
            <tbody>
            <tr class="exTotal exRowTitle"><td><span>CAPITONADO WIMBELDON ( BONDING MAKUKO ) MP27327-1</span><br>
                    <!-- @ToDo en saldo, lento,.... <i class="fa-solid fa-tag" style="color:red"></i> o -->
                    <i class="fa-solid fa-palette" style="font-weight:100"></i><i>PALO DE ROSA-PALOROSA/NEGRO</i></td>
                <td>Rollos<br>18,144</td><td>Kg<br>8,121,250.00</td></tr>
            <tr><td>Virgoma</td><td>144</td><td>1,250.00</td></tr>
            <tr><td>Puebla Pue</td><td>144</td><td>1,250.00</td></tr>
            </tbody>
        </table>
    </div>
</div>
<script>
    var tomUtil = {
        storagePrefix: 'tota',
        
        init: function(elementId, placeholder, values, idField, labelField) {
            try {
                var select = document.getElementById(elementId);
                if (!select) return;
                select.tomSelect = new TomSelect('#' + elementId, {
                    valueField: idField,
                    labelField: labelField,
                    searchField: labelField,
                    options: values,
                    placeholder: placeholder,
                    delimiter: ',',
                    create: false,
                    persist: false,
                    maxItems: null,
                    closeAfterSelect: true,
                    hideSelected: true,
                    openOnFocus: true,
                    plugins: {
                        'remove_button': {},
                        'clear_button': {},
                       // 'auto_select_on_type': {}
                    },
                    score: function(search) {
                        var score = this.getScoreFunction(search);
                        return function(item) {
                            console.log("item", item);
                            if(search.length && item[labelField]) {
                                function normalizeString(str) {
                                    return str.normalize("NFD")
                                        .replace(/[\u0300-\u036f]/g, "")
                                        .toLowerCase();
                                }

                                var normalizedSearch = normalizeString(search);
                                var normalizedName = normalizeString(item[labelField]);
                                if(normalizedName.indexOf(normalizedSearch) === 0) {
                                    return 1;
                                } else if(normalizedName.indexOf(normalizedSearch) !== -1) {
                                    return 0.5;
                                }
                            }
                            return score(item);
                        };
                    },
                    render: {
                        option: function(data, escape) {
                            return '<div class="option">' + escape(data[labelField]) + ' <span class="remove">×</span></div>';
                        },
                        item: function(data, escape) {
                            return '<div class="item">' + escape(data[labelField]) + '</div>';
                        }
                    },
                    onInitialize: function() {
                        var tomSelectInstance = this;
                        var savedSelection = localStorage.getItem(tomUtil.storagePrefix + elementId);

                        if(savedSelection) {
                            try {
                                var parsedSelection = JSON.parse(savedSelection);
                                if(Array.isArray(parsedSelection)) {
                                    var validItems = parsedSelection.filter(function(itemId) {
                                        return tomSelectInstance.options[itemId] !== undefined;
                                    });
                                    if(validItems.length > 0) {
                                        tomSelectInstance.setValue(validItems, true);
                                        document.getElementById(elementId).value = validItems;
                                    }
                                } else if(parsedSelection && tomSelectInstance.options[parsedSelection]) {
                                    tomSelectInstance.setValue(parsedSelection, true);
                                    document.getElementById(elementId).value = parsedSelection;
                                }
                                var $saveMe = $("BUTTON[data-txsave='" + elementId + "']");
                                console.log("saveme", $saveMe);
                                console.log("  elementId",  elementId);
                                if($saveMe.length) {
                                    if(parsedSelection.length)
                                        $saveMe.children("i").removeClass('fa-regular').addClass('fa-solid');
                                    else
                                        $saveMe.children("i").removeClass('fa-solid').addClass('fa-regular');
                                }
                                return;
                            } catch(e) {
                                console.error('Error restoring saved selection for ' + elementId + ':', e);
                            }

                            try {
                                var $saveMe = $("BUTTON[data-txsave='" + elementId + "']");
                                if($saveMe.length) {
                                    $saveMe.children("i").removeClass('fa-solid').addClass('fa-regular');
                                }
                            } catch(e) {

                            }
                        }
                    }
                });
            } catch(err) {
                console.error(err);
            }
        },

        initAjax: async function(url, params, elementId, placeholder, resultKey, idField, labelField) {
            try {
                $.ajax({
                    url: url,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    data: params,
                })
                    .done(function(res) {
                        if(res.code === 200 && res.ok === true && res[resultKey]) {
                            tomUtil.init(elementId, placeholder, res[resultKey], idField, labelField);
                        } else {
                            if(typeof js_report_error === 'function') {
                                js_report_error("Invalid product data received");
                            } else if(console.error) {
                                console.error("Invalid product data received:", res);
                            }
                        }
                    })
                    .fail(function(xhr, textStatus, errorThrown) {
                        if(typeof js_report_error === 'function') {
                            js_report_error("Failed to load products: " + errorThrown);
                        } else if(console.error) {
                            console.error("Failed to load products:", errorThrown);
                        }
                    })
            } catch(err) {
                if(typeof js_report_error === 'function') {
                    js_report_error(err);
                } else if(console.error) {
                    console.error("tomUtil.initAjax", err);
                } else {
                    console.log("tomUtil.initAjax", err);
                }
            }
        },
        
        saveSelected: function(e) {
            try {
                var selectElement = document.getElementById(e.target.dataset.txsave);
                if(selectElement && selectElement.tomSelect) {
                    var selectedOptions = selectElement.tomSelect.getValue();
                    if(Array.isArray(selectedOptions)) {
                        localStorage.setItem(tomUtil.storagePrefix + e.target.dataset.txsave, JSON.stringify(selectedOptions));
                    } else {
                        localStorage.setItem(tomUtil.storagePrefix + e.target.dataset.txsave, selectedOptions);
                    }
                    if(selectedOptions.length)
                        $(this).children("i").removeClass('fa-regular').addClass('fa-solid');
                    else
                        $(this).children("i").removeClass('fa-solid').addClass('fa-regular');
                }
            } catch(err) {
                if(typeof js_report_error === 'function') {
                    js_report_error(err);
                } else if(console.error) {
                    console.error("saveSelected", err);
                } else {
                    console.log("saveSelected", err);
                }
            }
        },
        
        updateOptions: async function(elementId, newOptions, idField) {
            try {
                var selectElement = document.getElementById(elementId);
                if(!selectElement || !selectElement.tomSelect) {
                    console.error('Tom Select instance not found for ID:', elementId);
                    return;
                }
                var tomSelectInstance = selectElement.tomSelect;
                var selectedItems = tomSelectInstance.items.slice();
                tomSelectInstance.clear();
                tomSelectInstance.clearOptions();
                tomSelectInstance.addOptions(newOptions);
                var validSelectedItems = [];
                for(var i = 0; i < selectedItems.length; i++) {
                    var itemId = selectedItems[i];
                    var stillValid = newOptions.some(function(option) {
                        return option[idField] === itemId;
                    });
                    if(stillValid) {
                        validSelectedItems.push(itemId);
                    }
                }
                if(validSelectedItems.length > 0) {
                    tomSelectInstance.setValue(validSelectedItems, true);
                }
                tomSelectInstance.refreshOptions(false);
            } catch(err) {
                if(typeof js_report_error === 'function') {
                    js_report_error('Error updating tom select options: ' + err.message);
                } else if(console.error) {
                    console.error('Error updating tom select options:', err);
                } else {
                    console.log('Error updating tom select options:', err);
                }
            }
        },
        
        refreshData: async function(url, params, elementId, resultKey, idField) {
            try {
                $.ajax({
                    url: url,
                    type: 'GET',
                    dataType: 'json',
                    cache: false,
                    data: params,
                })
                    .done(function(res) {
                        if(res.code === 200 && res.ok === true && res[resultKey]) {
                            tomUtil.updateOptions(elementId, res[resultKey], idField);
                        } else {
                            if(typeof js_report_error === 'function') {
                                js_report_error("Invalid data received when refreshing tomSelect");
                            } else if(console.error) {
                                console.error("Invalid data received when refreshing tomSelect:", res);
                            }
                        }
                    })
                    .fail(function(xhr, textStatus, errorThrown) {
                        if(typeof js_report_error === 'function') {
                            js_report_error("Failed to refresh tomSelect data: " + errorThrown);
                        } else if(console.error) {
                            console.error("Failed to refresh tomSelect data:", errorThrown);
                        }
                    });
            } catch(err) {
                if(typeof js_report_error === 'function') {
                    js_report_error(err);
                } else if(console.error) {
                    console.error("refreshData", err);
                } else {
                    console.log("refreshData", err);
                }
            }
        },

        getStorage: function(key, defaultValue) {
            var value = localStorage.getItem(key);
            if(value === null) {
                localStorage.setItem(key, defaultValue);
                return defaultValue;
            }
            return value;
        },
        
        setStorage: function(key, value) {localStorage.setItem(key, value);}
    }


    var ex = {


        checkedToStorage: function(e) {localStorage.setItem(e.target.id, e.target.checked ? "1" : "0");},
        getStorage: function(key, defaultValue) {
            var value = localStorage.getItem(key);
            if(value === null) {
                localStorage.setItem(key, defaultValue);
                return defaultValue;
            }
            return value;
        },

        init: function() {
            
            tomUtil.initAjax("/vitex/backoffice/ajax/existencia_acciones_mv.php", {accion: "getProductos"}, "ex_producto_general_id", "🔎 Buscar Productos", "productos", "k", "t");
            tomUtil.initAjax("/vitex/backoffice/ajax/existencia_acciones_mv.php", {accion: "getColores"}, "ex_color_id", "🔎 Buscar por colores", "colores", "k", "t");
            tomUtil.initAjax("/vitex/backoffice/ajax/existencia_acciones_mv.php", {accion: "getBodegasYGrupos"}, "ex_bodega_id", "🔎 Buscar en las Bodegas", "bodegas", "k", "t");

            $('.ex-save-button').off('click', tomUtil.saveSelected).on('click', tomUtil.saveSelected);

            var exPorStored = "ex_por_" + ex.getStorage("ex_por", "color");
            document.getElementById(exPorStored).checked = true;
            $('input[name="ex_por"]').on('change', function() {
                if(this.checked) localStorage.setItem("ex_por", this.value);
            });
            $("#" + exPorStored).trigger('change', {init: true});

            $("#ex_grupo").prop("checked", ex.getStorage("ex_grupo", "0") === "1")
                .off("change", ex.checkedToStorage).on("change", ex.checkedToStorage)
                .trigger('change', {init: true});

            $("#ex_filtro").prop("checked", ex.getStorage("ex_filtro", "0") === "1")
                .off("change", ex.checkedToStorage).on("change", ex.checkedToStorage)
                .off("change", ex.exFiltroChange).on("change", ex.exFiltroChange)
                .trigger('change', {init: true});

            $("#ex_sort").prop("checked", ex.getStorage("ex_sort", "0") === "1")
                .off("change", ex.checkedToStorage).on("change", ex.checkedToStorage)
                .off('click', ex.sortIcon).on('click', ex.sortIcon)
                .trigger('change', {init: true});

            $("#ex_clear_all").off('click', ex.clearAll).on('click', ex.clearAll);
        },

        removeListeners: function() {
            $("#ex_grupo").off("change", ex.checkedToStorage);
            $("#ex_filtro").off("change", ex.checkedToStorage).off("change", ex.exFiltroChange);
            $('.ex-save-button').off('click', tomUtil.saveSelected);
            $("#ex_clear_all").off('click', ex.clearAll);
            $("#ex_sort").off("change", ex.checkedToStorage).off('click', ex.sortIcon);
        },

        exFiltroChange: function(e) {
            document.getElementById("ex_bodegas").style.display = e.target.checked ? 'flex' : 'none';
        },

        exFiltrosToggle: function() {
            var exFiltros = document.getElementById("exFiltros");
            if(exFiltros.style.display === "none") {
                document.getElementById("exFiltrosOpen").style.display = "none";
                exFiltros.style.display = "block";
            } else {
                document.getElementById("exFiltrosOpen").style.display = document.getElementById("exResults").style.display === "none" ? "block" : "none";
                exFiltros.style.display = "none";
            }
        },

        clearAll: function() {
            document.getElementById("ex_producto_general_id").tomSelect.clear();
            document.getElementById("ex_color_id").tomSelect.clear();
            document.getElementById("ex_bodega_id").tomSelect.clear();
        },

        sortIcon: function(ev) {
            if(ev.target.checked)
                $("#ex_sortIcon").removeClass("fa-arrow-down-triangle-square").addClass("fa-arrow-down-a-z");
            else
                $("#ex_sortIcon").removeClass("fa-arrow-down-a-z").addClass("fa-arrow-down-triangle-square");
        },

        busca: function() {
            data = {
                accion: 'existencia',
                por: document.querySelector('input[name="ex_por"]:checked').value,
                grupo: document.getElementById("ex_grupo").checked ? "1" : "0",
                sort: document.getElementById("ex_sort").checked ? "1" : "0",
                producto_general_id: document.getElementById("ex_producto_general_id").value,
                color_id: document.getElementById("ex_color_id").value,
                bodega_id: document.getElementById("ex_bodega_id").value,
            }
        }
    }

    window.addEventListener('DOMContentLoaded', function() {ex.init();});
</script>
</body>
</html>