function focus() {
    var $el = $(this);
    $el.autocomplete('search', $el.val().length ? $el.val() : '');
}

function dblclick() {
    var $el = $(this);
    var originalMinLength = $el.autocomplete("option", "minLength");
    $el.autocomplete("option", "minLength", 0);
    $el.autocomplete('search', '');
    setTimeout(function() {
        $el.autocomplete("option", "minLength", originalMinLength);
    }, 0);
}

function removeAccents(str) {
    return str.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
}

export function initAutoComplete(element, _data, lengthToStart = 3, callbackOnSelect = null) {
    var arrayData = _data;
    $(element).autocomplete({
        source: function(request, response) {
            var useData = Array.isArray(arrayData) ? arrayData : $vitex_globales[_data];
            var terms = request.term.split(' ').map(removeAccents);
            var matches = useData.filter(function(item) {
                return terms.every(function(term, index) {
                    var normalizedItem = removeAccents(item.label);
                    var regex = new RegExp($.ui.autocomplete.escapeRegex(removeAccents(term)), "i");
                    return regex.test(normalizedItem);
                });
            });

            response(matches.map(function(item) {
                return {
                    label: item.label,
                    value: item.nombre,
                    id: item.id,
                    i: item
                };
            }));
        },
        autoFocus: true,
        minLength: lengthToStart,
        select: function(event, ui) {
            var input = $(element);
            input.val(ui.item.label);
            input.attr('data-id', ui.item.id);
            input.attr('data-item', JSON.stringify(ui.item.i));

            if (callbackOnSelect != null) {
                callbackOnSelect(ui.item, ui, this);
            }
            return false;
        }
    }).off('focus', focus).on('focus', focus)
        .off('dblclick', dblclick).on('dblclick', dblclick);
}

/**
 * Initialize autocomplete feature on the specified element using AJAX to fetch data.
 *
 * @param {string} element - The input element to bind the autocomplete functionality.
 * @param {object} _data - The data object containing configuration settings for autocomplete.
 * @param {number} [lengthToStart=3] - The minimum length of characters to start showing autocomplete suggestions.
 * @param {function} [callbackOnSelect=null] - The callback function to execute when a suggestion is selected.
 *
 * @return {void}
 */
export function initAutoCompleteAjax(element, _data, lengthToStart = 3, callbackOnSelect = null) {
    var arrayData = _data;
    var $el = $(element);
    var data = Object.assign({
        valor: '',
        accion: 'buscar',
        itemIsHtml: true,
        onBlur: null,
    }, _data);

    $(element).autocomplete({
        source: function(request, response) {
            if (request.term.length) {
                $el.autocomplete("option", "autoFocus", true);
            } else {
                $el.autocomplete("option", "autoFocus", false);
            }

            data.valor = encodeURIComponent(request.term);
            $.ajax({
                url: _data.url,
                dataType: "json",
                data: data,
                beforeSend: function(jqXHR, settings) {
                    return true;
                }
            }).done(function(responseRequest) {
                var responseR = responseRequest.data && Array.isArray(responseRequest.data) && responseRequest.data.length > 0 ? responseRequest.data : responseRequest;
                var terms = request.term.split(' ').map(removeAccents);
                var matches = Array.isArray(responseR) ? responseR.filter(function(item) {
                    var normalizedItem = removeAccents(item.label);
                    var regex = new RegExp($.ui.autocomplete.escapeRegex(removeAccents(terms[0])), "i");
                    return regex.test(normalizedItem);
                }) : [];

                response(data.valor === '' ? matches.slice(0, data.onEmptyValSliceNumber) : matches);
            });
        },
        autoFocus: true,
        minLength: lengthToStart,
        select: function(event, ui) {
            var input = $(element);
            input.val(ui.item.label);

            if (callbackOnSelect != null) {
                callbackOnSelect(ui, ui, this);
            }
            return false;
        }
    }).off('focus', focus).on('focus', focus)
        .off('dblclick', dblclick).on('dblclick', dblclick);
}


export function initselectize(element, _data, lengthToStart = 3, callbackOnSelect = null){
    var selectedColors = [];
    var arrayData = _data;
    var $el = $(element);
    var data = Object.assign({
        valor: '',
        accion: 'buscar',
        itemIsHtml: true,
        onBlur: null,
    }, _data);

    $(element).autocomplete({
        minLength: lengthToStart,
        source: function (request, response) {
            var filtered = colors.filter(color =>
                color.label.toLowerCase().includes(request.term.toLowerCase()) &&
                !selectedColors.some(selected => selected.color_id === color.color_id)
            );
            response(filtered.map(color => ({
                label: color.label,
                value: color.label,
                color_id: color.color_id,
                color_valor: color.color_valor
            })));
        },
        focus: function (event, ui) {
            return false;
        },
        select: function (event, ui) {
            selectedColors.push(ui.item);
            updateSelectedTags();
            $(this).val("");
            return false;
        }
    }).autocomplete("instance")._renderItem = function (ul, item) {
        return $("<li>")
            .append(`<div class="ui-menu-item-wrapper">
                                <span class="color-box" style="background-color: ${item.color_valor};"></span>
                                ${item.label}
                             </div>`)
            .appendTo(ul);
    };


    function updateSelectedTags() {
        var container = $(".multi-autocomplete-container");
        container.find(".selected-tag").remove();

        selectedColors.forEach(color => {
            var tag = $(`<span class="selected-tag">
                                    <span class="color-box" style="background-color: ${color.color_valor};"></span>
                                    ${color.label}
                                    <i class="fa fa-times" data-id="${color.color_id}"></i>
                                 </span>`);
            tag.find("i").on("click", function () {
                selectedColors = selectedColors.filter(c => c.color_id !== color.color_id);
                updateSelectedTags();
            });
            container.prepend(tag);
        });
    }


}


export function initSelectizeAjax(element, _data, lengthToStart = 3, callbackOnSelect = null){
    var selectedColors = [];
    var arrayData = _data;
    var $el = $(element);
    var data = Object.assign({
        valor: '',
        accion: 'buscar',
        itemIsHtml: true,
        onBlur: null,
    }, _data);

    $(element).autocomplete({

        source: function (request, response) {
            if (request.term.length) {
                $el.autocomplete("option", "autoFocus", true);
            } else {
                $el.autocomplete("option", "autoFocus", false);
            }

            data.valor = encodeURIComponent(request.term);
            $.ajax({
                url: _data.url,
                dataType: "json",
                data: data,
                beforeSend: function(jqXHR, settings) {
                    return true;
                }
            }).done(function(responseRequest) {

                var colors = responseRequest.data && Array.isArray(responseRequest.data) && responseRequest.data.length > 0 ? responseRequest.data : responseRequest;

                var filtered = colors.filter(color =>
                    color.label.toLowerCase().includes(request.term.toLowerCase()) &&
                    !selectedColors.some(selected => selected.color_id === color.color_id)
                );
                response(filtered.map(color => ({
                    label: color.label,
                    value: color.label,
                    color_id: color.color_id,
                    color_valor: color.color_valor
                })));
            })
        },
        focus: function (event, ui) {
            return false;
        },
        select: function (event, ui) {
            selectedColors.push(ui.item);
            updateSelectedTags();
            $(this).val("");


            if (callbackOnSelect != null) {
                callbackOnSelect(ui, ui, this);
            }

            return false;
        }
    }).autocomplete("instance")._renderItem = function (ul, item) {
        return $("<li>")
            .append(`<div class="ui-menu-item-wrapper">
                                <span class="color-box" style="background-color: ${item.color_valor};"></span>
                                ${item.label}
                             </div>`)
            .appendTo(ul);
    };


    function updateSelectedTags() {
        var container = $(".multi-autocomplete-container");
        container.find(".selected-tag").remove();

        selectedColors.forEach(color => {
            var tag = $(`<span class="selected-tag" id="${color.color_id}">
                                    <span class="color-box" style="background-color: ${color.color_valor};"></span>
                                    ${color.label}
                                    <i class="fa fa-times" style="color: red;" data-id="${color.color_id}"></i>
                                 </span>`);
            tag.find("i").on("click", function () {
                selectedColors = selectedColors.filter(c => c.color_id !== color.color_id);
                updateSelectedTags();
            });
            container.prepend(tag);
        });
    }

}


/*
export function createMultiselectAjax(containerSelector, options, placeholder = "Buscar opciones...") {

    const $container = $(containerSelector);
    if (!$container.length) {
        console.error("El contenedor no existe.");
        return;
    }

    // Crear la estructura HTML del multiselect
    $container.html(`
        <input type="text" class="search-input" placeholder="${placeholder}">
        <div class="options"></div>
        <div class="selected-options"></div>
    `);

    const $searchInput = $container.find(".search-input");
    const $optionsContainer = $container.find(".options");
    const $selectedOptionsContainer = $container.find(".selected-options");

    // Función para cargar las opciones desde el servidor
    function loadOptions(searchTerm = "") {

        $.ajax({
            url: options.url,
            dataType: "json",
            data: options,
            beforeSend: function(jqXHR, settings) {
                return true;
            }
        }).done(function(response) {

            $optionsContainer.empty();
            var items = response.data && Array.isArray(response.data) && response.data.length > 0 ? response.data : response;


            if (items.length > 0) {
                items.forEach(function(option) {
                    $optionsContainer.append(`
                            <div data-value="${option.id}">${option.label}</div>
                        `);
                });
            } else {
                $optionsContainer.append("<div>No se encontraron opciones.</div>");
            }
        })

    }

    // Cargar opciones al hacer clic en el campo de búsqueda
    $searchInput.on("focus", function() {
        loadOptions();
        $optionsContainer.show();
    });

    // Filtrar opciones al escribir en el campo de búsqueda
    $searchInput.on("input", function() {
        const searchTerm = $(this).val();
        loadOptions(searchTerm);
    });

    // Seleccionar una opción
    $optionsContainer.on("click", "div", function() {
        const value = $(this).data("value");
        const label = $(this).text();

        if (!$selectedOptionsContainer.find(`span[data-value="${value}"]`).length) {
            $selectedOptionsContainer.append(`
                <span data-value="${value}">${label} <button class="remove-btn">×</button></span>
            `);
        }

        $optionsContainer.hide();
    });

    // Eliminar una opción seleccionada
    $selectedOptionsContainer.on("click", ".remove-btn", function() {
        $(this).parent().remove();
    });

    // Ocultar las opciones al hacer clic fuera
    $(document).on("click", function(event) {
        if (!$(event.target).closest(containerSelector).length) {
            $optionsContainer.hide();
        }
    });
}
*/

/**
 *
 * @param {string} containerSelector - The selector for the container where the multiselect UI will be created
 * @param {object} options - The options object containing properties for the AJAX request (e.g., url)
 * @param {string} [placeholder="Buscar opciones..."] - The placeholder text for the search input field
 * @returns {Object} An object with a method selectOptions that allows selecting options based on values
 */
export function createMultiselectAjax(containerSelector, options, placeholder = "Buscar opciones...") {
    const $container = $(containerSelector);
    if (!$container.length) {
        console.error("El contenedor no existe.");
        return;
    }

    // Crear la estructura HTML del multiselect
    $container.html(`
        <div class="selected-options main-options"></div>
        <div class="hidden-input">
            <input type="text" class="search-input" placeholder="${placeholder}">
            <div class="options"></div>
        </div>
        
    `);

    const $searchInput = $container.find(".search-input");
    const $optionsContainer = $container.find(".options");
    const $selectedOptionsContainer = $container.find(".selected-options");



    loadOptions("", true)
    // Función para cargar las opciones desde el servidor
    function loadOptions(searchTerm = "", hideoptions = false) {
        $.ajax({
            url: options.url,
            dataType: "json",
            data: options,
            beforeSend: function(jqXHR, settings) {
                return true;
            }
        }).done(function(response) {
            $optionsContainer.empty();
            var items = response.data && Array.isArray(response.data) && response.data.length > 0 ? response.data : response;

            if (items.length > 0) {
                items.forEach(function(option) {
                    $optionsContainer.append(`
                        <div data-value="${option.id}">${option.label}</div>
                    `);
                });
            } else {
                $optionsContainer.append("<div>No se encontraron opciones.</div>");
            }
        });


        if(hideoptions){
            $optionsContainer.hide();
        }
        else {
            $optionsContainer.show();
        }


    }

    // Cargar opciones al hacer clic en el campo de búsqueda
    $searchInput.on("focus", function() {
        loadOptions();
        $optionsContainer.show();
    });

    // Filtrar opciones al escribir en el campo de búsqueda
    $searchInput.on("input", function() {
        const searchTerm = $(this).val();
        loadOptions(searchTerm);
    });

    // Seleccionar una opción
    $optionsContainer.on("click", "div", function() {
        const value = $(this).data("value");
        const label = $(this).text();

        if (!$selectedOptionsContainer.find(`span[data-value="${value}"]`).length) {
            $selectedOptionsContainer.append(`
                <span data-value="${value}">${label} <button class="remove-btn">×</button></span>
            `);
        }

        $optionsContainer.hide();
    });

    // Eliminar una opción seleccionada
    $selectedOptionsContainer.on("click", ".remove-btn", function() {
        $(this).parent().remove();
    });

    // Ocultar las opciones al hacer clic fuera
    $(document).on("click", function(event) {
        if (!$(event.target).closest(containerSelector).length) {
            $optionsContainer.hide();
        }
    });

    // Función para seleccionar opciones basadas en valores
    function selectOptions(values) {
        values = values.split(',')

        values.forEach(value => {
            const $option = $optionsContainer.find(`div[data-value="${value}"]`);
            if ($option.length && !$selectedOptionsContainer.find(`span[data-value="${value}"]`).length) {
                const label = $option.text();
                $selectedOptionsContainer.append(`
                    <span data-value="${value}">${label} <button class="remove-btn">×</button></span>
                `);
            }
        });
    }

    // Devolver la función para seleccionar opciones
    return {
        selectOptions
    };
}



/**
 * Creates a multiselect options component in the specified container.
 *
 * @param {string} containerSelector - The selector for the container element where the multiselect will be created.
 * @param {Object} options - The options data to populate the multiselect (either an object or an array).
 * @param {string} [placeholder="Buscar opciones..."] - The placeholder text for the search input.
 * @param {Function} onSelectCallback - The callback function to be executed when an option is selected.
 * @return {void}
 */
export function createMultiselectOptions(containerSelector, options, placeholder = "Buscar opciones...", onSelectCallback) {
    const $container = $(containerSelector);
    if (!$container.length) {
        console.error("El contenedor no existe.");
        return;
    }

    // Crear la estructura HTML del multiselect
    $container.html(`
        <input type="text" class="search-input" placeholder="${placeholder}">
        <div class="options"></div>
        <div class="selected-options-op"></div>
    `);

    const $searchInput = $container.find(".search-input");
    const $optionsContainer = $container.find(".options");
    const $selectedOptionsContainer = $container.find(".selected-options-op");

    // Función para cargar las opciones
    function loadOptions(searchTerm = "") {
        $optionsContainer.empty();
        var items = options.data && Array.isArray(options.data) && options.data.length > 0 ? options.data : options;

        if (items.length > 0) {
            items.forEach(function(option) {
                $optionsContainer.append(`
                    <div data-value="${option.value}">${option.label}</div>
                `);
            });
        } else {
            $optionsContainer.append("<div>No se encontraron opciones.</div>");
        }
    }

    // Cargar opciones al hacer clic en el campo de búsqueda
    $searchInput.on("focus", function() {
        loadOptions();
        $optionsContainer.show();
    });

    // Filtrar opciones al escribir en el campo de búsqueda
    $searchInput.on("input", function() {
        const searchTerm = $(this).val();
        loadOptions(searchTerm);
    });

    // Seleccionar una opción
    $optionsContainer.on("click", "div", function() {
        const value = $(this).data("value"); // Valor ya parseado
        const label = $(this).text();

        if (!$selectedOptionsContainer.find(`span[data-value="${value}"]`).length) {
            $selectedOptionsContainer.append(`
                <span data-value="${value}">${label} <button class="remove-btn">×</button></span>
            `);
        }

        // Ejecutar el callback con los valores seleccionados
        if (onSelectCallback) {
            onSelectCallback(value);
        }

        $optionsContainer.hide();
    });

    // Eliminar una opción seleccionada
    $selectedOptionsContainer.on("click", ".remove-btn", function() {
        var values  = $(this).parent().data("value").split(',');
        values.forEach(value => {
            const $option = $(".selected-options").find(`[data-value="${value}"]`);
            if ($option.length)
                $option.remove();
        });
        $(this).parent().remove();
    });

    // Ocultar las opciones al hacer clic fuera
    $(document).on("click", function(event) {
        if (!$(event.target).closest(containerSelector).length) {
            $optionsContainer.hide();
        }
    });
}

