import {
    initAutoCompleteAjax,
    initSelectizeAjax,
    createMultiselectAjax,
    createMultiselectOptions
} from './app_iacase_autocomplete.js';
// js2/app_iacase_autocomplete.js
var items = {}
const minimoDeRollos = 2000;

$(document).ready(function() {

    // Definir menú con clave-valor
    const menuItems = {
        "Inicio": "#",
        "Buscar Producto": "#producto_general_label",
        // "Historial": "#historial",
        // "Configuración": "#configuracion",
        // "Salir": "#salir"
    };

    // Crear estructura del menú
    const navHtml = `
        <div class="navbar">
            <i class="fas fa-bars menu-toggle"></i>
            <span>Existencia de Productos</span>
            <i class="fas fa-home home-btn"></i>
        </div>
        <div class="sidebar">
            <ul class="menu-list"></ul>
        </div>
    `;

    // Agregar el menú al cuerpo del documento
    $("body").prepend(navHtml);

    // Agregar elementos al menú dinámico
    $.each(menuItems, function(key, value) {
        $(".menu-list").append(`<li><a href="${value}">${key}</a></li>`);
    });

    // Toggle del menú lateral
    $(".menu-toggle").click(function() {
        $(".sidebar").toggleClass("active");
    });

    // Cerrar menú si se hace clic en un enlace
    $(".sidebar ul li a").click(function() {
        $(".sidebar").removeClass("active");
    });

    // Botón Home que recarga la página
    $(".home-btn").click(function() {
        // window.location.href = "../backoffice/index.php"; // Cambia esto si el home está en otra página
    });


    $("#btnBuscar").on("click", function() {
        getResult();
        getChinaByProduct();
    });

    const configAutoCompleteProducto = {
        url: '/vitex/backoffice/json/producto_general.html',
        genera: '1',
        minLength: 0,
        autoFocus: true,
        method: 'POST',
        cache: false,
        dataType: 'json',
        strict: true,
    };
    initAutoCompleteAjax('#producto_general_label', configAutoCompleteProducto, 0, producto_general_labelCallbackSelect, false, "280px");


    $("input[name='table_view']").on("change", function () {
        updateTableView();
    });


    createSelectMulti()

    $(".toggle-button").on("click", function() {
        $(".hidden-input").slideToggle(function() {
            if ($(".hidden-input").is(":visible")) {
                $(".toggle-button i").removeClass("fa-eye").addClass("fa-eye-slash"); // Ícono de ojo tachado (ocultar)
            } else {
                $(".toggle-button i").removeClass("fa-eye-slash").addClass("fa-eye"); // Ícono de ojo (mostrar)
            }
        });
    });


});



function createSelectMulti(){

    var configAutoCompleteBodegas = {
        url: '../../backoffice/ajax/existencia_acciones_mv.php',
        accion: 'getBodegas',
        method:'POST',
        itemIsHtml: false,
        cache: false
    };

    // Crear el multiselect con AJAX
    const multiselectAjax = createMultiselectAjax(
        "#miMultiselect",
        configAutoCompleteBodegas,
        "Buscar en Bodegas..."
    );


    var configAutoCompleteGrupos = {
        data:[
                {
                    value: ['74867af2fe60ad6b11ec6cb482d16b28', '74867af2fe60ad6b11ec6f2555d5d88d', '74867af2fe60ad6b11ec6f257e211e16'],
                    label: "CLA"
                },
                {
                    value: ['74867af2fe60ad6b11ec6d7b3badcba6', '74867af2fe60ad6b11ec6f24d9e472b6', '74867af2fe60ad6b11ec6f2522d2672e'],
                    label: "COY"
                },

                {
                    value: ['74867af2fe60ad6b11ec6cb3ea28e494', '74867af2fe60845411ecaa03953dd312'],
                    label: "Centro"
                }
        ]
    }

    // Crear el multiselect con opciones estáticas
    createMultiselectOptions(
        "#multiSelectGrupos",
        configAutoCompleteGrupos,
        "Seleccionar Grupos...",
        function(selectedValues) {
            multiselectAjax.selectOptions(selectedValues);
        }
    );

}

function updateTableView() {
    let selectedValue = $("input[name='table_view']:checked").val();
    generateInventoryTableBybodega(items.existencia, "table-container", selectedValue);
}


function producto_general_labelCallbackSelect(item, ui, _this) {
    $(_this).attr('data-id', ui.item.producto_general_id);
    $(_this).attr('data-item', JSON.stringify(ui.item));
    $('#color_label').val('');
    $(_this).autocomplete('close');
    getColores2(ui.item.producto_general_id);
}

function getColores2(producto_id) {
    var configAutoCompleteColores = {
        url: '../../backoffice/ajax/existencia_acciones_mv.php',
        accion: 'getcolores_by_producto_general_id',
        producto_id: producto_id,
        method:'GET',
        itemIsHtml: false,
        cache: false,
        minLength: 0,
        autoFocus: true,
        strict: true
    };
    // initAutoCompleteAjax('#color_label', configAutoCompleteColores, null, colores_labelCallbackSelect, false, "280px");
    initSelectizeAjax('#color_label', configAutoCompleteColores, 0, null);

}


function getBodegas() {
    var configAutoCompleteColores = {
        url: '../../backoffice/ajax/existencia_acciones_mv.php',
        accion: 'getbodegas',
        method:'GET',
        itemIsHtml: false,
        cache: false
    };
    // initAutoCompleteAjax('#color_label', configAutoCompleteColores, null, colores_labelCallbackSelect, false, "280px");
    initSelectizeAjax('#filto-bodega', configAutoCompleteColores, 0, null);

}


function getResult(){
    let selectedIds = $(".selected-tag").map(function() {
        return this.id;
    }).get();

    let selectedValues = [];
    $(".selected-options").find("span").each(function() {
        const value = $(this).data("value");
        selectedValues.push(value);
    });

    $('#radio-buttons-container').show();
    var productId = $('#producto_general_label').attr('data-id');

    var data = {
        accion: 'getExistencia',
        producto_id: productId,
        color_id: selectedIds,
        bodegas_id: selectedValues,
        method: 'POST',
        cache: false
    };

    $.ajax({
        url: '../../backoffice/ajax/existencia_acciones_mv.php',
        dataType: "json",
        data: data,
        beforeSend: function (jqXHR, settings) {
            return true;
        }
    }).done(function (response) {
        console.log("Respuesta del servidor:", response);

        if(!response.status) {
            if(typeof response.message === 'string' && response.message !== '')
                Window.alert(response.message);

            return;
        }

        items.existencia = response.data;

        let selectedValue = 'color_bodega'
        if($('#radio-buttons-container').css("display") !== 'none') {
            selectedValue = $("input[name='table_view']:checked").val();
        }
        generateInventoryTableBybodega(items.existencia, "table-container", selectedValue);
    });
}


function getChinaByProduct(){
    let selectedIds = $(".selected-tag").map(function() {
        return this.id;
    }).get();

    var productId = $('#producto_general_label').attr('data-id');

    var data = {
        accion: 'getProductoChina',
        producto_id: productId,
        color_id: selectedIds,
        method: 'POST',
        cache: false
    };

    $.ajax({
        url: '../../backoffice/ajax/existencia_acciones_mv.php',
        dataType: "json",
        data: data,
        beforeSend: function (jqXHR, settings) {
            return true;
        }
    }).done(function (response) {
        console.log("Respuesta del servidor:", response);


        items.china = response.data;

        if(response.status) {
            generateTableChina(response.data, 'table-container-china')
        }
    });
}


function generateInventoryTableBybodega(data, containerId, groupingMethod = "bodega_color") {
    let groupedData = {};
    let totalRollos = 0;
    let totalQuantity = 0;

    // Agrupar los datos de acuerdo al método de agrupación
    $.each(data, function (key, item) {
        let groupKey;

        switch (groupingMethod) {
            case "bodega_color":
                groupKey = item.bodega || " ";
                break;
            case "color_bodega":
                groupKey = item.producto_color || " ";
                break;
            case "grupo":
                groupKey = item.grupo || item.bodega;
                break;
            default:
                groupKey = " ";
                break;
        }

        if (!groupedData[groupKey]) {
            groupedData[groupKey] = {};
        }

        // Si el método de agrupación es 'grupo', agrupamos por color dentro de cada grupo
        if (groupingMethod === "grupo") {
            let colorKey = item.producto_color || " ";
            if (!groupedData[groupKey][colorKey]) {
                groupedData[groupKey][colorKey] = {
                    rollos: 0,
                    quantity: 0,
                    bodegas: new Set() // Para almacenar las bodegas únicas
                };
            }
            groupedData[groupKey][colorKey].rollos += parseFloat(item.existencia_rollos) || 0;
            groupedData[groupKey][colorKey].quantity += parseFloat(item.existencia_quantity) || 0;
            groupedData[groupKey][colorKey].bodegas.add(item.bodega || " ");
        } else {
            if (!Array.isArray(groupedData[groupKey])) {
                groupedData[groupKey] = [];
            }

            if (groupingMethod === "color_bodega") {
                groupedData[groupKey].color_id = item.color_id;
            }
            groupedData[groupKey].push(item);
        }
    });

    // Determinar encabezados
    let label = '';
    let info = '';
    let isGrupo = false;

    if (groupingMethod === "bodega_color") {
        label = "Color";
        info = 'producto_color';
    } else if (groupingMethod === "color_bodega") {
        label = "Bodega";
        info = 'bodega';
    } else if (groupingMethod === "grupo") {
        label = "Color";
        info = 'producto_color';
        isGrupo = true;
    }

    let tableHtml = `
        <table class="inventory-table">
            <thead>
                <tr>
                    <th>${label}</th>
                    <th>Rollos</th>
                    <th>Quantity</th>
                </tr>
            </thead>
            <tbody>`;

    var total_grupo = {};
    let zeroRollosItems = [];

    $.each(groupedData, function (group, value) {
        tableHtml += `<tr class="color-header"><td colspan="3" id="${value.color_id + "-color" || ''}"><strong>${group}</strong></td></tr>`;
        var total_grupo_rollos = 0;
        var total_grupo_qty = 0;

        if (groupingMethod === "grupo") {
            $.each(value, function (color, colorData) {
                let rollos = colorData.rollos;
                let quantity = colorData.quantity;
                totalRollos += rollos;
                totalQuantity += quantity;
                total_grupo_rollos += rollos;
                total_grupo_qty += quantity;
                let bodegasList = Array.from(colorData.bodegas).join(', ');

                // if (rollos === 0) {
                //     zeroRollosItems.push({ color, bodegasList });
                // }

                tableHtml += `
                    <tr>
                        <td><span style="font-weight: bold;">${color}</span> <br>(${bodegasList})</td>
                        <td style="text-align: end;" >${numFormatter(rollos, 0)}</td>
                        <td style="text-align: end;" >${numFormatter(quantity, 2)}</td>
                    </tr>`;
            });
        } else {
            $.each(value, function (index, item) {
                let rollos = parseFloat(item.existencia_rollos) || 0;
                let quantity = parseFloat(item.existencia_quantity) || 0;
                totalRollos += rollos;
                totalQuantity += quantity;
                total_grupo_rollos += rollos;
                total_grupo_qty += quantity;

                // if (groupingMethod === "color_bodega" && rollos <= minimoDeRollos) {
                //     if (!zeroRollosItems[group]) {
                //         zeroRollosItems[group] = [];
                //     }
                //
                //     zeroRollosItems[group].push({
                //         color_id: item.color_id,
                //         producto: item.producto,
                //         bodega_id: item.bodega_id,
                //         rollos: item.existencia_rollos,
                //         info: item[info],
                //         bodega: item.bodega,
                //         producto_general_id: item.producto_general_id,
                //     });
                // }

                tableHtml += `
                    <tr>
                        <td>${isGrupo ? item["bodega"] + ' - ' + item[info] : item[info]}</td>
                        <td style="text-align: end;">${numFormatter(rollos, 0)}</td>
                        <td style="text-align: end;">${numFormatter(quantity, 2)}</td>
                    </tr>`;
            });
        }


        total_grupo[group] = {
            container_id: value.color_id + "-color" || '',
            grupo_rollos: total_grupo_rollos,
            grupo_qty: total_grupo_qty
        }

        if(groupingMethod === "color_bodega" && total_grupo[group].grupo_rollos <= minimoDeRollos){
            if (!zeroRollosItems[group]) {
                zeroRollosItems[group] = [];
            }
            zeroRollosItems[group].push(value);
        }

        // Si hay ítems con rollos menor igual a minimoDeRollos, agregar un botón con la información
        if (group in zeroRollosItems) {
            tableHtml += `
                <tr>
                    <td colspan="3" style="text-align: center;">
                        <button 
                            class="btn-alerta-stock" 
                            onclick='reportarMinimoRollos(${JSON.stringify(zeroRollosItems[group])})'>
                            Reportar stock en ${group}
                        </button>
                    </td>
                </tr>`;
        }


    });

    tableHtml += `
                </tbody>
                <tfoot>
                    <tr>
                        <td style="text-align: end;"><strong>Total</strong></td>
                        <td style="text-align: end;"><strong>${numFormatter(totalRollos, 0)}</strong></td>
                        <td style="text-align: end;"><strong>${numFormatter(totalQuantity, 2)}</strong></td>
                    </tr>
                </tfoot>
            </table>`;

    $(`#${containerId}`).html(tableHtml);
}

function generateTableChina(data, containerId) {
    let tableHtml = "";
    let hasValidData = false; 

    $.each(data, function(key, item) {
        // Verificar si la fecha es correcta
        let formattedDate = formatDate(item.eta);
        if (!formattedDate || formattedDate === "Fecha no válida") return; // Omitir si la fecha es inválida

        let tdElement = $("#" + key + "-color");
        if (tdElement.length > 0) {
            tdElement.append(` <span> ETA: ${formattedDate} </span>`);
        }

        // Si topamos pared significa que hay al menos un dato válido
        if (!hasValidData) {
            hasValidData = true;
            tableHtml += `
                <table border="1" cellpadding="10" cellspacing="0" style="width: 100%; border-collapse: collapse;">
                    <caption>En el Mar</caption>
                    <thead>
                        <tr>
                            <th>Color</th>
                            <th>Rollos</th>
                            <th>ETA</th>
                        </tr>
                    </thead>
                    <tbody>`;
        }

        tableHtml += `
                <tr>
                    <td>${item.color}</td>
                    <td>${numFormatter(item.pedido_rollos, 0)}</td>
                    <td>${formattedDate}</td>
                </tr>`;
    });

    if (hasValidData) {// Si hay datos válidos, cerrar la tabla y agregarla al contenedor

        tableHtml += `</tbody></table>`;
        $("#" + containerId).html(tableHtml);
    } else {
        $("#" + containerId).html("");// Si no hay datos válidos, limpiar el contenedor para que no muestre nada

    }
}



function numFormatter(n, dec) {
    if(isNaN(n))
        return n;
    if(n === '' || n === null)
        return '';
    if(typeof Number === 'function')
        return parseFloat(n).toLocaleString('en-us', {minimumFractionDigits: dec, maximumFractionDigits:dec});

    if(typeof typeof Intl === 'object' && Intl.NumberFormat === 'function')
        return dec > 0 ?
            new Intl.NumberFormat('en-US',
                {minimumFractionDigits:dec,maximumFractionDigits:dec}).format(n) :
            new Intl.NumberFormat('en-US',
                {minimumFractionDigits:0,maximumFractionDigits:0}).format(Math.round(n));

    return n;
}

function formatDate(dateString) {
    //     console.log('formatDate', dateString);
    if (typeof dateString !== 'string' || dateString.trim() === '') return "Fecha no válida";

    const parts = dateString.split("-");
    if (parts.length !== 3) return "Formato incorrecto";

    const [year, month, day] = parts;

    const monthAbbreviations = {
        "01": "Ene", "02": "Feb", "03": "Mar", "04": "Abr",
        "05": "May", "06": "Jun", "07": "Jul", "08": "Ago",
        "09": "Sep", "10": "Oct", "11": "Nov", "12": "Dic"
    };

    const monthAbbr = monthAbbreviations[month] || "Mes inválido"; // Evita undefined
    const shortYear = year ? year.slice(-2) : "??"; // Verifica que year exista

    return `${day} / ${monthAbbr} / ${shortYear}`;
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//ERRORES A DIME
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
var iacLastError=[],iacLastErrorXhr;
function js_errores_a_dime(e){ // catcha errores sin try-catch, en su caso try{..} catch(e){js_errores_a_dime(e);}
    try {
        if(e.message.search("status\":false") > -1)
            return;
        console.log("** Error detectado:", e);
        var regex2 = /([?&])(_js_cache|_nd|_|pi|e|_)=[^&\s:]+/gmi;
        e.message = e.message.replace(regex2, "");
        var es ={message:e.message, filename:e.filename || '', lineno:e.lineno || '0', colno:e.colno || '0', err:
                (e.hasOwnProperty("error") ?  e.error.toString() : e.message) || ''
        };
        for(var i=0, iLen=iacLastError.length; i<iLen; i++) {
            var ya=iacLastError[i];
            if(ya.message === es.message && ya.filename === es.filename && ya.lineno === es.lineno && ya.clono === es.colno ) {
                return;
            }
        }
        if(es.message === 'TypeError: window.opener is null')
            return;


        iacLastError[iacLastError.length] = es;
        var data=new FormData(),sErr=e.error ?  e.error : e.message ? e.message : "error detected";
        if(e.error && e.error.stack)
            sErr += "<p>"+e.error.stack;
        data.append('file', e.filename ? e.filename : window.location);
        data.append('err',"<pre>" + sErr + ".</pre>\r\n<p><b>En</b>: " + location.protocol + "//" + location.host + location.pathname + " \r\n<br>");
        data.append('line', e.lineno);
        data.append('col', e.colno);
        var xhr=new XMLHttpRequest();
        xhr.open('POST', '../../backoffice/ajax/logerr.php', true);
        xhr.send(data);
    } catch(err){console.log("js_errores_a_dime tiene error:",err);}
}
    window.addEventListener('error',function(e){js_errores_a_dime(e);});
    window.addEventListener('unhandledrejection',function(event){
    if(event.reason instanceof Error) {
        console.log("ERROR in promise", event.reason);
        js_errores_a_dime(event.reason);
    }
});

jQuery(function($){
    $(document).on('ajaxError',function(event,xhr,settings){
        try {
            if(xhr.status == 0)
                return;
            if (xhr.status == 401) {
                window.location.href = '../backoffice';
                event.preventDefault();
                event.stopImmediatePropagation();
                event.stopPropagation();
                return;
            }
            iacLastErrorXhr=xhr;
            if(settings.url.indexOf('logerr.php')<0)
                js_errores_a_dime({error:status,filename:settings.url, message:'ajax call: '+xhr.statusText+'/'+xhr.status+': '+xhr.statusText+"<br>desde: "+window.location+"<pre>"+xhr.responseText+"</pre>", line:2,col:2});
        } catch(err){console.log("js_errores_a_dime jquery default fail tiene error:",err);}
    });
});