const action = {
    save: function(){

        if (!action.validateForm()) {
            return;
        }

        const values = action.getFormData();
        console.log("save items", values)
        debugger

        $.ajax({
            url: '../../backoffice/ajax/usrs_mv_acciones.php',
            cache: false,
            type: "POST",
            dataType: 'json',
            data:{
                accion:'NuevoUsuario',
                usr: values,

            }
        }).done(function(data, textStatus, jqXHR) {

            if(!data.status) {
                if(typeof data.message === 'string' && data.message !== '') {
                    alert(data.message || "Error inesperado, intente más tarde.");
                }
                return;
            }


        }).fail(function(jqXHR, textStatus, errorThrown) {
            try {
                if(typeof jqXHR.responseJSON === 'object') {
                    ia.alertError(jqXHR.responseJSON.message || "Error inesperado, intente más tarde.", "Error", true);
                } else
                    ia.alertError(`Error inesperado, intente más tarde.<div>${textStatus}</div><div>${errorThrown}</div>`, "Error", true);
                console.log("Ajax error:", this);
            } catch(error) {
                console.log("ajax.fail message failed", error);
            }
            console.log('    ajax.fail: ' + this.url, arguments);
        });
    },
    getFormData: function() {
        const formData = {};

        $("form input, form select").each(function() {
            const name = $(this).attr("name");
            const value = $(this).val();
            if (name) {
                formData[name] = value;
            }
        });

        return formData;
    },
    validateForm: function () {
        let isValid = true;
        const errors = [];

        const username = $("#username_mv").val().trim();
        if (!username) {
            isValid = false;
            errors.push("El nombre de usuario es obligatorio.");
        } else if (username.length > 50) {
            isValid = false;
            errors.push("El nombre de usuario no puede tener más de 50 caracteres.");
        }

        const password = $("#password_mv").val().trim();
        if (!password) {
            isValid = false;
            errors.push("La contraseña es obligatoria.");
        } else if (password.length > 255) {
            isValid = false;
            errors.push("La contraseña no puede tener más de 255 caracteres.");
        }

        const email = $("#email_mv").val().trim();
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!email) {
            isValid = false;
            errors.push("El correo electrónico es obligatorio.");
        } else if (!emailRegex.test(email)) {
            isValid = false;
            errors.push("El correo electrónico no tiene un formato válido.");
        }

        const nombreCompleto = $("#nombre_completo").val().trim();
        if (!nombreCompleto) {
            isValid = false;
            errors.push("El nombre completo es obligatorio.");
        } else if (nombreCompleto.length > 100) {
            isValid = false;
            errors.push("El nombre completo no puede tener más de 100 caracteres.");
        }

        const estado = $("#estado").val();
        if (!estado) {
            isValid = false;
            errors.push("Debe seleccionar un estado.");
        }

        const tipo = $("#tipo").val();
        if (!tipo) {
            isValid = false;
            errors.push("Debe seleccionar un tipo de usuario.");
        }

        if (errors.length > 0) {
            alert("Errores de validación:\n" + errors.join("\n"));
        }

        return isValid;
    }

}