<?php

class BaseModel {

    public static string $msg_error = 'el error';
    public static string $id_insert = '';
    function __construct()
    {

    }

    public static function jqgrid_read(): bool|array
    {
        $per_page = param('rows', 50);
        $page = param('page', 1);

        $querys = static::prepare_querys_jqgrid();

        $query_select = $querys['select'];
        $rows = ia_sqlArrayIndx($query_select);
        if ($rows === false)
            return false;

        $count = ia_singleread($querys['count']);

        $total_pages = ceil($count/$per_page);
        return ['query' => $query_select,
            'page' => $page,
            'records' => $count,
            'rows' => $rows,
            'total' => $total_pages,
            'userdata' => []
        ];
    }

    public static function prepare_query_count(): string
    {
        $tabla = param('iactbl');
        $select_parts = static::prepare_query_select(true);
        $select_parts['select'] = "SELECT COUNT(*)";
        $select_parts['order_by'] = '';
        $select_parts['limit'] = '';
        return implode(" ", $select_parts);
    }
    public static function prepare_querys_jqgrid(): array
    {
        global $gParams;
        $gParams = [
            'iacc' => '',
            'iasum' => '',
            'iactbl' => param('iactbl'),
        ];
        return [
            'select' => static::prepare_query_select(),
            'count' => static::prepare_query_count()
        ];
    }

    public static function prepare_query_select($return_parts = false): array|string
    {
        $tabla = param('iactbl');
        $per_page = param('rows', 50);

        $partes = [
            'select' => "SELECT *",
            'from' => "FROM $tabla",
            'where' => static::prepare_where(),
            'order_by' => "",
            'limit' => "LIMIT 0, $per_page"
        ];

        // Preparando el limit
        $page = param('page', 1);
        $page_anterior = $page-1;
        $desde = 0;
        if ($page_anterior>0) {
            $desde = $page == 1?0:($per_page*$page_anterior);
        }

        $partes['limit'] = "LIMIT $desde, $per_page";

        // Preparando el order
        $sidx = param('sidx');
        $sort = param('sord');
        if (!empty($sidx)) {
            $partes['order_by'] = "ORDER BY $sidx $sort";
        }

        if ($return_parts)
            return $partes;

        return implode(" ", $partes);
    }

    public static function prepare_where(): string
    {
        $iacwhere = param('iacwhere');
        $wheres = [];
        if (!empty($iacwhere))
            $wheres[] = $iacwhere;

        $iacwhere = implode(" AND ", $wheres);
        $where_filters = static::apply_filters();

        $wheres_concat = [];
        if (!empty($iacwhere))
            $wheres_concat[] = "($iacwhere)";

        if (!empty($where_filters))
            $wheres_concat[] = $where_filters;

        $where = "";
        if (!empty($wheres_concat))
            $where = "WHERE ".implode(" AND ", $wheres_concat);

        return $where;
    }

    public static function apply_filters(&$wheres=[]): string
    {
        $filters = param('filters');
        $iacase = null;
        $tablePrefix='';
        $where='';
        if (!empty($filters)) {
            $tmp = '';
            $f = @json_decode($filters);
            $json = json_last_error();
            if($json) {
                if($json === JSON_ERROR_DEPTH)
                    $jsonerr = "\r\nJSON ERROR: The maximum stack depth has been exceeded";
                elseif($json === JSON_ERROR_STATE_MISMATCH)
                    $jsonerr = "\r\nJSON ERROR: Invalid or malformed JSON";
                elseif($json === JSON_ERROR_CTRL_CHAR)
                    $jsonerr = "\r\nJSON ERROR: Control character error, possibly incorrectly encoded";
                elseif($json === JSON_ERROR_SYNTAX)
                    $jsonerr = "\r\nJSON ERROR: Syntax error";
                elseif($json === JSON_ERROR_UTF8)
                    $jsonerr = "\r\nJSON ERROR: Malformed UTF-8 characters, possibly incorrectly encoded";
                else
                    $jsonerr = "\r\nJSON ERROR: unkown $json";
                ia_errores_a_dime($jsonerr);
            }

            if(isset($f->groupOp))
                $op = $f->groupOp;
            else
                $op = 'AND';
            if($op != 'AND' && $op != 'OR')
                $op = 'AND';

            if( $f->rules ) {
                foreach( $f->rules as $rule ) {
                    $tiene=$rule->data;
                    if (!is_array($rule->data))
                        $tiene=trim($rule->data);

                    if( $tiene !== '' || ( $rule->op === 'nu' || $rule->op === 'nn' || $rule->op === 'nu_bodega' || $rule->op === 'nn_bodega' ) ) {
                        if ($tiene === '@_#empty#_@') // paa indicar que esta vacio
                            $tiene = '';


                        where_op($tmp,$op);
                        $prefix = strpos($rule->field,'.') === false ? $tablePrefix : '';
                        if($rule->op  ===  'eq')
                            $tiene = str_replace(",","",$tiene);
                        $oldName = $rule->field;
                        $rule->field = solveVirtualField($rule->field);
                        if($oldName === $rule->field && $iacase !== null && !empty($iacase->campos[$rule->field]['virtual_sql'])  ) {
                            $tmpFieldName = preg_replace('/\)\s*as\s+[\'a-z0-9]+\s*$/miUuS', ")",
                                $iacase->campos[$rule->field]['virtual_sql']);
                            $tmpFieldName =  str_replace("as " . $rule->field,"", $tmpFieldName);

                            $tmp.=where_clause($tmpFieldName,$rule->op,$tiene);
                            continue;
                        }

                        $tiene = str_replace("," ,"", $tiene);
                        $apps_de_nota_bodega = ['nota_bodega', 'nota_bodega_verificacion'];
                        if ($iacase !== null && in_array($iacase->table, $apps_de_nota_bodega) && ($rule->field === 'numero')) {
                            $numero_search = $tiene;
                            $parts = explode("-", $numero_search);
                            $contiene_ajuste = str_contains($numero_search, strtolower('ajuste'));
                            if (count($parts)>1 || $contiene_ajuste || !is_numeric($parts[0]))
                                $rule->op = 'cn';

                            if (count($parts) == 1 && is_numeric($parts[0])) {
                                $rule->field = 'numero_real';
                                // $valor = strit("$numero_search%");
                                // $tmp.= fieldit($prefix.$rule->field). " LIKE $valor";
                                // continue;
                            }
                        }
                        if(strpos($rule->field,"remarks") !== false) {
                            $tmp_tiene = preg_replace_callback('/(\d+(.|,))+(\d)+/m', function ($matches) {
                                $monto = echonf(limpiaCantidad($matches[0]), true);
                                return substr($monto, -3) == ".00" ? substr_replace($monto ,"", -3) : $monto;
                            }, $tiene);

                            if ($tmp_tiene != $tiene) {
                                $tiene_where=where_clause($prefix.$rule->field,$rule->op,$tiene);
                                where_op($tiene_where, 'OR');
                                $tiene_where .= where_clause($prefix . $rule->field, $rule->op, $tmp_tiene);


                                $tmp .= "($tiene_where)";
                            }
                            else
                                $tmp.=where_clause($prefix.$rule->field,$rule->op,$tiene);
                        }
                        else
                            $tmp.=where_clause($prefix.$rule->field,$rule->op,$tiene);


                        //echo "<li>$gParams[iactbl]";
                        if(($rule->field === 'cliente' || $rule->field === 'cliente_id') && isset($iacase) && !empty($iacase) && ($iacase->table === 'cheque' || $iacase->table === 'pagare' || $iacase->table === 'vale' || $iacase->table === 'compra')) {
                            $tmpNombre = where_clause('nombre',$rule->op,$tiene);
                            $tmp = "($tmp OR cliente_id IN(SELECT cliente_id FROM cliente WHERE $tmpNombre ))";
                        }
                    }
                }
                if($tmp!='') {
                    where_op($where,'AND');
                    $where.="($tmp)";
                    return $where;
                }
            }
        }
        return '';
    }
}
