<?php

class UIBase
{
    public static $add_choser = true; // para agregar seleccionador de columnas en el grid

    public static $app = null;

    public static $dirViews = '';

    public static $assets_version = '';

    public static function titlePage(): string
    {
        return 'Vitex';
    }
    static function load_libs(): void
    {
        $iah = param('iah', '');
        static::$assets_version = $_token_assets = bin2hex(random_bytes(16));

        global $gWebDir;

        echo <<<HTL
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
        <link rel="stylesheet" href="/$gWebDir/css2/libs/front/bootstrap.css">
        <link rel="stylesheet" href="/$gWebDir/mobil/layout/assets/app.css?version=$_token_assets">
        <script src="/$gWebDir/js2/html2canvas.min.js?version=$_token_assets"></script>
        <script src="/$gWebDir/js2/notify.js?version=$_token_assets"></script>
        <script src="/$gWebDir/mobil/layout/assets/app.js?version=$_token_assets"></script>
        
        <script >
        const iah = '$iah';
        $(document).ready( function() {
            $.notify.addStyle('copiado', {
                html: "<div>☺<span data-notify-text/>☺</div>",
                classes: {
                    base: {
                        "white-space": "nowrap",
                        "background-color": "lightblue",
                        "padding": "5px"
                    },
                    supercopiado: {
                        "color": "white",
                        "background-color": "blue"
                    }
                }
            });
        });
        </script>
        HTL;
    }

    static function prepare_permisos(&$app): void
    {
        // permisos default
        $app->permiso_insert = false;
        $app->permiso_update = false;
        $app->permiso_list = false;
        $app->permiso_read = false;
        $app->permiso_export = false;
        $app->permiso_app = true;

        // si puede entrar al módulo definimos sus permisos
        if ($app->permiso_app) {
            $app->permiso_insert = true;
            $app->permiso_read = true;
            $app->permiso_update = true;
        }
        static::$app = $app;
    }

    static function prepare_toolbar(&$app)
    {
        $titulo_add = 'Alta';
        $object_methods = 'departamento.forma';
        $registro_id = $app->id;

        if (static::$add_choser) {
            $app->toolbar['extraFirstTD'] = "<td id='putColsChooser_' style='width: 150px;'></td>";
        }

        $app->toolbar['add']['html'] = "<a rel='opener refferer' target='_blank' href='./?iah=a' id='iaNewItem' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold text-dark text-decoration-none' title='Crear Nuevo Registro'><i class='fa-icon fa-solid fa-rectangle-history-circle-plus txt_1_8em p-1 rounded bg-success text-white'></i><br />$titulo_add <br><strong style='display: none'>(F3)</strong></a>";

        $handle_save_action = empty($registro_id) ? 'handle_save()': "handle_update(\"$registro_id\")";

        $app->toolbar['save']['html'] = "<a href='javascript:$object_methods.$handle_save_action;' id='iaGuardar' class='txt_1_1em tooltip_toolbar tooltip_toolbar_wohtml bold text-dark text-decoration-none' style='display:none;' title='Crear Nuevo Registro'><i class='fa-icon fa-solid fa-floppy-disk txt_1_8em p-1 rounded bg-primary text-white blink' title='Guardar datos'></i><br />Guardar <br><strong style='display: none'>(F2)</strong></a>";

        $app->toolbar['edit']['html'] = "<a href='./?iah=e&iaid=$registro_id' class='txt_1_1em tooltip_toolbar bold text-dark text-decoration-none' title='<div class=\"ui_tooltip_grid_notas_verificacion_completa bold\">Editar Registro</div>'><i class='fa-icon fa-solid fa-pen-to-square txt_1_8em p-1 rounded bg-primary text-white'></i><br />Editar</a>";

        $app->toolbar['read']['html'] = "<a href='./?iah=r&iaid=$registro_id' class='txt_1_1em tooltip_toolbar bold text-dark text-decoration-none' title='<div class=\"ui_tooltip_grid_notas_verificacion_completa bold\">Ver Registro</div>'><i class='fa-icon fa-solid fa-eye txt_1_8em p-1 rounded bg-info text-white'></i><br />Consultar</a>";

        $app->toolbar['close']['html'] = "<a href='./' id='iaCloseItem' class='txt_1_1em tooltip_toolbar bold text-dark text-decoration-none' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Listado</div>'><i class='fa-icon fa-solid fa-database txt_1_8em p-1 rounded bg-secondary text-white'></i><br/>Grid <strong style='display: none'>(F4)</strong></a>";

        $app->toolbar['delete_ask']['html'] = "<a href='javascript:$object_methods.handle_delete(\"$registro_id\")' class='txt_1_1em tooltip_toolbar bold text-dark text-decoration-none' title='<div class=\"ui_tooltip_grid_notas_inconsistenticias_danger bold\">Solicitar Borrar Registro</div>'><i class='fa-icon fa-solid fa-trash-can txt_1_8em p-1 rounded bg-danger text-white'></i><br />Borrar</a>";

        $options = ['add', 'save', 'edit', 'read', 'close', 'delete_ask'];
        $toolbar = [];
        foreach ($options as $key)
            $toolbar[$key] = $app->toolbar[$key];

        $app->toolbar = $toolbar;
        static::$app = $app;
        return $app->toolbar;
    }

    static function prepare_ui($app): string
    {
        if (!$app->permiso_app) {
            $error['title'] = "Sin permiso";
            $error['message'] = "No tienes permisos para entrar a este módulo";
            include "../backoffice/view/component/errors/errors.php";
            die_Script();
        }
        static::$app = $app;
        $iah = param('iah', '');
        $id = param('id', param('iaid'));
        return match ($iah) {
            'a', 'r', 'e' => static::ui_forma(iah:$iah,id:$id),
            default => static::ui_jqgrid(),
        };
    }

    static function ui_forma($iah, $id): string
    {
        return static::renderView('forma.phtml');
    }


    static function ui_jqgrid(): string
    {
        return static::renderView('jqgrid_registros.phtml');
    }

    static protected function renderView($view = null, $data = []): string
    {
        $path_base = dirname(__DIR__);
        if (empty(static::$dirViews))
            static::$dirViews = $path_base.'/layout/componentes';



        $data['date'] = date("Y-m-d H:i:s");
        if (isset(static::$app))
            $data['app'] = static::$app;

        $path = static::$dirViews ."/". $view ;
        $path = str_replace('\\', '/', $path);
        extract($data);
        ob_start();
        include_once "$path_base/layout/componentes/header.phtml";
        echo '<div class="container-fluid" style="top:60px; position: absolute">';
        include_once $path;
        echo '<div>';
        $view = str_replace('\"','"',trim(ob_get_contents()));
        ob_end_clean();
        return $view;
    }
}