const _app_ = {
    _menu_: {
        init: function () {
            // Toggle del menú lateral
            $(".btn-menu").click(function() {
                $(".sidebar").toggleClass("active");
                $('.modal-backdrop-sidebar').toggleClass("show");
            });
            $('.modal-backdrop-sidebar').click(function () {
                $(".sidebar").removeClass("active");
                $('.modal-backdrop-sidebar').removeClass("show");
            });

            // Cerrar menú si se hace clic en un enlace
            $(".sidebar ul li a").click(function(e) {
                let anchor = this;
                e.preventDefault();
                $(".sidebar").removeClass("active");
                setTimeout(function () {
                    window.location.href = anchor.href;
                    setTimeout(function () {
                        $('.modal-backdrop-sidebar').removeClass("show");
                    }, 100);
                }, 250);
            });

            // Botón Home que recarga la página
            $(".home-btn").click(function() {
                // window.location.href = "../backoffice/index.php"; // Cambia esto si el home está en otra página
            });
        }
    },
    _device_: {
        catch_controls: function (){
            if(_app_.isMobile()) {
                // this.back_page();
            }
        },

    },


    init_catalogos_globales: function () {
        inicializa_catalogos_globales();
    },

    alert: function (config)
    {
        console.log('app.alert()');
        let options = {...{
            id: '',
            titulo: 'Titulo',
            mensaje: 'mensaje',
            type: '',
            options_btn: {},
            on_open: function (dialog){},
            on_close: function (){},
        }, ...config};

        let options_btn_ = {...{
                addButtonConfirm: true,
                textButtonConfirm: 'OK',
                idButtonConfirm: 'btn_confirm',
                clasesButtonConfirm: 'btn-primary',
                addButtonCancel: true,
                textButtonCancel: 'Cancelar',
                idButtonCancel: 'btn_cancel',
                clasesButtonCancel: 'btn-secondary',
            }, ...options.options_btn};

        const icons = {
            info: '<i class="fa-icon fa-solid fa-circle-exclamation text-info txt_2em"></i>',
            warning: '<i class="fa-icon fa-solid fa-triangle-exclamation text-warning txt_2em"></i>',
            danger: '<i class="fa-icon fa-solid fa-triangle-exclamation text-danger txt_2em"></i>',
            error: '<i class="fa-icon fa-solid fa-triangle-exclamation text-danger txt_2em"></i>',
            ask: '<svg aria-hidden="true" focusable="false" data-prefix="fad" data-icon="face-thinking" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="svg-inline--fa fa-face-thinking fa-4x text-warning fa-icon float-left mr-3" style="width: 2.5rem;"><g class="fa-duotone-group"><path fill="currentColor" d="M0 256c0 45 11.6 87.3 32 124l0-28c0-30.9 25.1-56 56-56s56 25.1 56 56l0 3 92.2-33.5-82.4-34.7c-8.1-3.4-12-12.8-8.5-21s12.8-12 21-8.5l122.5 51.6c22.7 9.6 37.9 31.2 39.2 55.6c1.5 24.2-12.9 47.4-36.8 56.1l-35.8 13-21 57.7c-2.5 6.8-5.8 13.1-9.8 18.8c10.3 1.3 20.8 1.9 31.4 1.9c141.4 0 256-114.6 256-256S397.4 0 256 0S0 114.6 0 256zM114.1 119.9c-4.4-7.7-1.7-17.4 6-21.8l7.1-4c35.2-20.1 79.3-15.9 110.1 10.5c4.4 3.8 8.8 7.5 13.2 11.3c6.7 5.8 7.5 15.9 1.7 22.6s-15.9 7.5-22.6 1.7l-13.2-11.3c-20.5-17.6-49.9-20.4-73.4-7l-7.1 4c-7.7 4.4-17.4 1.7-21.8-6zM208.4 176a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm160 16a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z" class="fa-secondary"></path><path fill="currentColor" d="M143 121.9c23.5-13.4 52.9-10.6 73.4 7l13.2 11.3c6.7 5.8 16.8 5 22.6-1.7s5-16.8-1.7-22.6l-13.2-11.3C206.4 78.1 162.3 74 127.1 94.1l-7.1 4c-7.7 4.4-10.3 14.2-6 21.8s14.2 10.3 21.8 6l7.1-4zM176.4 208a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM112 352c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 26.5 21.5 48 48 48l47.2 0c20.2 0 38.2-12.6 45.1-31.6l26.1-71.7 49.8-18.1c12.5-4.5 18.9-18.3 14.4-30.8s-18.3-18.9-30.8-14.4L112 400.6l0-48.6zM368.4 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z" style="fill: #183153"></path></g></svg>'
        };

        if (options.type === '' || options.type === 'warning' || options.type === 'alert' || options.type === 'error' || options.type === 'danger') {
            options_btn_.addButtonConfirm = false;
            // options_btn_.textButtonCancel = 'OK';
            options_btn_.clasesButtonCancel = 'btn-primary';
        }

        let buttons = [];
        if (options_btn_.addButtonConfirm) {
            buttons.push(`<button type="button" class="btn btn-sm ${options_btn_.clasesButtonConfirm} p-1" id="${options_btn_.idButtonConfirm}">${options_btn_.textButtonConfirm}</button>`);
        }
        if (options_btn_.addButtonCancel) {
            buttons.push(`<button type="button" class="btn btn-sm ${options_btn_.clasesButtonCancel} p-1" data-dismiss="modal" id="${options_btn_.idButtonCancel}">${options_btn_.textButtonCancel}</button>`);
        }

        var defer = $.Deferred();

        const dialog = $(`<div class="modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-hidden="true" ${options.id.length>0?'id="'+options.id+'"':''}>
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-body p-0">
                                    <div class="card">
                                        <h4 class="card-header py-1 px-1">
                                            ${options.titulo}
                                            <button type="button" class="close border-secondary border rounded" data-dismiss="modal" aria-label="Close">
                                                <i class="fa-icon fa-solid fa-close"></i>
                                            </button>
                                        </h4>
                                        <div class="card-body p-2" style="font-size: initial">
                                            ${icons[options.type]||''}
                                            <br>
                                            ${options.mensaje}
                                        </div>
                                        <div class="card-footer text-muted text-right py-1 d-inline-flex justify-content-end">
                                            <div>${buttons.join('</div><div class="ml-3">')}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>`).modal({show:false});
        dialog.on('hidden.bs.modal', function (e) {
            dialog.remove();
        });
        dialog.on('shown.bs.modal', function (e) {
            dialog.find('.card-footer button')[0].focus();
            options.on_open(dialog);
        });

        dialog.modal('show');

        $('#'+options_btn_.idButtonConfirm).click(function (e) {
            e.target.disabled = true;
            if(!defer.isResolved && !defer.isRejected)
                defer.resolve(dialog);

            dialog.modal('hide');
        });

        $('#'+options_btn_.clasesButtonCancel).click(function (e) {
            e.target.disabled = true;
            if(!defer.isResolved && !defer.isRejected)
                defer.reject(dialog);

            dialog.modal('hide');
        });

        return defer.promise();
    },

    is_email: function (email='') {
        // Verificamos si el email contiene el símbolo '@'
        // y la @ no está al inicio ni al final
        const atIndex = email.indexOf('@');
        if (atIndex <= 0 || atIndex === email.length - 1) {
            return false;
        }

        // Dividimos el email usando la '@' como separador
        const [local, domain] = email.split('@');
        // Ese código genera dos constantes
        // - local, con la parte de antes de la @
        // -- domain, con la parte de después de la arroba

        // Comprobamos si alguna de las partes está vacía
        if (!local || !domain) {
            return false;
        }

        // Verificamos que el dominio contenga un punto y no esté al inicio ni al final
        const dotIndex = domain.indexOf('.');
        if (dotIndex <= 0 || dotIndex === domain.length - 1) {
            return false;
        }

        // Comprobamos que el dominio no tenga más de un punto consecutivo
        if (domain.includes('..')) {
            return false;
        }

        // Comprobamos que el email no contenga caracteres inválidos
        // Estos caracteres inválidos podrían extenderse si lo ves necesario
        const invalidChars = [' ', '!', '#', '$', '%', '&', '*', '(', ')', '+', ',', '/', ':', ';', '<', '=', '>', '?', '[', '\\', ']', '^', '`', '{', '|', '}', '~'];
        for (let char of invalidChars) {
            if (email.includes(char)) {
                return false;
            }
        }

        // Si estamos aquí es que todas las comprobaciones anteriores fueron correctas
        return true;
    },
    _fileIsImage: function (fileName) {
        const dotIndex = fileName.lastIndexOf('.');
        if (dotIndex === -1) {
            return false;
        }
        const ext = fileName.substring(dotIndex + 1).toLowerCase();
        return (ext === 'jpg' || ext === 'jpeg' || ext === 'gif' || ext === 'png');
    },
    isMobile: function () {
        return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    },
};

$(function () {
    // _app_.init_catalogos_globales();
    _app_._device_.catch_controls();
});