
var CACHE_NAME = 'vitex-mobile-v001';
var urlsToCache = [
    '/vitex/mobile/index.php',
   // '/vitex/mobile/consulta_existencia.php',
    '/vitex/mobile/js/vitex_mobile.js',
    '/vitex/mobile/css/vitex_mobile.css',

    '/vitex/img/S.png',
    '/vitex/img/SL.png',
    '/vitex/img/L.png',
    '/vitex/img/SS.png',
];

fetch(url, {
    // opcional
    credentials: 'include'
});

self.addEventListener('install', function(event) {
    // Perform install steps
    event.waitUntil(
        caches.open(CACHE_NAME)
            .then(function(cache) {
                console.log('Opened cache');
                return cache.addAll(urlsToCache);
            })
    );

    self.addEventListener('fetch', function(event) {
        event.respondWith(
            caches.match(event.request)
                .then(function(response) {
                        // Cache hit - return response
                        if (response) {
                            return response;
                        }
                        return fetch(event.request);
                    }
                )
        );
    });

});
