// noinspection ES6ConvertVarToLetConst

var bodegas=[],productos_generales_dialog=[],colores_dialog=[], colores_alfabetico_dialog=[], colores_alfabetico_desc_dialog=[];
$(function () {
    $.fn._show = function(){
        $(this).css('visibility', 'visible');
    };
    $.fn._hide = function(){
        $(this).css('visibility', 'hidden');
    };
    dialogConsultarExistencia.init();}
);

function numFormatter(n, dec) {
    if(typeof Number === 'function' && typeof Number === 'function')
        return dec > 0 ?
            n.toLocaleString('en-us', {minimumFractionDigits: dec}) :
            Math.round(n).toLocaleString('en-us', {minimumFractionDigits: 0});

    if(typeof typeof Intl === 'object' && Intl.NumberFormat === 'function')
        return dec > 0 ?
            new Intl.NumberFormat('en-US',
                {minimumFractionDigits:2,maximumFractionDigits:2}).format(n) :
            new Intl.NumberFormat('en-US',
                {minimumFractionDigits:0,maximumFractionDigits:0}).format(Math.round(n));

    return Math.round(n);
}

function rptExistencias_Maximizar(miIdCampo){
    var elDiv= $("#"+ miIdCampo);
    elDiv.parent().width("99.2%");
    elDiv.parent().height("98%");
    elDiv.parent().css({top: 5, left: 0});
    $("#rptExistencias_imgResize").animate(
        { deg: 180 },
        {
          duration: 1200,
          step: function(now)
          {
            $(this).css({ transform: 'rotate(' + now + 'deg)' });
          }
        }
    );
    $("#rptExistencias_imgResize").attr("onclick","rptExistencias_Resize('"+miIdCampo+"')");
}
function rptExistencias_Resize(miIdCampo){
    var anchoPantalla= window.innerWidth;
    var altoPantalla= window.innerHeight;
    var elDiv= $("#"+ miIdCampo);

    elDiv.parent().width("1240px");
    elDiv.parent().height("650px");

    var topCalculado= (altoPantalla /2) - 325;
    var leftCalculado= (anchoPantalla / 2) - 620;
    elDiv.parent().css({top: topCalculado, left: leftCalculado});
    $("#rptExistencias_imgResize").animate(
        { deg: 0 },
        {
          duration: 1200,
          step: function(now)
          {
            $(this).css({ transform: 'rotate(' + now + 'deg)' });
          }
        }
    );
    $("#rptExistencias_imgResize").attr("onclick","rptExistencias_Maximizar('"+miIdCampo+"')");
}

var dialogConsultarExistencia = {
        version: 'UI', // [HTML, UI]

        consultaExistenciaTomaInputs: function() {
            if($("#dialog_bodega").val().trim() === '')
                $('#dialog_bodega_id').val('');
            if($("#dialog_producto").val().trim() === '')
                $('#dialog_producto_id').val('');
            if($("#dialog_color").val().trim() === '')
                $('#dialog_color_id').val('');
        },

        pdf: function() {

        },

        print:function() {

            var title=$("TITLE"), titleAnterior = title.html(), titula=$("#consultaExistenciaProducto").dialog('option', 'title');
            title.html(titula);
            $("#dialogo_existencias_print_area").printThis({
                debug: false,               // show the iframe for debugging
                importCSS: true,            // import parent page css
                importStyle: true,         // import style tags
                printContainer: false,       // print outer container/$.selector
                loadCSS: window.location.origin + '/' +  window.location.pathname.split('/')[1] + "/backoffice/view/component/commons/dialogoExistencias.css",                // path to additional css file - use an array [] for multiple
                pageTitle: titula,              // add title to print page
                removeInline: false,        // remove inline styles from print elements
                removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                printDelay: 666,            // variable print delay erea 333
                header: null,               // prefix to html o null
                footer: null,               // postfix to html o null / (new Date()).toDateString()
                base: false,                // preserve the BASE tag or accept a string for the URL
                formValues: true,           // preserve input/form values
                canvas: false,              // copy canvas content
                doctypeString: '',       // enter a different doctype for older markup
                removeScripts: false,       // remove script tags from print content
                copyTagClasses: false,      // copy classes from the html & body tag
                beforePrintEvent: null,     // function for printEvent in iframe
                beforePrint: null,          // function called before iframe is filled
                afterPrint: function(){$("TITLE").html(titleAnterior);}            // function called before iframe is removed
            });
        },

        allChanged:function() {
            if($("#dialogo_existencia_todo").is(":checked")) {
                $("#dialog_existencia_grupo").val('');
                $("#dialog_bodega").val('');
                $('#dialog_bodega'+ '_id').val('');
                $("#dialog_producto").val('');
                $('#dialog_producto'+ '_id').val('');
                $("#dialog_color").val('');
                $('#dialog_color'+ '_id').val('');
                $('#icon_clean_bodega')._hide();
                $('#icon_clean_producto')._hide();
                $('#icon_clean_color')._hide();
                $("#dialogo_existencia_saldo").prop('checked', false);
                $("#dialogo_existencia_lento").prop('checked', false);
            }
            dialogConsultarExistencia.consultaExistencia();
        },

        grupoChanged:function() {
            var grupo = $("#dialog_existencia_grupo").val().trim();
            if(grupo !== '') {
                $("#dialog_bodega").val('');
                $('#dialog_bodega'+ '_id').val('');
                $("#dialogo_existencia_todo").prop('checked', false);
            }
            dialogConsultarExistencia.consultaExistencia();
        },

        colorSort: function() {
            var sortCatalog;
            switch($("input[name='dialogo_existencia_orden_color']:checked").val()) {
                case 'asc': sortCatalog =  colores_alfabetico_dialog; break;
                case 'desc': sortCatalog = colores_alfabetico_desc_dialog; break;
                default: sortCatalog = colores_dialog;
            }
            $d.initAutoComplete('#dialog_color', sortCatalog, '#dialog_color_id', (color) => {
                dialogConsultarExistencia.consultaExistencia();
            });
            dialogConsultarExistencia.consultaExistencia(null, true);
        },

        init: function (vers) {
            if(typeof vers !== 'undefined')
                dialogConsultarExistencia.version = 'HTML';
            if (dialogConsultarExistencia.version === 'UI') {
                var elDiv= $('#consultaExistenciaProducto');

                var elAncho = dialogConsultarExistencia.localStorageGet('widthDialogExistencia');
                var elAlto = dialogConsultarExistencia.localStorageGet('heightDialogExistencia');
                var laTop = dialogConsultarExistencia.localStorageGet('topDialogExistencia');
                var elLeft = dialogConsultarExistencia.localStorageGet('leftDialogExistencia');
                
                if( typeof elAncho == "undefined" || elAncho < 450 || elAncho == ''  ||
                   typeof elAlto == "undefined" || elAlto < 450 || elAlto == '' 
                ){
                    elAncho ="1240";
                    elAlto ="650";

                    var anchoPantalla= window.innerWidth;
                    var altoPantalla= window.innerHeight;
                    laTop = (altoPantalla /2) - 325;
                    elLeft = leftCalculadOpen= (anchoPantalla / 2) - 620;
                    elDiv.parent().css({top: laTop, left: elLeft});

                    dialogConsultarExistencia.localStorageSet('widthDialogExistencia',elAncho);
                    dialogConsultarExistencia.localStorageSet('heightDialogExistencia',elAlto);
                    dialogConsultarExistencia.localStorageSet('topDialogExistencia',laTop);
                    dialogConsultarExistencia.localStorageSet('leftDialogExistencia',elLeft);
                }
console.log(laTop,elLeft);
                $('#consultaExistenciaProducto').dialog({
                    autoOpen: false,
                    modal: false,
                    width:1240,
                    height:650,
                    // position: {my:`top+${laTop} left+${elLeft}` },
                    draggable: true,
                    resizable: true,
                    title: 'Consulta Existencia de Producto',
                    open: function() {
                        dialogConsultarExistencia.colorSort();

                        //elDiv.parent().width(elAncho);
                        // elDiv.parent().height(elAlto);
                       // elDiv.parent().css({top: laTop, left: elLeft});

                        $('#dialog_bodega').val('');
                        $('#dialog_bodega_id').val('');
                        $('#dialog_producto').val('');
                        $('#dialog_producto_id').val('');
                        $('#dialog_color').val('');
                        $('#dialog_color_id').val('');
                        $('#icon_clean_bodega')._hide();
                        $('#icon_clean_producto')._hide();
                        $('#icon_clean_color')._hide();
                        $("#dialog_producto").focus();
                        $('#tabla_consulta_existencia tbody').html('');
                        $('#totales').html('');
                        $('#dialog_existencia_footer').html('');
                        //$("#dialogo_existencia_todo").prop('checked', true);
                        dialogConsultarExistencia.consultaExistencia();
                    },
                    beforeClose:function() {
                        var elDiv = $('#consultaExistenciaProducto');
                        var elAnchoClose= elDiv.parent().width();
                        var elAltoClose= elDiv.parent().height();
                        var laTopClose= elDiv.parent().position()["top"];
                        var elLeftClose= elDiv.parent().position()["left"];
                        //console.log("elLeft c", elLeftClose)
                        dialogConsultarExistencia.localStorageSet('widthDialogExistencia',elAnchoClose);
                        dialogConsultarExistencia.localStorageSet('heightDialogExistencia',elAltoClose);
                        dialogConsultarExistencia.localStorageSet('topDialogExistencia',laTopClose);
                        dialogConsultarExistencia.localStorageSet('leftDialogExistencia',elLeftClose);
                    },
                    close: function() {

                        dialogConsultarExistencia.hide();
                    }
                });
            }

            $("#dialogo_existencia_todo").prop('checked', false).off('change',dialogConsultarExistencia.allChanged).on('change',dialogConsultarExistencia.allChanged);
            $("#dialogo_existencia_donde").prop('checked', false).off('change',dialogConsultarExistencia.allChanged).on('change',dialogConsultarExistencia.allChanged);
            $("#dialogo_existencia_lento").prop('checked', false).off('change',dialogConsultarExistencia.consultaExistencia).on('change',dialogConsultarExistencia.consultaExistencia);
            $("#dialogo_existencia_saldo").prop('checked', false).off('change',dialogConsultarExistencia.consultaExistencia).on('change',dialogConsultarExistencia.consultaExistencia);
            $("INPUT[name='dialogo_existencia_orden_color']").off('change',dialogConsultarExistencia.colorSort).on('change',dialogConsultarExistencia.colorSort);
            $("INPUT[name='dialogo_existencia_casset']").off('change',dialogConsultarExistencia.botonesCasset).on('change',dialogConsultarExistencia.botonesCasset);
            $("#dialog_existencia_grupo").prop('checked', false).off('change',dialogConsultarExistencia.grupoChanged).on('change',dialogConsultarExistencia.grupoChanged);
            $("#dialog_bodega").on("blur", dialogConsultarExistencia.consultaExistenciaTomaInputs);
            $("#dialog_producto").on("blur", dialogConsultarExistencia.consultaExistenciaTomaInputs);
            $("#dialog_color").on("blur", dialogConsultarExistencia.consultaExistenciaTomaInputs);

            $.ajax({
                url: window.location.origin + '/' +  window.location.pathname.split('/')[1] + '/backoffice/ajax/catalogos_acciones.php',
                method:'post',
                dataType:'json',
                data: {
                    accion: 'obtenCatalogo',
                    catalogo: ['producto_general', 'color', 'color_alfabetico_desc', 'color_alfabetico', 'bodega'],
                    genera: true,
                    customAutocomplete: true,
                },
            })
            .done(function(response) {
                bodegas=response.catalogos.bodega;
                productos_generales_dialog = response.catalogos.producto_general;
                colores_dialog = response.catalogos.color;
                colores_alfabetico_dialog = response.catalogos.color_alfabetico;
                colores_alfabetico_desc_dialog = response.catalogos.color_alfabetico_desc;

                $d.initAutoComplete('#dialog_bodega', response.catalogos.bodega, '#dialog_bodega_id', (bodega) => {
                    dialogConsultarExistencia.consultaExistencia();
                });
                $d.initAutoComplete('#dialog_producto', response.catalogos.producto_general, '#dialog_producto_id', (producto) => {
                    dialogConsultarExistencia.consultaExistencia();
                });
                $d.initAutoComplete('#dialog_color', response.catalogos.color, '#dialog_color_id', (color) => {
                    dialogConsultarExistencia.consultaExistencia();
                });
            })
            .fail(function(jqXHR, textStatus, errorThrown) {

            })
            .always(function(data, textStatus, jqXHR) { //data|jqXHR, textStatus, jqXHR|errorThrown

            });
        },

        show: function () {
            if (dialogConsultarExistencia.version === 'UI') {
                $('#close_dialog_existencia_producto').hide();
                $('#title_dialog_existencia_producto').hide();
                $( "#consultaExistenciaProducto" ).dialog( "open" );
                return;
            }
            $('#consultaExistenciaProducto').height(500).draggable()[0].showModal();
            $('#close_dialog_existencia_producto').click(() =>{ dialogConsultarExistencia.hide(); });

        },

        hide: function () {
            $("#dialog_color").val('');
            $("#dialog_color_id").val('');
            $("#dialog_producto").val('');
            $("#dialog_producto_id").val('');
            $("#dialog_bodega").val('');
            $("#dialog_bodega_id").val('');

            dialogConsultarExistencia.consultaExistencia(
                $('#dialog_bodega_id').val().trim(),
                $('#dialog_producto_id').val().trim(),
                $('#dialog_color_id').val().trim()
            );

            if (dialogConsultarExistencia.version === 'UI') {
                $('#consultaExistenciaProducto').dialog('close');
            } else {
                var existenciasDialog = document.getElementById('consultaExistenciaProducto');
                existenciasDialog.close();
            }
        },

        botonesCasset: function() {
        var grupo =  $("#dialog_existencia_grupo").val().trim(),
            bodega_id =  $('#dialog_bodega_id').val().trim(),
            producto_general_id =  $('#dialog_producto_id').val().trim(),
            color_id=  $('#dialog_color_id').val().trim(),
            lento = $("#dialogo_existencia_lento").is(":checked"),
            saldo = $("#dialogo_existencia_saldo").is(":checked"),
            todo = $("#dialogo_existencia_todo").is(":checked"),
            btn = $("input[name='dialogo_existencia_casset']:checked").prop('checked', false).val();

        if(btn === '' || todo)
            return;

        if(grupo === '' && bodega_id === '' && producto_general_id === '' && color_id === '' &&  !saldo && !lento && !todo ) {
            $('#tabla_consulta_existencia caption').html("Seleccione la bodega, el producto y/o color a consultar" );
            $("#consultaExistenciaProducto").dialog( "option", "title", "Consulta Existencia de Producto");
            $('#tabla_consulta_existencia tbody').html('');
            $('#totales').html('');
            $('#dialog_existencia_footer').html('');
            return;
        }

        if(grupo !== '' || bodega_id !== '' || producto_general_id !== '' || color_id !== '' ||  saldo || lento) {
            $("#dialogo_existencia_todo").prop('checked', false);
            todo = false;
        }
        $("HTML").addClass('wait');
        $.ajax({
            url: window.location.origin + '/' +  window.location.pathname.split('/')[1] + '/backoffice/ajax/existencia_acciones.php',
            method:'post',
            cache:false,
            dataType:'json',
            data: {
                accion: 'consultarExistenciasBotonesDo',
                grupo: grupo,
                bodega_id: bodega_id,
                producto_general_id: producto_general_id,
                color_id: color_id,
                saldo:saldo ? '1' : '',
                lento: lento ? '1' : '',
                todo: todo ? '1' : '',
                'orden_color': $("input[name='dialogo_existencia_orden_color']:checked").val(),
                groupBy: $("#dialogo_existencia_swap").data('group'),
                btn : todo ? '': btn,
                donde: $("#dialogo_existencia_donde").is(":checked") ? '1' : '',
            }
        }).done(function(data) {
            if(!data.status) {
                alert("not ok");
                $("HTML").removeClass('wait');
                return;
            }
            var got = data.set, val='';
            for (var prop in got) {
                if (got.hasOwnProperty(prop)) {
                    val = got[prop];
                    switch(prop) {
                        case 'grupo': continue;
                        case 'grupo_id': $("#dialog_existencia_grupo").val(val); break;
                        case 'bodega_id': $("#dialog_bodega_id").val(val); break;
                        case 'bodega': $("#dialog_bodega").val(val); break;
                        case 'producto_general_id': $("#dialog_producto_id").val(val); break;
                        case 'producto_general': $("#dialog_producto").val(val); break;
                        case 'color_id': $("#dialog_color_id").val(val); break;
                        case 'color': $("#dialog_color").val(val); break;
                    }
                }
            }
            dialogConsultarExistencia.consultaExistencia(true);
        })
            .fail(function(jqXHR, textStatus, errorThrown) {
                alert(textStatus);
                $("HTML").removeClass('wait');
                console.log("ajax boton failed: ", arguments);
            }).always(function(data, textStatus, jqXHR) { //data|jqXHR, textStatus, jqXHR|errorThrown

        });
    },

        sessionStorageSet: function(key, value) {
            if(typeof window.sessionStorage !== 'object')
                return;
            window.sessionStorage.setItem('dlgExistencia' + key, value);
        },

        sessionStorageGet: function(key) {
            if(typeof window.sessionStorage !== 'object')
                return '';
            var ret = window.sessionStorage.getItem('dlgExistencia' +key);
            return ret === null ? '' : ret;
        },

        localStorageSet: function(key, value) {
          if(typeof window.localStorage !== 'object')
              return;
          window.localStorage.setItem('dlgExistencia' + key, value);
        },

        localStorageGet: function(key) {
            if(typeof window.localStorage !== 'object')
                return '';
            var ret = window.localStorage.getItem('dlgExistencia' +key);
           return ret === null ? '' : ret;
        },

        consultaExistencia: function (forza, showColor) {
            var grupo =  $("#dialog_existencia_grupo").val().trim(),
                bodega_id =  $('#dialog_bodega_id').val().trim(),
                producto_general_id =  $('#dialog_producto_id').val().trim(),
                color_id=  $('#dialog_color_id').val().trim(),
                lento = $("#dialogo_existencia_lento").is(":checked"),
                saldo = $("#dialogo_existencia_saldo").is(":checked"),
                todo = $("#dialogo_existencia_todo").is(":checked")
            ;
            if(typeof forza==='object' || typeof forza === 'undefined')
                forza = false;


            if(!forza && grupo === '' && bodega_id === '' && producto_general_id === '' && color_id === '' &&  !saldo && !lento && !todo ) {
                $('#tabla_consulta_existencia caption').html("Seleccione la bodega, el producto y/o color a consultar" );
                $("#consultaExistenciaProducto").dialog( "option", "title", "Consulta Existencia de Producto");
                $('#tabla_consulta_existencia tbody').html('');
                $('#totales').html('');
                $('#dialog_existencia_footer').html('');
                $("#dialogo_existencias_botones").css('visibility', 'hidden');
                return;
            }
            // dialogConsultarExistencia.localStorageSet('grupo', grupo);
            // dialogConsultarExistencia.localStorageSet('bodega_id', bodega_id);
            // dialogConsultarExistencia.localStorageSet('bodega', $('#dialog_bodega').val());
            // dialogConsultarExistencia.localStorageSet('groupBy', $("#dialogo_existencia_swap").text());
            dialogConsultarExistencia.localStorageSet('ordenColor', $("input[name='dialogo_existencia_orden_color']:checked").attr('id'));

            if(grupo !== '' || bodega_id !== '' || producto_general_id !== '' || color_id !== '' ||  saldo || lento) {
                $("#dialogo_existencia_todo").prop('checked', false);
                todo = false;
            }
            if(todo)
                $("#dialogo_existencias_botones").css('visibility','hidden');
            else
                $("#dialogo_existencias_botones").css('visibility',
                    grupo !== '' || bodega_id !== '' || producto_general_id !== '' || color_id !== ''  ? 'visible' : 'hidden');

            $('#label_consultando_existencia').html('Buscando existencia ...');
            $("HTML").addClass('wait');
            $.ajax({
                url: window.location.origin + '/' +  window.location.pathname.split('/')[1] + '/backoffice/ajax/existencia_acciones.php',
                data: {
                    accion: 'consultarExistenciaParaDialogoTotalizado',
                    grupo: grupo,
                    bodega_id: bodega_id,
                    producto_general_id: producto_general_id,
                    color_id: color_id,
                    saldo:saldo ? '1' : '',
                    lento: lento ? '1' : '',
                    todo: todo ? '1' : '',
                    'orden_color': $("input[name='dialogo_existencia_orden_color']:checked").val(),
                    donde: $("#dialogo_existencia_donde").is(":checked") ? '1' : '',
                    groupBy: $("#dialogo_existencia_swap").data('group'),
                }
            })
            .done(function(response) {
                var
                    bodega=$("#dialog_bodega").val().trim(),
                    producto=$("#dialog_producto").val().trim(),
                    color=$("#dialog_color").val().trim(),
                    grupo=$("#dialog_existencia_grupo").val().trim(),
                    lento = $("#dialogo_existencia_lento").is(":checked")
                ;
                if (bodega)
                    $('#icon_clean_bodega')._show();
                if (producto)
                    $('#icon_clean_producto')._show();
                if (color)
                    $('#icon_clean_color')._show();

                var captionPrint = '';
                if((grupo === '' || grupo === "''") && bodega === '')
                    captionPrint += 'Existencia General';
                else {
                    if (grupo !== '' && grupo !== "''")
                        captionPrint += grupo;
                    if (bodega !== '')
                        captionPrint += " " + bodega;
                }
                if(captionPrint.length)
                    captionPrint += "<br>";
                var productoColor = (producto + " " + color).trim();
                if(productoColor.length)
                    captionPrint +=  `<b>${productoColor}</b>`;

                $("#consultaExistenciaProducto").dialog(
                    "option", "title", "Existencias de: " + captionPrint.replaceAll('<b>', '').replaceAll('</b>', '').replaceAll('<br>', ' ') );
                $('#tabla_consulta_existencia caption').html( captionPrint );
                $("#dialog_existencia_th_title").html(captionPrint + "<p>" + response.ahora + ", " + response.usr + "</p>");
                $('#tabla_consulta_existencia tbody').html(response.totalizado);
                $('#totales').html(`<td></td>
                        <td class="t_gran_total_above">${numFormatter(response.totales.existencia_rollos,0)}</td>
                        <td class="t_gran_total_above">${numFormatter(response.totales.existencia_quantity, 2)}</td>`);

                $('#dialog_existencia_footer').html(`
                <tr>
                    <td class="der">Gran Total
                    <td class="t_gran_total_below">${numFormatter(response.totales.existencia_rollos,0)}</td>
                    <td class="t_gran_total_below">${numFormatter(response.totales.existencia_quantity, 2)}</td>`);
                if(todo) {
                    showLevel(2);
                } else {
                    var prevLevel = dialogConsultarExistencia.sessionStorageGet('level');
                    if(prevLevel === '')
                        prevLevel = 2;
                    if(prevLevel <= 0)
                        showAll();
                    else
                        showLevel(prevLevel);
                }
                $("HTML").removeClass('wait');
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                $("HTML").removeClass('wait');
            })
            .always(function(data, textStatus, jqXHR) { //data|jqXHR, textStatus, jqXHR|errorThrown

            });
    },

        limpiar: function (idInput) {
            if(typeof idInput === 'undefined')
                idInput = null;
            if (idInput !== null) {
                $("#" + idInput).val('').trigger('change');
                $('#'+idInput+ '_id').val('');
                if (idInput === 'dialog_bodega')
                    $('#icon_clean_bodega')._hide();
                if (idInput === 'dialog_producto')
                    $('#icon_clean_producto')._hide();
                if (idInput === 'dialog_color')
                    $('#icon_clean_color')._hide();
                dialogConsultarExistencia.consultaExistencia();
            }
        },

        reGroupBy: function() {
            var bodegaProducto = "<span class='t_level_menu' onClick='showLevel(1)' title='Ver totales por Bodega'>Bodega</span> / <span class='t_level_menu' onClick='showLevel(2)' title='Ver existencia por Producto en cada bodega, sin importar el color'>Producto</span> / <span class='t_level_menu' onClick='showAll()' title='Ver existencia de cada Producto con Color por Bodega'>Color</span>";
            var productoColor = "<span class='t_level_menu' onClick='showLevel(1)' title='Click ver existencias por Producto en todos los Colores y Bodegas'>Producto</span> / <span class='t_level_menu' onClick='showLevel(2)' title='Click existencia del Producto por Color en todas las bodegas'>Color</span> / <span class='t_level_menu' onClick='showAll()' title='Ver en que bodega estan'>Bodega</span>";
            var productoBodega = "<span class='t_level_menu' onClick='showLevel(1)' title='Ver existencias por Producto en todos los Colores y Bodegas'>Producto</span> / <span class='t_level_menu' onClick='showLevel(2)' title='Ver existencias por Producto en cada Bodega, sin importar el color'>Bodega</span> / <span class='t_level_menu' onClick='showAll()' title='Ver Colores del Producto en cada Bodega'>Color</span>";
            var $swap = $("#dialogo_existencia_swap"), era=$swap.text();
            var $ordena = $("#dialogo_existencia_ordena");
            switch(era) {
                case '⦽':
                    $swap.html("⬰").attr('title','Cambia a totales por Bodega / Producto / Color').data('group', ['producto','bodega',  'color']);
                    $ordena.html(productoBodega);
                    break;
                case '⬰':
                    $swap.html('⇴').attr('title','Cambia a totales por Producto / Color / Bodega').data('group', ['bodega', 'producto', 'color']);
                    $ordena.html(bodegaProducto);
                    break;
                case '⇴':
                    $swap.html("<span style='font-size:0.5em'>⦽</span>").attr('title','Cambia a totales por  Producto  / Bodega/ Color').data('group',['producto', 'color', 'bodega']);
                    $ordena.html(productoColor);
                    break;

            }
            dialogConsultarExistencia.consultaExistencia();
        },

    };

    Object.freeze(dialogConsultarExistencia);
