<?php

$h = param('iah', param('h'));
if(!usuarioTipoRony())
switch(Permisador::puede('pedido_china')) {
    case 'Nada':
        include_once("../backoffice/sin_permiso.php");
        die();
    case 'R/O':
       $_REQUEST['iah'] = $_REQUEST['h'] = $h = 'r';
}
$tmpPedidoId = strit($values['pedido_id'] ?? '');
$productos_colores = json_encode(ia_sqlKeyValue("
    SELECT /* color si se puede*/ CONCAT(pc.producto_general_id, pc.color_id), c.color
    FROM producto_color pc
        JOIN producto_general pg on pc.producto_general_id = pg.producto_general_id
        JOIN color c on pc.color_id = c.color_id
    WHERE pc.activo = 'Si' AND pc.prohibido = 'No' AND pg.activo = 'Si' AND c.activo = 'Si'
    UNION
    SELECT CONCAT(pi.producto_general_id, pi.color_id), c.color
    FROM pedido_items pi JOIN color c ON c.color_id =pi.color_id
    WHERE pi.pedido_id = $tmpPedidoId"
));
function getImportadoresOptions($importador_id):string {
    $options = [];
    $function = __FUNCTION__;
    $sql = "SELECT /*$function*/ importador_id, nombre, dias FROM importador WHERE activo='Si' ORDER BY nombre";
    foreach(ia_sqlArrayIndx($sql) as $d)
        $options[] = "<option value='$d[importador_id]' data-dias='$d[dias]'"
                . ($d['importador_id'] == $importador_id ? 'SELECTED="SELECTED" ' : '') . ">" .
            htmlentities($d['nombre']) .
            "</option>";
    return implode("\r\n\t", $options);
}

echo "
<!--suppress ES6ConvertVarToLetConst -->
<script>
    var productos_colores = $productos_colores;
    var bodega_eta_es = '$values[bodega_eta_es]';
    var arrIgnore = [];
    var arrInclude = [];
</script>";

$h_real = $h;
$h = $h === 'b' ? 'r': $h;
if(($h === 'e' || $h === 'r') && empty($values['items']))
    $values['items'] = $this->getItems();

if($h === 'i')
    $values['items'] = json_decode($this->values['items'] ?? "[]", true);

if ($h === 'a') {
    $values['numero'] = $this->getNextNumber();
}


if(!usuarioTipoRony() && strcasecmp($values['activo'], 'Si') !== 0) {
    switch(Permisador::puede('pedido_china_inactive')) {
        case 'Nada':
            include_once("../backoffice/sin_permiso.php");
            die();
        case 'R/O':
            $paramOri = param('iah', param('h'));
            if( $paramOri !== 'r' && $paramOri !== 'e') {
                include_once("../backoffice/sin_permiso.php");
                die();
            }
    }
}

if(strcasecmp($values['activo'], 'Si') === 0) {
    $styleCte = empty($values['cliente_id']) ? '' : 'color:red;';
    if(strcasecmp('Entregado', $values['estado']) === 0)
        $inactive =  "<span style='color:#FF0000;font-size:2.6em;'>ACTIVE</span><p style='margin-top:0;padding-top:0;color:red'><i style='font-size: 1rem'>🚚 ¡CON ENTRADA!</i></p>";
    elseif(strcasecmp('Cancelado', $values['estado']) === 0)
        $inactive =  "<span style='color:#FF0000;font-size:2.6em;'>ACTIVE</span><p style='margin-top:0;padding-top:0;color:red'><i style='font-size: 1rem'>¡$values[estado]!</i></p>";
    elseif(strcasecmp($values['mostrar_en_ventas'], 'Si') !== 0)
        $inactive =  "<span style='color:#0000FF;font-size:1.8em;$styleCte'><span style='color:red'>🚫</span> ACTIVE</span><p style='margin-top:0;padding-top:0;$styleCte'><i style='font-size: 0.9em'>No se muestra en ventas</i></p>";
    else
        $inactive =  "<span style='color:#0000FF;font-size:2.6em;font-weight: 100'>ACTIVE</span>";
    $inactiveClass =  '';
    $inactiveMessage = "";
} else {
    $inactiveClass = 'inactiveEnDb';
    $inactive = "<span style='color:red;font-size:2.6em;'>INACTIVE</span>";
    $inactiveMessage = "<span id='inactive' style='font-weight: 800;color:red;font-size:1.2em'>INACTIVE</span>";
}
$tablaDuplicados = duplicados($values);
$tablaNotasEntrada = messageEntradas($values);
$notasDeEntrada = notasDeEntrada($values);
switch(strtolower($values['estado_entrada'])) {
    case 'diferencias': $estado_entrada = '<span style="background-color: yellow">𝚫 Con Diferencias</style>'; break;
    case 'cambios': $estado_entrada = '<span style="background-color: yellow">⦻ Hubo Cambios</style>'; break;
    case 'aceptada': $estado_entrada = '<span style="color:green!important;">Aceptada</span>'; break;
    case 'ok': $estado_entrada = '<span style="color:green!important;">Ok</span>'; break;
    case '':
    default: $estado_entrada='';
}
?>
<!--suppress HtmlUnknownTarget -->
<link rel="stylesheet" href="../js2/jquery-toast/dist/jquery.toast.min.css" />
<script src="../js2/jquery-toast/dist/jquery.toast.min.js"></script>

<style>
    .ui-icon-link {cursor:pointer}

    .btnPedido {
        vertical-align: top;
        margin:0 1em 0.5em 2em;
        padding:0.3em 0.6em;
        width:fit-content;
        cursor: pointer;
        border-radius: 5px;
        border: 1px solid silver;
        box-shadow: 5px 4px 6px 4px silver;
        font-size: 1.2em;
    }

    @media print {
        .noprint {display:none}
        .noPrint {display:none}
        .printOnly {display:initial}
        .printonly {display:initial}
        .copyClipBloard {display:none}
        .jqgrid_actions {display:none}
        .ui-jqgrid-htable {display:none}
        #alertmod_table_productos_pedido {display:none}
        .iactoolbar {display:none}
        BODY {background-color: transparent!important;}
        DIV {background-color: transparent!important;}
        .content_add_producto {background-color: transparent!important;}
        .content_add_productos_color {background-color: transparent!important;}
        DIV {background-color: transparent!important;}
        TABLE, FIGURE {
            page-break-inside: avoid;
        }
        INPUT {
            border:none!important;
            background-color: inherit;
            color:inherit;
        }
        SELECT {
            appearance: none;
            border:none;
            background-color: transparent;
            color:inherit;
        }
        BUTTON {display:none}
    }
</style>
<?php
if(PedidoChina::puede_active_inactive() && ($h === 'e' || $h === 's')) {
    if( strcasecmp($values['activo'], 'Si') === 0) {
        $activo = '<button type="button" class="btnPedido"
            onclick="pedido.active_inactive(\'No\')">Desactivarlo</button>';
    } else {
        $activo =
          '<button type="button" class="btnPedido"
            onclick="pedido.active_inactive(\'Si\')">Activarlo<br/>Mostrando en Ventas</button>
          <button type="button" class="btnPedido"
            onclick="pedido.active_inactive(\'No\')">Activarlo<br/><span style="color:red">SIN MOSTRAR EN VENTAS</span></button> ';
    }
} else {
    $activo = "<span
                id='activo' class='" .(strcasecmp($values['activo'], 'Si') === 0 ? 'activo' : 'inactivo') .
            "'>"  . (strcasecmp($values['activo'], 'Si') === 0 ? 'Activo' : 'Inactivo') . "</span>";
}
if( strcasecmp($values['activo'], 'No') === 0) {
    // en inactive no se vale editar
    $h = 'r';
}
if($h === 'a' || $h === 'i')
    $activo = '';
// dd_($values);
$label = 'Nuevo';
if ($h === 'e')
    $label = 'Editar';

if ($h === 'r')
    $label = '';

if ($h_real === 'b')
    $label = 'Borrar';
$consecutivo = $label === 'Nuevo' ? '' :
    '<div class="flexItem" >
                <label class="bold lbl">Consecutivo</label><br>'.($values['pedido_consecutivo'] ?? '') . '</div>';
$origen_bodega = json_decode( obtenCatalogo('origen_bodega_bodega_grupo_keyValue_all'), true);

$checked_mostrar_en_ventas = 'checked';
$readable_mostrar_en_ventas = '';
if($h === 'r') {
    $aBodega = "<label class='bold lbl' for='origen_bodega_id'>Llega a</label><br>
        <span id='origen_bodega_id'>" . ($origen_bodega[$values['origen_bodega_id']] ?? '') . "</span>";
    $checked_mostrar_en_ventas = $values['mostrar_en_ventas'] === 'Si' ? 'checked':'';
    $readable_mostrar_en_ventas = 'readonly onclick="return false;"';
    setClienteLabel($values);
} else {
    $aBodega = "<label class='bold lbl' for='origen_bodega_id'>Llega a</label><br>
        <select id='origen_bodega_id' class='notSelectize'  name='origen_bodega_id'>" .
        ia_OptionsSetData($origen_bodega, $values['origen_bodega_id'], ['', ''] ) . "</select>";
    if ($h === 'a') {
        $checked_mostrar_en_ventas = 'checked';
    } else {
        $checked_mostrar_en_ventas = $values['mostrar_en_ventas'] === 'Si' ? 'checked':'';
        setClienteLabel($values);
    }

    if (!usuarioTipoRony() ) {
        $readable_mostrar_en_ventas = 'readonly onclick="return false;" tabindex="-1"';
    }
}
function notasDeEntrada($values):array {
    if(empty($values['numero_contenedor']))
        return ['notas' => '', 'productos' => ''];
    $productos = [];
    $resumen = [];
    $notas = ia_sqlArray(
        "SELECT nb.nota_bodega_id, nb.fecha, b.bodega, nb.numero, nb.producto_general_id, pg.producto,
            super_lock, traslado_match_lock, lock_por_tiempo, lock_por_nota_posterior_ajuste,reset_lock
        FROM nota_bodega nb
            JOIN bodega b ON b.bodega_id = nb.bodega_id
            JOIN producto_general pg ON pg.producto_general_id = nb.producto_general_id
        WHERE nb.tipo = 'Container' AND nb.numero_contenedor = " . strit($values['numero_contenedor'] ?? '')
        . " ORDER BY fecha, bodega, numero"
        , "nota_bodega_id");
    foreach($notas as $nota_bodega_id => $n) {
        $fecha = Date('d/M/y', strtotime($n['fecha']));
        $resumen[$nota_bodega_id] =
            "<div style='font-family:Roboto'>
                <a target='_blank' href='../bodega/edita_movimiento.php?iah=e&nota_bodega_id=$nota_bodega_id' title=''>$fecha $n[bodega] $n[numero]</a>
                <p style='text-decoration: none!important;font-weight: 100;color:grey'>" .
                    ucwords(str_replace('_', ' ', NotaBodega::tieneAlgunLock($nota_bodega_id)['tipo'] ?? '')) .
                " $n[producto]</p>" .
            "</div>";
        $productos[$n['producto_general_id']] = $n['producto'];
    }
    asort($productos);
    return [
            'notas' => implode(", ", $resumen),
            'productos' => implode(", ", $productos)
    ];
}

function messageEntradas(&$values):string {
    $pedidoChina = new PedidoChina();
    $return = $pedidoChina->htmlDetails($values['numero_contenedor'] ?? '');
    $values['marca'] = $pedidoChina->getMarca();
    return $return;
}


function duplicados($values):string {
    global $gStrIt;
    $method = __METHOD__;
    $dups = ia_sqlArray(
"SELECT /*$method*/ pedido_id, pedido_consecutivo,
                 own_reference,
                 numero_pi,
                 numero_contenedor,
                 if(our_reference_unico='No', 'rojo', '') as ref_unico,
                 if(numero_pi_unico='No', 'rojo', '') as pi_unico,
                 if(numero_contenedor_unico='No', 'rojo', '') as contenedor_unico,
                 if(quantity='$values[quantity]', 'rojo', '')  as quantity_mal,
                 if(rollos='$values[rollos]', 'rojo', '')  as rollos_mal,
                 quantity,
                 rollos
    FROM pedido
    WHERE activo = 'Si' AND pedido_id <> {$gStrIt($values['pedido_id'])} AND (
            (own_reference<> '' AND own_reference = {$gStrIt($values['own_reference'])}) OR
            (numero_pi<> '' AND numero_pi = {$gStrIt($values['numero_pi'])}) OR
            (numero_contenedor<> '' AND numero_contenedor = {$gStrIt($values['numero_contenedor'])})
        )", 'pedido_id'
    );
    if(empty($dups))
        return '';
    $ret = [];
    foreach($dups as $pedido_id => $d) {
        $q = bcformat($d['quantity'], 2);
        $r = bcformat($d['rollos'], 0);
        $ret[] = strim(<<< HTML
<tr>
  <td><a href="?pedido_id=$pedido_id"  target="_blank">Pedido #$d[pedido_consecutivo]</a>
  <td class="$d[contenedor_unico]">$d[numero_contenedor]
  <td class="$d[pi_unico]">$d[numero_pi]
  <td class="$d[ref_unico]">$d[own_reference]
  <td class="$d[quantity_mal] der">$q
  <td class="$d[rollos_mal] der">$r
</td></tr>
HTML);
    }
    return "<table class='laTabla'><caption style='font-weight: 800;color:red'> ☠ Duplicados</caption><thead><tr>
<th>Pedido</th><th># Contenedor</th><th>PI #</th><th>Our Ref</th><th>Total Quantity</th><th>Total Rolls</th>
</tr></thead><tbody>" .
        implode("", $ret) .
        "</tbody></table>";
}

function setClienteLabel(&$values):void {
    if (empty($values['cliente_id']))
        return;

    $values['cliente_label']=ia_singleread("SELECT nombre FROM cliente WHERE cliente_id = ".strit($values['cliente_id']));
}
?>
<!--suppress CssUnusedSymbol -->
<style>
    .div_attache {display:none}
    .noPedir {color:red;text-decoration: line-through}
    .laTabla TH {white-space: nowrap}
    .laTabla TD {white-space: nowrap}
        .drop {cursor:no-drop}
    .datepickerFit {width:7em}
    .activo {color:green}
    .inactivo {color:red}
    .inactiveEnDb {border-color: darkred}
    .inactiveEnDb > LEGEND {color: darkred}
    LABEL.datoDuplicado {color:red}
    INPUT.datoDuplicado {color:red}
    .content_add_producto {
        border: 1px solid #c5dbec;
        border-bottom: none;
        background: #dfeffc;
        font-weight: bold;
        color: #2e6e9e;
        width: fit-content;
    }

    .content_productos_color .ui-corner-all,
    .content_productos_color .ui-corner-top,
    .content_productos_color .ui-corner-right,
    .content_productos_color .ui-corner-tr {
        border-top-right-radius: unset;
    }
    .content_productos_color .ui-corner-all,
    .content_productos_color .ui-corner-top,
    .content_productos_color .ui-corner-left,
    .content_productos_color .ui-corner-tl {
        border-top-right-radius: unset;
    }
    .content_productos_color .ui-corner-all,
    .content_productos_color .ui-corner-top,
    .content_productos_color .ui-corner-left,
    .content_productos_color .ui-corner-tl {
        border-top-left-radius: unset;
    }
    .content_productos_color .ui-widget.ui-widget-content {
        border-top: none;
    }

    #btn_add {
        margin:0; padding: 0;
    }
    .content_productos_color .ui-state-highlight_row,
    .content_productos_color .ui-widget-content .ui-state-highlight_row,
    .content_productos_color .ui-widget-header .ui-state-highlight_row {
        background: #fbec88 !important;
        /* color: #eae611 !important; */
    }
    .copyClipBloard {cursor:copy}

    U.te {color:darkblue;text-decoration:underline}
    TABLE.te {border-collapse: collapse;border:1px darkblue solid}
    TD.te {text-align:left;vertical-align: top; padding:0.5em; border:1px darkblue solid}
    CAPTION.te {font-weight: 800;color:darkblue}
</style>
<?php
foreach($values as $k => &$v)
    if(!is_array($v) && $k !== 'label' && $k !== 'marca' && $k !== 'remarks')
        $v = ia_htmlentities($v ?? '');
unset($v);
$productosSon = 'Packing List';
if(empty($values['numero_contenedor']))
    $productosSon = 'PI';
if(empty($values['numero_pi']))
    $productosSon = '';
?>
<div id="avisos" style="margin:0 1em;padding:0.5em 1em; color:red"></div>
<fieldset class="<?=$inactiveClass?>">
    <legend><?=$values['marca']?> <?=$label?> China <i>en <?=$values['estado']?></i></legend>
    <fieldset class="<?=$inactiveClass?>">
        <legend>Datos</legend>
        <div class="flexRow" style="align-items:stretch;">
            <div style="display:flex;flex-direction:row;align-items:stretch;border:2px inset whitesmoke;">
                <?=$consecutivo?>
                <div class="flexItem" id="div_numero">
                    <label for="numero" title="Número de Nota" class="bold lbl"><?= $h!='r'?'*':''?> Número</label>
                    <br>
                    <?php if ($h === 'r'):?>
                    <span id="numero"><?=$values['numero']??''?></span>
                    <?php else:?>
                    <input name="numero" id="numero" required="required" class="auto ignore-val input inputEntrada unicos" data-init="" data-autonumeric="{mNum:6,mDec:0,aSep:'',vMax:999999,vMin:0}" type="text" style="width:5em" autocomplete="off" value="<?=$values['numero']??''?>">
                    <?php endif;?>
                </div>
                <div class="flexItem" id="div_own_reference">
                    <label for="own_reference"
                           title="Our Reference, nuestra referencia" class="bold lbl"><?= $h!='r'?'*':''?> Referencia</label>
                    <span class='ui-icon ui-icon-copy copyClipBloard' data-clipboard-target='#own_reference'></span>
                    <span class="duplicado redrojo" style="display:none">DUPLICADO</span>
                    <br>
                    <?php if ($h === 'r'):?>
                    <span id="own_reference"><?=$values['own_reference']??''?></span>
                    <?php else:?>
                    <input name="own_reference" id="own_reference" required="required" class="ignore-val input inputEntrada unicos" type="text" style="width:14em" autocomplete="off" value="<?=$values['own_reference']??''?>">
                    <?php endif;?>
                </div>
            </div>
            <div style="display:flex;flex-direction:row;align-items:stretch;border:2px inset whitesmoke;">
                <div class="flexItem" id="div_bodega_eta">
                    <label id="bodega_eta_es_label" for="bodega_eta_viewdate" title="Tiempo estimado de llegada a la Bodega" class="bold lbl">ETA Bodega
                        <span id="icon_bodega_eta_es"></span>
                        <input type="hidden" id="bodega_eta_es" name="bodega_eta_es" value="<?=$values['bodega_eta_es']?>">
                    </label>
                    <br>
                    <?php if ($h === 'r'):?>
                        <span data-value="<?=$values['bodega_eta']??''?>" id="bodega_eta"><?=mysqlDate2display($values['bodega_eta']??'')?></span>
                    <?php else:?>
                        <input type="hidden" name="bodega_eta" id="bodega_eta" value="<?=$values['bodega_eta']??''?>">
                        <input name="bodega_eta_viewdate" id="bodega_eta_viewdate" class="datepicker input inputEntrada" style="width:7em;text-align:center"
                        onblur="fechaPasadoResalta()" maxlength="11" size="10" type="text" autocomplete="off" value="<?=$values['bodega_eta']??''?>">
                    <?php endif;?>
                    <br><span id="bodega_eta_es_msg" style="font-weight:100;color:silver;font-size:0.8em"></span>
                </div>
                <div class="flexItem" id="div_bodega">
                    <?=$aBodega?>
                </div>
            </div>

            <div class="flexItem" id="div_cliente_id" style="border:2px inset whitesmoke;margin-top:-0.1em;min-width:14em">
                <label for="cliente_label" class="bold lbl">Cliente</label>
                <br>
                <?php if ($h === 'r'):?>
                    <span style="padding-bottom:0.1em" id="cliente_label"><?=$values['cliente_label']??''?></span>
                <?php else:?>
                    <input style="width:14em" type="text" name="cliente_label" id="cliente_label" value="<?=$values['cliente_label']??''?>">
                    <input type="hidden" name="cliente_id" id="cliente_id" value="<?=$values['cliente_id']??''?>">
                <?php endif;?>
            </div>

            <?php if(usuarioTipoRony() || Permisador::puede('importador') !== 'Nada') { ?>
            <div style="border:2px inset whitesmoke;margin-top:-0.1em;min-width:14em; padding: 5px 10px">
                <label for="importador_id" class="bold lbl">Importador</label>
                <br>
                <?php if ($h === 'r'):?>
                    <span style="padding-bottom:0.1em" id="importador_id"><?php
                        echo ia_singleread("SELECT nombre FROM importador WHERE importador_id=" . strit($values['importador_id'] ?? '0'));
                     ?></span>
                <?php else:?>
                    <select class="notSelectize" name="importador_id" id="importador_id" onchange="pedido.importadorChanged(true)">
                    <?php echo getImportadoresOptions($values['importador_id'] ?? '0'); ?>
                    </select>
                    <br><i style="font-size:0.8em;font-weight: 100;color:silver" id="importadorMuestraDias">&nbsp;</i>
                    <a title="Consultas, alta y modificación de Importadores" target="_blank" href="../backoffice/importador.php"><span class="ui-icon ui-icon-link"></span></a>
                <?php endif;?>
            </div>
            <?php } ?>

            <div style="display:flex;flex-direction: row;border:2px inset whitesmoke;">
                <div class="flexItem" style="align-self:flex-start" id="div_mostrar_en_ventas">
                    <label for="mostrar_en_ventas" title="Hacer visible en ventas" class="bold lbl">Mostrar en Ventas</label><br>
                    <?php if($h === 'r' || $activo === 'No' || !usuarioTipoRony())
                        echo $values['mostrar_en_ventas'] . "<input  name='mostrar_en_ventas' type='hidden' value='$values[mostrar_en_ventas]'>";
                        else { ?>
                    <input type="checkbox" name="mostrar_en_ventas" id="mostrar_en_ventas" value="Si" <?=$checked_mostrar_en_ventas?> <?=$readable_mostrar_en_ventas?> />
                    <?php } ?>
                </div>

                <div class="flexItem" style="align-self:flex-start;padding:0 3em;margin:0;display:flex">
                    <div><?=$inactive?></div> <div><?=$activo?></div>
                </div>
            </div>
        </div>
        <div class="flexRow" style="align-items:stretch;">
                <div style="display:flex;flex-direction: column;border:2px inset whitesmoke;">
                    <div style="display:flex;flex-direction: row;align-items:stretch;flex-wrap: nowrap;justify-content: space-between">
                        <div class="flexItem" id="div_numero_pi" >
                            <label for="numero_pi" title="Número PI" class="bold lbl">PI #: </label>
                            <span class='ui-icon ui-icon-copy copyClipBloard' data-clipboard-target='#numero_pi'></span>
                            <span class="duplicado redrojo" style="display:none">DUPLICADO</span>
                            <br>
                            <?php if ($h === 'r'):?>
                                <span data-value="<?=$values['numero_pi']??''?>" id="numero_pi"><?=$values['numero_pi']??''?></span>
                            <?php else:?>
                                <input name="numero_pi" id="numero_pi" class="ignore-val input inputEntrada unicos" style="width:12em" type="text" autocomplete="off" value="<?=$values['numero_pi']??''?>">
                            <?php endif;?>
                        </div>
                        <div class="flexItem" id="div_fecha_pi">
                            <label for="fecha_pi_viewdate" title="Fecha del PI" class="bold lbl">Fecha PI: </label>
                            <br>
                            <?php if ($h === 'r'):?>
                                <span data-value="<?=$values['fecha_pi']??''?>" id="fecha_pi"><?=mysqlDate2display($values['fecha_pi']??'')?></span>
                            <?php else:?>
                                <input type="hidden" name="fecha_pi" id="fecha_pi" value="<?=$values['fecha_pi']??''?>">
                                <input name="fecha_pi_viewdate" id="fecha_pi_viewdate" class="datepicker input inputEntrada" style="width:7em;text-align:center"
                                       onblur="piDateCheck()" maxlength="11" size="10" type="text" autocomplete="off" value="<?=$values['fecha_pi']??''?>">
                            <?php endif;?>
                        </div>
                    </div>
                    <div class="div_attache" data-attach="pi" style="cursor:pointer">
                        <?php if ($h !== 'r') { ?>
                            <div class="custom_file" style="padding:0.3em; width:95%">
                                <input name="json_file_attachments_pi" accept=".xlsx,.xls,.csv"
                                   class="custom_file_input" type="file" multiple="multiple"><label class="custom_file_label_icon">Excel del PI</label>
                            </div>
                        <?php } ?>
                            <ul style="text-align:left"><li>Aba</li></ul>
                    </div>
                </div>

            <div style="display:flex;flex-direction: column;border:2px inset whitesmoke;">
                <div style="display:flex;flex-direction: row;align-items:stretch;flex-wrap: nowrap;justify-content: space-between">
                    <div class="flexItem" id="div_numero_contenedor" style="width: fit-content">
                        <label for="numero_contenedor" title="Número de Contenedor" class="bold lbl"># Contenedor</label>
                        <span title="Copiar al clipboard" class='ui-icon ui-icon-copy copyClipBloard' data-clipboard-target='#numero_contenedor'></span>
                        <span class="duplicado redrojo" style="display:none">DUPLICADO</span>
                        <br>
                        <?php if ($h === 'r'):?>
                            <span id="numero_contenedor" class="autolink"><?=$values['numero_contenedor']??''?></span>
                        <?php if(($values['numero_contenedor']??'') !== '') {?>
                            <span title="Link a notas de entrada" class="ui-icon ui-icon-link autolinkSpan"
                                  onclick="window.open('../backoffice/nota_bodega.php?container=si&iah=e&numero_contenedor=<?=$values['numero_contenedor']??''?>', '_blank')"></span>
                        <?php } ?>
                        <?php else:?>
                            <input placeholder="Container Num" name="numero_contenedor" id="numero_contenedor" class="ignore-val input inputEntrada unicos autolink" style="width:160px" type="text" autocomplete="off" value="<?=$values['numero_contenedor']??''?>">
                        <?php if(($values['numero_contenedor']??'') !== '') {?>
                            <span title="Link a notas de entrada" class='ui-icon ui-icon-link autolinkPrevInput' onclick="autoLink('backoffice/nota_bodega.php','numero_contenedor','numero_contenedor', '&mostrar_productos=si&container=si')"></span>
                            <?php } ?>
                            <p id="numero_contenedor_error" style="color:darkred;font-weight: bold;text-align: center; display:none">¡# Inválido!</p>
                        <?php endif;?>
                    </div>
                    <div class="flexItem" id="div_eta">
                        <label for="eta_viewdate" title="Tiempo estimado de llegado al Puerto" class="bold lbl">ETA PUERTO</label>
                        <br>
                        <?php if ($h === 'r'):?>
                            <span data-value="<?=$values['eta']??''?>" id="eta"><?=mysqlDate2display($values['eta']??'')?></span>
                        <?php else:?>
                            <input type="hidden" name="eta" id="eta" value="<?=$values['eta']??''?>">
                            <input name="eta_viewdate" id="eta_viewdate" class="datepicker input inputEntrada" style="width:7em;text-align:center"
                             onchange="pedido.set_bodega_eta()"   onblur="fechaPasadoResalta();" maxlength="11" size="10" type="text" autocomplete="off"
                                   value="<?=$values['eta']??''?>">
                        <?php endif;?>
                    </div>
                </div>
                <div class="div_attache" id="div_json_file_attachments_packing_list">
                    <?php if ($h !== 'r') {?>
                        <div class="custom_file">
                        <input name="json_file_attachments_packing_list" id="json_file_attachments_packing_list"
                               accept="image/*,.pdf" class="custom_file_input" type="file" multiple="multiple">
                        <label class="custom_file_label_icon" for="json_file_attachments_packing_list"
                               id="icon_json_file_attachments_packing_list">Adjuntar Packing List</label>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <div class="div_attache" id="div_json_file_attachments" style="border:2px inset whitesmoke;">
                <?php if ($h !== 'r') {?>
                    <div class="custom_file" style="vertical-align: top">
                        <input name="json_file_attachments" id="json_file_attachments"
                               accept=".xlsx,.xls,image/*" class="custom_file_input" type="file" multiple="multiple">
                        <label class="custom_file_label_icon" for="json_file_attachments" id="icon_json_file_attachments">Archivos Anexos</label>
                    </div>
                <?php } ?>
            </div>
            <?php if ($h !== 'r'):?>
            <div class="flexItem" style="align-self: flex-start;padding-top:1.4em;border:2px inset whitesmoke;" id="div_edita_rollos" >
                <input type="checkbox" id="edit_rollos" value="Si">
                <label for="edit_rollos" title="Rollos manual o calculados" class="bold lbl">Editar Rollos</label>
            </div>
            <?php endif;?>
<!--
            <div style="display:flex;flex-direction: row;align-items:stretch;border:2px inset whitesmoke;">
                <div class="flexItem">
                    <label for="ancho" title="ancho" class="bold lbl">Width: </label>
                    <br>
                    <?php if ($h === 'r'):?>
                        <span id="ancho"><?=$values['ancho']??''?></span>
                    <?php else:?>
                        <input name="ancho" id="ancho" class="auto ignore-val input inputEntrada input_number"
                               data-autonumeric="{mNum:10,mDec:2,aSep:',',vMax:9999999999.99,vMin:0.00}"
                               style="width:6em" type="text" autocomplete="off" value="<?=$values['ancho']??''?>">
                    <?php endif;?>
                </div>

                <div class="flexItem">
                    <label for="gsm" title="gsm" class="bold lbl">GSM: </label>
                    <br>
                    <?php if ($h === 'r'):?>
                        <span id="gsm"><?=$values['gsm']??''?></span>
                    <?php else:?>
                        <input name="gsm" id="gsm" class="auto ignore-val input inputEntrada input_number"
                               data-autonumeric="{mNum:10,mDec:2,aSep:',',vMax:9999999999.99,vMin:0.00}"
                               style="width:6em" type="text" autocomplete="off" value="<?=$values['gsm']??''?>">
                    <?php endif;?>
                </div>

                <div class="flexItem">
                    <label for="rendimiento" title="rendimiento" class="bold lbl">Rendimiento: </label>
                    <br>
                    <?php if ($h === 'r'):?>
                        <span id="rendimiento"><?=$values['rendimiento']??''?></span>
                    <?php else:?>
                        <input name="rendimiento" id="rendimiento" class="auto ignore-val input inputEntrada input_number"
                               data-autonumeric="{mNum:10,mDec:2,aSep:',',vMax:9999999999.99,vMin:0.00}"
                               style="width:6em" type="text" autocomplete="off" value="<?=$values['rendimiento']??''?>">
                    <?php endif;?>
                </div>
            </div>
-->
            <?php if ($h !== 'r'):?>
            <div class="flexItem" style="align-self: center">
                <button type="button" style="display:none"
                        class="btn btnGenerar-comodin iaGuardar"
                        onclick="iaFormDirty=false;window.location.reload()">Cancelar Cambios</button>
            </div>
            <?php endif;?>
            <div class="flexItem" id="div_nombre" style="display: none;">
                <label for="nombre" title="Nombre del pedido" class="bold lbl"><?= $h!='r'?'*':''?> Nombre</label>
                <br>
                <?php if ($h === 'r'):?>
                    <span id="nombre"><?=$values['nombre']??''?></span>
                <?php else:?>
                    <input name="nombre" id="nombre" class="input inputEntrada" type="text" size="40" autocomplete="off" value="<?=$values['nombre']??''?>">
                <?php endif;?>
            </div>
        </div>

        <div style="margin:1em;display:flex;flex-direction: row;flex-wrap: wrap;gap:2em;justify-content: start">
            <?php echo $notasDeEntrada['notas']?>
        </div>

        <div style="text-align:left;font-weight: normal;clear;both">
            <?php echo PedidoChina::tablitaPiContendor(
                $values['pedido_id'] ?? '',
                $values['pedido_consecutivo'] ?? '',
                $values['own_reference'] ?? '',

                $values['numero_pi'] ?? '',
                $values['numero_contenedor'] ?? '',
                $values['eta'] ?? '',
                $values['bodega_eta'] ?? '',
                $values['estado'],
                $values['estado_entrada'],
            ); ?>
        </div>

        <?=$tablaDuplicados?>

        <div class="flexRow">
            <div class="flexItem" style="align-self:flex-start">
                <?=$tablaNotasEntrada?>
            </div>
        </div>


    </fieldset>

    <fieldset class="content_productos_color <?=$inactiveClass?>">
        <legend>Productos Capturando: <?=$productosSon?>
            <img class="noprint" style='cursor:pointer; margin-left: 2em;height:32px; width:32px;border:0 silver solid;' src='../img/collapseAll.png' alt='Collapse all' title='Collapse all' onclick='iaJqGridGrouping.collapseAll( gridhandler )' id='collapse_all_existencias'>
            <img class="noprint" style='cursor:pointer; margin-left: 2em;height:32px; width:32px ;border:0 silver solid;' src='../img/expandAll.png' alt='Expand all' title='Expand all' onclick='iaJqGridGrouping.expandAll( gridhandler )' id='expand_all_existencias'>
        </legend>
            <!--suppress HtmlFormInputWithoutLabel -->
        <textarea name="items" id="items" cols="30" rows="10" hidden readonly disabled><?= str_replace('"', "'", json_encode($values['items']??[]))?></textarea>
        <div style="display:flex;flex-wrap: wrap;align-items: flex-start"><div>
            <?php if ($h !== 'r'):?>
                <div class="flexRow content_add_producto noprint">
                <div class="flexItem" id="div_producto">
                    <label for="producto_general_label" title="Categoría de producto" class="bold lbl" id="label_for_producto">* Producto</label>
                    <br>
                    <input name="producto_general_label" id="producto_general_label" type="text" autocomplete="off" class="input inputEntrada ui-autocomplete-input ignoreFormDirty" data-campo="producto_general_label" value="" accesskey="P" style="width: 250px;">
                    <input name="producto_general_id" id="producto_general_id" type="hidden" data-campo="producto_general_id" value="">
                </div>
                <div class="flexItem" id="div_color">
                    <label for="color_label" title="Color del producto" class="bold lbl" id="label_for_color">(F3) Color</label>
                    <br>
                    <input name="color_label" id="color_label" type="text" autocomplete="off" class="input inputEntrada ui-autocomplete-input ignoreFormDirty" data-campo="color_label" value="" accesskey="C" style="width: 170px;">
                    <input type="hidden" id="color_id_selected" name="color_id_selected">
                </div>
                <div class="flexItem" id="div_quantity">
                    <label for="quantity" title="Quantity" class="bold lbl">Quantity</label>
                    <br>
                    <input name="quantity" id="quantity"
                           class="auto ignore-val input inputEntrada input_number ignoreFormDirty" style="width:110px"
                           data-autonumeric="{mNum:10,mDec:2,aSep:',',vMax:9999999999.99,vMin:0.00}"
                           type="text" size="14" autocomplete="off" value="">
                            <span style="font-family: Courier monospace" id="unidad_label">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                </div>

                <div class="flexItem" id="div_rollos" style="width: 71px">
                    <label for="rollos" title="Número de rollos" class="bold lbl">Rollos</label>
                    <br>
                    <input name="rollos" id="rollos" class="auto ignore-val input inputEntrada input_number ignoreFormDirty"
                           style="width:70px" data-autonumeric="{mNum:10,mDec:0,aSep:',',vMax:9999999999,vMin:0}"
                           type="text" autocomplete="off" value="" disabled readonly>
                </div>
                <div class="flexItem" id="div_button">
                    <button id="btn_add" type="button"
                            class="btn btnGenerar-comodin " onclick="pedido.agregaProducto()" style="width: 50px !important;">+(F4)</button>
                </div>

                <div class="flexItem" id="div_button" >
                    <i style="color:#0000FF;background-color:yellow;cursor:pointer;font-size:2em" title="Calculadora de contendores" onclick="containerCalc.dialog(this)" class="fa-duotone fa-calculator"></i>
                </div>
            </div>
            <?php endif;?>
                <div class="content_productos_color">
                    <table id="table_productos_pedido"></table>
                    <div id="table_productos_pedido_pager"></div>
                </div>
            </div>
            <div style="display:flex;flex-direction: column">
                <div style="padding:1em;font-weight: normal;text-align: left;vertical-align: top;">
                    <label for='remarks' title="Remarks" class="bold lbl">Remarks</label><br />
                    <?php if($h_real === 'r')
                        echo $values['remarks'];
                    else
                        echo "<textarea style='width:45em; min-height: 350px;' data-validation-engine='validate[maxSize[64000]]' " .
                                  " name='remarks' id='remarks'>$values[remarks]</textarea>";
                    ?>
                </div>

            </div>
        </div>
    </fieldset>
</fieldset>
<table id="mytable"></table>
<!--suppress ES6ConvertVarToLetConst -->
<script>
    const gHoy = <?=Date("'Y-m-d'")?>;
    const hreal = '<?=$h_real?>' ;
    const h = '<?=$h?>' ;
    var gridhandler;
    var productos;
    let producto_general_info =[];
    var $gridParams = {};
    var items_ori = [], items_by_producto_color = [];
    var editando_producto = false, last_selected_row_id = '';
    $(function (){

        gridhandler = $("#table_productos_pedido");
        if(hreal === 'r' || h === 'r') {
            $("#iaGuardar").remove();
            let forma = $("#iafrm_pedido");
            forma.prop("action", forma.attr("action").replace("iah=e", "iah=r") );
        }
        tinymce.init({
            selector: "#remarks",
            encoding: 'html',
            entity_encoding: 'named',
            entities: 'dollar,&,amp,&amp,60,62,num,ast,plus,period,sol,bsol,quot,apos',
            theme: 'silver',
            skin: 'small',
            invalid_elements: "frame,script,link,meta,object,meta,embed,iframe,input,button,textarea,map,area,progress,ruby,rt,rp,dialog,command,dfn,keygen,output,var",
            menubar: false,
            statusbar: true,
            elementpath: false,
            plugins: "image paste tabfocus insertdatetime emoticons",
            toolbar: "insertdatetime |  image | emoticons | forecolor backcolor | bold italic underline strikethrough | fontselect fontsizeselect | pastetext pasteword selectall",
            resize: true,
            deprecation_warnings : false,
            theme_advanced_resizing: true,
            //insertdatetime_formats: ["<b><i>%d/%b/%Y %H:%M</i></b> ", "<b><i>%d/%b/%Y</i></b> ", "<b><i>%Y-%m-%d %H:%M</i></b> "],
            insertdatetime_formats: [' %d/%b/%Y %H:%M '],
            setup: function (ed) {
                ed.once("change", function () {
                    iaFormSetDirty(true);
                });
            },
            forced_root_block: false, // usar br en vez de p en enter
            tabfocus_elements: ":prev,:next",
            autoresize_min_height: 150,
            autoresize_min_width: 450,
            autoresize_bottom_margin: 4,
            autoresize_overflow_padding: 4,
            autoresize_on_init: false,
            paste_auto_cleanup_on_paste: true,
            paste_remove_styles: true,
            paste_remove_styles_if_webkit: true,
            paste_strip_class_attributes: true,
            paste_as_text: true,

            file_picker_types: 'file image media',
            image_caption:false,
            image_advtab:false,
            image_description:false,
            image_dimensions:false,
            image_title:false,
            image_uploadtab:false,
            iconic_list: [ // 1) si no inician con / estan en: js2/tinymce/plguin/iconic/img.
                // 2) se despliegan a 24px height width el que de para 24px de alto
                ["../img/tick.png", "../img/tache_rojo_plano.gif", "../img/error.png", "../img/16-signo-interrogacion.png"],
                ["thumb1-up.svg", "thumb1-right.svg", "thumb1-down.svg", "thumb1-left.svg"],
                ["arrow1_up.svg", "arrow1_right.svg", "arrow1_down.svg", "arrow1_left.svg"],
                ["semaphore_green.svg", "semaphore_yellow.svg", "semaphore_red.svg", "semaphore_off.svg", "semaphore_on.svg"],
            ],
            image_list: [
                {title: "Ok", value: "/" + iacBaseDir + "/img/tick.png"},
                {title: "Tache", value: "/" + iacBaseDir + "/img/tache_rojo_plano.gif"},
                {title: "Atencion", value: "/" + iacBaseDir + "/img/error.png"},
                {title: "Duda", value: "/" + iacBaseDir + "/img/16-signo-interrogacion.png"},
            ],
        });

        $.ajax({
            url:'../backoffice/json/producto_general_info.html',
            method:'POST',
            cache:false,
            dataType:'json',
        })
        .done(function(data) {
            producto_general_info = data;

        }).always(function() {
            gridhandler = pedido.grid_productos;

            items_ori = JSON.parse(($('#items').val()).replaceAll("'", '"'));
            items_by_producto_color = jsObjetivisa_(items_ori, 'producto_color_id', true);
            // incializaHotKeysInputs(".content_add_producto");

            runAfterFetchingCatalogs(() => {
                productos  = jsObjetivisa_($vitex_globales.g_cat_producto_general, 'producto_general_id', true);
                if(h !== 'r' && h !== 'b' && h !== 'd' )
                    pedido.initControles();
            }, 'g_cat_producto_general');


            activaDesactiva($("#activo").val());
            pedido.initGridProductos();

            incializaHotKeysInputs();
            $(".unicos").on("blur", marcaNonUnique)
            marcaNonUnique();
            fechaPasadoResalta();

        });

        reportaAvisos();
    });

    let pedido_activo = <?php echo $values['activo'] === 'Si' ? "true" : "false"; ?>;
    let pedido_entregado = <?php echo $values['estado'] === 'Entregado' ? "true" : "false"; ?>;

    function activaDesactiva(val) {
        if(val === 'No') {
            $("#mostrar_en_ventas").attr("disabled", true)[0].checked = false;
            $("LABEL[for='mostrar_en_ventas']").css({color:"lightblue"});
        } else {
            $("#mostrar_en_ventas").attr("disabled", false);
            $("LABEL[for='mostrar_en_ventas']").css({color:""});
        }
    }


    const pedido = {
        record: (h === 'e' || h === 'r' || h === 'b')? <?=json_encode($values)?> :{},
        nopedir: <?php echo json_encode(ia_sqlKeyValue(
                "SELECT CONCAT(producto_general_id, color_id), pedir FROM producto_color WHERE pedir='No'")); ?>,
        es_verificacion: false,
        editando_color: false,
        grid_productos: $('#table_productos_pedido'),
        activarSortRows: true,
        f_colores: [],
        set_bodega_eta_es: function() {
          let $es = $("#icon_bodega_eta_es");
          let $bodega_eta_es = $("#bodega_eta_es");
          switch($bodega_eta_es.val()) {
              case 'Capturada':
                  $es.html('<i title="Fecha capturada Manualmente" class="fa-duotone fa-marker fa-small"></i>');
                  break;
              case 'Estimada por Importador':
                  $es.html('<i title="Fecha estimada por el importador seleccionado" class="fa-duotone fa-arrow-progress fa-small"></i>');
                  break;
              default:
                  $es.html('');
                  break;
          }
          $("#bodega_eta_es_msg").html($bodega_eta_es.val())
        },
        set_bodega_eta: function() {
            try {
                let $eta = $("#eta_viewdate");
                if ($eta.val().trim().length === 0)
                    return;
                let d = $eta.datepicker("getDate");
                let dias = $("#importador_id").find(":selected").data('dias') || 20;
                d.setDate(d.getDate() + dias);
                if(d.getDay() === 0)
                    d.setDate(d.getDate() + 1);
                $("#bodega_eta_viewdate").datepicker("setDate", d);
                $("#bodega_eta_es").val('Estimada por Importador');
                pedido.set_bodega_eta_es();
            } catch(e){}
        },
        importadorChanged: function(changeEtaBodega) {
            let dias = $("#importador_id").find(":selected").data('dias') || 20;
            $("#importadorMuestraDias").html(`Aprox ${dias} días de ETA a Bodega`)
            if(!changeEtaBodega || $("#eta").val() === '')
              return;
            pedido.set_bodega_eta();

        },
        initControles: function (controller = '*') {

            pedido.importadorChanged(false);
            if (controller === '*') {
                this.initInputProductos();
                this.initInputColor();
                $('#quantity').blur(function () {
                    if(this.value.trim() !== '' && $('#producto_general_id').val().trim() !== '' && $('#numero_contenedor').val().trim() === '')
                        calculaRollosEstimados();
                });
                $('#edit_rollos').change(function () {
                    pedido.setEditRolls();
                });
                if(h !== 'r' && h !== 'b' && h !== 'd' ) {
                    let $el = $('#numero_contenedor');
                    $el.blur(function () {
                        pedido.setEditRolls();
                        let $el = $(this), val = $el.val().trim();
                        if(val.length === 0 || is_container_number(val)) {
                            $el.css({color: '', 'background-color': '', 'font-weight': 'normal'});
                            $("#numero_contenedor_error").hide();
                        } else {
                            $el.css({color: 'darkred', 'background-color': 'yellow', 'font-weight': 'bold'});
                            $("#numero_contenedor_error").show();
                        }

                    });
                    let  val = $el.val().trim();
                    if(val.length === 0 || is_container_number(val)) {
                        $el.css({color: '', 'background-color': '', 'font-weight': 'normal'});
                        $("#numero_contenedor_error").hide();
                    } else {
                        $el.css({color: 'darkred', 'background-color': 'yellow', 'font-weight': 'bold'});
                        $("#numero_contenedor_error").show();
                    }
                    this.initInputClientes();
                }
                pedido.setEditRolls();
            }
        },
        setEditRolls: function() {
            const tempEditRolls = !(
                document.getElementById('edit_rollos').checked ||
                document.getElementById('numero_contenedor').value.trim().length >0
            );
            $('#rollos').prop('readonly', tempEditRolls).prop('disabled', tempEditRolls);
            if(!tempEditRolls) {
                document.getElementById('edit_rollos').checked = true;
            }
            $("#rollos").autoNumeric("destroy")
                .autoNumeric({mNum:10,mDec:0,aSep:',',vMax:9999999999,vMin:0})
        },
        initInputClientes: function () {
            var input_cliente_label = $('#cliente_label');
            var configAutoComplete = {
                url: getUrlForAjax('catalogos_acciones.php'),
                accion: 'buscar_valor',
                catalogo: 'cliente',
                label: 'nombre',
                extra_where: "vale = 'Active'",
                campos: ['nombre'],
                strict: true,

                minLength: 0,
                autoFocus: true,
                iOS: true,
                onEmptyValSliceNumber : 0,
            };
            $d.iOSinitAutoCompleteAjax(input_cliente_label[0], configAutoComplete, '#cliente_id', function (cliente) {
                if (empty(cliente)) {
                    $('#mostrar_en_ventas').prop('checked', true);
                } else {
                    $('#mostrar_en_ventas').prop('checked', false);
                }
            });
            input_cliente_label.blur(function () {
                if (empty(this.value.fulltrim())) {
                    $('#mostrar_en_ventas').prop('checked', true);
                } else {
                    $('#mostrar_en_ventas').prop('checked', false);
                }
            });
        },
        initInputProductos: function () {
            let productos = $vitex_globales.g_cat_producto_general;
            $d.initAutoComplete('#producto_general_label', productos, '#producto_general_id', function (item, ui, _this) {
                if (empty(item)) {
                    $(_this).val('').notify("El product no existe", { position:'right', className: 'error' }).focus();
                    $('#unidad_label').text('');
                    $('#rollos').text('');
                    return;
                }
                $('#unidad_label').text(item.unidad);
                let qty = $('#quantity').val();
                if (!empty(qty) && ! empty($('#producto_general_id').val()))
                    calculaRollosEstimados();

                $('#unidades-table').text(item.unidad);

                setTimeout(function () {
                    $('#color_label').focus().select();
                    $("#color_label").autocomplete("close");
                }, 0);
                $(_this).removeClass('input-required');

                pedido.initInputColor();
            }, 0, 'label', false, '', false, null, true, 0, true, false);

        },
        initInputColor: async function (last_color=null) {

            await pedido.trayendoColores($('#producto_general_id'),'colores','producto', last_color);

            let colores = pedido.f_colores;

            $d.initAutoComplete('#color_label', colores, '#color_id_selected', function (item, ui, _this) {
                if (empty(item)) {
                    return $(_this).val('').notify("El color no existe", { position:'right', className: 'error' }).focus();
                }
                setTimeout(function () {$('#quantity').focus().select();}, 0);
                $(_this).removeClass('input-required');
            }, 0, 'label', false, '', false, null, true, 0, true, false);

        },
        trayendoColores: async function (producto, on_table, table, last_color) {
            if (!producto.val().length) return;
           await $.ajax({
                url:'../backoffice/ajax/get_colores_by_producto.php',
                method:'POST',
                data:{accion:`getcolores_producto_general_id`, producto: producto.val(), last_color, pedido_id: $("#id").val() },
                dataType:'json',
            })
            .done(function(data) {

                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error", true);
                    return;
                }
                if(typeof data.productos_colores === 'object')
                    productos_colores = data.productos_colores


                const object_last_color = pedido.f_colores[0];
                pedido.f_colores = data.colors;
                if (last_color) {
                    // agregamos el last_color si no viene en los colores
                    let colores_id = pedido.f_colores.map(({color_id}) => color_id);
                    if (!colores_id.includes(object_last_color.color_id)) {
                        pedido.f_colores.push(object_last_color);
                        pedido.f_colores.sort((a, b) => a.color.localeCompare(b.color));
                    }
                    // pedido.f_colores=pedido.f_colores.concat(data.colors);
                }
                else
                    pedido.f_colores=data.colors;
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError(`Hubo un error en la funcion getcolores`, "Error", true);
                console.log('ajax failed', arguments);
            });
        },
        initGridProductos: function () {
            var _this = this;
            var colModel = [
                {label:"ProductoColorID", name:'producto_color_id',index:'producto_color_id', hidden:true, key:(h === 'a'), sortable:false},
                {label:"PedidoItemID", name:'pedido_item_id', index:'pedido_item_id', hidden:true, key:(h === 'e'), sortable:false},
                {label:"ProductoID", name:'producto_general_id',index:'producto_general_id', hidden:true, sortable:false},
                {label:"Producto", name:'producto_label',index:'producto_label', width:350, 'align': 'right',
                    cellattr:function(rowId, cellValue, rowObject, cm, rData) {
                        try {
                            if(pedido.nopedir.hasOwnProperty(rData.producto_general_id + rData.color_id))
                                return " title='Producto-Color esta marcado NO VALE PEDIR'";
                            if(pedido.nopedir.hasOwnProperty(rData.producto_general_id))
                                return " title='El Producto esta marcado NO VALE PEDIR'";
                        } catch(e) {}
                    },
                },

                {label:"ColorID", name:'color_id',index:'color_id', hidden: true, sortable:false},
                {label:"Color", name:'color_label',index:'color_label', width:190,
                    classes: "gridCellFontNotaBodega", 'align': 'center', sortable:false,
                    summaryTpl: "<div><b>{0} Colores</b></div>",
                    summaryType: "count",
                    summaryRound: 0,
                    editable: true,
                    cellattr:function(rowId, cellValue, rowObject, cm, rData) {
                        try {
                            if(!productos_colores.hasOwnProperty(rData.producto_general_id + rData.color_id))
                                return " class='noPedir' title='Este COLOR es INVÁLIDO para este producto'";
                            if (pedido.nopedir.hasOwnProperty(rData.producto_general_id + rData.color_id))
                                return " class='noPedir' title='Producto-Color esta marcado NO VALE PEDIR'";
                            if(pedido.nopedir.hasOwnProperty(rData.producto_general_id))
                                return " class='noPedir' title='El Producto esta marcado NO VALE PEDIR'";
                            if(pedido.nopedir.hasOwnProperty(rData.color_id))
                                return " class='noPedir' title='El Color esta marcado NO VALE PEDIR'";
                        } catch(e) {}
                    },
                },
                {
                    label:"Quantity", name:'quantity',index:'quantity', width:160,
                    template: colFmt.decimalSeparatorPoint,
                    summaryTpl: "<div><b>{0}</b></div>",
                    summaryType: "sum",
                    summaryRound: 2,
                    sortable:false,
                    editable: true,
                    cellattr:function(rowId, cellValue, rowObject, cm, rData) {
                        try {
                            if (pedido.nopedir.hasOwnProperty(rData.producto_general_id + rData.color_id))
                                return " class='noPedir' title='Producto-Color esta marcado NO VALE PEDIR'";
                            if(pedido.nopedir.hasOwnProperty(rData.producto_general_id))
                                return " class='noPedir' title='El Producto esta marcado NO VALE PEDIR'";
                            if(pedido.nopedir.hasOwnProperty(rData.color_id))
                                return " class='noPedir' title='El Color esta marcado NO VALE PEDIR'";
                        } catch(e) {}
                    },
                },
                {label:"Uni", name:'unidad',index:'unidad', width:50, sortable:false,
                    summaryTpl: "<div><b>{0}</b></div>",
                    summaryType: function(acc, colName, rowData){return rowData.unidad;},
                    cellattr:function(rowId, cellValue, rowObject, cm, rData) {
                        try {
                            if (pedido.nopedir.hasOwnProperty(rData.producto_general_id + rData.color_id))
                                return " class='noPedir' title='Producto-Color esta marcado NO VALE PEDIR'";
                            if(pedido.nopedir.hasOwnProperty(rData.producto_general_id))
                                return " class='noPedir' title='El Producto esta marcado NO VALE PEDIR'";
                            if(pedido.nopedir.hasOwnProperty(rData.color_id))
                                return " class='noPedir' title='El Color esta marcado NO VALE PEDIR'";
                        } catch(e) {}
                    },
                },
                {
                    label:"Rollos", name:'rollos',index:'rollos',width:90,
                    formatter:'integer',formatoptions: {thousandsSeparator: ",", defaultValue: '0'},
                    summaryTpl: "<div><b>{0}</b></div>",
                    summaryType: "sum",
                    summaryRound: 0,
                    align: "right",
                    sortable:false,
                    editable: true,
                    cellattr:function(rowId, cellValue, rawObject, cm, rdata) {
                        if(typeof rdata === 'undefined' || typeof rdata.producto_general_id === 'undefined') {
                            return;
                        }
                        let id = rdata.producto_general_id;
                        if(typeof producto_general_info[id] === 'undefined' ||
                            typeof rdata.rollos === 'undefined' ||
                            rdata.rollos <= 0 ||
                            typeof rdata.quantity === 'undefined'
                        ) {
                            return;
                        }
                        let avg = parseFloat(rdata.quantity)/parseFloat(rdata.rollos);
                        let p = producto_general_info[id];
                        if(avg >= p.min_por_rollo && avg <= p.max_por_rollo) {
                            try {
                                if (pedido.nopedir.hasOwnProperty(rdata.producto_general_id + rdata.color_id))
                                    return " class='noPedir' title='Producto-Color esta marcado NO VALE PEDIR'";
                                if(pedido.nopedir.hasOwnProperty(rdata.producto_general_id))
                                    return " class='noPedir' title='El Producto esta marcado NO VALE PEDIR'";
                                if(pedido.nopedir.hasOwnProperty(rdata.color_id))
                                    return " class='noPedir' title='El Color esta marcado NO VALE PEDIR'";
                                return;
                            } catch(e) {}
                        }
                        return "style='background-color:#FFCCCB' title='Revisa pues no da el AVERAGE: Quantity vs Rollos'";
                    },
                },
                {
                    label:"Usado", name:'used', width:80,
                    formatter:'number',formatoptions: {thousandsSeparator: ",", decimalPlaces:2, defaultValue: '0.00'},
                    summaryTpl: '<div><b>{0}</b> <sub style="color:silver;font-size:0.8em">aprox</sub></div>',
                    summaryType: 'sum',
                    summaryRound: 2,
                    align: "right",
                    sortable:false,
                    editable: true,
                },
                {label:"# Contenedor", name:'numero_contenedor',index:'numero_contenedor', width:145, hidden:true, sortable:false},
                {label:"PI #", name:'numero_pi',index:'numero_pi', width:150, hidden:true, sortable:false},
            ];
            if(h === 'e' || h === 's' || h === 'a' || h === 'i')
                colModel.push(
                    {
                        label:"Actions", name:'actions',index:'actions',formatter: 'actions',
                        fixed:true,search:false,editable:false, sortable:false,resize:false,width:60,
                        formatoptions: {editbutton:false,editformbutton:false,delbutton:false},
                        summaryTpl: '<div class="cen"><span onclick="pedido.removeProductoGeneral(this)" class="ui-icon ui-icon-trash pointer" style="color:red" title="Borrar TODOS los colores del producto"></span></div>',
                        summaryType: function(acc, colName, rowData){return 'X';},
                    },
                )
            let configJqgrid = {
                // datatype: (pedido.record.pedido_id) ? "json": "local",
                datatype: 'local',
                loadonce: true,
                data: items_ori,
                url: getUrlForAjax("movimientos_bodega_acciones.php"),
                // 2023-11-17 postData: {},
                colModel: colModel,
                height: 480,
                width: "auto", // pedido.grid_productos.parent().width()-15,
                filterToolbar: false,
                grouping: true,
                groupingView: {
                    groupField : ['producto_label'],
                    groupColumnShow: [true],
                    groupText: [groupTextProducto()],
                    showSummaryOnHide: false,
                    groupSummary: [true],
                    groupSummaryPos: ['header'],
                    hideFirstGroupCol:false,
                },
                beforeRequest: function(){},
                loadComplete: function (){
                    // 2023-11-17 pedido.grid_productos.jqGrid("hideCol", "rn");
                    vx_asyncFunction(function() {
                    pedido.grid_productos.children("tbody").children("tr.jqgrow").each(function () {
                        // $(this).find("td[aria-describedby=table_productos_pedido_producto_label]").text('');
                        $(this).find("td[aria-describedby=table_productos_pedido_producto_label]").css('color', 'transparent');

                        let td_actions = $(this).find("td[aria-describedby=table_productos_pedido_actions]");
                        var $div = td_actions.children('div'),
                            $id = td_actions.closest("tr.jqgrow").attr("id");

                        if ($div.length === 0) {
                            $div = $('<div>');
                            td_actions.append($div);
                        }
                        $div.html('');

                        $('<a>',{
                            rel:'opener refferer',
                            href:"javascript:pedido.editThisProduct('"+$id+"')",
                            title: 'Editar',
                            mouseover: function() { $(this).addClass('ui-state-hover');},
                            mouseout: function() {  $(this).removeClass('ui-state-hover');}
                        }).css({'margin-left':'5px',float:'left'})
                            .addClass('ui-pg-div ui-inline-custom')
                            .append('<span class="ui-icon ui-icon-pencil"></span>')
                            .appendTo($div);

                        $('<a>',{
                            rel:'opener refferer',
                            href:"javascript:pedido.removeThisProduct('"+$id+"')",
                            title: 'Eliminar',
                            mouseover: function() { $(this).addClass('ui-state-hover');},
                            mouseout: function() {  $(this).removeClass('ui-state-hover');}
                        }).css({'margin-left':'5px',float:'left'})
                            .addClass('ui-pg-div ui-inline-custom')
                            .append('<span class="ui-icon ui-icon-trash"></span>')
                            .appendTo($div);
                    });
                    },0, this);

                    if (h === 'r') {
                        $('td[aria-describedby=table_productos_pedido_actions] div').remove();
                        $('.table_productos_pedidoghead_0 .edit_only_product_option').remove();
                    }
                    // $('td[aria-describedby=table_productos_pedido_actions] div').hide();

                    // console.log("_______ loadComplete llama jqGridPonFooter");
                    jqGridPonFooter();

                },
                gridComplete:function() {/* console.log("_______ gridComplete llama jqGridPonFooter"); */ jqGridPonFooter();},
                footerrow: true,
                sortable:false,
                rownumbers : false,
                onSelectRow: function (id_selected) {
                    if(id_selected.length > 0 && !empty(last_selected_row_id)) {
                        if (id_selected !== last_selected_row_id) {
                            last_selected_row_id = id_selected;
                            if (_this.editando_color) {
                                $('#btn_add').click();
                            }
                        }
                    } else {
                        last_selected_row_id = id_selected;
                    }
                    setGridSelectedRow(id_selected);
                   // _this.grid_productos.editRow(id_selected, true, oneEditFuntionProducto);
                },
                onCellSelect: function (rowId, iCol, content) {
                    if(iCol === 3) {
                        $("#producto_general_label").val(content);
                        $("#producto_general_id").val($(this).getRowData(rowId).producto_general_id || '')  ;
                    }
                },

            };
            initJqGrig('#table_productos_pedido', configJqgrid);
            $gridParams = pedido.grid_productos.jqGrid('getGridParam');
            $('#gview_'+ pedido.grid_productos[0].id + ' .ui-jqgrid-ftable').css('height', '56px');
            $('#gbox_'+ pedido.grid_productos[0].id).css('background', '#FFFFFF');

            if (h !== 'r') {
                $('#table_productos_pedido_producto_label')._hide();
                $('#table_productos_pedido_color_label')._hide();
                $('#table_productos_pedido_quantity')._hide();
                $('#table_productos_pedido_unidad')._hide();
                $('#table_productos_pedido_rollos')._hide();
                /* $('#table_productos_pedido_numero_contenedor')._hide();
                $('#table_productos_pedido_numero_pi')._hide(); */
            }
            if (this.activarSortRows && h !== 'r' && h !== 'b') {
                pedido.grid_productos.sortableRows({
                    opacity: 0.5,
                    cursor: "grab",
                    // revert: true,
                    start: function (ev, ui) {
                        ui.item.addClass("ui-state-highlight_row");
                    },
                    stop: function (ev, ui) {
                        ui.item.removeClass("ui-state-highlight_row");
                        // var elementRow = ui.item.prevUntil('.jqgroup:not(.ui-sortable-placeholder)').last();
                        var elementRow = ui.item.prev('.jqgrow');

                        if (elementRow.length === 0)
                            elementRow = ui.item.next('.jqgrow');

                        let rowData_Compare = pedido.grid_productos.getRowData(elementRow.attr('id'));
                        let rowData = pedido.grid_productos.getRowData(ui.item.attr('id'));
                        if ( typeof rowData_Compare.producto_general_id === 'string' &&
                            typeof rowData.producto_general_id === 'string' &&
                            rowData_Compare.producto_general_id.strcasecmp(rowData.producto_general_id) !== 0) {
                            pedido.grid_productos.find("tbody").first().sortable("cancel");
                        }
                        iaFormSetDirty(true);
                    },
                    update : function () {
                        pedido.grid_productos.jqGrid('getRowData');
                    },

                });
            }

        },
        agregaProducto: function () {

            var $producto_general = $('#producto_general_id'),
                $color_id_selected = $('#color_id_selected'),
                $quantity = $('#quantity');

            let item = {
                // pedido_item_id
                producto_color_id: $producto_general.val()+"_"+$color_id_selected.val(),
                producto_general_id: $producto_general.val(),
                producto_label: $('#producto_general_label').val(),
                color_id: $color_id_selected.val(),
                color_label: $('#color_label').val(),
                quantity: normalizaQuantity($quantity.val()),
                unidad: $('#unidad_label').text(),
                rollos: normalizaQuantity($('#rollos').val()),
                used: containerCalc.calcula($producto_general.val(), normalizaQuantity($quantity.val())),
                numero_contenedor: $('#numero_contenedor').val(),
                numero_pi: $('#numero_pi').val(),
            };

            let rules = {
                producto_general_id: {
                    'required': true,
                    'label': 'Producto',
                    focusAfter: 'producto_general_label'
                },
                color_id: {
                    'required': true,
                    'label': 'Color',
                    focusAfter: 'color_label'
                },
                quantity: {
                    'required': true,
                    'label': 'Quantity',
                    'numeric': true,
                    'min': 1
                },
                rollos: {
                    'required': true,
                    'label': 'Rollos',
                    'numeric': true,
                    'min': 1
                }
            };

            if (validaDatos2(item, rules)) {
                if (pedido.existeProductoColor(item.producto_color_id)) {
                    $('#'+item.producto_color_id).addClass('blink_');
                    setTimeout(function () {$('#'+item.producto_color_id).removeClass('blink_')}, 2000);
                    // $('#'+item.producto_color_id).blink({delay: 200, class: 'blink_'});
                    // setTimeout(function () {$('#'+item.producto_color_id).blink({blink:'no', class: 'blink_'});}, 2000);
                    pedido.grid_productos.setSelection(item.producto_color_id);
                    return ia.alertWarn(`El pedido ya tiene el producto <b>${item.producto_label}</b> con el color <b>${item.color_label}</b>`, 'Agregar Producto', true);
                }
                // pedido.grid_productos.jqGrid(edit === true ? 'setRowData': 'addRowData', color_id, row);

                pedido.grid_productos.jqGrid('addRowData', item.producto_color_id, item);
                pedido.grid_productos.trigger('reloadGrid');
                resetFormColor();
                iaFormSetDirty(true);
            }
        },
        existeProductoColor: function (_id) {
            if (h === 'e') {
                let row = pedido.grid_productos.getRowData().filter(item => item.producto_color_id === _id);
                return !empty(row);
            }
            let row = pedido.grid_productos.getRowData(_id);
            return Object.entries(row).length !== 0;
        },
        removeThisProduct: function (rowId) {
            let row = pedido.grid_productos.jqGrid("getRowData",rowId);
            let confirm = ia.confirm(`Quieres eliminar <b>${row.producto_label+ ' '+ row.color_label}</b> de la lista de pedidos`, 'Eliminar Producto - Color', true);
            confirm.done(function () {
                pedido.grid_productos.jqGrid('delRowData', rowId);
                pedido.grid_productos.setGridParam({grouping : false});
                for(let i = 0; i < items_ori.length; ++i) {
                    let r = items_ori[i];
                    if(row.producto_general_id === r.producto_general_id && row.color_id === r.color_id) {
                        items_ori.splice(i, 1);
                        break;
                    }
                }
                pedido.grid_productos.setGridParam({grouping : true});
                pedido.grid_productos.trigger('reloadGrid');
                iaFormSetDirty(true);
            });
        },
        removeProductoGeneral:function(el) {
            let rowId = $(el).parents("TR").next().attr("id");
            let row = pedido.grid_productos.getRowData(rowId);
            let producto_label = row.producto_label;
            let confirm = ia.confirm(`Confirme <span style="color:red">Eliminar <b>TODO</b> el producto</span>:<div class="cen"><b>${producto_label}</b></div>`, `Borrar: ${producto_label}`, true);
            confirm.done(function () {
                while(typeof row.producto_label === 'string' && producto_label === row.producto_label) {
                    let nextId = $(`TR#${rowId}`).next().attr("id");
                    pedido.grid_productos.jqGrid('delRowData', rowId);
                    for(let i = 0; i < items_ori.length; ++i) {
                        let r = items_ori[i];
                        if(row.producto_general_id === r.producto_general_id && row.color_id === r.color_id) {
                            items_ori.splice(i, 1);
                            break;
                        }
                    }
                    if(typeof nextId === "undefined" || nextId === null)
                        break;
                    rowId = nextId;
                    row = pedido.grid_productos.getRowData(rowId);
                }
                pedido.grid_productos.setGridParam({grouping : true});
                pedido.grid_productos.trigger('reloadGrid');
                iaFormSetDirty(true);
            });
        },

        editThisProduct: function (rowId) {
            /* if (this.editando_color) {
                var producto = $('#producto_general_label').val()+ " "+  $('#color_label').val();
                let confirm = ia.confirm('Se esta editando el producto <b>'+producto+'</b>!<br>¿Quieres continuar sin guardar cambios?', 'Editar Producto', true);
                confirm.done(function () {
                    doEdit();
                });
            } else {
                doEdit();
            } */
            var _this = this;
            doEdit();

            async function  doEdit() {

                let rowData = pedido.grid_productos.getRowData(rowId);
                let $producto_general_label = $('#producto_general_label');
                $producto_general_label.val(rowData.producto_label);
                let $producto_general_id = $('#producto_general_id');
                $producto_general_id.val(rowData.producto_general_id);
                let $color_label = $('#color_label');
                $color_label.val(rowData.color_label)[0].value=rowData.color_label;
                let $color_id_selected = $('#color_id_selected');
                $color_id_selected.val(rowData.color_id);
                $color_label.focus();
                $color_label.autocomplete("close");
                $('#quantity').val(rowData.quantity);
                $('#unidad_label').text(rowData.unidad);
                $('#rollos').val(rowData.rollos);
                _this.editando_color = true;
                let color_anterior={color: $color_label.val(rowData.color_label)[0].value=rowData.color_label,color_id:$color_id_selected.val(),label: $color_label.val(rowData.color_label)[0].value=rowData.color_label,producto_general_id:$producto_general_id.val(),producto:$producto_general_label.val(),real_data: $color_id_selected.val(),real_value: $color_id_selected.val(), value: rowData.color_label};
                pedido.f_colores=[color_anterior];
                pedido.initInputColor($color_label.val());
                $('#btn_add').attr('onclick', "pedido.saveThisProduct('"+rowId+"')");
            }

        },
        saveThisProduct: function (rowId) {

            var rowData = pedido.grid_productos.getRowData(rowId);
            var pedido_item_id = rowData.pedido_item_id;

            var $producto_general = $('#producto_general_id'),
                $color_id_selected = $('#color_id_selected'),
                $quantity = $('#quantity');

            let item = {
                pedido_item_id: pedido_item_id,
                producto_color_id: $producto_general.val()+"_"+$color_id_selected.val(),
                producto_general_id: $producto_general.val(),
                producto_label: $('#producto_general_label').val(),
                color_id: $color_id_selected.val(),
                color_label: $('#color_label').val(),
                quantity: normalizaQuantity($quantity.val()),
                unidad: $('#unidad_label').text(),
                rollos: normalizaQuantity($('#rollos').val()),
                used: containerCalc.calcula($producto_general.val(), normalizaQuantity($quantity.val())),
                numero_contenedor: $('#numero_contenedor').val(),
                numero_pi: $('#numero_pi').val(),
            };

            let rules = {
                producto_general_id: {
                    'required': true,
                    'label': 'Producto',
                    focusAfter: 'producto_general_label'
                },
                color_id: {
                    'required': true,
                    'label': 'Color',
                    focusAfter: 'color_label'
                },
                quantity: {
                    'required': true,
                    'label': 'Quantity',
                    'numeric': true,
                    'min': 1
                }
            };

            var accion = 'setRowData';

            if(validaDatos2(item, rules)) {
                if(!productos_colores.hasOwnProperty(item.producto_general_id + item.color_id)) {
                    ia.alertWarn(`${item.producto_label} <span style="color:red">no tiene permitido el color</span>: ${item.color_label}<div style="margin-top:1em;font-weight: bold">Cambie o elimine el color</div>`, "Color Inválido", true);
                    return;
                }
                console.log(item, rowData);
                if (item.producto_color_id !== rowData.producto_color_id) {
                    // accion = 'addRowData';
                    if (pedido.existeProductoColor(item.producto_color_id)) {
                        $('#'+item.producto_color_id).addClass('blink_');
                        setTimeout(function () {$('#'+item.producto_color_id).removeClass('blink_')}, 2000);
                        pedido.grid_productos.setSelection(item.producto_color_id);
                        return ia.alertWarn(`El pedido ya tiene el producto <b>${item.producto_label}</b> con el color <b>${item.color_label}</b>`, 'Agregar Producto', true);
                    }
                }

                pedido.grid_productos.jqGrid(accion, rowId, item);
                pedido.grid_productos.trigger('reloadGrid');
                // pedido.grid_productos.setSelection(rowId);

                resetFormColor();
                $('#btn_add').attr('onclick', 'pedido.agregaProducto()');
                iaFormSetDirty(true);
                this.editando_color = false;
            }
        },
        groupedProductoPon: function(_anchor) {
            var
                tr_group = $(_anchor).parents('tr.jqgroup'),
                // td = $(_anchor).parent(),
                // input_group_product = td.find('.input_group_product'),
                // input_group_product_data = input_group_product.data(),
                group_items = tr_group.nextUntil('tr.jqgroup').first();
            let rowData = this.grid_productos.getRowData($(group_items).attr("id"));
            $("#producto_general_label").val(rowData.producto_label || '');
            $("#producto_general_id").val(rowData.producto_general_id || '')  ;
        },
        editOnlyProduct: function (_anchor) {
            if (this.editando_color) {
                $('#btn_add').click();
            }

            const _me = this;
            var // tr_group = $(_anchor).parents('tr.jqgroup'),
                td = $(_anchor).parent(),
                label_group_product = td.find('.label_group_product');

            $(_anchor).hide(); // edit
            // $(_anchor).next().show(); // save
            label_group_product.hide();
            const input_group_product = td.find('.input_group_product');
            input_group_product.show();
            $d.initAutoComplete(input_group_product[0], $vitex_globales.g_cat_producto_general, null, function (item, ui, _this) {
                $(_this).removeClass('input-required');
                if (empty(item)) {
                    input_group_product.data('producto_general_id', '');
                    input_group_product.data('producto_label', '');
                    input_group_product.data('unidad', '');
                    $(_this).addClass('input-required');
                    $(_this).val('').notify("El producto no existe", { position:'right', className: 'error' }).focus();
                    setTimeout(function () {
                        $(_this).focus();
                    }, 0);
                    return;
                }
                input_group_product.data('producto_general_id', item.producto_general_id);
                input_group_product.data('producto_label', input_group_product.val());
                input_group_product.data('unidad', item.unidad);
                _me.saveOnlyProduct(_anchor);
            }, 0, 'label', false, '', false,
                // on blur
                function(){
                    pedido.saveOnlyProduct(_anchor);
                },
                true, 0, true, false);


            input_group_product.val(label_group_product.find('.label').text());
            input_group_product.focus();
            input_group_product.autocomplete("close");
        },
        saveOnlyProduct: function (_anchor) {
            var _this = this,
                tr_group = $(_anchor).parents('tr.jqgroup'),
                td = $(_anchor).parent(),
                // label_group_product = td.find('.label_group_product'),
                input_group_product = td.find('.input_group_product'),
                input_group_product_data = input_group_product.data();

            if (empty(input_group_product_data.producto_general_id)){
                input_group_product.addClass('input-required');
                input_group_product.val('').notify("Seleccione un producto!", { position:'right', className: 'error' }).focus();
                setTimeout(function () {
                    input_group_product.focus();
                }, 0);
            }

            var setData = {
                producto_general_id: input_group_product_data.producto_general_id,
                producto_label: input_group_product_data.producto_label,
            };
            let producto_nuevo = input_group_product.val().trim();
            let colores_invalidos = [];
            var group_items = tr_group.nextUntil('tr.jqgroup');
            if(producto_nuevo.length) {
                $.each(group_items, function () {
                    let rowId = this.getAttribute('id');
                    let rowData = _this.grid_productos.getRowData(rowId);
                    if(!productos_colores.hasOwnProperty(setData.producto_general_id + rowData.color_id)) {
                        colores_invalidos.push(rowData.color_label);
                    }
                });
                if (colores_invalidos.length) {
                    $d.toaster(
                        'Color Inválido',
                        `En ${producto_nuevo} no valen los colores: ${colores_invalidos.join(", ")}`,
                        {position: offset(input_group_product[0]), bgColor:'#FF0000'}
                    );
                }
            }

            $.each(group_items, function () {
                let rowId = this.getAttribute('id');
                let rowData = _this.grid_productos.getRowData(rowId);
                setData.producto_color_id = setData.producto_general_id+"_"+rowData.color_id;
                _this.grid_productos.jqGrid('setRowData', rowId, setData);
            });
            _this.grid_productos.trigger('reloadGrid');
            iaFormSetDirty(true);

            function offset(el) {
                try {
                    if (el === null)
                        return 'top-center';
                    var rect = el.getBoundingClientRect(),
                        scrollLeft = window.scrollX || document.documentElement.scrollLeft,
                        scrollTop = window.scrollY || document.documentElement.scrollTop;
                    return {top: rect.top + scrollTop - 80, left: rect.left + scrollLeft}
                } catch(err) {console.log("err", err);
                    console.log("toaster offset() error:", el)
                    return {top: 100,left:  100}
                }
            }
        },
        active_inactive: function(mostrar_en_ventas) {
            $.ajax({
                url:'../backoffice/ajax/pedido_acciones.php',
                method:'POST',
                data:{accion:'active_inactive', pedido_id:pedido.record.pedido_id, mostrar_en_ventas:mostrar_en_ventas},
                dataType:'json',
            })
            .done(function(data) {
                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error", true);
                    return;
                }
                window.location += "&_nq=" + (new Date()).getTime();
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                console.log('ajax failed', arguments);
            })
            ;
        },
    };

    function jqGridPonFooter() {
        let footer = $('#gview_' + pedido.grid_productos[0].id + ' .ui-jqgrid-ftable');
        // Total de productos
        let productos_unit = {}
        pedido.grid_productos.find('tr.jqgroup').each(function() {
            let unit = $('TD[aria-describedby="table_productos_pedido_unidad"]', $(this)).text();
            if(productos_unit.hasOwnProperty(unit))
                productos_unit[unit]++;
            else
                productos_unit[unit] = 1;
        });
        var numUnits = 0;
        var prods = [
            `<p style="text-align:right;margin:0 auto;padding:0.1em"><b>${pedido.grid_productos.find('tr.jqgroup').length}</b></p>`
        ];
        for(let unit in productos_unit)
            if(productos_unit.hasOwnProperty(unit)) {
                numUnits++;
                prods.push(`<p style="text-align:right;margin:0 auto;padding:0.1em;font-size:1.2em">${unit}: <b>${productos_unit[unit]}</b></p>`);
            }
        if(numUnits <= 1)
            delete(prods[1]);
        footer
            .find('td[aria-describedby=table_productos_pedido_producto_label]')
            .html(`<div style="text-align:left;margin-top:0;padding:0 0.1em;font-size:1.1em;font-weight:bold;">Productos:${prods.join("")}<div>`);

        footer.find('td[aria-describedby=table_productos_pedido_color_label]')
            .html('<div style="text-align:left;margin-top:0;padding:0 0.1em;font-size:1.1em;font-weight:bold;">Colores: ' +
                `<p style="text-align:right;margin:0 auto;padding:0.1em"><b>${pedido.grid_productos.getGridParam("reccount")}</b></p>`
            );

        var total_rolls = 0, total_quantity = 0.00;
        var total_quantity_unit = {};
        var total_rolls_unit = {};
        var total_quantity_product = {};
        var unidades= '';
        pedido.grid_productos.getRowData().forEach(function (row) {
            total_rolls = total_rolls + Number(normalizaQuantity(row.rollos));
            total_quantity = total_quantity + Number(normalizaQuantity(row.quantity));
            unidades = row.unidad ?? 'mts';
            if(!total_quantity_unit.hasOwnProperty(unidades)) {
                total_quantity_unit[unidades] = Number(normalizaQuantity(row.quantity));
                total_rolls_unit[unidades] = Number(normalizaQuantity(row.rollos));
            }
            else {
                total_quantity_unit[unidades] += Number(normalizaQuantity(row.quantity));
                total_rolls_unit[unidades] += Number(normalizaQuantity(row.rollos));
            }

            let producto_general_id = row.producto_general_id;
            if(!total_quantity_product.hasOwnProperty(producto_general_id))
                total_quantity_product[producto_general_id] = Number(normalizaQuantity(row.quantity));
            else
                total_quantity_product[producto_general_id] += Number(normalizaQuantity(row.quantity));
        });
        let used = 0.00;
        for(let producto_general_id in total_quantity_product)
            if(total_quantity_product.hasOwnProperty(producto_general_id))
                used += containerCalc.calcula(producto_general_id, normalizaQuantity(total_quantity_product[producto_general_id]));

        numUnits = 0;
        var qtyTotal = "";
        var rollsTotal = "";
        for(let q in total_quantity_unit)
            if(total_quantity_unit.hasOwnProperty(q)) {
                numUnits++;
                qtyTotal += `<p style="text-align:right;margin:0 auto;padding:0.1em">${q} <b>${$.fmatter.util.NumberFormat(total_quantity_unit[q], $.jgrid.formatter.number)}</b></p>`;
                rollsTotal += `<p style="text-align:right;margin:0 auto;padding:0.1em"><b>${$.fmatter.util.NumberFormat(total_rolls_unit[q], $.jgrid.formatter.number)}</b></p>`;
            }
        if(numUnits < 2) {
            qtyTotal = "";
            rollsTotal = "";
        }

        footer
            .find('td[aria-describedby=table_productos_pedido_quantity]')
            .html('<div style="text-align: left;font-size: 1.05em">Quantity: ' +
                '<p style="text-align:right;margin:0 auto;padding:0.1em"><b>'+$.fmatter.util.NumberFormat(total_quantity, $.jgrid.formatter.number) + "</b></p>" + qtyTotal + "<div>");

        footer
            .find('td[aria-describedby=table_productos_pedido_unidad]')
            .html('<div style="text-align: left">Unidad: <br><b id="unidades-table" style="float:right; font-size: 1.5em">'+(!unidades ? '' : unidades)+'</b><div>');
        footer
            .find('td[aria-describedby=table_productos_pedido_rollos]')
            .html('<div style="text-align: left;font-size: 1.05em">Rollos: ' +
                '<p style="text-align:right;margin:0 auto;padding:0.1em"><b>'+$.fmatter.util.NumberFormat(total_rolls, $.jgrid.formatter.number) + "</b></p>" + rollsTotal + "<div>");
        // console.log("    pon used, containers", used)
        // console.log("    pon used en", footer.find('td[aria-describedby=table_productos_pedido_used]'))
        footer
            .find('td[aria-describedby=table_productos_pedido_used]')
            .html('<div style="text-align: left">Containers: <br><b style="float:right; font-size: 1.5em">'+numFormatter( used, 2)+"</b><div>");

    }

    function iacase_submit()     {
        let data = pedido.grid_productos.getRowData();
        for(let item of data)
            if(!productos_colores.hasOwnProperty(item.producto_general_id + item.color_id)) {
                ia.alertError(`${item.producto_label} <span style="color:red">no tiene permitido el color</span>: ${item.color_label}<div style="margin-top:1em;font-weight: bold">Cambie o elimine el color</div>`, "Arregle Color(es) Inválido(s)", true);
                return false;
            }
        $('#items').val(JSON.stringify(data));
        return true;
    }

    function calculaRollosEstimados()     {
        let producto_general_id = $('#producto_general_id').val();
        let producto = productos[producto_general_id];
        let average;
        if (vx_parseFloat(producto.average_calculado)>0) {
            average = vx_parseFloat(producto.average_calculado);
        } else {
            average = (vx_parseFloat(producto.min_por_rollo)+vx_parseFloat(producto.max_por_rollo))/2;
        }
        let qty = $('#quantity').val();
        let average_show = Math.ceil((average>0)?((vx_parseFloat(qty)/average).toFixed(2)):'0');

        if(!isNaN(average_show) && producto_general_id.trim() !== '' && $('#numero_contenedor').val().trim() === '')
            $('#rollos').val( average_show );
    }
    function resetFormColor()     {
        $('.content_add_producto input:not(#div_producto input)').val('');
        if (this.editando_color) {
            $('#quantity').focus();
            return;
        }
        $('#color_label').focus();
        $("#color_label").autocomplete("close");
    }

    /**
    * Sort type in subgrid's gropued rows
    */
    function sortGroup(cellValus, rowData, ty) {
        if(ty === 'producto_label')
            return rowData.producto_label;
       /* if(ty === 'attribute_1')
        return rowData.attr1_order;
       else if(ty === 'attribute_2')
        return rowData.attr2_order; */
    }

    function naturalSort(a, b, d) {
        if(d===undefined) { d=1; }
        var re = /(^-?[0-9]+(\.?[0-9]*)[df]?e?[0-9]?$|^0x[0-9a-f]+$|[0-9]+)/gi,
            sre = /(^[ ]*|[ ]*$)/g,
            dre = /(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,
            hre = /^0x[0-9a-f]+$/i,
            ore = /^0/,
            i = function(s) { return naturalSort.insensitive && (''+s).toLowerCase() || ''+s },
            // convert all to strings strip whitespace
            x = i(a).replace(sre, '') || '',
            y = i(b).replace(sre, '') || '',
            // chunk/tokenize
            xN = x.replace(re, '\0$1\0').replace(/\0$/,'').replace(/^\0/,'').split('\0'),
            yN = y.replace(re, '\0$1\0').replace(/\0$/,'').replace(/^\0/,'').split('\0'),
            // numeric, hex or date detection
            xD = parseInt(x.match(hre)) || (xN.length !== 1 && x.match(dre) && Date.parse(x)),
            yD = parseInt(y.match(hre)) || xD && y.match(dre) && Date.parse(y) || null,
            oFxNcL, oFyNcL;
        // first try and sort Hex code sor Dates
        if (yD)
            if ( xD < yD ) return -d;
            else if ( xD > yD ) return d;
        // natural sorting through split numeric strings and default strings
        for(var cLoc=0, numS=Math.max(xN.length, yN.length); cLoc < numS; cLoc++) {
            // find floats not starting with '0', string or 0 if not defined (Clint Priest)
            oFxNcL = !(xN[cLoc] || '').match(ore) && parseFloat(xN[cLoc]) || xN[cLoc] || 0;
            oFyNcL = !(yN[cLoc] || '').match(ore) && parseFloat(yN[cLoc]) || yN[cLoc] || 0;
            // handle numeric vs string comparison - number < string - (Kyle Adams)
            if (isNaN(oFxNcL) !== isNaN(oFyNcL)) { return (isNaN(oFxNcL)) ? d : -d; }
            // rely on string comparison if different types - i.e. '02' < 2 != '02' < '2'
            else if (typeof oFxNcL !== typeof oFyNcL) {
                oFxNcL += '';
                oFyNcL += '';
            }
            if (oFxNcL < oFyNcL) return -d;
            if (oFxNcL > oFyNcL) return d;
        }
        return 0;
    }
    function piDateCheck() {
       let piDate = valOrText("fecha_pi").trim();
       let piNumber = valOrText("numero_pi").trim();
        let $labelPIDate = $(`LABEL[for='fecha_pi_viewdate']`);
       if(piNumber.length > 0 && (piDate.length === 0 || piDate === '0000-00-00')) {
           $labelPIDate.addClass('datoDuplicado').prop("title", 'FALTA la fecha del documento PI');
           return;
       }
       let $labelPI = $(`LABEL[for='numero_pi']`);
        if(piNumber.length === 0 && piDate.length > 0) {
            $labelPI.css('border','1px solid red').prop("title", 'Tengo la Fecha del PI pero no su NÚMERO');
            return;
        }

        if(piDate > gHoy) {
            $labelPIDate.css('border','1px solid red').prop("title", 'Fecha del PI en el futuro ' + piDate + " vs " + gHoy);
            return;
        }
        if(piNumber.length === 0 && $("#numero_contenedor").val().trim()) {
            $labelPI.css('border','1px solid red').prop("title", 'Número de Contendor SIN PI');
            $labelPIDate.css('border','1px solid red').prop("title", 'Número de Contendor SIN PI');
            return;
        }
        $labelPI.css('border','none').prop("title", 'Número del documento PI');
        $labelPIDate.css('border','none').removeClass('datoDuplicado').prop("title", 'Fecha del documento PI');
        reportaAvisos();
    }
    function fechaPasadoResalta() {
        const d=new Date(); m = (d.getMonth()+1).toString().padStart(2, "0");
        const hoy = `${d.getFullYear()}-${(d.getMonth()+1).toString().padStart(2, "0")}-${d.getDate().toString().padStart(2, "0")}`;
        let debeTenerEta = valOrText("numero_contenedor").length > 0;
        let title = {eta:'Fecha Estimada de Arribo al PUERTO', bodega_eta:'Fecha ESTIMADA arriba a nuestra BODEGA'}
        for(let para of [ 'eta', 'bodega_eta']) {
            let f = valOrText(para);

           // let fEra = $("#"+para).val().trim();
            if(debeTenerEta && pedido_activo && !pedido_entregado && f.length === 0)
                $(`LABEL[for='${para}_viewdate']`).addClass('datoDuplicado').attr('title', " con CONTAINER sin ETA: " + title[para]);
            else if(f.length === 0 || f > hoy || !pedido_activo || pedido_entregado)
                $(`LABEL[for='${para}_viewdate']`).removeClass('datoDuplicado').attr('title', title[para]);
            else
                $(`LABEL[for='${para}_viewdate']`).addClass('datoDuplicado').attr('title', "¡YA PASO! la fecha" + title[para]);
        }
        reportaAvisos();
    }
    function valOrText(id) {
        let ta = $("#" + id);
        if(ta.length === 0)
            return '';
        if(ta[0].tagName === 'INPUT')
            return ta.val().trim();
        if(typeof ta.data('value') === 'undefined')
            return ta.text();
        else
            return ta.data('value');
    }


    function marcaNonUnique() {
        piDateCheck();
        let cual = ['numero', 'own_reference', 'numero_pi', 'numero_contenedor'];
        let send = {
            accion: 'unico',
            pedido_id: pedido.record.pedido_id || "\t",
            unico:{},
        };
        for(let c of cual)
            send.unico[c] = $("#" + c).val().trim();

        $.ajax({
            url:'../backoffice/ajax/pedido_acciones.php',
            method:'GET',
            cache:false,
            data:send,
            dataType:'json',
        })
        .done(function(data) {
            if(!data.status) {
                console.log("ERROR: Ajax pedido_acciones.php accion=unico da status=false", arguments);
                return;
            }
            for(let c in data.unicos || [])
                if(data.unicos.hasOwnProperty(c))
                    if(data.unicos[c])
                        $(`LABEL[for='${c}']`).removeClass('datoDuplicado').prop("title", c).siblings(".duplicado").hide();
                    else
                        $(`LABEL[for='${c}']`).addClass('datoDuplicado').prop("title", "Ya existe otro " + c + " igual").siblings(".duplicado").show();
            if(typeof data.productos_colores === 'object')
                productos_colores = data.productos_colores;
            reportaAvisos();
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            console.log("ERROR: Ajax pedido_acciones.php accion=unico ", arguments)
        });
    }
    function groupTextProducto() {
       return "<b class='label_group_product'><span onclick='pedido.groupedProductoPon(this)' class='label'>{0}</span></b>: " +
           "<input type='text' class='input_group_product input inputEntrada noprint' style='display:none'><a href='javascript:void(0);' onclick='pedido.editOnlyProduct(this)' title='Editar producto' class='ui-pg-div ui-inline-custom edit_only_product_option' style='margin-left: 5px; float: right;'><span class='ui-icon ui-icon-pencil'></span></a><a href='javascript:void(0);' onclick='pedido.saveOnlyProduct(this)' title='Guardar producto' class='ui-pg-div ui-inline-custom edit_only_product_option' style='margin-left: 5px; float: right; display:none'><span class='ui-icon ui-icon-disk'></span></a>"
    }
    function reportaAvisos() {
        let avisos = [];
        $(".datoDuplicado").each(function() {
            let $el = $(this);
            avisos.push( $el.attr("title") );
        });
        let $numero_contenedor_error = $("#numero_contenedor_error");
        if($numero_contenedor_error.length) {
            let numero_contenedor_error = $numero_contenedor_error.html();
            if (numero_contenedor_error.length && $numero_contenedor_error.is(":visible"))
                avisos.push("Contendor: " + numero_contenedor_error);
        }
        $("#bodega_eta_msg").html($("#bodega_eta_es").val());
        $("#avisos").html(avisos.length ? "Revise:<p>* " + avisos.join("</p><p>* ") + "</p>" : "");
    }

    function oneEditFuntionProducto(rowId) {

        var input_color = rowId+"_color_label", input_qty = rowId+"_quantity";
        incializaHotKeysInputs('#'+rowId, rowId+'_');
        initColor();

        $('#'+input_qty).autoNumeric({
            mNum:10,
            mDec:2,
            aSep:',',
            vMax:9999999999.99,
            vMin:0.00
        });

        function initColor() {
            $d.initAutoComplete('#'+input_color, $vitex_globales.g_cat_color_alfabetico, null, function (item, ui, _this) {
                if (empty(item)) {
                    return $(_this).val('').notify("El color no existe", { position:'right', className: 'error' }).focus();
                }
                // setTimeout(function () {$('#quantity').focus().select();}, 0);
                $(_this).removeClass('input-required');
            }, 0, 'label', false, '', false, null, true, 0, true, false);
        }
    }

    jQuery(function($){
        containerCalc.productDataRead();
        piDateCheck();
        fechaPasadoResalta();
        pedido.set_bodega_eta_es();
        $("#bodega_eta_viewdate").on("change", function() {
            $("#bodega_eta_es").val('Capturada');
            pedido.set_bodega_eta_es();
        } );
    });

</script>

