// noinspection JSUnusedGlobalSymbols
// 2025-07-02
const editablePrefixes = ["fob_", "usd_", "synch_", "factory2_"];
const editableFields = editablePrefixes.length;
function editmode(element, modo) {
    if(element.checked) {
        confirmHoyUpdate(`<h1>${modo} ${costs.label}</h1>Seleccione:<ul><li>Editar sin cambiar la fecha<div>o</div></li><li>Nuevos a partir de Hoy</ul>`,
            `${modo}  ${costs.label} ¿a partir de hoy o sin cambiar la fecha?`, true)
            .done(function(hoy_misma){
                if(hoy_misma === "hoy")
                    $("#editmodedate").html( `<b>${modo}</b> Costos <b>NUEVOS</b> a partir de <b>Hoy</b>`).data("modo", modo).data("fecha", "hoy").show();
                else
                    $("#editmodedate").html(`<b>${modo} Corrigiendo</b> costos desde su captura`).data("modo", modo).data("fecha", "misma").show();
                $("#editMode").html(modo);
                costs.modo = modo;
                $("#editmodeFieldset").remove();
                $("#synchmodeFieldset").remove();
                $("#editModeButtons").show();
                $(".syncbutton").css({visibility:"visible"});
                $(".costRW").prop("contenteditable", true);
            })
            .fail(function(){
                document.getElementById("editmode").checked = false;
                document.getElementById("synchmode").checked = false;
            });
    } else {
        $(".costRW").prop("contenteditable", false);
        $("#editmodedate").html("Modo consulta").hide();
    }
}


function confirmHoyUpdate(message, title, html) {
    var defer = $.Deferred();
    $('<div/>')
        .html(html===true ? message : message.replace(/</g,'&lt; '))
        .dialog({
            autoOpen:true,
            resizable:true,
            draggable:true,
            modal:true,
            closeOnEscape:true,
            width:'auto',
            height:'auto',
            title: title==null ? 'Por favor, confirma:' : title,
            buttons: [
                {text:'Arreglarlos SIN CAMBIAR la fecha',icon:'ui-icon-pencil',
                    click:function(e){
                        e.target.disabled = true;
                        if(!defer.isResolved && !defer.isRejected)
                            defer.resolve("arreglar");
                        $(this).dialog("close");
                    }
                },
                {text:'Nuevos a partir de Hoy',icon:'ui-icon-check',
                    click:function(e){
                        e.target.disabled = true;
                        if(!defer.isResolved && !defer.isRejected)
                            defer.resolve("hoy");
                        $(this).dialog("close");
                    }
                },
            ],
            close: function () {
                if(!defer.isResolved && !defer.isRejected)
                    defer.reject();
                $(this).dialog('destroy').remove();
            }
        });
    return defer.promise();
}

const costs = {
    version: "2024-03-15",
    url: "",
    synch_url: "",
    page: "",
    label: "",
    modo: "",
    autoNumId: {},
    autoNumRO: [],
    autoNumRW: [],
    scrollBlur: true, // @EMULAR
    lastClickedTr: null,

    saveDefaults: function(element, name) {
      $(element).hide("implode").show("explode");
      $.ajax({
          url: '../backoffice/ajax/user_json_data_acciones.php',
          method: 'POST',
          dataType: 'json',
          data:  {
              accion: "guarda",
              tema: "productos_costs",
              descripcion: "default settings",
              name: name,
          }
      })
      $.ajax({
          url: '../backoffice/ajax/user_json_data_acciones.php',
          method: 'POST',
          dataType: 'json',
          data:  {
              accion: "guarda",
              tema: "productos_costs",
              descripcion: "default settings",
              name: name,
              data: {
                      viewExistencia: document.getElementById("viewExistencia").checked ? "1" : "",
                      productNameGSM: document.getElementById("productNameGSM").checked ? "1" : "",
                      columnWH: document.getElementById("columnWH").checked ? "1" : "",
                      columnGSM: document.getElementById("columnGSM").checked ? "1" : "",
                      columnUnit: document.getElementById("columnUnit").checked ? "1" : "",
                      columnFOB: document.getElementById("columnFOB").checked ? "1" : "",
                      columnFactory2: document.getElementById("columnFactory2").checked ? "1" : "",
                      columnLoadingCapacity: document.getElementById("columnLoadingCapacity").checked ? "1" : "",
                  },
          },
      })
      .done(function(data, textStatus, jqXHR) {
          if(!data.status) {
              ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
              console.log("ajax status wrong: " + this.url, data);
          }
          costs.templateSaved();
      })
      .fail(function(jqXHR, textStatus, errorThrown) {
          try {
              if(typeof jqXHR.responseJSON === 'object') {
                  ia.alertError(jqXHR.responseJSON.message || "Error inesperado, intente más tarde.", "Error");
              } else
                  ia.alertError(`Error inesperado, intente más tarde.<div>${textStatus}</div><div>${errorThrown}</div>`, "Error", true);
              console.log("Ajax error:", this);
          } catch(error) {
              console.log("ajax.fail message failed", error)
          }
          console.log('    ajax.fail: ' + this.url, arguments);
      });
    },
    dialog_overwrite: function(accion) {
        let html = ''; // confirm = '';
        if('report2china' === accion) {
            html = `
            <div style="padding:1em">¿Copy CIF costs from <span style="color:darkmagenta;font-weight: bold">REPORT</span> to <span style="color:#00F;font-weight: bold">CHINA</span>?</div>
            <div style="margin:auto;width:90%;text-align: center">
            <i class="fa-duotone fa-face-smile fa-3x" style="--fa-primary-color: #32026c; --fa-secondary-color: #32026c;"></i> 
            <span style="color:#F00;font-size: 2em">➠</span>
            <i class="fa-duotone fa-face-scream fa-3x" style="--fa-primary-color: #0000ff; --fa-primary-opacity: 0.4; --fa-secondary-color: #0000ff; --fa-secondary-opacity: 1;"></i>
            </div>`;
            // confirm = "Confirm OVERWRITE CIF CHINA with Report";
        } else if('china2report' === accion) {
            html = `
            <div style="padding:1em">¿Copy CIF costs from <span style="color:#00F;font-weight: bold">CHINA</span> to <span style="color:darkmagenta;font-weight: bold">REPORT</span>?</div>
            <div style="margin:auto;width:90%;text-align: center">
            <i class="fa-duotone fa-face-smile fa-3x" style="--fa-primary-color: #0000ff; --fa-primary-opacity: 0.4; --fa-secondary-color: #0000ff; --fa-secondary-opacity: 1;"></i>
            <span style="color:#F00;font-size: 2em">➠</span>
            <i class="fa-duotone fa-face-scream fa-3x" style="--fa-primary-color: #32026c; --fa-secondary-color: #32026c;"></i>
            </div>`;
            // confirm = "Confirm OVERWRITE CIF REPORT with China"
        }
        if(html.length === 0) {
            ia.alertError("Acción inválida: " + accion);
        }
    },

    overwrite_china: function() {
        ia.confirm(`
            <div style="padding:1em">¿Copy CIF costs from <span style="color:darkmagenta;font-weight: bold">REPORT</span> to <span style="color:#00F;font-weight: bold">CHINA</span>?</div>
            <div style="margin:auto;width:90%;text-align: center">
            <i class="fa-duotone fa-face-smile fa-3x" style="--fa-primary-color: #32026c; --fa-secondary-color: #32026c;"></i> 
            <span style="color:#F00;font-size: 2em">➠</span>
            <i class="fa-duotone fa-face-scream fa-3x" style="--fa-primary-color: #0000ff; --fa-primary-opacity: 0.4; --fa-secondary-color: #0000ff; --fa-secondary-opacity: 1;"></i>
            </div>`,
            "CONFIRM OVERWRITE CIF CHINA with REPORT", true, true)
            .done(function(){
                $(".buttonOverrides").prop("disabled", true);
                $.ajax({
                    url: '../backoffice/ajax/productos_costs_acciones.php',
                    method: 'POST',
                    dataType: 'json',
                    data: {accion:"report2china"},
                })
                .done(function(data, textStatus, jqXHR) {
                    if(!data.status) {
                        ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                        console.log("ajax status wrong: " + this.url, data);
                        return;
                    }
                    window.location.reload();
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    try {
                        if(typeof jqXHR.responseJSON === 'object') {
                            ia.alertError(jqXHR.responseJSON.message || "Error inesperado, intente más tarde.", "Error");
                        } else
                            ia.alertError(`Error inesperado, intente más tarde.<div>${textStatus}</div><div>${errorThrown}</div>`, "Error", true);
                        console.log("Ajax error:", this);
                    } catch(error) {
                        console.log("ajax.fail message failed", error)
                    }
                    console.log('    ajax.fail: ' + this.url, arguments);
                });
            });
    },

    overwrite_report: function() {
        ia.confirm(`
            <div style="padding:1em">¿Copy CIF costs from <span style="color:#00F;font-weight: bold">CHINA</span> to <span style="color:darkmagenta;font-weight: bold">REPORT</span>?</div>
            <div style="margin:auto;width:90%;text-align: center">
            <i class="fa-duotone fa-face-smile fa-3x" style="--fa-primary-color: #0000ff; --fa-primary-opacity: 0.4; --fa-secondary-color: #0000ff; --fa-secondary-opacity: 1;"></i>
            <span style="color:#F00;font-size: 2em">➠</span>
            <i class="fa-duotone fa-face-scream fa-3x" style="--fa-primary-color: #32026c; --fa-secondary-color: #32026c;"></i>
            </div>`,
            "CONFIRM OVERWRITE CIF CHINA with REPORT", true, true)
            .done(function() {
                $(".buttonOverrides").prop("disabled", true);
                $.ajax({
                    url: '../backoffice/ajax/productos_costs_acciones.php',
                    method: 'POST',
                    dataType: 'json',
                    data: {accion: "china2report"},
                })
                    .done(function(data, textStatus, jqXHR) {
                        if(!data.status) {
                            ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                            console.log("ajax status wrong: " + this.url, data);
                            return;
                        }
                        window.location.reload();
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        try {
                            if(typeof jqXHR.responseJSON === 'object') {
                                ia.alertError(jqXHR.responseJSON.message || "Error inesperado, intente más tarde.", "Error");
                            } else
                                ia.alertError(`Error inesperado, intente más tarde.<div>${textStatus}</div><div>${errorThrown}</div>`, "Error", true);
                            console.log("Ajax error:", this);
                        } catch(error) {
                            console.log("ajax.fail message failed", error)
                        }
                        console.log('    ajax.fail: ' + this.url, arguments);
                    });
            });
    },

    producto_clear: function() {
        var select = $('#costs_search')[0];
        select.selectize.clear();
        select.selectize.refreshItems();
        setTimeout(function() {
            var select = $('#costs_search')[0];
            select.selectize.open();
        }, 10);
    },
    producto_changed: function(ev) {
        let productos = $("#costs_search").val();
        if(productos.length === 0) {
            costs.showAll();
            return;
        }
        costs.show(productos);
    },

    bodegaShowHide: function() {
        let open = '▼';
        let closed = '▶';
        let element = document.getElementById('showHideBodega');
        if( element.innerHTML.trim() === closed) {
            $(`TR[data-bodega]`).show();
            element.innerHTML = open + ' ';
        } else {
            $(`TR[data-bodega]`).hide();
            element.innerHTML = closed + ' ';
        }
    },

    colorShowHide: function() {
        let open = '<i class="fa-duotone fa-brush fa-rotate-180"></i>';
        let closed = '<i class="fa-duotone fa-brush fa-rotate-90"></i>';
        let element = document.getElementById('showHideColor');
        if( element.innerHTML.trim() === closed) {
            $(`TR[data-color]`).show();
            element.innerHTML = open + ' ';
        } else {
            $(`TR[data-color]`).hide();
            element.innerHTML = closed + ' ';
        }
    },

    show: function(ids) {
        if(typeof ids === 'undefined' || ids === null || (typeof ids === 'string' && ids.length === 0)) {
            costs.showAll();
            return;
        }
        // costs.hideChildren();
        $("TR[data-producto]").hide();
        if(typeof ids==='string')
            ids = [ids];
        for(let tr of ids) {
            $("#tr_" + tr).show();
            $("#tr_" + tr + "-blanco").show();
        }
    },

    showAll: function() {
        $("TR[data-producto]").show();
        // costs.hideChildren();
    },

    hideChildren: function() {
        $(".childRow").hide();
        $(".fa-brush").removeClass("fa-rotate-180").addClass("fa-rotate-90");
        $(".costExpand").each(function(){
            if(this.innerText.trim() === '▼')
                this.innerText = '▶';
        });
        $("#showHideBodega").text('▶');
    },

    porBodega: function(element, pid) {
        if(element.innerHTML.trim() === '▶') {
            $(`TR[data-parentbodega='tr_${pid}']`).show();
            element.innerHTML = '▼ ';
        } else {
            $(`TR[data-parentbodega='tr_${pid}']`).hide();
            element.innerHTML = '▶ ';
        }
    },

    porColor: function(element, pid) {
        let open = '<i class="fa-duotone fa-brush fa-rotate-180"></i>';
        let closed = '<i class="fa-duotone fa-brush fa-rotate-90"></i>';
        if(element.innerHTML.trim() === closed) {
            $(`TR[data-parentcolor='tr_${pid}']`).show();
            element.innerHTML = open + ' ';
        } else {
            $(`TR[data-parentcolor='tr_${pid}']`).hide();
            element.innerHTML = closed + ' ';
        }
    },
    templateNeedsSave: function() {$("#savebadge").show();},
    templateSaved: function() {$("#savebadge").hide();},
    showHide: function(columnNames, do_show) {
        costs.templateNeedsSave();
        let tbl  = document.getElementById('costTable');
        let colNumbers = [];
        let colDef = document.getElementById('trCostColNames');
        let th = colDef.getElementsByTagName('th');
        for (let col_no = 0, len = th.length; col_no < len; ++col_no) {
            let name = th[col_no].dataset.colname;
            for(let c of columnNames)
                if(name === c)
                    colNumbers.push(col_no)
        }
        const displayStyle = do_show ?  "table-cell"  : 'none';
        let rows = tbl.getElementsByTagName('tr');
        for (let row = 0, len = rows.length; row < len; ++row) {
            let cels = rows[row].getElementsByTagName('td');
            if(cels.length === 0)
                cels = rows[row].getElementsByTagName('th');
            for(let col_no of colNumbers)
                cels[col_no].style.display = displayStyle;
        }
    },

    /**
     * Calcula y despliega los totales
     */
    totals:function() {
        let totales = { total_usd:0.00, total_synch:0.00, faltan:0, con_usd:0,};

        for(let a of costs.autoNumRW) {
            let id = a.domElement.id;
            let val = a.get();
            let emptyVal = isNaN(val) || val === '' || parseFloat(val) === 0.00;
            if(id.search("usd_") === 0 ) {
                if(emptyVal)
                    totales.faltan++;
                else
                    totales.con_usd++;
            }
        }

        let existencia = {};
        for(let a of costs.autoNumRO) {
            let id = a.domElement.id;
            if(id.search("total_usd") === 0) {
                totales.total_usd += Math.round(100.00 * parseFloat(a.get()) )/100.00;
                totales.total_usd = Math.round(100.00 * totales.total_usd) / 100.00;
                continue;
            }
            if(id.search("total_synch") === 0) {
                totales.total_synch += Math.round(100.00 * parseFloat(a.get()) )/100.00;
                totales.total_synch = Math.round(100.00 * totales.total_synch) / 100.00;
                continue;
            }

            if(id.search("existencia") === 0) {
                let u = "existencia-" + (document.getElementById(id).dataset.unidad || '');
                if(!existencia.hasOwnProperty(u))
                    existencia[u] = parseFloat(a.get());
                else
                    existencia[u] += parseFloat(a.get());
            }


        }

        document.getElementById('produsd').innerHTML = totales.con_usd;
        let $prodFaltan = $("#prodFaltan");
        let numproductos  = parseInt($prodFaltan.data('numproductos'));
        if(totales.con_usd === numproductos)
            document.getElementById('prodFaltan').innerHTML = "";
        else
            document.getElementById('prodFaltan').innerHTML = `<span style="color:red; font-weight: bold">Faltan ${numproductos - totales.con_usd} CIF</span>`;

        let usdTotalFormatted = costs.autoNumId['gran_total_existencia_usd'].set(totales.total_usd).getFormatted();
        document.getElementById('gran_total_existencia_usd').innerText =
            costs.autoNumId['gran_total_existencia_usd'].set(totales.total_usd).getFormatted();
        for(let d of document.querySelectorAll("TH[data-totalusd]"))
            d.innerHTML = usdTotalFormatted;

        let synch_usdTotalFormatted = costs.autoNumId['gran_total_existencia_usd'].set(totales.total_usd).getFormatted();
        document.getElementById('gran_total_existencia_usd').innerText =
            costs.autoNumId['gran_total_existencia_usd'].set(totales.total_usd).getFormatted();
        for(let d of document.querySelectorAll("TH[data-totalusd]"))
            d.innerHTML = usdTotalFormatted;

        let tcActual = parseFloat( costs.autoNumId['tcActual'].get() );
        document.getElementById('actualmxp').innerText =
            costs.autoNumId['actualmxp'].set(totales.total_usd * tcActual).getFormatted();
        let tcManual = parseFloat( costs.autoNumId['tcManual'].get() );
        document.getElementById('manualmxp').innerText =
            costs.autoNumId['manualmxp'].set(totales.total_usd * tcManual).getFormatted();


    },

    ymd: function (date = new Date()) {
        const year = date.toLocaleString('default', {year: 'numeric'});
        const month = date.toLocaleString('default', {
            month: '2-digit',
        });
        const day = date.toLocaleString('default', {day: '2-digit'});
        return [year, month, day].join('-');
    },

    read: function() {
        let data = [];
        $(".td_cif").each(function(){
            if(this.id.search("usd_") === 0) {
                let producto_general_id = this.id.substring(4);
                if(producto_general_id.length === 32 || producto_general_id.length === 39 || true) {
                    data.push({
                        producto_general_id,
                        cost_cif: costs.autoNumId[this.id].get(),
                        fob: costs.autoNumId[`fob_${producto_general_id}`]?.get() ?? "0.00",
                        factory_2: document.getElementById(`factory2_${producto_general_id}`) ?.innerText.trim() ?? "",
                        fecha: $(`#desde_${producto_general_id}`).text().trim()
                    });
                } else alert("hmmm producto_general_id.length=" + producto_general_id.length + " es " + producto_general_id);
            }
        });
        return data;
    },

    readSynch: function() {
        let data = [];
        $(".costNumRW").each(function(){
            if(this.id.search("synch_") === 0) {
                let producto_general_id = this.id.substring(6);
                //if(producto_general_id.length === 32)
                    data.push({
                        producto_general_id,
                        cost_cif: costs.autoNumId[this.id].get(),
                        fecha: $(`#synch_desde_${producto_general_id}`).text().trim()
                    });
            }
        });
        return data;
    },

    guarda: function() {
        $(".costRW").prop("contenteditable", false);
        $("#editModeButtons").hide();
        $.ajax({
            url: costs.url,
            method: 'POST',
            processData: true,
            dataType: 'json',
            data: {accion:'save', modo:costs.modo, datos: costs.read() },
        })
        .done(function(data) {
            $(".costRW").prop("contenteditable", true);
            $("#editModeButtons").show();
            if(!data.status) {
                ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                console.log("ajax status wrong: " + this.url, data);
                return;
            }
            $(".saved").removeClass("saved");
            iaFormDirty = false;
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
            $(".costRW").prop("contenteditable", true);
            $("#editModeButtons").show();
        });
        $.ajax({
            url: costs.synch_url,
            method: 'POST',
            processData: true,
            dataType: 'json',
            data: {accion:'save', modo:costs.modo, datos: costs.readSynch() },
        }).fail(function(jqXHR, textStatus, errorThrown) {
            ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
            console.log('ajax failed: ' + this.url, arguments);
            $(".costRW").prop("contenteditable", true);
            $("#editModeButtons").show();
        });
    },

    forceEdit:function(id, producto_general_id) {
        let $element = $(`#${id}`);
        iaFormDirty = true;
        $element.addClass("saved");
        if (id.startsWith('fob_') || id.startsWith('factory2_')) {
            return; // Don't update dates for FOB, factory2_
        }
        let fecha = $("#editmodedate").data("fecha");
        if(fecha === 'hoy') {
            if(id.indexOf("sy") === 0)
                $(`#synch_desde_${producto_general_id}`).text(dateUtils.todayYMD());
            else
                $(`#desde_${producto_general_id}`).text(dateUtils.todayYMD());
        }
    },

    /**
     *  editar aceptado ponloe en el elemento
     */
    editDone:function(producto_general_id) {
        costs.checkSynch(producto_general_id); // doubleInputZ
        let $element = $(`#usd_${producto_general_id}`);
        if($element.length === 0 || parseFloat( $element.attr('value') ) ==  costs.autoNumId[`usd_${producto_general_id}`].get())
            return;
        iaFormDirty = true;
        $element.addClass("saved");
        let fecha = $("#editmodedate").data("fecha");
        if(fecha === 'hoy')
            $(`#desde_${producto_general_id}`).text(dateUtils.todayYMD());
    },
    checkSynch: function(producto_general_id) { // doubleInputZ toda la function
        let $element = $(`#synch_${producto_general_id}`);
        if($element.length === 0 ||  parseFloat( $element.attr('value') ) ==  costs.autoNumId[`synch_${producto_general_id}`].get())
            return;
        iaFormDirty = true;
        $element.addClass("saved");
        let fecha = $("#editmodedate").data("fecha");
        if(fecha === 'hoy')
            $(`#synch_desde_${producto_general_id}`).text(dateUtils.todayYMD()); // doubleInputZ @TODO otra col fecha desde
    },
    init: function() {
        costs.autoNumRO = AutoNumeric.multiple(".costNumRO" , // http://autonumeric.org/configurator
            {
                decimalPlaces: "2",
                roundingMethod: "A",
                maximumValue: "999999999",
                minimumValue: "-999999999",
                // readOnly: AutoNumeric.options.readOnly.readOnly,
                // formulaMode: AutoNumeric.options.formulaMode.disabled,
                // valuesToStrings: AutoNumeric.options.valuesToStrings.zeroDash,
                emptyInputBehavior: "zero",
                watchExternalChanges: AutoNumeric.options.watchExternalChanges.watch,
                unformatOnSubmit: AutoNumeric.options.unformatOnSubmit.unformat,
            }
        );
        for(let a of costs.autoNumRO)
            costs.autoNumId[a.domElement.id] = a;

        let tcManual = AutoNumeric.multiple(".costsTC",
            {
                decimalPlaces: "6",
                roundingMethod: "A",
                maximumValue: "999.999999",
                minimumValue: AutoNumeric.options.minimumValue.zero,
                // readOnly: AutoNumeric.options.readOnly.readOnly,
                formulaMode: true,
                modifyValueOnWheel:false,
                modifyValueOnUpDownArrow:false,
                emptyInputBehavior: "zero",
                // valuesToStrings: AutoNumeric.options.valuesToStrings.zeroDash,
                watchExternalChanges: AutoNumeric.options.watchExternalChanges.watch,
                unformatOnSubmit: AutoNumeric.options.unformatOnSubmit.unformat,
            }
        );
        for(let a of tcManual)
            costs.autoNumId[a.domElement.id] = a;
        costs.autoNumRW = AutoNumeric.multiple(".costNumRW" ,
            {
                decimalPlaces: "3",
                roundingMethod: "A",
                maximumValue: "9999.999",
                minimumValue: AutoNumeric.options.minimumValue.zero,
                // readOnly: AutoNumeric.options.readOnly.readOnly,
                formulaMode: true,
                modifyValueOnWheel:false,
                modifyValueOnUpDownArrow:false,
                emptyInputBehavior: "zero",
                // valuesToStrings: AutoNumeric.options.valuesToStrings.zeroDash,
                watchExternalChanges: AutoNumeric.options.watchExternalChanges.watch,
                unformatOnSubmit: AutoNumeric.options.unformatOnSubmit.unformat,
            }
        );
        for(let a of costs.autoNumRW)
            costs.autoNumId[a.domElement.id] = a;
        costs.gInputs = document.querySelectorAll("TD[contenteditable]");
        costs.gInputsArray = [...costs.gInputs];

        var tbody = document.getElementById("tb");
        tbody.addEventListener("keydown", function(event) {
            const current = event.target;
            if (!current || !current.id) return;

            const idMatch = current.id.match(/^(fob_|usd_|synch_)(.+)$/);
            if (!idMatch) return;

            const prefix = idMatch[1];
            const rowId = idMatch[2];
            const colIndex = editablePrefixes.indexOf(prefix);
            if (colIndex === -1) return;

            const getCell = (col, row) => document.getElementById(editablePrefixes[col] + row);

            let nextCell = null;

            if ([ "ArrowDown", "ArrowUp"].includes(event.key)) { // "Enter",
                event.preventDefault();

                const direction = (event.key === "ArrowUp" || event.shiftKey) ? -1 : 1;
                const rows = Array.from(tbody.querySelectorAll("tr[id^='tr_']"));
                const currentRowIndex = rows.findIndex(tr => tr.id === "tr_" + rowId);
                const newRow = rows[currentRowIndex + direction];
                if (newRow) {
                    const newRowId = newRow.id.replace(/^tr_/, "");
                    nextCell = getCell(colIndex, newRowId);
                }
            }

            if (event.key === "Tab" || event.key === "Enter") {
                event.preventDefault();

                let newCol = colIndex + (event.shiftKey ? -1 : 1);
                let newRowId = rowId;

                const rows = Array.from(tbody.querySelectorAll("tr[id^='tr_']"));
                const currentRowIndex = rows.findIndex(tr => tr.id === "tr_" + rowId);

                if (newCol >= editableFields) {
                    newCol = 0;
                    newRowId = rows[currentRowIndex + 1]?.id.replace(/^tr_/, "") || rowId;
                } else if (newCol < 0) {
                    newCol = editableFields - 1;
                    newRowId = rows[currentRowIndex - 1]?.id.replace(/^tr_/, "") || rowId;
                }

                nextCell = getCell(newCol, newRowId);
            }

            if (nextCell) {
                nextCell.focus();
                const offset = nextCell.offsetTop - current.offsetTop;
                window.scrollBy(0, offset);
            }
        });



        $(".costRW")
            .on('focus', function(){
                this.parentElement.style.outline = "thin solid #0000FF";
            })
            .on('input',function(event){
                this.parentElement.style.outline = "";
                let parts = this.id.split('_'),
                    producto_general_id = parts[1];
                $(this).css({"outline-color": 'blue'}).prop("title", "Cambiado");
                costs.forceEdit(this.id, producto_general_id, this);
            })
            .on('blur', function(event) {
                // quita el remarca renglon actual en edición @EMULAR
                this.parentElement.style.outline = "";
                let id = this.id,
                    parts = id.split('_'),
                    producto_general_id = parts[1];

                costs.editDone(producto_general_id, this);
                if(id.startsWith("fob") || id.startsWith("factory2"))
                    return;

                let cost = costs.autoNumId[id].get();
                if(id.startsWith("synch_")) {
                    costs.autoNumId[`total_${id}`].set(cost * costs.autoNumId[`existencia_${producto_general_id}`].get());
                    let tot = 0.00;
                    for(let a of costs.autoNumRO) {
                        if(a.domElement.id.search("total_synch_") === 0) {
                            tot += parseFloat(a.get());
                            tot = Math.round(100.00 * tot) / 100.00;
                        }
                    }
                    costs.autoNumId['gran_total_synch_existencia_usd'].set(tot);
                    $("#gran_total_synch_existencia_usd").text(costs.autoNumId["gran_total_synch_existencia_usd"].getFormatted())
                    costs.totals();
                    $('#costTable').trigger("updateCache");
                    return
                }

                costs.autoNumId[`total_${id}`].set(cost * costs.autoNumId[`existencia_${producto_general_id}`].get());

                $(`TR[data-parent="tr_${producto_general_id}"]`).each(function(){
                    let $tr = $(this);
                    costs.autoNumId[`${$tr.data("id")}_total_${parts[0]}_${producto_general_id}`].set(cost * $tr.data("quantity"));
                });

                let totales = {total_usd:0.00, faltan:0};
                for(let a of costs.autoNumRW) {
                    let id = a.domElement.id;
                    if(id.search("usd_") === 0 &&  parseFloat(a.get()) === 0)
                        totales.faltan++;
                }
                for(let a of costs.autoNumRO) {
                    if(id.search("total_usd_") === 0) {
                        totales.total_usd += parseFloat(a.get());
                        totales.total_usd = Math.round(100.00 * totales.total_usd) / 100.00;
                    }
                }

                costs.autoNumId['gran_total_existencia_usd'].set(totales.total_usd);

                costs.totals();
                $('#costTable').trigger("updateCache");
            })
        ;

       // costs.showHide(['total_usd_china',], false);
        $("#tcManual").on("change", costs.totals);
        $("#costTable").tablesorter({
            sortList: [[0,0]],
            theme: 'blue',
            ignoreCase: true,
            cssChildRow: "childRow",
            showProcessing : true,
            textExtraction: {
                // Column index as key (0-based)
                0: function(node, table, cellIndex) {
                    let value = node.textContent;
                    return value.replace(/▶/g, '').trim();
                }
            }
        });
        $("TR[data-producto]").on("click", function() {
            if(costs.lastClickedTr !== null)
                costs.lastClickedTr.css({'outline':''});
            costs.lastClickedTr =  $(this).css({'outline':'1px solid blue'})
        });
        costs.totals();
        $("#costs_search").off('change', costs.producto_changed).on('change', costs.producto_changed);
    },

    cifHistDialog() {
        let $cifHistDialog = $("#cifHistDialog");
        if($cifHistDialog.length) {
            $cifHistDialog.remove();
            return;
        }
        $(".fondocontenedor").css({display:"none"});
        $("<div id='cifHistDialog' style='display:block'><div id='cifHistContent'>... Loading ...<h1><i class='fa-duotone fa-hourglass-end fa-spin'></i></h1></div></div>").dialog({
            title: `${costs.label} Cost Log`,
            closeOnEscape: true,
            width: window.innerWidth -90,
            height: window.innerHeight,
            open: function() {
                $.ajax({
                    url:  costs.url,
                    method: 'POST',
                    cache: false,
                    processData: true,
                    dataType: 'json',
                    data: {accion:'cifLog'},
                })
                .done(function(data) {
                    if(!data.status) {
                        ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                        console.log("ajax status wrong: " + this.url, data);
                        return;
                    }
                    $("#cifHistContent").html(data.html); //.prepend(exporter.toolBar('#cifHistTable'));
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                    console.log('ajax failed: ' + this.url, arguments);
                });
            },
            close: function() {$(this).remove(); $(".fondocontenedor").css({display:""}); },
        });
    },

    synchCifHistDialog() {
        let $cifHistDialog = $("#cifHistDialog");
        if($cifHistDialog.length) {
            $cifHistDialog.remove();
            return;
        }
        $(".fondocontenedor").css({display:"none"});
        $("<div id='cifHistDialog' style='display:block'><div id='cifHistContent'>... Loading ...<h1><i class='fa-duotone fa-hourglass-end fa-spin'></i></h1></div></div>").dialog({
            title: `${costs.label} Cost Log`,
            closeOnEscape: true,
            width: window.innerWidth -90,
            height: window.innerHeight,
            open: function() {
                $.ajax({
                    url:  costs.synch_url,
                    method: 'POST',
                    cache: false,
                    processData: true,
                    dataType: 'json',
                    data: {accion:'cifLog'},
                })
                    .done(function(data) {
                        if(!data.status) {
                            ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                            console.log("ajax status wrong: " + this.url, data);
                            return;
                        }
                        $("#cifHistContent").html(data.html); //.prepend(exporter.toolBar('#cifHistTable'));
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                        console.log('ajax failed: ' + this.url, arguments);
                    });
            },
            close: function() {$(this).remove(); $(".fondocontenedor").css({display:""}); },
        });
    }
}


window.onbeforeunload = function () {
    if(iaFormDirty) {
        iaFormDirty = false;
        return "¡Hay datos sin guardar!";
    }
};

function handleDragStart(e) {
    this.style.opacity = '0.4';
    e.dataTransfer.effectAllowed = 'move';
}

function handleDragEnd(e) {
    this.style.opacity = '1';
}
function handleDrop(e) {
    e.stopPropagation(); // stops the browser from redirecting.
    return true
}


function histRows(tbodyId) {
    const table = document.getElementById(tbodyId);
    const rows = Array.from(table.getElementsByTagName("tr"));
    const rowData = rows.map(row => {
        return row.dataset.producto.replace(/\s+/g, ' ').trim().normalize('NFD').toUpperCase();
    });
    return [rows, rowData];
}
function filterTable(theIndex, searchInputId) {
    console.log("filterTable", arguments);
    const rows = theIndex[0];
    const rowData = theIndex[1];
    const input = document.getElementById(searchInputId);
    const filter = input.value.replace(/\s+/g, ' ').trim().normalize('NFD').toUpperCase();
    rows.forEach((row, index) => {
        row.style.display = rowData[index].indexOf(filter) > -1 ? "" : "none";
    });
}

if (document.readyState === 'complete') {
    costs.init();
    editmode(document.getElementById('editmode'));
} else {
    window.addEventListener('load', function() {
        costs.init();
        editmode(document.getElementById('editmode'))
    });
}
