<?php
require_once("../inc/config.php");

// fixes luego quitar
  // ia_query("update pedido set mostrar_en_ventas = 'Si' where mostrar_en_ventas NOT IN ('Si', 'No')");
  //  ia_query("update pedido set activo='Si' where activo NOT IN ('Si', 'No')");
  //  ia_query("update pedido set mostrar_en_ventas='No' where activo = 'No'");
  //  app_pedido::marcaNonUniques();

global $gAppRelate;
$f=new app_pedido();
$f->process_action();
$f->redirect();
$f->toolbar_set();

$queryEstados = "SELECT * FROM estado_bodega WHERE origen = 'CHINA' AND activo = 'SI' ORDER BY orden";
$estados = json_encode(ia_sqlArrayIndx($queryEstados));

$query= "SELECT id_clave_busqueda FROM estado_bodega WHERE origen = 'CHINA' AND activo = 'SI'  order by CAST(id_clave_busqueda AS UNSIGNED);";
$estadosClaveBusqueda = ia_sqlArrayIndx($query);
$array_claves = [];
foreach($estadosClaveBusqueda as $key => $value){
    $array_claves[] = $value['id_clave_busqueda'];
}

$array_claves = json_encode($array_claves);


?><!DOCTYPE html>
<html lang="es">
<head>
    <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=utf-8">
    <title><?php echo $f->labeled(); ?></title>
    <script>

    var Obj_Estados={
        estadosBodega: <?php echo  $estados ?>,
        estadosClaveBusqueda: <?php echo  $array_claves ?>,
        tipo:'China'
    }

    Object.freeze(Obj_Estados);

    var g_bandera_stados=false;

    </script>
    <?php
        global $gIaHeader;
        $gIaHeader->html_head_add( array('estado_filter','cambia_estado' ));
        $gIaHeader->html_head_echo();
    ?>
    <script>
        jQuery(function($){
            containerCalc.productData = <?php echo json_encode( ia_sqlArray(
            "SELECT pg.producto_general_id, RTRIM(CONCAT(pg.producto, ' ', pg.gsm)) as 'producto', u.unidad, 
                pg.container_quantity, pg.gsm,  pg.width, pg.composition
                FROM producto_general pg JOIN unidades u ON u.unidades_id=pg.unidades_id
                WHERE pg.activo = 'Si' AND pg.para_bodega='En Bodega' ORDER BY 1", "producto_general_id") ); ?>;
            containerCalc.weight_per_m = <?php echo json_encode(
          ia_sqlKeyValue(
            "SELECT pg.producto_general_id, pg.weight_per_m 
                    FROM producto_general pg JOIN unidades u ON u.unidades_id=pg.unidades_id
                    WHERE u.unidad <> 'Kg'"
          )); ?>
        });
    </script>
    <link rel="stylesheet" href="../css2/bodega/nota.css">
    <style>
        <?php
            require_once("../backoffice/StylerGetStyle.php");
            foreach (StylerGetStyle::getAllStyles() as $style) {
                echo $style['json_styles'];
            }
            unset($style);
        ?>
        .attacheDrag {
            background-color: lightyellow;
            cursor:grabbing;
        }
        TD.rollos {text-align: right;}
        TD.quantity {text-align: right;}
        .ui-jqgrid tr.footrow td {
            font-weight: bold;
            overflow: hidden;
            white-space: nowrap;
            height: 21px;
            padding: 0 2px 0 2px;
            border-top-width: 1px;
            border-top-color: inherit;
            border-top-style: solid;
            color: #001c00;
            background: linear-gradient(var(--entrada_bodega), #dbffdb, var(--entrada_bodega))!important;
            font-size: 1em;
        }
        .ui-search-toolbar{
            height: 69px !important;
        }
        .mr-2px{
            margin-right: 2px;
        }

    </style>
    <style>
        @media print {
            .noprint {display:none}
            .noPrint {display:none}
            .printOnly {display:initial}
            .printonly {display:initial}
            .jqgrid_actions {display:none}
            .iactoolbar {display:none}
            #jqg_alrt {display:none}
            #alertmod_iajqgridpedido {display:none}
            .ui-jqgrid-htable {background-color: transparent!important;}
            .ui-search-toolbar {display:none}
            BODY {background-color: transparent!important;}
            TABLE, FIGURE {
                page-break-inside: avoid;
            }
            INPUT {
                border:none!important;
                background-color: inherit;
                color:inherit;
            }
            SELECT {
                appearance: none;
                border:none;
                background-color: transparent;
                color:inherit;
            }
            BUTTON {display:none}
        }

    </style>
    <script>
        function pedido_doSumasGrid(iasumCols) {

            //funcion para colocar que la informacion del footer sea la correcta
            
            comprobandoTotales.metodos.comprobando(iasumCols, gridhandler)
            let { estadosClaveBusqueda, estadosBodega }=Obj_Estados
            if(!g_bandera_stados){
                let estadosProducto= new EstadoBodega($('#gs_estado_p'),
                gridhandler,estadosBodega, estadosClaveBusqueda,
                $('#gsh_iajqgridpedido_estado_p'),
                'CHINA',
                $('#iajqgridpedido_estado_p')
                );

                g_bandera_stados=true;
            }

            if(typeof iasumCols === 'undefined' || iasumCols.length === 0) {
                doSumasGridSolamente(false);
                return false;
            }

            let ventas = {
                rn: parseInt(iasumCols.rn || 0),
                quantity: parseFloat(iasumCols.suma_quantity || 0.00),
                rollos: parseInt(iasumCols.suma_rollos || 0),
                eta: 'Muestra en ventas',
            };
            let clientes = {
                rn: parseInt(iasumCols.rn_usd || 0),
                quantity: parseFloat(iasumCols.suma_quantity_usd || 0.00),
                rollos: parseInt(iasumCols.suma_rollos_usd || 0),
                eta: 'Oculta en ventas',
            };
            let totales = {
                rn: ventas.rn + clientes.rn,
                quantity: ventas.quantity + clientes.quantity,
                rollos: ventas.rollos + clientes.rollos,
                eta: 'Total'
            };

            $("#tfootTotals").remove();
            $("#tfootClientes").remove();
            let footerTable =  $(".ui-jqgrid-ftable", $("#gview_" + gridhandler.attr('id') ));
            let footerTR = footerTable.children("TBODY").children("TR").first();

            gridhandler.jqGrid('footerData', 'set', totales);
            $totalesRow = footerTR.clone();
            $totalesRow.attr('id', 'tfootTotals');

            gridhandler.jqGrid('footerData', 'set', clientes);
            let $clientesRow = footerTR.clone();
            $clientesRow.attr('id', 'tfootClientes');

            gridhandler.jqGrid('footerData', 'set', ventas);

            footerTable.children("TBODY").append($clientesRow);
            footerTable.children("TBODY").append($totalesRow);
            if(window.opener === null || typeof window.opener.plsHearMe !== 'function')
                return;
            return;
            let tell = {}

           
            tell['pedido_china'] = {
                    iasumCols: iasumCols,
                    totales: totales,
                    totalesRow: $totalesRow,
                    clientes: clientes,
                    clientesRow: $clientesRow,
                    ventas: ventas,
                    ventasRow: gridhandler.jqGrid('footerData', 'get'),
                    footerData: gridhandler.jqGrid('footerData', 'get'),
            }

            console.log("tell", tell);
            window.opener.plsHearMe(tell);

        }
        doSumasGrid = pedido_doSumasGrid;
        

        
    </script>
    <script src="../js2/tinymce5/tinymce.min.js" defer="defer"></script><style>.mce-path {display: none !important;}</style><script>var iacBaseDir="vitex";</script>
    <link rel="stylesheet" href="../js2/spectrum/spectrum.css">
    <script src="../js2/spectrum/spectrum.js"></script>
    <?php require_once __DIR__."/../backoffice/view/component/commons/styler_widget.php"; ?>
</head>
<body>
<div id="loadingMask" style="width: 100%; height: 100%; position: fixed; background: #fff; z-index: 999; font-size: 1.5em; font-weight: bolder; padding-top: 4em;"></div>
<?php
include('../backoffice/header.php');
$h=param('h',param('iah'));
echo $f->form_tag(tag:'');
$f->display_toolbar();
echo '<div style="margin-top:2px;">';
$f->process();
?>
</form>
<?php
if(Permisador::puede_consultar_permisos() !== 'Nada')
    echo '<script>jQuery(function() { permisador.ponPermiso(); });</script>';
?>

<?php

if($h === 'e' || $h === 'r') {
    $h = new HistTable('pedido_hist');
    $h->addIgnoreFields(['rollos_entrada', 'quantity_entrada']) // en estos no muestra diferencia
        ->addChildsReKey(['items' => ['producto_general_id','color_id']]) // si no viene con unique key comparable
        ->addFueErrorFields([]) // ie [{fue_error:'No', id:1,label:'gato'},]
        ->addJsonArrayFields([]) // ie [{id:1,label:'gato'},]
        ->addJsonObjectFields(['nota_bodega']) // ie {id:1,label:'gato'}
        ->addChildsOnly([
            'items' => ['producto_general_id', 'color_id', 'quantity',  'rollos'], // si se pone producto_general_id y unidades_id la calcula aunque no venga
            'nota_bodega' => ['notas']
        ]);
    //$diff =  $h->getDiferences($f->id); //echo "<pre class='code'>" . print_r($diff, true) . "</pre>";
    echo "<details class='default' style='margin:1em;width:fit-content'><summary>History Log</summary><div>" .
        $h->getDiferencesTable($f->id) .
        "</div></details>";
}
?>
<script>
    const laTabla = {

        init: function () {
            $("SPAN.laTabla_collapseExpand").off('click', laTabla.collapseExpand).one('click', laTabla.collapseExpand);
            $("SPAN.laTabla_collapseAll").off('click', laTabla.collapseAll).one('click', laTabla.collapseAll);
            $("SPAN.laTabla_expandAll").off('click', laTabla.expandAll).one('click', laTabla.expandAll);

            console.log("laTabla.init");
        },

        clickOff: function ($el, $table) {
            $el.css('cursor', 'wait').css({'background-color':'whitesmoke'});
            $("BODY").css('cursor', 'wait');
            $("SPAN.laTabla_collapseExpand", $table).off('click', laTabla.collapseExpand);
            $("SPAN.laTabla_collapseAll").off('click', laTabla.collapseAll);
            $("SPAN.laTabla_expandAll").off('click', laTabla.expandAll);
        },

        clickOn: function ($el, $table) {
            $("SPAN.laTabla_collapseExpand", $table).off('click', laTabla.collapseExpand).one('click', laTabla.collapseExpand);
            $("SPAN.laTabla_collapseAll").off('click', laTabla.collapseAll).one('click', laTabla.collapseAll);
            $("SPAN.laTabla_expandAll").off('click', laTabla.expandAll).one('click', laTabla.expandAll);
            $("BODY").css('cursor', '');
            $el.css('cursor', '').css({'background-color':''});
        },

        pdf: function(el) {
            let $el = $(el);
            let $table = $el.parents("TABLE").first();

            let era = $table.html();
            $table.html(era.replaceAll(/[⮛➣𝚫∃]/g,''));
            exporter.pdf_table($table);
            $table.html(era);
            laTabla.init();
        },

        print:function(el) {
            let $el = $(el);
            let $table = $el.parents("TABLE").first();
            exporter.print($table);
        },

        collapseExpand: function (ev) {
            let $el = $(ev.target);
            let $table = $el.parents("TABLE").first();
            laTabla.clickOff($el, $table);
            let grupo = $el.data('latabla_grupo');
            if ($el.html() === '➣') {
                $(`TR[data-latabla_grupo="${grupo}"]`, $table).show();
                $el.html('⮛');
            } else {
                $(`TR[data-latabla_grupo="${grupo}"]`, $table).hide();
                $el.html('➣');
            }
            laTabla.clickOn($el, $table);
        },

        collapseAll: function (ev) {
            let $el = $(ev.target);
            let $table = $el.parents("TABLE").first();
            laTabla.clickOff($el, $table);
            $("SPAN.laTabla_collapseExpand", $table).html('➣');
            $(`TR[data-latabla_grupo]`, $table).hide();
            laTabla.clickOn($el, $table);
        },

        expandAll: function (ev) {
            let $el = $(ev.target);
            let $table = $el.parents("TABLE").first();
            laTabla.clickOff($el, $table);
            $("SPAN.laTabla_collapseExpand", $table).html('⮛');
            $(`TR[data-latabla_grupo]`, $table).show();
            laTabla.clickOn($el, $table);
        },

    }
    Object.freeze(laTabla);
</script>
<script>
    jQuery(function($){
        //laTabla.init(); inicializa expanded
        laTabla.collapseAll({target:$("SPAN.laTabla_collapseAll", $("#tablaDiff"))}); // inicializa collapsed
        $("#tablaDiffToolbar").append(exporter.toolBar("#tablaDiff"));
    });
</script>
<script>
    const attache = {
        init:function(el) {
           // let el = document.getElementById(id);
            window.addEventListener("dragover",function(e){
                e = e || event;
                e.preventDefault();
            },false);
            window.addEventListener("drop",function(e){
                e = e || event;
                e.preventDefault();
            },false);
            ['drag', 'dragstart', 'dragenter', 'dragover', 'dragleave', 'dragend', 'drop'].forEach(eventName => {
                el.addEventListener(eventName, attache._preventDefaults, false);
            });
            ['dragenter', 'dragover'].forEach(eventName => {
                el.addEventListener(eventName, attache._draggingMark, false);
            });
            ['dragleave', 'dragend', 'drop'].forEach(eventName => {
                el.addEventListener(eventName, attache._draggingUnMark, false)
            });
            el.addEventListener('dragEnd', attache._dragEnd, false)
            el.addEventListener('dragOver', attache._dragOver, false)
            el.addEventListener('drop', attache._drop, false)
        },
        _preventDefaults:function(e) {
            e.preventDefault();
            e.stopPropagation();
        },
        _draggingMark:function(e) {
            $(e.target).parent().addClass('attacheDrag');
        },
        _draggingUnMark:function(e) {
           $(e.target).parent().removeClass('attacheDrag');
        },
        _dragOver: function(ev) {
            ev.preventDefault();
            console.log('File(s) in drop zone', e);
        },
        _dragEnd: function(ev) {
            ev.preventDefault();
            $(".attacheDrag").removeClass('attacheDrag');
        },
        _drop:function(e) {
            let dt = e.dataTransfer;
            let files = dt.files;
            for(let f of files) {
                console.log("a file", f);
            }
            $(".attacheDrag").removeClass('attacheDrag');
            console.log("files", files);
        },
        uploadFiles:function() {
            var files = document.getElementById('file_upload').files;
            if(files.length===0){
                alert("Please first choose or drop any file(s)...");
                return;
            }
            var filenames="";
            for(var i=0;i<files.length;i++){
                filenames+=files[i].name+"\n";
            }
    }
    }


    Object.freeze(attache)

    jQuery(function($){
        $(".div_attache").each(function(){attache.init(this)});
    });
</script>
<?php if(usuarioTipoRony()) { ?>
<script>
    $('.btn_tooltip').tooltip();

    const pedidoChinaReset = {
        init: function() {
            $("#pch_activate_si").off('click',pedidoChinaReset.pch_activate_si).one('click',pedidoChinaReset.pch_activate_si);
            $("#pch_activate_no").off('click',pedidoChinaReset.pch_delete).one('click',pedidoChinaReset.pch_activate_no);
            $("#pch_inactivate").off('click',pedidoChinaReset.pch_inactivate).one('click',pedidoChinaReset.pch_inactivate);
            $("#pch_del_inactivate").off('click',pedidoChinaReset.pch_delete).one('click',pedidoChinaReset.pch_del_inactivate);
            $('#pch_states').on('click',pedidoChinaReset.pch_state);
            $('#pch_states_select').on('click',pedidoChinaReset.pch_state_select);
            $("#pch_delete").off('click',pedidoChinaReset.pch_delete).one('click',pedidoChinaReset.pch_delete);
            $("#pcConfirm").remove();
        },
        off: function() {
            $("#pch_activate_si").off('click',pedidoChinaReset.pch_activate_si);
            $("#pch_activate_no").off('click',pedidoChinaReset.pch_activate_no);
            $("#pch_inactivate").off('click',pedidoChinaReset.pch_inactivate);
            $("#pch_del_inactivate").off('click',pedidoChinaReset.pch_del_inactivate);
            $("#pch_delete").off('click',pedidoChinaReset.pch_delete);
        },
        cuales:function() {
            let ret = {
                id:[],
                n:[]
            }
            let data = gridhandler.jqGrid('getRowData');
            for(let d of data) {
                if (d.iacsel === 'Yes') {
                    ret.id.push(d.pedido_id);
                    ret.n.push(d.numero);
                }
            }
            return ret;
        },
        _pch_selected_do: function(accion, message, title, conSelected) {
            pedidoChinaReset.off();
            let data = pedidoChinaReset.cuales();
            if(conSelected && data.n.length === 0) {
                ia.alertWarn("Seleccione al menos un pedido");
                pedidoChinaReset.init();
                return;
            }
            data.accion = accion;
            let promise = ia.confirm(message + (conSelected ? data.n.join(", ") : ''), title, true, false, 'pcConfirm');
            promise.done(function(){
                $.ajax({
                    url:'../backoffice/ajax/pedido_acciones.php',
                    method:'GET',
                    data:data,
                    cache:false,
                    dataType:'json',
                })
                    .done(function(data, textStatus, jqXHR) {
                        ia.alertInfo("Done", "Done");
                        location.reload();

                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        ia.alertError(textStatus, textStatus);
                        console.log("pedidoChinaReset ERROR", arguments)
                        pedidoChinaReset.init();
                    });

            });
            promise.fail(function() {
                pedidoChinaReset.init();
            });
        },

        pch_state: function () {
        $('.ui-dialog-titlebar-close:visible').trigger('click');
        $("#confirmar_reset_state").remove();
        $("BODY").append(
            `<div id='confirmar_reset_state' class='jqgridcolssorter_dialog'>
            <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0px 12px 20px 0;"></span>¿Seguro que quiere borrar <span style="color:red; font-weight: bold; text-transform: uppercase;">todos</span> los estados de <span style="color:red; font-weight: bold; text-transform: uppercase;">todos los registros</span>?</p></div>
            </div>`
        );

        $("#confirmar_reset_state").dialog({
                    title: "LIMPIA ESTADOS",
                    resizable: false,
                    height: "auto",
                    width: 400,
                    buttons: [
                        {
                            text: "Confirmar",
                            icon: "ui-icon-check", // Clase de icono de jQuery UI
                            click: function() {
                                // Acción a realizar si el usuario confirma
                                pedidoChinaReset.reseteandoState('China');
                            }
                        },
                        {
                            text: "Cancelar",
                            icon: "ui-icon-closethick", // Clase de icono de jQuery UI
                            click: function() {
                                $(this).dialog("close");
                            }
                        }
                    ]
                });
        },
        pch_state_select: function () {
            let row_visible= $('tr.ui-row-ltr:visible .grid_table', gridhandler);
            let data_cells= [];
            row_visible.each(function(){
                let filaId = $(this).data('id'); // Obtener el ID de la fila
                data_cells.push(filaId);
            });

            data_cells= data_cells.join(',');

           $('.ui-dialog-titlebar-close:visible').trigger('click');
            $("#confirmar_reset_select").remove();
            $("BODY").append(
                `<div id='confirmar_reset_select' class='jqgridcolssorter_dialog'>
                <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0px 12px 20px 0;"></span>¿Seguro que quiere borrar <span style="color:red; font-weight: bold; text-transform: uppercase;">todos</span> los estados <span style="color:red; font-weight: bold; text-transform: uppercase;">visibles</span> ?</p></div>`
            );

            $("#confirmar_reset_select").dialog({
                        title: "LIMPIA ESTADOS VISIBLES",
                        resizable: false,
                        height: "auto",
                        width: 400,
                        buttons: [
                            {
                                text: "Confirmar",
                                icon: "ui-icon-check", // Clase de icono de jQuery UI
                                click: function() {
                                    // Acción a realizar si el usuario confirma
                                    pedidoChinaReset.reseteandoStateSelect(data_cells);
                                }
                            },
                            {
                                text: "Cancelar",
                                icon: "ui-icon-closethick", // Clase de icono de jQuery UI
                                click: function() {
                                    $(this).dialog("close");
                                }
                            }
                        ]
                    });
        },
        reseteandoState: function(tipo){
            $.ajax({
            url: '../backoffice/ajax/ResetState.php',
            method: 'POST',
            cache: false,
            data: {accion:'resetChina'},
            dataType: 'json',
            })
            .done(function(data, textStatus, jqXHR) {
                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax failed url:", this.url);
                    return;
                }
                gridhandler.trigger("reloadGrid");
                $("#confirmar_reset_state").dialog("close");

            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                console.log('ajax failed: ' + this.url, arguments);
            });
        },
        reseteandoStateSelect: function(ids){

            $.ajax({
            url: '../backoffice/ajax/ResetState.php',
            method: 'POST',
            cache: false,
            data: {accion:'resetChinaSelect', ids},
            dataType: 'json',
            })
            .done(function(data, textStatus, jqXHR) {
                if(!data.status) {
                    ia.alertError(data.message || "Error inesperado, intente más tarde.", "Error");
                    console.log("ajax failed url:", this.url);
                    return;
                }

                gridhandler.trigger("reloadGrid");
                $("#confirmar_reset_select").dialog("close");

            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                ia.alertError(`Problemas al comunicarme con el server: <ul><lI>${errorThrown}<li>${textStatus}</ul>`, "Error", true);
                console.log('ajax failed: ' + this.url, arguments);
            });
        },
        pch_activate_si: function() {
            pedidoChinaReset._pch_selected_do(
                "pch_activateSi",
                "Confirm: Activar Mostrando en ventas los pedidos: ",
                "Activar, confirme",
                true
            );
        },
        pch_activate_no: function() {
            pedidoChinaReset._pch_selected_do(
                "pch_activateNo",
                "Confirm: Activa SIN mostrar en ventas los pedidos: ",
                "Activar, confirme",
                true
            );
        },
        pch_inactivate: function() {
            pedidoChinaReset._pch_selected_do(
                "pch_inactivate",
                "Confirm: INACTIVATE los pedios: ",
                "Inactivar, confirme",
                true
            );
        },
        pch_delete: function() {
            pedidoChinaReset._pch_selected_do(
                "pch_delete",
                "<span style='color:red'>Confirm: ☠ DELETE SELECTED ☠ <br>Borrar los pedidos: ",
                "☠ DELETE SELECTED ☠",
                true);
        },
        pch_del_inactivate:function() {
            pedidoChinaReset._pch_selected_do(
                "pch_delete",
                "<span style='color:red'>Confirm: ☠ DELETE INACTIVE ☠</span>",
                "☠ DELETE INACTIVE",
                false
            );
        },

    }
    Object.freeze(pedidoChinaReset)
</script>
<?php } ?>
<?php
include_once("../backoffice/view/component/commons/containerCalc.php");
global $gVersionesExtraFiles;
$gVersionesExtraFiles[] = './componentes/form_pedido.php';
include('../backoffice/footer.php');
?>
<script> $(document).ready( function() { $('#loadingMask').fadeOut(0); _app='pedido_china'}); </script>
</body>
</html>