<?php
  die();
  /* clon de productos_costs.php con otra tabla */
require_once('../inc/config.php');
$permisos = (new ProductoGeneralUtil())->permisos();
if(!$permisos['costos_report_editar'] && !$permisos['costos_report_ver']) {
    require_once('../backoffice/sin_permiso.php');
    die();
}

$f = new iacase_base();
$f->permiso_app = $f->permiso_list = $f->permiso_read = false;
$f->permiso_insert = $f->permiso_delete = $f->permiso_update = $f->permiso_export = false;
$f->table = $f->label = 'COST WH REPORT CIF (WAREHOUSE).';
$f->toolbar_set();

$productoCostsBodega = new ProductoCostsBodegaReport();
// $productoCostsBodega->fixMe();

?><!DOCTYPE html>
<html lang="es-MX">
<head>
    <meta charset="UTF-8">
    <title>WH CIF</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <?php
    global $gIaHeader;
    $gIaHeader->html_head_add( array( 'jqgrid', 'ia' ));
    $gIaHeader->html_head_echo();
    ?>
    <link href="componentes/productos_costs.css" rel="stylesheet"  type="text/css"/>
    <link href="componentes/productos_costs_wh.css" rel="stylesheet"  type="text/css"/>

    <?php
        require_once("../backoffice/StylerGetStyle.php");
        echo "\r\n<style>";
        foreach(StylerGetStyle::getAllStyles() as $tempStyles)
            echo "\r\n$tempStyles[json_styles]";
        echo "\r\n</style>\r\n";
    ?>
    <script src="componentes/productos_costs.js?pi=3.141592"></script>
    <script>
        costs.url = '../backoffice/ajax/productos_costs_report_acciones.php';
        costs.synch_url = '../backoffice/ajax/productos_costs_acciones.php';
        costs.page = "productos_costs_report";
        costs.label = "WH CIF";
    </script>
    <script src="../js2/dateUtils.js"></script>
    <script src="../js2/autoNumeric-next.js"></script>
    <link rel="stylesheet" href="../js2/tablesorter-master/dist/css/theme.blue.min.css">
    <script src="../js2/tablesorter-master/dist/js/jquery.tablesorter.combined.min.js"></script>
</head>
<body>
<?php
$f->display_toolbar();
$productosCostsBodegaReport = new ProductoCostsBodegaReport();
echo "<div class='toolbar'>
    <div class='fondocontenedor' style='margin: .6em auto; padding: 0.1em; width: 84%;'>"
    . $productosCostsBodegaReport->inputTable(
        "CIF REPORT",
        $permisos,
        $permisos['costos_report_editar'] ? "true" : "false",
        getProductCostsQuery(),
        ProductoCostsBodegaReport::getOtherCif()
  ) .
  "</div></div>";

function getProductCostsQuery() {
    $method = __FUNCTION__;
    $blanco = ia_sqlArray(
      "SELECT /*$method*/ pb.producto_general_id, 
                SUM(IFNULL(pb.existencia_rollos, 0)) as 'existencia_rollos',
                SUM(IFNULL(pb.existencia_quantity, 0.00)) as 'existencia_quantity'
            FROM producto_bodega pb
            WHERE pb.color_id = '54bf6469e2cc850b11ec1c8e8e9a60a2'
            GROUP BY pb.producto_general_id
     ",
      "producto_general_id"
    );
    $productosExistencia = <<< SQL
        SELECT /*$method*/ pg.producto_general_id, CONCAT(pg.producto, ' <span class="gsm_producto">', gsm, '</span>') AS 'producto', u.unidad,
               pg.gsm, pg.container_quantity,pg.cost_variant,
           SUM(IFNULL(pb.existencia_rollos, 0)) as 'existencia_rollos',
           SUM(IFNULL(pb.existencia_quantity, 0.00)) as 'existencia_quantity'
        FROM producto_general pg
            JOIN unidades u ON pg.unidades_id = u.unidades_id
            LEFT JOIN producto_bodega pb ON pg.producto_general_id = pb.producto_general_id
        WHERE pg.activo = 'Si' AND pg.para_cif = 'Visible' 
        GROUP BY 1,2,3,4,5,6
        ORDER BY 2
    SQL;
    $productosCIF = <<< SQL2
        SELECT /*$method*/ pg.producto_general_id,
            pcb.cost_cif,
            pcb.cost_cif_blanco,
            pcb.fob,
            pcb.fob_blanco,
            IFNULL(pcb.factory_2,'') AS factory_2,
            IFNULL(pcb.factory_2_blanco,'') AS factory_2_blanco,
            0 AS total_cif,
            pcb.fecha AS desde,
            pcb.fecha_blanco AS desde_blanco
        FROM producto_general pg
                JOIN producto_costs_bodega_report pcb ON pg.producto_general_id = pcb.producto_general_id AND pcb.fecha_fin IS NULL
        WHERE pg.activo = 'Si' AND pg.para_cif = 'Visible' 
        ORDER BY pg.producto
SQL2;

    $return = [];
    $cif = ia_sqlArray($productosCIF,'producto_general_id');
    $productos = ia_sqlArray($productosExistencia, 'producto_general_id');

    foreach($productos as $producto_general_id => $p) {
        $costs = $cif[$producto_general_id] ?? [];
        if($p['cost_variant'] === 'Diferentes') {
            $rollos = $blanco[$producto_general_id]["existencia_rollos"] ?? "0";
            $quantity = $blanco[$producto_general_id]["existencia_quantity"] ?? "1.00";
            $return[$producto_general_id."-blanco"] = [
              "producto_general_id" => $producto_general_id."-blanco",
              "producto" => $p['producto'] . " <b style='color:#00F'>BLANCO</b>",
              "unidad" => $p['unidad'],
              "gsm" => $p['gsm'],
              "container_quantity" => $p['container_quantity'],
              "cost_variant" => $p['cost_variant'],
              "existencia_rollos" =>  $rollos,
              "existencia_quantity" => $quantity,
              "cost_cif" => $costs['cost_cif_blanco'] ?? "0.00",
              "fob" => $costs['fob_blanco'] ?? "0.00",
              "factory_2" => $costs['factory_2_blanco'] ?? "",
              "desde" => $costs['desde_blanco'] ?? "",
              "total_cif" => 0,
            ];
            $p['producto'] .= " <span style='color:#00F'>Teñido</span>";
            $p["existencia_rollos"] = bcsub($p['existencia_rollos'], $rollos, 0);
            $p["existencia_quantity"] = bcsub($p['existencia_quantity'], $quantity, 2);
        }
        unset($costs['cost_cif_blanco'], $costs['fob_blanco'], $costs['factory_2_blanco'], $costs['desde_blanco']);
        if(empty($costs))
            $return[$producto_general_id] = $p;
        else
            $return[$producto_general_id] = [...$p, ...$costs];

    }
    global $gDime;
    $gDime["productos"] = $productos;
    $gDime["cif"] = $cif;
    $gDime["return"] = $return;
    return $return;
    return array_replace_recursive(
      ia_sqlArray($productosExistencia, 'producto_general_id'),
      ia_sqlArray($productosCIF,'producto_general_id')
    );
}

function getProductCostsQueryOld() {
    $method = __FUNCTION__;
    return <<< SQL
WITH nums AS ( /*$method*/
    SELECT 
           pg.producto_general_id,pg.producto AS producto_sort,
           CONCAT(pg.producto, ' <span class="gsm_producto">', gsm, '</span>') AS 'producto', CONCAT(pg.producto, ' ', gsm) as producto_bare,
           u.unidad,
           IFNULL(pcb.cost_cif, 0.00) as cost_cif,
           pcb.fecha as Since,
           IFNULL(pb.existencia_rollos, 0.00) as existencia_rollos,
           IFNULL(pb.existencia_quantity, 0.00) as existencia_quantity,
           IFNULL( IF(pg.container_quantity = 0, 0.00, CONVERT(pb.existencia_quantity / pg.container_quantity, DECIMAL(16,2))), 0.00) AS Containers,
           IFNULL( CONVERT(pb.existencia_quantity * IFNULL(pcb.cost_cif, 0.00), DECIMAL(16,2)), 0.00) AS total_cif,
           pg.gsm, pg.container_quantity
    FROM producto_general pg 
        JOIN unidades u ON u.unidades_id = pg.unidades_id
            LEFT OUTER JOIN producto_bodega pb ON pg.producto_general_id = pb.producto_general_id        
            LEFT OUTER JOIN producto_costs_bodega_report pcb
                     ON pcb.producto_general_id = pg.producto_general_id AND pcb.fecha_fin IS NULL
    WHERE pg.activo = 'Si' AND pg.para_cif = 'Visible'
)
SELECT
    nums.producto_general_id, nums.producto, nums.unidad, nums.Since as desde, nums.cost_cif,
    SUM(nums.existencia_rollos) as existencia_rollos,
    SUM(nums.existencia_quantity) as existencia_quantity,
    SUM(nums.Containers) as existencia_containers,
    SUM(nums.total_cif) as total_cif,
    nums.gsm, nums.container_quantity
FROM nums
GROUP BY nums.producto_general_id, nums.producto, nums.unidad, nums.Since, nums.cost_cif,nums.gsm, nums.container_quantity
ORDER BY nums.producto_sort
SQL;
}
?>
<?php
if(Permisador::puede_consultar_permisos() !== 'Nada')
    echo '<script>jQuery(function() { permisador.ponPermiso(); });</script>';
?>

<?php include('../backoffice/footer.php'); ?>
</body>
</html>