# Ari Ben - CFDI Invoice Management System

## System Overview

**Ari Ben** is a Mexican tax compliance system for managing CFDI invoices (Comprobantes Fiscales Digitales por Internet). CFDI is the mandatory electronic invoicing system required by the Mexican Tax Authority (SAT - Servicio de Administración Tributaria).

This system tracks issued invoices (CFDIs emitidos), their SAT status, payment information, tax breakdowns, and all metadata required for Mexican tax compliance.

## Business Domain

**Mexican Tax Compliance / Electronic Invoicing / Accounting**

This system manages:
- Issued CFDI invoices (Comprobantes emitidos)
- SAT status tracking
- Invoice relationships and cancellations
- Tax breakdowns (IVA 16%, IVA 8%, ISR, IEPS, ISH)
- Payment tracking and methods
- Tax use codes (UsoCFDI)
- Fiscal regimes
- Currency and exchange rates

## App Files (Model Layer)

### System-Specific Files
Located in `/app/`:

- **`app_eleyeme_cfdi_emitidos.php`** - Issued CFDI invoice model
  - Table: `eleyeme_cfdi_emitidos`
  - Primary key: `eleyeme_cfdi_emitido_id` (UUID)
  - 50+ fields covering all SAT-required invoice metadata
  - Features: Quick search, comprehensive tax tracking

### Framework Files (Shared with ALL Systems)
These files are part of the iaCase framework and are used by ALL systems in Quantix:

- `app_iac_usr.php` - User management
- `app_iac_log.php` - Activity logging
- `app_iac_field_permission.php` - Field-level permissions
- `app_iac_table.php` - Table metadata
- `app_iac_parametros.php` - System parameters
- And all other `app_iac_*.php` files...

Additional shared utility files:
- `app_estilos_grid.php` - Grid styling
- `app_vitex_grid.php`, `app_vitex_grid_col.php` - Grid configurations
- `app_reportes_grid.php` - Report grids
- `app_cp_sat_codigo_postal.php`, `app_cp_sat_estado.php` - SAT postal code catalogs
- And more...

## Backoffice Pages (UI Layer)

Located in `/backoffice/`:

- **`eleyeme_cfdi_emitidos.php`** - CFDI issued invoices management
  - List all issued CFDIs in jqGrid
  - Add/Edit/Delete/View operations
  - Quick search functionality
  - Export capabilities (Excel, CSV, PDF)
  - Filter by SAT status, date, client, amount

## AJAX Endpoints

Located in `/backoffice/ajax/`:

Standard jqGrid AJAX endpoints handle data loading. No custom AJAX files identified for this system - uses framework defaults.

## Database Tables

### Primary Tables:

- **`eleyeme_cfdi_emitidos`** - Issued CFDI invoices
  - UUID primary key: `eleyeme_cfdi_emitido_id`

  **SAT Compliance Fields:**
  - `Estado_SAT` - SAT status (Valid, Cancelled, etc.)
  - `TipoComprobante` - Invoice type (I=Ingreso, E=Egreso, P=Pago, T=Traslado)
  - `UUID` - Fiscal Folio (unique identifier from SAT)
  - `Serie` - Invoice series
  - `Folio` - Invoice folio number
  - `TipoRelacion` - Relationship type (for related invoices)
  - `UUID_Relacion` - Related invoice UUID

  **Date/Time Fields:**
  - `Fecha_Emision` - Issue date
  - `Fecha_Timbrado` - Timestamp date (when SAT certified it)
  - `FechaPago` - Payment date

  **Issuer (Emisor):**
  - `RFC_Emisor` - Issuer's RFC (tax ID)
  - `Nombre_Emisor` - Issuer's business name
  - `LugarDeExpedicion` - Place of issue (postal code)

  **Recipient (Receptor):**
  - `RFC_Receptor` - Recipient's RFC (tax ID)
  - `Nombre_Receptor` - Recipient's business name
  - `UsoCFDI` - Tax use code (G01, G03, P01, etc.)
  - `RegimenFiscalReceptor` - Recipient's fiscal regime
  - `DomicilioFiscalReceptor` - Recipient's fiscal address

  **Financial Data:**
  - `SubTotal` - Subtotal before taxes
  - `Descuento` - Discount amount
  - `Total` - Total amount
  - `Moneda` - Currency (MXN, USD, EUR, etc.)
  - `Tipo_De_Cambio` - Exchange rate

  **Tax Breakdown:**
  - `IVA_16` - 16% VAT amount
  - `IVA_8` - 8% VAT amount (border region)
  - `Base_16` - Tax base for 16% VAT
  - `Base_8` - Tax base for 8% VAT
  - `Base_0` - Tax base for 0% VAT
  - `Exento` - Tax-exempt amount
  - `Base_no_objeto` - Non-taxable amount
  - `Retenido_IVA` - Withheld VAT
  - `Retenido_ISR` - Withheld income tax (ISR)
  - `Total_IEPS` - Special tax on production and services
  - `ISH` - Hospitality tax

  **Payment Information:**
  - `FormaDePago` - Payment method code (01=Cash, 03=Transfer, 04=Credit card, etc.)
  - `MetodoDePago` - Payment type (PUE=One payment, PPD=Partial payments)
  - `EstadoPago` - Payment status
  - `Cobrado` - Collected amount

  **Additional Info:**
  - `Tipo` - Transaction type
  - `Conceptos` - Invoice line items/concepts
  - `Complemento` - Additional complements (payments, etc.)
  - `Comprobacion` - Verification info
  - `Mes_cobro` - Collection month
  - `REP` - Additional reference
  - `Estado_de_Cuenta` - Account statement reference
  - `Tipo_de_ingreso` - Type of income

  **Audit Fields:**
  - `alta_db` - Creation timestamp
  - `alta_por` - Created by user
  - `ultimo_cambio` - Last modification timestamp
  - `ultimo_cambio_por` - Last modified by user

### SAT Catalog Tables (Shared):
- `cp_sat_codigo_postal` - SAT postal code catalog
- `cp_sat_estado` - SAT state catalog

### Framework Tables (Shared):
All systems share these iaCase framework tables:
- `iac_usr`, `iac_log`, `iac_table`, `iac_field_permission`, `iac_parametros`, etc.

## Key Features

### 1. CFDI Lifecycle Management
- **Issue**: Create new CFDI invoices
- **Stamp**: Integration with PAC (Proveedor Autorizado de Certificación) for SAT stamping
- **Track**: Monitor SAT status
- **Cancel**: Handle invoice cancellations with relationships
- **Query**: Verify invoice status with SAT

### 2. SAT Compliance
- **UUID tracking**: Fiscal folio from SAT
- **Status monitoring**: Valid, Cancelled, Pending, etc.
- **Relationship tracking**: Cancelled invoices linked to replacement invoices
- **Timestamp verification**: Timbrado date from PAC
- **Series and folios**: Sequential numbering control

### 3. Tax Calculation & Breakdown
Comprehensive tax tracking:
- **IVA (VAT)**: 16% (general rate) and 8% (border region)
- **Tax bases**: Separate tracking for each rate (16%, 8%, 0%, exempt, no objeto)
- **Withholdings**: ISR (income tax) and IVA withholdings
- **IEPS**: Special production/services tax
- **ISH**: Hospitality tax
- **Automatic calculations**: Framework can validate tax math

### 4. Multi-Party Management
- **Issuer (Emisor)**: Your company's data
  - RFC, business name, place of issue
- **Recipient (Receptor)**: Client's data
  - RFC, business name, tax use code, fiscal regime, fiscal address

### 5. Payment Tracking
- **Payment methods**: Cash, transfer, credit card, check, etc. (SAT catalog codes)
- **Payment types**:
  - PUE (Pago en Una Sola Exhibición) - Single payment
  - PPD (Pago en Parcialidades o Diferido) - Partial/deferred payments
- **Collection status**: Track which invoices have been paid
- **Collection month**: For accounting period tracking

### 6. Multi-Currency Support
- Currency codes (MXN, USD, EUR, etc.)
- Exchange rates (Tipo_De_Cambio)
- Automatic conversion tracking

### 7. Search & Reporting
- Quick search enabled
- Filter by:
  - SAT status
  - Date ranges (emission, stamp, payment)
  - Client (RFC or name)
  - Amount ranges
  - Invoice series/folio
  - UUID
- Export to Excel, CSV, PDF
- Tax report generation

### 8. Audit Trail
- Creation timestamp and user (alta_db, alta_por)
- Last modification timestamp and user (ultimo_cambio, ultimo_cambio_por)
- Full activity logging through iaCase framework
- Immutability tracking (SAT-stamped invoices shouldn't be edited)

## Technical Architecture

### Framework Integration
This system is built on the **iaCase framework**, which means:

- **Auto-generated UI**: Forms and grids automatically created from database schema
- **CRUD operations**: Insert/Update/Delete handled by framework
- **Validation**: Type checking, required fields, length limits all automatic
- **Permissions**: User-based, table-based, and field-based permissions
- **Logging**: All actions automatically logged
- **jqGrid integration**: Data tables with sorting, filtering, paging

### Display Mode
- Uses `cardex_window` mode (forms open in new window)
- Permissions: Full edit, delete, export, insert, list, read, update
- Quick search enabled with automatic filters
- Complex form with 50+ fields organized logically

### CFDI Workflow Integration
Typical integration points:
1. **Invoice creation** in system
2. **XML generation** (CFDI 3.3 or 4.0 format)
3. **PAC stamping** (external service for SAT certification)
4. **UUID reception** from PAC
5. **Database update** with stamp data
6. **PDF generation** for customer
7. **Email delivery** to client

## File Organization

```
/lamp/www/quantix/
├── app/
│   ├── app_eleyeme_cfdi_emitidos.php    ← ARI BEN MODEL
│   ├── app_cp_sat_codigo_postal.php     ← SAT POSTAL CODES (shared)
│   ├── app_cp_sat_estado.php            ← SAT STATES (shared)
│   ├── app_iac_*.php                    ← SHARED FRAMEWORK FILES
│   └── [other shared utility files]
├── backoffice/
│   └── eleyeme_cfdi_emitidos.php        ← ARI BEN UI
├── inc/                                  ← SHARED FRAMEWORK CORE
│   ├── iacase.php                       ← Core CRUD engine
│   ├── config.php                       ← Entry point
│   ├── ia_utilerias.php                 ← Database utilities
│   └── [other framework files]
└── [database]
    ├── eleyeme_cfdi_emitidos            ← ARI BEN TABLE
    ├── cp_sat_codigo_postal             ← SAT CATALOG (shared)
    └── cp_sat_estado                    ← SAT CATALOG (shared)
```

## How It Works

### User Flow:
1. User navigates to `/backoffice/eleyeme_cfdi_emitidos.php`
2. Page loads `app_eleyeme_cfdi_emitidos` class
3. Class calls `process_action()` to handle URL parameter `?iah=`
   - `iah=l` or empty = List (jqGrid) - All invoices
   - `iah=a` = Add form - Create new CFDI
   - `iah=e` = Edit form - Modify invoice (pre-stamp only!)
   - `iah=r` = Read-only view - View invoice details
   - `iah=s` = Save (insert or update)
   - `iah=d` = Delete (typically disabled for stamped invoices)
4. Framework auto-generates HTML forms and jqGrid from database schema
5. JavaScript provides additional interactivity

### CFDI Stamping Flow:
1. Create invoice record in database
2. Fill all required SAT fields
3. Generate XML in CFDI format (3.3 or 4.0)
4. Send XML to PAC for stamping
5. PAC validates and sends to SAT
6. SAT returns UUID and timestamp
7. PAC returns stamped XML with UUID
8. Update database record with:
   - UUID
   - Fecha_Timbrado
   - Estado_SAT = "Vigente" (Valid)
9. Generate PDF with UUID and QR code
10. Deliver to client

### Cancellation Flow:
1. Create new cancellation record
2. Set `TipoRelacion` to cancellation type (01, 02, etc.)
3. Set `UUID_Relacion` to original invoice UUID
4. Submit cancellation to SAT via PAC
5. Update original invoice `Estado_SAT` to "Cancelado"
6. If replacement invoice, create new invoice with relationship

## Common Operations

### Creating a CFDI Invoice:
1. Navigate to Eleyeme CFDI Emitidos page
2. Click "Add" button
3. Fill in required fields:
   - **Type**: Ingreso (most common)
   - **Issuer**: Your company's RFC and name
   - **Recipient**: Client's RFC, name, UsoCFDI, regime
   - **Dates**: Issue date (today)
   - **Concepts**: Line items (products/services)
   - **Amounts**: Subtotal, taxes, discounts, total
   - **Tax breakdown**: IVA amounts and bases
   - **Payment**: Method and type (PUE or PPD)
4. Save
5. Generate XML
6. Send to PAC for stamping
7. Update record with UUID and timestamp

### Querying Invoice Status:
1. Open invoice in View mode
2. Check `Estado_SAT` field
3. Possible statuses:
   - "Vigente" = Valid (active)
   - "Cancelado" = Cancelled
   - Other PAC-specific statuses

### Filtering Invoices by Period:
1. Open Eleyeme CFDI Emitidos grid
2. Use date filter on `Fecha_Emision`
3. Select date range (e.g., January 2025)
4. View filtered results
5. Export for tax reporting

### Calculating Tax Totals:
1. Filter invoices by period
2. Export to Excel
3. Sum columns:
   - `IVA_16` for total 16% VAT collected
   - `IVA_8` for total 8% VAT collected
   - `Retenido_IVA` for total VAT withheld
   - `Retenido_ISR` for total ISR withheld
4. Use for monthly/annual tax declarations

## Integration Points

### With Framework:
- Uses `iacase_base` parent class for all CRUD
- Leverages `appRelate` for schema metadata
- Respects `iac_field_permission` for field visibility
- Logs to `iac_log` automatically
- Uses SAT catalog tables for postal codes and states

### With External Systems:
- **PAC (Proveedor Autorizado de Certificación)**: For SAT stamping
  - Send XML for stamping
  - Receive UUID and certified XML
  - Query invoice status
  - Submit cancellations
- **SAT Web Services**: For status verification
- **Accounting software**: Export for integration
- **Email system**: Send invoices to clients
- **PDF generator**: Create printable invoices

### With Other Quantix Systems:
- Shares user authentication (iac_usr)
- Shares permission system
- Shares audit logging
- Independent business logic from other systems

## Maintenance Notes

### Do NOT Edit:
- `campos_default()` method - Auto-generated from database schema
- Framework files (`app_iac_*.php`, `/inc/*`)
- Stamped invoices (UUID present) - SAT compliance requires immutability

### Safe to Customize:
- `campos_final()` method - Field ordering, display groups, custom validation
- Permission settings in constructor
- Hook methods (insert_*, update_*, delete_* overrides)
- Add validation to prevent editing stamped invoices

### Database Changes:
1. Alter table in database
2. Regenerate `appRelateBase.php` from schema
3. Update `campos_final()` if field order changes
4. Clear opcache if in production
5. **WARNING**: SAT field changes may break compliance!

### SAT Catalog Updates:
- Update `cp_sat_codigo_postal` when SAT releases new postal codes
- Update `cp_sat_estado` if state codes change
- Update UsoCFDI catalogs when SAT adds new codes
- Update payment method catalogs (FormaDePago)

## Security

- **Permissions**: Controlled by `$this->permiso_*` properties
- **User type checks**: Can restrict by Rony/Power/Normal user types
- **Field-level security**: Via `iac_field_permission` table
- **SQL injection prevention**: Framework uses parameterized queries
- **Session management**: Automatic timeout and regeneration
- **Audit logging**: All changes tracked with user and timestamp
- **Fiscal immutability**: Stamped invoices should not be editable
- **RFC validation**: Validate tax IDs before stamping
- **UUID uniqueness**: Ensure no duplicate UUIDs

## SAT Compliance Notes

### CFDI Version:
This system tracks CFDI invoices. Ensure your XML generation follows either:
- **CFDI 3.3** (older standard, still valid)
- **CFDI 4.0** (current standard as of 2022)

### Required Fields:
The SAT requires these fields to be present and valid:
- RFC_Emisor, RFC_Receptor (valid RFC format)
- UUID (after stamping)
- TipoComprobante (I, E, P, or T)
- Fecha_Emision, Fecha_Timbrado
- SubTotal, Total
- FormaDePago, MetodoDePago
- UsoCFDI
- RegimenFiscalReceptor

### Tax Calculation Rules:
- **IVA 16%**: General VAT rate
- **IVA 8%**: Border region rate (specific postal codes)
- **IVA 0%**: Zero-rated (exports, specific goods)
- **Exempt**: Tax-exempt transactions
- **No objeto**: Not subject to tax
- Always verify tax math before stamping!

### Cancellation Rules:
- Can only cancel within specific timeframe
- Must provide cancellation reason (TipoRelacion)
- Client may need to accept cancellation
- Some invoice types cannot be cancelled after payment

---

**System Type:** Tax Compliance / Electronic Invoicing
**Framework:** iaCase (custom PHP CRUD framework)
**Database:** MySQL
**UI:** jqGrid + jQuery UI
**Architecture:** Model-driven auto-CRUD with declarative customization
**Compliance:** Mexican SAT CFDI 3.3 / 4.0

**Key Acronyms:**
- **CFDI**: Comprobante Fiscal Digital por Internet (Digital Tax Receipt via Internet)
- **SAT**: Servicio de Administración Tributaria (Tax Administration Service)
- **PAC**: Proveedor Autorizado de Certificación (Authorized Certification Provider)
- **RFC**: Registro Federal de Contribuyentes (Federal Taxpayer Registry)
- **IVA**: Impuesto al Valor Agregado (Value Added Tax / VAT)
- **ISR**: Impuesto Sobre la Renta (Income Tax)
- **IEPS**: Impuesto Especial sobre Producción y Servicios (Special Tax on Production and Services)
- **UUID**: Universally Unique Identifier (Fiscal Folio)

**Related Systems in Quantix:**
- Bintech Robot UP (scholarship management)
- MrW - Reporte Propietarios (property management)

All systems share the same framework core (`/inc/`) and framework tables (`iac_*`)!
